/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.utils;

import com.uber.jaeger.utils.Utils;

public class RateLimiter {
    private final double creditsPerSecond;
    private double balance;
    private long lastTick;

    public RateLimiter(double creditsPerSecond) {
        this.creditsPerSecond = creditsPerSecond;
        this.balance = creditsPerSecond;
    }

    public boolean checkCredit(double itemCost) {
        long currentTime = Utils.getNanoseconds();
        double elapsedTime = currentTime - this.lastTick;
        this.lastTick = currentTime;
        this.balance += elapsedTime / 1.0E9 * this.creditsPerSecond;
        if (this.balance > this.creditsPerSecond) {
            this.balance = this.creditsPerSecond;
        }
        if (this.balance >= itemCost) {
            this.balance -= itemCost;
            return true;
        }
        return false;
    }
}

