/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.utils;

import com.uber.jaeger.utils.RateLimiter;
import com.uber.jaeger.utils.Utils;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Utils.class})
public class RateLimiterTest {
    RateLimiter limiter;

    @Test
    public void testRateLimiterWholeNumber() {
        RateLimiter limiter = new RateLimiter(2.0);
        long currentTime = TimeUnit.MICROSECONDS.toNanos(100L);
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)currentTime);
        Assert.assertTrue((boolean)limiter.checkCredit(1.0));
        Assert.assertTrue((boolean)limiter.checkCredit(1.0));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(250L)));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(500L)));
        Assert.assertTrue((boolean)limiter.checkCredit(1.0));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(5000L)));
        Assert.assertTrue((boolean)limiter.checkCredit(1.0));
        Assert.assertTrue((boolean)limiter.checkCredit(1.0));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
        TestCase.assertFalse((boolean)limiter.checkCredit(1.0));
    }

    @Test
    public void testRateLimiterLessThanOne() {
        RateLimiter limiter = new RateLimiter(0.5);
        long currentTime = TimeUnit.MICROSECONDS.toNanos(100L);
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)currentTime);
        Assert.assertTrue((boolean)limiter.checkCredit(0.25));
        Assert.assertTrue((boolean)limiter.checkCredit(0.25));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(250L)));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(500L)));
        Assert.assertTrue((boolean)limiter.checkCredit(0.25));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
        BDDMockito.given((Object)Utils.getNanoseconds()).willReturn((Object)(currentTime += TimeUnit.MILLISECONDS.toNanos(5000L)));
        Assert.assertTrue((boolean)limiter.checkCredit(0.25));
        Assert.assertTrue((boolean)limiter.checkCredit(0.25));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
        TestCase.assertFalse((boolean)limiter.checkCredit(0.25));
    }
}

