/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.filters.jaxrs2;

import com.uber.jaeger.context.TraceContext;
import com.uber.jaeger.filters.jaxrs2.ClientRequestCarrier;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
public class ClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ClientFilter.class);
    private final Tracer tracer;
    private final TraceContext traceContext;

    public ClientFilter(Tracer tracer, TraceContext traceContext) {
        this.tracer = tracer;
        this.traceContext = traceContext;
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        try {
            Tracer.SpanBuilder clientSpanBuilder = this.tracer.buildSpan(clientRequestContext.getMethod());
            if (!this.traceContext.isEmpty()) {
                clientSpanBuilder.asChildOf((BaseSpan)this.traceContext.getCurrentSpan());
            }
            Span clientSpan = clientSpanBuilder.startManual();
            Tags.SPAN_KIND.set((BaseSpan)clientSpan, "client");
            Tags.HTTP_URL.set((BaseSpan)clientSpan, clientRequestContext.getUri().toString());
            Tags.PEER_HOSTNAME.set((BaseSpan)clientSpan, clientRequestContext.getUri().getHost());
            this.tracer.inject(clientSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new ClientRequestCarrier(clientRequestContext));
            clientRequestContext.setProperty("io.opentracing.Span", (Object)clientSpan);
        }
        catch (Exception e) {
            log.error("Client Filter Request:", (Throwable)e);
        }
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        try {
            Span clientSpan = (Span)clientRequestContext.getProperty("io.opentracing.Span");
            if (clientSpan != null) {
                Tags.HTTP_STATUS.set((BaseSpan)clientSpan, Integer.valueOf(clientResponseContext.getStatus()));
                clientSpan.finish();
            }
        }
        catch (Exception e) {
            log.error("Client Filter Response:", (Throwable)e);
        }
    }
}

