/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.filters.jaxrs2;

import com.uber.jaeger.context.TraceContext;
import com.uber.jaeger.filters.jaxrs2.ServerRequestCarrier;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ServerFilter.class);
    private final Tracer tracer;
    private final TraceContext traceContext;
    @Context
    protected ResourceInfo resourceInfo;

    public ServerFilter(Tracer tracer, TraceContext traceContext) {
        this.tracer = tracer;
        this.traceContext = traceContext;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        try {
            ServerRequestCarrier carrier;
            SpanContext spanContext;
            Tracer.SpanBuilder builder = this.tracer.buildSpan(this.getOperationName(containerRequestContext)).withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.PEER_HOSTNAME.getKey(), containerRequestContext.getUriInfo().getBaseUri().getHost()).withTag(Tags.HTTP_URL.getKey(), containerRequestContext.getUriInfo().getAbsolutePath().toString());
            MultivaluedMap headers = containerRequestContext.getHeaders();
            if (headers.containsKey((Object)"x-uber-source")) {
                builder = builder.withTag(Tags.PEER_SERVICE.getKey(), (String)headers.getFirst((Object)"x-uber-source"));
            }
            if ((spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)(carrier = new ServerRequestCarrier(containerRequestContext)))) != null) {
                builder = builder.asChildOf(spanContext);
            }
            Span serverSpan = builder.startManual();
            this.traceContext.push(serverSpan);
        }
        catch (Exception e) {
            log.error("Server Filter Request:", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        try {
            if (this.traceContext.isEmpty()) {
                return;
            }
            Span serverSpan = this.traceContext.pop();
            Tags.HTTP_STATUS.set((BaseSpan)serverSpan, Integer.valueOf(containerResponseContext.getStatus()));
            serverSpan.finish();
        }
        catch (Exception e) {
            log.error("Server Filter Response:", (Throwable)e);
        }
    }

    protected String getOperationName(ContainerRequestContext containerRequestContext) {
        return containerRequestContext.getMethod();
    }
}

