/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReplaceRequestBuilder<T extends ScimResource>
extends ResourceReturningRequestBuilder<ReplaceRequestBuilder<T>> {
    private final T resource;
    private String version;

    public ReplaceRequestBuilder(WebTarget target, T resource) {
        super(target);
        this.resource = resource;
    }

    public ReplaceRequestBuilder<T> ifMatch() {
        this.version = ReplaceRequestBuilder.getResourceVersion(this.resource);
        return this;
    }

    @Override
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    public T invoke() throws ScimException {
        return (T)((ScimResource)this.invoke(this.resource.getClass()));
    }

    public <C> C invoke(Class<C> cls) throws ScimException {
        Response response = this.buildRequest().put(Entity.entity(this.resource, (MediaType)ScimService.MEDIA_TYPE_SCIM_TYPE));
        try {
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                Object object = response.readEntity(cls);
                return (C)object;
            }
            throw ReplaceRequestBuilder.toScimException(response);
        }
        finally {
            response.close();
        }
    }
}

