/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.client.ScimServiceException;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestBuilder<T extends RequestBuilder> {
    private WebTarget target;
    protected final MultivaluedMap<String, Object> headers = new MultivaluedHashMap();
    protected final MultivaluedMap<String, Object> queryParams = new MultivaluedHashMap();

    RequestBuilder(WebTarget target) {
        this.target = target;
    }

    public T header(String name, Object ... value) {
        this.headers.addAll((Object)name, value);
        return (T)this;
    }

    public T queryParam(String name, Object ... value) {
        this.queryParams.addAll((Object)name, value);
        return (T)this;
    }

    static String getResourceVersion(ScimResource resource) throws IllegalArgumentException {
        if (resource == null || resource.getMeta() == null || resource.getMeta().getVersion() == null) {
            throw new IllegalArgumentException("Resource version must be specified by meta.version");
        }
        return resource.getMeta().getVersion();
    }

    static ScimException toScimException(Response response) {
        try {
            ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ScimException exception = ScimException.createException((ErrorResponse)errorResponse, null);
            response.close();
            return exception;
        }
        catch (ProcessingException ex) {
            return new ScimServiceException(response.getStatus(), ex.getMessage(), ex);
        }
    }

    protected WebTarget target() {
        return this.target;
    }

    WebTarget buildTarget() {
        for (Map.Entry queryParam : this.queryParams.entrySet()) {
            this.target = this.target.queryParam((String)queryParam.getKey(), ((List)queryParam.getValue()).toArray());
        }
        return this.target;
    }

    Invocation.Builder buildRequest() {
        Invocation.Builder builder = this.buildTarget().request(new MediaType[]{ScimService.MEDIA_TYPE_SCIM_TYPE, MediaType.APPLICATION_JSON_TYPE});
        for (Map.Entry header : this.headers.entrySet()) {
            builder = builder.header((String)header.getKey(), (Object)StaticUtils.listToString((List)((List)header.getValue()), (String)", "));
        }
        return builder;
    }
}

