/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.fasterxml.jackson.databind.JsonNode;
import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.utils.JsonUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifyRequestBuilder<T extends ModifyRequestBuilder<T>>
extends ResourceReturningRequestBuilder<T> {
    protected final List<PatchOperation> operations = new LinkedList<PatchOperation>();
    protected String version;

    private ModifyRequestBuilder(WebTarget target) {
        super(target);
    }

    @Override
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    public T replaceValue(String path, Object object) throws ScimException {
        return this.replaceValue(Path.fromString((String)path), object);
    }

    public T replaceValue(Path path, Object object) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)object);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    public T replaceValues(String path, Collection<Object> objects) throws ScimException {
        return this.replaceValues(Path.fromString((String)path), objects);
    }

    public T replaceValues(Path path, Collection<Object> objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode(objects);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    public T replaceValues(String path, Object ... objects) throws ScimException {
        return this.replaceValues(Path.fromString((String)path), objects);
    }

    public T replaceValues(Path path, Object ... objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)objects);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    public T addValues(String path, Collection<?> objects) throws ScimException {
        return this.addValues(Path.fromString((String)path), objects);
    }

    public T addValues(Path path, Collection<?> objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode(objects);
        return this.addOperation(PatchOperation.add((Path)path, (JsonNode)newObjectNode));
    }

    public T addValues(String path, Object ... objects) throws ScimException {
        return this.addValues(Path.fromString((String)path), objects);
    }

    public T addValues(Path path, Object ... objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)objects);
        return this.addOperation(PatchOperation.add((Path)path, (JsonNode)newObjectNode));
    }

    public T removeValues(String path) throws ScimException {
        return this.removeValues(Path.fromString((String)path));
    }

    public T removeValues(Path path) throws ScimException {
        return this.addOperation(PatchOperation.remove((Path)path));
    }

    public T addOperation(PatchOperation op) {
        this.operations.add(op);
        return (T)this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Typed
    extends ModifyRequestBuilder<Typed> {
        public Typed(WebTarget target) {
            super(target);
        }

        public Typed ifMatch(String version) {
            this.version = version;
            return this;
        }

        public <T> T invoke(Class<T> cls) throws ScimException {
            PatchRequest patchRequest = new PatchRequest(this.operations);
            Response response = this.buildRequest().method("PATCH", Entity.entity((Object)patchRequest, (String)this.getContentType()));
            try {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (T)object;
                }
                throw Typed.toScimException(response);
            }
            finally {
                response.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Generic<T extends ScimResource>
    extends ModifyRequestBuilder<Generic<T>> {
        private final T resource;

        public Generic(WebTarget target, T resource) {
            super(target);
            this.resource = resource;
        }

        public Generic<T> ifMatch() {
            this.version = Generic.getResourceVersion(this.resource);
            return this;
        }

        public T invoke() throws ScimException {
            return (T)((ScimResource)this.invoke(this.resource.getClass()));
        }

        public <C> C invoke(Class<C> cls) throws ScimException {
            PatchRequest patchRequest = new PatchRequest(this.operations);
            Response response = this.buildRequest().method("PATCH", Entity.entity((Object)patchRequest, (String)this.getContentType()));
            try {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (C)object;
                }
                throw Generic.toScimException(response);
            }
            finally {
                response.close();
            }
        }
    }
}

