/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

final class CBORCanonical {
    static final Comparator<CBORObject> Comparer = new CtapComparer();
    private static final Comparator<Map.Entry<byte[], byte[]>> ByteComparer = new CtapByteComparer();

    private CBORCanonical() {
    }

    private static boolean IsArrayOrMap(CBORObject a) {
        return a.getType() == CBORType.Array || a.getType() == CBORType.Map;
    }

    public static byte[] CtapCanonicalEncode(CBORObject a) {
        return CBORCanonical.CtapCanonicalEncode(a, 0);
    }

    private static boolean ByteArraysEqual(byte[] bytesA, byte[] bytesB) {
        if (bytesA == bytesB) {
            return true;
        }
        if (bytesA == null || bytesB == null) {
            return false;
        }
        if (bytesA.length == bytesB.length) {
            for (int j = 0; j < bytesA.length; ++j) {
                if (bytesA[j] == bytesB[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void CheckDepth(CBORObject cbor, int depth) {
        block5: {
            block4: {
                if (cbor.getType() != CBORType.Array) break block4;
                for (int i = 0; i < cbor.size(); ++i) {
                    if (depth >= 3 && CBORCanonical.IsArrayOrMap(cbor.get(i))) {
                        throw new CBORException("Nesting level too deep");
                    }
                    CBORCanonical.CheckDepth(cbor.get(i), depth + 1);
                }
                break block5;
            }
            if (cbor.getType() != CBORType.Map) break block5;
            for (CBORObject key : cbor.getKeys()) {
                if (depth >= 3 && (CBORCanonical.IsArrayOrMap(key) || CBORCanonical.IsArrayOrMap(cbor.get(key)))) {
                    throw new CBORException("Nesting level too deep");
                }
                CBORCanonical.CheckDepth(key, depth + 1);
                CBORCanonical.CheckDepth(cbor.get(key), depth + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static byte[] CtapCanonicalEncode(CBORObject a, int depth) {
        CBORType valueAType;
        CBORObject cbor;
        block28: {
            cbor = a.Untag();
            valueAType = cbor.getType();
            try {
                AbstractMap.SimpleImmutableEntry<byte[], byte[]> kv1;
                if (valueAType == CBORType.Array) {
                    ByteArrayOutputStream ms = null;
                    try {
                        ms = new ByteArrayOutputStream();
                        CBORObject.WriteValue((OutputStream)ms, 4, cbor.size());
                        for (int i = 0; i < cbor.size(); ++i) {
                            if (depth >= 3 && CBORCanonical.IsArrayOrMap(cbor.get(i))) {
                                throw new CBORException("Nesting level too deep");
                            }
                            byte[] bytes = CBORCanonical.CtapCanonicalEncode(cbor.get(i), depth + 1);
                            ms.write(bytes, 0, bytes.length);
                        }
                        byte[] i = ms.toByteArray();
                        return i;
                    }
                    finally {
                        try {
                            if (ms != null) {
                                ms.close();
                            }
                        }
                        catch (IOException bytes) {}
                    }
                }
                if (valueAType != CBORType.Map) break block28;
                ArrayList<AbstractMap.SimpleImmutableEntry<byte[], byte[]>> sortedKeys = new ArrayList<AbstractMap.SimpleImmutableEntry<byte[], byte[]>>();
                for (CBORObject key : cbor.getKeys()) {
                    if (depth >= 3 && (CBORCanonical.IsArrayOrMap(key) || CBORCanonical.IsArrayOrMap(cbor.get(key)))) {
                        throw new CBORException("Nesting level too deep");
                    }
                    CBORCanonical.CheckDepth(key, depth + 1);
                    CBORCanonical.CheckDepth(cbor.get(key), depth + 1);
                    kv1 = new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(CBORCanonical.CtapCanonicalEncode(key, depth + 1), CBORCanonical.CtapCanonicalEncode(cbor.get(key), depth + 1));
                    sortedKeys.add(kv1);
                }
                Collections.sort(sortedKeys, ByteComparer);
                ByteArrayOutputStream ms = null;
                try {
                    ms = new ByteArrayOutputStream();
                    CBORObject.WriteValue((OutputStream)ms, 5, cbor.size());
                    byte[] lastKey = null;
                    for (int i = 0; i < sortedKeys.size(); ++i) {
                        kv1 = (AbstractMap.SimpleImmutableEntry<byte[], byte[]>)sortedKeys.get(i);
                        byte[] bytes = (byte[])kv1.getKey();
                        if (lastKey != null && CBORCanonical.ByteArraysEqual(bytes, lastKey)) {
                            throw new CBORException("duplicate canonical CBOR key");
                        }
                        lastKey = bytes;
                        ms.write(bytes, 0, bytes.length);
                        bytes = (byte[])kv1.getValue();
                        ms.write(bytes, 0, bytes.length);
                    }
                    byte[] byArray = ms.toByteArray();
                    return byArray;
                }
                finally {
                    try {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.toString(), ex);
            }
        }
        if (valueAType == CBORType.SimpleValue || valueAType == CBORType.Boolean || valueAType == CBORType.ByteString || valueAType == CBORType.TextString) {
            return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        }
        if (valueAType == CBORType.FloatingPoint) {
            long bits = cbor.AsDoubleBits();
            return new byte[]{-5, (byte)(bits >> 56 & 0xFFL), (byte)(bits >> 48 & 0xFFL), (byte)(bits >> 40 & 0xFFL), (byte)(bits >> 32 & 0xFFL), (byte)(bits >> 24 & 0xFFL), (byte)(bits >> 16 & 0xFFL), (byte)(bits >> 8 & 0xFFL), (byte)(bits & 0xFFL)};
        }
        if (valueAType != CBORType.Integer) {
            throw new IllegalArgumentException("Invalid CBOR type.");
        }
        return cbor.EncodeToBytes(CBOREncodeOptions.Default);
    }

    private static final class CtapComparer
    implements Comparator<CBORObject> {
        private CtapComparer() {
        }

        private static int MajorType(CBORObject a) {
            if (a.isTagged()) {
                return 6;
            }
            switch (a.getType()) {
                case Integer: {
                    return a.AsNumber().IsNegative() ? 1 : 0;
                }
                case SimpleValue: 
                case Boolean: 
                case FloatingPoint: {
                    return 7;
                }
                case ByteString: {
                    return 2;
                }
                case TextString: {
                    return 3;
                }
                case Array: {
                    return 4;
                }
                case Map: {
                    return 5;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int compare(CBORObject a, CBORObject b) {
            byte[] bbs;
            byte[] abs;
            int bmt;
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            if (a == b) {
                return 0;
            }
            a = a.Untag();
            b = b.Untag();
            int amt = CtapComparer.MajorType(a);
            if (amt != (bmt = CtapComparer.MajorType(b))) {
                return amt < bmt ? -1 : 1;
            }
            if (amt == 2) {
                abs = a.GetByteString();
                bbs = b.GetByteString();
            } else {
                abs = CBORCanonical.CtapCanonicalEncode(a);
                bbs = CBORCanonical.CtapCanonicalEncode(b);
            }
            if (abs.length != bbs.length) {
                return abs.length < bbs.length ? -1 : 1;
            }
            for (int i = 0; i < abs.length; ++i) {
                if (abs[i] == bbs[i]) continue;
                int ai = abs[i] & 0xFF;
                int bi = bbs[i] & 0xFF;
                return ai < bi ? -1 : 1;
            }
            return 0;
        }
    }

    private static final class CtapByteComparer
    implements Comparator<Map.Entry<byte[], byte[]>> {
        private CtapByteComparer() {
        }

        @Override
        public int compare(Map.Entry<byte[], byte[]> kva, Map.Entry<byte[], byte[]> kvb) {
            byte[] bytesA = kva.getKey();
            byte[] bytesB = kvb.getKey();
            if (bytesA == null) {
                return bytesB == null ? 0 : -1;
            }
            if (bytesB == null) {
                return 1;
            }
            if (bytesA.length == 0) {
                return bytesB.length == 0 ? 0 : -1;
            }
            if (bytesB.length == 0) {
                return 1;
            }
            if (bytesA == bytesB) {
                return 0;
            }
            if ((bytesA[0] & 0xE0) != (bytesB[0] & 0xE0)) {
                return (bytesA[0] & 0xE0) < (bytesB[0] & 0xE0) ? -1 : 1;
            }
            if (bytesA.length != bytesB.length) {
                return bytesA.length < bytesB.length ? -1 : 1;
            }
            for (int i = 0; i < bytesA.length; ++i) {
                if (bytesA[i] == bytesB[i]) continue;
                int ai = bytesA[i] & 0xFF;
                int bi = bytesB[i] & 0xFF;
                return ai < bi ? -1 : 1;
            }
            return 0;
        }
    }
}

