/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.matcher;

import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.matcher.util.TirePathTree;
import com.usthe.sureness.mgt.SurenessNoInitException;
import com.usthe.sureness.subject.Subject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPathRoleMatcher
implements TreePathRoleMatcher {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPathRoleMatcher.class);
    private static final String LEFT_CON = "[";
    private static final String RIGHT_CON = "]";
    private static final String NULL_ROLE = "[]";
    private final TirePathTree root = new TirePathTree();
    private final Set<String> excludedResource = new HashSet<String>(16);
    private PathTreeProvider pathTreeProvider;
    private boolean isTreeInit;

    @Override
    public void matchRole(Subject auToken) {
        if (!this.isTreeInit) {
            logger.error("DefaultPathRoleMatcher -> root tree is not init");
            throw new SurenessNoInitException("DefaultPathRoleMatcher -> root tree is not init");
        }
        String targetResource = (String)auToken.getTargetResource();
        String matchRoleString = this.root.searchPathFilterRoles(targetResource);
        if (matchRoleString != null && matchRoleString.startsWith(LEFT_CON) && matchRoleString.endsWith(RIGHT_CON)) {
            if (NULL_ROLE.equals(matchRoleString)) {
                auToken.setSupportRoles(new ArrayList(0));
            } else {
                String[] roles = matchRoleString.substring(1, matchRoleString.length() - 1).split(",");
                auToken.setSupportRoles(Arrays.asList(roles));
            }
        }
    }

    @Override
    public void buildTree() {
        this.isTreeInit = false;
        this.checkComponentInit();
        this.clearTree();
        Set<String> resources = this.pathTreeProvider.providePathData();
        if (resources != null) {
            resources = resources.stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.root.buildTree(resources);
            this.isTreeInit = true;
        } else {
            this.isTreeInit = false;
        }
    }

    @Override
    public boolean isExcludedResource(Object request) {
        String requestUri = ((HttpServletRequest)request).getRequestURI();
        String requestType = ((HttpServletRequest)request).getMethod();
        String targetUri = requestUri.concat("===").concat(requestType).toLowerCase();
        return this.excludedResource.contains(targetUri);
    }

    @Override
    public void loadExcludedResource() {
        Set<String> provideResource = this.pathTreeProvider.provideExcludedResource();
        if (provideResource != null) {
            provideResource = provideResource.stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.excludedResource.addAll(provideResource);
        }
    }

    private void checkComponentInit() {
        if (this.pathTreeProvider == null) {
            throw new SurenessNoInitException("DefaultPathRoleMatcher init error : component init not complete");
        }
    }

    private void clearTree() {
        this.root.clearTree();
    }

    public void setPathTreeProvider(PathTreeProvider pathTreeProvider) {
        this.pathTreeProvider = pathTreeProvider;
    }
}

