/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.matcher.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TirePathTree {
    private static final String NODE_TYPE_PATH_NODE = "pathNode";
    private static final String NODE_TYPE_PATH_END = "isPathEnd";
    private static final String NODE_TYPE_METHOD = "methodNode";
    private static final String NODE_TYPE_FILTER_ROLES = "filterRolesNode";
    private static final String URL_PATH_SPLIT = "/";
    private static final int PATH_NODE_NUM_3 = 3;
    private static final int PATH_NODE_NUM_2 = 2;
    private Node root = new Node("root");

    public void buildTree(Set<String> paths) {
        this.clearTree();
        for (String path : paths) {
            this.insertNode(path);
        }
    }

    public void clearTree() {
        this.root.getChildren().clear();
    }

    public int getResourceNum() {
        int resourceNum = 0;
        LinkedList<Node> resourceList = new LinkedList<Node>();
        resourceList.add(this.root);
        while (!resourceList.isEmpty()) {
            Node currentNode = (Node)resourceList.poll();
            if (NODE_TYPE_METHOD.equals(currentNode.nodeType)) {
                ++resourceNum;
            }
            if (currentNode.getChildren() == null || currentNode.getChildren().isEmpty()) continue;
            resourceList.addAll(currentNode.getChildren().values());
        }
        return resourceNum;
    }

    public String searchPathFilterRoles(String path) {
        if (path == null || "".equals(path) || !path.startsWith(URL_PATH_SPLIT)) {
            return null;
        }
        String[] tmp = path.split("===");
        if (tmp.length != 2) {
            return null;
        }
        String[] urlPac = tmp[0].split(URL_PATH_SPLIT);
        if (urlPac.length > 1) {
            urlPac = Arrays.copyOfRange(urlPac, 1, urlPac.length);
        }
        String method = tmp[1];
        Node current = this.root;
        for (String data : urlPac) {
            if (current.getChildren().containsKey(data.toLowerCase())) {
                current = (Node)current.getChildren().get(data.toLowerCase());
                continue;
            }
            if (current.getChildren().containsKey("*")) {
                current = (Node)current.getChildren().get("*");
                continue;
            }
            if (current.getChildren().containsKey("**")) {
                if (NODE_TYPE_PATH_END.equals((current = (Node)current.getChildren().get("**")).getNodeType())) {
                    if (current.getChildren().containsKey(method.toLowerCase())) {
                        if (NODE_TYPE_METHOD.equals((current = (Node)current.getChildren().get(method.toLowerCase())).getNodeType())) {
                            if (!current.getChildren().isEmpty()) {
                                Iterator iterator = current.getChildren().entrySet().iterator();
                                Map.Entry filterRole = iterator.next();
                                if (NODE_TYPE_FILTER_ROLES.equals(((Node)filterRole.getValue()).getNodeType())) {
                                    return (String)filterRole.getKey();
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        if (!NODE_TYPE_PATH_END.equals(current.getNodeType())) {
            return null;
        }
        if (!current.getChildren().containsKey(method.toLowerCase())) {
            return null;
        }
        if (!NODE_TYPE_METHOD.equals((current = (Node)current.getChildren().get(method.toLowerCase())).getNodeType())) {
            return null;
        }
        if (!current.getChildren().isEmpty()) {
            Iterator iterator = current.getChildren().entrySet().iterator();
            Map.Entry filterRole = iterator.next();
            if (NODE_TYPE_FILTER_ROLES.equals(((Node)filterRole.getValue()).getNodeType())) {
                return (String)filterRole.getKey();
            }
            return null;
        }
        return null;
    }

    private void insertNode(String path) {
        if (path == null || "".equals(path) || !path.startsWith(URL_PATH_SPLIT)) {
            return;
        }
        String[] tmp = path.split("===");
        if (tmp.length != 3) {
            return;
        }
        String[] urlPac = tmp[0].split(URL_PATH_SPLIT);
        if (urlPac.length > 1) {
            urlPac = Arrays.copyOfRange(urlPac, 1, urlPac.length);
        }
        String method = tmp[1];
        String supportRoles = tmp[2];
        Node current = this.root;
        for (String urlData : urlPac) {
            if (!current.getChildren().containsKey(urlData.toLowerCase())) {
                current.insertChild(urlData.toLowerCase());
            }
            current = (Node)current.getChildren().get(urlData.toLowerCase());
        }
        current.setNodeType(NODE_TYPE_PATH_END);
        if (!current.getChildren().containsKey(method.toLowerCase())) {
            current.insertChild(method.toLowerCase(), NODE_TYPE_METHOD);
        }
        if ((current = (Node)current.getChildren().get(method.toLowerCase())).getChildren().isEmpty()) {
            current.insertChild(supportRoles, NODE_TYPE_FILTER_ROLES);
        }
    }

    private class Node {
        private String nodeType;
        private String data;
        private Map<String, Node> children;

        private Node(String data, String nodeType) {
            this.data = data;
            this.nodeType = nodeType;
            this.children = new HashMap<String, Node>();
        }

        private Node(String data) {
            this.data = data;
            this.nodeType = TirePathTree.NODE_TYPE_PATH_NODE;
            this.children = new HashMap<String, Node>();
        }

        private void insertChild(String data) {
            this.children.put(data, new Node(data));
        }

        private void insertChild(String data, String nodeType) {
            this.children.put(data, new Node(data, nodeType));
        }

        private String getNodeType() {
            return this.nodeType;
        }

        private void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        private String getData() {
            return this.data;
        }

        private void setData(String data) {
            this.data = data;
        }

        private Map<String, Node> getChildren() {
            return this.children;
        }

        private void setChildren(Map<String, Node> children) {
            this.children = children;
        }
    }
}

