/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.mgt;

import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.mgt.SecurityManager;
import com.usthe.sureness.mgt.SurenessNoInitException;
import com.usthe.sureness.processor.ProcessorManager;
import com.usthe.sureness.processor.exception.BaseSurenessException;
import com.usthe.sureness.processor.exception.UnsupportedSubjectException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectFactory;
import com.usthe.sureness.subject.SubjectSum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurenessSecurityManager
implements SecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(SurenessSecurityManager.class);
    private SubjectFactory subjectFactory;
    private TreePathRoleMatcher pathRoleMatcher;
    private ProcessorManager processorManager;

    private SurenessSecurityManager() {
    }

    private void checkComponentInit() {
        if (this.subjectFactory == null || this.pathRoleMatcher == null || this.processorManager == null) {
            logger.error("SecurityManager init error : SurenessSecurityManager not init fill component");
            throw new SurenessNoInitException("SurenessSecurityManager not init fill component");
        }
    }

    @Override
    public SubjectSum checkIn(Subject token) throws BaseSurenessException {
        this.pathRoleMatcher.matchRole(token);
        return this.processorManager.process(token);
    }

    @Override
    public SubjectSum checkIn(Object var1) throws BaseSurenessException {
        this.checkComponentInit();
        if (this.pathRoleMatcher.isExcludedResource(var1)) {
            return null;
        }
        List<Subject> subjectList = this.createSubject(var1);
        BaseSurenessException lastException = new UnsupportedSubjectException("this request can not create subject by creators");
        for (Subject thisSubject : subjectList) {
            try {
                return this.checkIn(thisSubject);
            }
            catch (BaseSurenessException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    @Override
    public List<Subject> createSubject(Object var1) {
        return this.subjectFactory.createSubjects(var1);
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public void setPathRoleMatcher(TreePathRoleMatcher pathRoleMatcher) {
        this.pathRoleMatcher = pathRoleMatcher;
    }

    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public TreePathRoleMatcher getPathRoleMatcher() {
        return this.pathRoleMatcher;
    }

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public static SurenessSecurityManager getInstance() {
        return SingleDefaultSecurityManager.INSTANCE;
    }

    private static class SingleDefaultSecurityManager {
        private static final SurenessSecurityManager INSTANCE = new SurenessSecurityManager();

        private SingleDefaultSecurityManager() {
        }
    }
}

