/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.processor;

import com.usthe.sureness.mgt.SurenessNoInitException;
import com.usthe.sureness.processor.Processor;
import com.usthe.sureness.processor.ProcessorManager;
import com.usthe.sureness.processor.exception.BaseSurenessException;
import com.usthe.sureness.processor.exception.ProcessorNotFoundException;
import com.usthe.sureness.processor.exception.SurenessAuthenticationException;
import com.usthe.sureness.processor.exception.SurenessAuthorizationException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectSum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessorManager
implements ProcessorManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProcessorManager.class);
    private List<Processor> processorList;

    public DefaultProcessorManager(List<Processor> processorList) {
        this.processorList = processorList;
    }

    @Override
    public SubjectSum process(Subject auToken) throws SurenessAuthenticationException, SurenessAuthorizationException {
        this.checkComponentInit();
        SurenessAuthenticationException lastAuthenticationException = null;
        BaseSurenessException lastAuthorizationException = null;
        SubjectSum subjectResult = null;
        Class<?> auTokenClazz = auToken.getClass();
        for (Processor processor : this.getProcessorList()) {
            if (processor.canSupportAuTokenClass(auTokenClazz)) {
                try {
                    subjectResult = processor.process(auToken);
                }
                catch (SurenessAuthenticationException var1) {
                    lastAuthenticationException = var1;
                }
                catch (SurenessAuthorizationException var2) {
                    lastAuthorizationException = var2;
                }
            }
            if (subjectResult == null) continue;
            return subjectResult;
        }
        if (lastAuthenticationException == null && lastAuthorizationException == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("not found token : {} -- target processor", auToken.getClass());
            }
            throw new ProcessorNotFoundException("not found token : " + auToken.getClass() + " --target processor");
        }
        throw lastAuthenticationException == null ? lastAuthorizationException : lastAuthenticationException;
    }

    private List<Processor> getProcessorList() {
        return this.processorList;
    }

    private void checkComponentInit() throws SurenessNoInitException {
        if (this.processorList == null) {
            throw new SurenessNoInitException("processorManager not init component processorList");
        }
    }
}

