/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.processor.support;

import com.usthe.sureness.processor.BaseProcessor;
import com.usthe.sureness.processor.exception.ExpiredCredentialsException;
import com.usthe.sureness.processor.exception.IncorrectCredentialsException;
import com.usthe.sureness.processor.exception.SurenessAuthenticationException;
import com.usthe.sureness.processor.exception.SurenessAuthorizationException;
import com.usthe.sureness.processor.exception.UnauthorizedException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtProcessor
extends BaseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JwtProcessor.class);

    @Override
    public boolean canSupportAuTokenClass(Class<?> var) {
        return var == JwtSubject.class;
    }

    @Override
    public Class<?> getSupportAuTokenClass() {
        return JwtSubject.class;
    }

    @Override
    public Subject authenticated(Subject var) throws SurenessAuthenticationException {
        Claims claims;
        String jwt = (String)var.getCredentials();
        if (JsonWebTokenUtil.isNotJsonWebToken(jwt)) {
            throw new IncorrectCredentialsException("this jwt credential is illegal");
        }
        try {
            claims = JsonWebTokenUtil.parseJwt(jwt);
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("jwtProcessor authenticated fail, user: {}, jwt: {}", var.getPrincipal(), (Object)jwt);
            }
            throw new IncorrectCredentialsException("this jwt error:" + e.getMessage());
        }
        catch (ExpiredJwtException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("jwtProcessor authenticated expired, user: {}, jwt: {}", var.getPrincipal(), (Object)jwt);
            }
            throw new ExpiredCredentialsException("this jwt has expired");
        }
        JwtSubject.Builder builder = JwtSubject.builder(var).setPrincipal(claims.getSubject());
        List ownRoles = (List)claims.get("roles", List.class);
        if (ownRoles != null) {
            builder.setOwnRoles(ownRoles);
        }
        return builder.build();
    }

    @Override
    public void authorized(Subject var) throws SurenessAuthorizationException {
        List ownRoles = (List)var.getOwnRoles();
        List supportRoles = (List)var.getSupportRoles();
        if (supportRoles != null) {
            if (supportRoles.stream().noneMatch(ownRoles::contains)) {
                throw new UnauthorizedException("do not have the role access");
            }
        }
    }
}

