/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.processor.support;

import com.usthe.sureness.processor.BaseProcessor;
import com.usthe.sureness.processor.exception.SurenessAuthenticationException;
import com.usthe.sureness.processor.exception.SurenessAuthorizationException;
import com.usthe.sureness.processor.exception.UnauthorizedException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.support.NoneSubject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoneProcessor
extends BaseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(NoneProcessor.class);

    @Override
    public boolean canSupportAuTokenClass(Class<?> var) {
        return var == NoneSubject.class;
    }

    @Override
    public Class<?> getSupportAuTokenClass() {
        return NoneSubject.class;
    }

    @Override
    public Subject authenticated(Subject var) throws SurenessAuthenticationException {
        return var;
    }

    @Override
    public void authorized(Subject var) throws SurenessAuthorizationException {
        List supportRoles = (List)var.getSupportRoles();
        if (supportRoles != null && !supportRoles.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("NoneProcessor authorized fail, due {} need role access", var.getTargetResource());
            }
            throw new UnauthorizedException("do not have the role access");
        }
    }
}

