/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.provider;

import com.usthe.sureness.provider.DocumentResourceEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.yaml.snakeyaml.Yaml;

public class DocumentResourceAccess {
    private static final String DEFAULT_FILE_NAME = "sureness.yml";
    private static String yamlFilePath = ClassLoader.getSystemResource("sureness.yml").getPath();

    public static DocumentResourceEntity loadConfig() throws IOException {
        DocumentResourceEntity documentResourceEntity;
        Yaml yaml = new Yaml();
        File yamlFile = new File(yamlFilePath);
        if (!yamlFile.exists()) {
            throw new FileNotFoundException("sureness file: " + yamlFile + "not found, please create the file if you need config resource");
        }
        FileInputStream inputStream = new FileInputStream(yamlFile);
        try {
            documentResourceEntity = (DocumentResourceEntity)yaml.loadAs((InputStream)inputStream, DocumentResourceEntity.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        inputStream.close();
        return documentResourceEntity;
    }

    public static void dumpConfig(DocumentResourceEntity entity) throws IOException {
        Yaml yaml = new Yaml();
        File yamlFile = new File(yamlFilePath);
        if (yamlFile.exists()) {
            throw new FileNotFoundException("sureness file: " + yamlFilePath + "not found, please create the file if you need config resource in one file");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(yamlFile), StandardCharsets.UTF_8);){
            yaml.dump((Object)entity, (Writer)writer);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static void setYamlFile(String yamlFile) {
        yamlFilePath = yamlFile;
    }
}

