/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.provider;

import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.SurenessLoadDataException;
import com.usthe.sureness.provider.DefaultAccount;
import com.usthe.sureness.provider.DocumentResourceAccess;
import com.usthe.sureness.provider.DocumentResourceEntity;
import com.usthe.sureness.provider.SurenessAccount;
import com.usthe.sureness.provider.SurenessAccountProvider;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentResourceDefaultProvider
implements PathTreeProvider,
SurenessAccountProvider {
    private static final Logger logger = LoggerFactory.getLogger(DocumentResourceDefaultProvider.class);
    private static final String CREDENTIAL = "credential";
    private static final String SALT = "salt";
    private static final String ROLE = "role";

    @Override
    public Set<String> providePathData() {
        try {
            DocumentResourceEntity entity = DocumentResourceAccess.loadConfig();
            return new HashSet<String>(entity.getResourceRole());
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
            throw new SurenessLoadDataException(e.getMessage());
        }
    }

    @Override
    public Set<String> provideExcludedResource() {
        try {
            DocumentResourceEntity entity = DocumentResourceAccess.loadConfig();
            List<String> resource = entity.getExcludedResource();
            if (resource != null) {
                return new HashSet<String>(resource);
            }
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
        }
        return new HashSet<String>();
    }

    @Override
    public SurenessAccount loadAccount(String appId) {
        if (appId == null) {
            return null;
        }
        try {
            DocumentResourceEntity entity = DocumentResourceAccess.loadConfig();
            Optional<Map> mapOptional = entity.getAccount().stream().filter(map -> appId.equals(map.get("appId"))).findFirst();
            DefaultAccount.Builder builder = new DefaultAccount.Builder(appId);
            if (mapOptional.isPresent()) {
                Map accountMap = mapOptional.get();
                if (accountMap.get(CREDENTIAL) != null) {
                    builder.setPassword(String.valueOf(accountMap.get(CREDENTIAL)));
                }
                if (accountMap.get(SALT) != null) {
                    builder.setSalt(String.valueOf(accountMap.get(SALT)));
                }
                if (accountMap.get(ROLE) != null) {
                    builder.setOwnRoles((List)accountMap.get(ROLE));
                }
                builder.setDisabledAccount(Boolean.FALSE).setExcessiveAttempts(Boolean.FALSE);
                return builder.build();
            }
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
        }
        return null;
    }
}

