/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class JsonWebTokenUtil {
    private static final String DEFAULT_SECRET_KEY = "?::4390fsf4sdl6opf):";
    private static final int COUNT_3 = 3;
    private static String secretKey = "?::4390fsf4sdl6opf):";

    public static String issueJwt(String id, String subject, String issuer, Long period, List<String> roles, List<String> permissions, Boolean isRefresh, SignatureAlgorithm algorithm) {
        long currentTimeMillis = System.currentTimeMillis();
        byte[] secretKeyBytes = DatatypeConverter.parseBase64Binary((String)secretKey);
        JwtBuilder jwtBuilder = Jwts.builder();
        if (id != null) {
            jwtBuilder.setId(id);
        }
        if (subject != null) {
            jwtBuilder.setSubject(subject);
        }
        if (issuer != null) {
            jwtBuilder.setIssuer(issuer);
        }
        jwtBuilder.setIssuedAt(new Date(currentTimeMillis));
        if (null != period) {
            jwtBuilder.setExpiration(new Date(currentTimeMillis + period * 1000L));
        }
        if (roles != null) {
            jwtBuilder.claim("roles", roles);
        }
        if (permissions != null) {
            jwtBuilder.claim("perms", permissions);
        }
        if (isRefresh != null) {
            jwtBuilder.claim("isRefresh", (Object)isRefresh);
        }
        jwtBuilder.compressWith(CompressionCodecs.DEFLATE);
        jwtBuilder.signWith(algorithm, secretKeyBytes);
        return jwtBuilder.compact();
    }

    public static boolean isNotJsonWebToken(String jwt) {
        return jwt.split("\\.").length != 3;
    }

    public static Claims parseJwt(String jwt) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secretKey)).parseClaimsJws(jwt).getBody();
    }

    public static void setSecretKey(String secretNowKey) {
        secretKey = secretNowKey;
    }
}

