/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import com.usthe.sureness.subject.SubjectSum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContext {
    private static final Logger logger = LoggerFactory.getLogger(ThreadContext.class);
    public static final String SUBJECT_KEY = ThreadContext.class.getName() + "_SUBJECT_KEY";
    private static final ThreadLocal<Map<Object, Object>> RESOURCES = new InheritableThreadLocalMap();

    public static void bind(SubjectSum subject) {
        if (subject != null) {
            ThreadContext.put(SUBJECT_KEY, subject);
        }
    }

    public static SubjectSum unbindSubject() {
        return (SubjectSum)ThreadContext.remove(SUBJECT_KEY);
    }

    public static SubjectSum getBindSubject() {
        return (SubjectSum)ThreadContext.get(SUBJECT_KEY);
    }

    private static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            ThreadContext.remove(key);
        } else {
            ThreadContext.ensureResourcesInitialized();
            RESOURCES.get().put(key, value);
            if (logger.isTraceEnabled()) {
                String msg = "Bound value of type [" + value.getClass().getName() + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]";
                logger.trace(msg);
            }
        }
    }

    private static Object get(Object key) {
        Map<Object, Object> perThreadResources;
        Object value;
        if (logger.isTraceEnabled()) {
            String msg = "get() - in thread [" + Thread.currentThread().getName() + "]";
            logger.trace(msg);
        }
        Object object = value = (perThreadResources = RESOURCES.get()) != null ? perThreadResources.get(key) : null;
        if (value != null && logger.isTraceEnabled()) {
            String msg = "Retrieved value of type [" + value.getClass().getName() + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]";
            logger.trace(msg);
        }
        return value;
    }

    private static Object remove(Object key) {
        Object value;
        Map<Object, Object> perThreadResources = RESOURCES.get();
        Object object = value = perThreadResources != null ? perThreadResources.remove(key) : null;
        if (value != null && logger.isTraceEnabled()) {
            String msg = "Removed value of type [" + value.getClass().getName() + "] for key [" + key + "]from thread [" + Thread.currentThread().getName() + "]";
            logger.trace(msg);
        }
        return value;
    }

    private static void ensureResourcesInitialized() {
        if (RESOURCES.get() == null) {
            RESOURCES.set(new HashMap(8));
        }
    }

    public static void remove() {
        RESOURCES.remove();
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            return parentValue != null ? (Map)((HashMap)parentValue).clone() : null;
        }
    }
}

