/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness;

import com.usthe.sureness.matcher.DefaultPathRoleMatcher;
import com.usthe.sureness.mgt.SurenessSecurityManager;
import com.usthe.sureness.processor.DefaultProcessorManager;
import com.usthe.sureness.processor.Processor;
import com.usthe.sureness.processor.support.DigestProcessor;
import com.usthe.sureness.processor.support.JwtProcessor;
import com.usthe.sureness.processor.support.NoneProcessor;
import com.usthe.sureness.processor.support.PasswordProcessor;
import com.usthe.sureness.provider.ducument.DocumentAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentPathTreeProvider;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.SurenessSubjectFactory;
import com.usthe.sureness.subject.creater.BasicSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.BasicSubjectServletCreator;
import com.usthe.sureness.subject.creater.BasicSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.DigestSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.DigestSubjectServletCreator;
import com.usthe.sureness.subject.creater.DigestSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.JwtSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.JwtSubjectServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsJaxRsCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsSpringReactiveCreator;
import com.usthe.sureness.subject.creater.NoneSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.NoneSubjectServletCreator;
import com.usthe.sureness.subject.creater.NoneSubjectSpringReactiveCreator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSurenessConfig {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSurenessConfig.class);
    public static final String SUPPORT_SERVLET = "servlet";
    public static final String SUPPORT_JAX_RS = "jax-rs";
    public static final String SUPPORT_SPRING_REACTIVE = "spring-reactive";

    public DefaultSurenessConfig() {
        this.init(SUPPORT_SERVLET);
    }

    public DefaultSurenessConfig(String supportContainer) {
        this.init(supportContainer);
    }

    private void init(String supportContainer) {
        DocumentAccountProvider accountProvider = new DocumentAccountProvider();
        LinkedList<Processor> processorList = new LinkedList<Processor>();
        NoneProcessor noneProcessor = new NoneProcessor();
        processorList.add(noneProcessor);
        JwtProcessor jwtProcessor = new JwtProcessor();
        processorList.add(jwtProcessor);
        PasswordProcessor passwordProcessor = new PasswordProcessor();
        passwordProcessor.setAccountProvider(accountProvider);
        processorList.add(passwordProcessor);
        DigestProcessor digestProcessor = new DigestProcessor();
        digestProcessor.setAccountProvider(accountProvider);
        processorList.add(digestProcessor);
        DefaultProcessorManager processorManager = new DefaultProcessorManager(processorList);
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultProcessorManager init");
        }
        DocumentPathTreeProvider pathTreeProvider = new DocumentPathTreeProvider();
        DefaultPathRoleMatcher pathRoleMatcher = new DefaultPathRoleMatcher();
        pathRoleMatcher.setPathTreeProvider(pathTreeProvider);
        pathRoleMatcher.buildTree();
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultPathRoleMatcher init");
        }
        SurenessSubjectFactory subjectFactory = new SurenessSubjectFactory();
        List<SubjectCreate> subjectCreates = SUPPORT_JAX_RS.equals(supportContainer) ? Arrays.asList(new NoneSubjectJaxRsCreator(), new DigestSubjectJaxRsCreator(), new BasicSubjectJaxRsCreator(), new JwtSubjectJaxRsCreator(), new JwtSubjectWsJaxRsCreator()) : (SUPPORT_SPRING_REACTIVE.equals(supportContainer) ? Arrays.asList(new NoneSubjectSpringReactiveCreator(), new DigestSubjectSpringReactiveCreator(), new BasicSubjectSpringReactiveCreator(), new JwtSubjectSpringReactiveCreator(), new JwtSubjectWsSpringReactiveCreator()) : Arrays.asList(new NoneSubjectServletCreator(), new DigestSubjectServletCreator(), new BasicSubjectServletCreator(), new JwtSubjectServletCreator(), new JwtSubjectWsServletCreator()));
        subjectFactory.registerSubjectCreator(subjectCreates);
        if (logger.isDebugEnabled()) {
            logger.debug("SurenessSubjectFactory init");
        }
        SurenessSecurityManager securityManager = SurenessSecurityManager.getInstance();
        securityManager.setPathRoleMatcher(pathRoleMatcher);
        securityManager.setSubjectFactory(subjectFactory);
        securityManager.setProcessorManager(processorManager);
        if (logger.isDebugEnabled()) {
            logger.debug("SurenessSecurityManager init");
        }
    }
}

