/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSubjectServletCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(JwtSubjectServletCreator.class);

    @Override
    public boolean canSupportSubject(Object context) {
        String authorization;
        if (context instanceof HttpServletRequest && (authorization = ((HttpServletRequest)context).getHeader("Authorization")) != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            return !JsonWebTokenUtil.isNotJsonWebToken(jwtValue);
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String authorization = ((HttpServletRequest)context).getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            if (JsonWebTokenUtil.isNotJsonWebToken(jwtValue)) {
                if (logger.isInfoEnabled()) {
                    logger.info("can not create JwtSubject by this request message, is not jwt");
                }
                return null;
            }
            String remoteHost = ((HttpServletRequest)context).getRemoteHost();
            String requestUri = ((HttpServletRequest)context).getRequestURI();
            String requestType = ((HttpServletRequest)context).getMethod();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder(jwtValue).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
        }
        return null;
    }
}

