/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import javax.servlet.http.HttpServletRequest;

public class JwtSubjectWsServletCreator
implements SubjectCreate {
    @Override
    public boolean canSupportSubject(Object context) {
        if (context instanceof HttpServletRequest) {
            String token = ((HttpServletRequest)context).getParameter("token");
            return !JsonWebTokenUtil.isNotJsonWebToken(token);
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String jwtToken = ((HttpServletRequest)context).getParameter("token");
        if (jwtToken != null) {
            jwtToken = jwtToken.trim();
            String remoteHost = ((HttpServletRequest)context).getRemoteHost();
            String requestUri = ((HttpServletRequest)context).getRequestURI();
            String requestType = ((HttpServletRequest)context).getMethod();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder(jwtToken).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
        }
        return null;
    }
}

