/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleParser.class);
    private static final String SOURCE = "source";
    private static final String NAME = "name";
    private static final String CHUNKS = "chunks";
    private static final String MODULES = "modules";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("get[\\s]*template\\(\\)[\\s]*\\{[\\s]*return[\\s]*html([\\`|\\'|\\\"])([\\s\\S]*)\\1;[\\s]*\\}");
    private static final Pattern HASH_PATTERN = Pattern.compile("\"hash\"\\s*:\\s*\"([^\"]+)\"\\s*,");
    private static final String TEMPLATE_TAG_NAME = "template";

    private BundleParser() {
    }

    public static String getHashFromStatistics(String fileContents) {
        Matcher matcher = HASH_PATTERN.matcher(fileContents);
        return matcher.find() ? matcher.group(1) : "" + fileContents.length();
    }

    public static JsonObject parseJsonStatistics(String fileContents) {
        return Json.parse((String)fileContents);
    }

    public static String getSourceFromStatistics(String fileName, JsonObject statistics) {
        return BundleParser.getSourceFromObject(statistics, fileName);
    }

    public static Element parseTemplateElement(String name, JsonObject statisticsJson) {
        return BundleParser.parseTemplateElement(name, statisticsJson.getString(SOURCE));
    }

    public static Element parseTemplateElement(String fileName, String source) {
        Document templateDocument;
        Matcher matcher = TEMPLATE_PATTERN.matcher(source);
        if (matcher.find() && matcher.groupCount() == 2) {
            String group = matcher.group(2);
            LOGGER.trace("Found template content was {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
        } else {
            LOGGER.warn("No template data found in {} sources.", (Object)fileName);
            templateDocument = new Document("");
            templateDocument.appendChild((Node)templateDocument.createElement("body"));
        }
        Element template = templateDocument.createElement(TEMPLATE_TAG_NAME);
        templateDocument.body().children().stream().filter(node -> !node.equals((Object)templateDocument.body())).forEach(arg_0 -> ((Element)template).appendChild(arg_0));
        return template;
    }

    private static String getSourceFromObject(JsonObject module, String fileName) {
        String source = null;
        if (BundleParser.validKey(module, MODULES, JsonType.ARRAY)) {
            source = BundleParser.getSourceFromArray(module.getArray(MODULES), fileName);
        }
        if (source == null && BundleParser.validKey(module, CHUNKS, JsonType.ARRAY)) {
            source = BundleParser.getSourceFromArray(module.getArray(CHUNKS), fileName);
        }
        if (source == null && BundleParser.validKey(module, NAME, JsonType.STRING) && BundleParser.validKey(module, SOURCE, JsonType.STRING)) {
            String name = module.getString(NAME);
            if (name.endsWith("es5")) {
                return source;
            }
            fileName = fileName.replaceFirst("(\\.js|)$", ".js");
            String alternativeFileName = fileName.replaceFirst("^(\\./)frontend/", "$1").replaceFirst("^frontend://", ".");
            if (name.contains("@vaadin/flow-frontend/")) {
                alternativeFileName = alternativeFileName.replaceFirst("\\./", "");
            }
            if ((name = name.replaceFirst("\\?.+$", "")).endsWith(fileName) || name.endsWith(alternativeFileName)) {
                source = module.getString(SOURCE);
            }
        }
        return source;
    }

    private static String getSourceFromArray(JsonArray objects, String fileName) {
        String source = null;
        for (int i = 0; source == null && i < objects.length(); ++i) {
            if (!objects.get(i).getType().equals((Object)JsonType.OBJECT)) continue;
            source = BundleParser.getSourceFromObject((JsonObject)objects.get(i), fileName);
        }
        return source;
    }

    private static boolean validKey(JsonObject o, String k, JsonType t) {
        boolean validKey = o != null && o.hasKey(k) && o.get(k).getType().equals((Object)t);
        return validKey && (!t.equals((Object)JsonType.STRING) || !o.getString(k).isEmpty());
    }
}

