/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.polymertemplate.AbstractTemplate;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class IdMapper
implements Serializable {
    private final HashMap<String, Element> registeredElementIdToInjected = new HashMap();
    private AbstractTemplate<?> template;

    public IdMapper(AbstractTemplate<?> template) {
        this.template = template;
    }

    public void mapComponentOrElement(Field field, String id, String tag, Consumer<Element> beforeComponentInject) {
        Element element = this.getElementById(id).orElse(null);
        if (element == null) {
            this.injectClientSideElement(tag, id, field, beforeComponentInject);
        } else {
            this.injectServerSideElement(element, field, beforeComponentInject);
        }
    }

    private void injectServerSideElement(Element element, Field field, Consumer<Element> beforeComponentInject) {
        if (this.getElement().equals(element)) {
            throw new IllegalArgumentException("Cannot map the root element of the template. This is always mapped to the template instance itself (" + this.getContainerClass().getName() + ')');
        }
        if (element != null) {
            this.injectTemplateElement(element, field, beforeComponentInject);
        }
    }

    private Class<? extends Component> getContainerClass() {
        return this.template.getClass();
    }

    private void injectClientSideElement(String tagName, String id, Field field, Consumer<Element> beforeComponentInject) {
        Class<?> fieldType = field.getType();
        Tag tag = fieldType.getAnnotation(Tag.class);
        if (tag != null && !tagName.equalsIgnoreCase(tag.value())) {
            String msg = String.format("Class '%s' has field '%s' whose type '%s' is annotated with tag '%s' but the element defined in the HTML template with id '%s' has tag name '%s'", this.getContainerClass().getName(), field.getName(), fieldType.getName(), tag.value(), id, tagName);
            throw new IllegalStateException(msg);
        }
        this.attachExistingElementById(tagName, id, field, beforeComponentInject);
    }

    public ShadowRoot getOrCreateShadowRoot() {
        return this.getElement().getShadowRoot().orElseGet(() -> this.getElement().attachShadow());
    }

    private Element getElement() {
        return this.template.getElement();
    }

    private Optional<Element> getElementById(String id) {
        return this.getOrCreateShadowRoot().getChildren().flatMap(this::flattenChildren).filter(element -> id.equals(element.getAttribute("id"))).findFirst();
    }

    private Stream<Element> flattenChildren(Element node) {
        if (node.getChildCount() > 0) {
            return node.getChildren().flatMap(this::flattenChildren);
        }
        return Stream.of(node);
    }

    private void attachExistingElementById(String tagName, String id, Field field, Consumer<Element> beforeComponentInject) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name parameter cannot be null");
        }
        Element element = this.registeredElementIdToInjected.get(id);
        if (element == null) {
            element = new Element(tagName);
            VirtualChildrenList list = this.getElement().getNode().getFeature(VirtualChildrenList.class);
            list.append(element.getNode(), "@id", id);
            this.registeredElementIdToInjected.put(id, element);
        }
        this.injectTemplateElement(element, field, beforeComponentInject);
    }

    private void injectTemplateElement(Element element, Field field, Consumer<Element> beforeComponentInject) {
        Class<?> fieldType = field.getType();
        if (Component.class.isAssignableFrom(fieldType)) {
            Component component;
            beforeComponentInject.accept(element);
            Optional<Component> wrappedComponent = element.getComponent();
            if (wrappedComponent.isPresent()) {
                component = wrappedComponent.get();
            } else {
                Class<?> componentType = fieldType;
                component = Component.from(element, componentType);
            }
            ReflectTools.setJavaFieldValue(this.template, field, component);
        } else if (Element.class.isAssignableFrom(fieldType)) {
            ReflectTools.setJavaFieldValue(this.template, field, element);
        } else {
            String msg = String.format("The field '%s' in '%s' has an @'%s' annotation but the field type '%s' does not extend neither '%s' nor '%s'", field.getName(), this.getContainerClass().getName(), Id.class.getSimpleName(), fieldType.getName(), Component.class.getSimpleName(), Element.class.getSimpleName());
            throw new IllegalArgumentException(msg);
        }
    }

    public void reset() {
        this.registeredElementIdToInjected.clear();
    }

    public boolean isMapped(String id) {
        return this.registeredElementIdToInjected.containsKey(id);
    }
}

