/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.CompatibilityModeStatus;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinServletConfiguration;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

public final class DeploymentConfigurationFactory
implements Serializable {
    public static final Object DEV_MODE_ENABLE_STRATEGY = new Serializable(){};
    public static final String ERROR_COMPATIBILITY_MODE_UNSET = "Unable to determine mode of operation. To use npm mode, ensure 'flow-build-info.json' exists on the classpath. With Maven, this is handled by the 'prepare-frontend' goal. To use compatibility mode, add the 'flow-server-compatibility-mode' dependency. If using Vaadin with Spring Boot, instead set the property 'vaadin.compatibilityMode' to 'true' in 'application.properties'.";
    public static final String ERROR_DEV_MODE_NO_FILES = "The compatibility mode is explicitly set to 'false', but there are neither 'flow-build-info.json' nor 'webpack.config.js' file available in the project/working directory. Ensure 'webpack.config.js' is present or trigger creation of 'flow-build-info.json' via running 'prepare-frontend' Maven goal.";
    public static final String DEV_FOLDER_MISSING_MESSAGE = "Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/v14/flow/production/tutorial-production-mode-basic.html";
    private static Pattern JAR_REGEX = Pattern.compile("(.+\\.jar).*");

    private DeploymentConfigurationFactory() {
    }

    public static DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        return new DefaultDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, servletConfig));
    }

    public static DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        return new PropertyDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, servletConfig));
    }

    protected static Properties createInitParameters(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        String name;
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        DeploymentConfigurationFactory.readConfigurationAnnotation(systemPropertyBaseClass, initParameters);
        ServletContext context = servletConfig.getServletContext();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, context.getInitParameter(name));
        }
        e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, servletConfig.getInitParameter(name));
        }
        DeploymentConfigurationFactory.readBuildInfo(initParameters);
        return initParameters;
    }

    private static void readBuildInfo(Properties initParameters) {
        String json = null;
        try {
            File tokenFile;
            String tokenLocation = initParameters.getProperty("vaadin.frontend.token.file");
            if (tokenLocation != null && (tokenFile = new File(tokenLocation)) != null && tokenFile.canRead()) {
                json = FileUtils.readFileToString((File)tokenFile, (String)"UTF-8");
            }
            if (json == null) {
                ArrayList<URL> resources = Collections.list(DeploymentConfiguration.class.getClassLoader().getResources("META-INF/VAADIN/config/flow-build-info.json"));
                URL resource = null;
                if (!resources.isEmpty()) {
                    resource = resources.stream().filter(url -> !JAR_REGEX.matcher(url.getPath()).find()).findFirst().orElse(null);
                }
                if (resource != null) {
                    json = FrontendUtils.streamToString(resource.openStream());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (json != null) {
            JsonObject buildInfo = (JsonObject)JsonUtil.parse(json);
            if (buildInfo.hasKey("productionMode")) {
                initParameters.setProperty("productionMode", String.valueOf(buildInfo.getBoolean("productionMode")));
                System.clearProperty("vaadin.productionMode");
            }
            if (buildInfo.hasKey("compatibilityMode")) {
                initParameters.setProperty("compatibilityMode", String.valueOf(buildInfo.getBoolean("compatibilityMode")));
                System.clearProperty("vaadin.compatibilityMode");
            }
            if (buildInfo.hasKey("npmFolder")) {
                initParameters.setProperty("project.basedir", buildInfo.getString("npmFolder"));
                DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("npmFolder"));
            }
            if (buildInfo.hasKey("frontendFolder")) {
                initParameters.setProperty("vaadin.frontend.frontend.folder", buildInfo.getString("frontendFolder"));
                if (!buildInfo.hasKey("npmFolder") || !buildInfo.getString("frontendFolder").startsWith(buildInfo.getString("npmFolder"))) {
                    DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("frontendFolder"));
                }
            }
            if (buildInfo.hasKey("enableDevServer")) {
                initParameters.setProperty("enableDevServer", String.valueOf(buildInfo.getBoolean("enableDevServer")));
            }
            if (buildInfo.hasKey("reuseDevServer")) {
                initParameters.setProperty("reuseDevServer", String.valueOf(buildInfo.getBoolean("reuseDevServer")));
            }
        }
        try {
            boolean hasWebPackConfig = DeploymentConfigurationFactory.hasWebpackConfig(initParameters);
            boolean hasTokenFile = json != null;
            SerializableConsumer strategy = value -> DeploymentConfigurationFactory.verifyMode(value, hasTokenFile, hasWebPackConfig);
            initParameters.put(DEV_MODE_ENABLE_STRATEGY, strategy);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void verifyFolderExists(Properties initParameters, String folder) {
        Boolean productionMode = Boolean.parseBoolean(initParameters.getProperty("productionMode", "false"));
        if (!productionMode.booleanValue() && !new File(folder).exists()) {
            String message = String.format(DEV_FOLDER_MISSING_MESSAGE, folder);
            throw new IllegalStateException(message);
        }
    }

    private static void verifyMode(CompatibilityModeStatus value, boolean hasTokenFile, boolean hasWebpackConfig) {
        if (value == CompatibilityModeStatus.UNDEFINED) {
            if (!hasWebpackConfig) {
                throw new IllegalStateException(ERROR_COMPATIBILITY_MODE_UNSET);
            }
        } else if (!hasTokenFile && !hasWebpackConfig) {
            throw new IllegalStateException(ERROR_DEV_MODE_NO_FILES);
        }
        if (!hasTokenFile && hasWebpackConfig) {
            LoggerFactory.getLogger(DeploymentConfigurationFactory.class).warn("Found 'webpack.config.js' in the project/working directory. Will use it for webpack dev server.");
        }
    }

    private static boolean hasWebpackConfig(Properties initParameters) throws IOException {
        String baseDir = initParameters.getProperty("project.basedir");
        File projectBaseDir = baseDir == null ? new File(".") : new File(baseDir);
        File webPackConfig = new File(projectBaseDir, "webpack.config.js");
        return FrontendUtils.isWebpackConfigFile(webPackConfig);
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }

    private static void readConfigurationAnnotation(Class<?> systemPropertyBaseClass, Properties initParameters) throws ServletException {
        Method[] methods;
        Optional<VaadinServletConfiguration> optionalConfigAnnotation = AnnotationReader.getAnnotationFor(systemPropertyBaseClass, VaadinServletConfiguration.class);
        if (!optionalConfigAnnotation.isPresent()) {
            return;
        }
        VaadinServletConfiguration configuration = optionalConfigAnnotation.get();
        for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
            VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
            assert (name != null) : "All methods declared in VaadinServletConfiguration should have a @InitParameterName annotation";
            try {
                Object value = method.invoke((Object)configuration, new Object[0]);
                String stringValue = value instanceof Class ? ((Class)value).getName() : value.toString();
                initParameters.setProperty(name.value(), stringValue);
            }
            catch (Exception e) {
                throw new ServletException("Could not read @VaadinServletConfiguration value " + method.getName(), (Throwable)e);
            }
        }
    }
}

