/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractDeploymentConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;

public class PropertyDeploymentConfiguration
extends AbstractDeploymentConfiguration {
    private final Properties initParameters;
    private final Class<?> systemPropertyBaseClass;

    public PropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, Properties initParameters) {
        this.initParameters = initParameters;
        this.systemPropertyBaseClass = systemPropertyBaseClass;
    }

    @Override
    public <T> T getApplicationOrSystemProperty(String propertyName, T defaultValue, Function<String, T> converter) {
        String val = this.getSystemProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        val = this.getApplicationProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        return defaultValue;
    }

    protected String getSystemProperty(String parameterName) {
        String className;
        int index;
        Package pkg = this.systemPropertyBaseClass.getPackage();
        String pkgName = pkg != null ? pkg.getName() : ((index = (className = this.systemPropertyBaseClass.getName()).lastIndexOf(46)) >= 0 ? className.substring(0, index) : null);
        if (pkgName == null) {
            pkgName = "";
        } else if (!pkgName.isEmpty()) {
            pkgName = pkgName + '.';
        }
        String val = System.getProperty(pkgName + parameterName);
        if (val != null) {
            return val;
        }
        val = System.getProperty(pkgName + parameterName.toLowerCase(Locale.ENGLISH));
        if (val != null) {
            return val;
        }
        val = System.getProperty("vaadin." + parameterName);
        return val;
    }

    public String getApplicationProperty(String parameterName) {
        String val = this.initParameters.getProperty(parameterName);
        if (val != null) {
            return val;
        }
        val = this.initParameters.getProperty(parameterName.toLowerCase());
        return val;
    }

    @Override
    public boolean isProductionMode() {
        return this.getBooleanProperty("productionMode", false);
    }

    @Override
    public boolean isBowerMode() {
        return this.getBooleanProperty("bowerMode", false);
    }

    @Override
    public boolean isCompatibilityMode() {
        String bower = this.getStringProperty("bowerMode", null);
        if (bower == null) {
            return this.getBooleanProperty("compatibilityMode", false);
        }
        return this.isBowerMode();
    }

    @Override
    public boolean isRequestTiming() {
        return this.getBooleanProperty("requestTiming", !this.isProductionMode());
    }

    @Override
    public boolean isXsrfProtectionEnabled() {
        return !this.getBooleanProperty("disable-xsrf-protection", false);
    }

    @Override
    public boolean isSyncIdCheckEnabled() {
        return this.getBooleanProperty("syncIdCheck", true);
    }

    @Override
    public int getHeartbeatInterval() {
        return 300;
    }

    @Override
    public int getWebComponentDisconnect() {
        return 300;
    }

    @Override
    public boolean isSendUrlsAsParameters() {
        return this.getBooleanProperty("sendUrlsAsParameters", true);
    }

    @Override
    public boolean isCloseIdleSessions() {
        return this.getBooleanProperty("closeIdleSessions", false);
    }

    @Override
    public PushMode getPushMode() {
        return PushMode.DISABLED;
    }

    @Override
    public String getPushURL() {
        return "";
    }

    @Override
    public Properties getInitParameters() {
        return this.initParameters;
    }
}

