/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String TARGET = "target/";
    public static final String DEFAULT_GENERATED_DIR = "target/frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    private static final String NOT_FOUND = "%n%n======================================================================================================%nFailed to determine '%s' tool.%nPlease install it either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v10.16.0\" %n======================================================================================================%n";
    private static final String SHOULD_WORK = "%n%n======================================================================================================%nYour installed '%s' version (%s) is not supported but should still work. Supported versions are %d.%d+%nYou can install a new one:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v10.16.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v11.6.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private static String operatingSystem = null;

    private FrontendUtils() {
    }

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String getNodeExecutable(String baseDir) {
        String command = FrontendUtils.isWindows() ? "node.exe" : "node";
        String defaultNode = FrontendUtils.isWindows() ? "node/node.exe" : "node/node";
        return FrontendUtils.getExecutable(baseDir, command, defaultNode).getAbsolutePath();
    }

    public static List<String> getNpmExecutable(String baseDir) {
        File file = new File(baseDir, "node/node_modules/npm/bin/npm-cli.js");
        if (file.canRead()) {
            return Arrays.asList(FrontendUtils.getNodeExecutable(baseDir), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "npm.cmd" : "npm";
        return Arrays.asList(FrontendUtils.getExecutable(baseDir, command, null).getAbsolutePath());
    }

    public static List<String> getBowerExecutable(String baseDir) {
        File file = new File(baseDir, "node_modules/bower/bin/bower");
        if (file.canRead()) {
            return Arrays.asList(FrontendUtils.getNodeExecutable(baseDir), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "bower.cmd" : "bower";
        return frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static File getExecutable(String baseDir, String cmd, String defaultLocation) {
        File file = null;
        try {
            file = defaultLocation == null ? (File)frontendToolsLocator.tryLocateTool(cmd).orElse(null) : Optional.of(new File(baseDir, defaultLocation)).filter(frontendToolsLocator::verifyTool).orElseGet(() -> frontendToolsLocator.tryLocateTool(cmd).orElse(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NOT_FOUND, cmd));
        }
        return file;
    }

    public static String streamToString(InputStream inputStream) {
        String ret = "";
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
            return ret;
        }
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get("PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put("PATH", path);
        }
        return processBuilder;
    }

    public static String getStatsContent(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        if (!config.isProductionMode() && config.enableDevServer()) {
            content = FrontendUtils.getStatsFromWebpack();
        }
        if (content == null) {
            content = FrontendUtils.getStatsFromClassPath(service);
        }
        return content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : null;
    }

    public static String getStatsHash(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            return FrontendUtils.streamToString(handler.prepareConnection("/stats.hash", "GET").getInputStream()).replaceAll("\"", "");
        }
        return "";
    }

    private static InputStream getStatsFromWebpack() throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        return handler.prepareConnection("/stats.json", "GET").getInputStream();
    }

    private static InputStream getStatsFromClassPath(VaadinService service) {
        String stats = service.getDeploymentConfiguration().getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        InputStream stream = service.getClassLoader().getResourceAsStream(stats);
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the 'stats.json' from the classpath '{}'", (Object)stats);
        }
        return stream;
    }

    public static String getStatsAssetsByChunkName(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            return FrontendUtils.streamToString(handler.prepareConnection("/assetsByChunkName", "GET").getInputStream());
        }
        String stats = config.getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        InputStream resourceAsStream = service.getClassLoader().getResourceAsStream(stats);
        try (Scanner scan = new Scanner(resourceAsStream, StandardCharsets.UTF_8.name());){
            StringBuilder assets = new StringBuilder();
            assets.append("{");
            FrontendUtils.scanToAssetChunkStart(scan, assets);
            while (scan.hasNextLine()) {
                String line = scan.nextLine().trim();
                if ("}".equals(line) || "},".equals(line)) {
                    String string = assets.append("}").toString();
                    return string;
                }
                if (line.endsWith("}") || line.endsWith("},")) {
                    String string = assets.append(line.substring(0, line.indexOf(125)).trim()).append("}").toString();
                    return string;
                }
                if (line.contains("{")) {
                    break;
                }
                assets.append(line);
            }
        }
        return null;
    }

    private static void scanToAssetChunkStart(Scanner scan, StringBuilder assets) {
        do {
            String line;
            if (!(line = scan.nextLine().trim()).startsWith("\"assetsByChunkName\"")) continue;
            if (line.endsWith("{")) break;
            assets.append(line.substring(line.indexOf(123) + 1).trim());
            break;
        } while (scan.hasNextLine());
    }

    public static void validateNodeAndNpmVersion(String baseDir) {
        try {
            ArrayList<String> nodeVersionCommand = new ArrayList<String>();
            nodeVersionCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            nodeVersionCommand.add("--version");
            String[] nodeVersion = FrontendUtils.getVersion("node", nodeVersionCommand);
            FrontendUtils.validateToolVersion("node", nodeVersion, 10, 0, 8, 9);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            ArrayList<String> npmVersionCommand = new ArrayList<String>();
            npmVersionCommand.addAll(FrontendUtils.getNpmExecutable(baseDir));
            npmVersionCommand.add("--version");
            String[] npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
            FrontendUtils.validateToolVersion("npm", npmVersion, 5, 6, 5, 5);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    public static boolean isWebpackConfigFile(File file) throws IOException {
        return file.exists() && FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("./webpack.generated.js");
    }

    static void validateToolVersion(String tool, String[] toolVersion, int supportedMajor, int supportedMinor, int shouldWorkMajor, int shouldWorkMinor) throws UnknownVersionException {
        if ("true".equalsIgnoreCase(System.getProperty(PARAM_IGNORE_VERSION_CHECKS))) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(tool, toolVersion, supportedMajor, supportedMinor)) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(tool, toolVersion, shouldWorkMajor, shouldWorkMinor)) {
            FrontendUtils.getLogger().warn(String.format(SHOULD_WORK, tool, String.join((CharSequence)".", toolVersion), supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS));
            return;
        }
        throw new IllegalStateException(String.format(TOO_OLD, tool, String.join((CharSequence)".", toolVersion), supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS));
    }

    static boolean isVersionAtLeast(String tool, String[] toolVersion, int requiredMajor, int requiredMinor) throws UnknownVersionException {
        try {
            int major = Integer.parseInt(toolVersion[0]);
            int minor = Integer.parseInt(toolVersion[1]);
            return major > requiredMajor || major == requiredMajor && minor >= requiredMinor;
        }
        catch (NumberFormatException e) {
            throw new UnknownVersionException(tool, "Reported version " + String.join((CharSequence)".", toolVersion) + " could not be parsed", e);
        }
    }

    private static String[] getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(versionCommand).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand));
            }
            String output = FrontendUtils.streamToString(process.getInputStream());
            return FrontendUtils.parseVersion(output);
        }
        catch (IOException | InterruptedException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    static String[] parseVersion(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "").split("\\.", 3)).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

