/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer.query;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.filter.Compare;
import com.vaadin.v7.data.util.sqlcontainer.ColumnProperty;
import com.vaadin.v7.data.util.sqlcontainer.OptimisticLockException;
import com.vaadin.v7.data.util.sqlcontainer.RowId;
import com.vaadin.v7.data.util.sqlcontainer.RowItem;
import com.vaadin.v7.data.util.sqlcontainer.SQLUtil;
import com.vaadin.v7.data.util.sqlcontainer.TemporaryRowId;
import com.vaadin.v7.data.util.sqlcontainer.connection.JDBCConnectionPool;
import com.vaadin.v7.data.util.sqlcontainer.query.AbstractTransactionalQuery;
import com.vaadin.v7.data.util.sqlcontainer.query.OrderBy;
import com.vaadin.v7.data.util.sqlcontainer.query.QueryDelegate;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.DefaultSQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.MSSQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.SQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.StatementHelper;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class TableQuery
extends AbstractTransactionalQuery
implements QueryDelegate,
QueryDelegate.RowIdChangeNotifier {
    private String tableName;
    private String catalogName;
    private String schemaName;
    private String fullTableName;
    private List<String> primaryKeyColumns;
    private String versionColumn;
    private List<Container.Filter> filters;
    private List<OrderBy> orderBys;
    private SQLGenerator sqlGenerator;
    private LinkedList<QueryDelegate.RowIdChangeListener> rowIdChangeListeners;
    private final List<RowIdChangeEvent> bufferedEvents = new ArrayList<RowIdChangeEvent>();
    private final boolean debug = false;

    public TableQuery(String tableName, JDBCConnectionPool connectionPool, SQLGenerator sqlGenerator) {
        this(null, null, tableName, connectionPool, sqlGenerator);
    }

    public TableQuery(String catalogName, String schemaName, String tableName, JDBCConnectionPool connectionPool, SQLGenerator sqlGenerator) {
        this(catalogName, schemaName, tableName, connectionPool, sqlGenerator, true);
    }

    public TableQuery(String tableName, JDBCConnectionPool connectionPool) {
        this(tableName, connectionPool, new DefaultSQLGenerator());
    }

    protected TableQuery(String catalogName, String schemaName, String tableName, JDBCConnectionPool connectionPool, SQLGenerator sqlGenerator, boolean escapeNames) {
        super(connectionPool);
        if (tableName == null || tableName.trim().length() < 1 || connectionPool == null || sqlGenerator == null) {
            throw new IllegalArgumentException("Table name, connection pool and SQL generator parameters must be non-null and non-empty.");
        }
        if (escapeNames) {
            this.catalogName = SQLUtil.escapeSQL(catalogName);
            this.schemaName = SQLUtil.escapeSQL(schemaName);
            this.tableName = SQLUtil.escapeSQL(tableName);
        } else {
            this.catalogName = catalogName;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }
        this.sqlGenerator = sqlGenerator;
        this.fetchMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() throws SQLException {
        TableQuery.getLogger().log(Level.FINE, "Fetching count...");
        StatementHelper sh = this.sqlGenerator.generateSelectQuery(this.getFullTableName(), this.filters, null, 0, 0, "COUNT(*)");
        boolean shouldCloseTransaction = false;
        if (!this.isInTransaction()) {
            shouldCloseTransaction = true;
            this.beginTransaction();
        }
        ResultSet r = null;
        int count = -1;
        try {
            r = this.executeQuery(sh);
            r.next();
            count = r.getInt(1);
        }
        finally {
            try {
                if (r != null) {
                    this.releaseConnection(null, r.getStatement(), r);
                }
            }
            finally {
                if (shouldCloseTransaction) {
                    this.commit();
                }
            }
        }
        return count;
    }

    @Override
    public ResultSet getResults(int offset, int pagelength) throws SQLException {
        StatementHelper sh;
        if (this.orderBys == null || this.orderBys.isEmpty()) {
            ArrayList<OrderBy> ob = new ArrayList<OrderBy>();
            for (int i = 0; i < this.primaryKeyColumns.size(); ++i) {
                ob.add(new OrderBy(this.primaryKeyColumns.get(i), true));
            }
            sh = this.sqlGenerator.generateSelectQuery(this.getFullTableName(), this.filters, ob, offset, pagelength, null);
        } else {
            sh = this.sqlGenerator.generateSelectQuery(this.getFullTableName(), this.filters, this.orderBys, offset, pagelength, null);
        }
        return this.executeQuery(sh);
    }

    @Override
    public boolean implementationRespectsPagingLimits() {
        return true;
    }

    @Override
    public int storeRow(RowItem row) throws UnsupportedOperationException, SQLException {
        if (row == null) {
            throw new IllegalArgumentException("Row argument must be non-null.");
        }
        int result = 0;
        if (row.getId() instanceof TemporaryRowId) {
            this.setVersionColumnFlagInProperty(row);
            StatementHelper sh = this.sqlGenerator.generateInsertQuery(this.getFullTableName(), row);
            result = this.executeUpdateReturnKeys(sh, row);
        } else {
            this.setVersionColumnFlagInProperty(row);
            StatementHelper sh = this.sqlGenerator.generateUpdateQuery(this.getFullTableName(), row);
            result = this.executeUpdate(sh);
        }
        if (this.versionColumn != null && result == 0) {
            throw new OptimisticLockException("Someone else changed the row that was being updated.", row.getId());
        }
        return result;
    }

    private void setVersionColumnFlagInProperty(RowItem row) {
        ColumnProperty versionProperty = (ColumnProperty)row.getItemProperty(this.versionColumn);
        if (versionProperty != null) {
            versionProperty.setVersionColumn(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowId storeRowImmediately(RowItem row) throws SQLException {
        RowId rowId;
        this.beginTransaction();
        this.setVersionColumnFlagInProperty(row);
        StatementHelper sh = this.sqlGenerator.generateInsertQuery(this.getFullTableName(), row);
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet generatedKeys = null;
        connection = this.getConnection();
        try {
            pstmt = connection.prepareStatement(sh.getQueryString(), this.primaryKeyColumns.toArray(new String[0]));
            sh.setParameterValuesToStatement(pstmt);
            TableQuery.getLogger().log(Level.FINE, "DB -> {0}", sh.getQueryString());
            int result = pstmt.executeUpdate();
            RowId newId = null;
            if (result > 0) {
                generatedKeys = pstmt.getGeneratedKeys();
                newId = this.getNewRowId(row, generatedKeys);
            }
            this.commit();
            rowId = newId;
        }
        catch (Throwable throwable) {
            this.releaseConnection(connection, pstmt, generatedKeys);
            throw throwable;
        }
        this.releaseConnection(connection, pstmt, generatedKeys);
        return rowId;
    }

    @Override
    public void setFilters(List<Container.Filter> filters) throws UnsupportedOperationException {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = Collections.unmodifiableList(filters);
    }

    @Override
    public void setOrderBy(List<OrderBy> orderBys) throws UnsupportedOperationException {
        if (orderBys == null) {
            this.orderBys = null;
            return;
        }
        this.orderBys = Collections.unmodifiableList(orderBys);
    }

    @Override
    public void beginTransaction() throws UnsupportedOperationException, SQLException {
        TableQuery.getLogger().log(Level.FINE, "DB -> begin transaction");
        super.beginTransaction();
    }

    @Override
    public void commit() throws UnsupportedOperationException, SQLException {
        TableQuery.getLogger().log(Level.FINE, "DB -> commit");
        super.commit();
        RowIdChangeEvent[] unFiredEvents = this.bufferedEvents.toArray(new RowIdChangeEvent[0]);
        this.bufferedEvents.clear();
        if (this.rowIdChangeListeners != null && !this.rowIdChangeListeners.isEmpty()) {
            for (QueryDelegate.RowIdChangeListener r : this.rowIdChangeListeners) {
                for (RowIdChangeEvent e : unFiredEvents) {
                    r.rowIdChange(e);
                }
            }
        }
    }

    @Override
    public void rollback() throws UnsupportedOperationException, SQLException {
        TableQuery.getLogger().log(Level.FINE, "DB -> rollback");
        super.rollback();
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return Collections.unmodifiableList(this.primaryKeyColumns);
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String column) {
        this.versionColumn = column;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected String getFullTableName() {
        if (this.fullTableName == null) {
            StringBuilder sb = new StringBuilder();
            if (this.catalogName != null) {
                sb.append(this.catalogName).append('.');
            }
            if (this.schemaName != null) {
                sb.append(this.schemaName).append('.');
            }
            sb.append(this.tableName);
            this.fullTableName = sb.toString();
        }
        return this.fullTableName;
    }

    public SQLGenerator getSqlGenerator() {
        return this.sqlGenerator;
    }

    private ResultSet executeQuery(StatementHelper sh) throws SQLException {
        this.ensureTransaction();
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(sh.getQueryString());
            sh.setParameterValuesToStatement(pstmt);
            TableQuery.getLogger().log(Level.FINE, "DB -> {0}", sh.getQueryString());
            return pstmt.executeQuery();
        }
        catch (SQLException e) {
            this.releaseConnection(null, pstmt, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(StatementHelper sh) throws SQLException {
        int n;
        PreparedStatement pstmt = null;
        Connection connection = null;
        try {
            int retval;
            connection = this.getConnection();
            pstmt = connection.prepareStatement(sh.getQueryString());
            sh.setParameterValuesToStatement(pstmt);
            TableQuery.getLogger().log(Level.FINE, "DB -> {0}", sh.getQueryString());
            n = retval = pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(connection, pstmt, null);
            throw throwable;
        }
        this.releaseConnection(connection, pstmt, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateReturnKeys(StatementHelper sh, RowItem row) throws SQLException {
        int n;
        PreparedStatement pstmt = null;
        ResultSet genKeys = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            pstmt = connection.prepareStatement(sh.getQueryString(), this.primaryKeyColumns.toArray(new String[0]));
            sh.setParameterValuesToStatement(pstmt);
            TableQuery.getLogger().log(Level.FINE, "DB -> {0}", sh.getQueryString());
            int result = pstmt.executeUpdate();
            genKeys = pstmt.getGeneratedKeys();
            RowId newId = this.getNewRowId(row, genKeys);
            this.bufferedEvents.add(new RowIdChangeEvent(row.getId(), newId));
            n = result;
        }
        catch (Throwable throwable) {
            this.releaseConnection(connection, pstmt, genKeys);
            throw throwable;
        }
        this.releaseConnection(connection, pstmt, genKeys);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void fetchMetaData() {
        Connection connection = null;
        ResultSet rs = null;
        ResultSet tables = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData dbmd = connection.getMetaData();
            if (dbmd != null) {
                tables = dbmd.getTables(this.catalogName, this.schemaName, this.tableName, null);
                if (!tables.next()) {
                    String schema;
                    String catalog = this.catalogName != null ? this.catalogName.toUpperCase(Locale.ROOT) : null;
                    tables = dbmd.getTables(catalog, schema = this.schemaName != null ? this.schemaName.toUpperCase(Locale.ROOT) : null, this.tableName.toUpperCase(Locale.ROOT), null);
                    if (!tables.next()) {
                        throw new IllegalArgumentException("Table with the name \"" + this.getFullTableName() + "\" was not found. Check your database contents.");
                    }
                    this.catalogName = catalog;
                    this.schemaName = schema;
                    this.tableName = this.tableName.toUpperCase(Locale.ROOT);
                }
                tables.close();
                rs = dbmd.getPrimaryKeys(this.catalogName, this.schemaName, this.tableName);
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                if (!names.isEmpty()) {
                    this.primaryKeyColumns = names;
                }
                if (this.primaryKeyColumns == null || this.primaryKeyColumns.isEmpty()) {
                    throw new IllegalArgumentException("Primary key constraints have not been defined for the table \"" + this.getFullTableName() + "\". Use FreeFormQuery to access this table.");
                }
                for (String colName : this.primaryKeyColumns) {
                    if (!colName.equalsIgnoreCase("rownum") || !(this.getSqlGenerator() instanceof MSSQLGenerator) && !(this.getSqlGenerator() instanceof MSSQLGenerator)) continue;
                    throw new IllegalArgumentException("When using Oracle or MSSQL, a primary key column named 'rownum' is not allowed!");
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            block36: {
                this.releaseConnection(connection, null, rs);
                try {
                    if (tables != null) {
                        tables.close();
                    }
                    break block36;
                }
                catch (SQLException sQLException) {}
                break block36;
                catch (SQLException sQLException) {
                    try {
                        if (tables != null) {
                            tables.close();
                        }
                    }
                    catch (SQLException sQLException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (tables != null) {
                                tables.close();
                            }
                        }
                        catch (SQLException sQLException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    private RowId getNewRowId(RowItem row, ResultSet genKeys) {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            ResultSetMetaData rsmd = genKeys.getMetaData();
            int colCount = rsmd.getColumnCount();
            if (genKeys.next()) {
                for (int i = 1; i <= colCount; ++i) {
                    values.put(rsmd.getColumnName(i), genKeys.getObject(i));
                }
            }
            ArrayList newRowId = new ArrayList();
            if (values.size() == 1) {
                if (this.primaryKeyColumns.size() == 1) {
                    newRowId.add(values.get(values.keySet().iterator().next()));
                } else {
                    for (String s : this.primaryKeyColumns) {
                        if (!((ColumnProperty)row.getItemProperty(s)).isReadOnlyChangeAllowed()) {
                            newRowId.add(values.get(values.keySet().iterator().next()));
                            continue;
                        }
                        newRowId.add(values.get(s));
                    }
                }
            } else {
                for (String s : this.primaryKeyColumns) {
                    newRowId.add(values.get(s));
                }
            }
            return new RowId(newRowId.toArray());
        }
        catch (Exception e) {
            TableQuery.getLogger().log(Level.FINE, "Failed to fetch key values on insert: {0}", e.getMessage());
            return null;
        }
    }

    @Override
    public boolean removeRow(RowItem row) throws UnsupportedOperationException, SQLException {
        if (TableQuery.getLogger().isLoggable(Level.FINE)) {
            TableQuery.getLogger().log(Level.FINE, "Removing row with id: {0}", row.getId().getId()[0]);
        }
        if (this.executeUpdate(this.sqlGenerator.generateDeleteQuery(this.getFullTableName(), this.primaryKeyColumns, this.versionColumn, row)) == 1) {
            return true;
        }
        if (this.versionColumn != null) {
            throw new OptimisticLockException("Someone else changed the row that was being deleted.", row.getId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsRowWithKey(Object ... keys) throws SQLException {
        ArrayList<Container.Filter> filtersAndKeys = new ArrayList<Container.Filter>();
        if (this.filters != null) {
            filtersAndKeys.addAll(this.filters);
        }
        int ix = 0;
        for (String colName : this.primaryKeyColumns) {
            filtersAndKeys.add(new Compare.Equal(colName, keys[ix]));
            ++ix;
        }
        StatementHelper sh = this.sqlGenerator.generateSelectQuery(this.getFullTableName(), filtersAndKeys, this.orderBys, 0, 0, "*");
        boolean shouldCloseTransaction = false;
        if (!this.isInTransaction()) {
            shouldCloseTransaction = true;
            this.beginTransaction();
        }
        ResultSet rs = null;
        try {
            boolean contains;
            rs = this.executeQuery(sh);
            boolean bl = contains = rs.next();
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    this.releaseConnection(null, rs.getStatement(), rs);
                }
            }
            finally {
                if (shouldCloseTransaction) {
                    this.commit();
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        out.defaultWriteObject();
    }

    @Override
    public void addRowIdChangeListener(QueryDelegate.RowIdChangeListener listener) {
        if (this.rowIdChangeListeners == null) {
            this.rowIdChangeListeners = new LinkedList();
        }
        this.rowIdChangeListeners.add(listener);
    }

    @Override
    @Deprecated
    public void addListener(QueryDelegate.RowIdChangeListener listener) {
        this.addRowIdChangeListener(listener);
    }

    @Override
    public void removeRowIdChangeListener(QueryDelegate.RowIdChangeListener listener) {
        if (this.rowIdChangeListeners != null) {
            this.rowIdChangeListeners.remove(listener);
        }
    }

    @Override
    @Deprecated
    public void removeListener(QueryDelegate.RowIdChangeListener listener) {
        this.removeRowIdChangeListener(listener);
    }

    private static final Logger getLogger() {
        return Logger.getLogger(TableQuery.class.getName());
    }

    @Deprecated
    public static class RowIdChangeEvent
    extends EventObject
    implements QueryDelegate.RowIdChangeEvent {
        private final RowId oldId;
        private final RowId newId;

        private RowIdChangeEvent(RowId oldId, RowId newId) {
            super(oldId);
            this.oldId = oldId;
            this.newId = newId;
        }

        @Override
        public RowId getNewRowId() {
            return this.newId;
        }

        @Override
        public RowId getOldRowId() {
            return this.oldId;
        }
    }
}

