/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.server.Resource;
import com.vaadin.util.FileTypeResolver;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.MethodProperty;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class FilesystemContainer
implements Container.Hierarchical {
    public static String PROPERTY_NAME = "Name";
    public static String PROPERTY_SIZE = "Size";
    public static String PROPERTY_ICON = "Icon";
    public static String PROPERTY_LASTMODIFIED = "Last Modified";
    public static Collection<String> FILE_PROPERTIES = new ArrayList<String>();
    private static final Method FILEITEM_LASTMODIFIED;
    private static final Method FILEITEM_NAME;
    private static final Method FILEITEM_ICON;
    private static final Method FILEITEM_SIZE;
    private File[] roots = new File[0];
    private FilenameFilter filter = null;
    private boolean recursive = true;

    public FilesystemContainer(File root) {
        if (root != null) {
            this.roots = new File[]{root};
        }
    }

    public FilesystemContainer(File root, boolean recursive) {
        this(root);
        this.setRecursive(recursive);
    }

    public FilesystemContainer(File root, String extension, boolean recursive) {
        this(root);
        this.setFilter(extension);
        this.setRecursive(recursive);
    }

    public FilesystemContainer(File root, FilenameFilter filter, boolean recursive) {
        this(root);
        this.setFilter(filter);
        this.setRecursive(recursive);
    }

    public void addRoot(File root) {
        if (root != null) {
            File[] newRoots = new File[this.roots.length + 1];
            for (int i = 0; i < this.roots.length; ++i) {
                newRoots[i] = this.roots[i];
            }
            newRoots[this.roots.length] = root;
            this.roots = newRoots;
        }
    }

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        return itemId instanceof File && ((File)itemId).canRead() && ((File)itemId).isDirectory();
    }

    public Collection<File> getChildren(Object itemId) {
        if (!(itemId instanceof File)) {
            return Collections.unmodifiableCollection(new LinkedList());
        }
        File[] f = this.filter != null ? ((File)itemId).listFiles(this.filter) : ((File)itemId).listFiles();
        if (f == null) {
            return Collections.unmodifiableCollection(new LinkedList());
        }
        List<File> l = Arrays.asList(f);
        Collections.sort(l);
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public Object getParent(Object itemId) {
        if (!(itemId instanceof File)) {
            return null;
        }
        return ((File)itemId).getParentFile();
    }

    @Override
    public boolean hasChildren(Object itemId) {
        if (!(itemId instanceof File)) {
            return false;
        }
        String[] l = this.filter != null ? ((File)itemId).list(this.filter) : ((File)itemId).list();
        return l != null && l.length > 0;
    }

    @Override
    public boolean isRoot(Object itemId) {
        if (!(itemId instanceof File)) {
            return false;
        }
        for (File root : this.roots) {
            if (!root.equals(itemId)) continue;
            return true;
        }
        return false;
    }

    public Collection<File> rootItemIds() {
        File[] f = this.roots.length == 1 ? (this.filter != null ? this.roots[0].listFiles(this.filter) : this.roots[0].listFiles()) : this.roots;
        if (f == null) {
            return Collections.unmodifiableCollection(new LinkedList());
        }
        List<File> l = Arrays.asList(f);
        Collections.sort(l);
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Conversion file to/from directory is not supported");
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File moving is not supported");
    }

    @Override
    public boolean containsId(Object itemId) {
        if (!(itemId instanceof File)) {
            return false;
        }
        boolean val = false;
        for (File root : this.roots) {
            try {
                val |= ((File)itemId).getCanonicalPath().startsWith(root.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (val && this.filter != null) {
            val &= this.filter.accept(((File)itemId).getParentFile(), ((File)itemId).getName());
        }
        return val;
    }

    @Override
    public Item getItem(Object itemId) {
        if (!(itemId instanceof File)) {
            return null;
        }
        return new FileItem((File)itemId);
    }

    private void addItemIds(Collection<File> col, File f) {
        File[] l = this.filter != null ? f.listFiles(this.filter) : f.listFiles();
        if (l == null) {
            return;
        }
        List<File> ll = Arrays.asList(l);
        Collections.sort(ll);
        for (File lf : ll) {
            col.add(lf);
            if (!lf.isDirectory()) continue;
            this.addItemIds(col, lf);
        }
    }

    public Collection<File> getItemIds() {
        if (this.recursive) {
            ArrayList<File> col = new ArrayList<File>();
            for (File root : this.roots) {
                this.addItemIds(col, root);
            }
            return Collections.unmodifiableCollection(col);
        }
        File[] f = this.roots.length == 1 ? (this.filter != null ? this.roots[0].listFiles(this.filter) : this.roots[0].listFiles()) : this.roots;
        if (f == null) {
            return Collections.unmodifiableCollection(new LinkedList());
        }
        List<File> l = Arrays.asList(f);
        Collections.sort(l);
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        if (!(itemId instanceof File)) {
            return null;
        }
        if (propertyId.equals(PROPERTY_NAME)) {
            return new MethodProperty(this.getType(propertyId), (Object)new FileItem((File)itemId), FILEITEM_NAME, null);
        }
        if (propertyId.equals(PROPERTY_ICON)) {
            return new MethodProperty(this.getType(propertyId), (Object)new FileItem((File)itemId), FILEITEM_ICON, null);
        }
        if (propertyId.equals(PROPERTY_SIZE)) {
            return new MethodProperty(this.getType(propertyId), (Object)new FileItem((File)itemId), FILEITEM_SIZE, null);
        }
        if (propertyId.equals(PROPERTY_LASTMODIFIED)) {
            return new MethodProperty(this.getType(propertyId), (Object)new FileItem((File)itemId), FILEITEM_LASTMODIFIED, null);
        }
        return null;
    }

    public Collection<String> getContainerPropertyIds() {
        return FILE_PROPERTIES;
    }

    @Override
    public Class<?> getType(Object propertyId) {
        if (propertyId.equals(PROPERTY_NAME)) {
            return String.class;
        }
        if (propertyId.equals(PROPERTY_ICON)) {
            return Resource.class;
        }
        if (propertyId.equals(PROPERTY_SIZE)) {
            return Long.class;
        }
        if (propertyId.equals(PROPERTY_LASTMODIFIED)) {
            return Date.class;
        }
        return null;
    }

    private int getFileCounts(File directory) {
        File[] l = this.filter != null ? directory.listFiles(this.filter) : directory.listFiles();
        if (l == null) {
            return 0;
        }
        int ret = l.length;
        for (File f : l) {
            if (!f.isDirectory()) continue;
            ret += this.getFileCounts(f);
        }
        return ret;
    }

    @Override
    public int size() {
        if (this.recursive) {
            int counts = 0;
            for (File f : this.roots) {
                counts += this.getFileCounts(f);
            }
            return counts;
        }
        File[] f = this.roots.length == 1 ? (this.filter != null ? this.roots[0].listFiles(this.filter) : this.roots[0].listFiles()) : this.roots;
        if (f == null) {
            return 0;
        }
        return f.length;
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public void setFilter(String extension) {
        this.filter = new FileExtensionFilter(extension);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("File system container does not support this operation");
    }

    static {
        FILE_PROPERTIES.add(PROPERTY_NAME);
        FILE_PROPERTIES.add(PROPERTY_ICON);
        FILE_PROPERTIES.add(PROPERTY_SIZE);
        FILE_PROPERTIES.add(PROPERTY_LASTMODIFIED);
        FILE_PROPERTIES = Collections.unmodifiableCollection(FILE_PROPERTIES);
        try {
            FILEITEM_LASTMODIFIED = FileItem.class.getMethod("lastModified", new Class[0]);
            FILEITEM_NAME = FileItem.class.getMethod("getName", new Class[0]);
            FILEITEM_ICON = FileItem.class.getMethod("getIcon", new Class[0]);
            FILEITEM_SIZE = FileItem.class.getMethod("getSize", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in FilesystemContainer");
        }
    }

    @Deprecated
    public class FileExtensionFilter
    implements FilenameFilter,
    Serializable {
        private final String filter;

        public FileExtensionFilter(String fileExtension) {
            this.filter = "." + fileExtension;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.endsWith(this.filter)) {
                return true;
            }
            return new File(dir, name).isDirectory();
        }
    }

    @Deprecated
    public class FileItem
    implements Item {
        private final File file;

        private FileItem(File file) {
            this.file = file;
        }

        @Override
        public Property getItemProperty(Object id) {
            return FilesystemContainer.this.getContainerProperty(this.file, id);
        }

        public Collection<String> getItemPropertyIds() {
            return FilesystemContainer.this.getContainerPropertyIds();
        }

        public int hashCode() {
            return this.file.hashCode() ^ FilesystemContainer.this.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileItem)) {
                return false;
            }
            FileItem fi = (FileItem)obj;
            return fi.getHost() == this.getHost() && fi.file.equals(this.file);
        }

        private FilesystemContainer getHost() {
            return FilesystemContainer.this;
        }

        public Date lastModified() {
            return new Date(this.file.lastModified());
        }

        public String getName() {
            return this.file.getName();
        }

        public Resource getIcon() {
            return FileTypeResolver.getIcon((File)this.file);
        }

        public long getSize() {
            if (this.file.isDirectory()) {
                return 0L;
            }
            return this.file.length();
        }

        public String toString() {
            if ("".equals(this.file.getName())) {
                return this.file.getAbsolutePath();
            }
            return this.file.getName();
        }

        @Override
        public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Filesystem container does not support adding new properties");
        }

        @Override
        public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Filesystem container does not support property removal");
        }
    }
}

