/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer.query;

import com.vaadin.v7.data.util.sqlcontainer.connection.JDBCConnectionPool;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

@Deprecated
public abstract class AbstractTransactionalQuery
implements Serializable {
    private JDBCConnectionPool connectionPool;
    private transient Connection activeConnection;

    AbstractTransactionalQuery() {
    }

    AbstractTransactionalQuery(JDBCConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void beginTransaction() throws UnsupportedOperationException, SQLException {
        if (this.isInTransaction()) {
            throw new IllegalStateException("A transaction is already active!");
        }
        this.activeConnection = this.connectionPool.reserveConnection();
        this.activeConnection.setAutoCommit(false);
    }

    public void commit() throws UnsupportedOperationException, SQLException {
        if (!this.isInTransaction()) {
            throw new SQLException("No active transaction");
        }
        if (!this.activeConnection.getAutoCommit()) {
            this.activeConnection.commit();
        }
        this.connectionPool.releaseConnection(this.activeConnection);
        this.activeConnection = null;
    }

    public void rollback() throws UnsupportedOperationException, SQLException {
        if (!this.isInTransaction()) {
            throw new SQLException("No active transaction");
        }
        this.activeConnection.rollback();
        this.connectionPool.releaseConnection(this.activeConnection);
        this.activeConnection = null;
    }

    protected void ensureTransaction() throws SQLException {
        if (!this.isInTransaction()) {
            throw new SQLException("No active transaction!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(Connection conn, Statement statement, ResultSet rs) throws SQLException {
        try {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            finally {
                if (null != statement) {
                    if (statement instanceof PreparedStatement) {
                        try {
                            ((PreparedStatement)statement).clearParameters();
                        }
                        catch (Exception exception) {}
                    }
                    statement.close();
                }
            }
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.activeConnection != null) {
            return this.activeConnection;
        }
        return this.connectionPool.reserveConnection();
    }

    protected boolean isInTransaction() {
        return this.activeConnection != null;
    }

    private void releaseConnection(Connection conn) {
        if (conn != this.activeConnection && conn != null) {
            this.connectionPool.releaseConnection(conn);
        }
    }
}

