var pt=(o,e)=>()=>(e||o((e={exports:{}}).exports,e),e.exports);import{w as wrap$e,m as microTask,d as calculateSplices,b as PolymerElement,R as ResizeMixin,E as ElementMixin,h as html,e as beforeNextRender,g as get}from"./generated-flow-imports-TP-MceYD.js";import{i,a as registerStyles,d as defineCustomElement,T as ThemableMixin}from"./indexhtml-CjDE4kOg.js";var ft=pt(exports=>{/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(o){o.SVG_NS="http://www.w3.org/2000/svg",o.product="Highcharts",o.version="9.2.2",o.win=w,o.doc=o.win.document,o.svg=o.doc&&o.doc.createElementNS&&!!o.doc.createElementNS(o.SVG_NS,"svg").createSVGRect,o.userAgent=o.win.navigator&&o.win.navigator.userAgent||"",o.isChrome=o.userAgent.indexOf("Chrome")!==-1,o.isFirefox=o.userAgent.indexOf("Firefox")!==-1,o.isMS=/(edge|msie|trident)/i.test(o.userAgent)&&!o.win.opera,o.isSafari=!o.isChrome&&o.userAgent.indexOf("Safari")!==-1,o.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(o.userAgent),o.isWebKit=o.userAgent.indexOf("AppleWebKit")!==-1,o.deg2rad=Math.PI*2/360,o.hasBidiBug=o.isFirefox&&parseInt(o.userAgent.split("Firefox/")[1],10)<4,o.hasTouch=!!o.win.TouchEvent,o.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],o.noop=function(){},o.supportsPassiveEvents=function(){var e=!1;if(!o.isMS){var t=Object.defineProperty({},"passive",{get:function(){e=!0}});o.win.addEventListener&&o.win.removeEventListener&&(o.win.addEventListener("testPassive",o.noop,t),o.win.removeEventListener("testPassive",o.noop,t))}return e}(),o.charts=[],o.dateFormats={},o.seriesTypes={},o.symbolSizes={},o.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$a(o,e,t,r){var n=e?"Highcharts error":"Highcharts warning";o===32&&(o=n+": Deprecated member");var s=isNumber$R(o),a=s?n+" #"+o+": www.highcharts.com/errors/"+o+"/":o.toString(),l=function(){if(e)throw new Error(a);win$g.console&&error$a.messages.indexOf(a)===-1&&console.warn(a)};if(typeof r<"u"){var h="";s&&(a+="?"),objectEach$B(r,function(c,d){h+=`
 - `+d+": "+c,s&&(a+=encodeURI(d)+"="+encodeURI(c))}),a+=h}fireEvent$B(H,"displayError",{chart:t,code:o,message:a,params:r},l),error$a.messages.push(a)}(function(o){o.messages=[]})(error$a||(error$a={}));function merge$1p(){var o,e=arguments,t={},r=function(s,a){return typeof s!="object"&&(s={}),objectEach$B(a,function(l,h){h==="__proto__"||h==="constructor"||(isObject$f(l,!0)&&!isClass(l)&&!isDOMElement(l)?s[h]=r(s[h]||{},l):s[h]=a[h])}),s};e[0]===!0&&(t=e[1],e=Array.prototype.slice.call(e,2));var n=e.length;for(o=0;o<n;o++)t=r(t,e[o]);return t}function clamp$j(o,e,t){return o>e?o<t?o:t:e}function cleanRecursively$2(o,e){var t={};return objectEach$B(o,function(r,n){var s;isObject$f(o[n],!0)&&!o.nodeType&&e[n]?(s=cleanRecursively$2(o[n],e[n]),Object.keys(s).length&&(t[n]=s)):(isObject$f(o[n])||o[n]!==e[n])&&(t[n]=o[n])}),t}function pInt$a(o,e){return parseInt(o,e||10)}function isString$c(o){return typeof o=="string"}function isArray$n(o){var e=Object.prototype.toString.call(o);return e==="[object Array]"||e==="[object Array Iterator]"}function isObject$f(o,e){return!!o&&typeof o=="object"&&(!e||!isArray$n(o))}function isDOMElement(o){return isObject$f(o)&&typeof o.nodeType=="number"}function isClass(o){var e=o&&o.constructor;return!!(isObject$f(o,!0)&&!isDOMElement(o)&&e&&e.name&&e.name!=="Object")}function isNumber$R(o){return typeof o=="number"&&!isNaN(o)&&o<1/0&&o>-1/0}function erase$9(o,e){for(var t=o.length;t--;)if(o[t]===e){o.splice(t,1);break}}function defined$W(o){return typeof o<"u"&&o!==null}function attr$8(o,e,t){var r;return isString$c(e)?defined$W(t)?o.setAttribute(e,t):o&&o.getAttribute&&(r=o.getAttribute(e),!r&&e==="class"&&(r=o.getAttribute(e+"Name"))):objectEach$B(e,function(n,s){o.setAttribute(s,n)}),r}function splat$j(o){return isArray$n(o)?o:[o]}function syncTimeout$9(o,e,t){return e>0?setTimeout(o,e,t):(o.call(0,t),-1)}function internalClearTimeout(o){defined$W(o)&&clearTimeout(o)}function extend$1q(o,e){var t;o||(o={});for(t in e)o[t]=e[t];return o}function pick$1B(){for(var o=arguments,e=o.length,t=0;t<e;t++){var r=o[t];if(typeof r<"u"&&r!==null)return r}}function css$d(o,e){H.isMS&&!H.svg&&e&&typeof e.opacity<"u"&&(e.filter="alpha(opacity="+e.opacity*100+")"),extend$1q(o.style,e)}function createElement$b(o,e,t,r,n){var s=doc$m.createElement(o);return e&&extend$1q(s,e),n&&css$d(s,{padding:"0",border:"none",margin:"0"}),t&&css$d(s,t),r&&r.appendChild(s),s}function extendClass$2(o,e){var t=function(){};return t.prototype=new o,extend$1q(t.prototype,e),t}function pad$2(o,e,t){return new Array((e||2)+1-String(o).replace("-","").length).join(t||"0")+o}function relativeLength$a(o,e,t){return/%$/.test(o)?e*parseFloat(o)/100+(t||0):parseFloat(o)}function wrap$d(o,e,t){var r=o[e];o[e]=function(){var n=Array.prototype.slice.call(arguments),s=arguments,a=this;a.proceed=function(){r.apply(a,arguments.length?arguments:s)},n.unshift(r);var l=t.apply(this,n);return a.proceed=null,l}}function getMagnitude$3(o){return Math.pow(10,Math.floor(Math.log(o)/Math.LN10))}function normalizeTickInterval$3(o,e,t,r,n){var s,a=o;t=pick$1B(t,1);var l=o/t;for(e||(e=n?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],r===!1&&(t===1?e=e.filter(function(h){return h%1===0}):t<=.1&&(e=[1/t]))),s=0;s<e.length&&(a=e[s],!(n&&a*t>=o||!n&&l<=(e[s]+(e[s+1]||e[s]))/2));s++);return a=correctFloat$d(a*t,-Math.round(Math.log(.001)/Math.LN10)),a}function stableSort$7(o,e){var t=o.length,r,n;for(n=0;n<t;n++)o[n].safeI=n;for(o.sort(function(s,a){return r=e(s,a),r===0?s.safeI-a.safeI:r}),n=0;n<t;n++)delete o[n].safeI}function arrayMin$9(o){for(var e=o.length,t=o[0];e--;)o[e]<t&&(t=o[e]);return t}function arrayMax$a(o){for(var e=o.length,t=o[0];e--;)o[e]>t&&(t=o[e]);return t}function destroyObjectProperties$a(o,e){objectEach$B(o,function(t,r){t&&t!==e&&t.destroy&&t.destroy(),delete o[r]})}function discardElement$7(o){garbageBin||(garbageBin=createElement$b("div")),o&&garbageBin.appendChild(o),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(o,e){return parseFloat(o.toPrecision(e||14))}var timeUnits$3={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:7*24*36e5,month:28*24*36e5,year:364*24*36e5};Math.easeInOutSine=function(o){return-.5*(Math.cos(Math.PI*o)-1)};function getNestedProperty$3(o,e){for(var t=o.split(".");t.length&&defined$W(e);){var r=t.shift();if(typeof r>"u"||r==="__proto__")return;var n=e[r];if(!defined$W(n)||typeof n=="function"||typeof n.nodeType=="number"||n===win$g)return;e=n}return e}function getStyle$2(o,e,t){var r=H.getStyle||getStyle$2,n;if(e==="width"){var s=Math.min(o.offsetWidth,o.scrollWidth),a=o.getBoundingClientRect&&o.getBoundingClientRect().width;return a<s&&a>=s-1&&(s=Math.floor(a)),Math.max(0,s-(r(o,"padding-left",!0)||0)-(r(o,"padding-right",!0)||0))}if(e==="height")return Math.max(0,Math.min(o.offsetHeight,o.scrollHeight)-(r(o,"padding-top",!0)||0)-(r(o,"padding-bottom",!0)||0));win$g.getComputedStyle||error$a(27,!0);var l=win$g.getComputedStyle(o,void 0);return l&&(n=l.getPropertyValue(e),pick$1B(t,e!=="opacity")&&(n=pInt$a(n))),n}function inArray(o,e,t){return error$a(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),e.indexOf(o,t)}var find$j=Array.prototype.find?function(o,e){return o.find(e)}:function(o,e){var t,r=o.length;for(t=0;t<r;t++)if(e(o[t],t))return o[t]};function keys(o){return error$a(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(o)}function offset$1(o){var e=doc$m.documentElement,t=o.parentElement||o.parentNode?o.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:t.top+(win$g.pageYOffset||e.scrollTop)-(e.clientTop||0),left:t.left+(win$g.pageXOffset||e.scrollLeft)-(e.clientLeft||0),width:t.width,height:t.height}}function objectEach$B(o,e,t){for(var r in o)Object.hasOwnProperty.call(o,r)&&e.call(t||o[r],o[r],r,o)}objectEach$B({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(o,e){H[e]=function(t){var r;return error$a(32,!1,void 0,(r={},r["Highcharts."+e]="use Array."+o,r)),Array.prototype[o].apply(t,[].slice.call(arguments,1))}});function addEvent$12(o,e,t,r){r===void 0&&(r={});var n=typeof o=="function"&&o.prototype||o;Object.hasOwnProperty.call(n,"hcEvents")||(n.hcEvents={});var s=n.hcEvents;H.Point&&o instanceof H.Point&&o.series&&o.series.chart&&(o.series.chart.runTrackerClick=!0);var a=o.addEventListener||H.addEventListenerPolyfill;a&&a.call(o,e,t,H.supportsPassiveEvents?{passive:r.passive===void 0?e.indexOf("touch")!==-1:r.passive,capture:!1}:!1),s[e]||(s[e]=[]);var l={fn:t,order:typeof r.order=="number"?r.order:1/0};return s[e].push(l),s[e].sort(function(h,c){return h.order-c.order}),function(){removeEvent$c(o,e,t)}}function removeEvent$c(o,e,t){function r(h,c){var d=o.removeEventListener||H.removeEventListenerPolyfill;d&&d.call(o,h,c,!1)}function n(h){var c,d;o.nodeName&&(e?(c={},c[e]=!0):c=h,objectEach$B(c,function(f,p){if(h[p])for(d=h[p].length;d--;)r(p,h[p][d].fn)}))}var s=typeof o=="function"&&o.prototype||o;if(Object.hasOwnProperty.call(s,"hcEvents")){var a=s.hcEvents;if(e){var l=a[e]||[];t?(a[e]=l.filter(function(h){return t!==h.fn}),r(e,t)):(n(a),a[e]=[])}else n(a),delete s.hcEvents}}function fireEvent$B(o,e,t,r){var n;if(t=t||{},doc$m.createEvent&&(o.dispatchEvent||o.fireEvent&&o!==H))n=doc$m.createEvent("Events"),n.initEvent(e,!0,!0),t=extend$1q(n,t),o.dispatchEvent?o.dispatchEvent(t):o.fireEvent(e,t);else if(o.hcEvents){t.target||extend$1q(t,{preventDefault:function(){t.defaultPrevented=!0},target:o,type:e});for(var s=[],a=o,l=!1;a.hcEvents;)Object.hasOwnProperty.call(a,"hcEvents")&&a.hcEvents[e]&&(s.length&&(l=!0),s.unshift.apply(s,a.hcEvents[e])),a=Object.getPrototypeOf(a);l&&s.sort(function(h,c){return h.order-c.order}),s.forEach(function(h){h.fn.call(o,t)===!1&&t.preventDefault()})}r&&!t.defaultPrevented&&r.call(o,t)}var serialMode,uniqueKey$8=function(){var o=Math.random().toString(36).substring(2,9)+"-",e=0;return function(){return"highcharts-"+(serialMode?"":o)+e++}}();function useSerialIds(o){return serialMode=pick$1B(o,serialMode)}function isFunction$5(o){return typeof o=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var o=[].slice.call(arguments);if(this[0])return o[0]?(new H[isString$c(o[0])?o.shift():"Chart"](this[0],o[0],o[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$12,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$j,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$W,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$9,error:error$a,extend:extend$1q,extendClass:extendClass$2,find:find$j,fireEvent:fireEvent$B,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$n,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$R,isObject:isObject$f,isString:isString$c,keys,merge:merge$1p,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$B,offset:offset$1,pad:pad$2,pick:pick$1B,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$j,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$3,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$d},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5",positiveColor:"#06b535",negativeColor:"#f21313"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$Q=Utilities.isNumber,merge$1o=Utilities.merge,pInt$9=Utilities.pInt,Color=function(){function o(e){this.rgba=[NaN,NaN,NaN,NaN],this.input=e;var t=H.Color;if(t&&t!==o)return new t(e);if(!(this instanceof o))return new o(e);this.init(e)}return o.parse=function(e){return e?new o(e):o.None},o.prototype.init=function(e){var t,r,n,s;if(typeof e=="object"&&typeof e.stops<"u")this.stops=e.stops.map(function(h){return new o(h[1])});else if(typeof e=="string"){if(this.input=e=o.names[e.toLowerCase()]||e,e.charAt(0)==="#"){var a=e.length,l=parseInt(e.substr(1),16);a===7?r=[(l&16711680)>>16,(l&65280)>>8,l&255,1]:a===4&&(r=[(l&3840)>>4|(l&3840)>>8,(l&240)>>4|l&240,(l&15)<<4|l&15,1])}if(!r)for(n=o.parsers.length;n--&&!r;)s=o.parsers[n],t=s.regex.exec(e),t&&(r=s.parse(t))}r&&(this.rgba=r)},o.prototype.get=function(e){var t=this.input,r=this.rgba;if(typeof t=="object"&&typeof this.stops<"u"){var n=merge$1o(t);return n.stops=[].slice.call(n.stops),this.stops.forEach(function(s,a){n.stops[a]=[n.stops[a][0],s.get(e)]}),n}return r&&isNumber$Q(r[0])?e==="rgb"||!e&&r[3]===1?"rgb("+r[0]+","+r[1]+","+r[2]+")":e==="a"?""+r[3]:"rgba("+r.join(",")+")":t},o.prototype.brighten=function(e){var t=this.rgba;if(this.stops)this.stops.forEach(function(n){n.brighten(e)});else if(isNumber$Q(e)&&e!==0)for(var r=0;r<3;r++)t[r]+=pInt$9(e*255),t[r]<0&&(t[r]=0),t[r]>255&&(t[r]=255);return this},o.prototype.setOpacity=function(e){return this.rgba[3]=e,this},o.prototype.tweenTo=function(e,t){var r=this.rgba,n=e.rgba;if(!isNumber$Q(r[0])||!isNumber$Q(n[0]))return e.input||"none";var s=n[3]!==1||r[3]!==1;return(s?"rgba(":"rgb(")+Math.round(n[0]+(r[0]-n[0])*(1-t))+","+Math.round(n[1]+(r[1]-n[1])*(1-t))+","+Math.round(n[2]+(r[2]-n[2])*(1-t))+(s?","+(n[3]+(r[3]-n[3])*(1-t)):"")+")"},o.names={white:"#ffffff",black:"#000000"},o.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(e){return[pInt$9(e[1]),pInt$9(e[2]),pInt$9(e[3]),parseFloat(e[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(e){return[pInt$9(e[1]),pInt$9(e[2]),pInt$9(e[3]),1]}}],o.None=new o(""),o}(),win$f=H.win,defined$V=Utilities.defined,error$9=Utilities.error,extend$1p=Utilities.extend,isObject$e=Utilities.isObject,merge$1n=Utilities.merge,objectEach$A=Utilities.objectEach,pad$1=Utilities.pad,pick$1A=Utilities.pick,splat$i=Utilities.splat,timeUnits$2=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=function(){function o(e){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(e)}return o.prototype.get=function(e,t){if(this.variableTimezone||this.timezoneOffset){var r=t.getTime(),n=r-this.getTimezoneOffset(t);t.setTime(n);var s=t["getUTC"+e]();return t.setTime(r),s}return this.useUTC?t["getUTC"+e]():t["get"+e]()},o.prototype.set=function(e,t,r){if(this.variableTimezone||this.timezoneOffset){if(e==="Milliseconds"||e==="Seconds"||e==="Minutes"&&this.getTimezoneOffset(t)%36e5===0)return t["setUTC"+e](r);var n=this.getTimezoneOffset(t),s=t.getTime()-n;t.setTime(s),t["setUTC"+e](r);var a=this.getTimezoneOffset(t);return s=t.getTime()+a,t.setTime(s)}return this.useUTC||hasNewSafariBug&&e==="FullYear"?t["setUTC"+e](r):t["set"+e](r)},o.prototype.update=function(e){var t=pick$1A(e&&e.useUTC,!0);this.options=e=merge$1n(!0,this.options||{},e),this.Date=e.Date||win$f.Date||Date,this.useUTC=t,this.timezoneOffset=t&&e.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=t&&!!(e.getTimezoneOffset||e.timezone)},o.prototype.makeTime=function(e,t,r,n,s,a){var l,h,c;return this.useUTC?(l=this.Date.UTC.apply(0,arguments),h=this.getTimezoneOffset(l),l+=h,c=this.getTimezoneOffset(l),h!==c?l+=c-h:h-36e5===this.getTimezoneOffset(l-36e5)&&!hasOldSafariBug&&(l-=36e5)):l=new this.Date(e,t,pick$1A(r,1),pick$1A(n,0),pick$1A(s,0),pick$1A(a,0)).getTime(),l},o.prototype.timezoneOffsetFunction=function(){var e=this,t=this.options,r=t.moment||win$f.moment;if(!this.useUTC)return function(n){return new Date(n.toString()).getTimezoneOffset()*6e4};if(t.timezone)if(!r)error$9(25);else return function(n){return-r.tz(n,t.timezone).utcOffset()*6e4};return this.useUTC&&t.getTimezoneOffset?function(n){return t.getTimezoneOffset(n.valueOf())*6e4}:function(){return(e.timezoneOffset||0)*6e4}},o.prototype.dateFormat=function(e,t,r){if(!defined$V(t)||isNaN(t))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";e=pick$1A(e,"%Y-%m-%d %H:%M:%S");var n=this,s=new this.Date(t),a=this.get("Hours",s),l=this.get("Day",s),h=this.get("Date",s),c=this.get("Month",s),d=this.get("FullYear",s),f=H.defaultOptions.lang,p=f&&f.weekdays,u=f&&f.shortWeekdays,g=extend$1p({a:u?u[l]:p[l].substr(0,3),A:p[l],d:pad$1(h),e:pad$1(h,2," "),w:l,b:f.shortMonths[c],B:f.months[c],m:pad$1(c+1),o:c+1,y:d.toString().substr(2,2),Y:d,H:pad$1(a),k:a,I:pad$1(a%12||12),l:a%12||12,M:pad$1(this.get("Minutes",s)),p:a<12?"AM":"PM",P:a<12?"am":"pm",S:pad$1(s.getSeconds()),L:pad$1(Math.floor(t%1e3),3)},H.dateFormats);return objectEach$A(g,function(v,y){for(;e.indexOf("%"+y)!==-1;)e=e.replace("%"+y,typeof v=="function"?v.call(n,t):v)}),r?e.substr(0,1).toUpperCase()+e.substr(1):e},o.prototype.resolveDTLFormat=function(e){return isObject$e(e,!0)?e:(e=splat$i(e),{main:e[0],from:e[1],to:e[2]})},o.prototype.getTimeTicks=function(e,t,r,n){var s=this,a=s.Date,l=[],h={},c=new a(t),d=e.unitRange,f=e.count||1,p,u,g,v;if(n=pick$1A(n,1),defined$V(t)){s.set("Milliseconds",c,d>=timeUnits$2.second?0:f*Math.floor(s.get("Milliseconds",c)/f)),d>=timeUnits$2.second&&s.set("Seconds",c,d>=timeUnits$2.minute?0:f*Math.floor(s.get("Seconds",c)/f)),d>=timeUnits$2.minute&&s.set("Minutes",c,d>=timeUnits$2.hour?0:f*Math.floor(s.get("Minutes",c)/f)),d>=timeUnits$2.hour&&s.set("Hours",c,d>=timeUnits$2.day?0:f*Math.floor(s.get("Hours",c)/f)),d>=timeUnits$2.day&&s.set("Date",c,d>=timeUnits$2.month?1:Math.max(1,f*Math.floor(s.get("Date",c)/f))),d>=timeUnits$2.month&&(s.set("Month",c,d>=timeUnits$2.year?0:f*Math.floor(s.get("Month",c)/f)),u=s.get("FullYear",c)),d>=timeUnits$2.year&&(u-=u%f,s.set("FullYear",c,u)),d===timeUnits$2.week&&(v=s.get("Day",c),s.set("Date",c,s.get("Date",c)-v+n+(v<n?-7:0))),u=s.get("FullYear",c);var y=s.get("Month",c),m=s.get("Date",c),x=s.get("Hours",c);t=c.getTime(),(s.variableTimezone||!s.useUTC)&&defined$V(r)&&(g=r-t>4*timeUnits$2.month||s.getTimezoneOffset(t)!==s.getTimezoneOffset(r));var b=c.getTime();for(p=1;b<r;)l.push(b),d===timeUnits$2.year?b=s.makeTime(u+p*f,0):d===timeUnits$2.month?b=s.makeTime(u,y+p*f):g&&(d===timeUnits$2.day||d===timeUnits$2.week)?b=s.makeTime(u,y,m+p*f*(d===timeUnits$2.day?1:7)):g&&d===timeUnits$2.hour&&f>1?b=s.makeTime(u,y,m,x+p*f):b+=d*f,p++;l.push(b),d<=timeUnits$2.hour&&l.length<1e4&&l.forEach(function($){$%18e5===0&&s.dateFormat("%H%M%S%L",$)==="000000000"&&(h[$]="day")})}return l.info=extend$1p(e,{higherRanks:h,totalRange:d*f}),l},o.prototype.getDateFormat=function(e,t,r,n){var s=this.dateFormat("%m-%d %H:%M:%S.%L",t),a="01-01 00:00:00.000",l={millisecond:15,second:12,minute:9,hour:6,day:3},h,c,d="millisecond";for(c in timeUnits$2){if(e===timeUnits$2.week&&+this.dateFormat("%w",t)===r&&s.substr(6)===a.substr(6)){c="week";break}if(timeUnits$2[c]>e){c=d;break}if(l[c]&&s.substr(l[c])!==a.substr(l[c]))break;c!=="week"&&(d=c)}return c&&(h=this.resolveDTLFormat(n[c]).main),h},o}(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$5=H.svg,merge$1m=Utilities.merge,defaultOptions$f={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$5,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$f.chart.styledMode=!1;var defaultTime$2=new Time(merge$1m(defaultOptions$f.global,defaultOptions$f.time));function getOptions$3(){return defaultOptions$f}function setOptions$2(o){return merge$1m(!0,defaultOptions$f,o),(o.time||o.global)&&(H.time?H.time.update(merge$1m(defaultOptions$f.global,defaultOptions$f.time,o.global,o.time)):H.time=defaultTime$2),defaultOptions$f}var DefaultOptions={defaultOptions:defaultOptions$f,defaultTime:defaultTime$2,getOptions:getOptions$3,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$P=Utilities.isNumber,objectEach$z=Utilities.objectEach,Fx=function(){function o(e,t,r){this.pos=NaN,this.options=t,this.elem=e,this.prop=r}return o.prototype.dSetter=function(){var e=this.paths,t=e&&e[0],r=e&&e[1],n=this.now||0,s=[];if(n===1||!t||!r)s=this.toD||[];else if(t.length===r.length&&n<1)for(var a=0;a<r.length;a++){for(var l=t[a],h=r[a],c=[],d=0;d<h.length;d++){var f=l[d],p=h[d];isNumber$P(f)&&isNumber$P(p)&&!(h[0]==="A"&&(d===4||d===5))?c[d]=f+n*(p-f):c[d]=p}s.push(c)}else s=r;this.elem.attr("d",s,void 0,!0)},o.prototype.update=function(){var e=this.elem,t=this.prop,r=this.now,n=this.options.step;this[t+"Setter"]?this[t+"Setter"]():e.attr?e.element&&e.attr(t,r,null,!0):e.style[t]=r+this.unit,n&&n.call(e,r,this)},o.prototype.run=function(e,t,r){var n=this,s=n.options,a=function(c){return a.stopped?!1:n.step(c)},l=win$e.requestAnimationFrame||function(c){setTimeout(c,13)},h=function(){for(var c=0;c<o.timers.length;c++)o.timers[c]()||o.timers.splice(c--,1);o.timers.length&&l(h)};e===t&&!this.elem["forceAnimate:"+this.prop]?(delete s.curAnim[this.prop],s.complete&&Object.keys(s.curAnim).length===0&&s.complete.call(this.elem)):(this.startTime=+new Date,this.start=e,this.end=t,this.unit=r,this.now=this.start,this.pos=0,a.elem=this.elem,a.prop=this.prop,a()&&o.timers.push(a)===1&&l(h))},o.prototype.step=function(e){var t=+new Date,r=this.options,n=this.elem,s=r.complete,a=r.duration,l=r.curAnim,h,c;return n.attr&&!n.element?h=!1:e||t>=a+this.startTime?(this.now=this.end,this.pos=1,this.update(),l[this.prop]=!0,c=!0,objectEach$z(l,function(d){d!==!0&&(c=!1)}),c&&s&&s.call(n),h=!1):(this.pos=r.easing((t-this.startTime)/a),this.now=this.start+(this.end-this.start)*this.pos,this.update(),h=!0),h},o.prototype.initPath=function(e,t,r){var n=e.startX,s=e.endX,a=r.slice(),l=e.isArea,h=l?2:1,c,d,f,p,u=t&&t.slice();if(!u)return[a,a];function g(y,m){for(;y.length<d;){var x=y[0],b=m[d-y.length];if(b&&x[0]==="M"&&(b[0]==="C"?y[0]=["C",x[1],x[2],x[1],x[2],x[1],x[2]]:y[0]=["L",x[1],x[2]]),y.unshift(x),l){var $=y.pop();y.push(y[y.length-1],$)}}}function v(y,m){for(;y.length<d;){var x=y[Math.floor(y.length/h)-1].slice();if(x[0]==="C"&&(x[1]=x[5],x[2]=x[6]),!l)y.push(x);else{var b=y[Math.floor(y.length/h)].slice();y.splice(y.length/2,0,x,b)}}}if(n&&s&&s.length){for(f=0;f<n.length;f++)if(n[f]===s[0]){c=f;break}else if(n[0]===s[s.length-n.length+f]){c=f,p=!0;break}else if(n[n.length-1]===s[s.length-n.length+f]){c=n.length-f;break}typeof c>"u"&&(u=[])}return u.length&&isNumber$P(c)&&(d=a.length+c*h,p?(g(u,a),v(a)):(g(a,u),v(u))),[u,a]},o.prototype.fillSetter=function(){o.prototype.strokeSetter.apply(this,arguments)},o.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},o.timers=[],o}(),defined$U=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$m=Utilities.isArray,isNumber$O=Utilities.isNumber,isObject$d=Utilities.isObject,merge$1l=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1z=Utilities.pick;function setAnimation$5(o,e){e.renderer.globalAnimation=pick$1z(o,e.options.chart.animation,!0)}function animObject$c(o){return isObject$d(o)?merge$1l({duration:500,defer:0},o):{duration:o?500:0,defer:0}}function getDeferredAnimation$3(o,e,t){var r=animObject$c(e),n=t?[t]:o.series,s=0,a=0;n.forEach(function(h){var c=animObject$c(h.options.animation);s=e&&defined$U(e.defer)?r.defer:Math.max(s,c.duration+c.defer),a=Math.min(r.duration,c.duration)}),o.renderer.forExport&&(s=0);var l={defer:Math.max(0,s-a),duration:Math.min(s,a)};return l}function animate$2(o,e,t){var r,n="",s,a,l;isObject$d(t)||(l=arguments,t={duration:l[2],easing:l[3],complete:l[4]}),isNumber$O(t.duration)||(t.duration=400),t.easing=typeof t.easing=="function"?t.easing:Math[t.easing]||Math.easeInOutSine,t.curAnim=merge$1l(e),objectEach$y(e,function(h,c){stop$2(o,c),a=new Fx(o,t,c),s=void 0,c==="d"&&isArray$m(e.d)?(a.paths=a.initPath(o,o.pathArray,e.d),a.toD=e.d,r=0,s=1):o.attr?r=o.attr(c):(r=parseFloat(getStyle$1(o,c))||0,c!=="opacity"&&(n="px")),s||(s=h),typeof s=="string"&&s.match("px")&&(s=s.replace(/px/g,"")),a.run(r,s,n)})}function stop$2(o,e){for(var t=Fx.timers.length;t--;)Fx.timers[t].elem===o&&(!e||e===Fx.timers[t].prop)&&(Fx.timers[t].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$c,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$8=Utilities.error,isString$b=Utilities.isString,objectEach$x=Utilities.objectEach,splat$h=Utilities.splat,hasValidDOMParser=function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}}(),AST=function(){function o(e){this.nodes=typeof e=="string"?this.parseMarkup(e):e}return o.filterUserAttributes=function(e){return objectEach$x(e,function(t,r){var n=!0;o.allowedAttributes.indexOf(r)===-1&&(n=!1),["background","dynsrc","href","lowsrc","src"].indexOf(r)!==-1&&(n=isString$b(t)&&o.allowedReferences.some(function(s){return t.indexOf(s)===0})),n||(error$8("Highcharts warning: Invalid attribute '"+r+"' in config"),delete e[r])}),e},o.setElementHTML=function(e,t){if(e.innerHTML="",t){var r=new o(t);r.addToDOM(e)}},o.prototype.addToDOM=function(e){function t(r,n){var s;return splat$h(r).forEach(function(a){var l=a.tagName,h=a.textContent?H.doc.createTextNode(a.textContent):void 0,c;if(l)if(l==="#text")c=h;else if(o.allowedTags.indexOf(l)!==-1){var d=l==="svg"?SVG_NS$3:n.namespaceURI||SVG_NS$3,f=H.doc.createElementNS(d,l),p=a.attributes||{};objectEach$x(a,function(u,g){g!=="tagName"&&g!=="attributes"&&g!=="children"&&g!=="textContent"&&(p[g]=u)}),attr$7(f,o.filterUserAttributes(p)),h&&f.appendChild(h),t(a.children||[],f),c=f}else error$8("Highcharts warning: Invalid tagName '"+l+"' in config");c&&n.appendChild(c),s=c}),s}return t(this.nodes,e)},o.prototype.parseMarkup=function(e){var t=[];e=e.trim();var r,n;hasValidDOMParser?r=new DOMParser().parseFromString(e,"text/html"):(n=createElement$a("div"),n.innerHTML=e,r={body:n});var s=function(a,l){var h=a.nodeName.toLowerCase(),c={tagName:h};h==="#text"&&(c.textContent=a.textContent||"");var d=a.attributes;if(d){var f={};[].forEach.call(d,function(u){f[u.name]=u.value}),c.attributes=f}if(a.childNodes.length){var p=[];[].forEach.call(a.childNodes,function(u){s(u,p)}),p.length&&(c.children=p)}l.push(c)};return[].forEach.call(r.body.childNodes,function(a){return s(a,t)}),n&&discardElement$6(n),t},o.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],o.allowedReferences=["https://","http://","mailto:","/","../","./","#"],o.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],o}(),defaultOptions$e=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$N=Utilities.isNumber,pick$1y=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(o,e,t){return defaultTime$1.dateFormat(o,e,t)}function format$d(o,e,t){for(var r="{",n=!1,s,a,l,h,c=/f$/,d=/\.([0-9])/,f=defaultOptions$e.lang,p=t&&t.time||defaultTime$1,u=t&&t.numberFormatter||numberFormat$2,g=[];o&&(h=o.indexOf(r),h!==-1);){if(s=o.slice(0,h),n){if(a=s.split(":"),l=getNestedProperty$2(a.shift()||"",e),a.length&&typeof l=="number")if(s=a.join(":"),c.test(s)){var v=parseInt((s.match(d)||["","-1"])[1],10);l!==null&&(l=u(l,v,f.decimalPoint,s.indexOf(",")>-1?f.thousandsSep:""))}else l=p.dateFormat(s,l);g.push(l)}else g.push(s);o=o.slice(h+1),n=!n,r=n?"}":"{"}return g.push(o),g.join("")}function numberFormat$2(o,e,t,r){o=+o||0,e=+e;var n,s,a=defaultOptions$e.lang,l=(o.toString().split(".")[1]||"").split("e")[0].length,h=o.toString().split("e"),c=e;e===-1?e=Math.min(l,20):isNumber$N(e)?e&&h[1]&&h[1]<0&&(s=e+ +h[1],s>=0?(h[0]=(+h[0]).toExponential(s).split("e")[0],e=s):(h[0]=h[0].split(".")[0]||0,e<20?o=(h[0]*Math.pow(10,h[1])).toFixed(e):o=0,h[1]=0)):e=2;var d=(Math.abs(h[1]?h[0]:o)+Math.pow(10,-Math.max(e,l)-1)).toFixed(e),f=String(pInt$8(d)),p=f.length>3?f.length%3:0;return t=pick$1y(t,a.decimalPoint),r=pick$1y(r,a.thousandsSep),n=o<0?"-":"",n+=p?f.substr(0,p)+r:"",+h[1]<0&&!c?n="0":n+=f.substr(p).replace(/(\d{3})(?=\d)/g,"$1"+r),e&&(n+=t+d.slice(-e)),h[1]&&+n!=0&&(n+="e"+h[1]),n}var FormatUtilities={dateFormat,format:format$d,numberFormat:numberFormat$2},clamp$i=Utilities.clamp,pick$1x=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(o){function e(t,r,n){var s=t,a=s.reducedLen||r,l=function(v,y){return(y.rank||0)-(v.rank||0)},h=function(v,y){return v.target-y.target},c,d=!0,f=[],p,u,g=0;for(c=t.length;c--;)g+=t[c].size;if(g>a){for(stableSort$6(t,l),c=0,g=0;g<=a;)g+=t[c].size,c++;f=t.splice(c-1,t.length)}for(stableSort$6(t,h),t=t.map(function(v){return{size:v.size,targets:[v.target],align:pick$1x(v.align,.5)}});d;){for(c=t.length;c--;)p=t[c],u=(Math.min.apply(0,p.targets)+Math.max.apply(0,p.targets))/2,p.pos=clamp$i(u-p.size*p.align,0,r-p.size);for(c=t.length,d=!1;c--;)c>0&&t[c-1].pos+t[c-1].size>t[c].pos&&(t[c-1].size+=t[c].size,t[c-1].targets=t[c-1].targets.concat(t[c].targets),t[c-1].align=.5,t[c-1].pos+t[c-1].size>r&&(t[c-1].pos=r-t[c-1].size),t.splice(c,1),d=!0)}return s.push.apply(s,f),c=0,t.some(function(v){var y=0;return(v.targets||[]).some(function(){return s[c].pos=v.pos+y,typeof n<"u"&&Math.abs(s[c].pos-s[c].target)>n?(s.slice(0,c+1).forEach(function(m){return delete m.pos}),s.reducedLen=(s.reducedLen||r)-r*.1,s.reducedLen>r*.1&&e(s,r,n),!0):(y+=s[c].size,c++,!1)})}),stableSort$6(s,h),s}o.distribute=e})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$b=animationExports.animObject,stop$1=animationExports.stop,deg2rad$8=H.deg2rad,doc$l=H.doc,noop$l=H.noop,svg$4=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$11=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$T=Utilities.defined,erase$8=Utilities.erase,extend$1o=Utilities.extend,fireEvent$A=Utilities.fireEvent,isArray$l=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$M=Utilities.isNumber,isString$a=Utilities.isString,merge$1k=Utilities.merge,objectEach$w=Utilities.objectEach,pick$1w=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=function(){function o(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return o.prototype._defaultGetter=function(e){var t=pick$1w(this[e+"Value"],this[e],this.element?this.element.getAttribute(e):null,0);return/^[\-0-9\.]+$/.test(t)&&(t=parseFloat(t)),t},o.prototype._defaultSetter=function(e,t,r){r.setAttribute(t,e)},o.prototype.add=function(e){var t=this.renderer,r=this.element,n;return e&&(this.parentGroup=e),this.parentInverted=e&&e.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&t.buildText(this),this.added=!0,(!e||e.handleZ||this.zIndex)&&(n=this.zIndexSetter()),n||(e?e.element:t.box).appendChild(r),this.onAdd&&this.onAdd(),this},o.prototype.addClass=function(e,t){var r=t?"":this.attr("class")||"";return e=(e||"").split(/ /g).reduce(function(n,s){return r.indexOf(s)===-1&&n.push(s),n},r?[r]:[]).join(" "),e!==r&&this.attr("class",e),this},o.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},o.prototype.align=function(e,t,r){var n={},s=this.renderer,a=s.alignedObjects,l,h,c,d,f;e?(this.alignOptions=e,this.alignByTranslate=t,(!r||isString$a(r))&&(this.alignTo=c=r||"renderer",erase$8(a,this),a.push(this),r=void 0)):(e=this.alignOptions,t=this.alignByTranslate,c=this.alignTo),r=pick$1w(r,s[c],c==="scrollablePlotBox"?s.plotBox:void 0,s);var p=e.align,u=e.verticalAlign;return l=(r.x||0)+(e.x||0),h=(r.y||0)+(e.y||0),p==="right"?d=1:p==="center"&&(d=2),d&&(l+=(r.width-(e.width||0))/d),n[t?"translateX":"x"]=Math.round(l),u==="bottom"?f=1:u==="middle"&&(f=2),f&&(h+=(r.height-(e.height||0))/f),n[t?"translateY":"y"]=Math.round(h),this[this.placed?"animate":"attr"](n),this.placed=!0,this.alignAttr=n,this},o.prototype.alignSetter=function(e){var t={left:"start",center:"middle",right:"end"};t[e]&&(this.alignValue=e,this.element.setAttribute("text-anchor",t[e]))},o.prototype.animate=function(e,t,r){var n=this,s=animObject$b(pick$1w(t,this.renderer.globalAnimation,!0)),a=s.defer;return pick$1w(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(s.duration=0),s.duration!==0?(r&&(s.complete=r),syncTimeout$8(function(){n.element&&animate$1(n,e,s)},a)):(this.attr(e,void 0,r),objectEach$w(e,function(l,h){s.step&&s.step.call(this,l,{prop:h,pos:1,elem:this})},this)),this},o.prototype.applyTextOutline=function(e){var t=this.element,r=e.indexOf("contrast")!==-1;r&&(e=e.replace(/contrast/g,this.renderer.getContrast(t.style.fill)));var n=e.split(" "),s=n[n.length-1],a=n[0];if(a&&a!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,a=a.replace(/(^[\d\.]+)(.*?)$/g,function(c,d,f){return 2*Number(d)+f}),this.removeTextOutline();var l=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(l,{class:"highcharts-text-outline",fill:s,stroke:s,"stroke-width":a,"stroke-linejoin":"round"}),[].forEach.call(t.childNodes,function(c){var d=c.cloneNode(!0);d.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(f){return d.removeAttribute(f)}),l.appendChild(d)});var h=doc$l.createElementNS(SVG_NS$2,"tspan");h.textContent="​",["x","y"].forEach(function(c){var d=t.getAttribute(c);d&&h.setAttribute(c,d)}),l.appendChild(h),t.insertBefore(l,t.firstChild)}},o.prototype.attr=function(e,t,r,n){var s=this.element,a=this.symbolCustomAttribs,l,h,c=this,d,f;return typeof e=="string"&&typeof t<"u"&&(l=e,e={},e[l]=t),typeof e=="string"?c=(this[e+"Getter"]||this._defaultGetter).call(this,e,s):(objectEach$w(e,function(u,g){d=!1,n||stop$1(this,g),this.symbolName&&a.indexOf(g)!==-1&&(h||(this.symbolAttr(e),h=!0),d=!0),this.rotation&&(g==="x"||g==="y")&&(this.doTransform=!0),d||(f=this[g+"Setter"]||this._defaultSetter,f.call(this,u,g,s),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(g)&&this.updateShadows(g,u,f))},this),this.afterSetters()),r&&r.call(this),c},o.prototype.clip=function(e){return this.attr("clip-path",e?"url("+this.renderer.url+"#"+e.id+")":"none")},o.prototype.crisp=function(e,t){var r=this;t=t||e.strokeWidth||0;var n=Math.round(t)%2/2;return e.x=Math.floor(e.x||r.x||0)+n,e.y=Math.floor(e.y||r.y||0)+n,e.width=Math.floor((e.width||r.width||0)-2*n),e.height=Math.floor((e.height||r.height||0)-2*n),defined$T(e.strokeWidth)&&(e.strokeWidth=t),e},o.prototype.complexColor=function(e,t,r){var n=this.renderer,s,a,l,h,c,d,f,p,u,g,v=[],y;fireEvent$A(this.renderer,"complexColor",{args:arguments},function(){if(e.radialGradient?a="radialGradient":e.linearGradient&&(a="linearGradient"),a){if(l=e[a],c=n.gradients,d=e.stops,u=r.radialReference,isArray$l(l)&&(e[a]=l={x1:l[0],y1:l[1],x2:l[2],y2:l[3],gradientUnits:"userSpaceOnUse"}),a==="radialGradient"&&u&&!defined$T(l.gradientUnits)&&(h=l,l=merge$1k(l,n.getRadialAttr(u,h),{gradientUnits:"userSpaceOnUse"})),objectEach$w(l,function(x,b){b!=="id"&&v.push(b,x)}),objectEach$w(d,function(x){v.push(x)}),v=v.join(","),c[v])g=c[v].attr("id");else{l.id=g=uniqueKey$7();var m=c[v]=n.createElement(a).attr(l).add(n.defs);m.radAttr=h,m.stops=[],d.forEach(function(x){x[1].indexOf("rgba")===0?(s=Color.parse(x[1]),f=s.get("rgb"),p=s.get("a")):(f=x[1],p=1);var b=n.createElement("stop").attr({offset:x[0],"stop-color":f,"stop-opacity":p}).add(m);m.stops.push(b)})}y="url("+n.url+"#"+g+")",r.setAttribute(t,y),r.gradient=v,e.toString=function(){return y}}})},o.prototype.css=function(e){var t=this.styles,r={},n=this.element,s=["textOutline","textOverflow","width"],a,l="",h,c=!t;return e&&e.color&&(e.fill=e.color),t&&objectEach$w(e,function(d,f){t&&t[f]!==d&&(r[f]=d,c=!0)}),c&&(t&&(e=extend$1o(t,r)),e&&(e.width===null||e.width==="auto"?delete this.textWidth:n.nodeName.toLowerCase()==="text"&&e.width&&(a=this.textWidth=pInt$7(e.width))),this.styles=e,a&&!svg$4&&this.renderer.forExport&&delete e.width,n.namespaceURI===this.SVG_NS?(h=function(d,f){return"-"+f.toLowerCase()},objectEach$w(e,function(d,f){s.indexOf(f)===-1&&(l+=f.replace(/([A-Z])/g,h)+":"+d+";")}),l&&attr$6(n,"style",l)):css$c(n,e),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),e&&e.textOutline&&this.applyTextOutline(e.textOutline))),this},o.prototype.dashstyleSetter=function(e){var t,r=this["stroke-width"];if(r==="inherit"&&(r=1),e=e&&e.toLowerCase(),e){var n=e.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(t=n.length;t--;)n[t]=""+pInt$7(n[t])*pick$1w(r,NaN);e=n.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",e)}},o.prototype.destroy=function(){var e=this,t=e.element||{},r=e.renderer,n=t.ownerSVGElement,s=r.isSVG&&t.nodeName==="SPAN"&&e.parentGroup||void 0,a,l;if(t.onclick=t.onmouseout=t.onmouseover=t.onmousemove=t.point=null,stop$1(e),e.clipPath&&n){var h=e.clipPath;[].forEach.call(n.querySelectorAll("[clip-path],[CLIP-PATH]"),function(c){c.getAttribute("clip-path").indexOf(h.element.id)>-1&&c.removeAttribute("clip-path")}),e.clipPath=h.destroy()}if(e.stops){for(l=0;l<e.stops.length;l++)e.stops[l].destroy();e.stops.length=0,e.stops=void 0}for(e.safeRemoveChild(t),r.styledMode||e.destroyShadows();s&&s.div&&s.div.childNodes.length===0;)a=s.parentGroup,e.safeRemoveChild(s.div),delete s.div,s=a;e.alignTo&&erase$8(r.alignedObjects,e),objectEach$w(e,function(c,d){e[d]&&e[d].parentGroup===e&&e[d].destroy&&e[d].destroy(),delete e[d]})},o.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(e){this.safeRemoveChild(e)},this),this.shadows=void 0},o.prototype.destroyTextPath=function(e,t){var r=e.getElementsByTagName("text")[0],n;if(r){if(r.removeAttribute("dx"),r.removeAttribute("dy"),t.element.setAttribute("id",""),this.textPathWrapper&&r.getElementsByTagName("textPath").length){for(n=this.textPathWrapper.element.childNodes;n.length;)r.appendChild(n[0]);r.removeChild(this.textPathWrapper.element)}}else(e.getAttribute("dx")||e.getAttribute("dy"))&&(e.removeAttribute("dx"),e.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},o.prototype.dSetter=function(e,t,r){isArray$l(e)&&(typeof e[0]=="string"&&(e=this.renderer.pathToSegments(e)),this.pathArray=e,e=e.reduce(function(n,s,a){return!s||!s.join?(s||"").toString():(a?n+" ":"")+s.join(" ")},"")),/(NaN| {2}|^$)/.test(e)&&(e="M 0 0"),this[t]!==e&&(r.setAttribute(t,e),this[t]=e)},o.prototype.fadeOut=function(e){var t=this;t.animate({opacity:0},{duration:pick$1w(e,150),complete:function(){t.attr({y:-9999}).hide()}})},o.prototype.fillSetter=function(e,t,r){typeof e=="string"?r.setAttribute(t,e):e&&this.complexColor(e,t,r)},o.prototype.getBBox=function(e,t){var r=this,n=r.renderer,s=r.element,a=r.styles,l=r.textStr,h=n.cache,c=n.cacheKeys,d=s.namespaceURI===r.SVG_NS,f=pick$1w(t,r.rotation,0),p=n.styledMode?s&&o.prototype.getStyle.call(s,"font-size"):a&&a.fontSize,u,g,v,y,m;if(defined$T(l)&&(m=l.toString(),m.indexOf("<")===-1&&(m=m.replace(/[0-9]/g,"0")),m+=["",f,p,r.textWidth,a&&a.textOverflow,a&&a.fontWeight].join(",")),m&&!e&&(u=h[m]),!u){if(d||n.forExport){try{y=this.fakeTS&&function(b){var $=s.querySelector(".highcharts-text-outline");$&&css$c($,{display:b})},isFunction$4(y)&&y("none"),u=s.getBBox?extend$1o({},s.getBBox()):{width:s.offsetWidth,height:s.offsetHeight},isFunction$4(y)&&y("")}catch{}(!u||u.width<0)&&(u={width:0,height:0})}else u=r.htmlGetBBox();if(n.isSVG&&(g=u.width,v=u.height,d&&(u.height=v={"11px,17":14,"13px,20":16}[a&&a.fontSize+","+Math.round(v)]||v),f)){var x=f*deg2rad$8;u.width=Math.abs(v*Math.sin(x))+Math.abs(g*Math.cos(x)),u.height=Math.abs(v*Math.cos(x))+Math.abs(g*Math.sin(x))}if(m&&(l===""||u.height>0)){for(;c.length>250;)delete h[c.shift()];h[m]||c.push(m),h[m]=u}}return u},o.prototype.getStyle=function(e){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(e)},o.prototype.hasClass=function(e){return(""+this.attr("class")).split(" ").indexOf(e)!==-1},o.prototype.hide=function(e){return e?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},o.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},o.prototype.init=function(e,t){this.element=t==="span"?createElement$9(t):doc$l.createElementNS(this.SVG_NS,t),this.renderer=e,fireEvent$A(this,"afterInit")},o.prototype.invert=function(e){return this.inverted=e,this.updateTransform(),this},o.prototype.on=function(e,t){var r=this.onEvents;return r[e]&&r[e](),r[e]=addEvent$11(this.element,e,t),this},o.prototype.opacitySetter=function(e,t,r){var n=Number(Number(e).toFixed(3));this.opacity=n,r.setAttribute(t,n)},o.prototype.removeClass=function(e){return this.attr("class",(""+this.attr("class")).replace(isString$a(e)?new RegExp("(^| )"+e+"( |$)"):e," ").replace(/ +/g," ").trim())},o.prototype.removeTextOutline=function(){var e=this.element.querySelector("tspan.highcharts-text-outline");e&&this.safeRemoveChild(e)},o.prototype.safeRemoveChild=function(e){var t=e.parentNode;t&&t.removeChild(e)},o.prototype.setRadialReference=function(e){var t=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=e,t&&t.radAttr&&t.animate(this.renderer.getRadialAttr(e,t.radAttr)),this},o.prototype.setTextPath=function(e,t){var r=this.element,n=this.text?this.text.element:r,s={textAnchor:"text-anchor"},a=!1,l,h,c=this.textPathWrapper,d=!c;t=merge$1k(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},t);var f=AST.filterUserAttributes(t.attributes);if(e&&t&&t.enabled){if(c&&c.element.parentNode===null?(d=!0,c=c.destroy()):c&&this.removeTextOutline.call(c.parentGroup),this.options&&this.options.padding&&(f.dx=-this.options.padding),c||(this.textPathWrapper=c=this.renderer.createElement("textPath"),a=!0),l=c.element,h=e.element.getAttribute("id"),h||e.element.setAttribute("id",h=uniqueKey$7()),d){n.setAttribute("y",0),isNumber$M(f.dx)&&n.setAttribute("x",-f.dx);for(var p=[].slice.call(n.childNodes),u=0;u<p.length;u++){var g=p[u];(g.nodeType===Node.TEXT_NODE||g.nodeName==="tspan")&&l.appendChild(g)}}a&&c&&c.add({element:n}),l.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+h),defined$T(f.dy)&&(l.parentNode.setAttribute("dy",f.dy),delete f.dy),defined$T(f.dx)&&(l.parentNode.setAttribute("dx",f.dx),delete f.dx),objectEach$w(f,function(v,y){l.setAttribute(s[y]||y,v)}),r.removeAttribute("transform"),this.removeTextOutline.call(c),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$l,this.applyTextOutline=noop$l}else c&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(r,e),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},o.prototype.shadow=function(e,t,r){var n=[],s=this.element,a=this.oldShadowOptions,l={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},h,c,d,f,p=!1,u,g;if(e===!0?g=l:typeof e=="object"&&(g=extend$1o(l,e)),g&&(g&&a&&objectEach$w(g,function(v,y){v!==a[y]&&(p=!0)}),p&&this.destroyShadows(),this.oldShadowOptions=g),!g)this.destroyShadows();else if(!this.shadows){for(f=g.opacity/g.width,u=this.parentInverted?"translate("+g.offsetY+", "+g.offsetX+")":"translate("+g.offsetX+", "+g.offsetY+")",h=1;h<=g.width;h++)c=s.cloneNode(!1),d=g.width*2+1-2*h,attr$6(c,{stroke:e.color||palette.neutralColor100,"stroke-opacity":f*h,"stroke-width":d,transform:u,fill:"none"}),c.setAttribute("class",(c.getAttribute("class")||"")+" highcharts-shadow"),r&&(attr$6(c,"height",Math.max(attr$6(c,"height")-d,0)),c.cutHeight=d),t?t.element.appendChild(c):s.parentNode&&s.parentNode.insertBefore(c,s),n.push(c);this.shadows=n}return this},o.prototype.show=function(e){return this.attr({visibility:e?"inherit":"visible"})},o.prototype.strokeSetter=function(e,t,r){this[t]=e,this.stroke&&this["stroke-width"]?(o.prototype.fillSetter.call(this,this.stroke,"stroke",r),r.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):t==="stroke-width"&&e===0&&this.hasStroke?(r.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(r.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},o.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var e=this.getStyle("stroke-width"),t=0,r;return e.indexOf("px")===e.length-2?t=pInt$7(e):e!==""&&(r=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(r,{width:e,"stroke-width":0}),this.element.parentNode.appendChild(r),t=r.getBBox().width,r.parentNode.removeChild(r)),t},o.prototype.symbolAttr=function(e){var t=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(r){t[r]=pick$1w(e[r],t[r])}),t.attr({d:t.renderer.symbols[t.symbolName](t.x,t.y,t.width,t.height,t)})},o.prototype.textSetter=function(e){e!==this.textStr&&(delete this.textPxLength,this.textStr=e,this.added&&this.renderer.buildText(this))},o.prototype.titleSetter=function(e){var t=this.element,r=t.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");t.insertBefore?t.insertBefore(r,t.firstChild):t.appendChild(r),r.textContent=String(pick$1w(e,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},o.prototype.toFront=function(){var e=this.element;return e.parentNode.appendChild(e),this},o.prototype.translate=function(e,t){return this.attr({translateX:e,translateY:t})},o.prototype.updateShadows=function(e,t,r){var n=this.shadows;if(n)for(var s=n.length;s--;)r.call(n[s],e==="height"?Math.max(t-(n[s].cutHeight||0),0):e==="d"?this.d:t,e,n[s])},o.prototype.updateTransform=function(){var e=this,t=e.scaleX,r=e.scaleY,n=e.inverted,s=e.rotation,a=e.matrix,l=e.element,h=e.translateX||0,c=e.translateY||0;n&&(h+=e.width,c+=e.height);var d=["translate("+h+","+c+")"];defined$T(a)&&d.push("matrix("+a.join(",")+")"),n?d.push("rotate(90) scale(-1,1)"):s&&d.push("rotate("+s+" "+pick$1w(this.rotationOriginX,l.getAttribute("x"),0)+" "+pick$1w(this.rotationOriginY,l.getAttribute("y")||0)+")"),(defined$T(t)||defined$T(r))&&d.push("scale("+pick$1w(t,1)+" "+pick$1w(r,1)+")"),d.length&&l.setAttribute("transform",d.join(" "))},o.prototype.visibilitySetter=function(e,t,r){e==="inherit"?r.removeAttribute(t):this[t]!==e&&r.setAttribute(t,e),this[t]=e},o.prototype.xGetter=function(e){return this.element.nodeName==="circle"&&(e==="x"?e="cx":e==="y"&&(e="cy")),this._defaultGetter(e)},o.prototype.zIndexSetter=function(e,t){var r=this.renderer,n=this.parentGroup,s=n||r,a=s.element||r.box,l=this.element,h=a===r.box,c,d,f,p=!1,u,g=this.added,v;if(defined$T(e)?(l.setAttribute("data-z-index",e),e=+e,this[t]===e&&(g=!1)):defined$T(this[t])&&l.removeAttribute("data-z-index"),this[t]=e,g){for(e=this.zIndex,e&&n&&(n.handleZ=!0),c=a.childNodes,v=c.length-1;v>=0&&!p;v--)d=c[v],f=d.getAttribute("data-z-index"),u=!defined$T(f),d!==l&&(e<0&&u&&!h&&!v?(a.insertBefore(l,c[v]),p=!0):(pInt$7(f)<=e||u&&(!defined$T(e)||e>=0))&&(a.insertBefore(l,c[v+1]||null),p=!0));p||(a.insertBefore(l,c[h?3:0]||null),p=!0)}return p},o}();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(o,e){this[e]=o,this.doTransform=!0};var RendererRegistry;(function(o){o.rendererTypes={};var e;function t(n){return n===void 0&&(n=e),o.rendererTypes[n]||o.rendererTypes[e]}o.getRendererType=t;function r(n,s,a){o.rendererTypes[n]=s,(!e||a)&&(e=n,H.Renderer=s)}o.registerRendererType=r})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$Y=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$S=Utilities.defined,extend$1n=Utilities.extend,isNumber$L=Utilities.isNumber,merge$1j=Utilities.merge,pick$1v=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=function(o){__extends$Y(e,o);function e(t,r,n,s,a,l,h,c,d,f){var p=o.call(this)||this;p.paddingLeftSetter=p.paddingSetter,p.paddingRightSetter=p.paddingSetter,p.init(t,"g"),p.textStr=r,p.x=n,p.y=s,p.anchorX=l,p.anchorY=h,p.baseline=d,p.className=f,p.addClass(f==="button"?"highcharts-no-tooltip":"highcharts-label"),f&&p.addClass("highcharts-"+f),p.text=t.text(void 0,0,0,c).attr({zIndex:1});var u;return typeof a=="string"&&(u=/^url\((.*?)\)$/.test(a),(u||p.renderer.symbols[a])&&(p.symbolKey=a)),p.bBox=e.emptyBBox,p.padding=3,p.baselineOffset=0,p.needsBox=t.styledMode||u,p.deferredAttr={},p.alignFactor=0,p}return e.prototype.alignSetter=function(t){var r={left:0,center:.5,right:1}[t];r!==this.alignFactor&&(this.alignFactor=r,this.bBox&&isNumber$L(this.xSetting)&&this.attr({x:this.xSetting}))},e.prototype.anchorXSetter=function(t,r){this.anchorX=t,this.boxAttr(r,Math.round(t)-this.getCrispAdjust()-this.xSetting)},e.prototype.anchorYSetter=function(t,r){this.anchorY=t,this.boxAttr(r,t-this.ySetting)},e.prototype.boxAttr=function(t,r){this.box?this.box.attr(t,r):this.deferredAttr[t]=r},e.prototype.css=function(t){if(t){var r={};t=merge$1j(t),e.textProps.forEach(function(a){typeof t[a]<"u"&&(r[a]=t[a],delete t[a])}),this.text.css(r);var n="width"in r,s="fontSize"in r||"fontWeight"in r;s?this.updateTextPadding():n&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,t)},e.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},e.prototype.fillSetter=function(t,r){t&&(this.needsBox=!0),this.fill=t,this.boxAttr(r,t)},e.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var t=this.padding,r=pick$1v(this.paddingLeft,t);return{width:this.width,height:this.height,x:this.bBox.x-r,y:this.bBox.y-t}},e.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},e.prototype.heightSetter=function(t){this.heightSetting=t},e.prototype.onAdd=function(){var t=this.textStr;this.text.add(this),this.attr({text:defined$S(t)?t:"",x:this.x,y:this.y}),this.box&&defined$S(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},e.prototype.paddingSetter=function(t,r){isNumber$L(t)?t!==this[r]&&(this[r]=t,this.updateTextPadding()):this[r]=void 0},e.prototype.rSetter=function(t,r){this.boxAttr(r,t)},e.prototype.shadow=function(t){return t&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(t)),this},e.prototype.strokeSetter=function(t,r){this.stroke=t,this.boxAttr(r,t)},e.prototype["stroke-widthSetter"]=function(t,r){t&&(this.needsBox=!0),this["stroke-width"]=t,this.boxAttr(r,t)},e.prototype["text-alignSetter"]=function(t){this.textAlign=t},e.prototype.textSetter=function(t){typeof t<"u"&&this.text.attr({text:t}),this.updateTextPadding()},e.prototype.updateBoxSize=function(){var t=this.text.element.style,r={},n=this.padding,s=this.bBox=(!isNumber$L(this.widthSetting)||!isNumber$L(this.heightSetting)||this.textAlign)&&defined$S(this.text.textStr)?this.text.getBBox():e.emptyBBox,a;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||s.height||0)+2*n;var l=this.renderer.fontMetrics(t&&t.fontSize,this.text);if(this.baselineOffset=n+Math.min((this.text.firstLineMetrics||l).b,s.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-l.h)/2),this.needsBox){if(!this.box){var h=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();h.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),h.add(this)}a=this.getCrispAdjust(),r.x=a,r.y=(this.baseline?-this.baselineOffset:0)+a,r.width=Math.round(this.width),r.height=Math.round(this.height),this.box.attr(extend$1n(r,this.deferredAttr)),this.deferredAttr={}}},e.prototype.updateTextPadding=function(){var t=this.text;this.updateBoxSize();var r=this.baseline?0:this.baselineOffset,n=pick$1v(this.paddingLeft,this.padding);defined$S(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(n+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(n!==t.x||r!==t.y)&&(t.attr("x",n),t.hasBoxWidthChanged&&(this.bBox=t.getBBox(!0)),typeof r<"u"&&t.attr("y",r)),t.x=n,t.y=r},e.prototype.widthSetter=function(t){this.widthSetting=isNumber$L(t)?t:void 0},e.prototype.getPaddedWidth=function(){var t=this.padding,r=pick$1v(this.paddingLeft,t),n=pick$1v(this.paddingRight,t);return(this.widthSetting||this.bBox.width||0)+r+n},e.prototype.xSetter=function(t){this.x=t,this.alignFactor&&(t-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(t),this.attr("translateX",this.xSetting)},e.prototype.ySetter=function(t){this.ySetting=this.y=Math.round(t),this.attr("translateY",this.ySetting)},e.emptyBBox={width:0,height:0,x:0,y:0},e.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],e}(SVGElement),defined$R=Utilities.defined,isNumber$K=Utilities.isNumber,pick$1u=Utilities.pick;function arc$1(o,e,t,r,n){var s=[];if(n){var a=n.start||0,l=pick$1u(n.r,t),h=pick$1u(n.r,r||t),c=.001,d=Math.abs((n.end||0)-a-2*Math.PI)<c,f=(n.end||0)-c,p=n.innerR,u=pick$1u(n.open,d),g=Math.cos(a),v=Math.sin(a),y=Math.cos(f),m=Math.sin(f),x=pick$1u(n.longArc,f-a-Math.PI<c?0:1);s.push(["M",o+l*g,e+h*v],["A",l,h,0,x,pick$1u(n.clockwise,1),o+l*y,e+h*m]),defined$R(p)&&s.push(u?["M",o+p*y,e+p*m]:["L",o+p*y,e+p*m],["A",p,p,0,x,defined$R(n.clockwise)?1-n.clockwise:0,o+p*g,e+p*v]),u||s.push(["Z"])}return s}function callout(o,e,t,r,n){var s=6,a=6,l=Math.min(n&&n.r||0,t,r),h=l+a,c=n&&n.anchorX,d=n&&n.anchorY||0,f=roundedRect(o,e,t,r,{r:l});return isNumber$K(c)&&(o+c>=t?d>e+h&&d<e+r-h?f.splice(3,1,["L",o+t,d-a],["L",o+t+s,d],["L",o+t,d+a],["L",o+t,e+r-l]):f.splice(3,1,["L",o+t,r/2],["L",c,d],["L",o+t,r/2],["L",o+t,e+r-l]):o+c<=0?d>e+h&&d<e+r-h?f.splice(7,1,["L",o,d+a],["L",o-s,d],["L",o,d-a],["L",o,e+l]):f.splice(7,1,["L",o,r/2],["L",c,d],["L",o,r/2],["L",o,e+l]):d&&d>r&&c>o+h&&c<o+t-h?f.splice(5,1,["L",c+a,e+r],["L",c,e+r+s],["L",c-a,e+r],["L",o+l,e+r]):d&&d<0&&c>o+h&&c<o+t-h&&f.splice(1,1,["L",c-a,e],["L",c,e-s],["L",c+a,e],["L",t-l,e])),f}function circle(o,e,t,r){return arc$1(o+t/2,e+r/2,t/2,r/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(o,e,t,r){return[["M",o+t/2,e],["L",o+t,e+r/2],["L",o+t/2,e+r],["L",o,e+r/2],["Z"]]}function rect(o,e,t,r,n){return n&&n.r?roundedRect(o,e,t,r,n):[["M",o,e],["L",o+t,e],["L",o+t,e+r],["L",o,e+r],["Z"]]}function roundedRect(o,e,t,r,n){var s=n&&n.r||0;return[["M",o+s,e],["L",o+t-s,e],["C",o+t,e,o+t,e,o+t,e+s],["L",o+t,e+r-s],["C",o+t,e+r,o+t,e+r,o+t-s,e+r],["L",o+s,e+r],["C",o,e+r,o,e+r,o,e+r-s],["L",o,e+s],["C",o,e,o,e,o+s,e]]}function triangle(o,e,t,r){return[["M",o+t/2,e],["L",o+t,e+r],["L",o,e+r],["Z"]]}function triangleDown(o,e,t,r){return[["M",o,e],["L",o+t,e],["L",o+t/2,e+r],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$9=Utilities.isString,objectEach$v=Utilities.objectEach,pick$1t=Utilities.pick,TextBuilder=function(){function o(e){var t=e.styles;this.renderer=e.renderer,this.svgElement=e,this.width=e.textWidth,this.textLineHeight=t&&t.lineHeight,this.textOutline=t&&t.textOutline,this.ellipsis=!!(t&&t.textOverflow==="ellipsis"),this.noWrap=!!(t&&t.whiteSpace==="nowrap"),this.fontSize=t&&t.fontSize}return o.prototype.buildSVG=function(){var e=this.svgElement,t=e.element,r=e.renderer,n=pick$1t(e.textStr,"").toString(),s=n.indexOf("<")!==-1,a=t.childNodes,l=this.width&&!e.added&&r.box,h=/<br.*?>/g,c=[n,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(c!==e.textCache){e.textCache=c,delete e.actualWidth;for(var d=a.length;d--;)t.removeChild(a[d]);if(!s&&!this.ellipsis&&!this.width&&(n.indexOf(" ")===-1||this.noWrap&&!h.test(n)))t.appendChild(doc$k.createTextNode(this.unescapeEntities(n)));else if(n!==""){l&&l.appendChild(t);var f=new AST(n);this.modifyTree(f.nodes),f.addToDOM(e.element),this.modifyDOM(),this.ellipsis&&(t.textContent||"").indexOf("…")!==-1&&e.attr("title",this.unescapeEntities(e.textStr||"",["&lt;","&gt;"])),l&&l.removeChild(t)}isString$9(this.textOutline)&&e.applyTextOutline&&e.applyTextOutline(this.textOutline)}},o.prototype.modifyDOM=function(){var e=this,t=this.svgElement,r=attr$5(t.element,"x");t.firstLineMetrics=void 0;for(var n;(n=t.element.firstChild)&&/^[\s\u200B]*$/.test(n.textContent||" ");)t.element.removeChild(n);[].forEach.call(t.element.querySelectorAll("tspan.highcharts-br"),function(h,c){h.nextSibling&&h.previousSibling&&(c===0&&h.previousSibling.nodeType===1&&(t.firstLineMetrics=t.renderer.fontMetrics(void 0,h.previousSibling)),attr$5(h,{dy:e.getLineHeight(h.nextSibling),x:r}))});var s=this.width||0;if(s){var a=function(h,c){var d=h.textContent||"",f=d.replace(/([^\^])-/g,"$1- ").split(" "),p=!e.noWrap&&(f.length>1||t.element.childNodes.length>1),u=e.getLineHeight(c),g=0,v=t.actualWidth;if(e.ellipsis)d&&e.truncate(h,d,void 0,0,Math.max(0,s-parseInt(e.fontSize||12,10)),function(x,b){return x.substring(0,b)+"…"});else if(p){for(var y=[],m=[];c.firstChild&&c.firstChild!==h;)m.push(c.firstChild),c.removeChild(c.firstChild);for(;f.length;)f.length&&!e.noWrap&&g>0&&(y.push(h.textContent||""),h.textContent=f.join(" ").replace(/- /g,"-")),e.truncate(h,void 0,f,g===0&&v||0,s,function(x,b){return f.slice(0,b).join(" ").replace(/- /g,"-")}),v=t.actualWidth,g++;m.forEach(function(x){c.insertBefore(x,h)}),y.forEach(function(x){c.insertBefore(doc$k.createTextNode(x),h);var b=doc$k.createElementNS(SVG_NS$1,"tspan");b.textContent="​",attr$5(b,{dy:u,x:r}),c.insertBefore(b,h)})}},l=function(h){var c=[].slice.call(h.childNodes);c.forEach(function(d){d.nodeType===Node.TEXT_NODE?a(d,h):(d.className.baseVal.indexOf("highcharts-br")!==-1&&(t.actualWidth=0),l(d))})};l(t.element)}},o.prototype.getLineHeight=function(e){var t,r=e.nodeType===Node.TEXT_NODE?e.parentElement:e;return this.renderer.styledMode||(t=r&&/(px|em)$/.test(r.style.fontSize)?r.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(t,r||this.svgElement.element).h},o.prototype.modifyTree=function(e){var t=this,r=function(n,s){var a=n.tagName,l=t.renderer.styledMode,h=n.attributes||{};if(a==="b"||a==="strong"?l?h.class="highcharts-strong":h.style="font-weight:bold;"+(h.style||""):(a==="i"||a==="em")&&(l?h.class="highcharts-emphasized":h.style="font-style:italic;"+(h.style||"")),isString$9(h.style)&&(h.style=h.style.replace(/(;| |^)color([ :])/,"$1fill$2")),a==="br"){h.class="highcharts-br",n.textContent="​";var c=e[s+1];c&&c.textContent&&(c.textContent=c.textContent.replace(/^ +/gm,""))}a!=="#text"&&a!=="a"&&(n.tagName="tspan"),n.attributes=h,n.children&&n.children.filter(function(d){return d.tagName!=="#text"}).forEach(r)};e.forEach(r)},o.prototype.truncate=function(e,t,r,n,s,a){var l=this.svgElement,h=l.renderer,c=l.rotation,d=[],f=r?1:0,p=(t||r||"").length,u=p,g,v,y=function(m,x){var b=x||m,$=e.parentNode;if($&&typeof d[b]>"u")if($.getSubStringLength)try{d[b]=n+$.getSubStringLength(0,r?b+1:b)}catch{}else h.getSpanWidth&&(e.textContent=a(t||r,m),d[b]=n+h.getSpanWidth(l,e));return d[b]};if(l.rotation=0,v=y(e.textContent.length),n+v>s){for(;f<=p;)u=Math.ceil((f+p)/2),r&&(g=a(r,u)),v=y(u,g&&g.length-1),f===p?f=p+1:v>s?p=u-1:f=u;p===0?e.textContent="":t&&p===t.length-1||(e.textContent=g||a(t||r,u))}r&&r.splice(0,u),l.actualWidth=v,l.rotation=c},o.prototype.unescapeEntities=function(e,t){return objectEach$v(this.renderer.escapes,function(r,n){(!t||t.indexOf(r)===-1)&&(e=e.toString().replace(new RegExp(r,"g"),n))}),e},o}(),charts$4=H.charts,deg2rad$7=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$k=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$10=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$Q=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1m=Utilities.extend,isArray$k=Utilities.isArray,isNumber$J=Utilities.isNumber,isObject$c=Utilities.isObject,isString$8=Utilities.isString,merge$1i=Utilities.merge,pick$1s=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=function(){function o(e,t,r,n,s,a,l){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(e,t,r,n,s,a,l)}return o.prototype.init=function(e,t,r,n,s,a,l){var h=this,c=h.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),d=c.element;l||c.css(this.getStyle(n)),e.appendChild(d),attr$4(e,"dir","ltr"),e.innerHTML.indexOf("xmlns")===-1&&attr$4(d,"xmlns",this.SVG_NS),h.isSVG=!0,this.box=d,this.boxWrapper=c,h.alignedObjects=[],this.url=this.getReferenceURL();var f=this.createElement("desc").add();f.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),h.defs=this.createElement("defs").add(),h.allowHTML=a,h.forExport=s,h.styledMode=l,h.gradients={},h.cache={},h.cacheKeys=[],h.imgCount=0,h.setSize(t,r,!1);var p,u;isFirefox$3&&e.getBoundingClientRect&&(p=function(){css$b(e,{left:0,top:0}),u=e.getBoundingClientRect(),css$b(e,{left:Math.ceil(u.left)-u.left+"px",top:Math.ceil(u.top)-u.top+"px"})},p(),h.unSubPixelFix=addEvent$10(win$c,"resize",p))},o.prototype.definition=function(e){var t=new AST([e]);return t.addToDOM(this.defs.element)},o.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$Q(hasInternalReferenceBug)){var e=uniqueKey$6(),t=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:e},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+e+")",fill:"rgba(0,0,0,0.001)"}}]}]),r=t.addToDOM(doc$j.body);css$b(r,{position:"fixed",top:0,left:0,zIndex:9e5});var n=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(n&&n.id)==="hitme",doc$j.body.removeChild(r)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},o.prototype.getStyle=function(e){return this.style=extend$1m({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},e),this.style},o.prototype.setStyle=function(e){this.boxWrapper.css(this.getStyle(e))},o.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},o.prototype.destroy=function(){var e=this,t=e.defs;return e.box=null,e.boxWrapper=e.boxWrapper.destroy(),destroyObjectProperties$9(e.gradients||{}),e.gradients=null,t&&(e.defs=t.destroy()),e.unSubPixelFix&&e.unSubPixelFix(),e.alignedObjects=null,null},o.prototype.createElement=function(e){var t=new this.Element;return t.init(this,e),t},o.prototype.getRadialAttr=function(e,t){return{cx:e[0]-e[2]/2+(t.cx||0)*e[2],cy:e[1]-e[2]/2+(t.cy||0)*e[2],r:(t.r||0)*e[2]}},o.prototype.buildText=function(e){new TextBuilder(e).buildSVG()},o.prototype.getContrast=function(e){return e=Color.parse(e).rgba,e[0]*=1,e[1]*=1.2,e[2]*=.5,e[0]+e[1]+e[2]>1.8*255?"#000000":"#FFFFFF"},o.prototype.button=function(e,t,r,n,s,a,l,h,c,d){var f=this.label(e,t,r,c,void 0,void 0,d,void 0,"button"),p=this.styledMode,u=0,g=s?merge$1i(s):{},v=g&&g.style||{};g=AST.filterUserAttributes(g),f.attr(merge$1i({padding:8,r:2},g));var y,m,x,b;return p||(g=merge$1i({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:v},g),y=g.style,delete g.style,a=merge$1i(g,{fill:palette.neutralColor10},AST.filterUserAttributes(a||{})),m=a.style,delete a.style,l=merge$1i(g,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(l||{})),x=l.style,delete l.style,h=merge$1i(g,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(h||{})),b=h.style,delete h.style),addEvent$10(f.element,isMS$2?"mouseover":"mouseenter",function(){u!==3&&f.setState(1)}),addEvent$10(f.element,isMS$2?"mouseout":"mouseleave",function(){u!==3&&f.setState(u)}),f.setState=function($){$!==1&&(f.state=u=$),f.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][$||0]),p||f.attr([g,a,l,h][$||0]).css([y,m,x,b][$||0])},p||f.attr(g).css(extend$1m({cursor:"default"},y)),f.on("touchstart",function($){return $.stopPropagation()}).on("click",function($){u!==3&&n.call(f,$)})},o.prototype.crispLine=function(e,t,r){r===void 0&&(r="round");var n=e[0],s=e[1];return defined$Q(n[1])&&n[1]===s[1]&&(n[1]=s[1]=Math[r](n[1])-t%2/2),defined$Q(n[2])&&n[2]===s[2]&&(n[2]=s[2]=Math[r](n[2])+t%2/2),e},o.prototype.path=function(e){var t=this.styledMode?{}:{fill:"none"};return isArray$k(e)?t.d=e:isObject$c(e)&&extend$1m(t,e),this.createElement("path").attr(t)},o.prototype.circle=function(e,t,r){var n=isObject$c(e)?e:typeof e>"u"?{}:{x:e,y:t,r},s=this.createElement("circle");return s.xSetter=s.ySetter=function(a,l,h){h.setAttribute("c"+l,a)},s.attr(n)},o.prototype.arc=function(e,t,r,n,s,a){var l;isObject$c(e)?(l=e,t=l.y,r=l.r,n=l.innerR,s=l.start,a=l.end,e=l.x):l={innerR:n,start:s,end:a};var h=this.symbol("arc",e,t,r,r,l);return h.r=r,h},o.prototype.rect=function(e,t,r,n,s,a){s=isObject$c(e)?e.r:s;var l=this.createElement("rect"),h=isObject$c(e)?e:typeof e>"u"?{}:{x:e,y:t,width:Math.max(r,0),height:Math.max(n,0)};return this.styledMode||(typeof a<"u"&&(h["stroke-width"]=a,h=l.crisp(h)),h.fill="none"),s&&(h.r=s),l.rSetter=function(c,d,f){l.r=c,attr$4(f,{rx:c,ry:c})},l.rGetter=function(){return l.r||0},l.attr(h)},o.prototype.setSize=function(e,t,r){var n=this;n.width=e,n.height=t,n.boxWrapper.animate({width:e,height:t},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1s(r,!0)?void 0:0}),n.alignElements()},o.prototype.g=function(e){var t=this.createElement("g");return e?t.attr({class:"highcharts-"+e}):t},o.prototype.image=function(e,t,r,n,s,a){var l={preserveAspectRatio:"none"},h=function(p,u){p.setAttributeNS?p.setAttributeNS("http://www.w3.org/1999/xlink","href",u):p.setAttribute("hc-svg-href",u)};arguments.length>1&&extend$1m(l,{x:t,y:r,width:n,height:s});var c=this.createElement("image").attr(l),d=function(p){h(c.element,e),a.call(c,p)};if(a){h(c.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var f=new win$c.Image;addEvent$10(f,"load",d),f.src=e,f.complete&&d({})}else h(c.element,e);return c},o.prototype.symbol=function(e,t,r,n,s,a){var l=this,h=/^url\((.*?)\)$/,c=h.test(e),d=!c&&(this.symbols[e]?e:"circle"),f=d&&this.symbols[d],p,u,g,v;if(f)typeof t=="number"&&(u=f.call(this.symbols,Math.round(t||0),Math.round(r||0),n||0,s||0,a)),p=this.path(u),l.styledMode||p.attr("fill","none"),extend$1m(p,{symbolName:d||void 0,x:t,y:r,width:n,height:s}),a&&extend$1m(p,a);else if(c){g=e.match(h)[1];var y=p=this.image(g);y.imgwidth=pick$1s(symbolSizes[g]&&symbolSizes[g].width,a&&a.width),y.imgheight=pick$1s(symbolSizes[g]&&symbolSizes[g].height,a&&a.height),v=function(m){return m.attr({width:m.width,height:m.height})},["width","height"].forEach(function(m){y[m+"Setter"]=function(x,b){var $=this["img"+b];if(this[b]=x,defined$Q($)&&(a&&a.backgroundSize==="within"&&this.width&&this.height&&($=Math.round($*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(b,$),!this.alignByTranslate)){var S=((this[b]||0)-$)/2,k=b==="width"?{translateX:S}:{translateY:S};this.attr(k)}}}),defined$Q(t)&&y.attr({x:t,y:r}),y.isImg=!0,defined$Q(y.imgwidth)&&defined$Q(y.imgheight)?v(y):(y.attr({width:0,height:0}),createElement$8("img",{onload:function(){var m=charts$4[l.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[g]={width:this.width,height:this.height},y.imgwidth=this.width,y.imgheight=this.height,y.element&&v(y),this.parentNode&&this.parentNode.removeChild(this),l.imgCount--,!l.imgCount&&m&&!m.hasLoaded&&m.onload()},src:g}),this.imgCount++)}return p},o.prototype.clipRect=function(e,t,r,n){var s=uniqueKey$6()+"-",a=this.createElement("clipPath").attr({id:s}).add(this.defs),l=this.rect(e,t,r,n,0).add(a);return l.id=s,l.clipPath=a,l.count=0,l},o.prototype.text=function(e,t,r,n){var s=this,a={};if(n&&(s.allowHTML||!s.forExport))return s.html(e,t,r);a.x=Math.round(t||0),r&&(a.y=Math.round(r)),defined$Q(e)&&(a.text=e);var l=s.createElement("text").attr(a);return(!n||s.forExport&&!s.allowHTML)&&(l.xSetter=function(h,c,d){for(var f=d.getElementsByTagName("tspan"),p=d.getAttribute(c),u=0,g=void 0;u<f.length;u++)g=f[u],g.getAttribute(c)===p&&g.setAttribute(c,h);d.setAttribute(c,h)}),l},o.prototype.fontMetrics=function(e,t){(this.styledMode||!/px/.test(e))&&win$c.getComputedStyle?e=t&&SVGElement.prototype.getStyle.call(t,"font-size"):e=e||t&&t.style&&t.style.fontSize||this.style&&this.style.fontSize,/px/.test(e)?e=pInt$6(e):e=12;var r=e<24?e+3:Math.round(e*1.2),n=Math.round(r*.8);return{h:r,b:n,f:e}},o.prototype.rotCorr=function(e,t,r){var n=e;return t&&r&&(n=Math.max(n*Math.cos(t*deg2rad$7),4)),{x:-e/3*Math.sin(t*deg2rad$7),y:n}},o.prototype.pathToSegments=function(e){for(var t=[],r=[],n={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},s=0;s<e.length;s++)isString$8(r[0])&&isNumber$J(e[s])&&r.length===n[r[0].toUpperCase()]&&e.splice(s,0,r[0].replace("M","L").replace("m","l")),typeof e[s]=="string"&&(r.length&&t.push(r.slice(0)),r.length=0),r.push(e[s]);return t.push(r.slice(0)),t},o.prototype.label=function(e,t,r,n,s,a,l,h,c){return new SVGLabel(this,e,t,r,n,s,a,l,h,c)},o.prototype.alignElements=function(){this.alignedObjects.forEach(function(e){return e.align()})},o}();extend$1m(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$k});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$X=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$P=Utilities.defined,extend$1l=Utilities.extend,pick$1r=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement=function(o){__extends$X(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.compose=function(t){if(e.composedClasses.indexOf(t)===-1){e.composedClasses.push(t);var r=e.prototype,n=t.prototype;n.getSpanCorrection=r.getSpanCorrection,n.htmlCss=r.htmlCss,n.htmlGetBBox=r.htmlGetBBox,n.htmlUpdateTransform=r.htmlUpdateTransform,n.setSpanRotation=r.setSpanRotation}return t},e.prototype.getSpanCorrection=function(t,r,n){this.xCorr=-t*n,this.yCorr=-r},e.prototype.htmlCss=function(t){var r=this,n=r.element,s=n.tagName==="SPAN"&&t&&"width"in t,a=pick$1r(s&&t.width,void 0),l;return s&&(delete t.width,r.textWidth=a,l=!0),t&&t.textOverflow==="ellipsis"&&(t.whiteSpace="nowrap",t.overflow="hidden"),r.styles=extend$1l(r.styles,t),css$a(r.element,t),l&&r.htmlUpdateTransform(),r},e.prototype.htmlGetBBox=function(){var t=this,r=t.element;return{x:r.offsetLeft,y:r.offsetTop,width:r.offsetWidth,height:r.offsetHeight}},e.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var t=this,r=t.renderer,n=t.element,s=t.translateX||0,a=t.translateY||0,l=t.x||0,h=t.y||0,c=t.textAlign||"left",d={left:0,center:.5,right:1}[c],f=t.styles,p=f&&f.whiteSpace;function u(){return css$a(n,{width:"",whiteSpace:p||"nowrap"}),n.offsetWidth}if(css$a(n,{marginLeft:s,marginTop:a}),!r.styledMode&&t.shadows&&t.shadows.forEach(function(x){css$a(x,{marginLeft:s+1,marginTop:a+1})}),t.inverted&&[].forEach.call(n.childNodes,function(x){r.invertChild(x,n)}),n.tagName==="SPAN"){var g=t.rotation,v=t.textWidth&&pInt$5(t.textWidth),y=[g,c,n.innerHTML,t.textWidth,t.textAlign].join(","),m=void 0;v!==t.oldTextWidth&&(v>t.oldTextWidth||(t.textPxLength||u())>v)&&(/[ \-]/.test(n.textContent||n.innerText)||n.style.textOverflow==="ellipsis")?(css$a(n,{width:v+"px",display:"block",whiteSpace:p||"normal"}),t.oldTextWidth=v,t.hasBoxWidthChanged=!0):t.hasBoxWidthChanged=!1,y!==t.cTT&&(m=r.fontMetrics(n.style.fontSize,n).b,defined$P(g)&&(g!==(t.oldRotation||0)||c!==t.oldAlign)&&t.setSpanRotation(g,d,m),t.getSpanCorrection(!defined$P(g)&&t.textPxLength||n.offsetWidth,m,d,g,c)),css$a(n,{left:l+(t.xCorr||0)+"px",top:h+(t.yCorr||0)+"px"}),t.cTT=y,t.oldRotation=g,t.oldAlign=c}},e.prototype.setSpanRotation=function(t,r,n){var s=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},a={},l=s();l&&(a[l]=a.transform="rotate("+t+"deg)",a[l+(isFirefox$2?"Origin":"-origin")]=a.transformOrigin=r*100+"% "+n+"px",css$a(this.element,a))},e.composedClasses=[],e}(SVGElement),__extends$W=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1k=Utilities.extend,pick$1q=Utilities.pick,HTMLRenderer=function(o){__extends$W(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.compose=function(t){if(e.composedClasses.indexOf(t)===-1){e.composedClasses.push(t);var r=e.prototype,n=t.prototype;n.html=r.html}return t},e.prototype.html=function(t,r,n){var s=this.createElement("span"),a=s.element,l=s.renderer,h=l.isSVG,c=function(d,f){["opacity","visibility"].forEach(function(p){d[p+"Setter"]=function(u,g,v){var y=d.div?d.div.style:f;SVGElement.prototype[p+"Setter"].call(this,u,g,v),y&&(y[g]=u)}}),d.addedSetters=!0};return s.textSetter=function(d){d!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1q(d,"")),this.textStr=d,s.doTransform=!0)},h&&c(s,s.element.style),s.xSetter=s.ySetter=s.alignSetter=s.rotationSetter=function(d,f){f==="align"?s.alignValue=s.textAlign=d:s[f]=d,s.doTransform=!0},s.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},s.attr({text:t,x:Math.round(r),y:Math.round(n)}).css({position:"absolute"}),l.styledMode||s.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),a.style.whiteSpace="nowrap",s.css=s.htmlCss,h&&(s.add=function(d){var f=l.box.parentNode,p=[],u,g;if(this.parentGroup=d,d){if(u=d.div,!u){for(g=d;g;)p.push(g),g=g.parentGroup;p.reverse().forEach(function(v){var y=attr$3(v.element,"class");function m($,S){v[S]=$,S==="translateX"?b.left=$+"px":b.top=$+"px",v.doTransform=!0}var x=v.styles||{};u=v.div=v.div||createElement$7("div",y?{className:y}:void 0,{position:"absolute",left:(v.translateX||0)+"px",top:(v.translateY||0)+"px",display:v.display,opacity:v.opacity,cursor:x.cursor,pointerEvents:x.pointerEvents,visibility:v.visibility},u||f);var b=u.style;extend$1k(v,{classSetter:function($){return function(S){this.element.setAttribute("class",S),$.className=S}}(u),on:function(){return p[0].div&&s.on.apply({element:p[0].div,onEvents:v.onEvents},arguments),v},translateXSetter:m,translateYSetter:m}),v.addedSetters||c(v)})}}else u=f;return u.appendChild(a),s.added=!0,s.alignOnAdd&&s.htmlUpdateTransform(),s}),s},e.composedClasses=[],e}(SVGRenderer),AxisDefaults;(function(o){o.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},o.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var e=this.axis.chart.numberFormatter;return e(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},o.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},o.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},o.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},o.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$$=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$u=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(o,e){o.eventOptions=o.eventOptions||{},objectEach$u(e.events,function(t,r){o.eventOptions[r]!==t&&(o.eventOptions[r]&&(removeEvent$a(o,r,o.eventOptions[r]),delete o.eventOptions[r]),isFunction$3(t)&&(o.eventOptions[r]=t,addEvent$$(o,r,t)))})},exports$3={registerEventOptions:registerEventOptions$3},deg2rad$6=H.deg2rad,clamp$h=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$O=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1j=Utilities.extend,fireEvent$z=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1h=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1p=Utilities.pick,Tick=function(){function o(e,t,r,n,s){this.isNew=!0,this.isNewLabel=!0,this.axis=e,this.pos=t,this.type=r||"",this.parameters=s||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$z(this,"init"),!r&&!n&&this.addLabel()}return o.prototype.addLabel=function(){var e=this,t=e.axis,r=t.options,n=t.chart,s=t.categories,a=t.logarithmic,l=t.names,h=e.pos,c=pick$1p(e.options&&e.options.labels,r.labels),d=t.tickPositions,f=h===d[0],p=h===d[d.length-1],u=(!c.step||c.step===1)&&t.tickInterval===1,g=d.info,v=e.label,y,m,x,b=this.parameters.category||(s?pick$1p(s[h],l[h],h):h);a&&isNumber$I(b)&&(b=correctFloat$c(a.lin2log(b))),t.dateTime&&(g?(m=n.time.resolveDTLFormat(r.dateTimeLabelFormats[!r.grid&&g.higherRanks[h]||g.unitName]),y=m.main):isNumber$I(b)&&(y=t.dateTime.getXDateFormat(b,r.dateTimeLabelFormats||{}))),e.isFirst=f,e.isLast=p;var $={axis:t,chart:n,dateTimeLabelFormat:y,isFirst:f,isLast:p,pos:h,tick:e,tickPositionInfo:g,value:b};fireEvent$z(this,"labelFormat",$);var S=function(M){return c.formatter?c.formatter.call(M,M):c.format?(M.text=t.defaultLabelFormatter.call(M),FormatUtilities.format(c.format,M,n)):t.defaultLabelFormatter.call(M,M)},k=S.call($,$),A=m&&m.list;A?e.shortenLabel=function(){for(x=0;x<A.length;x++)if(extend$1j($,{dateTimeLabelFormat:A[x]}),v.attr({text:S.call($,$)}),v.getBBox().width<t.getSlotWidth(e)-2*c.padding)return;v.attr({text:""})}:e.shortenLabel=void 0,u&&t._addedPlotLB&&e.moveLabel(k,c),!defined$O(v)&&!e.movedLabel?(e.label=v=e.createLabel({x:0,y:0},k,c),e.rotation=0):v&&v.textStr!==k&&!u&&(v.textWidth&&!c.style.width&&!v.styles.width&&v.css({width:null}),v.attr({text:k}),v.textPxLength=v.getBBox().width)},o.prototype.createLabel=function(e,t,r){var n=this.axis,s=n.chart,a=defined$O(t)&&r.enabled?s.renderer.text(t,e.x,e.y,r.useHTML).add(n.labelGroup):null;return a&&(s.styledMode||a.css(merge$1h(r.style)),a.textPxLength=a.getBBox().width),a},o.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},o.prototype.getPosition=function(e,t,r,n){var s=this.axis,a=s.chart,l=n&&a.oldChartHeight||a.chartHeight,h={x:e?correctFloat$c(s.translate(t+r,null,null,n)+s.transB):s.left+s.offset+(s.opposite?(n&&a.oldChartWidth||a.chartWidth)-s.right-s.left:0),y:e?l-s.bottom+s.offset-(s.opposite?s.height:0):correctFloat$c(l-s.translate(t+r,null,null,n)-s.transB)};return h.y=clamp$h(h.y,-1e5,1e5),fireEvent$z(this,"afterGetPosition",{pos:h}),h},o.prototype.getLabelPosition=function(e,t,r,n,s,a,l,h){var c=this.axis,d=c.transA,f=c.isLinked&&c.linkedParent?c.linkedParent.reversed:c.reversed,p=c.staggerLines,u=c.tickRotCorr||{x:0,y:0},g=!n&&!c.reserveSpaceDefault?-c.labelOffset*(c.labelAlign==="center"?.5:1):0,v={},y=s.y,m;return defined$O(y)||(c.side===0?y=r.rotation?-8:-r.getBBox().height:c.side===2?y=u.y+8:y=Math.cos(r.rotation*deg2rad$6)*(u.y-r.getBBox(!1,0).height/2)),e=e+s.x+g+u.x-(a&&n?a*d*(f?-1:1):0),t=t+y-(a&&!n?a*d*(f?1:-1):0),p&&(m=l/(h||1)%p,c.opposite&&(m=p-m-1),t+=m*(c.labelOffset/p)),v.x=e,v.y=Math.round(t),fireEvent$z(this,"afterGetLabelPosition",{pos:v,tickmarkOffset:a,index:l}),v},o.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},o.prototype.getMarkPath=function(e,t,r,n,s,a){return a.crispLine([["M",e,t],["L",e+(s?0:-r),t+(s?r:0)]],n)},o.prototype.handleOverflow=function(e){var t=this,r=this.axis,n=r.options.labels,s=e.x,a=r.chart.chartWidth,l=r.chart.spacing,h=pick$1p(r.labelLeft,Math.min(r.pos,l[3])),c=pick$1p(r.labelRight,Math.max(r.isRadial?0:r.pos+r.len,a-l[1])),d=this.label,f=this.rotation,p={left:0,center:.5,right:1}[r.labelAlign||d.attr("align")],u=d.getBBox().width,g=r.getSlotWidth(t),v=p,y={},m=g,x=1,b,$,S;!f&&n.overflow==="justify"?(b=s-p*u,$=s+(1-p)*u,b<h?m=e.x+m*(1-p)-h:$>c&&(m=c-e.x+m*p,x=-1),m=Math.min(g,m),m<g&&r.labelAlign==="center"&&(e.x+=x*(g-m-v*(g-Math.min(u,m)))),(u>m||r.autoRotation&&(d.styles||{}).width)&&(S=m)):f<0&&s-p*u<h?S=Math.round(s/Math.cos(f*deg2rad$6)-h):f>0&&s+p*u>c&&(S=Math.round((a-s)/Math.cos(f*deg2rad$6))),S&&(t.shortenLabel?t.shortenLabel():(y.width=Math.floor(S)+"px",(n.style||{}).textOverflow||(y.textOverflow="ellipsis"),d.css(y)))},o.prototype.moveLabel=function(e,t){var r=this,n=r.label,s=r.axis,a=s.reversed,l=!1,h,c,d;n&&n.textStr===e?(r.movedLabel=n,l=!0,delete r.label):objectEach$t(s.ticks,function(f){!l&&!f.isNew&&f!==r&&f.label&&f.label.textStr===e&&(r.movedLabel=f.label,l=!0,f.labelPos=r.movedLabel.xy,delete f.label)}),!l&&(r.labelPos||n)&&(h=r.labelPos||n.xy,c=s.horiz?a?0:s.width+s.left:h.x,d=s.horiz?h.y:a?s.width+s.left:0,r.movedLabel=r.createLabel({x:c,y:d},e,t),r.movedLabel&&r.movedLabel.attr({opacity:0}))},o.prototype.render=function(e,t,r){var n=this,s=n.axis,a=s.horiz,l=n.pos,h=pick$1p(n.tickmarkOffset,s.tickmarkOffset),c=n.getPosition(a,l,h,t),d=c.x,f=c.y,p=a&&d===s.pos+s.len||!a&&f===s.pos?-1:1,u=pick$1p(r,n.label&&n.label.newOpacity,1);r=pick$1p(r,1),this.isActive=!0,this.renderGridLine(t,r,p),this.renderMark(c,r,p),this.renderLabel(c,t,u,e),n.isNew=!1,fireEvent$z(this,"afterRender")},o.prototype.renderGridLine=function(e,t,r){var n=this,s=n.axis,a=s.options,l={},h=n.pos,c=n.type,d=pick$1p(n.tickmarkOffset,s.tickmarkOffset),f=s.chart.renderer,p=n.gridLine,u,g=a.gridLineWidth,v=a.gridLineColor,y=a.gridLineDashStyle;n.type==="minor"&&(g=a.minorGridLineWidth,v=a.minorGridLineColor,y=a.minorGridLineDashStyle),p||(s.chart.styledMode||(l.stroke=v,l["stroke-width"]=g||0,l.dashstyle=y),c||(l.zIndex=1),e&&(t=0),n.gridLine=p=f.path().attr(l).addClass("highcharts-"+(c?c+"-":"")+"grid-line").add(s.gridGroup)),p&&(u=s.getPlotLinePath({value:h+d,lineWidth:p.strokeWidth()*r,force:"pass",old:e}),u&&p[e||n.isNew?"attr":"animate"]({d:u,opacity:t}))},o.prototype.renderMark=function(e,t,r){var n=this,s=n.axis,a=s.options,l=s.chart.renderer,h=n.type,c=s.tickSize(h?h+"Tick":"tick"),d=e.x,f=e.y,p=pick$1p(a[h!=="minor"?"tickWidth":"minorTickWidth"],!h&&s.isXAxis?1:0),u=a[h!=="minor"?"tickColor":"minorTickColor"],g=n.mark,v=!g;c&&(s.opposite&&(c[0]=-c[0]),g||(n.mark=g=l.path().addClass("highcharts-"+(h?h+"-":"")+"tick").add(s.axisGroup),s.chart.styledMode||g.attr({stroke:u,"stroke-width":p})),g[v?"attr":"animate"]({d:n.getMarkPath(d,f,c[0],g.strokeWidth()*r,s.horiz,l),opacity:t}))},o.prototype.renderLabel=function(e,t,r,n){var s=this,a=s.axis,l=a.horiz,h=a.options,c=s.label,d=h.labels,f=d.step,p=pick$1p(s.tickmarkOffset,a.tickmarkOffset),u=e.x,g=e.y,v=!0;c&&isNumber$I(u)&&(c.xy=e=s.getLabelPosition(u,g,c,l,d,p,n,f),s.isFirst&&!s.isLast&&!h.showFirstLabel||s.isLast&&!s.isFirst&&!h.showLastLabel?v=!1:l&&!d.step&&!d.rotation&&!t&&r!==0&&s.handleOverflow(e),f&&n%f&&(v=!1),v&&isNumber$I(e.y)?(e.opacity=r,c[s.isNewLabel?"attr":"animate"](e),s.isNewLabel=!1):(c.attr("y",-9999),s.isNewLabel=!0))},o.prototype.replaceMovedLabel=function(){var e=this,t=e.label,r=e.axis,n=r.reversed,s,a;t&&!e.isNew&&(s=r.horiz?n?r.left:r.width+r.left:t.xy.x,a=r.horiz?t.xy.y:n?r.width+r.top:r.top,t.animate({x:s,y:a,opacity:0},void 0,t.destroy),delete e.label),r.isDirty=!0,e.label=e.movedLabel,delete e.movedLabel},o}(),animObject$a=animationExports.animObject,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions$2=exports$3.registerEventOptions,deg2rad$5=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$g=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$N=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$7=Utilities.erase,error$7=Utilities.error,extend$1i=Utilities.extend,fireEvent$y=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isString$7=Utilities.isString,merge$1g=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$s=Utilities.objectEach,pick$1o=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$g=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=function(){function o(e,t){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(e,t)}return o.prototype.init=function(e,t){var r=t.isX,n=this;n.chart=e,n.horiz=e.inverted&&!n.isZAxis?!r:r,n.isXAxis=r,n.coll=n.coll||(r?"xAxis":"yAxis"),fireEvent$y(this,"init",{userOptions:t}),n.opposite=pick$1o(t.opposite,n.opposite),n.side=pick$1o(t.side,n.side,n.horiz?n.opposite?0:2:n.opposite?1:3),n.setOptions(t);var s=this.options,a=s.labels,l=s.type;n.userOptions=t,n.minPixelPadding=0,n.reversed=pick$1o(s.reversed,n.reversed),n.visible=s.visible,n.zoomEnabled=s.zoomEnabled,n.hasNames=l==="category"||s.categories===!0,n.categories=s.categories||n.hasNames,n.names||(n.names=[],n.names.keys={}),n.plotLinesAndBandsGroups={},n.positiveValuesOnly=!!n.logarithmic,n.isLinked=defined$N(s.linkedTo),n.ticks={},n.labelEdge=[],n.minorTicks={},n.plotLinesAndBands=[],n.alternateBands={},n.len=0,n.minRange=n.userMinRange=s.minRange||s.maxZoom,n.range=s.range,n.offset=s.offset||0,n.max=null,n.min=null;var h=pick$1o(s.crosshair,splat$g(e.options.tooltip.crosshairs)[r?0:1]);n.crosshair=h===!0?{}:h,e.axes.indexOf(n)===-1&&(r?e.axes.splice(e.xAxis.length,0,n):e.axes.push(n),e[n.coll].push(n)),n.series=n.series||[],e.inverted&&!n.isZAxis&&r&&typeof n.reversed>"u"&&(n.reversed=!0),n.labelRotation=isNumber$H(a.rotation)?a.rotation:void 0,registerEventOptions$2(n,s),fireEvent$y(this,"afterInit")},o.prototype.setOptions=function(e){this.options=merge$1g(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1g(defaultOptions$d[this.coll],e)),fireEvent$y(this,"afterSetOptions",{userOptions:e})},o.prototype.defaultLabelFormatter=function(e){var t=this.axis,r=this.chart,n=r.numberFormatter,s=isNumber$H(this.value)?this.value:NaN,a=t.chart.time,l=t.categories,h=this.dateTimeLabelFormat,c=defaultOptions$d.lang,d=c.numericSymbols,f=c.numericSymbolMagnitude||1e3,p=t.logarithmic?Math.abs(s):t.tickInterval,u=d&&d.length,g,v;if(l)v=""+this.value;else if(h)v=a.dateFormat(h,s);else if(u&&p>=1e3)for(;u--&&typeof v>"u";)g=Math.pow(f,u+1),p>=g&&s*10%g===0&&d[u]!==null&&s!==0&&(v=n(s/g,-1)+d[u]);return typeof v>"u"&&(Math.abs(s)>=1e4?v=n(s,-1):v=n(s,-1,void 0,"")),v},o.prototype.getSeriesExtremes=function(){var e=this,t=e.chart,r;fireEvent$y(this,"getSeriesExtremes",null,function(){e.hasVisibleSeries=!1,e.dataMin=e.dataMax=e.threshold=null,e.softThreshold=!e.isXAxis,e.stacking&&e.stacking.buildStacks(),e.series.forEach(function(n){if(n.visible||!t.options.chart.ignoreHiddenSeries){var s=n.options,a=void 0,l=s.threshold,h=void 0,c=void 0;if(e.hasVisibleSeries=!0,e.positiveValuesOnly&&l<=0&&(l=null),e.isXAxis)a=n.xData,a.length&&(a=e.logarithmic?a.filter(e.validatePositiveValue):a,r=n.getXExtremes(a),h=r.min,c=r.max,!isNumber$H(h)&&!(h instanceof Date)&&(a=a.filter(isNumber$H),r=n.getXExtremes(a),h=r.min,c=r.max),a.length&&(e.dataMin=Math.min(pick$1o(e.dataMin,h),h),e.dataMax=Math.max(pick$1o(e.dataMax,c),c)));else{var d=n.applyExtremes();isNumber$H(d.dataMin)&&(h=d.dataMin,e.dataMin=Math.min(pick$1o(e.dataMin,h),h)),isNumber$H(d.dataMax)&&(c=d.dataMax,e.dataMax=Math.max(pick$1o(e.dataMax,c),c)),defined$N(l)&&(e.threshold=l),(!s.softThreshold||e.positiveValuesOnly)&&(e.softThreshold=!1)}}})}),fireEvent$y(this,"afterGetSeriesExtremes")},o.prototype.translate=function(e,t,r,n,s,a){var l=this.linkedParent||this,h=n&&l.old?l.old.min:l.min,c=l.minPixelPadding,d=(l.isOrdinal||l.brokenAxis&&l.brokenAxis.hasBreaks||l.logarithmic&&s)&&l.lin2val,f=1,p=0,u=n&&l.old?l.old.transA:l.transA,g=0;return u||(u=l.transA),r&&(f*=-1,p=l.len),l.reversed&&(f*=-1,p-=f*(l.sector||l.len)),t?(e=e*f+p,e-=c,g=e/u+h,d&&(g=l.lin2val(g))):(d&&(e=l.val2lin(e)),g=isNumber$H(h)?f*(e-h)*u+p+f*c+(isNumber$H(a)?u*a:0):void 0),g},o.prototype.toPixels=function(e,t){return this.translate(e,!1,!this.horiz,null,!0)+(t?0:this.pos)},o.prototype.toValue=function(e,t){return this.translate(e-(t?0:this.pos),!0,!this.horiz,null,!0)},o.prototype.getPlotLinePath=function(e){var t=this,r=t.chart,n=t.left,s=t.top,a=e.old,l=e.value,h=e.lineWidth,c=a&&r.oldChartHeight||r.chartHeight,d=a&&r.oldChartWidth||r.chartWidth,f=t.transB,p=e.translatedValue,u=e.force,g,v,y,m,x;function b(S,k,A){return(u!=="pass"&&S<k||S>A)&&(u?S=clamp$g(S,k,A):x=!0),S}var $={value:l,lineWidth:h,old:a,force:u,acrossPanes:e.acrossPanes,translatedValue:p};return fireEvent$y(this,"getPlotLinePath",$,function(S){p=pick$1o(p,t.translate(l,null,null,a)),p=clamp$g(p,-1e5,1e5),g=y=Math.round(p+f),v=m=Math.round(c-p-f),isNumber$H(p)?t.horiz?(v=s,m=c-t.bottom,g=y=b(g,n,n+t.width)):(g=n,y=d-t.right,v=m=b(v,s,s+t.height)):(x=!0,u=!1),S.path=x&&!u?null:r.renderer.crispLine([["M",g,v],["L",y,m]],h||1)}),$.path},o.prototype.getLinearTickPositions=function(e,t,r){var n=correctFloat$b(Math.floor(t/e)*e),s=correctFloat$b(Math.ceil(r/e)*e),a=[],l,h,c;if(correctFloat$b(n+e)===n&&(c=20),this.single)return[t];for(l=n;l<=s&&(a.push(l),l=correctFloat$b(l+e,c),l!==h);)h=l;return a},o.prototype.getMinorTickInterval=function(){var e=this.options;return e.minorTicks===!0?pick$1o(e.minorTickInterval,"auto"):e.minorTicks===!1?null:e.minorTickInterval},o.prototype.getMinorTickPositions=function(){var e=this,t=e.options,r=e.tickPositions,n=e.minorTickInterval,s=e.pointRangePadding||0,a=e.min-s,l=e.max+s,h=l-a,c=[],d;if(h&&h/n<e.len/3){var f=e.logarithmic;if(f)this.paddedTicks.forEach(function(p,u,g){u&&c.push.apply(c,f.getLogTickPositions(n,g[u-1],g[u],!0))});else if(e.dateTime&&this.getMinorTickInterval()==="auto")c=c.concat(e.getTimeTicks(e.dateTime.normalizeTimeTickInterval(n),a,l,t.startOfWeek));else for(d=a+(r[0]-a)%n;d<=l&&d!==c[0];d+=n)c.push(d)}return c.length!==0&&e.trimTicks(c),c},o.prototype.adjustForMinRange=function(){var e=this,t=e.options,r=e.logarithmic,n=e.min,s=e.max,a,l,h=0,c,d,f,p,u,g,v;e.isXAxis&&typeof e.minRange>"u"&&!r&&(defined$N(t.min)||defined$N(t.max)?e.minRange=null:(e.series.forEach(function(y){if(f=y.xData,p=y.xIncrement?1:f.length-1,f.length>1)for(c=p;c>0;c--)d=f[c]-f[c-1],(!h||d<h)&&(h=d)}),e.minRange=Math.min(h*5,e.dataMax-e.dataMin))),s-n<e.minRange&&(l=e.dataMax-e.dataMin>=e.minRange,v=e.minRange,a=(v-s+n)/2,u=[n-a,pick$1o(t.min,n-a)],l&&(u[2]=e.logarithmic?e.logarithmic.log2lin(e.dataMin):e.dataMin),n=arrayMax$9(u),g=[n+v,pick$1o(t.max,n+v)],l&&(g[2]=r?r.log2lin(e.dataMax):e.dataMax),s=arrayMin$8(g),s-n<v&&(u[0]=s-v,u[1]=pick$1o(t.min,s-v),n=arrayMax$9(u))),e.min=n,e.max=s},o.prototype.getClosest=function(){var e;return this.categories?e=1:this.series.forEach(function(t){var r=t.closestPointRange,n=t.visible||!t.chart.options.chart.ignoreHiddenSeries;!t.noSharedTooltip&&defined$N(r)&&n&&(e=defined$N(e)?Math.min(e,r):r)}),e},o.prototype.nameToX=function(e){var t=isArray$j(this.categories),r=t?this.categories:this.names,n=e.options.x,s;return e.series.requireSorting=!1,defined$N(n)||(n=this.options.uniqueNames?t?r.indexOf(e.name):pick$1o(r.keys[e.name],-1):e.series.autoIncrement()),n===-1?t||(s=r.length):s=n,typeof s<"u"&&(this.names[s]=e.name,this.names.keys[e.name]=s),s},o.prototype.updateNames=function(){var e=this,t=this.names,r=t.length;r>0&&(Object.keys(t.keys).forEach(function(n){delete t.keys[n]}),t.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(n){n.xIncrement=null,(!n.points||n.isDirtyData)&&(e.max=Math.max(e.max,n.xData.length-1),n.processData(),n.generatePoints()),n.data.forEach(function(s,a){var l;s&&s.options&&typeof s.name<"u"&&(l=e.nameToX(s),typeof l<"u"&&l!==s.x&&(s.x=l,n.xData[a]=l))})}))},o.prototype.setAxisTranslation=function(){var e=this,t=e.max-e.min,r=e.linkedParent,n=!!e.categories,s=e.isXAxis,a=e.axisPointRange||0,l,h=0,c=0,d,f=e.transA;(s||n||a)&&(l=e.getClosest(),r?(h=r.minPointOffset,c=r.pointRangePadding):e.series.forEach(function(p){var u=n?1:s?pick$1o(p.options.pointRange,l,0):e.axisPointRange||0,g=p.options.pointPlacement;if(a=Math.max(a,u),!e.single||n){var v=p.is("xrange")?!s:s;h=Math.max(h,v&&isString$7(g)?0:u/2),c=Math.max(c,v&&g==="on"?0:u)}}),d=e.ordinal&&e.ordinal.slope&&l?e.ordinal.slope/l:1,e.minPointOffset=h=h*d,e.pointRangePadding=c=c*d,e.pointRange=Math.min(a,e.single&&n?1:t),s&&(e.closestPointRange=l)),e.translationSlope=e.transA=f=e.staticScale||e.len/(t+c||1),e.transB=e.horiz?e.left:e.bottom,e.minPixelPadding=f*h,fireEvent$y(this,"afterSetAxisTranslation")},o.prototype.minFromRange=function(){var e=this;return e.max-e.range},o.prototype.setTickInterval=function(e){var t=this,r=t.chart,n=t.logarithmic,s=t.options,a=t.isXAxis,l=t.isLinked,h=s.tickPixelInterval,c=t.categories,d=t.softThreshold,f=s.maxPadding,p=s.minPadding,u,g,v=s.tickInterval,y=isNumber$H(t.threshold)?t.threshold:null,m,x,b,$;!t.dateTime&&!c&&!l&&this.getTickAmount(),b=pick$1o(t.userMin,s.min),$=pick$1o(t.userMax,s.max),l?(t.linkedParent=r[t.coll][s.linkedTo],g=t.linkedParent.getExtremes(),t.min=pick$1o(g.min,g.dataMin),t.max=pick$1o(g.max,g.dataMax),s.type!==t.linkedParent.options.type&&error$7(11,1,r)):(d&&defined$N(y)&&(t.dataMin>=y?(m=y,p=0):t.dataMax<=y&&(x=y,f=0)),t.min=pick$1o(b,m,t.dataMin),t.max=pick$1o($,x,t.dataMax)),n&&(t.positiveValuesOnly&&!e&&Math.min(t.min,pick$1o(t.dataMin,t.min))<=0&&error$7(10,1,r),t.min=correctFloat$b(n.log2lin(t.min),16),t.max=correctFloat$b(n.log2lin(t.max),16)),t.range&&defined$N(t.max)&&(t.userMin=t.min=b=Math.max(t.dataMin,t.minFromRange()),t.userMax=$=t.max,t.range=null),fireEvent$y(t,"foundExtremes"),t.beforePadding&&t.beforePadding(),t.adjustForMinRange(),!c&&!t.axisPointRange&&!(t.stacking&&t.stacking.usePercentage)&&!l&&defined$N(t.min)&&defined$N(t.max)&&(u=t.max-t.min,u&&(!defined$N(b)&&p&&(t.min-=u*p),!defined$N($)&&f&&(t.max+=u*f))),isNumber$H(t.userMin)||(isNumber$H(s.softMin)&&s.softMin<t.min&&(t.min=b=s.softMin),isNumber$H(s.floor)&&(t.min=Math.max(t.min,s.floor))),isNumber$H(t.userMax)||(isNumber$H(s.softMax)&&s.softMax>t.max&&(t.max=$=s.softMax),isNumber$H(s.ceiling)&&(t.max=Math.min(t.max,s.ceiling))),d&&defined$N(t.dataMin)&&(y=y||0,!defined$N(b)&&t.min<y&&t.dataMin>=y?t.min=t.options.minRange?Math.min(y,t.max-t.minRange):y:!defined$N($)&&t.max>y&&t.dataMax<=y&&(t.max=t.options.minRange?Math.max(y,t.min+t.minRange):y)),isNumber$H(t.min)&&isNumber$H(t.max)&&!this.chart.polar&&t.min>t.max&&(defined$N(t.options.min)?t.max=t.min:defined$N(t.options.max)&&(t.min=t.max)),t.min===t.max||typeof t.min>"u"||typeof t.max>"u"?t.tickInterval=1:l&&t.linkedParent&&!v&&h===t.linkedParent.options.tickPixelInterval?t.tickInterval=v=t.linkedParent.tickInterval:t.tickInterval=pick$1o(v,this.tickAmount?(t.max-t.min)/Math.max(this.tickAmount-1,1):void 0,c?1:(t.max-t.min)*h/Math.max(t.len,h)),a&&!e&&(t.series.forEach(function(k){k.forceCrop=k.forceCropping&&k.forceCropping(),k.processData(t.min!==(t.old&&t.old.min)||t.max!==(t.old&&t.old.max))}),fireEvent$y(this,"postProcessData")),t.setAxisTranslation(),fireEvent$y(this,"initialAxisTranslation"),t.pointRange&&!v&&(t.tickInterval=Math.max(t.pointRange,t.tickInterval));var S=pick$1o(s.minTickInterval,t.dateTime&&!t.series.some(function(k){return k.noSharedTooltip})?t.closestPointRange:0);!v&&t.tickInterval<S&&(t.tickInterval=S),!t.dateTime&&!t.logarithmic&&!v&&(t.tickInterval=normalizeTickInterval$2(t.tickInterval,void 0,getMagnitude$2(t.tickInterval),pick$1o(s.allowDecimals,t.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(t.tickInterval=t.unsquish()),this.setTickPositions()},o.prototype.setTickPositions=function(){var e=this,t=this.options,r=t.tickPositions,n=this.getMinorTickInterval(),s=this.hasVerticalPanning(),a=this.coll==="colorAxis",l=(a||!s)&&t.startOnTick,h=(a||!s)&&t.endOnTick,c,d=t.tickPositioner;this.tickmarkOffset=this.categories&&t.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=n==="auto"&&this.tickInterval?this.tickInterval/5:n,this.single=this.min===this.max&&defined$N(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||t.allowDecimals!==!1),this.tickPositions=c=r&&r.slice(),c||((!e.ordinal||!e.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(c=[this.min,this.max],error$7(19,!1,this.chart)):e.dateTime?c=e.getTimeTicks(e.dateTime.normalizeTimeTickInterval(this.tickInterval,t.units),this.min,this.max,t.startOfWeek,e.ordinal&&e.ordinal.positions,this.closestPointRange,!0):e.logarithmic?c=e.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):c=this.getLinearTickPositions(this.tickInterval,this.min,this.max),c.length>this.len&&(c=[c[0],c.pop()],c[0]===c[1]&&(c.length=1)),this.tickPositions=c,d&&(d=d.apply(e,[this.min,this.max]),d&&(this.tickPositions=c=d))),this.paddedTicks=c.slice(0),this.trimTicks(c,l,h),this.isLinked||(this.single&&c.length<2&&!this.categories&&!this.series.some(function(f){return f.is("heatmap")&&f.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!r&&!d&&this.adjustTickAmount()),fireEvent$y(this,"afterSetTickPositions")},o.prototype.trimTicks=function(e,t,r){var n=e[0],s=e[e.length-1],a=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$y(this,"trimTicks"),!this.isLinked){if(t&&n!==-1/0)this.min=n;else for(;this.min-a>e[0];)e.shift();if(r)this.max=s;else for(;this.max+a<e[e.length-1];)e.pop();e.length===0&&defined$N(n)&&!this.options.tickPositions&&e.push((s+n)/2)}},o.prototype.alignToOthers=function(){var e=this,t={},r=e.options,n;return this.chart.options.chart.alignTicks!==!1&&r.alignTicks&&r.startOnTick!==!1&&r.endOnTick!==!1&&!e.logarithmic&&this.chart[this.coll].forEach(function(s){var a=s.options,l=s.horiz,h=[l?a.left:a.top,a.width,a.height,a.pane].join(",");s.series.length&&(t[h]?n=!0:t[h]=1)}),n},o.prototype.getTickAmount=function(){var e=this,t=this.options,r=t.tickPixelInterval,n=t.tickAmount;!defined$N(t.tickInterval)&&!n&&this.len<r&&!this.isRadial&&!e.logarithmic&&t.startOnTick&&t.endOnTick&&(n=2),!n&&this.alignToOthers()&&(n=Math.ceil(this.len/r)+1),n<4&&(this.finalTickAmt=n,n=5),this.tickAmount=n},o.prototype.adjustTickAmount=function(){var e=this,t=e.options,r=e.tickInterval,n=e.tickPositions,s=e.tickAmount,a=e.finalTickAmt,l=n&&n.length,h=pick$1o(e.threshold,e.softThreshold?0:null),c,d;if(e.hasData()&&isNumber$H(e.min)&&isNumber$H(e.max)){if(l<s){for(;n.length<s;)n.length%2||e.min===h?n.push(correctFloat$b(n[n.length-1]+r)):n.unshift(correctFloat$b(n[0]-r));e.transA*=(l-1)/(s-1),e.min=t.startOnTick?n[0]:Math.min(e.min,n[0]),e.max=t.endOnTick?n[n.length-1]:Math.max(e.max,n[n.length-1])}else l>s&&(e.tickInterval*=2,e.setTickPositions());if(defined$N(a)){for(d=c=n.length;d--;)(a===3&&d%2===1||a<=2&&d>0&&d<c-1)&&n.splice(d,1);e.finalTickAmt=void 0}}},o.prototype.setScale=function(){var e=this,t=!1,r=!1;e.series.forEach(function(s){t=t||s.isDirtyData||s.isDirty,r=r||s.xAxis&&s.xAxis.isDirty||!1}),e.setAxisSize();var n=e.len!==(e.old&&e.old.len);n||t||r||e.isLinked||e.forceRedraw||e.userMin!==(e.old&&e.old.userMin)||e.userMax!==(e.old&&e.old.userMax)||e.alignToOthers()?(e.stacking&&e.stacking.resetStacks(),e.forceRedraw=!1,e.getSeriesExtremes(),e.setTickInterval(),e.isDirty||(e.isDirty=n||e.min!==(e.old&&e.old.min)||e.max!==(e.old&&e.old.max))):e.stacking&&e.stacking.cleanStacks(),t&&e.panningState&&(e.panningState.isDirty=!0),fireEvent$y(this,"afterSetScale")},o.prototype.setExtremes=function(e,t,r,n,s){var a=this,l=a.chart;r=pick$1o(r,!0),a.series.forEach(function(h){delete h.kdTree}),s=extend$1i(s,{min:e,max:t}),fireEvent$y(a,"setExtremes",s,function(){a.userMin=e,a.userMax=t,a.eventArgs=s,r&&l.redraw(n)})},o.prototype.zoom=function(e,t){var r=this,n=this.dataMin,s=this.dataMax,a=this.options,l=Math.min(n,pick$1o(a.min,n)),h=Math.max(s,pick$1o(a.max,s)),c={newMin:e,newMax:t};return fireEvent$y(this,"zoom",c,function(d){var f=d.newMin,p=d.newMax;(f!==r.min||p!==r.max)&&(r.allowZoomOutside||(defined$N(n)&&(f<l&&(f=l),f>h&&(f=h)),defined$N(s)&&(p<l&&(p=l),p>h&&(p=h))),r.displayBtn=typeof f<"u"||typeof p<"u",r.setExtremes(f,p,!1,void 0,{trigger:"zoom"})),d.zoomed=!0}),c.zoomed},o.prototype.setAxisSize=function(){var e=this.chart,t=this.options,r=t.offsets||[0,0,0,0],n=this.horiz,s=this.width=Math.round(relativeLength$9(pick$1o(t.width,e.plotWidth-r[3]+r[1]),e.plotWidth)),a=this.height=Math.round(relativeLength$9(pick$1o(t.height,e.plotHeight-r[0]+r[2]),e.plotHeight)),l=this.top=Math.round(relativeLength$9(pick$1o(t.top,e.plotTop+r[0]),e.plotHeight,e.plotTop)),h=this.left=Math.round(relativeLength$9(pick$1o(t.left,e.plotLeft+r[3]),e.plotWidth,e.plotLeft));this.bottom=e.chartHeight-a-l,this.right=e.chartWidth-s-h,this.len=Math.max(n?s:a,0),this.pos=n?h:l},o.prototype.getExtremes=function(){var e=this,t=e.logarithmic;return{min:t?correctFloat$b(t.lin2log(e.min)):e.min,max:t?correctFloat$b(t.lin2log(e.max)):e.max,dataMin:e.dataMin,dataMax:e.dataMax,userMin:e.userMin,userMax:e.userMax}},o.prototype.getThreshold=function(e){var t=this,r=t.logarithmic,n=r?r.lin2log(t.min):t.min,s=r?r.lin2log(t.max):t.max;return e===null||e===-1/0?e=n:e===1/0?e=s:n>e?e=n:s<e&&(e=s),t.translate(e,0,1,0,1)},o.prototype.autoLabelAlign=function(e){var t=(pick$1o(e,0)-this.side*90+720)%360,r={align:"center"};return fireEvent$y(this,"autoLabelAlign",r,function(n){t>15&&t<165?n.align="right":t>195&&t<345&&(n.align="left")}),r.align},o.prototype.tickSize=function(e){var t=this.options,r=pick$1o(t[e==="tick"?"tickWidth":"minorTickWidth"],e==="tick"&&this.isXAxis&&!this.categories?1:0),n=t[e==="tick"?"tickLength":"minorTickLength"],s;r&&n&&(t[e+"Position"]==="inside"&&(n=-n),s=[n,r]);var a={tickSize:s};return fireEvent$y(this,"afterTickSize",a),a.tickSize},o.prototype.labelMetrics=function(){var e=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[e]&&this.ticks[e].label)},o.prototype.unsquish=function(){var e=this.options.labels,t=this.horiz,r=this.tickInterval,n=this.len/(((this.categories?1:0)+this.max-this.min)/r),s=e.rotation,a=this.labelMetrics(),l=Math.max(this.max-this.min,0),h=function(g){var v=g/(n||1);return v=v>1?Math.ceil(v):1,v*r>l&&g!==1/0&&n!==1/0&&l&&(v=Math.ceil(l/r)),correctFloat$b(v*r)},c=r,d,f,p=Number.MAX_VALUE,u;return t?(!e.staggerLines&&!e.step&&(isNumber$H(s)?u=[s]:n<e.autoRotationLimit&&(u=e.autoRotation)),u&&u.forEach(function(g){var v;(g===s||g&&g>=-90&&g<=90)&&(f=h(Math.abs(a.h/Math.sin(deg2rad$5*g))),v=f+Math.abs(g/360),v<p&&(p=v,d=g,c=f))})):e.step||(c=h(a.h)),this.autoRotation=u,this.labelRotation=pick$1o(d,isNumber$H(s)?s:0),c},o.prototype.getSlotWidth=function(e){var t=this.chart,r=this.horiz,n=this.options.labels,s=Math.max(this.tickPositions.length-(this.categories?0:1),1),a=t.margin[3];if(e&&isNumber$H(e.slotWidth))return e.slotWidth;if(r&&n.step<2)return n.rotation?0:(this.staggerLines||1)*this.len/s;if(!r){var l=n.style.width;if(l!==void 0)return parseInt(String(l),10);if(a)return a-t.spacing[3]}return t.chartWidth*.33},o.prototype.renderUnsquish=function(){var e=this.chart,t=e.renderer,r=this.tickPositions,n=this.ticks,s=this.options.labels,a=s.style,l=this.horiz,h=this.getSlotWidth(),c=Math.max(1,Math.round(h-2*s.padding)),d={},f=this.labelMetrics(),p=a.textOverflow,u,g,v=0,y,m,x;if(isString$7(s.rotation)||(d.rotation=s.rotation||0),r.forEach(function(b){var $=n[b];$.movedLabel&&$.replaceMovedLabel(),$&&$.label&&$.label.textPxLength>v&&(v=$.label.textPxLength)}),this.maxLabelLength=v,this.autoRotation)v>c&&v>f.h?d.rotation=this.labelRotation:this.labelRotation=0;else if(h&&(u=c,!p))for(g="clip",m=r.length;!l&&m--;)x=r[m],y=n[x].label,y&&(y.styles&&y.styles.textOverflow==="ellipsis"?y.css({textOverflow:"clip"}):y.textPxLength>h&&y.css({width:h+"px"}),y.getBBox().height>this.len/r.length-(f.h-f.f)&&(y.specificTextOverflow="ellipsis"));d.rotation&&(u=v>e.chartHeight*.5?e.chartHeight*.33:v,p||(g="ellipsis")),this.labelAlign=s.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(d.align=this.labelAlign),r.forEach(function(b){var $=n[b],S=$&&$.label,k=a.width,A={};S&&(S.attr(d),$.shortenLabel?$.shortenLabel():u&&!k&&a.whiteSpace!=="nowrap"&&(u<S.textPxLength||S.element.tagName==="SPAN")?(A.width=u+"px",p||(A.textOverflow=S.specificTextOverflow||g),S.css(A)):S.styles&&S.styles.width&&!A.width&&!k&&S.css({width:null}),delete S.specificTextOverflow,$.rotation=d.rotation)},this),this.tickRotCorr=t.rotCorr(f.b,this.labelRotation||0,this.side!==0)},o.prototype.hasData=function(){return this.series.some(function(e){return e.hasData()})||this.options.showEmpty&&defined$N(this.min)&&defined$N(this.max)},o.prototype.addTitle=function(e){var t=this,r=t.chart.renderer,n=t.horiz,s=t.opposite,a=t.options,l=a.title,h=t.chart.styledMode,c;t.axisTitle||(c=l.textAlign,c||(c=(n?{low:"left",middle:"center",high:"right"}:{low:s?"right":"left",middle:"center",high:s?"left":"right"})[l.align]),t.axisTitle=r.text(l.text||"",0,0,l.useHTML).attr({zIndex:7,rotation:l.rotation,align:c}).addClass("highcharts-axis-title"),h||t.axisTitle.css(merge$1g(l.style)),t.axisTitle.add(t.axisGroup),t.axisTitle.isNew=!0),!h&&!l.style.width&&!t.isRadial&&t.axisTitle.css({width:t.len+"px"}),t.axisTitle[e?"show":"hide"](e)},o.prototype.generateTick=function(e){var t=this,r=t.ticks;r[e]?r[e].addLabel():r[e]=new Tick(t,e)},o.prototype.getOffset=function(){var e=this,t=this,r=t.chart,n=r.renderer,s=t.options,a=t.tickPositions,l=t.ticks,h=t.horiz,c=t.side,d=r.inverted&&!t.isZAxis?[1,0,3,2][c]:c,f=t.hasData(),p=s.title,u=s.labels,g=r.axisOffset,v=r.clipOffset,y=[-1,1,1,-1][c],m=s.className,x=t.axisParent,b,$=0,S,k=0,A=0,M,P;if(t.showAxis=b=f||s.showEmpty,t.staggerLines=t.horiz&&u.staggerLines||void 0,!t.axisGroup){var E=function(C,I,L){return n.g(C).attr({zIndex:L}).addClass("highcharts-"+e.coll.toLowerCase()+I+" "+(e.isRadial?"highcharts-radial-axis"+I+" ":"")+(m||"")).add(x)};t.gridGroup=E("grid","-grid",s.gridZIndex),t.axisGroup=E("axis","",s.zIndex),t.labelGroup=E("axis-labels","-labels",u.zIndex)}f||t.isLinked?(a.forEach(function(C){t.generateTick(C)}),t.renderUnsquish(),t.reserveSpaceDefault=c===0||c===2||{1:"left",3:"right"}[c]===t.labelAlign,pick$1o(u.reserveSpace,t.labelAlign==="center"?!0:null,t.reserveSpaceDefault)&&a.forEach(function(C){A=Math.max(l[C].getLabelSize(),A)}),t.staggerLines&&(A*=t.staggerLines),t.labelOffset=A*(t.opposite?-1:1)):objectEach$s(l,function(C,I){C.destroy(),delete l[I]}),p&&p.text&&p.enabled!==!1&&(t.addTitle(b),b&&p.reserveSpace!==!1&&(t.titleOffset=$=t.axisTitle.getBBox()[h?"height":"width"],S=p.offset,k=defined$N(S)?0:pick$1o(p.margin,h?5:10))),t.renderLine(),t.offset=y*pick$1o(s.offset,g[c]?g[c]+(s.margin||0):0),t.tickRotCorr=t.tickRotCorr||{x:0,y:0},c===0?P=-t.labelMetrics().h:c===2?P=t.tickRotCorr.y:P=0,M=Math.abs(A)+k,A&&(M-=P,M+=y*(h?pick$1o(u.y,t.tickRotCorr.y+y*8):u.x)),t.axisTitleMargin=pick$1o(S,M),t.getMaxLabelDimensions&&(t.maxLabelDimensions=t.getMaxLabelDimensions(l,a));var T=this.tickSize("tick");g[c]=Math.max(g[c],(t.axisTitleMargin||0)+$+y*t.offset,M,a&&a.length&&T?T[0]+y*t.offset:0);var O=s.offset?0:Math.floor(t.axisLine.strokeWidth()/2)*2;v[d]=Math.max(v[d],O),fireEvent$y(this,"afterGetOffset")},o.prototype.getLinePath=function(e){var t=this.chart,r=this.opposite,n=this.offset,s=this.horiz,a=this.left+(r?this.width:0)+n,l=t.chartHeight-this.bottom-(r?this.height:0)+n;return r&&(e*=-1),t.renderer.crispLine([["M",s?this.left:a,s?l:this.top],["L",s?t.chartWidth-this.right:a,s?l:t.chartHeight-this.bottom]],e)},o.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},o.prototype.getTitlePosition=function(){var e=this.horiz,t=this.left,r=this.top,n=this.len,s=this.options.title,a=e?t:r,l=this.opposite,h=this.offset,c=s.x,d=s.y,f=this.axisTitle,p=this.chart.renderer.fontMetrics(s.style.fontSize,f),u=Math.max(f.getBBox(null,0).height-p.h-1,0),g={low:a+(e?0:n),middle:a+n/2,high:a+(e?n:0)}[s.align],v=(e?r+this.height:t)+(e?1:-1)*(l?-1:1)*this.axisTitleMargin+[-u,u,p.f,-u][this.side],y={x:e?g+c:v+(l?this.width:0)+h+c,y:e?v+d-(l?this.height:0)+h:g+d};return fireEvent$y(this,"afterGetTitlePosition",{titlePosition:y}),y},o.prototype.renderMinorTick=function(e,t){var r=this,n=r.minorTicks;n[e]||(n[e]=new Tick(r,e,"minor")),t&&n[e].isNew&&n[e].render(null,!0),n[e].render(null,!1,1)},o.prototype.renderTick=function(e,t,r){var n=this,s=n.isLinked,a=n.ticks;(!s||e>=n.min&&e<=n.max||n.grid&&n.grid.isColumn)&&(a[e]||(a[e]=new Tick(n,e)),r&&a[e].isNew&&a[e].render(t,!0,-1),a[e].render(t))},o.prototype.render=function(){var e=this,t=e.chart,r=e.logarithmic,n=t.renderer,s=e.options,a=e.isLinked,l=e.tickPositions,h=e.axisTitle,c=e.ticks,d=e.minorTicks,f=e.alternateBands,p=s.stackLabels,u=s.alternateGridColor,g=e.tickmarkOffset,v=e.axisLine,y=e.showAxis,m=animObject$a(n.globalAnimation),x,b;if(e.labelEdge.length=0,e.overlap=!1,[c,d,f].forEach(function(k){objectEach$s(k,function(A){A.isActive=!1})}),e.hasData()||a){var $=e.chart.hasRendered&&e.old&&isNumber$H(e.old.min);e.minorTickInterval&&!e.categories&&e.getMinorTickPositions().forEach(function(k){e.renderMinorTick(k,$)}),l.length&&(l.forEach(function(k,A){e.renderTick(k,A,$)}),g&&(e.min===0||e.single)&&(c[-1]||(c[-1]=new Tick(e,-1,null,!0)),c[-1].render(-1))),u&&l.forEach(function(k,A){b=typeof l[A+1]<"u"?l[A+1]+g:e.max-g,A%2===0&&k<e.max&&b<=e.max+(t.polar?-g:g)&&(f[k]||(f[k]=new H.PlotLineOrBand(e)),x=k+g,f[k].options={from:r?r.lin2log(x):x,to:r?r.lin2log(b):b,color:u,className:"highcharts-alternate-grid"},f[k].render(),f[k].isActive=!0)}),e._addedPlotLB||(e._addedPlotLB=!0,(s.plotLines||[]).concat(s.plotBands||[]).forEach(function(k){e.addPlotBandOrLine(k)}))}if([c,d,f].forEach(function(k){var A=[],M=m.duration,P=function(){for(var E=A.length;E--;)k[A[E]]&&!k[A[E]].isActive&&(k[A[E]].destroy(),delete k[A[E]])};objectEach$s(k,function(E,T){E.isActive||(E.render(T,!1,0),E.isActive=!1,A.push(T))}),syncTimeout$7(P,k===f||!t.hasRendered||!M?0:M)}),v&&(v[v.isPlaced?"animate":"attr"]({d:this.getLinePath(v.strokeWidth())}),v.isPlaced=!0,v[y?"show":"hide"](y)),h&&y){var S=e.getTitlePosition();isNumber$H(S.y)?(h[h.isNew?"attr":"animate"](S),h.isNew=!1):(h.attr("y",-9999),h.isNew=!0)}p&&p.enabled&&e.stacking&&e.stacking.renderStackTotals(),e.old={len:e.len,max:e.max,min:e.min,transA:e.transA,userMax:e.userMax,userMin:e.userMin},e.isDirty=!1,fireEvent$y(this,"afterRender")},o.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(e){e.render()})),this.series.forEach(function(e){e.isDirty=!0})},o.prototype.getKeepProps=function(){return this.keepProps||o.keepProps},o.prototype.destroy=function(e){var t=this,r=t.plotLinesAndBands,n=this.eventOptions;if(fireEvent$y(this,"destroy",{keepEvents:e}),e||removeEvent$9(t),[t.ticks,t.minorTicks,t.alternateBands].forEach(function(l){destroyObjectProperties$7(l)}),r)for(var s=r.length;s--;)r[s].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(l){t[l]&&(t[l]=t[l].destroy())});for(var a in t.plotLinesAndBandsGroups)t.plotLinesAndBandsGroups[a]=t.plotLinesAndBandsGroups[a].destroy();objectEach$s(t,function(l,h){t.getKeepProps().indexOf(h)===-1&&delete t[h]}),this.eventOptions=n},o.prototype.drawCrosshair=function(e,t){var r=this.crosshair,n=pick$1o(r&&r.snap,!0),s=this.chart,a,l,h,c=this.cross,d;if(fireEvent$y(this,"drawCrosshair",{e,point:t}),e||(e=this.cross&&this.cross.e),!r||(defined$N(t)||!n)===!1)this.hideCrosshair();else{if(n?defined$N(t)&&(l=pick$1o(this.coll!=="colorAxis"?t.crosshairPos:null,this.isXAxis?t.plotX:this.len-t.plotY)):l=e&&(this.horiz?e.chartX-this.pos:this.len-e.chartY+this.pos),defined$N(l)&&(d={value:t&&(this.isXAxis?t.x:pick$1o(t.stackY,t.y)),translatedValue:l},s.polar&&extend$1i(d,{isCrosshair:!0,chartX:e&&e.chartX,chartY:e&&e.chartY,point:t}),a=this.getPlotLinePath(d)||null),!defined$N(a)){this.hideCrosshair();return}h=this.categories&&!this.isRadial,c||(this.cross=c=s.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(h?"category ":"thin ")+(r.className||"")).attr({zIndex:pick$1o(r.zIndex,2)}).add(),s.styledMode||(c.attr({stroke:r.color||(h?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1o(r.width,1)}).css({"pointer-events":"none"}),r.dashStyle&&c.attr({dashstyle:r.dashStyle}))),c.show().attr({d:a}),h&&!r.width&&c.attr({"stroke-width":this.transA}),this.cross.e=e}fireEvent$y(this,"afterDrawCrosshair",{e,point:t})},o.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$y(this,"afterHideCrosshair")},o.prototype.hasVerticalPanning=function(){var e=this.chart.options.chart.panning;return!!(e&&e.enabled&&/y/.test(e.type))},o.prototype.validatePositiveValue=function(e){return isNumber$H(e)&&e>0},o.prototype.update=function(e,t){var r=this.chart;e=merge$1g(this.userOptions,e),this.destroy(!0),this.init(r,e),r.isDirtyBox=!0,pick$1o(t,!0)&&r.redraw()},o.prototype.remove=function(e){for(var t=this.chart,r=this.coll,n=this.series,s=n.length;s--;)n[s]&&n[s].remove(!1);erase$7(t.axes,this),erase$7(t[r],this),t[r].forEach(function(a,l){a.options.index=a.userOptions.index=l}),this.destroy(),t.isDirtyBox=!0,pick$1o(e,!0)&&t.redraw()},o.prototype.setTitle=function(e,t){this.update({title:e},t)},o.prototype.setCategories=function(e,t){this.update({categories:e},t)},o.defaultOptions=AxisDefaults$1.defaultXAxisOptions,o.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],o}(),addEvent$_=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$1=Utilities.timeUnits,DateTimeAxis;(function(o){var e=[];function t(a){if(e.indexOf(a)===-1){e.push(a),a.keepProps.push("dateTime");var l=a.prototype;l.getTimeTicks=r,addEvent$_(a,"init",n)}return a}o.compose=t;function r(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function n(a){var l=this,h=a.userOptions;if(h.type!=="datetime"){l.dateTime=void 0;return}l.dateTime||(l.dateTime=new s(l))}var s=function(){function a(l){this.axis=l}return a.prototype.normalizeTimeTickInterval=function(l,h){var c=h||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],d=c[c.length-1],f=timeUnits$1[d[0]],p=d[1],u;for(u=0;u<c.length;u++)if(d=c[u],f=timeUnits$1[d[0]],p=d[1],c[u+1]){var g=(f*p[p.length-1]+timeUnits$1[c[u+1][0]])/2;if(l<=g)break}f===timeUnits$1.year&&l<5*f&&(p=[1,2,5]);var v=normalizeTickInterval$1(l/f,p,d[0]==="year"?Math.max(getMagnitude$1(l/f),1):1);return{unitRange:f,count:v,unitName:d[0]}},a.prototype.getXDateFormat=function(l,h){var c=this.axis;return c.closestPointRange?c.chart.time.getDateFormat(c.closestPointRange,l,c.options.startOfWeek,h)||h.year:h.day},a}();o.Additions=s})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$Z=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1n=Utilities.pick,LogarithmicAxis;(function(o){var e=[];function t(a){return e.indexOf(a)===-1&&(e.push(a),a.keepProps.push("logarithmic"),addEvent$Z(a,"init",r),addEvent$Z(a,"afterInit",n)),a}o.compose=t;function r(a){var l=this,h=a.userOptions,c=l.logarithmic;h.type!=="logarithmic"?l.logarithmic=void 0:c||(c=l.logarithmic=new s(l))}function n(){var a=this,l=a.logarithmic;l&&(a.lin2val=function(h){return l.lin2log(h)},a.val2lin=function(h){return l.log2lin(h)})}var s=function(){function a(l){this.axis=l}return a.prototype.getLogTickPositions=function(l,h,c,d){var f=this,p=f.axis,u=p.len,g=p.options,v=[];if(d||(f.minorAutoInterval=void 0),l>=.5)l=Math.round(l),v=p.getLinearTickPositions(l,h,c);else if(l>=.08){var y=Math.floor(h),m=void 0,x=void 0,b=void 0,$=void 0,S=void 0,k=void 0,A=void 0;for(l>.3?m=[1,2,4]:l>.15?m=[1,2,4,6,8]:m=[1,2,3,4,5,6,7,8,9],x=y;x<c+1&&!A;x++)for($=m.length,b=0;b<$&&!A;b++)S=f.log2lin(f.lin2log(x)*m[b]),S>h&&(!d||k<=c)&&typeof k<"u"&&v.push(k),k>c&&(A=!0),k=S}else{var M=f.lin2log(h),P=f.lin2log(c),E=d?p.getMinorTickInterval():g.tickInterval,T=E==="auto"?null:E,O=g.tickPixelInterval/(d?5:1),C=d?u/p.tickPositions.length:u;l=pick$1n(T,f.minorAutoInterval,(P-M)*O/(C||1)),l=normalizeTickInterval(l,void 0,getMagnitude(l)),v=p.getLinearTickPositions(l,M,P).map(f.log2lin),d||(f.minorAutoInterval=l/5)}return d||(p.tickInterval=l),v},a.prototype.lin2log=function(l){return Math.pow(10,l)},a.prototype.log2lin=function(l){return Math.log(l)/Math.LN10},a}();o.Additions=s})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$6=Utilities.erase,extend$1h=Utilities.extend,isNumber$G=Utilities.isNumber,PlotLineOrBandAxis;(function(o){var e=[],t;function r(s,a){return t||(t=s),e.indexOf(a)===-1&&(e.push(a),extend$1h(a.prototype,n.prototype)),a}o.compose=r;var n=function(){function s(){}return s.prototype.getPlotBandPath=function(a,l,h){h===void 0&&(h=this.options);var c=this.getPlotLinePath({value:l,force:!0,acrossPanes:h.acrossPanes}),d=[],f=this.horiz,p=!isNumber$G(this.min)||!isNumber$G(this.max)||a<this.min&&l<this.min||a>this.max&&l>this.max,u=this.getPlotLinePath({value:a,force:!0,acrossPanes:h.acrossPanes}),g,v=1,y;if(u&&c)for(p&&(y=u.toString()===c.toString(),v=0),g=0;g<u.length;g+=2){var m=u[g],x=u[g+1],b=c[g],$=c[g+1];(m[0]==="M"||m[0]==="L")&&(x[0]==="M"||x[0]==="L")&&(b[0]==="M"||b[0]==="L")&&($[0]==="M"||$[0]==="L")&&(f&&b[1]===m[1]?(b[1]+=v,$[1]+=v):!f&&b[2]===m[2]&&(b[2]+=v,$[2]+=v),d.push(["M",m[1],m[2]],["L",x[1],x[2]],["L",$[1],$[2]],["L",b[1],b[2]],["Z"])),d.isFlat=y}else u=null;return d},s.prototype.addPlotBand=function(a){return this.addPlotBandOrLine(a,"plotBands")},s.prototype.addPlotLine=function(a){return this.addPlotBandOrLine(a,"plotLines")},s.prototype.addPlotBandOrLine=function(a,l){var h=this,c=this.userOptions,d=new t(this,a);if(this.visible&&(d=d.render()),d){if(this._addedPlotLB||(this._addedPlotLB=!0,(c.plotLines||[]).concat(c.plotBands||[]).forEach(function(p){h.addPlotBandOrLine(p)})),l){var f=c[l]||[];f.push(a),c[l]=f}this.plotLinesAndBands.push(d)}return d},s.prototype.removePlotBandOrLine=function(a){var l=this.plotLinesAndBands,h=this.options,c=this.userOptions;if(l){for(var d=l.length;d--;)l[d].id===a&&l[d].destroy();[h.plotLines||[],c.plotLines||[],h.plotBands||[],c.plotBands||[]].forEach(function(f){for(d=f.length;d--;)(f[d]||{}).id===a&&erase$6(f,f[d])})}},s.prototype.removePlotBand=function(a){this.removePlotBandOrLine(a)},s.prototype.removePlotLine=function(a){this.removePlotBandOrLine(a)},s}()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$M=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$5=Utilities.erase,fireEvent$x=Utilities.fireEvent,merge$1f=Utilities.merge,objectEach$r=Utilities.objectEach,pick$1m=Utilities.pick,PlotLineOrBand=function(){function o(e,t){this.axis=e,t&&(this.options=t,this.id=t.id)}return o.compose=function(e){return PlotLineOrBandAxis$1.compose(o,e)},o.prototype.render=function(){fireEvent$x(this,"render");var e=this,t=e.axis,r=t.horiz,n=t.logarithmic,s=e.options,a=s.color,l=pick$1m(s.zIndex,0),h=s.events,c={},d=t.chart.renderer,f=s.label,p=e.label,u=s.to,g=s.from,v=s.value,y=e.svgElem,m=[],x,b=defined$M(g)&&defined$M(u),$=defined$M(v),S=!y,k={class:"highcharts-plot-"+(b?"band ":"line ")+(s.className||"")},A=b?"bands":"lines";if(n&&(g=n.log2lin(g),u=n.log2lin(u),v=n.log2lin(v)),t.chart.styledMode||($?(k.stroke=a||palette.neutralColor40,k["stroke-width"]=pick$1m(s.width,1),s.dashStyle&&(k.dashstyle=s.dashStyle)):b&&(k.fill=a||palette.highlightColor10,s.borderWidth&&(k.stroke=s.borderColor,k["stroke-width"]=s.borderWidth))),c.zIndex=l,A+="-"+l,x=t.plotLinesAndBandsGroups[A],x||(t.plotLinesAndBandsGroups[A]=x=d.g("plot-"+A).attr(c).add()),S&&(e.svgElem=y=d.path().attr(k).add(x)),$)m=t.getPlotLinePath({value:v,lineWidth:y.strokeWidth(),acrossPanes:s.acrossPanes});else if(b)m=t.getPlotBandPath(g,u,s);else return;return!e.eventsAdded&&h&&(objectEach$r(h,function(M,P){y.on(P,function(E){h[P].apply(e,[E])})}),e.eventsAdded=!0),(S||!y.d)&&m&&m.length?y.attr({d:m}):y&&(m?(y.show(!0),y.animate({d:m})):y.d&&(y.hide(),p&&(e.label=p=p.destroy()))),f&&(defined$M(f.text)||defined$M(f.formatter))&&m&&m.length&&t.width>0&&t.height>0&&!m.isFlat?(f=merge$1f({align:r&&b&&"center",x:r?!b&&4:10,verticalAlign:!r&&b&&"middle",y:r?b?16:10:b?6:-4,rotation:r&&!b&&90},f),this.renderLabel(f,m,b,l)):p&&p.hide(),e},o.prototype.renderLabel=function(e,t,r,n){var s=this,a=s.axis,l=a.chart.renderer,h=s.label;h||(s.label=h=l.text(this.getLabelText(e),0,0,e.useHTML).attr({align:e.textAlign||e.align,rotation:e.rotation,class:"highcharts-plot-"+(r?"band":"line")+"-label "+(e.className||""),zIndex:n}).add(),a.chart.styledMode||h.css(merge$1f({textOverflow:"ellipsis"},e.style)));var c=t.xBounds||[t[0][1],t[1][1],r?t[2][1]:t[0][1]],d=t.yBounds||[t[0][2],t[1][2],r?t[2][2]:t[0][2]],f=arrayMin$7(c),p=arrayMin$7(d);h.align(e,!1,{x:f,y:p,width:arrayMax$8(c)-f,height:arrayMax$8(d)-p}),(!h.alignValue||h.alignValue==="left")&&h.css({width:(h.rotation===90?a.height-(h.alignAttr.y-a.top):a.width-(h.alignAttr.x-a.left))+"px"}),h.show(!0)},o.prototype.getLabelText=function(e){return defined$M(e.formatter)?e.formatter.call(this):e.text},o.prototype.destroy=function(){erase$5(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},o}(),format$c=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$Y=Utilities.addEvent,clamp$f=Utilities.clamp,css$9=Utilities.css,defined$L=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1g=Utilities.extend,fireEvent$w=Utilities.fireEvent,isArray$i=Utilities.isArray,isNumber$F=Utilities.isNumber,isString$6=Utilities.isString,merge$1e=Utilities.merge,pick$1l=Utilities.pick,splat$f=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=function(){function o(e,t){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=e,this.init(e,t)}return o.prototype.applyFilter=function(){var e=this.chart;e.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+e.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},o.prototype.bodyFormatter=function(e){return e.map(function(t){var r=t.series.tooltipOptions;return(r[(t.point.formatPrefix||"point")+"Formatter"]||t.point.tooltipFormatter).call(t.point,r[(t.point.formatPrefix||"point")+"Format"]||"")})},o.prototype.cleanSplit=function(e){this.chart.series.forEach(function(t){var r=t&&t.tt;r&&(!r.isActive||e?t.tt=r.destroy():r.isActive=!1)})},o.prototype.defaultFormatter=function(e){var t=this.points||splat$f(this),r;return r=[e.tooltipFooterHeaderFormatter(t[0])],r=r.concat(e.bodyFormatter(t)),r.push(e.tooltipFooterHeaderFormatter(t[0],!0)),r},o.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},o.prototype.getAnchor=function(e,t){var r=this.chart,n=r.pointer,s=r.inverted,a=r.plotTop,l=r.plotLeft,h,c,d,f=0,p=0;return e=splat$f(e),this.followPointer&&t?(typeof t.chartX>"u"&&(t=n.normalize(t)),h=[t.chartX-l,t.chartY-a]):e[0].tooltipPos?h=e[0].tooltipPos:(e.forEach(function(u){c=u.series.yAxis,d=u.series.xAxis,f+=u.plotX||0,p+=u.plotLow?(u.plotLow+(u.plotHigh||0))/2:u.plotY||0,d&&c&&(s?(f+=a+r.plotHeight-d.len-d.pos,p+=l+r.plotWidth-c.len-c.pos):(f+=d.pos-l,p+=c.pos-a))}),f/=e.length,p/=e.length,h=[s?r.plotWidth-p:f,s?r.plotHeight-f:p],this.shared&&e.length>1&&t&&(s?h[0]=t.chartX-l:h[1]=t.chartY-a)),h.map(Math.round)},o.prototype.getLabel=function(){var e=this,t=this.chart.styledMode,r=this.options,n="tooltip"+(defined$L(r.className)?" "+r.className:""),s=r.style.pointerEvents||(!this.followPointer&&r.stickOnContact?"auto":"none"),a=function(){e.inContact=!0},l=function(v){var y=e.chart.hoverSeries;e.inContact=e.shouldStickOnContact()&&e.chart.pointer.inClass(v.relatedTarget,"highcharts-tooltip"),!e.inContact&&y&&y.onMouseOut&&y.onMouseOut()},h,c=this.chart.renderer;if(!this.label){if(this.outside){var d=this.chart.options.chart.style,f=RendererRegistry$1.getRendererType();this.container=h=H.doc.createElement("div"),h.className="highcharts-tooltip-container",css$9(h,{position:"absolute",top:"1px",pointerEvents:s,zIndex:Math.max(this.options.style.zIndex||0,(d&&d.zIndex||0)+3)}),addEvent$Y(h,"mouseenter",a),addEvent$Y(h,"mouseleave",l),H.doc.body.appendChild(h),this.renderer=c=new f(h,0,0,d,void 0,void 0,c.styledMode)}if(this.split?this.label=c.g(n):(this.label=c.label("",0,0,r.shape,void 0,void 0,r.useHTML,void 0,n).attr({padding:r.padding,r:r.borderRadius}),t||this.label.attr({fill:r.backgroundColor,"stroke-width":r.borderWidth}).css(r.style).css({pointerEvents:s}).shadow(r.shadow)),t&&r.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),e.outside&&!e.split){var p=this.label,u=p.xSetter,g=p.ySetter;p.xSetter=function(v){u.call(p,e.distance),h.style.left=v+"px"},p.ySetter=function(v){g.call(p,e.distance),h.style.top=v+"px"}}this.label.on("mouseenter",a).on("mouseleave",l).attr({zIndex:8}).add()}return this.label},o.prototype.getPosition=function(e,t,r){var n=this.chart,s=this.distance,a={},l=n.inverted&&r.h||0,h=this.outside,c=h?doc$i.documentElement.clientWidth-2*s:n.chartWidth,d=h?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):n.chartHeight,f=n.pointer.getChartPosition(),p=function(A){return A*f.scaleX},u=function(A){return A*f.scaleY},g=function(A){var M=A==="x";return[A,M?c:d,M?e:t].concat(h?[M?p(e):u(t),M?f.left-s+p(r.plotX+n.plotLeft):f.top-s+u(r.plotY+n.plotTop),0,M?c:d]:[M?e:t,M?r.plotX+n.plotLeft:r.plotY+n.plotTop,M?n.plotLeft:n.plotTop,M?n.plotLeft+n.plotWidth:n.plotTop+n.plotHeight])},v=g("y"),y=g("x"),m,x=!this.followPointer&&pick$1l(r.ttBelow,!n.inverted==!!r.negative),b=function(A,M,P,E,T,O,C){var I=h?A==="y"?u(s):p(s):s,L=(P-E)/2,D=E<T-s,N=T+s+E<M,B=T-I-P+L,X=T+I-L;if(x&&N)a[A]=X;else if(!x&&D)a[A]=B;else if(D)a[A]=Math.min(C-E,B-l<0?B:B-l);else if(N)a[A]=Math.max(O,X+l+P>M?X:X+l);else return!1},$=function(A,M,P,E,T){var O;return T<s||T>M-s?O=!1:T<P/2?a[A]=1:T>M-E/2?a[A]=M-E-2:a[A]=T-P/2,O},S=function(A){var M=v;v=y,y=M,m=A},k=function(){b.apply(0,v)!==!1?$.apply(0,y)===!1&&!m&&(S(!0),k()):m?a.x=a.y=0:(S(!0),k())};return(n.inverted||this.len>1)&&S(),k(),a},o.prototype.hide=function(e){var t=this;Utilities.clearTimeout(this.hideTimer),e=pick$1l(e,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){t.getLabel().fadeOut(e&&void 0),t.isHidden=!0},e))},o.prototype.init=function(e,t){this.chart=e,this.options=t,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=t.split&&!e.inverted&&!e.polar,this.shared=t.shared||this.split,this.outside=pick$1l(t.outside,!!(e.scrollablePixelsX||e.scrollablePixelsY))},o.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},o.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},o.prototype.move=function(e,t,r,n){var s=this,a=s.now,l=s.options.animation!==!1&&!s.isHidden&&(Math.abs(e-a.x)>1||Math.abs(t-a.y)>1),h=s.followPointer||s.len>1;extend$1g(a,{x:l?(2*a.x+e)/3:e,y:l?(a.y+t)/2:t,anchorX:h?void 0:l?(2*a.anchorX+r)/3:r,anchorY:h?void 0:l?(a.anchorY+n)/2:n}),s.getLabel().attr(a),s.drawTracker(),l&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){s&&s.move(e,t,r,n)},32))},o.prototype.refresh=function(e,t){var r=this,n=this.chart,s=r.options,a=splat$f(e),l=a[0],h=[],c=s.formatter||r.defaultFormatter,d=r.shared,f=n.styledMode,p={};if(s.enabled){Utilities.clearTimeout(this.hideTimer),r.followPointer=!r.split&&l.series.tooltipOptions.followPointer;var u=r.getAnchor(e,t),g=u[0],v=u[1];d&&!(!isArray$i(e)&&e.series&&e.series.noSharedTooltip)?(n.pointer.applyInactiveState(a),a.forEach(function(S){S.setState("hover"),h.push(S.getLabelConfig())}),p={x:l.category,y:l.y},p.points=h):p=l.getLabelConfig(),this.len=h.length;var y=c.call(p,r),m=l.series;if(this.distance=pick$1l(m.tooltipOptions.distance,16),y===!1)this.hide();else{if(r.split)this.renderSplit(y,a);else{var x=g,b=v;if(t&&n.pointer.isDirectTouch&&(x=t.chartX-n.plotLeft,b=t.chartY-n.plotTop),n.polar||m.options.clip===!1||m.shouldShowTooltip(x,b)){var $=r.getLabel();(!s.style.width||f)&&$.css({width:this.chart.spacingBox.width+"px"}),$.attr({text:y&&y.join?y.join(""):y}),$.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1l(l.colorIndex,m.colorIndex)),f||$.attr({stroke:s.borderColor||l.color||m.color||palette.neutralColor60}),r.updatePosition({plotX:g,plotY:v,negative:l.negative,ttBelow:l.ttBelow,h:u[2]||0})}else{r.hide();return}}r.isHidden&&r.label&&r.label.attr({opacity:1}).show(),r.isHidden=!1}fireEvent$w(this,"refresh")}},o.prototype.renderSplit=function(e,t){var r=this,n=r.chart,s=r.chart,a=s.chartWidth,l=s.chartHeight,h=s.plotHeight,c=s.plotLeft,d=s.plotTop,f=s.pointer,p=s.scrollablePixelsY,u=p===void 0?0:p,g=s.scrollablePixelsX,v=s.scrollingContainer,y=v===void 0?{scrollLeft:0,scrollTop:0}:v,m=y.scrollLeft,x=y.scrollTop,b=s.styledMode,$=r.distance,S=r.options,k=r.options.positioner,A=r.outside&&typeof g!="number"?doc$i.documentElement.getBoundingClientRect():{left:m,right:m+a,top:x,bottom:x+l},M=r.getLabel(),P=this.renderer||n.renderer,E=!!(n.xAxis[0]&&n.xAxis[0].opposite),T=f.getChartPosition(),O=T.left,C=T.top,I=d+x,L=0,D=h-u;function N(Y){var Z=Y.isHeader,et=Y.plotX,Q=et===void 0?0:et,tt=Y.plotY,rt=tt===void 0?0:tt,it=Y.series,nt,st;if(Z)nt=c+Q,st=d+h/2;else{var at=it.xAxis,lt=it.yAxis;nt=at.pos+clamp$f(Q,-$,at.len+$),it.shouldShowTooltip(0,lt.pos-d+rt,{ignoreX:!0})&&(st=lt.pos+rt)}return nt=clamp$f(nt,A.left-$,A.right+$),{anchorX:nt,anchorY:st}}function B(Y,Z,et,Q,tt){tt===void 0&&(tt=!0);var rt,it;return et?(rt=E?0:D,it=clamp$f(Y-Q/2,A.left,A.right-Q-(r.outside?O:0))):(rt=Z-I,it=tt?Y-Q-$:Y+$,it=clamp$f(it,tt?it:A.left,A.right)),{x:it,y:rt}}function X(Y,Z,et){var Q=Y,tt=Z.isHeader,rt=Z.series,it="highcharts-color-"+pick$1l(Z.colorIndex,rt.colorIndex,"none");if(!Q){var nt={padding:S.padding,r:S.borderRadius};b||(nt.fill=S.backgroundColor,nt["stroke-width"]=S.borderWidth),Q=P.label("",0,0,S[tt?"headerShape":"shape"],void 0,void 0,S.useHTML).addClass((tt?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+it).attr(nt).add(M)}return Q.isActive=!0,Q.attr({text:et}),b||Q.css(S.style).shadow(S.shadow).attr({stroke:S.borderColor||Z.color||rt.color||palette.neutralColor80}),Q}isString$6(e)&&(e=[!1,e]);var W=e.slice(0,t.length+1).reduce(function(Y,Z,et){if(Z!==!1&&Z!==""){var Q=t[et-1]||{isHeader:!0,plotX:t[0].plotX,plotY:h,series:{}},tt=Q.isHeader,rt=tt?r:Q.series,it=rt.tt=X(rt.tt,Q,Z.toString()),nt=it.getBBox(),st=nt.width+it.strokeWidth();tt&&(L=nt.height,D+=L,E&&(I-=L));var at=N(Q),lt=at.anchorX,ht=at.anchorY;if(typeof ht=="number"){var ct=nt.height+1,dt=k?k.call(r,st,ct,Q):B(lt,ht,tt,st);Y.push({align:k?0:void 0,anchorX:lt,anchorY:ht,boxWidth:st,point:Q,rank:pick$1l(dt.rank,tt?1:0),size:ct,target:dt.y,tt:it,x:dt.x})}else it.isActive=!1}return Y},[]);!k&&W.some(function(Y){var Z=r.outside,et=(Z?O:0)+Y.anchorX;return et<A.left&&et+Y.boxWidth<A.right?!0:et<O-A.left+Y.boxWidth&&A.right-et>et})&&(W=W.map(function(Y){var Z=B(Y.anchorX,Y.anchorY,Y.point.isHeader,Y.boxWidth,!1),et=Z.x,Q=Z.y;return extend$1g(Y,{target:Q,x:et})})),r.cleanSplit(),distribute$3(W,D);var F={left:O,right:O};W.forEach(function(Y){var Z=Y.x,et=Y.boxWidth,Q=Y.isHeader;Q||(r.outside&&O+Z<F.left&&(F.left=O+Z),!Q&&r.outside&&F.left+et>F.right&&(F.right=O+Z))}),W.forEach(function(Y){var Z=Y.x,et=Y.anchorX,Q=Y.anchorY,tt=Y.pos,rt=Y.point.isHeader,it={visibility:typeof tt>"u"?"hidden":"inherit",x:Z,y:tt+I,anchorX:et,anchorY:Q};if(r.outside&&Z<et){var nt=O-F.left;nt>0&&(rt||(it.x=Z+nt,it.anchorX=et+nt),rt&&(it.x=(F.right-F.left)/2,it.anchorX=et+nt))}Y.tt.attr(it)});var U=r.container,z=r.outside,V=r.renderer;if(z&&U&&V){var j=M.getBBox(),K=j.width,ot=j.height,q=j.x,J=j.y;V.setSize(K+q,ot+J,!1),U.style.left=F.left+"px",U.style.top=C+"px"}},o.prototype.drawTracker=function(){var e=this;if(e.followPointer||!e.options.stickOnContact){e.tracker&&e.tracker.destroy();return}var t=e.chart,r=e.label,n=e.shared?t.hoverPoints:t.hoverPoint;if(!(!r||!n)){var s={x:0,y:0,width:0,height:0},a=this.getAnchor(n),l=r.getBBox();a[0]+=t.plotLeft-r.translateX,a[1]+=t.plotTop-r.translateY,s.x=Math.min(0,a[0]),s.y=Math.min(0,a[1]),s.width=a[0]<0?Math.max(Math.abs(a[0]),l.width-a[0]):Math.max(Math.abs(a[0]),l.width),s.height=a[1]<0?Math.max(Math.abs(a[1]),l.height-Math.abs(a[1])):Math.max(Math.abs(a[1]),l.height),e.tracker?e.tracker.attr(s):(e.tracker=r.renderer.rect(s).addClass("highcharts-tracker").add(r),t.styledMode||e.tracker.attr({fill:"rgba(0,0,0,0)"}))}},o.prototype.styledModeFormat=function(e){return e.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},o.prototype.tooltipFooterHeaderFormatter=function(e,t){var r=e.series,n=r.tooltipOptions,s=r.xAxis,a=s&&s.dateTime,l={isFooter:t,labelConfig:e},h=n.xDateFormat,c=n[t?"footerFormat":"headerFormat"];return fireEvent$w(this,"headerFormatter",l,function(d){a&&!h&&isNumber$F(e.key)&&(h=a.getXDateFormat(e.key,n.dateTimeLabelFormats)),a&&h&&(e.point&&e.point.tooltipDateKeys||["key"]).forEach(function(f){c=c.replace("{point."+f+"}","{point."+f+":"+h+"}")}),r.chart.styledMode&&(c=this.styledModeFormat(c)),d.text=format$c(c,{point:e,series:r},this.chart)}),l.text},o.prototype.update=function(e){this.destroy(),merge$1e(!0,this.chart.options.tooltip.userOptions,e),this.init(this.chart,merge$1e(!0,this.options,e))},o.prototype.updatePosition=function(e){var t=this.chart,r=this.options,n=t.pointer,s=this.getLabel(),a=n.getChartPosition(),l=(r.positioner||this.getPosition).call(this,s.width,s.height,e),h=e.plotX+t.plotLeft,c=e.plotY+t.plotTop,d;this.outside&&(d=r.borderWidth+2*this.distance,this.renderer.setSize(s.width+d,s.height+d,!1),(a.scaleX!==1||a.scaleY!==1)&&(css$9(this.container,{transform:"scale("+a.scaleX+", "+a.scaleY+")"}),h*=a.scaleX,c*=a.scaleY),h+=a.left-l.x,c+=a.top-l.y),this.move(Math.round(l.x),Math.round(l.y||0),h,c)},o}(),animObject$9=animationExports.animObject,defaultOptions$c=DefaultOptions.defaultOptions,format$b=FormatUtilities.format,addEvent$X=Utilities.addEvent,defined$K=Utilities.defined,erase$4=Utilities.erase,extend$1f=Utilities.extend,fireEvent$v=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$h=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$E=Utilities.isNumber,isObject$b=Utilities.isObject,merge$1d=Utilities.merge,objectEach$q=Utilities.objectEach,pick$1k=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$2=function(){function o(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return o.prototype.animateBeforeDestroy=function(){var e=this,t={x:e.startXPos,opacity:0},r=e.getGraphicalProps();r.singular.forEach(function(n){var s=n==="dataLabel";e[n]=e[n].animate(s?{x:e[n].startXPos,y:e[n].startYPos,opacity:0}:t)}),r.plural.forEach(function(n){e[n].forEach(function(s){s.element&&s.animate(extend$1f({x:e.startXPos},s.startYPos?{x:s.startXPos,y:s.startYPos}:{}))})})},o.prototype.applyOptions=function(e,t){var r=this,n=r.series,s=n.options.pointValKey||n.pointValKey;return e=o.prototype.optionsToObject.call(this,e),extend$1f(r,e),r.options=r.options?extend$1f(r.options,e):e,e.group&&delete r.group,e.dataLabels&&delete r.dataLabels,s&&(r.y=o.prototype.getNestedProperty.call(r,s)),r.isNull=pick$1k(r.isValid&&!r.isValid(),r.x===null||!isNumber$E(r.y)),r.formatPrefix=r.isNull?"null":"point",r.selected&&(r.state="select"),"name"in r&&typeof t>"u"&&n.xAxis&&n.xAxis.hasNames&&(r.x=n.xAxis.nameToX(r)),typeof r.x>"u"&&n?typeof t>"u"?r.x=n.autoIncrement():r.x=t:isNumber$E(e.x)&&n.options.relativeXValue&&(r.x=n.autoIncrement(e.x)),r},o.prototype.destroy=function(){var e=this,t=e.series,r=t.chart,n=t.options.dataSorting,s=r.hoverPoints,a=e.series.chart.renderer.globalAnimation,l=animObject$9(a),h;function c(){(e.graphic||e.dataLabel||e.dataLabels)&&(removeEvent$8(e),e.destroyElements());for(h in e)e[h]=null}e.legendItem&&r.legend.destroyItem(e),s&&(e.setState(),erase$4(s,e),s.length||(r.hoverPoints=null)),e===r.hoverPoint&&e.onMouseOut(),!n||!n.enabled?c():(this.animateBeforeDestroy(),syncTimeout$5(c,l.duration)),r.pointCount--},o.prototype.destroyElements=function(e){var t=this,r=t.getGraphicalProps(e);r.singular.forEach(function(n){t[n]=t[n].destroy()}),r.plural.forEach(function(n){t[n].forEach(function(s){s.element&&s.destroy()}),delete t[n]})},o.prototype.firePointEvent=function(e,t,r){var n=this,s=this.series,a=s.options;(a.point.events[e]||n.options&&n.options.events&&n.options.events[e])&&n.importEvents(),e==="click"&&a.allowPointSelect&&(r=function(l){n.select&&n.select(null,l.ctrlKey||l.metaKey||l.shiftKey)}),fireEvent$v(n,e,t,r)},o.prototype.getClassName=function(){var e=this;return"highcharts-point"+(e.selected?" highcharts-point-select":"")+(e.negative?" highcharts-negative":"")+(e.isNull?" highcharts-null-point":"")+(typeof e.colorIndex<"u"?" highcharts-color-"+e.colorIndex:"")+(e.options.className?" "+e.options.className:"")+(e.zone&&e.zone.className?" "+e.zone.className.replace("highcharts-negative",""):"")},o.prototype.getGraphicalProps=function(e){var t=this,r=[],n={singular:[],plural:[]},s,a;for(e=e||{graphic:1,dataLabel:1},e.graphic&&r.push("graphic","upperGraphic","shadowGroup"),e.dataLabel&&r.push("dataLabel","dataLabelUpper","connector"),a=r.length;a--;)s=r[a],t[s]&&n.singular.push(s);return["dataLabel","connector"].forEach(function(l){var h=l+"s";e[l]&&t[h]&&n.plural.push(h)}),n},o.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},o.prototype.getNestedProperty=function(e){if(e)return e.indexOf("custom.")===0?getNestedProperty$1(e,this.options):this[e]},o.prototype.getZone=function(){var e=this.series,t=e.zones,r=e.zoneAxis||"y",n,s=0;for(n=t[s];this[r]>=n.value;)n=t[++s];return this.nonZonedColor||(this.nonZonedColor=this.color),n&&n.color&&!this.options.color?this.color=n.color:this.color=this.nonZonedColor,n},o.prototype.hasNewShapeType=function(){var e=this,t=e.graphic&&(e.graphic.symbolName||e.graphic.element.nodeName);return t!==this.shapeType},o.prototype.init=function(e,t,r){return this.series=e,this.applyOptions(t,r),this.id=defined$K(this.id)?this.id:uniqueKey$5(),this.resolveColor(),e.chart.pointCount++,fireEvent$v(this,"afterInit"),this},o.prototype.optionsToObject=function(e){var t=this.series,r=t.options.keys,n=r||t.pointArrayMap||["y"],s=n.length,a={},l,h=0,c=0;if(isNumber$E(e)||e===null)a[n[0]]=e;else if(isArray$h(e))for(!r&&e.length>s&&(l=typeof e[0],l==="string"?a.name=e[0]:l==="number"&&(a.x=e[0]),h++);c<s;)(!r||typeof e[h]<"u")&&(n[c].indexOf(".")>0?o.prototype.setNestedProperty(a,e[h],n[c]):a[n[c]]=e[h]),h++,c++;else typeof e=="object"&&(a=e,e.dataLabels&&(t._hasPointLabels=!0),e.marker&&(t._hasPointMarkers=!0));return a},o.prototype.resolveColor=function(){var e=this.series,t=e.chart.options.chart,r=e.chart.styledMode,n,s,a=t.colorCount,l;delete this.nonZonedColor,e.options.colorByPoint?(r||(s=e.options.colors||e.chart.options.colors,n=s[e.colorCounter],a=s.length),l=e.colorCounter,e.colorCounter++,e.colorCounter===a&&(e.colorCounter=0)):(r||(n=e.color),l=e.colorIndex),this.colorIndex=pick$1k(this.options.colorIndex,l),this.color=pick$1k(this.options.color,n)},o.prototype.setNestedProperty=function(e,t,r){var n=r.split(".");return n.reduce(function(s,a,l,h){var c=h.length-1===l;return s[a]=c?t:isObject$b(s[a],!0)?s[a]:{},s[a]},e),e},o.prototype.tooltipFormatter=function(e){var t=this.series,r=t.tooltipOptions,n=pick$1k(r.valueDecimals,""),s=r.valuePrefix||"",a=r.valueSuffix||"";return t.chart.styledMode&&(e=t.chart.tooltip.styledModeFormat(e)),(t.pointArrayMap||["y"]).forEach(function(l){l="{point."+l,(s||a)&&(e=e.replace(RegExp(l+"}","g"),s+l+"}"+a)),e=e.replace(RegExp(l+"}","g"),l+":,."+n+"f}")}),format$b(e,{point:this,series:this.series},t.chart)},o.prototype.update=function(e,t,r,n){var s=this,a=s.series,l=s.graphic,h=a.chart,c=a.options,d;t=pick$1k(t,!0);function f(){s.applyOptions(e);var p=l&&s.hasDummyGraphic,u=s.y===null?!p:p;l&&u&&(s.graphic=l.destroy(),delete s.hasDummyGraphic),isObject$b(e,!0)&&(l&&l.element&&e&&e.marker&&typeof e.marker.symbol<"u"&&(s.graphic=l.destroy()),e&&e.dataLabels&&s.dataLabel&&(s.dataLabel=s.dataLabel.destroy()),s.connector&&(s.connector=s.connector.destroy())),d=s.index,a.updateParallelArrays(s,d),c.data[d]=isObject$b(c.data[d],!0)||isObject$b(e,!0)?s.options:pick$1k(e,c.data[d]),a.isDirty=a.isDirtyData=!0,!a.fixedBox&&a.hasCartesianSeries&&(h.isDirtyBox=!0),c.legendType==="point"&&(h.isDirtyLegend=!0),t&&h.redraw(r)}n===!1?f():s.firePointEvent("update",{options:e},f)},o.prototype.remove=function(e,t){this.series.removePoint(this.series.data.indexOf(this),e,t)},o.prototype.select=function(e,t){var r=this,n=r.series,s=n.chart;e=pick$1k(e,!r.selected),this.selectedStaging=e,r.firePointEvent(e?"select":"unselect",{accumulate:t},function(){r.selected=r.options.selected=e,n.options.data[n.data.indexOf(r)]=r.options,r.setState(e&&"select"),t||s.getSelectedPoints().forEach(function(a){var l=a.series;a.selected&&a!==r&&(a.selected=a.options.selected=!1,l.options.data[l.data.indexOf(a)]=a.options,a.setState(s.hoverPoints&&l.options.inactiveOtherPoints?"inactive":""),a.firePointEvent("unselect"))})}),delete this.selectedStaging},o.prototype.onMouseOver=function(e){var t=this,r=t.series,n=r.chart,s=n.pointer;e=e?s.normalize(e):s.getChartCoordinatesFromPoint(t,n.inverted),s.runPointActions(e,t)},o.prototype.onMouseOut=function(){var e=this,t=e.series.chart;e.firePointEvent("mouseOut"),e.series.options.inactiveOtherPoints||(t.hoverPoints||[]).forEach(function(r){r.setState()}),t.hoverPoints=t.hoverPoint=null},o.prototype.importEvents=function(){if(!this.hasImportedEvents){var e=this,t=merge$1d(e.series.options.point,e.options),r=t.events;e.events=r,objectEach$q(r,function(n,s){isFunction$2(n)&&addEvent$X(e,s,n)}),this.hasImportedEvents=!0}},o.prototype.setState=function(e,t){var r=this,n=r.series,s=r.state,a=n.options.states[e||"normal"]||{},l=defaultOptions$c.plotOptions[n.type].marker&&n.options.marker,h=l&&l.enabled===!1,c=l&&l.states&&l.states[e||"normal"]||{},d=c.enabled===!1,f=r.marker||{},p=n.chart,u=l&&n.markerAttribs,g=n.halo,v,y,m,x=n.stateMarkerGraphic,b;if(e=e||"",!(e===r.state&&!t||r.selected&&e!=="select"||a.enabled===!1||e&&(d||h&&c.enabled===!1)||e&&f.states&&f.states[e]&&f.states[e].enabled===!1)){r.state=e,u&&(v=n.markerAttribs(r,e)),r.graphic&&!r.hasDummyGraphic?(s&&r.graphic.removeClass("highcharts-point-"+s),e&&r.graphic.addClass("highcharts-point-"+e),p.styledMode||(y=n.pointAttribs(r,e),m=pick$1k(p.options.chart.animation,a.animation),n.options.inactiveOtherPoints&&isNumber$E(y.opacity)&&((r.dataLabels||[]).forEach(function(A){A&&A.animate({opacity:y.opacity},m)}),r.connector&&r.connector.animate({opacity:y.opacity},m)),r.graphic.animate(y,m)),v&&r.graphic.animate(v,pick$1k(p.options.chart.animation,c.animation,l.animation)),x&&x.hide()):(e&&c&&(b=f.symbol||n.symbol,x&&x.currentSymbol!==b&&(x=x.destroy()),v&&(x?x[t?"animate":"attr"]({x:v.x,y:v.y}):b&&(n.stateMarkerGraphic=x=p.renderer.symbol(b,v.x,v.y,v.width,v.height).add(n.markerGroup),x.currentSymbol=b)),!p.styledMode&&x&&x.attr(n.pointAttribs(r,e))),x&&(x[e&&r.isInside?"show":"hide"](),x.element.point=r,x.addClass(r.getClassName(),!0)));var $=a.halo,S=r.graphic||x,k=S&&S.visibility||"inherit";$&&$.size&&S&&k!=="hidden"&&!r.isCluster?(g||(n.halo=g=p.renderer.path().add(S.parentGroup)),g.show()[t?"animate":"attr"]({d:r.haloPath($.size)}),g.attr({class:"highcharts-halo highcharts-color-"+pick$1k(r.colorIndex,n.colorIndex)+(r.className?" "+r.className:""),visibility:k,zIndex:-1}),g.point=r,p.styledMode||g.attr(extend$1f({fill:r.color||n.color,"fill-opacity":$.opacity},AST.filterUserAttributes($.attributes||{})))):g&&g.point&&g.point.haloPath&&g.animate({d:g.point.haloPath(0)},null,g.hide),fireEvent$v(r,"afterSetState",{state:e})}},o.prototype.haloPath=function(e){var t=this.series,r=t.chart;return r.renderer.symbols.circle(Math.floor(this.plotX)-e,this.plotY-e,e*2,e*2)},o}(),color$e=Color.parse,charts$3=H.charts,noop$j=H.noop,addEvent$W=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$J=Utilities.defined,extend$1e=Utilities.extend,find$i=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$D=Utilities.isNumber,isObject$a=Utilities.isObject,objectEach$p=Utilities.objectEach,offset=Utilities.offset,pick$1j=Utilities.pick,splat$e=Utilities.splat,Pointer=function(){function o(e,t){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=e,this.hasDragged=!1,this.options=t,this.init(e,t)}return o.prototype.applyInactiveState=function(e){var t=[],r;(e||[]).forEach(function(n){r=n.series,t.push(r),r.linkedParent&&t.push(r.linkedParent),r.linkedSeries&&(t=t.concat(r.linkedSeries)),r.navigatorSeries&&t.push(r.navigatorSeries)}),this.chart.series.forEach(function(n){t.indexOf(n)===-1?n.setState("inactive",!0):n.options.inactiveOtherPoints&&n.setAllPointsToState("inactive")})},o.prototype.destroy=function(){var e=this;this.eventsToUnbind.forEach(function(t){return t()}),this.eventsToUnbind=[],H.chartCount||(o.unbindDocumentMouseUp&&(o.unbindDocumentMouseUp=o.unbindDocumentMouseUp()),o.unbindDocumentTouchEnd&&(o.unbindDocumentTouchEnd=o.unbindDocumentTouchEnd())),clearInterval(e.tooltipTimeout),objectEach$p(e,function(t,r){e[r]=void 0})},o.prototype.drag=function(e){var t=this.chart,r=t.options.chart,n=this.zoomHor,s=this.zoomVert,a=t.plotLeft,l=t.plotTop,h=t.plotWidth,c=t.plotHeight,d=this.mouseDownX||0,f=this.mouseDownY||0,p=isObject$a(r.panning)?r.panning&&r.panning.enabled:r.panning,u=r.panKey&&e[r.panKey+"Key"],g=e.chartX,v=e.chartY,y,m,x=this.selectionMarker;x&&x.touch||(g<a?g=a:g>a+h&&(g=a+h),v<l?v=l:v>l+c&&(v=l+c),this.hasDragged=Math.sqrt(Math.pow(d-g,2)+Math.pow(f-v,2)),this.hasDragged>10&&(y=t.isInsidePlot(d-a,f-l,{visiblePlotOnly:!0}),t.hasCartesianSeries&&(this.zoomX||this.zoomY)&&y&&!u&&(x||(this.selectionMarker=x=t.renderer.rect(a,l,n?1:h,s?1:c,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),t.styledMode||x.attr({fill:r.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),x&&n&&(m=g-d,x.attr({width:Math.abs(m),x:(m>0?0:m)+d})),x&&s&&(m=v-f,x.attr({height:Math.abs(m),y:(m>0?0:m)+f})),y&&!x&&p&&t.pan(e,r.panning)))},o.prototype.dragStart=function(e){var t=this.chart;t.mouseIsDown=e.type,t.cancelClick=!1,t.mouseDownX=this.mouseDownX=e.chartX,t.mouseDownY=this.mouseDownY=e.chartY},o.prototype.drop=function(e){var t=this,r=this.chart,n=this.hasPinched;if(this.selectionMarker){var s={originalEvent:e,xAxis:[],yAxis:[]},a=this.selectionMarker,l=a.attr?a.attr("x"):a.x,h=a.attr?a.attr("y"):a.y,c=a.attr?a.attr("width"):a.width,d=a.attr?a.attr("height"):a.height,f;(this.hasDragged||n)&&(r.axes.forEach(function(p){if(p.zoomEnabled&&defined$J(p.min)&&(n||t[{xAxis:"zoomX",yAxis:"zoomY"}[p.coll]])&&isNumber$D(l)&&isNumber$D(h)){var u=p.horiz,g=e.type==="touchend"?p.minPixelPadding:0,v=p.toValue((u?l:h)+g),y=p.toValue((u?l+c:h+d)-g);s[p.coll].push({axis:p,min:Math.min(v,y),max:Math.max(v,y)}),f=!0}}),f&&fireEvent$u(r,"selection",s,function(p){r.zoom(extend$1e(p,n?{animation:!1}:null))})),isNumber$D(r.index)&&(this.selectionMarker=this.selectionMarker.destroy()),n&&this.scaleGroups()}r&&isNumber$D(r.index)&&(css$8(r.container,{cursor:r._cursor}),r.cancelClick=this.hasDragged>10,r.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},o.prototype.findNearestKDPoint=function(e,t,r){var n=this.chart,s=n.hoverPoint,a=n.tooltip;if(s&&a&&a.isStickyOnContact())return s;var l;function h(c,d){var f=c.distX-d.distX,p=c.dist-d.dist,u=(d.series.group&&d.series.group.zIndex)-(c.series.group&&c.series.group.zIndex),g;return f!==0&&t?g=f:p!==0?g=p:u!==0?g=u:g=c.series.index>d.series.index?-1:1,g}return e.forEach(function(c){var d=c.noSharedTooltip&&t,f=!d&&c.options.findNearestPointBy.indexOf("y")<0,p=c.searchPoint(r,f);isObject$a(p,!0)&&p.series&&(!isObject$a(l,!0)||h(l,p)>0)&&(l=p)}),l},o.prototype.getChartCoordinatesFromPoint=function(e,t){var r=e.series,n=r.xAxis,s=r.yAxis,a=e.shapeArgs;if(n&&s){var l=pick$1j(e.clientX,e.plotX),h=e.plotY||0;return e.isNode&&a&&isNumber$D(a.x)&&isNumber$D(a.y)&&(l=a.x,h=a.y),t?{chartX:s.len+s.pos-h,chartY:n.len+n.pos-l}:{chartX:l+n.pos,chartY:h+s.pos}}if(a&&a.x&&a.y)return{chartX:a.x,chartY:a.y}},o.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var e=this.chart.container,t=offset(e);this.chartPosition={left:t.left,top:t.top,scaleX:1,scaleY:1};var r=e.offsetWidth,n=e.offsetHeight;return r>2&&n>2&&(this.chartPosition.scaleX=t.width/r,this.chartPosition.scaleY=t.height/n),this.chartPosition},o.prototype.getCoordinates=function(e){var t={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(r){t[r.isXAxis?"xAxis":"yAxis"].push({axis:r,value:r.toValue(e[r.horiz?"chartX":"chartY"])})}),t},o.prototype.getHoverData=function(e,t,r,n,s,a){var l=[],h=!!(n&&e),c=function(v){return v.visible&&!(!s&&v.directTouch)&&pick$1j(v.options.enableMouseTracking,!0)},d=t,f,p={chartX:a?a.chartX:void 0,chartY:a?a.chartY:void 0,shared:s};fireEvent$u(this,"beforeGetHoverData",p);var u=d&&!d.stickyTracking;f=u?[d]:r.filter(function(v){return p.filter?p.filter(v):c(v)&&v.stickyTracking});var g=h||!a?e:this.findNearestKDPoint(f,s,a);return d=g&&g.series,g&&(s&&!d.noSharedTooltip?(f=r.filter(function(v){return p.filter?p.filter(v):c(v)&&!v.noSharedTooltip}),f.forEach(function(v){var y=find$i(v.points,function(m){return m.x===g.x&&!m.isNull});isObject$a(y)&&(v.chart.isBoosting&&(y=v.getPoint(y)),l.push(y))})):l.push(g)),p={hoverPoint:g},fireEvent$u(this,"afterGetHoverData",p),{hoverPoint:p.hoverPoint,hoverSeries:d,hoverPoints:l}},o.prototype.getPointFromEvent=function(e){for(var t=e.target,r;t&&!r;)r=t.point,t=t.parentNode;return r},o.prototype.onTrackerMouseOut=function(e){var t=this.chart,r=e.relatedTarget||e.toElement,n=t.hoverSeries;this.isDirectTouch=!1,n&&r&&!n.stickyTracking&&!this.inClass(r,"highcharts-tooltip")&&(!this.inClass(r,"highcharts-series-"+n.index)||!this.inClass(r,"highcharts-tracker"))&&n.onMouseOut()},o.prototype.inClass=function(e,t){for(var r;e;){if(r=attr$2(e,"class"),r){if(r.indexOf(t)!==-1)return!0;if(r.indexOf("highcharts-container")!==-1)return!1}e=e.parentNode}},o.prototype.init=function(e,t){this.options=t,this.chart=e,this.runChartClick=!!(t.chart.events&&t.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(e.tooltip=new Tooltip(e,t.tooltip),this.followTouchMove=pick$1j(t.tooltip.followTouchMove,!0)),this.setDOMEvents()},o.prototype.normalize=function(e,t){var r=e.touches,n=r?r.length?r.item(0):pick$1j(r.changedTouches,e.changedTouches)[0]:e;t||(t=this.getChartPosition());var s=n.pageX-t.left,a=n.pageY-t.top;return s/=t.scaleX,a/=t.scaleY,extend$1e(e,{chartX:Math.round(s),chartY:Math.round(a)})},o.prototype.onContainerClick=function(e){var t=this.chart,r=t.hoverPoint,n=this.normalize(e),s=t.plotLeft,a=t.plotTop;t.cancelClick||(r&&this.inClass(n.target,"highcharts-tracker")?(fireEvent$u(r.series,"click",extend$1e(n,{point:r})),t.hoverPoint&&r.firePointEvent("click",n)):(extend$1e(n,this.getCoordinates(n)),t.isInsidePlot(n.chartX-s,n.chartY-a,{visiblePlotOnly:!0})&&fireEvent$u(t,"click",n)))},o.prototype.onContainerMouseDown=function(e){var t=((e.buttons||e.button)&1)===1;e=this.normalize(e),H.isFirefox&&e.button!==0&&this.onContainerMouseMove(e),(typeof e.button>"u"||t)&&(this.zoomOption(e),t&&e.preventDefault&&e.preventDefault(),this.dragStart(e))},o.prototype.onContainerMouseLeave=function(e){var t=charts$3[pick$1j(o.hoverChartIndex,-1)],r=this.chart.tooltip;r&&r.shouldStickOnContact()&&this.inClass(e.relatedTarget,"highcharts-tooltip-container")||(e=this.normalize(e),t&&(e.relatedTarget||e.toElement)&&(t.pointer.reset(),t.pointer.chartPosition=void 0),r&&!r.isHidden&&this.reset())},o.prototype.onContainerMouseEnter=function(e){delete this.chartPosition},o.prototype.onContainerMouseMove=function(e){var t=this.chart,r=this.normalize(e);this.setHoverChartIndex(),r.preventDefault||(r.returnValue=!1),(t.mouseIsDown==="mousedown"||this.touchSelect(r))&&this.drag(r),!t.openMenu&&(this.inClass(r.target,"highcharts-tracker")||t.isInsidePlot(r.chartX-t.plotLeft,r.chartY-t.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(r.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(r))},o.prototype.onDocumentTouchEnd=function(e){var t=charts$3[pick$1j(o.hoverChartIndex,-1)];t&&t.pointer.drop(e)},o.prototype.onContainerTouchMove=function(e){this.touchSelect(e)?this.onContainerMouseMove(e):this.touch(e)},o.prototype.onContainerTouchStart=function(e){this.touchSelect(e)?this.onContainerMouseDown(e):(this.zoomOption(e),this.touch(e,!0))},o.prototype.onDocumentMouseMove=function(e){var t=this.chart,r=this.chartPosition,n=this.normalize(e,r),s=t.tooltip;r&&(!s||!s.isStickyOnContact())&&!t.isInsidePlot(n.chartX-t.plotLeft,n.chartY-t.plotTop,{visiblePlotOnly:!0})&&!this.inClass(n.target,"highcharts-tracker")&&this.reset()},o.prototype.onDocumentMouseUp=function(e){var t=charts$3[pick$1j(o.hoverChartIndex,-1)];t&&t.pointer.drop(e)},o.prototype.pinch=function(e){var t=this,r=t.chart,n=t.pinchDown,s=e.touches||[],a=s.length,l=t.lastValidTouch,h=t.hasZoom,c={},d=a===1&&(t.inClass(e.target,"highcharts-tracker")&&r.runTrackerClick||t.runChartClick),f={},p=t.selectionMarker;a>1?t.initiated=!0:a===1&&this.followTouchMove&&(t.initiated=!1),h&&t.initiated&&!d&&e.cancelable!==!1&&e.preventDefault(),[].map.call(s,function(u){return t.normalize(u)}),e.type==="touchstart"?([].forEach.call(s,function(u,g){n[g]={chartX:u.chartX,chartY:u.chartY}}),l.x=[n[0].chartX,n[1]&&n[1].chartX],l.y=[n[0].chartY,n[1]&&n[1].chartY],r.axes.forEach(function(u){if(u.zoomEnabled){var g=r.bounds[u.horiz?"h":"v"],v=u.minPixelPadding,y=u.toPixels(Math.min(pick$1j(u.options.min,u.dataMin),u.dataMin)),m=u.toPixels(Math.max(pick$1j(u.options.max,u.dataMax),u.dataMax)),x=Math.min(y,m),b=Math.max(y,m);g.min=Math.min(u.pos,x-v),g.max=Math.max(u.pos+u.len,b+v)}}),t.res=!0):t.followTouchMove&&a===1?this.runPointActions(t.normalize(e)):n.length&&(p||(t.selectionMarker=p=extend$1e({destroy:noop$j,touch:!0},r.plotBox)),t.pinchTranslate(n,s,c,p,f,l),t.hasPinched=h,t.scaleGroups(c,f),t.res&&(t.res=!1,this.reset(!1,0)))},o.prototype.pinchTranslate=function(e,t,r,n,s,a){this.zoomHor&&this.pinchTranslateDirection(!0,e,t,r,n,s,a),this.zoomVert&&this.pinchTranslateDirection(!1,e,t,r,n,s,a)},o.prototype.pinchTranslateDirection=function(e,t,r,n,s,a,l,h){var c=this.chart,d=e?"x":"y",f=e?"X":"Y",p="chart"+f,u=e?"width":"height",g=c["plot"+(e?"Left":"Top")],v=c.inverted,y=c.bounds[e?"h":"v"],m=t.length===1,x=t[0][p],b=!m&&t[1][p],$=function(){typeof E=="number"&&Math.abs(x-b)>20&&(M=h||Math.abs(P-E)/Math.abs(x-b)),A=(g-P)/M+x,S=c["plot"+(e?"Width":"Height")]/M},S,k,A,M=h||1,P=r[0][p],E=!m&&r[1][p],T;$(),k=A,k<y.min?(k=y.min,T=!0):k+S>y.max&&(k=y.max-S,T=!0),T?(P-=.8*(P-l[d][0]),typeof E=="number"&&(E-=.8*(E-l[d][1])),$()):l[d]=[P,E],v||(a[d]=A-g,a[u]=S);var O=v?e?"scaleY":"scaleX":"scale"+f,C=v?1/M:M;s[u]=S,s[d]=k,n[O]=M,n["translate"+f]=C*g+(P-C*x)},o.prototype.reset=function(e,t){var r=this,n=r.chart,s=n.hoverSeries,a=n.hoverPoint,l=n.hoverPoints,h=n.tooltip,c=h&&h.shared?l:a;e&&c&&splat$e(c).forEach(function(d){d.series.isCartesian&&typeof d.plotX>"u"&&(e=!1)}),e?h&&c&&splat$e(c).length&&(h.refresh(c),h.shared&&l?l.forEach(function(d){d.setState(d.state,!0),d.series.isCartesian&&(d.series.xAxis.crosshair&&d.series.xAxis.drawCrosshair(null,d),d.series.yAxis.crosshair&&d.series.yAxis.drawCrosshair(null,d))}):a&&(a.setState(a.state,!0),n.axes.forEach(function(d){d.crosshair&&a.series[d.coll]===d&&d.drawCrosshair(null,a)}))):(a&&a.onMouseOut(),l&&l.forEach(function(d){d.setState()}),s&&s.onMouseOut(),h&&h.hide(t),r.unDocMouseMove&&(r.unDocMouseMove=r.unDocMouseMove()),n.axes.forEach(function(d){d.hideCrosshair()}),r.hoverX=n.hoverPoints=n.hoverPoint=null)},o.prototype.runPointActions=function(e,t){var r=this,n=r.chart,s=n.series,a=n.tooltip&&n.tooltip.options.enabled?n.tooltip:void 0,l=a?a.shared:!1,h=t||n.hoverPoint,c=h&&h.series||n.hoverSeries,d=(!e||e.type!=="touchmove")&&(!!t||c&&c.directTouch&&r.isDirectTouch),f=this.getHoverData(h,c,s,d,l,e);h=f.hoverPoint,c=f.hoverSeries;var p=f.hoverPoints,u=c&&c.tooltipOptions.followPointer&&!c.tooltipOptions.split,g=l&&c&&!c.noSharedTooltip;if(h&&(h!==n.hoverPoint||a&&a.isHidden)){if((n.hoverPoints||[]).forEach(function(y){p.indexOf(y)===-1&&y.setState()}),n.hoverSeries!==c&&c.onMouseOver(),r.applyInactiveState(p),(p||[]).forEach(function(y){y.setState("hover")}),n.hoverPoint&&n.hoverPoint.firePointEvent("mouseOut"),!h.series)return;n.hoverPoints=p,n.hoverPoint=h,h.firePointEvent("mouseOver"),a&&a.refresh(g?p:h,e)}else if(u&&a&&!a.isHidden){var v=a.getAnchor([{}],e);n.isInsidePlot(v[0],v[1],{visiblePlotOnly:!0})&&a.updatePosition({plotX:v[0],plotY:v[1]})}r.unDocMouseMove||(r.unDocMouseMove=addEvent$W(n.container.ownerDocument,"mousemove",function(y){var m=charts$3[o.hoverChartIndex];m&&m.pointer.onDocumentMouseMove(y)}),r.eventsToUnbind.push(r.unDocMouseMove)),n.axes.forEach(function(m){var x=pick$1j((m.crosshair||{}).snap,!0),b;x&&(b=n.hoverPoint,(!b||b.series[m.coll]!==m)&&(b=find$i(p,function($){return $.series[m.coll]===m}))),b||!x?m.drawCrosshair(e,b):m.hideCrosshair()})},o.prototype.scaleGroups=function(e,t){var r=this.chart;r.series.forEach(function(n){var s=e||n.getPlotBox();n.xAxis&&n.xAxis.zoomEnabled&&n.group&&(n.group.attr(s),n.markerGroup&&(n.markerGroup.attr(s),n.markerGroup.clip(t?r.clipRect:null)),n.dataLabelsGroup&&n.dataLabelsGroup.attr(s))}),r.clipRect.attr(t||r.clipBox)},o.prototype.setDOMEvents=function(){var e=this,t=this.chart.container,r=t.ownerDocument;t.onmousedown=this.onContainerMouseDown.bind(this),t.onmousemove=this.onContainerMouseMove.bind(this),t.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$W(t,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$W(t,"mouseleave",this.onContainerMouseLeave.bind(this))),o.unbindDocumentMouseUp||(o.unbindDocumentMouseUp=addEvent$W(r,"mouseup",this.onDocumentMouseUp.bind(this)));for(var n=this.chart.renderTo.parentElement;n&&n.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$W(n,"scroll",function(){delete e.chartPosition})),n=n.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$W(t,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$W(t,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),o.unbindDocumentTouchEnd||(o.unbindDocumentTouchEnd=addEvent$W(r,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},o.prototype.setHoverChartIndex=function(){var e=this.chart,t=H.charts[pick$1j(o.hoverChartIndex,-1)];t&&t!==e&&t.pointer.onContainerMouseLeave({relatedTarget:!0}),(!t||!t.mouseIsDown)&&(o.hoverChartIndex=e.index)},o.prototype.touch=function(e,t){var r=this.chart,n,s,a;this.setHoverChartIndex(),e.touches.length===1?(e=this.normalize(e),a=r.isInsidePlot(e.chartX-r.plotLeft,e.chartY-r.plotTop,{visiblePlotOnly:!0}),a&&!r.openMenu?(t&&this.runPointActions(e),e.type==="touchmove"&&(s=this.pinchDown,n=s[0]?Math.sqrt(Math.pow(s[0].chartX-e.chartX,2)+Math.pow(s[0].chartY-e.chartY,2))>=4:!1),pick$1j(n,!0)&&this.pinch(e)):t&&this.reset()):e.touches.length===2&&this.pinch(e)},o.prototype.touchSelect=function(e){return!!(this.chart.options.chart.zoomBySingleTouch&&e.touches&&e.touches.length===1)},o.prototype.zoomOption=function(e){var t=this.chart,r=t.options.chart,n=t.inverted,s=r.zoomType||"",a,l;/touch/.test(e.type)&&(s=pick$1j(r.pinchType,s)),this.zoomX=a=/x/.test(s),this.zoomY=l=/y/.test(s),this.zoomHor=a&&!n||l&&n,this.zoomVert=l&&!n||a&&n,this.hasZoom=a||l},o}(),__extends$V=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),charts$2=H.charts,doc$h=H.doc,noop$i=H.noop,win$a=H.win,addEvent$V=Utilities.addEvent,css$7=Utilities.css,objectEach$o=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var o=[];return o.item=function(e){return this[e]},objectEach$o(touches,function(e){o.push({pageX:e.pageX,pageY:e.pageY,target:e.target})}),o}function translateMSPointer(o,e,t,r){var n=charts$2[Pointer.hoverChartIndex||NaN];if((o.pointerType==="touch"||o.pointerType===o.MSPOINTER_TYPE_TOUCH)&&n){var s=n.pointer;r(o),s[e]({type:t,target:o.currentTarget,preventDefault:noop$i,touches:getWebkitTouches()})}}var MSPointer=function(o){__extends$V(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},e.prototype.batchMSEvents=function(t){t(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),t(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),t(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},e.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),o.prototype.destroy.call(this)},e.prototype.init=function(t,r){o.prototype.init.call(this,t,r),this.hasZoom&&css$7(t.container,{"-ms-touch-action":"none","touch-action":"none"})},e.prototype.onContainerPointerDown=function(t){translateMSPointer(t,"onContainerTouchStart","touchstart",function(r){touches[r.pointerId]={pageX:r.pageX,pageY:r.pageY,target:r.currentTarget}})},e.prototype.onContainerPointerMove=function(t){translateMSPointer(t,"onContainerTouchMove","touchmove",function(r){touches[r.pointerId]={pageX:r.pageX,pageY:r.pageY},touches[r.pointerId].target||(touches[r.pointerId].target=r.currentTarget)})},e.prototype.onDocumentPointerUp=function(t){translateMSPointer(t,"onDocumentTouchEnd","touchend",function(r){delete touches[r.pointerId]})},e.prototype.setDOMEvents=function(){o.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$V)},e}(Pointer),animObject$8=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$a=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$U=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$I=Utilities.defined,discardElement$4=Utilities.discardElement,find$h=Utilities.find,fireEvent$t=Utilities.fireEvent,isNumber$C=Utilities.isNumber,merge$1c=Utilities.merge,pick$1i=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$c=Utilities.wrap,Legend=function(){function o(e,t){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=e,this.init(e,t)}return o.prototype.init=function(e,t){this.chart=e,this.setOptions(t),t.enabled&&(this.render(),addEvent$U(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$U(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},o.prototype.setOptions=function(e){var t=pick$1i(e.padding,8);this.options=e,this.chart.styledMode||(this.itemStyle=e.itemStyle,this.itemHiddenStyle=merge$1c(this.itemStyle,e.itemHiddenStyle)),this.itemMarginTop=e.itemMarginTop||0,this.itemMarginBottom=e.itemMarginBottom||0,this.padding=t,this.initialItemY=t-5,this.symbolWidth=pick$1i(e.symbolWidth,16),this.pages=[],this.proximate=e.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},o.prototype.update=function(e,t){var r=this.chart;this.setOptions(merge$1c(!0,this.options,e)),this.destroy(),r.isDirtyLegend=r.isDirtyBox=!0,pick$1i(t,!0)&&r.redraw(),fireEvent$t(this,"afterUpdate")},o.prototype.colorizeItem=function(e,t){if(e.legendGroup[t?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var r=this,n=r.options,s=e.legendItem,a=e.legendLine,l=e.legendSymbol,h=r.itemHiddenStyle.color,c=t?n.itemStyle.color:h,d=t&&e.color||h,f=e.options&&e.options.marker,p={fill:d};s&&s.css({fill:c,color:c}),a&&a.attr({stroke:d}),l&&(f&&l.isMarker&&(p=e.pointAttribs(),t||(p.stroke=p.fill=h)),l.attr(p))}fireEvent$t(this,"afterColorizeItem",{item:e,visible:t})},o.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},o.prototype.positionItem=function(e){var t=this,r=this,n=r.options,s=n.symbolPadding,a=!n.rtl,l=e._legendItemPos,h=l[0],c=l[1],d=e.checkbox,f=e.legendGroup;if(f&&f.element){var p={translateX:a?h:r.legendWidth-h-2*s-4,translateY:c},u=function(){fireEvent$t(t,"afterPositionItem",{item:e})};defined$I(f.translateY)?f.animate(p,void 0,u):(f.attr(p),u())}d&&(d.x=h,d.y=c)},o.prototype.destroyItem=function(e){var t=e.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(r){e[r]&&(e[r]=e[r].destroy())}),t&&discardElement$4(e.checkbox)},o.prototype.destroy=function(){function e(t){this[t]&&(this[t]=this[t].destroy())}this.getAllItems().forEach(function(t){["legendItem","legendGroup"].forEach(e,t)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(e,this),this.display=null},o.prototype.positionCheckboxes=function(){var e=this.group&&this.group.alignAttr,t=this.clipHeight||this.legendHeight,r=this.titleHeight,n;e&&(n=e.translateY,this.allItems.forEach(function(s){var a=s.checkbox,l;a&&(l=n+r+a.y+(this.scrollOffset||0)+3,css$6(a,{left:e.translateX+s.checkboxOffset+a.x-20+"px",top:l+"px",display:this.proximate||l>n-6&&l<n+t-6?"":"none"}))},this))},o.prototype.renderTitle=function(){var e=this.options,t=this.padding,r=e.title,n,s=0;r.text&&(this.title||(this.title=this.chart.renderer.label(r.text,t-3,t-4,null,null,null,e.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(r.style),this.title.add(this.group)),r.width||this.title.css({width:this.maxLegendWidth+"px"}),n=this.title.getBBox(),s=n.height,this.offsetWidth=n.width,this.contentGroup.attr({translateY:s})),this.titleHeight=s},o.prototype.setText=function(e){var t=this.options;e.legendItem.attr({text:t.labelFormat?format$a(t.labelFormat,e,this.chart):t.labelFormatter.call(e)})},o.prototype.renderItem=function(e){var t=this,r=t.chart,n=r.renderer,s=t.options,a=s.layout==="horizontal",l=t.symbolWidth,h=s.symbolPadding||0,c=t.itemStyle,d=t.itemHiddenStyle,f=a?pick$1i(s.itemDistance,20):0,p=!s.rtl,u=!e.series,g=!u&&e.series.drawLegendSymbol?e.series:e,v=g.options,y=t.createCheckboxForItem&&v&&v.showCheckbox,m=s.useHTML,x=e.options.className,b=e.legendItem,$=l+h+f+(y?20:0);b||(e.legendGroup=n.g("legend-item").addClass("highcharts-"+g.type+"-series highcharts-color-"+e.colorIndex+(x?" "+x:"")+(u?" highcharts-series-"+e.index:"")).attr({zIndex:1}).add(t.scrollGroup),e.legendItem=b=n.text("",p?l+h:-h,t.baseline||0,m),r.styledMode||b.css(merge$1c(e.visible?c:d)),b.attr({align:p?"left":"right",zIndex:2}).add(e.legendGroup),t.baseline||(t.fontMetrics=n.fontMetrics(r.styledMode?12:c.fontSize,b),t.baseline=t.fontMetrics.f+3+t.itemMarginTop,b.attr("y",t.baseline),t.symbolHeight=s.symbolHeight||t.fontMetrics.f,s.squareSymbol&&(t.symbolWidth=pick$1i(s.symbolWidth,Math.max(t.symbolHeight,16)),$=t.symbolWidth+h+f+(y?20:0),p&&b.attr("x",t.symbolWidth+h))),g.drawLegendSymbol(t,e),t.setItemEvents&&t.setItemEvents(e,b,m)),y&&!e.checkbox&&t.createCheckboxForItem&&t.createCheckboxForItem(e),t.colorizeItem(e,e.visible),(r.styledMode||!c.width)&&b.css({width:(s.itemWidth||t.widthOption||r.spacingBox.width)-$+"px"}),t.setText(e);var S=b.getBBox();e.itemWidth=e.checkboxOffset=s.itemWidth||e.legendItemWidth||S.width+$,t.maxItemWidth=Math.max(t.maxItemWidth,e.itemWidth),t.totalItemWidth+=e.itemWidth,t.itemHeight=e.itemHeight=Math.round(e.legendItemHeight||S.height||t.symbolHeight)},o.prototype.layoutItem=function(e){var t=this.options,r=this.padding,n=t.layout==="horizontal",s=e.itemHeight,a=this.itemMarginBottom,l=this.itemMarginTop,h=n?pick$1i(t.itemDistance,20):0,c=this.maxLegendWidth,d=t.alignColumns&&this.totalItemWidth>c?this.maxItemWidth:e.itemWidth;n&&this.itemX-r+d>c&&(this.itemX=r,this.lastLineHeight&&(this.itemY+=l+this.lastLineHeight+a),this.lastLineHeight=0),this.lastItemY=l+this.itemY+a,this.lastLineHeight=Math.max(s,this.lastLineHeight),e._legendItemPos=[this.itemX,this.itemY],n?this.itemX+=d:(this.itemY+=l+s+a,this.lastLineHeight=s),this.offsetWidth=this.widthOption||Math.max((n?this.itemX-r-(e.checkbox?0:h):d)+r,this.offsetWidth)},o.prototype.getAllItems=function(){var e=[];return this.chart.series.forEach(function(t){var r=t&&t.options;t&&pick$1i(r.showInLegend,defined$I(r.linkedTo)?!1:void 0,!0)&&(e=e.concat(t.legendItems||(r.legendType==="point"?t.data:t)))}),fireEvent$t(this,"afterGetAllItems",{allItems:e}),e},o.prototype.getAlignment=function(){var e=this.options;return this.proximate?e.align.charAt(0)+"tv":e.floating?"":e.align.charAt(0)+e.verticalAlign.charAt(0)+e.layout.charAt(0)},o.prototype.adjustMargins=function(e,t){var r=this.chart,n=this.options,s=this.getAlignment();s&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(a,l){a.test(s)&&!defined$I(e[l])&&(r[marginNames$1[l]]=Math.max(r[marginNames$1[l]],r.legend[(l+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][l]*n[l%2?"x":"y"]+pick$1i(n.margin,12)+t[l]+(r.titleOffset[l]||0)))})},o.prototype.proximatePositions=function(){var e=this.chart,t=[],r=this.options.align==="left";this.allItems.forEach(function(n){var s,a,l=r,h,c;n.yAxis&&(n.xAxis.options.reversed&&(l=!l),n.points&&(s=find$h(l?n.points:n.points.slice(0).reverse(),function(d){return isNumber$C(d.plotY)})),a=this.itemMarginTop+n.legendItem.getBBox().height+this.itemMarginBottom,c=n.yAxis.top-e.plotTop,n.visible?(h=s?s.plotY:n.yAxis.height,h+=c-.3*a):h=c+n.yAxis.height,t.push({target:h,size:a,item:n}))},this),distribute$2(t,e.plotHeight).forEach(function(n){n.item._legendItemPos&&(n.item._legendItemPos[1]=e.plotTop-e.spacing[0]+n.pos)})},o.prototype.render=function(){var e=this,t=e.chart,r=t.renderer,n=e.options,s=e.padding,a=e.getAllItems(),l,h,c,d=e.group,f,p=e.box;e.itemX=s,e.itemY=e.initialItemY,e.offsetWidth=0,e.lastItemY=0,e.widthOption=relativeLength$8(n.width,t.spacingBox.width-s),f=t.spacingBox.width-2*s-n.x,["rm","lm"].indexOf(e.getAlignment().substring(0,2))>-1&&(f/=2),e.maxLegendWidth=e.widthOption||f,d||(e.group=d=r.g("legend").addClass(n.className||"").attr({zIndex:7}).add(),e.contentGroup=r.g().attr({zIndex:1}).add(d),e.scrollGroup=r.g().add(e.contentGroup)),e.renderTitle(),stableSort$5(a,function(u,g){return(u.options&&u.options.legendIndex||0)-(g.options&&g.options.legendIndex||0)}),n.reversed&&a.reverse(),e.allItems=a,e.display=l=!!a.length,e.lastLineHeight=0,e.maxItemWidth=0,e.totalItemWidth=0,e.itemHeight=0,a.forEach(e.renderItem,e),a.forEach(e.layoutItem,e),h=(e.widthOption||e.offsetWidth)+s,c=e.lastItemY+e.lastLineHeight+e.titleHeight,c=e.handleOverflow(c),c+=s,p||(e.box=p=r.rect().addClass("highcharts-legend-box").attr({r:n.borderRadius}).add(d),p.isNew=!0),t.styledMode||p.attr({stroke:n.borderColor,"stroke-width":n.borderWidth||0,fill:n.backgroundColor||"none"}).shadow(n.shadow),h>0&&c>0&&(p[p.isNew?"attr":"animate"](p.crisp.call({},{x:0,y:0,width:h,height:c},p.strokeWidth())),p.isNew=!1),p[l?"show":"hide"](),t.styledMode&&d.getStyle("display")==="none"&&(h=c=0),e.legendWidth=h,e.legendHeight=c,l&&e.align(),this.proximate||this.positionItems(),fireEvent$t(this,"afterRender")},o.prototype.align=function(e){e===void 0&&(e=this.chart.spacingBox);var t=this.chart,r=this.options,n=e.y;/(lth|ct|rth)/.test(this.getAlignment())&&t.titleOffset[0]>0?n+=t.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&t.titleOffset[2]>0&&(n-=t.titleOffset[2]),n!==e.y&&(e=merge$1c(e,{y:n})),this.group.align(merge$1c(r,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":r.verticalAlign}),!0,e)},o.prototype.handleOverflow=function(e){var t=this,r=this.chart,n=r.renderer,s=this.options,a=s.y,l=s.verticalAlign==="top",h=this.padding,c=s.maxHeight,d=s.navigation,f=pick$1i(d.animation,!0),p=d.arrowSize||12,u=this.pages,g=this.allItems,v=function(k){typeof k=="number"?S.attr({height:k}):S&&(t.clipRect=S.destroy(),t.contentGroup.clip()),t.contentGroup.div&&(t.contentGroup.div.style.clip=k?"rect("+h+"px,9999px,"+(h+k)+"px,0)":"auto")},y=function(k){return t[k]=n.circle(0,0,p*1.3).translate(p/2,p/2).add($),r.styledMode||t[k].attr("fill","rgba(0,0,0,0.0001)"),t[k]},m,x,b=r.spacingBox.height+(l?-a:a)-h,$=this.nav,S=this.clipRect;return s.layout==="horizontal"&&s.verticalAlign!=="middle"&&!s.floating&&(b/=2),c&&(b=Math.min(b,c)),u.length=0,e&&b>0&&e>b&&d.enabled!==!1?(this.clipHeight=m=Math.max(b-20-this.titleHeight-h,0),this.currentPage=pick$1i(this.currentPage,1),this.fullHeight=e,g.forEach(function(k,A){var M=k._legendItemPos[1],P=Math.round(k.legendItem.getBBox().height),E=u.length;(!E||M-u[E-1]>m&&(x||M)!==u[E-1])&&(u.push(x||M),E++),k.pageIx=E-1,x&&(g[A-1].pageIx=E-1),A===g.length-1&&M+P-u[E-1]>m&&M!==x&&(u.push(M),k.pageIx=E),M!==x&&(x=M)}),S||(S=t.clipRect=n.clipRect(0,h,9999,0),t.contentGroup.clip(S)),v(m),$||(this.nav=$=n.g().attr({zIndex:1}).add(this.group),this.up=n.symbol("triangle",0,0,p,p).add($),y("upTracker").on("click",function(){t.scroll(-1,f)}),this.pager=n.text("",15,10).addClass("highcharts-legend-navigation"),r.styledMode||this.pager.css(d.style),this.pager.add($),this.down=n.symbol("triangle-down",0,0,p,p).add($),y("downTracker").on("click",function(){t.scroll(1,f)})),t.scroll(0),e=b):$&&(v(),this.nav=$.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),e},o.prototype.scroll=function(e,t){var r=this,n=this.chart,s=this.pages,a=s.length,l=this.clipHeight,h=this.options.navigation,c=this.pager,d=this.padding,f=this.currentPage+e;if(f>a&&(f=a),f>0){typeof t<"u"&&setAnimation$4(t,n),this.nav.attr({translateX:d,translateY:l+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(u){u.attr({class:f===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),c.attr({text:f+"/"+a}),[this.down,this.downTracker].forEach(function(u){u.attr({x:18+this.pager.getBBox().width,class:f===a?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),n.styledMode||(this.up.attr({fill:f===1?h.inactiveColor:h.activeColor}),this.upTracker.css({cursor:f===1?"default":"pointer"}),this.down.attr({fill:f===a?h.inactiveColor:h.activeColor}),this.downTracker.css({cursor:f===a?"default":"pointer"})),this.scrollOffset=-s[f-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=f,this.positionCheckboxes();var p=animObject$8(pick$1i(t,n.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$t(r,"afterScroll",{currentPage:f})},p.duration)}},o.prototype.setItemEvents=function(e,t,r){var n=this,s=n.chart.renderer.boxWrapper,a=e instanceof Point$2,l="highcharts-legend-"+(a?"point":"series")+"-active",h=n.chart.styledMode,c=r?[t,e.legendSymbol]:[e.legendGroup],d=function(f){n.allItems.forEach(function(p){e!==p&&[p].concat(p.linkedSeries||[]).forEach(function(u){u.setState(f,!a)})})};c.forEach(function(f){f&&f.on("mouseover",function(){e.visible&&d("inactive"),e.setState("hover"),e.visible&&s.addClass(l),h||t.css(n.options.itemHoverStyle)}).on("mouseout",function(){n.chart.styledMode||t.css(merge$1c(e.visible?n.itemStyle:n.itemHiddenStyle)),d(""),s.removeClass(l),e.setState()}).on("click",function(p){var u="legendItemClick",g=function(){e.setVisible&&e.setVisible(),d(e.visible?"inactive":"")};s.removeClass(l),p={browserEvent:p},e.firePointEvent?e.firePointEvent(u,p,g):fireEvent$t(e,u,p,g)})})},o.prototype.createCheckboxForItem=function(e){var t=this;e.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:e.selected,defaultChecked:e.selected},t.options.itemCheckboxStyle,t.chart.container),addEvent$U(e.checkbox,"click",function(r){var n=r.target;fireEvent$t(e.series||e,"checkboxClick",{checked:n.checked,item:e},function(){e.select()})})},o}();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$c(Legend.prototype,"positionItem",function(o,e){var t=this,r=function(){e._legendItemPos&&o.call(t,e)};r(),t.bubbleLegend||setTimeout(r)});var defaultOptions$b=DefaultOptions.defaultOptions,error$6=Utilities.error,extendClass$1=Utilities.extendClass,merge$1b=Utilities.merge,SeriesRegistry;(function(o){o.seriesTypes=H.seriesTypes;function e(n,s){s===void 0&&(s={});var a=n.options.chart,l=s.type||a.type||a.defaultSeriesType||"",h=o.seriesTypes[l];o||error$6(17,!0,n,{missingModuleFor:l});var c=new h;return typeof c.init=="function"&&c.init(n,s),c}o.getSeries=e;function t(n,s){var a=defaultOptions$b.plotOptions||{},l=s.defaultOptions;s.prototype.pointClass||(s.prototype.pointClass=Point$2),s.prototype.type=n,l&&(a[n]=l),o.seriesTypes[n]=s}o.registerSeriesType=t;function r(n,s,a,l,h){var c=defaultOptions$b.plotOptions||{};return s=s||"",c[n]=merge$1b(c[s],a),t(n,extendClass$1(o.seriesTypes[s]||function(){},l)),o.seriesTypes[n].prototype.type=n,h&&(o.seriesTypes[n].prototype.pointClass=extendClass$1(Point$2,h)),o.seriesTypes[n]}o.seriesType=r})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$7=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$3.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$3=H.svg,win$8=H.win,defaultOptions$a=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$T=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$H=Utilities.defined,discardElement$3=Utilities.discardElement,erase$3=Utilities.erase,error$5=Utilities.error,extend$1d=Utilities.extend,find$g=Utilities.find,fireEvent$s=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$g=Utilities.isArray,isNumber$B=Utilities.isNumber,isObject$9=Utilities.isObject,isString$5=Utilities.isString,merge$1a=Utilities.merge,objectEach$n=Utilities.objectEach,pick$1h=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$d=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=function(){function o(e,t,r){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(e,t,r)}return o.chart=function(e,t,r){return new o(e,t,r)},o.prototype.getArgs=function(e,t,r){isString$5(e)||e.nodeName?(this.renderTo=e,this.init(t,r)):this.init(e,t)},o.prototype.init=function(e,t){var r=e.plotOptions||{};fireEvent$s(this,"init",{args:arguments},function(){var n=merge$1a(defaultOptions$a,e),s=n.chart;objectEach$n(n.plotOptions,function(l,h){isObject$9(l)&&(l.tooltip=r[h]&&merge$1a(r[h].tooltip)||void 0)}),n.tooltip.userOptions=e.chart&&e.chart.forExport&&e.tooltip.userOptions||e.tooltip,this.userOptions=e,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=t,this.isResizing=0,this.options=n,this.axes=[],this.series=[],this.time=e.time&&Object.keys(e.time).length?new Time(e.time):H.time,this.numberFormatter=s.numberFormatter||numberFormat$1,this.styledMode=s.styledMode,this.hasCartesianSeries=s.showAxes;var a=this;a.index=charts$1.length,charts$1.push(a),H.chartCount++,registerEventOptions$1(this,s),a.xAxis=[],a.yAxis=[],a.pointCount=a.colorCounter=a.symbolCounter=0,fireEvent$s(a,"afterInit"),a.firstRender()})},o.prototype.initSeries=function(e){var t=this,r=t.options.chart,n=e.type||r.type||r.defaultSeriesType,s=seriesTypes$7[n];s||error$5(17,!0,t,{missingModuleFor:n});var a=new s;return typeof a.init=="function"&&a.init(t,e),a},o.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(e){!e.points&&!e.data&&e.enabledDataSorting&&e.setData(e.options.data,!1)})},o.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(e,t){return e.linkedSeries.length||t.linkedSeries.length?t.linkedSeries.length-e.linkedSeries.length:0})},o.prototype.orderSeries=function(e){for(var t=this.series,r=e||0,n=t.length;r<n;++r)t[r]&&(t[r].index=r,t[r].name=t[r].getName())},o.prototype.isInsidePlot=function(e,t,r){var n;r===void 0&&(r={});var s=this,a=s.inverted,l=s.plotBox,h=s.plotLeft,c=s.plotTop,d=s.scrollablePlotBox,f=0,p=0;r.visiblePlotOnly&&this.scrollingContainer&&(n=this.scrollingContainer,f=n.scrollLeft,p=n.scrollTop);var u=r.series,g=r.visiblePlotOnly&&d||l,v=r.inverted?t:e,y=r.inverted?e:t,m={x:v,y,isInsidePlot:!0};if(!r.ignoreX){var x=u&&(a?u.yAxis:u.xAxis)||{pos:h,len:1/0},b=r.paneCoordinates?x.pos+v:h+v;b>=Math.max(f+h,x.pos)&&b<=Math.min(f+h+g.width,x.pos+x.len)||(m.isInsidePlot=!1)}if(!r.ignoreY&&m.isInsidePlot){var $=u&&(a?u.xAxis:u.yAxis)||{pos:c,len:1/0},S=r.paneCoordinates?$.pos+y:c+y;S>=Math.max(p+c,$.pos)&&S<=Math.min(p+c+g.height,$.pos+$.len)||(m.isInsidePlot=!1)}return fireEvent$s(this,"afterIsInsidePlot",m),m.isInsidePlot},o.prototype.redraw=function(e){fireEvent$s(this,"beforeRedraw");var t=this,r=t.hasCartesianSeries?t.axes:t.colorAxis||[],n=t.series,s=t.pointer,a=t.legend,l=t.userOptions.legend,h=t.renderer,c=h.isHidden(),d=[],f,p,u,g=t.isDirtyBox,v=t.isDirtyLegend,y;for(t.setResponsive&&t.setResponsive(!1),setAnimation$3(t.hasRendered?e:!1,t),c&&t.temporaryDisplay(),t.layOutTitles(),u=n.length;u--;)if(y=n[u],(y.options.stacking||y.options.centerInCategory)&&(p=!0,y.isDirty)){f=!0;break}if(f)for(u=n.length;u--;)y=n[u],y.options.stacking&&(y.isDirty=!0);n.forEach(function(m){m.isDirty&&(m.options.legendType==="point"?(typeof m.updateTotals=="function"&&m.updateTotals(),v=!0):l&&(l.labelFormatter||l.labelFormat)&&(v=!0)),m.isDirtyData&&fireEvent$s(m,"updatedData")}),v&&a&&a.options.enabled&&(a.render(),t.isDirtyLegend=!1),p&&t.getStacks(),r.forEach(function(m){m.updateNames(),m.setScale()}),t.getMargins(),r.forEach(function(m){m.isDirty&&(g=!0)}),r.forEach(function(m){var x=m.min+","+m.max;m.extKey!==x&&(m.extKey=x,d.push(function(){fireEvent$s(m,"afterSetExtremes",extend$1d(m.eventArgs,m.getExtremes())),delete m.eventArgs})),(g||p)&&m.redraw()}),g&&t.drawChartBox(),fireEvent$s(t,"predraw"),n.forEach(function(m){(g||m.isDirty)&&m.visible&&m.redraw(),m.isDirtyData=!1}),s&&s.reset(!0),h.draw(),fireEvent$s(t,"redraw"),fireEvent$s(t,"render"),c&&t.temporaryDisplay(!0),d.forEach(function(m){m.call()})},o.prototype.get=function(e){var t=this.series;function r(a){return a.id===e||a.options&&a.options.id===e}for(var n=find$g(this.axes,r)||find$g(this.series,r),s=0;!n&&s<t.length;s++)n=find$g(t[s].points||[],r);return n},o.prototype.getAxes=function(){var e=this,t=this.options,r=t.xAxis=splat$d(t.xAxis||{}),n=t.yAxis=splat$d(t.yAxis||{});fireEvent$s(this,"getAxes"),r.forEach(function(a,l){a.index=l,a.isX=!0}),n.forEach(function(a,l){a.index=l});var s=r.concat(n);s.forEach(function(a){new Axis(e,a)}),fireEvent$s(this,"afterGetAxes")},o.prototype.getSelectedPoints=function(){return this.series.reduce(function(e,t){return t.getPointsCollection().forEach(function(r){pick$1h(r.selectedStaging,r.selected)&&e.push(r)}),e},[])},o.prototype.getSelectedSeries=function(){return this.series.filter(function(e){return e.selected})},o.prototype.setTitle=function(e,t,r){this.applyDescription("title",e),this.applyDescription("subtitle",t),this.applyDescription("caption",void 0),this.layOutTitles(r)},o.prototype.applyDescription=function(e,t){var r=this,n=e==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},s=this.options[e]=merge$1a(!this.styledMode&&{style:n},this.options[e],t),a=this[e];a&&t&&(this[e]=a=a.destroy()),s&&!a&&(a=this.renderer.text(s.text,0,0,s.useHTML).attr({align:s.align,class:"highcharts-"+e,zIndex:s.zIndex||4}).add(),a.update=function(l){var h={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[e];r[h](l)},this.styledMode||a.css(s.style),this[e]=a)},o.prototype.layOutTitles=function(e){var t=[0,0,0],r=this.renderer,n=this.spacingBox;["title","subtitle","caption"].forEach(function(a){var l=this[a],h=this.options[a],c=h.verticalAlign||"top",d=a==="title"?c==="top"?-3:0:c==="top"?t[0]+2:0,f,p;l&&(this.styledMode||(f=h.style&&h.style.fontSize),f=r.fontMetrics(f,l).b,l.css({width:(h.width||n.width+(h.widthAdjust||0))+"px"}),p=Math.round(l.getBBox(h.useHTML).height),l.align(extend$1d({y:c==="bottom"?f:d+f,height:p},h),!1,"spacingBox"),h.floating||(c==="top"?t[0]=Math.ceil(t[0]+p):c==="bottom"&&(t[2]=Math.ceil(t[2]+p))))},this),t[0]&&(this.options.title.verticalAlign||"top")==="top"&&(t[0]+=this.options.title.margin),t[2]&&this.options.caption.verticalAlign==="bottom"&&(t[2]+=this.options.caption.margin);var s=!this.titleOffset||this.titleOffset.join(",")!==t.join(",");this.titleOffset=t,fireEvent$s(this,"afterLayOutTitles"),!this.isDirtyBox&&s&&(this.isDirtyBox=this.isDirtyLegend=s,this.hasRendered&&pick$1h(e,!0)&&this.isDirtyBox&&this.redraw())},o.prototype.getChartSize=function(){var e=this,t=e.options.chart,r=t.width,n=t.height,s=e.renderTo;defined$H(r)||(e.containerWidth=getStyle(s,"width")),defined$H(n)||(e.containerHeight=getStyle(s,"height")),e.chartWidth=Math.max(0,r||e.containerWidth||600),e.chartHeight=Math.max(0,relativeLength$7(n,e.chartWidth)||(e.containerHeight>1?e.containerHeight:400))},o.prototype.temporaryDisplay=function(e){var t=this.renderTo,r;if(e)for(;t&&t.style;)t.hcOrigStyle&&(css$5(t,t.hcOrigStyle),delete t.hcOrigStyle),t.hcOrigDetached&&(doc$g.body.removeChild(t),t.hcOrigDetached=!1),t=t.parentNode;else for(;t&&t.style&&(!doc$g.body.contains(t)&&!t.parentNode&&(t.hcOrigDetached=!0,doc$g.body.appendChild(t)),(getStyle(t,"display",!1)==="none"||t.hcOricDetached)&&(t.hcOrigStyle={display:t.style.display,height:t.style.height,overflow:t.style.overflow},r={display:"block",overflow:"hidden"},t!==this.renderTo&&(r.height=0),css$5(t,r),t.offsetWidth||t.style.setProperty("display","block","important")),t=t.parentNode,t!==doc$g.body););},o.prototype.setClassName=function(e){this.container.className="highcharts-container "+(e||"")},o.prototype.getContainer=function(){var e=this,t=e.options,r=t.chart,n="data-highcharts-chart",s=uniqueKey$4(),a,l=e.renderTo;l||(e.renderTo=l=r.renderTo),isString$5(l)&&(e.renderTo=l=doc$g.getElementById(l)),l||error$5(13,!0,e);var h=pInt$4(attr$1(l,n));isNumber$B(h)&&charts$1[h]&&charts$1[h].hasRendered&&charts$1[h].destroy(),attr$1(l,n,e.index),l.innerHTML="",!r.skipClone&&!l.offsetWidth&&e.temporaryDisplay(),e.getChartSize();var c=e.chartWidth,d=e.chartHeight;css$5(l,{overflow:"hidden"}),e.styledMode||(a=extend$1d({position:"relative",overflow:"hidden",width:c+"px",height:d+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},r.style||{}));var f=createElement$5("div",{id:s},a,l);e.container=f,e._cursor=f.style.cursor;var p=r.renderer||!svg$3?RendererRegistry$1.getRendererType(r.renderer):SVGRenderer;if(e.renderer=new p(f,c,d,void 0,r.forExport,t.exporting&&t.exporting.allowHTML,e.styledMode),setAnimation$3(void 0,e),e.setClassName(r.className),!e.styledMode)e.renderer.setStyle(r.style);else for(var u in t.defs)this.renderer.definition(t.defs[u]);e.renderer.chartIndex=e.index,fireEvent$s(this,"afterGetContainer")},o.prototype.getMargins=function(e){var t=this,r=t.spacing,n=t.margin,s=t.titleOffset;this.resetMargins(),s[0]&&!defined$H(n[0])&&(this.plotTop=Math.max(this.plotTop,s[0]+r[0])),s[2]&&!defined$H(n[2])&&(this.marginBottom=Math.max(this.marginBottom,s[2]+r[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(n,r),fireEvent$s(this,"getMargins"),e||this.getAxisMargins()},o.prototype.getAxisMargins=function(){var e=this,t=e.axisOffset=[0,0,0,0],r=e.colorAxis,n=e.margin,s=function(a){a.forEach(function(l){l.visible&&l.getOffset()})};e.hasCartesianSeries?s(e.axes):r&&r.length&&s(r),marginNames.forEach(function(a,l){defined$H(n[l])||(e[a]+=t[l])}),e.setChartSize()},o.prototype.reflow=function(e){var t=this,r=t.options.chart,n=t.renderTo,s=defined$H(r.width)&&defined$H(r.height),a=r.width||getStyle(n,"width"),l=r.height||getStyle(n,"height"),h=e?e.target:win$8;delete t.pointer.chartPosition,!s&&!t.isPrinting&&a&&l&&(h===win$8||h===doc$g)&&((a!==t.containerWidth||l!==t.containerHeight)&&(Utilities.clearTimeout(t.reflowTimeout),t.reflowTimeout=syncTimeout$3(function(){t.container&&t.setSize(void 0,void 0,!1)},e?100:0)),t.containerWidth=a,t.containerHeight=l)},o.prototype.setReflow=function(e){var t=this;e!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$T(win$8,"resize",function(r){t.options&&t.reflow(r)}),addEvent$T(this,"destroy",this.unbindReflow)):e===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},o.prototype.setSize=function(e,t,r){var n=this,s=n.renderer;n.isResizing+=1,setAnimation$3(r,n);var a=s.globalAnimation;n.oldChartHeight=n.chartHeight,n.oldChartWidth=n.chartWidth,typeof e<"u"&&(n.options.chart.width=e),typeof t<"u"&&(n.options.chart.height=t),n.getChartSize(),n.styledMode||(a?animate:css$5)(n.container,{width:n.chartWidth+"px",height:n.chartHeight+"px"},a),n.setChartSize(!0),s.setSize(n.chartWidth,n.chartHeight,a),n.axes.forEach(function(l){l.isDirty=!0,l.setScale()}),n.isDirtyLegend=!0,n.isDirtyBox=!0,n.layOutTitles(),n.getMargins(),n.redraw(a),n.oldChartHeight=null,fireEvent$s(n,"resize"),syncTimeout$3(function(){n&&fireEvent$s(n,"endResize",null,function(){n.isResizing-=1})},animObject$7(a).duration)},o.prototype.setChartSize=function(e){var t=this,r=t.inverted,n=t.renderer,s=t.chartWidth,a=t.chartHeight,l=t.options.chart,h=t.spacing,c=t.clipOffset,d,f,p,u;t.plotLeft=d=Math.round(t.plotLeft),t.plotTop=f=Math.round(t.plotTop),t.plotWidth=p=Math.max(0,Math.round(s-d-t.marginRight)),t.plotHeight=u=Math.max(0,Math.round(a-f-t.marginBottom)),t.plotSizeX=r?u:p,t.plotSizeY=r?p:u,t.plotBorderWidth=l.plotBorderWidth||0,t.spacingBox=n.spacingBox={x:h[3],y:h[0],width:s-h[3]-h[1],height:a-h[0]-h[2]},t.plotBox=n.plotBox={x:d,y:f,width:p,height:u};var g=2*Math.floor(t.plotBorderWidth/2),v=Math.ceil(Math.max(g,c[3])/2),y=Math.ceil(Math.max(g,c[0])/2);t.clipBox={x:v,y,width:Math.floor(t.plotSizeX-Math.max(g,c[1])/2-v),height:Math.max(0,Math.floor(t.plotSizeY-Math.max(g,c[2])/2-y))},e||(t.axes.forEach(function(m){m.setAxisSize(),m.setAxisTranslation()}),n.alignElements()),fireEvent$s(t,"afterSetChartSize",{skipAxes:e})},o.prototype.resetMargins=function(){fireEvent$s(this,"resetMargins");var e=this,t=e.options.chart;["margin","spacing"].forEach(function(n){var s=t[n],a=isObject$9(s)?s:[s,s,s,s];["Top","Right","Bottom","Left"].forEach(function(l,h){e[n][h]=pick$1h(t[n+l],a[h])})}),marginNames.forEach(function(r,n){e[r]=pick$1h(e.margin[n],e.spacing[n])}),e.axisOffset=[0,0,0,0],e.clipOffset=[0,0,0,0]},o.prototype.drawChartBox=function(){var e=this,t=e.options.chart,r=e.renderer,n=e.chartWidth,s=e.chartHeight,a=e.styledMode,l=e.plotBGImage,h=t.backgroundColor,c=t.plotBackgroundColor,d=t.plotBackgroundImage,f=e.plotLeft,p=e.plotTop,u=e.plotWidth,g=e.plotHeight,v=e.plotBox,y=e.clipRect,m=e.clipBox,x=e.chartBackground,b=e.plotBackground,$=e.plotBorder,S,k,A,M="animate";x||(e.chartBackground=x=r.rect().addClass("highcharts-background").add(),M="attr"),a?S=k=x.strokeWidth():(S=t.borderWidth||0,k=S+(t.shadow?8:0),A={fill:h||"none"},(S||x["stroke-width"])&&(A.stroke=t.borderColor,A["stroke-width"]=S),x.attr(A).shadow(t.shadow)),x[M]({x:k/2,y:k/2,width:n-k-S%2,height:s-k-S%2,r:t.borderRadius}),M="animate",b||(M="attr",e.plotBackground=b=r.rect().addClass("highcharts-plot-background").add()),b[M](v),a||(b.attr({fill:c||"none"}).shadow(t.plotShadow),d&&(l?(d!==l.attr("href")&&l.attr("href",d),l.animate(v)):e.plotBGImage=r.image(d,f,p,u,g).add())),y?y.animate({width:m.width,height:m.height}):e.clipRect=r.clipRect(m),M="animate",$||(M="attr",e.plotBorder=$=r.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),a||$.attr({stroke:t.plotBorderColor,"stroke-width":t.plotBorderWidth||0,fill:"none"}),$[M]($.crisp({x:f,y:p,width:u,height:g},-$.strokeWidth())),e.isDirtyBox=!1,fireEvent$s(this,"afterDrawChartBox")},o.prototype.propFromSeries=function(){var e=this,t=e.options.chart,r=e.options.series,n,s,a;["inverted","angular","polar"].forEach(function(l){for(s=seriesTypes$7[t.type||t.defaultSeriesType],a=t[l]||s&&s.prototype[l],n=r&&r.length;!a&&n--;)s=seriesTypes$7[r[n].type],s&&s.prototype[l]&&(a=!0);e[l]=a})},o.prototype.linkSeries=function(){var e=this,t=e.series;t.forEach(function(r){r.linkedSeries.length=0}),t.forEach(function(r){var n=r.options.linkedTo;isString$5(n)&&(n===":previous"?n=e.series[r.index-1]:n=e.get(n),n&&n.linkedParent!==r&&(n.linkedSeries.push(r),r.linkedParent=n,n.enabledDataSorting&&r.setDataSortingOptions(),r.visible=pick$1h(r.options.visible,n.options.visible,r.visible)))}),fireEvent$s(this,"afterLinkSeries")},o.prototype.renderSeries=function(){this.series.forEach(function(e){e.translate(),e.render()})},o.prototype.renderLabels=function(){var e=this,t=e.options.labels;t.items&&t.items.forEach(function(r){var n=extend$1d(t.style,r.style),s=pInt$4(n.left)+e.plotLeft,a=pInt$4(n.top)+e.plotTop+12;delete n.left,delete n.top,e.renderer.text(r.html,s,a).attr({zIndex:2}).css(n).add()})},o.prototype.render=function(){var e=this,t=e.axes,r=e.colorAxis,n=e.renderer,s=e.options,a=function(p){p.forEach(function(u){u.visible&&u.render()})},l=0;e.setTitle(),e.legend=new Legend(e,s.legend),e.getStacks&&e.getStacks(),e.getMargins(!0),e.setChartSize();var h=e.plotWidth;t.some(function(p){if(p.horiz&&p.visible&&p.options.labels.enabled&&p.series.length)return l=21,!0}),e.plotHeight=Math.max(e.plotHeight-l,0);var c=e.plotHeight;t.forEach(function(p){p.setScale()}),e.getAxisMargins();var d=h/e.plotWidth>1.1,f=c/e.plotHeight>1.05;(d||f)&&(t.forEach(function(p){(p.horiz&&d||!p.horiz&&f)&&p.setTickInterval(!0)}),e.getMargins()),e.drawChartBox(),e.hasCartesianSeries?a(t):r&&r.length&&a(r),e.seriesGroup||(e.seriesGroup=n.g("series-group").attr({zIndex:3}).add()),e.renderSeries(),e.renderLabels(),e.addCredits(),e.setResponsive&&e.setResponsive(),e.hasRendered=!0},o.prototype.addCredits=function(e){var t=this,r=merge$1a(!0,this.options.credits,e);r.enabled&&!this.credits&&(this.credits=this.renderer.text(r.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){r.href&&(win$8.location.href=r.href)}).attr({align:r.position.align,zIndex:8}),t.styledMode||this.credits.css(r.style),this.credits.add().align(r.position),this.credits.update=function(n){t.credits=t.credits.destroy(),t.addCredits(n)})},o.prototype.destroy=function(){var e=this,t=e.axes,r=e.series,n=e.container,s=n&&n.parentNode,a;for(fireEvent$s(e,"destroy"),e.renderer.forExport?erase$3(charts$1,e):charts$1[e.index]=void 0,H.chartCount--,e.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(e),a=t.length;a--;)t[a]=t[a].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),a=r.length;a--;)r[a]=r[a].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(l){var h=e[l];h&&h.destroy&&(e[l]=h.destroy())}),n&&(n.innerHTML="",removeEvent$6(n),s&&discardElement$3(n)),objectEach$n(e,function(l,h){delete e[h]})},o.prototype.firstRender=function(){var e=this,t=e.options;e.isReadyToRender&&!e.isReadyToRender()||(e.getContainer(),e.resetMargins(),e.setChartSize(),e.propFromSeries(),e.getAxes(),(isArray$g(t.series)?t.series:[]).forEach(function(r){e.initSeries(r)}),e.linkSeries(),e.setSeriesData(),fireEvent$s(e,"beforeRender"),Pointer&&(MSPointer.isRequired()?e.pointer=new MSPointer(e,t):e.pointer=new Pointer(e,t)),e.render(),e.pointer.getChartPosition(),!e.renderer.imgCount&&!e.hasLoaded&&e.onload(),e.temporaryDisplay(!0))},o.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(e){e&&typeof this.index<"u"&&e.apply(this,[this])},this),fireEvent$s(this,"load"),fireEvent$s(this,"render"),defined$H(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},o.prototype.addSeries=function(e,t,r){var n=this,s;return e&&(t=pick$1h(t,!0),fireEvent$s(n,"addSeries",{options:e},function(){s=n.initSeries(e),n.isDirtyLegend=!0,n.linkSeries(),s.enabledDataSorting&&s.setData(e.data,!1),fireEvent$s(n,"afterAddSeries",{series:s}),t&&n.redraw(r)})),s},o.prototype.addAxis=function(e,t,r,n){return this.createAxis(t?"xAxis":"yAxis",{axis:e,redraw:r,animation:n})},o.prototype.addColorAxis=function(e,t,r){return this.createAxis("colorAxis",{axis:e,redraw:t,animation:r})},o.prototype.createAxis=function(e,t){var r=new Axis(this,merge$1a(t.axis,{index:this[e].length,isX:e==="xAxis"}));return pick$1h(t.redraw,!0)&&this.redraw(t.animation),r},o.prototype.showLoading=function(e){var t=this,r=t.options,n=r.loading,s=function(){a&&css$5(a,{left:t.plotLeft+"px",top:t.plotTop+"px",width:t.plotWidth+"px",height:t.plotHeight+"px"})},a=t.loadingDiv,l=t.loadingSpan;a||(t.loadingDiv=a=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,t.container)),l||(t.loadingSpan=l=createElement$5("span",{className:"highcharts-loading-inner"},null,a),addEvent$T(t,"redraw",s)),a.className="highcharts-loading",AST.setElementHTML(l,pick$1h(e,r.lang.loading,"")),t.styledMode||(css$5(a,extend$1d(n.style,{zIndex:10})),css$5(l,n.labelStyle),t.loadingShown||(css$5(a,{opacity:0,display:""}),animate(a,{opacity:n.style.opacity||.5},{duration:n.showDuration||0}))),t.loadingShown=!0,s()},o.prototype.hideLoading=function(){var e=this.options,t=this.loadingDiv;t&&(t.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(t,{opacity:0},{duration:e.loading.hideDuration||100,complete:function(){css$5(t,{display:"none"})}})),this.loadingShown=!1},o.prototype.update=function(e,t,r,n){var s=this,a={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},l=e.isResponsiveOptions,h=[],c,d,f;fireEvent$s(s,"update",{options:e}),l||s.setResponsive(!1,!0),e=cleanRecursively$1(e,s.options),s.userOptions=merge$1a(s.userOptions,e);var p=e.chart;p&&(merge$1a(!0,s.options.chart,p),"className"in p&&s.setClassName(p.className),"reflow"in p&&s.setReflow(p.reflow),("inverted"in p||"polar"in p||"type"in p)&&(s.propFromSeries(),c=!0),"alignTicks"in p&&(c=!0),"events"in p&&registerEventOptions$1(this,p),objectEach$n(p,function(v,y){s.propsRequireUpdateSeries.indexOf("chart."+y)!==-1&&(d=!0),s.propsRequireDirtyBox.indexOf(y)!==-1&&(s.isDirtyBox=!0),s.propsRequireReflow.indexOf(y)!==-1&&(l?s.isDirtyBox=!0:f=!0)}),!s.styledMode&&p.style&&s.renderer.setStyle(s.options.chart.style||{})),!s.styledMode&&e.colors&&(this.options.colors=e.colors),e.time&&(this.time===defaultTime&&(this.time=new Time(e.time)),merge$1a(!0,s.options.time,e.time)),objectEach$n(e,function(v,y){s[y]&&typeof s[y].update=="function"?s[y].update(v,!1):typeof s[a[y]]=="function"?s[a[y]](v):y!=="colors"&&s.collectionsWithUpdate.indexOf(y)===-1&&merge$1a(!0,s.options[y],e[y]),y!=="chart"&&s.propsRequireUpdateSeries.indexOf(y)!==-1&&(d=!0)}),this.collectionsWithUpdate.forEach(function(v){var y;e[v]&&(y=[],s[v].forEach(function(m,x){m.options.isInternal||y.push(pick$1h(m.options.index,x))}),splat$d(e[v]).forEach(function(m,x){var b=defined$H(m.id),$;b&&($=s.get(m.id)),!$&&s[v]&&($=s[v][y?y[x]:x],$&&b&&defined$H($.options.id)&&($=void 0)),$&&$.coll===v&&($.update(m,!1),r&&($.touched=!0)),!$&&r&&s.collectionsWithInit[v]&&(s.collectionsWithInit[v][0].apply(s,[m].concat(s.collectionsWithInit[v][1]||[]).concat([!1])).touched=!0)}),r&&s[v].forEach(function(m){!m.touched&&!m.options.isInternal?h.push(m):delete m.touched}))}),h.forEach(function(v){v.chart&&v.remove&&v.remove(!1)}),c&&s.axes.forEach(function(v){v.update({},!1)}),d&&s.getSeriesOrderByLinks().forEach(function(v){v.chart&&v.update({},!1)},this);var u=p&&p.width,g=p&&(isString$5(p.height)?relativeLength$7(p.height,u||s.chartWidth):p.height);f||isNumber$B(u)&&u!==s.chartWidth||isNumber$B(g)&&g!==s.chartHeight?s.setSize(u,g,n):pick$1h(t,!0)&&s.redraw(n),fireEvent$s(s,"afterUpdate",{options:e,redraw:t,animation:n})},o.prototype.setSubtitle=function(e,t){this.applyDescription("subtitle",e),this.layOutTitles(t)},o.prototype.setCaption=function(e,t){this.applyDescription("caption",e),this.layOutTitles(t)},o.prototype.showResetZoom=function(){var e=this,t=defaultOptions$a.lang,r=e.options.chart.resetZoomButton,n=r.theme,s=n.states,a=r.relativeTo==="chart"||r.relativeTo==="spacingBox"?null:"scrollablePlotBox";function l(){e.zoomOut()}fireEvent$s(this,"beforeShowResetZoom",null,function(){e.resetZoomButton=e.renderer.button(t.resetZoom,null,null,l,n,s&&s.hover).attr({align:r.position.align,title:t.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(r.position,!1,a)}),fireEvent$s(this,"afterShowResetZoom")},o.prototype.zoomOut=function(){fireEvent$s(this,"selection",{resetSelection:!0},this.zoom)},o.prototype.zoom=function(e){var t=this,r=t.pointer,n=t.inverted?r.mouseDownX:r.mouseDownY,s=!1,a;!e||e.resetSelection?(t.axes.forEach(function(h){a=h.zoom()}),r.initiated=!1):e.xAxis.concat(e.yAxis).forEach(function(h){var c=h.axis,d=t.inverted?c.left:c.top,f=t.inverted?d+c.width:d+c.height,p=c.isXAxis,u=!1;(!p&&n>=d&&n<=f||p||!defined$H(n))&&(u=!0),r[p?"zoomX":"zoomY"]&&u&&(a=c.zoom(h.min,h.max),c.displayBtn&&(s=!0))});var l=t.resetZoomButton;s&&!l?t.showResetZoom():!s&&isObject$9(l)&&(t.resetZoomButton=l.destroy()),a&&t.redraw(pick$1h(t.options.chart.animation,e&&e.animation,t.pointCount<100))},o.prototype.pan=function(e,t){var r=this,n=r.hoverPoints,s=typeof t=="object"?t:{enabled:t,type:"x"},a=r.options.chart,l=r.options.mapNavigation&&r.options.mapNavigation.enabled;a&&a.panning&&(a.panning=s);var h=s.type,c;fireEvent$s(this,"pan",{originalEvent:e},function(){n&&n.forEach(function(p){p.setState()});var d=r.xAxis;h==="xy"?d=d.concat(r.yAxis):h==="y"&&(d=r.yAxis);var f={};d.forEach(function(p){if(!(!p.options.panningEnabled||p.options.isInternal)){var u=p.horiz,g=e[u?"chartX":"chartY"],v=u?"mouseDownX":"mouseDownY",y=r[v],m=p.minPointOffset||0,x=p.reversed&&!r.inverted||!p.reversed&&r.inverted?-1:1,b=p.getExtremes(),$=p.toValue(y-g,!0)+m*x,S=p.toValue(y+p.len-g,!0)-(m*x||p.isXAxis&&p.pointRangePadding||0),k=S<$,A=p.hasVerticalPanning(),M=k?S:$,P=k?$:S,E=p.panningState,T;A&&!p.isXAxis&&(!E||E.isDirty)&&p.series.forEach(function(I){var L=I.getProcessedData(!0),D=I.getExtremes(L.yData,!0);E||(E={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$B(D.dataMin)&&isNumber$B(D.dataMax)&&(E.startMin=Math.min(pick$1h(I.options.threshold,1/0),D.dataMin,E.startMin),E.startMax=Math.max(pick$1h(I.options.threshold,-1/0),D.dataMax,E.startMax))});var O=Math.min(pick$1h(E&&E.startMin,b.dataMin),m?b.min:p.toValue(p.toPixels(b.min)-p.minPixelPadding)),C=Math.max(pick$1h(E&&E.startMax,b.dataMax),m?b.max:p.toValue(p.toPixels(b.max)+p.minPixelPadding));p.panningState=E,p.isOrdinal||(T=O-M,T>0&&(P+=T,M=O),T=P-C,T>0&&(P=C,M-=T),p.series.length&&M!==b.min&&P!==b.max&&M>=O&&P<=C&&(p.setExtremes(M,P,!1,!1,{trigger:"pan"}),!r.resetZoomButton&&!l&&M!==O&&P!==C&&h.match("y")&&(r.showResetZoom(),p.displayBtn=!1),c=!0),f[v]=g)}}),objectEach$n(f,function(p,u){r[u]=p}),c&&r.redraw(!1),css$5(r.container,{cursor:"move"})})},o}();extend$1d(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$19=Utilities.merge,pick$1g=Utilities.pick,LegendSymbol;(function(o){function e(r){var n=this.options,s=r.symbolWidth,a=r.symbolHeight,l=a/2,h=this.chart.renderer,c=this.legendGroup,d=r.baseline-Math.round(r.fontMetrics.b*.3),f={},p,u=n.marker;if(this.chart.styledMode||(f={"stroke-width":n.lineWidth||0},n.dashStyle&&(f.dashstyle=n.dashStyle)),this.legendLine=h.path([["M",0,d],["L",s,d]]).addClass("highcharts-graph").attr(f).add(c),u&&u.enabled!==!1&&s){var g=Math.min(pick$1g(u.radius,l),l);this.symbol.indexOf("url")===0&&(u=merge$19(u,{width:a,height:a}),g=0),this.legendSymbol=p=h.symbol(this.symbol,s/2-g,d-g,2*g,2*g,u).addClass("highcharts-point").add(c),p.isMarker=!0}}o.drawLineMarker=e;function t(r,n){var s=r.options,a=r.symbolHeight,l=s.squareSymbol,h=l?a:r.symbolWidth;n.legendSymbol=this.chart.renderer.rect(l?(r.symbolWidth-a)/2:0,r.baseline-a+1,h,a,pick$1g(r.options.symbolRadius,a/2)).addClass("highcharts-point").attr({zIndex:3}).add(n.legendGroup)}o.drawRectangle=t})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var o=this.series.chart.numberFormatter;return typeof this.y!="number"?"":o(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$6=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$9=DefaultOptions.defaultOptions,registerEventOptions=exports$3.registerEventOptions,hasTouch$2=H.hasTouch,svg$2=H.svg,win$7=H.win,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$S=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$e=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$G=Utilities.defined,erase$2=Utilities.erase,error$4=Utilities.error,extend$1c=Utilities.extend,find$f=Utilities.find,fireEvent$r=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$f=Utilities.isArray,isNumber$A=Utilities.isNumber,isString$4=Utilities.isString,merge$18=Utilities.merge,objectEach$m=Utilities.objectEach,pick$1f=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$c=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$e=function(){function o(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return o.prototype.init=function(e,t){fireEvent$r(this,"init",{options:t});var r=this,n=e.series;this.eventsToUnbind=[],r.chart=e,r.options=r.setOptions(t);var s=r.options;r.linkedSeries=[],r.bindAxes(),extend$1c(r,{name:s.name,state:"",visible:s.visible!==!1,selected:s.selected===!0}),registerEventOptions(this,s);var a=s.events;(a&&a.click||s.point&&s.point.events&&s.point.events.click||s.allowPointSelect)&&(e.runTrackerClick=!0),r.getColor(),r.getSymbol(),r.parallelArrays.forEach(function(h){r[h+"Data"]||(r[h+"Data"]=[])}),r.isCartesian&&(e.hasCartesianSeries=!0);var l;n.length&&(l=n[n.length-1]),r._i=pick$1f(l&&l._i,-1)+1,r.opacity=r.options.opacity,e.orderSeries(this.insert(n)),s.dataSorting&&s.dataSorting.enabled?r.setDataSortingOptions():!r.points&&!r.data&&r.setData(s.data,!1),fireEvent$r(this,"afterInit")},o.prototype.is=function(e){return seriesTypes$6[e]&&this instanceof seriesTypes$6[e]},o.prototype.insert=function(e){var t=this.options.index,r;if(isNumber$A(t)){for(r=e.length;r--;)if(t>=pick$1f(e[r].options.index,e[r]._i)){e.splice(r+1,0,this);break}r===-1&&e.unshift(this),r=r+1}else e.push(this);return pick$1f(r,e.length-1)},o.prototype.bindAxes=function(){var e=this,t=e.options,r=e.chart,n;fireEvent$r(this,"bindAxes",null,function(){(e.axisTypes||[]).forEach(function(s){var a=0;r[s].forEach(function(l){n=l.options,(t[s]===a&&!n.isInternal||typeof t[s]<"u"&&t[s]===n.id||typeof t[s]>"u"&&n.index===0)&&(e.insert(l.series),e[s]=l,l.isDirty=!0),n.isInternal||a++}),!e[s]&&e.optionalAxis!==s&&error$4(18,!0,r)})}),fireEvent$r(this,"afterBindAxes")},o.prototype.updateParallelArrays=function(e,t){var r=e.series,n=arguments,s=isNumber$A(t)?function(a){var l=a==="y"&&r.toYData?r.toYData(e):e[a];r[a+"Data"][t]=l}:function(a){Array.prototype[t].apply(r[a+"Data"],Array.prototype.slice.call(n,2))};r.parallelArrays.forEach(s)},o.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},o.prototype.autoIncrement=function(e){var t=this.options,r=t.pointIntervalUnit,n=t.relativeXValue,s=this.chart.time,a=this.xIncrement,l,h;return a=pick$1f(a,t.pointStart,0),this.pointInterval=h=pick$1f(this.pointInterval,t.pointInterval,1),n&&isNumber$A(e)&&(h*=e),r&&(l=new s.Date(a),r==="day"?s.set("Date",l,s.get("Date",l)+h):r==="month"?s.set("Month",l,s.get("Month",l)+h):r==="year"&&s.set("FullYear",l,s.get("FullYear",l)+h),h=l.getTime()-a),n&&isNumber$A(e)?a+h:(this.xIncrement=a+h,a)},o.prototype.setDataSortingOptions=function(){var e=this.options;extend$1c(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$G(e.pointRange)||(e.pointRange=1)},o.prototype.setOptions=function(e){var t=this.chart,r=t.options,n=r.plotOptions,s=t.userOptions||{},a=merge$18(e),l=t.styledMode,h={plotOptions:n,userOptions:a},c;fireEvent$r(this,"setOptions",h);var d=h.plotOptions[this.type],f=s.plotOptions||{};this.userOptions=h.userOptions;var p=merge$18(d,n.series,s.plotOptions&&s.plotOptions[this.type],a);this.tooltipOptions=merge$18(defaultOptions$9.tooltip,defaultOptions$9.plotOptions.series&&defaultOptions$9.plotOptions.series.tooltip,defaultOptions$9.plotOptions[this.type].tooltip,r.tooltip.userOptions,n.series&&n.series.tooltip,n[this.type].tooltip,a.tooltip),this.stickyTracking=pick$1f(a.stickyTracking,f[this.type]&&f[this.type].stickyTracking,f.series&&f.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:p.stickyTracking),d.marker===null&&delete p.marker,this.zoneAxis=p.zoneAxis;var u=this.zones=(p.zones||[]).slice();return(p.negativeColor||p.negativeFillColor)&&!p.zones&&(c={value:p[this.zoneAxis+"Threshold"]||p.threshold||0,className:"highcharts-negative"},l||(c.color=p.negativeColor,c.fillColor=p.negativeFillColor),u.push(c)),u.length&&defined$G(u[u.length-1].value)&&u.push(l?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$r(this,"afterSetOptions",{options:p}),p},o.prototype.getName=function(){return pick$1f(this.options.name,"Series "+(this.index+1))},o.prototype.getCyclic=function(e,t,r){var n=this.chart,s=this.userOptions,a=e+"Index",l=e+"Counter",h=r?r.length:pick$1f(n.options.chart[e+"Count"],n[e+"Count"]),c,d;t||(d=pick$1f(s[a],s["_"+a]),defined$G(d)?c=d:(n.series.length||(n[l]=0),s["_"+a]=c=n[l]%h,n[l]+=1),r&&(t=r[c])),typeof c<"u"&&(this[a]=c),this[e]=t},o.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$9.plotOptions[this.type].color,this.chart.options.colors)},o.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},o.prototype.getSymbol=function(){var e=this.options.marker;this.getCyclic("symbol",e.symbol,this.chart.options.symbols)},o.prototype.findPointIndex=function(e,t){var r=e.id,n=e.x,s=this.points,a=this.options.dataSorting,l,h,c;if(r){var d=this.chart.get(r);d instanceof Point$2&&(l=d)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var f=function(p){return!p.touched&&p.index===e.index};if(a&&a.matchByName?f=function(p){return!p.touched&&p.name===e.name}:this.options.relativeXValue&&(f=function(p){return!p.touched&&p.options.x===e.x}),l=find$f(s,f),!l)return}return l&&(c=l&&l.index,typeof c<"u"&&(h=!0)),typeof c>"u"&&isNumber$A(n)&&(c=this.xData.indexOf(n,t)),c!==-1&&typeof c<"u"&&this.cropped&&(c=c>=this.cropStart?c-this.cropStart:c),!h&&isNumber$A(c)&&s[c]&&s[c].touched&&(c=void 0),c},o.prototype.updateData=function(e,t){var r=this.options,n=r.dataSorting,s=this.points,a=[],l=this.requireSorting,h=e.length===s.length,c,d,f,p,u=!0;if(this.xIncrement=null,e.forEach(function(g,v){var y=defined$G(g)&&this.pointClass.prototype.optionsToObject.call({series:this},g)||{},m,x=y.x,b=y.id;b||isNumber$A(x)?(m=this.findPointIndex(y,p),m===-1||typeof m>"u"?a.push(g):s[m]&&g!==r.data[m]?(s[m].update(g,!1,null,!1),s[m].touched=!0,l&&(p=m+1)):s[m]&&(s[m].touched=!0),(!h||v!==m||n&&n.enabled||this.hasDerivedData)&&(c=!0)):a.push(g)},this),c)for(d=s.length;d--;)f=s[d],f&&!f.touched&&f.remove&&f.remove(!1,t);else h&&(!n||!n.enabled)?(e.forEach(function(g,v){g!==s[v].y&&s[v].update&&s[v].update(g,!1,null,!1)}),a.length=0):u=!1;return s.forEach(function(g){g&&(g.touched=!1)}),u?(a.forEach(function(g){this.addPoint(g,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},o.prototype.setData=function(e,t,r,n){var s=this,a=s.points,l=a&&a.length||0,h=s.options,c=s.chart,d=h.dataSorting,f=s.xAxis,p=h.turboThreshold,u=this.xData,g=this.yData,v=s.pointArrayMap,y=v&&v.length,m=h.keys,x,b,$,S=0,k=1,A=null;e=e||[];var M=e.length;if(t=pick$1f(t,!0),d&&d.enabled&&(e=this.sortData(e)),n!==!1&&M&&l&&!s.cropped&&!s.hasGroupedData&&s.visible&&!s.isSeriesBoosting&&($=this.updateData(e,r)),!$){if(s.xIncrement=null,s.colorCounter=0,this.parallelArrays.forEach(function(P){s[P+"Data"].length=0}),p&&M>p)if(A=s.getFirstValidPoint(e),isNumber$A(A))for(x=0;x<M;x++)u[x]=this.autoIncrement(),g[x]=e[x];else if(isArray$f(A))if(y)for(x=0;x<M;x++)b=e[x],u[x]=b[0],g[x]=b.slice(1,y+1);else for(m&&(S=m.indexOf("x"),k=m.indexOf("y"),S=S>=0?S:0,k=k>=0?k:1),x=0;x<M;x++)b=e[x],u[x]=b[S],g[x]=b[k];else error$4(12,!1,c);else for(x=0;x<M;x++)typeof e[x]<"u"&&(b={series:s},s.pointClass.prototype.applyOptions.apply(b,[e[x]]),s.updateParallelArrays(b,x));for(g&&isString$4(g[0])&&error$4(14,!0,c),s.data=[],s.options.data=s.userOptions.data=e,x=l;x--;)a[x]&&a[x].destroy&&a[x].destroy();f&&(f.minRange=f.userMinRange),s.isDirty=c.isDirtyBox=!0,s.isDirtyData=!!a,r=!1}h.legendType==="point"&&(this.processData(),this.generatePoints()),t&&c.redraw(r)},o.prototype.sortData=function(e){var t=this,r=t.options,n=r.dataSorting,s=n.sortKey||"y",a=function(h,c){return defined$G(c)&&h.pointClass.prototype.optionsToObject.call({series:h},c)||{}};e.forEach(function(h,c){e[c]=a(t,h),e[c].index=c},this);var l=e.concat().sort(function(h,c){var d=getNestedProperty(s,h),f=getNestedProperty(s,c);return f<d?-1:f>d?1:0});return l.forEach(function(h,c){h.x=c},this),t.linkedSeries&&t.linkedSeries.forEach(function(h){var c=h.options,d=c.data;(!c.dataSorting||!c.dataSorting.enabled)&&d&&(d.forEach(function(f,p){d[p]=a(h,f),e[p]&&(d[p].x=e[p].x,d[p].index=p)}),h.setData(d,!1))}),e},o.prototype.getProcessedData=function(e){var t=this,r=t.xAxis,n=t.options,s=n.cropThreshold,a=e||t.getExtremesFromAll||n.getExtremesFromAll,l=t.isCartesian,h=r&&r.val2lin,c=!!(r&&r.logarithmic),d,f,p=0,u,g,v,y,m,x,b=t.xData,$=t.yData,S=t.requireSorting,k=!1,A=b.length;for(r&&(y=r.getExtremes(),m=y.min,x=y.max,k=r.categories&&!r.names.length),l&&t.sorted&&!a&&(!s||A>s||t.forceCrop)&&(b[A-1]<m||b[0]>x?(b=[],$=[]):t.yData&&(b[0]<m||b[A-1]>x)&&(d=this.cropData(t.xData,t.yData,m,x),b=d.xData,$=d.yData,p=d.start,f=!0)),v=b.length||1;--v;)u=c?h(b[v])-h(b[v-1]):b[v]-b[v-1],u>0&&(typeof g>"u"||u<g)?g=u:u<0&&S&&!k&&(error$4(15,!1,t.chart),S=!1);return{xData:b,yData:$,cropped:f,cropStart:p,closestPointRange:g}},o.prototype.processData=function(e){var t=this,r=t.xAxis;if(t.isCartesian&&!t.isDirty&&!r.isDirty&&!t.yAxis.isDirty&&!e)return!1;var n=t.getProcessedData();t.cropped=n.cropped,t.cropStart=n.cropStart,t.processedXData=n.xData,t.processedYData=n.yData,t.closestPointRange=t.basePointRange=n.closestPointRange},o.prototype.cropData=function(e,t,r,n,s){var a=e.length,l,h,c=0,d=a;for(s=pick$1f(s,this.cropShoulder),l=0;l<a;l++)if(e[l]>=r){c=Math.max(0,l-s);break}for(h=l;h<a;h++)if(e[h]>n){d=h+s;break}return{xData:e.slice(c,d),yData:t.slice(c,d),start:c,end:d}},o.prototype.generatePoints=function(){var e=this,t=e.options,r=t.data,n=e.processedXData,s=e.processedYData,a=e.pointClass,l=n.length,h=e.cropStart||0,c=e.hasGroupedData,d=t.keys,f=[],p=t.dataGrouping&&t.dataGrouping.groupAll?h:0,u,g,v,y,m=e.data;if(!m&&!c){var x=[];x.length=r.length,m=e.data=x}for(d&&c&&(e.options.keys=!1),y=0;y<l;y++)g=h+y,c?(v=new a().init(e,[n[y]].concat(splat$c(s[y]))),v.dataGroup=e.groupMap[p+y],v.dataGroup.options&&(v.options=v.dataGroup.options,extend$1c(v,v.dataGroup.options),delete v.dataLabels)):(v=m[g],!v&&typeof r[g]<"u"&&(m[g]=v=new a().init(e,r[g],n[y]))),v&&(v.index=c?p+y:g,f[y]=v);if(e.options.keys=d,m&&(l!==(u=m.length)||c))for(y=0;y<u;y++)y===h&&!c&&(y+=l),m[y]&&(m[y].destroyElements(),m[y].plotX=void 0);e.data=m,e.points=f,fireEvent$r(this,"afterGeneratePoints")},o.prototype.getXExtremes=function(e){return{min:arrayMin$6(e),max:arrayMax$7(e)}},o.prototype.getExtremes=function(e,t){var r=this.xAxis,n=this.yAxis,s=this.processedXData||this.xData,a=[],l=this.requireSorting?this.cropShoulder:0,h=n?n.positiveValuesOnly:!1,c,d,f,p,u,g,v,y=0,m=0,x=0;e=e||this.stackedYData||this.processedYData||[];var b=e.length;for(r&&(c=r.getExtremes(),y=c.min,m=c.max),g=0;g<b;g++)if(p=s[g],u=e[g],d=(isNumber$A(u)||isArray$f(u))&&(u.length||u>0||!h),f=t||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!r||(s[g+l]||p)>=y&&(s[g-l]||p)<=m,d&&f)if(v=u.length,v)for(;v--;)isNumber$A(u[v])&&(a[x++]=u[v]);else a[x++]=u;var $={dataMin:arrayMin$6(a),dataMax:arrayMax$7(a)};return fireEvent$r(this,"afterGetExtremes",{dataExtremes:$}),$},o.prototype.applyExtremes=function(){var e=this.getExtremes();return this.dataMin=e.dataMin,this.dataMax=e.dataMax,e},o.prototype.getFirstValidPoint=function(e){for(var t=e.length,r=0,n=null;n===null&&r<t;)n=e[r],r++;return n},o.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var e=this,t=e.options,r=t.stacking,n=e.xAxis,s=n.categories,a=e.enabledDataSorting,l=e.yAxis,h=e.points,c=h.length,d=!!e.modifyValue,f=e.pointPlacementToXValue(),p=!!f,u=t.threshold,g=t.startFromThreshold?u:0,v=this.zoneAxis||"y",y,m,x,b,$=Number.MAX_VALUE;function S(I){return clamp$e(I,-1e5,1e5)}for(y=0;y<c;y++){var k=h[y],A=k.x,M=void 0,P=void 0,E=k.y,T=k.low,O=r&&l.stacking&&l.stacking.stacks[(e.negStacks&&E<(g?0:u)?"-":"")+e.stackKey];if((l.positiveValuesOnly&&!l.validatePositiveValue(E)||n.positiveValuesOnly&&!n.validatePositiveValue(A))&&(k.isNull=!0),k.plotX=m=correctFloat$a(S(n.translate(A,0,0,0,1,f,this.type==="flags"))),r&&e.visible&&O&&O[A]&&(b=e.getStackIndicator(b,A,e.index),k.isNull||(M=O[A],P=M.points[b.key])),isArray$f(P)&&(T=P[0],E=P[1],T===g&&b.key===O[A].base&&(T=pick$1f(isNumber$A(u)&&u,l.min)),l.positiveValuesOnly&&T<=0&&(T=null),k.total=k.stackTotal=M.total,k.percentage=M.total&&k.y/M.total*100,k.stackY=E,e.irregularWidths||M.setOffset(e.pointXOffset||0,e.barW||0)),k.yBottom=defined$G(T)?S(l.translate(T,0,1,0,1)):null,d&&(E=e.modifyValue(E,k)),k.plotY=void 0,isNumber$A(E)){var C=l.translate(E,!1,!0,!1,!0);typeof C<"u"&&(k.plotY=S(C))}k.isInside=this.isPointInside(k),k.clientX=p?correctFloat$a(n.translate(A,0,0,0,1,f)):m,k.negative=k[v]<(t[v+"Threshold"]||u||0),k.category=s&&typeof s[k.x]<"u"?s[k.x]:k.x,!k.isNull&&k.visible!==!1&&(typeof x<"u"&&($=Math.min($,Math.abs(m-x))),x=m),k.zone=this.zones.length&&k.getZone(),!k.graphic&&e.group&&a&&(k.isNew=!0)}e.closestPointRangePx=$,fireEvent$r(this,"afterTranslate")},o.prototype.getValidPoints=function(e,t,r){var n=this.chart;return(e||this.points||[]).filter(function(s){return t&&!n.isInsidePlot(s.plotX,s.plotY,{inverted:n.inverted})?!1:s.visible!==!1&&(r||!s.isNull)})},o.prototype.getClipBox=function(e,t){var r=this,n=r.options,s=r.chart,a=s.inverted,l=r.xAxis,h=l&&r.yAxis,c=s.options.chart.scrollablePlotArea||{},d;return e&&n.clip===!1&&h?d=a?{y:-s.chartWidth+h.len+h.pos,height:s.chartWidth,width:s.chartHeight,x:-s.chartHeight+l.len+l.pos}:{y:-h.pos,height:s.chartHeight,width:s.chartWidth,x:-l.pos}:(d=r.clipBox||s.clipBox,t&&(d.width=s.plotSizeX,d.x=(s.scrollablePixelsX||0)*(c.scrollPositionX||0))),t?{width:d.width,x:d.x}:d},o.prototype.getSharedClipKey=function(e){if(this.sharedClipKey)return this.sharedClipKey;var t=[e&&e.duration,e&&e.easing,e&&e.defer,this.getClipBox(e).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||e)&&(this.sharedClipKey=t),t},o.prototype.setClip=function(e){var t=this.chart,r=this.options,n=t.renderer,s=t.inverted,a=this.clipBox,l=this.getClipBox(e),h=this.getSharedClipKey(e),c=t.sharedClips[h],d=t.sharedClips[h+"m"];e&&(l.width=0,s&&(l.x=t.plotHeight+(r.clip!==!1?0:t.plotTop))),c?t.hasLoaded||c.attr(l):(e&&(t.sharedClips[h+"m"]=d=n.clipRect(s?(t.plotSizeX||0)+99:-99,s?-t.plotLeft:-t.plotTop,99,s?t.chartWidth:t.chartHeight)),t.sharedClips[h]=c=n.clipRect(l),c.count={length:0}),e&&(c.count[this.index]||(c.count[this.index]=!0,c.count.length+=1)),(r.clip!==!1||e)&&(this.group.clip(e||a?c:t.clipRect),this.markerGroup.clip(d)),e||(c.count[this.index]&&(delete c.count[this.index],c.count.length-=1),c.count.length===0&&(a||(t.sharedClips[h]=c.destroy()),d&&(t.sharedClips[h+"m"]=d.destroy())))},o.prototype.animate=function(e){var t=this,r=t.chart,n=animObject$6(t.options.animation),s=this.sharedClipKey;if(e)t.setClip(n);else if(s){var a=r.sharedClips[s],l=r.sharedClips[s+"m"],h=t.getClipBox(n,!0);a&&a.animate(h,n),l&&l.animate({width:h.width+99,x:h.x-(r.inverted?0:99)},n)}},o.prototype.afterAnimate=function(){this.setClip(),fireEvent$r(this,"afterAnimate"),this.finishedAnimating=!0},o.prototype.drawPoints=function(){var e=this,t=e.points,r=e.chart,n=e.options,s=n.marker,a=e[e.specialGroup]||e.markerGroup,l=e.xAxis,h=pick$1f(s.enabled,!l||l.isRadial?!0:null,e.closestPointRangePx>=s.enabledThreshold*s.radius),c,d,f,p,u,g,v;if(s.enabled!==!1||e._hasPointMarkers)for(c=0;c<t.length;c++){d=t[c],f=d.graphic,p=f?"animate":"attr",u=d.marker||{},g=!!d.marker;var y=(h&&typeof u.enabled>"u"||u.enabled)&&!d.isNull&&d.visible!==!1;if(y){var m=pick$1f(u.symbol,e.symbol,"rect");v=e.markerAttribs(d,d.selected&&"select"),e.enabledDataSorting&&(d.startXPos=l.reversed?-(v.width||0):l.width);var x=d.isInside!==!1;f?f[x?"show":"hide"](x).animate(v):x&&((v.width||0)>0||d.hasImage)&&(d.graphic=f=r.renderer.symbol(m,v.x,v.y,v.width,v.height,g?u:s).add(a),e.enabledDataSorting&&r.hasRendered&&(f.attr({x:d.startXPos}),p="animate")),f&&p==="animate"&&f[x?"show":"hide"](x).animate(v),f&&!r.styledMode&&f[p](e.pointAttribs(d,d.selected&&"select")),f&&f.addClass(d.getClassName(),!0)}else f&&(d.graphic=f.destroy())}},o.prototype.markerAttribs=function(e,t){var r=this.options,n=r.marker,s=e.marker||{},a=s.symbol||n.symbol,l,h,c=pick$1f(s.radius,n.radius);t&&(l=n.states[t],h=s.states&&s.states[t],c=pick$1f(h&&h.radius,l&&l.radius,c+(l&&l.radiusPlus||0))),e.hasImage=a&&a.indexOf("url")===0,e.hasImage&&(c=0);var d={x:r.crisp?Math.floor(e.plotX-c):e.plotX-c,y:e.plotY-c};return c&&(d.width=d.height=2*c),d},o.prototype.pointAttribs=function(e,t){var r=this.options.marker,n=e&&e.options,s=n&&n.marker||{},a=n&&n.color,l=e&&e.color,h=e&&e.zone&&e.zone.color,c,d,f=this.color,p,u,g=pick$1f(s.lineWidth,r.lineWidth),v=1;return f=a||h||l||f,p=s.fillColor||r.fillColor||f,u=s.lineColor||r.lineColor||f,t=t||"normal",t&&(c=r.states[t],d=s.states&&s.states[t]||{},g=pick$1f(d.lineWidth,c.lineWidth,g+pick$1f(d.lineWidthPlus,c.lineWidthPlus,0)),p=d.fillColor||c.fillColor||p,u=d.lineColor||c.lineColor||u,v=pick$1f(d.opacity,c.opacity,v)),{stroke:u,"stroke-width":g,fill:p,opacity:v}},o.prototype.destroy=function(e){var t=this,r=t.chart,n=/AppleWebKit\/533/.test(win$7.navigator.userAgent),s=t.data||[],a,l,h,c;for(fireEvent$r(t,"destroy"),this.removeEvents(e),(t.axisTypes||[]).forEach(function(d){c=t[d],c&&c.series&&(erase$2(c.series,t),c.isDirty=c.forceRedraw=!0)}),t.legendItem&&t.chart.legend.destroyItem(t),l=s.length;l--;)h=s[l],h&&h.destroy&&h.destroy();t.clips&&t.clips.forEach(function(d){return d.destroy()}),Utilities.clearTimeout(t.animationTimeout),objectEach$m(t,function(d,f){d instanceof SVGElement&&!d.survive&&(a=n&&f==="group"?"hide":"destroy",d[a]())}),r.hoverSeries===t&&(r.hoverSeries=void 0),erase$2(r.series,t),r.orderSeries(),objectEach$m(t,function(d,f){(!e||f!=="hcEvents")&&delete t[f]})},o.prototype.applyZones=function(){var e=this,t=this.chart,r=t.renderer,n=this.zones,s=this.clips||[],a=this.graph,l=this.area,h=Math.max(t.chartWidth,t.chartHeight),c=this[(this.zoneAxis||"y")+"Axis"],d=t.inverted,f,p,u,g,v,y,m,x,b,$,S,k=!1;n.length&&(a||l)&&c&&typeof c.min<"u"?(v=c.reversed,y=c.horiz,a&&!this.showLine&&a.hide(),l&&l.hide(),g=c.getExtremes(),n.forEach(function(A,M){f=v?y?t.plotWidth:0:y?0:c.toPixels(g.min)||0,f=clamp$e(pick$1f(p,f),0,h),p=clamp$e(Math.round(c.toPixels(pick$1f(A.value,g.max),!0)||0),0,h),k&&(f=p=c.toPixels(g.max)),m=Math.abs(f-p),x=Math.min(f,p),b=Math.max(f,p),c.isXAxis?(u={x:d?b:x,y:0,width:m,height:h},y||(u.x=t.plotHeight-u.x)):(u={x:0,y:d?b:x,width:h,height:m},y&&(u.y=t.plotWidth-u.y)),d&&r.isVML&&(c.isXAxis?u={x:0,y:v?x:b,height:u.width,width:t.chartWidth}:u={x:u.y-t.plotLeft-t.spacingBox.x,y:0,width:u.height,height:t.chartHeight}),s[M]?s[M].animate(u):s[M]=r.clipRect(u),$=e["zone-area-"+M],S=e["zone-graph-"+M],a&&S&&S.clip(s[M]),l&&$&&$.clip(s[M]),k=A.value>g.max,e.resetZones&&p===0&&(p=void 0)}),this.clips=s):e.visible&&(a&&a.show(!0),l&&l.show(!0))},o.prototype.invertGroups=function(e){var t=this,r=t.chart;function n(){["group","markerGroup"].forEach(function(s){t[s]&&(r.renderer.isVML&&t[s].attr({width:t.yAxis.len,height:t.xAxis.len}),t[s].width=t.yAxis.len,t[s].height=t.xAxis.len,t[s].invert(t.isRadialSeries?!1:e))})}t.xAxis&&(t.eventsToUnbind.push(addEvent$S(r,"resize",n)),n(),t.invertGroups=n)},o.prototype.plotGroup=function(e,t,r,n,s){var a=this[e],l=!a,h={visibility:r,zIndex:n||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(h.opacity=this.opacity),l&&(this[e]=a=this.chart.renderer.g().add(s)),a.addClass("highcharts-"+t+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$G(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(a.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),a.attr(h)[l?"attr":"animate"](this.getPlotBox()),a},o.prototype.getPlotBox=function(){var e=this.chart,t=this.xAxis,r=this.yAxis;return e.inverted&&(t=r,r=this.xAxis),{translateX:t?t.left:e.plotLeft,translateY:r?r.top:e.plotTop,scaleX:1,scaleY:1}},o.prototype.removeEvents=function(e){var t=this;e||removeEvent$5(t),t.eventsToUnbind.length&&(t.eventsToUnbind.forEach(function(r){r()}),t.eventsToUnbind.length=0)},o.prototype.render=function(){var e=this,t=e.chart,r=e.options,n=animObject$6(r.animation),s=e.visible?"inherit":"hidden",a=r.zIndex,l=e.hasRendered,h=t.seriesGroup,c=t.inverted,d=!e.finishedAnimating&&t.renderer.isSVG&&n.duration;fireEvent$r(this,"render");var f=e.plotGroup("group","series",s,a,h);e.markerGroup=e.plotGroup("markerGroup","markers",s,a,h),d&&e.animate&&e.animate(!0),f.inverted=pick$1f(e.invertible,e.isCartesian)?c:!1,e.drawGraph&&(e.drawGraph(),e.applyZones()),e.visible&&e.drawPoints(),e.drawDataLabels&&e.drawDataLabels(),e.redrawPoints&&e.redrawPoints(),e.drawTracker&&e.options.enableMouseTracking!==!1&&e.drawTracker(),e.invertGroups(c),r.clip!==!1&&!e.sharedClipKey&&!l&&f.clip(t.clipRect),d&&e.animate&&e.animate(),l||(d&&n.defer&&(d+=n.defer),e.animationTimeout=syncTimeout$2(function(){e.afterAnimate()},d||0)),e.isDirty=!1,e.hasRendered=!0,fireEvent$r(e,"afterRender")},o.prototype.redraw=function(){var e=this,t=e.chart,r=e.isDirty||e.isDirtyData,n=e.group,s=e.xAxis,a=e.yAxis;n&&(t.inverted&&n.attr({width:t.plotWidth,height:t.plotHeight}),n.animate({translateX:pick$1f(s&&s.left,t.plotLeft),translateY:pick$1f(a&&a.top,t.plotTop)})),e.translate(),e.render(),r&&delete this.kdTree},o.prototype.searchPoint=function(e,t){var r=this,n=r.xAxis,s=r.yAxis,a=r.chart.inverted;return this.searchKDTree({clientX:a?n.len-e.chartY+n.pos:e.chartX-n.pos,plotY:a?s.len-e.chartX+s.pos:e.chartY-s.pos},t,e)},o.prototype.buildKDTree=function(e){this.buildingKdTree=!0;var t=this,r=t.options.findNearestPointBy.indexOf("y")>-1?2:1;function n(a,l,h){var c=a&&a.length,d,f;if(c)return d=t.kdAxisArray[l%h],a.sort(function(p,u){return p[d]-u[d]}),f=Math.floor(c/2),{point:a[f],left:n(a.slice(0,f),l+1,h),right:n(a.slice(f+1),l+1,h)}}function s(){t.kdTree=n(t.getValidPoints(null,!t.directTouch),r,r),t.buildingKdTree=!1}delete t.kdTree,syncTimeout$2(s,t.options.kdNow||e&&e.type==="touchstart"?0:1)},o.prototype.searchKDTree=function(e,t,r){var n=this,s=this.kdAxisArray[0],a=this.kdAxisArray[1],l=t?"distX":"dist",h=n.options.findNearestPointBy.indexOf("y")>-1?2:1;function c(f,p){var u=defined$G(f[s])&&defined$G(p[s])?Math.pow(f[s]-p[s],2):null,g=defined$G(f[a])&&defined$G(p[a])?Math.pow(f[a]-p[a],2):null,v=(u||0)+(g||0);p.dist=defined$G(v)?Math.sqrt(v):Number.MAX_VALUE,p.distX=defined$G(u)?Math.sqrt(u):Number.MAX_VALUE}function d(f,p,u,g){var v=p.point,y=n.kdAxisArray[u%g],m,x,b=v;c(f,v);var $=f[y]-v[y],S=$<0?"left":"right",k=$<0?"right":"left";return p[S]&&(m=d(f,p[S],u+1,g),b=m[l]<b[l]?m:v),p[k]&&Math.sqrt($*$)<b[l]&&(x=d(f,p[k],u+1,g),b=x[l]<b[l]?x:b),b}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(r),this.kdTree)return d(e,this.kdTree,h,h)},o.prototype.pointPlacementToXValue=function(){var e=this,t=e.options,r=t.pointPlacement,n=t.pointRange,s=e.xAxis,a=r;return a==="between"&&(a=s.reversed?-.5:.5),isNumber$A(a)?a*(n||s.pointRange):0},o.prototype.isPointInside=function(e){var t=typeof e.plotY<"u"&&typeof e.plotX<"u"&&e.plotY>=0&&e.plotY<=this.yAxis.len&&e.plotX>=0&&e.plotX<=this.xAxis.len;return t},o.prototype.drawTracker=function(){var e=this,t=e.options,r=t.trackByArea,n=[].concat(r?e.areaPath:e.graphPath),s=e.chart,a=s.pointer,l=s.renderer,h=s.options.tooltip.snap,c=e.tracker,d=function(p){s.hoverSeries!==e&&e.onMouseOver()},f="rgba(192,192,192,"+(svg$2?1e-4:.002)+")";c?c.attr({d:n}):e.graph&&(e.tracker=l.path(n).attr({visibility:e.visible?"visible":"hidden",zIndex:2}).addClass(r?"highcharts-tracker-area":"highcharts-tracker-line").add(e.group),s.styledMode||e.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:f,fill:r?f:"none","stroke-width":e.graph.strokeWidth()+(r?0:2*h)}),[e.tracker,e.markerGroup,e.dataLabelsGroup].forEach(function(p){p&&(p.addClass("highcharts-tracker").on("mouseover",d).on("mouseout",function(u){a.onTrackerMouseOut(u)}),t.cursor&&!s.styledMode&&p.css({cursor:t.cursor}),hasTouch$2&&p.on("touchstart",d))})),fireEvent$r(this,"afterDrawTracker")},o.prototype.addPoint=function(e,t,r,n,s){var a=this,l=a.options,h=a.data,c=a.chart,d=a.xAxis,f=d&&d.hasNames&&d.names,p=l.data,u=a.xData,g,v;t=pick$1f(t,!0);var y={series:a};a.pointClass.prototype.applyOptions.apply(y,[e]);var m=y.x;if(v=u.length,a.requireSorting&&m<u[v-1])for(g=!0;v&&u[v-1]>m;)v--;a.updateParallelArrays(y,"splice",v,0,0),a.updateParallelArrays(y,v),f&&y.name&&(f[m]=y.name),p.splice(v,0,e),g&&(a.data.splice(v,0,null),a.processData()),l.legendType==="point"&&a.generatePoints(),r&&(h[0]&&h[0].remove?h[0].remove(!1):(h.shift(),a.updateParallelArrays(y,"shift"),p.shift())),s!==!1&&fireEvent$r(a,"addPoint",{point:y}),a.isDirty=!0,a.isDirtyData=!0,t&&c.redraw(n)},o.prototype.removePoint=function(e,t,r){var n=this,s=n.data,a=s[e],l=n.points,h=n.chart,c=function(){l&&l.length===s.length&&l.splice(e,1),s.splice(e,1),n.options.data.splice(e,1),n.updateParallelArrays(a||{series:n},"splice",e,1),a&&a.destroy(),n.isDirty=!0,n.isDirtyData=!0,t&&h.redraw()};setAnimation$2(r,h),t=pick$1f(t,!0),a?a.firePointEvent("remove",null,c):c()},o.prototype.remove=function(e,t,r,n){var s=this,a=s.chart;function l(){s.destroy(n),a.isDirtyLegend=a.isDirtyBox=!0,a.linkSeries(),pick$1f(e,!0)&&a.redraw(t)}r!==!1?fireEvent$r(s,"remove",null,l):l()},o.prototype.update=function(e,t){e=cleanRecursively(e,this.userOptions),fireEvent$r(this,"update",{options:e});var r=this,n=r.chart,s=r.userOptions,a=r.initialType||r.type,l=n.options.plotOptions,h=seriesTypes$6[a].prototype,c=["group","markerGroup","dataLabelsGroup","transformGroup"],d=r.finishedAnimating&&{animation:!1},f={},p,u,g=["eventOptions","navigatorSeries","baseSeries"],v=e.type||s.type||n.options.chart.type,y=!(this.hasDerivedData||v&&v!==this.type||typeof e.pointStart<"u"||typeof e.pointInterval<"u"||typeof e.relativeXValue<"u"||r.hasOptionChanged("dataGrouping")||r.hasOptionChanged("pointStart")||r.hasOptionChanged("pointInterval")||r.hasOptionChanged("pointIntervalUnit")||r.hasOptionChanged("keys"));v=v||a,y&&(g.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),e.visible!==!1&&g.push("area","graph"),r.parallelArrays.forEach(function(S){g.push(S+"Data")}),e.data&&(e.dataSorting&&extend$1c(r.options.dataSorting,e.dataSorting),this.setData(e.data,!1))),e=merge$18(s,d,{index:typeof s.index>"u"?r.index:s.index,pointStart:pick$1f(l&&l.series&&l.series.pointStart,s.pointStart,r.xData[0])},!y&&{data:r.options.data},e),y&&e.data&&(e.data=r.options.data),g=c.concat(g),g.forEach(function(S){g[S]=r[S],delete r[S]});var m=!1;if(seriesTypes$6[v]){if(m=v!==r.type,r.remove(!1,!1,!1,!0),m)if(Object.setPrototypeOf)Object.setPrototypeOf(r,seriesTypes$6[v].prototype);else{var x=Object.hasOwnProperty.call(r,"hcEvents")&&r.hcEvents;for(u in h)r[u]=void 0;extend$1c(r,seriesTypes$6[v].prototype),x?r.hcEvents=x:delete r.hcEvents}}else error$4(17,!0,n,{missingModuleFor:v});if(g.forEach(function(S){r[S]=g[S]}),r.init(n,e),y&&this.points){if(p=r.options,p.visible===!1)f.graphic=1,f.dataLabel=1;else if(!r._hasPointLabels){var b=p.marker,$=p.dataLabels;b&&(b.enabled===!1||(s.marker&&s.marker.symbol)!==b.symbol)&&(f.graphic=1),$&&$.enabled===!1&&(f.dataLabel=1)}this.points.forEach(function(S){S&&S.series&&(S.resolveColor(),Object.keys(f).length&&S.destroyElements(f),p.showInLegend===!1&&S.legendItem&&n.legend.destroyItem(S))},this)}r.initialType=a,n.linkSeries(),m&&r.linkedSeries.length&&(r.isDirtyData=!0),fireEvent$r(this,"afterUpdate"),pick$1f(t,!0)&&n.redraw(y?void 0:!1)},o.prototype.setName=function(e){this.name=this.options.name=this.userOptions.name=e,this.chart.isDirtyLegend=!0},o.prototype.hasOptionChanged=function(e){var t=this.chart,r=this.options[e],n=t.options.plotOptions,s=this.userOptions[e];return s?r!==s:r!==pick$1f(n&&n[this.type]&&n[this.type][e],n&&n.series&&n.series[e],r)},o.prototype.onMouseOver=function(){var e=this,t=e.chart,r=t.hoverSeries,n=t.pointer;n.setHoverChartIndex(),r&&r!==e&&r.onMouseOut(),e.options.events.mouseOver&&fireEvent$r(e,"mouseOver"),e.setState("hover"),t.hoverSeries=e},o.prototype.onMouseOut=function(){var e=this,t=e.options,r=e.chart,n=r.tooltip,s=r.hoverPoint;r.hoverSeries=null,s&&s.onMouseOut(),e&&t.events.mouseOut&&fireEvent$r(e,"mouseOut"),n&&!e.stickyTracking&&(!n.shared||e.noSharedTooltip)&&n.hide(),r.series.forEach(function(a){a.setState("",!0)})},o.prototype.setState=function(e,t){var r=this,n=r.options,s=r.graph,a=n.inactiveOtherPoints,l=n.states,h=pick$1f(l[e||"normal"]&&l[e||"normal"].animation,r.chart.options.chart.animation),c,d=n.lineWidth,f=0,p=n.opacity;if(e=e||"",r.state!==e&&([r.group,r.markerGroup,r.dataLabelsGroup].forEach(function(u){u&&(r.state&&u.removeClass("highcharts-series-"+r.state),e&&u.addClass("highcharts-series-"+e))}),r.state=e,!r.chart.styledMode)){if(l[e]&&l[e].enabled===!1)return;if(e&&(d=l[e].lineWidth||d+(l[e].lineWidthPlus||0),p=pick$1f(l[e].opacity,p)),s&&!s.dashstyle)for(c={"stroke-width":d},s.animate(c,h);r["zone-graph-"+f];)r["zone-graph-"+f].animate(c,h),f=f+1;a||[r.group,r.markerGroup,r.dataLabelsGroup,r.labelBySeries].forEach(function(u){u&&u.animate({opacity:p},h)})}t&&a&&r.points&&r.setAllPointsToState(e||void 0)},o.prototype.setAllPointsToState=function(e){this.points.forEach(function(t){t.setState&&t.setState(e)})},o.prototype.setVisible=function(e,t){var r=this,n=r.chart,s=r.legendItem,a=n.options.chart.ignoreHiddenSeries,l=r.visible;r.visible=e=r.options.visible=r.userOptions.visible=typeof e>"u"?!l:e;var h=e?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(c){r[c]&&r[c][h]()}),(n.hoverSeries===r||(n.hoverPoint&&n.hoverPoint.series)===r)&&r.onMouseOut(),s&&n.legend.colorizeItem(r,e),r.isDirty=!0,r.options.stacking&&n.series.forEach(function(c){c.options.stacking&&c.visible&&(c.isDirty=!0)}),r.linkedSeries.forEach(function(c){c.setVisible(e,!1)}),a&&(n.isDirtyBox=!0),fireEvent$r(r,h),t!==!1&&n.redraw()},o.prototype.show=function(){this.setVisible(!0)},o.prototype.hide=function(){this.setVisible(!1)},o.prototype.select=function(e){var t=this;t.selected=e=this.options.selected=typeof e>"u"?!t.selected:e,t.checkbox&&(t.checkbox.checked=e),fireEvent$r(t,e?"select":"unselect")},o.prototype.shouldShowTooltip=function(e,t,r){return r===void 0&&(r={}),r.series=this,r.visiblePlotOnly=!0,this.chart.isInsidePlot(e,t,r)},o.defaultOptions=seriesDefaults,o}();extend$1c(Series$e.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$2,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$e;var stop=animationExports.stop,addEvent$R=Utilities.addEvent,createElement$4=Utilities.createElement,merge$17=Utilities.merge,pick$1e=Utilities.pick;addEvent$R(Chart$1,"afterSetChartSize",function(o){var e=this.options.chart.scrollablePlotArea,t=e&&e.minWidth,r=e&&e.minHeight,n,s,a;this.renderer.forExport||(t?(this.scrollablePixelsX=n=Math.max(0,t-this.chartWidth),n&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.width=this.plotWidth+=n,this.inverted?this.clipBox.height+=n:this.clipBox.width+=n,a={1:{name:"right",value:n}})):r&&(this.scrollablePixelsY=s=Math.max(0,r-this.chartHeight),s&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.height=this.plotHeight+=s,this.inverted?this.clipBox.width+=s:this.clipBox.height+=s,a={2:{name:"bottom",value:s}})),a&&!o.skipAxes&&this.axes.forEach(function(l){a[l.side]?l.getPlotLinePath=function(){var h=a[l.side].name,c=a[l.side].value,d=this[h],f;return this[h]=d-c,f=Axis.prototype.getPlotLinePath.apply(this,arguments),this[h]=d,f}:(l.setAxisSize(),l.setAxisTranslation())}))});addEvent$R(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var o=this,e={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(e.overflowX="auto"),this.scrollablePixelsY&&(e.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},e,this.scrollingParent),addEvent$R(this.scrollingContainer,"scroll",function(){o.pointer&&delete o.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var o=this.container,e=this.fixedRenderer,t=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],r;this.scrollablePixelsX&&!this.inverted?r=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?r=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(r=".highcharts-yaxis"),r&&t.push(r+":not(.highcharts-radial-axis)",r+"-labels:not(.highcharts-radial-axis-labels)"),t.forEach(function(n){[].forEach.call(o.querySelectorAll(n),function(s){(s.namespaceURI===e.SVG_NS?e.box:e.box.parentNode).appendChild(s),s.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var o=!this.fixedDiv,e=this.options.chart,t=e.scrollablePlotArea,r=RendererRegistry$1.getRendererType(),n,s,a;o?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(e.style&&e.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=n=new r(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=n.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1e(t.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$R(this,"afterShowResetZoom",this.moveFixedElements),addEvent$R(this,"afterDrilldown",this.moveFixedElements),addEvent$R(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||o)&&(this.scrollableDirty=!1,this.moveFixedElements()),s=this.chartWidth+(this.scrollablePixelsX||0),a=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=s+"px",this.container.style.height=a+"px",this.renderer.boxWrapper.attr({width:s,height:a,viewBox:[0,0,s,a].join(" ")}),this.chartBackground.attr({width:s,height:a}),this.scrollingContainer.style.height=this.chartHeight+"px",o&&(t.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*t.scrollPositionX),t.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*t.scrollPositionY));var l=this.axisOffset,h=this.plotTop-l[0]-1,c=this.plotLeft-l[3]-1,d=this.plotTop+this.plotHeight+l[2]+1,f=this.plotLeft+this.plotWidth+l[1]+1,p=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),u=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),g;this.scrollablePixelsX?g=[["M",0,h],["L",this.plotLeft-1,h],["L",this.plotLeft-1,d],["L",0,d],["Z"],["M",p,h],["L",this.chartWidth,h],["L",this.chartWidth,d],["L",p,d],["Z"]]:this.scrollablePixelsY?g=[["M",c,0],["L",c,this.plotTop-1],["L",f,this.plotTop-1],["L",f,0],["Z"],["M",c,u],["L",c,this.chartHeight],["L",f,this.chartHeight],["L",f,u],["Z"]]:g=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:g})};addEvent$R(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$R(Series$e,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$Q=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$q=Utilities.fireEvent,isNumber$z=Utilities.isNumber,objectEach$l=Utilities.objectEach,StackingAxis;(function(o){var e=[];function t(a){return e.indexOf(a)===-1&&(e.push(a),addEvent$Q(a,"init",n),addEvent$Q(a,"destroy",r)),a}o.compose=t;function r(){var a=this.stacking;if(a){var l=a.stacks;objectEach$l(l,function(h,c){destroyObjectProperties$5(h),l[c]=null}),a&&a.stackTotalGroup&&a.stackTotalGroup.destroy()}}function n(){var a=this;a.stacking||(a.stacking=new s(a))}var s=function(){function a(l){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=l}return a.prototype.buildStacks=function(){var l=this,h=l.axis,c=h.series,d=h.options.reversedStacks,f=c.length,p,u;if(!h.isXAxis){for(l.usePercentage=!1,u=f;u--;)p=c[d?u:f-u-1],p.setStackedPoints(),p.setGroupedPoints();for(u=0;u<f;u++)c[u].modifyStacks();fireEvent$q(h,"afterBuildStacks")}},a.prototype.cleanStacks=function(){var l=this,h=l.axis,c;h.isXAxis||(l.oldStacks&&(c=l.stacks=l.oldStacks),objectEach$l(c,function(d){objectEach$l(d,function(f){f.cumulative=f.total})}))},a.prototype.resetStacks=function(){var l=this,h=l.axis,c=l.stacks;h.isXAxis||objectEach$l(c,function(d){objectEach$l(d,function(f,p){isNumber$z(f.touched)&&f.touched<l.stacksTouched?(f.destroy(),delete d[p]):(f.total=null,f.cumulative=null)})})},a.prototype.renderStackTotals=function(){var l=this,h=l.axis,c=h.chart,d=c.renderer,f=l.stacks,p=h.options.stackLabels&&h.options.stackLabels.animation,u=getDeferredAnimation$2(c,p||!1),g=l.stackTotalGroup=l.stackTotalGroup||d.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();g.translate(c.plotLeft,c.plotTop),objectEach$l(f,function(v){objectEach$l(v,function(y){y.render(g)})}),g.animate({opacity:1},u)},a}();o.Additions=s})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$9=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$F=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$e=Utilities.isArray,isNumber$y=Utilities.isNumber,objectEach$k=Utilities.objectEach,pick$1d=Utilities.pick,StackItem=function(){function o(e,t,r,n,s){var a=e.chart.inverted;this.axis=e,this.isNegative=r,this.options=t=t||{},this.x=n,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=s,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:t.align||(a?r?"left":"right":"center"),verticalAlign:t.verticalAlign||(a?"middle":r?"bottom":"top"),y:t.y,x:t.x},this.textAlign=t.textAlign||(a?r?"right":"left":"center")}return o.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},o.prototype.render=function(e){var t=this.axis.chart,r=this.options,n=r.format,s={},a=n?format$9(n,this,t):r.formatter.call(this);this.label?this.label.attr({text:a,visibility:"hidden"}):(this.label=t.renderer.label(a,null,null,r.shape,null,null,r.useHTML,!1,"stack-labels"),s={r:r.borderRadius||0,text:a,rotation:r.rotation,padding:pick$1d(r.padding,5),visibility:"hidden"},t.styledMode||(s.fill=r.backgroundColor,s.stroke=r.borderColor,s["stroke-width"]=r.borderWidth,this.label.css(r.style)),this.label.attr(s),this.label.added||this.label.add(e)),this.label.labelrank=t.plotSizeY},o.prototype.setOffset=function(e,t,r,n,s){var a=this,l=a.axis,h=l.chart,c=l.translate(l.stacking.usePercentage?100:n||a.total,0,0,0,1),d=l.translate(r||0),f=defined$F(c)&&Math.abs(c-d),p=pick$1d(s,h.xAxis[0].translate(a.x))+e,u=defined$F(c)&&a.getStackBox(h,a,p,c,t,f,l),g=a.label,v=a.isNegative,y=pick$1d(a.options.overflow,"justify")==="justify",m=a.textAlign,x;if(g&&u){var b=g.getBBox(),$=g.padding,S=void 0,k=void 0;m==="left"?S=h.inverted?-$:$:m==="right"?S=b.width:h.inverted&&m==="center"?S=b.width/2:S=h.inverted?v?b.width+$:-$:b.width/2,k=h.inverted?b.height/2:v?-$:b.height,a.alignOptions.x=pick$1d(a.options.x,0),a.alignOptions.y=pick$1d(a.options.y,0),u.x-=S,u.y-=k,g.align(a.alignOptions,null,u),h.isInsidePlot(g.alignAttr.x+S-a.alignOptions.x,g.alignAttr.y+k-a.alignOptions.y)?g.show():(g.alignAttr.y=-9999,y=!1),y&&Series$e.prototype.justifyDataLabel.call(this.axis,g,a.alignOptions,g.alignAttr,b,u),g.attr({x:g.alignAttr.x,y:g.alignAttr.y}),pick$1d(!y&&a.options.crop,!0)&&(x=isNumber$y(g.x)&&isNumber$y(g.y)&&h.isInsidePlot(g.x-$+g.width,g.y)&&h.isInsidePlot(g.x+$,g.y),x||g.hide())}},o.prototype.getStackBox=function(e,t,r,n,s,a,l){var h=t.axis.reversed,c=e.inverted,d=l.height+l.pos-(c?e.plotLeft:e.plotTop),f=t.isNegative&&!h||!t.isNegative&&h;return{x:c?f?n-l.right:n-a+l.pos-e.plotLeft:r+e.xAxis[0].transB-e.plotLeft,y:c?l.height-r-s:f?d-n-a:d-n,width:c?a:s,height:c?s:a}},o}();Chart$1.prototype.getStacks=function(){var o=this,e=o.inverted;o.yAxis.forEach(function(t){t.stacking&&t.stacking.stacks&&t.hasVisibleSeries&&(t.stacking.oldStacks=t.stacking.stacks)}),o.series.forEach(function(t){var r=t.xAxis&&t.xAxis.options||{};t.options.stacking&&(t.visible===!0||o.options.chart.ignoreHiddenSeries===!1)&&(t.stackKey=[t.type,pick$1d(t.options.stack,""),e?r.top:r.left,e?r.height:r.width].join(","))})};StackingAxis$1.compose(Axis);Series$e.prototype.setGroupedPoints=function(){var o=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$e.prototype.setStackedPoints.call(this,"group"):o&&objectEach$k(o.stacks,function(e,t){t.slice(-5)==="group"&&(objectEach$k(e,function(r){return r.destroy()}),delete o.stacks[t])})};Series$e.prototype.setStackedPoints=function(o){var e=o||this.options.stacking;if(!(!e||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var t=this,r=t.processedXData,n=t.processedYData,s=[],a=n.length,l=t.options,h=l.threshold,c=pick$1d(l.startFromThreshold&&h,0),d=l.stack,f=o?t.type+","+e:t.stackKey,p="-"+f,u=t.negStacks,g=t.yAxis,v=g.stacking.stacks,y=g.stacking.oldStacks,m,x,b,$,S,k,A,M,P;for(g.stacking.stacksTouched+=1,A=0;A<a;A++)M=r[A],P=n[A],m=t.getStackIndicator(m,M,t.index),k=m.key,x=u&&P<(c?0:h),S=x?p:f,v[S]||(v[S]={}),v[S][M]||(y[S]&&y[S][M]?(v[S][M]=y[S][M],v[S][M].total=null):v[S][M]=new StackItem(g,g.options.stackLabels,x,M,d)),b=v[S][M],P!==null?(b.points[k]=b.points[t.index]=[pick$1d(b.cumulative,c)],defined$F(b.cumulative)||(b.base=k),b.touched=g.stacking.stacksTouched,m.index>0&&t.singleStacks===!1&&(b.points[k][0]=b.points[t.index+","+M+",0"][0])):b.points[k]=b.points[t.index]=null,e==="percent"?($=x?f:p,u&&v[$]&&v[$][M]?($=v[$][M],b.total=$.total=Math.max($.total,b.total)+Math.abs(P)||0):b.total=correctFloat$9(b.total+(Math.abs(P)||0))):e==="group"?(isArray$e(P)&&(P=P[0]),P!==null&&(b.total=(b.total||0)+1)):b.total=correctFloat$9(b.total+(P||0)),e==="group"?b.cumulative=(b.total||1)-1:b.cumulative=pick$1d(b.cumulative,c)+(P||0),P!==null&&(b.points[k].push(b.cumulative),s[A]=b.cumulative,b.hasValidPoints=!0);e==="percent"&&(g.stacking.usePercentage=!0),e!=="group"&&(this.stackedYData=s),g.stacking.oldStacks={}}};Series$e.prototype.modifyStacks=function(){var o=this,e=o.yAxis,t=o.stackKey,r=e.stacking.stacks,n=o.processedXData,s,a=o.options.stacking;o[a+"Stacker"]&&[t,"-"+t].forEach(function(l){for(var h=n.length,c,d,f;h--;)c=n[h],s=o.getStackIndicator(s,c,o.index,l),d=r[l]&&r[l][c],f=d&&d.points[s.key],f&&o[a+"Stacker"](f,d,h)})};Series$e.prototype.percentStacker=function(o,e,t){var r=e.total?100/e.total:0;o[0]=correctFloat$9(o[0]*r),o[1]=correctFloat$9(o[1]*r),this.stackedYData[t]=o[1]};Series$e.prototype.getStackIndicator=function(o,e,t,r){return!defined$F(o)||o.x!==e||r&&o.key!==r?o={x:e,index:0,key:r}:o.index++,o.key=[t,e,o.index].join(","),o};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$U=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$E=Utilities.defined,merge$16=Utilities.merge,LineSeries$5=function(o){__extends$U(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.drawGraph=function(){var t=this,r=this.options,n=(this.gappedPath||this.getGraphPath).call(this),s=this.chart.styledMode,a=[["graph","highcharts-graph"]];s||a[0].push(r.lineColor||this.color||palette.neutralColor20,r.dashStyle),a=t.getZonesGraphs(a),a.forEach(function(l,h){var c=l[0],d,f=t[c],p=f?"animate":"attr";f?(f.endX=t.preventGraphAnimation?null:n.xMap,f.animate({d:n})):n.length&&(t[c]=f=t.chart.renderer.path(n).addClass(l[1]).attr({zIndex:1}).add(t.group)),f&&!s&&(d={stroke:l[2],"stroke-width":r.lineWidth,fill:t.fillGraph&&t.color||"none"},l[3]?d.dashstyle=l[3]:r.linecap!=="square"&&(d["stroke-linecap"]=d["stroke-linejoin"]="round"),f[p](d).shadow(h<2&&r.shadow)),f&&(f.startX=n.xMap,f.isArea=n.isArea)})},e.prototype.getGraphPath=function(t,r,n){var s=this,a=s.options,l=[],h=[],c,d=a.step;t=t||s.points;var f=t.reversed;return f&&t.reverse(),d={right:1,center:2}[d]||d&&3,d&&f&&(d=4-d),t=this.getValidPoints(t,!1,!(a.connectNulls&&!r&&!n)),t.forEach(function(p,u){var g=p.plotX,v=p.plotY,y=t[u-1],m;(p.leftCliff||y&&y.rightCliff)&&!n&&(c=!0),p.isNull&&!defined$E(r)&&u>0?c=!a.connectNulls:p.isNull&&!r?c=!0:(u===0||c?m=[["M",p.plotX,p.plotY]]:s.getPointSpline?m=[s.getPointSpline(t,p,u)]:d?(d===1?m=[["L",y.plotX,v]]:d===2?m=[["L",(y.plotX+g)/2,y.plotY],["L",(y.plotX+g)/2,v]]:m=[["L",g,y.plotY]],m.push(["L",g,v])):m=[["L",g,v]],h.push(p.x),d&&(h.push(p.x),d===2&&h.push(p.x)),l.push.apply(l,m),c=!1)}),l.xMap=h,s.graphPath=l,l},e.prototype.getZonesGraphs=function(t){return this.zones.forEach(function(r,n){var s=["zone-graph-"+n,"highcharts-graph highcharts-zone-graph-"+n+" "+(r.className||"")];this.chart.styledMode||s.push(r.color||this.color,r.dashStyle||this.options.dashStyle),t.push(s)},this),t},e.defaultOptions=merge$16(Series$e.defaultOptions,{}),e}(Series$e);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$T=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1b=Utilities.extend,merge$15=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1c=Utilities.pick,AreaSeries$1=function(o){__extends$T(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.drawGraph=function(){this.areaPath=[],o.prototype.drawGraph.apply(this);var t=this,r=this.areaPath,n=this.options,s=this.zones,a=[["area","highcharts-area",this.color,n.fillColor]];s.forEach(function(l,h){a.push(["zone-area-"+h,"highcharts-area highcharts-zone-area-"+h+" "+l.className,l.color||t.color,l.fillColor||n.fillColor])}),a.forEach(function(l){var h=l[0],c=t[h],d=c?"animate":"attr",f={};c?(c.endX=t.preventGraphAnimation?null:r.xMap,c.animate({d:r})):(f.zIndex=0,c=t[h]=t.chart.renderer.path(r).addClass(l[1]).add(t.group),c.isArea=!0),t.chart.styledMode||(f.fill=pick$1c(l[3],color$d(l[2]).setOpacity(pick$1c(n.fillOpacity,.75)).get())),c[d](f),c.startX=r.xMap,c.shiftUnit=n.step?2:1})},e.prototype.getGraphPath=function(t){var r=LineSeries$4.prototype.getGraphPath,n,s=this.options,a=s.stacking,l=this.yAxis,h,c,d=[],f=[],p=this.index,u,g,v,y=l.stacking.stacks[this.stackKey],m=s.threshold,x=Math.round(l.getThreshold(s.threshold)),b,$,S=pick$1c(s.connectNulls,a==="percent"),k=function(M,P,E){var T=t[M],O=a&&y[T.x].points[p],C=T[E+"Null"]||0,I=T[E+"Cliff"]||0,L,D,N=!0;I||C?(L=(C?O[0]:O[1])+I,D=O[0]+I,N=!!C):!a&&t[P]&&t[P].isNull&&(L=D=m),typeof L<"u"&&(f.push({plotX:v,plotY:L===null?x:l.getThreshold(L),isNull:N,isCliff:!0}),d.push({plotX:v,plotY:D===null?x:l.getThreshold(D),doCurve:!1}))};for(t=t||this.points,a&&(t=this.getStackPoints(t)),u=0;u<t.length;u++)a||(t[u].leftCliff=t[u].rightCliff=t[u].leftNull=t[u].rightNull=void 0),b=t[u].isNull,v=pick$1c(t[u].rectPlotX,t[u].plotX),$=a?pick$1c(t[u].yBottom,x):x,(!b||S)&&(S||k(u,u-1,"left"),b&&!a&&S||(f.push(t[u]),d.push({x:u,plotX:v,plotY:$})),S||k(u,u+1,"right"));h=r.call(this,f,!0,!0),d.reversed=!0,c=r.call(this,d,!0,!0);var A=c[0];return A&&A[0]==="M"&&(c[0]=["L",A[1],A[2]]),g=h.concat(c),g.length&&g.push(["Z"]),n=r.call(this,f,!1,S),g.xMap=h.xMap,this.areaPath=g,n},e.prototype.getStackPoints=function(t){var r=this,n=[],s=[],a=this.xAxis,l=this.yAxis,h=l.stacking.stacks[this.stackKey],c={},d=l.series,f=d.length,p=l.options.reversedStacks?1:-1,u=d.indexOf(r);if(t=t||this.points,this.options.stacking){for(var g=0;g<t.length;g++)t[g].leftNull=t[g].rightNull=void 0,c[t[g].x]=t[g];objectEach$j(h,function(y,m){y.total!==null&&s.push(m)}),s.sort(function(y,m){return y-m});var v=d.map(function(y){return y.visible});s.forEach(function(y,m){var x=0,b,$;if(c[y]&&!c[y].isNull)n.push(c[y]),[-1,1].forEach(function(A){var M=A===1?"rightNull":"leftNull",P=A===1?"rightCliff":"leftCliff",E=0,T=h[s[m+A]];if(T)for(var O=u;O>=0&&O<f;){var C=d[O].index;b=T.points[C],b||(C===r.index?c[y][M]=!0:v[O]&&($=h[y].points[C],$&&(E-=$[1]-$[0]))),O+=p}c[y][P]=E});else{for(var S=u;S>=0&&S<f;){var k=d[S].index;if(b=h[y].points[k],b){x=b[1];break}S+=p}x=pick$1c(x,0),x=l.translate(x,0,1,0,1),n.push({isNull:!0,plotX:a.translate(y,0,0,0,1),x:y,plotY:x,yBottom:x})}})}return n},e.defaultOptions=merge$15(LineSeries$4.defaultOptions,{threshold:0}),e}(LineSeries$4);extend$1b(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$S=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$14=Utilities.merge,pick$1b=Utilities.pick,SplineSeries$1=function(o){__extends$S(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getPointSpline=function(t,r,n){var s=1.5,a=s+1,l=r.plotX||0,h=r.plotY||0,c=t[n-1],d=t[n+1],f,p,u,g,v;function y(k){return k&&!k.isNull&&k.doCurve!==!1&&!r.isCliff}if(y(c)&&y(d)){var m=c.plotX||0,x=c.plotY||0,b=d.plotX||0,$=d.plotY||0,S=0;f=(s*l+m)/a,p=(s*h+x)/a,u=(s*l+b)/a,g=(s*h+$)/a,u!==f&&(S=(g-p)*(u-l)/(u-f)+h-g),p+=S,g+=S,p>x&&p>h?(p=Math.max(x,h),g=2*h-p):p<x&&p<h&&(p=Math.min(x,h),g=2*h-p),g>$&&g>h?(g=Math.max($,h),p=2*h-g):g<$&&g<h&&(g=Math.min($,h),p=2*h-g),r.rightContX=u,r.rightContY=g}return v=["C",pick$1b(c.rightContX,c.plotX,0),pick$1b(c.rightContY,c.plotY,0),pick$1b(f,l,0),pick$1b(p,h,0),l,h],c.rightContX=c.rightContY=void 0,v},e.defaultOptions=merge$14(LineSeries$3.defaultOptions),e}(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$R=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),areaProto$1=AreaSeries$1.prototype,extend$1a=Utilities.extend,merge$13=Utilities.merge,AreaSplineSeries=function(o){__extends$R(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return e.defaultOptions=merge$13(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),e}(SplineSeries$1);extend$1a(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$Q=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$5=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$h=H.noop,clamp$d=Utilities.clamp,css$4=Utilities.css,defined$D=Utilities.defined,extend$19=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$d=Utilities.isArray,isNumber$x=Utilities.isNumber,merge$12=Utilities.merge,pick$1a=Utilities.pick,objectEach$i=Utilities.objectEach,ColumnSeries$h=function(o){__extends$Q(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.borderWidth=void 0,t.data=void 0,t.group=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){var r=this,n=this.yAxis,s=r.options,a=this.chart.inverted,l={},h=a?"translateX":"translateY",c,d;t?(l.scaleY=.001,d=clamp$d(n.toPixels(s.threshold),n.pos,n.pos+n.len),a?l.translateX=d-n.len:l.translateY=d,r.clipBox&&r.setClip(),r.group.attr(l)):(c=Number(r.group.attr(h)),r.group.animate({scaleY:1},extend$19(animObject$5(r.options.animation),{step:function(f,p){r.group&&(l[h]=c+p.pos*(n.pos-c),r.group.attr(l))}})))},e.prototype.init=function(t,r){o.prototype.init.apply(this,arguments);var n=this;t=n.chart,t.hasRendered&&t.series.forEach(function(s){s.type===n.type&&(s.isDirty=!0)})},e.prototype.getColumnMetrics=function(){var t=this,r=t.options,n=t.xAxis,s=t.yAxis,a=n.options.reversedStacks,l=n.reversed&&!a||!n.reversed&&a,h={},c,d=0;r.grouping===!1?d=1:t.chart.series.forEach(function(b){var $=b.yAxis,S=b.options,k;b.type===t.type&&(b.visible||!t.chart.options.chart.ignoreHiddenSeries)&&s.len===$.len&&s.pos===$.pos&&(S.stacking&&S.stacking!=="group"?(c=b.stackKey,typeof h[c]>"u"&&(h[c]=d++),k=h[c]):S.grouping!==!1&&(k=d++),b.columnIndex=k)});var f=Math.min(Math.abs(n.transA)*(n.ordinal&&n.ordinal.slope||r.pointRange||n.closestPointRange||n.tickInterval||1),n.len),p=f*r.groupPadding,u=f-2*p,g=u/(d||1),v=Math.min(r.maxPointWidth||n.len,pick$1a(r.pointWidth,g*(1-2*r.pointPadding))),y=(g-v)/2,m=(t.columnIndex||0)+(l?1:0),x=y+(p+m*g-f/2)*(l?-1:1);return t.columnMetrics={width:v,offset:x,paddedWidth:g,columnCount:d},t.columnMetrics},e.prototype.crispCol=function(t,r,n,s){var a=this.chart,l=this.borderWidth,h=-(l%2?.5:0),c,d=l%2?.5:1;a.inverted&&a.renderer.isVML&&(d+=1),this.options.crisp&&(c=Math.round(t+n)+h,t=Math.round(t)+h,n=c-t);var f=Math.round(r+s)+d,p=Math.abs(r)<=.5&&f>.5;return r=Math.round(r)+d,s=f-r,p&&s&&(r-=1,s+=1),{x:t,y:r,width:n,height:s}},e.prototype.adjustForMissingColumns=function(t,r,n,s){var a=this,l=this.options.stacking;if(!n.isNull&&s.columnCount>1){var h=0,c=0;objectEach$i(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(f){if(typeof n.x=="number"){var p=f[n.x.toString()];if(p){var u=p.points[a.index],g=p.total;l?(u&&(h=c),p.hasValidPoints&&c++):isArray$d(u)&&(h=u[1],c=g||0)}}});var d=(c-1)*s.paddedWidth+r;t=(n.plotX||0)+d/2-r-h*s.paddedWidth}return t},e.prototype.translate=function(){var t=this,r=t.chart,n=t.options,s=t.dense=t.closestPointRange*t.xAxis.transA<2,a=t.borderWidth=pick$1a(n.borderWidth,s?0:1),l=t.xAxis,h=t.yAxis,c=n.threshold,d=t.translatedThreshold=h.getThreshold(c),f=pick$1a(n.minPointLength,5),p=t.getColumnMetrics(),u=p.width,g=t.pointXOffset=p.offset,v=t.dataMin,y=t.dataMax,m=t.barW=Math.max(u,1+2*a);r.inverted&&(d-=.5),n.pointPadding&&(m=Math.ceil(m)),Series$e.prototype.translate.apply(t),t.points.forEach(function(x){var b=pick$1a(x.yBottom,d),$=999+Math.abs(b),S=x.plotX||0,k=clamp$d(x.plotY,-$,h.len+$),A,M=Math.min(k,b),P=Math.max(k,b)-M,E=u,T=S+g,O=m;f&&Math.abs(P)<f&&(P=f,A=!h.reversed&&!x.negative||h.reversed&&x.negative,isNumber$x(c)&&isNumber$x(y)&&x.y===c&&y<=c&&(h.min||0)<c&&(v!==y||(h.max||0)<=c)&&(A=!A),M=Math.abs(M-d)>f?b-f:d-(A?f:0)),defined$D(x.options.pointWidth)&&(E=O=Math.ceil(x.options.pointWidth),T-=Math.round((E-u)/2)),n.centerInCategory&&(T=t.adjustForMissingColumns(T,E,x,p)),x.barX=T,x.pointWidth=E,x.tooltipPos=r.inverted?[clamp$d(h.len+h.pos-r.plotLeft-k,h.pos-r.plotLeft,h.len+h.pos-r.plotLeft),l.len+l.pos-r.plotTop-T-O/2,P]:[l.left-r.plotLeft+T+O/2,clamp$d(k+h.pos-r.plotTop,h.pos-r.plotTop,h.len+h.pos-r.plotTop),P],x.shapeType=t.pointClass.prototype.shapeType||"rect",x.shapeArgs=t.crispCol.apply(t,x.isNull?[T,d,O,0]:[T,M,O,P])})},e.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},e.prototype.pointAttribs=function(t,r){var n=this.options,s=this.pointAttrToOptions||{},a=s.stroke||"borderColor",l=s["stroke-width"]||"borderWidth",h,c,d,f=t&&t.color||this.color,p=t&&t[a]||n[a]||f,u=t&&t.options.dashStyle||n.dashStyle,g=t&&t[l]||n[l]||this[l]||0,v=pick$1a(t&&t.opacity,n.opacity,1);t&&this.zones.length&&(c=t.getZone(),f=t.options.color||c&&(c.color||t.nonZonedColor)||this.color,c&&(p=c.borderColor||p,u=c.dashStyle||u,g=c.borderWidth||g)),r&&t&&(h=merge$12(n.states[r],t.options.states&&t.options.states[r]||{}),d=h.brightness,f=h.color||typeof d<"u"&&color$c(f).brighten(h.brightness).get()||f,p=h[a]||p,g=h[l]||g,u=h.dashStyle||u,v=pick$1a(h.opacity,v));var y={fill:f,stroke:p,"stroke-width":g,opacity:v};return u&&(y.dashstyle=u),y},e.prototype.drawPoints=function(){var t=this,r=this.chart,n=t.options,s=r.renderer,a=n.animationLimit||250,l;t.points.forEach(function(h){var c=h.plotY,d=h.graphic,f=!!d,p=d&&r.pointCount<a?"animate":"attr";isNumber$x(c)&&h.y!==null?(l=h.shapeArgs,d&&h.hasNewShapeType()&&(d=d.destroy()),t.enabledDataSorting&&(h.startXPos=t.xAxis.reversed?-(l&&l.width||0):t.xAxis.width),d||(h.graphic=d=s[h.shapeType](l).add(h.group||t.group),d&&t.enabledDataSorting&&r.hasRendered&&r.pointCount<a&&(d.attr({x:h.startXPos}),f=!0,p="animate")),d&&f&&d[p](merge$12(l)),n.borderRadius&&d[p]({r:n.borderRadius}),r.styledMode||d[p](t.pointAttribs(h,h.selected&&"select")).shadow(h.allowShadow!==!1&&n.shadow,null,n.stacking&&!n.borderRadius),d&&(d.addClass(h.getClassName(),!0),d.attr({visibility:h.visible?"inherit":"hidden"}))):d&&(h.graphic=d.destroy())})},e.prototype.drawTracker=function(){var t=this,r=t.chart,n=r.pointer,s=function(l){var h=n.getPointFromEvent(l);typeof h<"u"&&(n.isDirectTouch=!0,h.onMouseOver(l))},a;t.points.forEach(function(l){a=isArray$d(l.dataLabels)?l.dataLabels:l.dataLabel?[l.dataLabel]:[],l.graphic&&(l.graphic.element.point=l),a.forEach(function(h){h.div?h.div.point=l:h.element.point=l})}),t._hasTracking||(t.trackerGroups.forEach(function(l){t[l]&&(t[l].addClass("highcharts-tracker").on("mouseover",s).on("mouseout",function(h){n.onTrackerMouseOut(h)}),hasTouch$1&&t[l].on("touchstart",s),!r.styledMode&&t.options.cursor&&t[l].css(css$4).css({cursor:t.options.cursor}))}),t._hasTracking=!0),fireEvent$p(this,"afterDrawTracker")},e.prototype.remove=function(){var t=this,r=t.chart;r.hasRendered&&r.series.forEach(function(n){n.type===t.type&&(n.isDirty=!0)}),Series$e.prototype.remove.apply(t,arguments)},e.defaultOptions=merge$12(Series$e.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),e}(Series$e);extend$19(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$h,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$8=FormatUtilities.format,defined$C=Utilities.defined,extend$18=Utilities.extend,fireEvent$o=Utilities.fireEvent,isArray$c=Utilities.isArray,merge$11=Utilities.merge,objectEach$h=Utilities.objectEach,pick$19=Utilities.pick,splat$b=Utilities.splat,DataLabel;(function(o){var e=[];function t(c,d,f,p,u){var g=this,v=this.chart,y=this.isCartesian&&v.inverted,m=this.enabledDataSorting,x=pick$19(c.dlBox&&c.dlBox.centerX,c.plotX,-9999),b=pick$19(c.plotY,-9999),$=d.getBBox(),S=f.rotation,k=f.align,A=v.isInsidePlot(x,Math.round(b),{inverted:y,paneCoordinates:!0,series:g}),M=function(D){m&&g.xAxis&&!I&&g.setDataLabelStartPos(c,d,u,A,D)},P,E,T,O,C,I=pick$19(f.overflow,m?"none":"justify")==="justify",L=this.visible&&c.visible!==!1&&(c.series.forceDL||m&&!I||A||pick$19(f.inside,!!this.options.stacking)&&p&&v.isInsidePlot(x,y?p.x+1:p.y+p.height-1,{inverted:y,paneCoordinates:!0,series:g}));L&&(P=v.renderer.fontMetrics(v.styledMode?void 0:f.style.fontSize,d).b,p=extend$18({x:y?this.yAxis.len-b:x,y:Math.round(y?this.xAxis.len-x:b),width:0,height:0},p),extend$18(f,{width:$.width,height:$.height}),S?(I=!1,O=v.renderer.rotCorr(P,S),C={x:p.x+(f.x||0)+p.width/2+O.x,y:p.y+(f.y||0)+{top:0,middle:.5,bottom:1}[f.verticalAlign]*p.height},M(C),d[u?"attr":"animate"](C).attr({align:k}),E=(S+720)%360,T=E>180&&E<360,k==="left"?C.y-=T?$.height:0:k==="center"?(C.x-=$.width/2,C.y-=$.height/2):k==="right"&&(C.x-=$.width,C.y-=T?0:$.height),d.placed=!0,d.alignAttr=C):(M(p),d.align(f,void 0,p),C=d.alignAttr),I&&p.height>=0?this.justifyDataLabel(d,f,C,$,p,u):pick$19(f.crop,!0)&&(L=v.isInsidePlot(C.x,C.y,{paneCoordinates:!0,series:g})&&v.isInsidePlot(C.x+$.width,C.y+$.height,{paneCoordinates:!0,series:g})),f.shape&&!S&&d[u?"attr":"animate"]({anchorX:y?v.plotWidth-c.plotY:c.plotX,anchorY:y?v.plotHeight-c.plotX:c.plotY})),u&&m&&(d.placed=!1),!L&&(!m||I)&&(d.hide(!0),d.placed=!1)}function r(c,d){var f=d.filter;if(f){var p=f.operator,u=c[f.property],g=f.value;return p===">"&&u>g||p==="<"&&u<g||p===">="&&u>=g||p==="<="&&u<=g||p==="=="&&u==g||p==="==="&&u===g}return!0}function n(c){if(e.indexOf(c)===-1){var d=c.prototype;e.push(c),d.alignDataLabel=t,d.drawDataLabels=s,d.justifyDataLabel=a,d.setDataLabelStartPos=h}}o.compose=n;function s(){var c=this,d=c.chart,f=c.options,p=c.points,u=c.hasRendered||0,g=d.renderer,v=f.dataLabels,y,m,x=v.animation,b=v.defer?getDeferredAnimation$1(d,x,c):{defer:0,duration:0};if(v=l(l(d.options.plotOptions&&d.options.plotOptions.series&&d.options.plotOptions.series.dataLabels,d.options.plotOptions&&d.options.plotOptions[c.type]&&d.options.plotOptions[c.type].dataLabels),v),fireEvent$o(this,"drawDataLabels"),isArray$c(v)||v.enabled||c._hasPointLabels){if(m=c.plotGroup("dataLabelsGroup","data-labels",u?"inherit":"hidden",v.zIndex||6),m.attr({opacity:+u}),!u){var $=c.dataLabelsGroup;$&&(c.visible&&m.show(!0),$[f.animation?"animate":"attr"]({opacity:1},b))}p.forEach(function(S){y=splat$b(l(v,S.dlOptions||S.options&&S.options.dataLabels)),y.forEach(function(k,A){var M=k.enabled&&(!S.isNull||S.dataLabelOnNull)&&r(S,k),P=S.connectors?S.connectors[A]:S.connector,E,T,O,C,I,L,D=S.dataLabels?S.dataLabels[A]:S.dataLabel,N=pick$19(k.distance,S.labelDistance),B=!D;M&&(E=S.getLabelConfig(),T=pick$19(k[S.formatPrefix+"Format"],k.format),O=defined$C(T)?format$8(T,E,d):(k[S.formatPrefix+"Formatter"]||k.formatter).call(E,k),C=k.style,I=k.rotation,d.styledMode||(C.color=pick$19(k.color,C.color,c.color,palette.neutralColor100),C.color==="contrast"?(S.contrastColor=g.getContrast(S.color||c.color),C.color=!defined$C(N)&&k.inside||N<0||f.stacking?S.contrastColor:palette.neutralColor100):delete S.contrastColor,f.cursor&&(C.cursor=f.cursor)),L={r:k.borderRadius||0,rotation:I,padding:k.padding,zIndex:1},d.styledMode||(L.fill=k.backgroundColor,L.stroke=k.borderColor,L["stroke-width"]=k.borderWidth),objectEach$h(L,function(X,W){typeof X>"u"&&delete L[W]})),D&&(!M||!defined$C(O))?(S.dataLabel=S.dataLabel&&S.dataLabel.destroy(),S.dataLabels&&(S.dataLabels.length===1?delete S.dataLabels:delete S.dataLabels[A]),A||delete S.dataLabel,P&&(S.connector=S.connector.destroy(),S.connectors&&(S.connectors.length===1?delete S.connectors:delete S.connectors[A]))):M&&defined$C(O)&&(D?L.text=O:(S.dataLabels=S.dataLabels||[],D=S.dataLabels[A]=I?g.text(O,0,-9999,k.useHTML).addClass("highcharts-data-label"):g.label(O,0,-9999,k.shape,null,null,k.useHTML,null,"data-label"),A||(S.dataLabel=D),D.addClass(" highcharts-data-label-color-"+S.colorIndex+" "+(k.className||"")+(k.useHTML?" highcharts-tracker":""))),D.options=k,D.attr(L),d.styledMode||D.css(C).shadow(k.shadow),D.added||D.add(m),k.textPath&&!k.useHTML&&(D.setTextPath(S.getDataLabelPath&&S.getDataLabelPath(D)||S.graphic,k.textPath),S.dataLabelPath&&!k.textPath.enabled&&(S.dataLabelPath=S.dataLabelPath.destroy())),c.alignDataLabel(S,D,k,null,B))})})}fireEvent$o(this,"afterDrawDataLabels")}function a(c,d,f,p,u,g){var v=this.chart,y=d.align,m=d.verticalAlign,x=c.box?0:c.padding||0,b=d.x,$=b===void 0?0:b,S=d.y,k=S===void 0?0:S,A,M;return A=(f.x||0)+x,A<0&&(y==="right"&&$>=0?(d.align="left",d.inside=!0):$-=A,M=!0),A=(f.x||0)+p.width-x,A>v.plotWidth&&(y==="left"&&$<=0?(d.align="right",d.inside=!0):$+=v.plotWidth-A,M=!0),A=f.y+x,A<0&&(m==="bottom"&&k>=0?(d.verticalAlign="top",d.inside=!0):k-=A,M=!0),A=(f.y||0)+p.height-x,A>v.plotHeight&&(m==="top"&&k<=0?(d.verticalAlign="bottom",d.inside=!0):k+=v.plotHeight-A,M=!0),M&&(d.x=$,d.y=k,c.placed=!g,c.align(d,void 0,u)),M}function l(c,d){var f=[],p;if(isArray$c(c)&&!isArray$c(d))f=c.map(function(u){return merge$11(u,d)});else if(isArray$c(d)&&!isArray$c(c))f=d.map(function(u){return merge$11(c,u)});else if(!isArray$c(c)&&!isArray$c(d))f=merge$11(c,d);else for(p=Math.max(c.length,d.length);p--;)f[p]=merge$11(c[p],d[p]);return f}function h(c,d,f,p,u){var g=this.chart,v=g.inverted,y=this.xAxis,m=y.reversed,x=v?d.height/2:d.width/2,b=c.pointWidth,$=b?b/2:0;d.startXPos=v?u.x:m?-x-$:y.width-x+$,d.startYPos=v?m?this.yAxis.height-x+$:-x-$:u.y,p?d.visibility==="hidden"&&(d.show(),d.attr({opacity:0}).animate({opacity:1})):d.attr({opacity:1}).animate({opacity:0},void 0,d.hide),g.hasRendered&&(f&&d.attr({x:d.startXPos,y:d.startYPos}),d.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$d=SeriesRegistry$1.series,merge$10=Utilities.merge,pick$18=Utilities.pick,ColumnDataLabel$1;(function(o){var e=[];function t(n,s,a,l,h){var c=this.chart.inverted,d=n.series,f=n.dlBox||n.shapeArgs,p=pick$18(n.below,n.plotY>pick$18(this.translatedThreshold,d.yAxis.len)),u=pick$18(a.inside,!!this.options.stacking),g;f&&(l=merge$10(f),l.y<0&&(l.height+=l.y,l.y=0),g=l.y+l.height-d.yAxis.len,g>0&&g<l.height&&(l.height-=g),c&&(l={x:d.yAxis.len-l.y-l.height,y:d.xAxis.len-l.x-l.width,width:l.height,height:l.width}),u||(c?(l.x+=p?0:l.width,l.width=0):(l.y+=p?l.height:0,l.height=0))),a.align=pick$18(a.align,!c||u?"center":p?"right":"left"),a.verticalAlign=pick$18(a.verticalAlign,c||u?"middle":p?"top":"bottom"),Series$d.prototype.alignDataLabel.call(this,n,s,a,l,h),a.inside&&n.contrastColor&&s.css({color:n.contrastColor})}function r(n){DataLabel$1.compose(Series$d),e.indexOf(n)===-1&&(e.push(n),n.prototype.alignDataLabel=t)}o.compose=r})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$P=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),extend$17=Utilities.extend,merge$$=Utilities.merge,BarSeries=function(o){__extends$P(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.defaultOptions=merge$$(ColumnSeries$h.defaultOptions,{}),e}(ColumnSeries$h);extend$17(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$O=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),addEvent$P=Utilities.addEvent,extend$16=Utilities.extend,merge$_=Utilities.merge,ScatterSeries$4=function(o){__extends$O(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.applyJitter=function(){var t=this,r=this.options.jitter,n=this.points.length;function s(a){var l=Math.sin(a)*1e4;return l-Math.floor(l)}r&&this.points.forEach(function(a,l){["x","y"].forEach(function(h,c){var d,f="plot"+h.toUpperCase(),p,u,g;r[h]&&!a.isNull&&(d=t[h+"Axis"],g=r[h]*d.transA,d&&!d.isLog&&(p=Math.max(0,a[f]-g),u=Math.min(d.len,a[f]+g),a[f]=p+(u-p)*s(l+c*n),h==="x"&&(a.clientX=a.plotX)))})})},e.prototype.drawGraph=function(){this.options.lineWidth?o.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},e.defaultOptions=merge$_(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),e}(LineSeries$5);extend$16(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$P(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$w=Utilities.isNumber,pick$17=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$4=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var o=this.options,e=this.chart,t=2*(o.slicedOffset||0),r,n=e.plotWidth-2*t,s=e.plotHeight-2*t,a=o.center,l=Math.min(n,s),h=o.size,c=o.innerSize||0,d,f,p;for(typeof h=="string"&&(h=parseFloat(h)),typeof c=="string"&&(c=parseFloat(c)),d=[pick$17(a[0],"50%"),pick$17(a[1],"50%"),pick$17(h&&h<0?void 0:o.size,"100%"),pick$17(c&&c<0?void 0:o.innerSize||0,"0%")],e.angular&&!(this instanceof Series$e)&&(d[3]=0),f=0;f<4;++f)p=d[f],r=f<2||f===2&&/%$/.test(p),d[f]=relativeLength$6(p,[n,s,l,d[2]][f])+(r?t:0);return d[3]>d[2]&&(d[3]=d[2]),d},getStartAndEndRadians:function(o,e){var t=isNumber$w(o)?o:0,r=isNumber$w(e)&&e>t&&e-t<360?e:t+360,n=-90;return{start:deg2rad$4*(t+n),end:deg2rad$4*(r+n)}}},__extends$N=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),setAnimation$1=animationExports.setAnimation,addEvent$O=Utilities.addEvent,defined$B=Utilities.defined,extend$15=Utilities.extend,isNumber$v=Utilities.isNumber,pick$16=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=function(o){__extends$N(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.labelDistance=void 0,t.options=void 0,t.series=void 0,t}return e.prototype.getConnectorPath=function(){var t=this.labelPosition,r=this.series.options.dataLabels,n=this.connectorShapes,s=r.connectorShape;return n[s]&&(s=n[s]),s.call(this,{x:t.final.x,y:t.final.y,alignment:t.alignment},t.connectorPosition,r)},e.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},e.prototype.haloPath=function(t){var r=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(r.x,r.y,r.r+t,r.r+t,{innerR:r.r-1,start:r.start,end:r.end})},e.prototype.init=function(){var t=this;o.prototype.init.apply(this,arguments),this.name=pick$16(this.name,"Slice");var r=function(n){t.slice(n.type==="select")};return addEvent$O(this,"select",r),addEvent$O(this,"unselect",r),this},e.prototype.isValid=function(){return isNumber$v(this.y)&&this.y>=0},e.prototype.setVisible=function(t,r){var n=this,s=this.series,a=s.chart,l=s.options.ignoreHiddenPoint;r=pick$16(r,l),t!==this.visible&&(this.visible=this.options.visible=t=typeof t>"u"?!this.visible:t,s.options.data[s.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(h){n[h]&&n[h][t?"show":"hide"](t)}),this.legendItem&&a.legend.colorizeItem(this,t),!t&&this.state==="hover"&&this.setState(""),l&&(s.isDirty=!0),r&&a.redraw())},e.prototype.slice=function(t,r,n){var s=this.series,a=s.chart;setAnimation$1(n,a),r=pick$16(r,!0),this.sliced=this.options.sliced=t=defined$B(t)?t:!this.sliced,s.options.data[s.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},e}(Point$2);extend$15(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(o,e,t){var r=e.breakAt,n=e.touchingSliceAt,s=t.softConnector?["C",o.x+(o.alignment==="left"?-5:5),o.y,2*r.x-n.x,2*r.y-n.y,r.x,r.y]:["L",r.x,r.y];return[["M",o.x,o.y],s,["L",n.x,n.y]]},straight:function(o,e){var t=e.touchingSliceAt;return[["M",o.x,o.y],["L",t.x,t.y]]},crookedLine:function(o,e,t){var r=e.touchingSliceAt,n=this.series,s=n.center[0],a=n.chart.plotWidth,l=n.chart.plotLeft,h=o.alignment,c=this.shapeArgs.r,d=relativeLength$5(t.crookDistance,1),f=h==="left"?s+c+(a+l-s-c)*(1-d):l+(s-c)*d,p=["L",f,o.y],u=!0;(h==="left"?f>o.x||f<r.x:f<o.x||f>r.x)&&(u=!1);var g=[["M",o.x,o.y]];return u&&g.push(p),g.push(["L",r.x,r.y]),g}}});var __extends$M=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$g=H.noop,clamp$c=Utilities.clamp,extend$14=Utilities.extend,fireEvent$n=Utilities.fireEvent,merge$Z=Utilities.merge,pick$15=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=function(o){__extends$M(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.center=void 0,t.data=void 0,t.maxLabelDistance=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){var r=this,n=r.points,s=r.startAngleRad;t||n.forEach(function(a){var l=a.graphic,h=a.shapeArgs;l&&h&&(l.attr({r:pick$15(a.startR,r.center&&r.center[3]/2),start:s,end:s}),l.animate({r:h.r,start:h.start,end:h.end},r.options.animation))})},e.prototype.drawEmpty=function(){var t=this.startAngleRad,r=this.endAngleRad,n=this.options,s,a;this.total===0&&this.center?(s=this.center[0],a=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(s,a,this.center[1]/2,0,t,r).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(s,a,this.center[2]/2,0,{start:t,end:r,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":n.borderWidth,fill:n.fillColor||"none",stroke:n.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},e.prototype.drawPoints=function(){var t=this.chart.renderer;this.points.forEach(function(r){r.graphic&&r.hasNewShapeType()&&(r.graphic=r.graphic.destroy()),r.graphic||(r.graphic=t[r.shapeType](r.shapeArgs).add(r.series.group),r.delayedRendering=!0)})},e.prototype.generatePoints=function(){o.prototype.generatePoints.call(this),this.updateTotals()},e.prototype.getX=function(t,r,n){var s=this.center,a=this.radii?this.radii[n.index]||0:s[2]/2,l=Math.asin(clamp$c((t-s[1])/(a+n.labelDistance),-1,1)),h=s[0]+(r?-1:1)*(Math.cos(l)*(a+n.labelDistance))+(n.labelDistance>0?(r?-1:1)*this.options.dataLabels.padding:0);return h},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.redrawPoints=function(){var t=this,r=t.chart,n=r.renderer,s=t.options.shadow,a,l,h,c;this.drawEmpty(),s&&!t.shadowGroup&&!r.styledMode&&(t.shadowGroup=n.g("shadow").attr({zIndex:-1}).add(t.group)),t.points.forEach(function(d){var f={};if(l=d.graphic,!d.isNull&&l){var p=void 0;c=d.shapeArgs,a=d.getTranslate(),r.styledMode||(p=d.shadowGroup,s&&!p&&(p=d.shadowGroup=n.g("shadow").add(t.shadowGroup)),p&&p.attr(a),h=t.pointAttribs(d,d.selected&&"select")),d.delayedRendering?(l.setRadialReference(t.center).attr(c).attr(a),r.styledMode||l.attr(h).attr({"stroke-linejoin":"round"}).shadow(s,p),d.delayedRendering=!1):(l.setRadialReference(t.center),r.styledMode||merge$Z(!0,f,h),merge$Z(!0,f,c,a),l.animate(f)),l.attr({visibility:d.visible?"inherit":"hidden"}),l.addClass(d.getClassName(),!0)}else l&&(d.graphic=l.destroy())})},e.prototype.sortByAngle=function(t,r){t.sort(function(n,s){return typeof n.angle<"u"&&(s.angle-n.angle)*r})},e.prototype.translate=function(t){this.generatePoints();var r=this,n=1e3,s=r.options,a=s.slicedOffset,l=a+(s.borderWidth||0),h=getStartAndEndRadians(s.startAngle,s.endAngle),c=r.startAngleRad=h.start,d=r.endAngleRad=h.end,f=d-c,p=r.points,u=s.dataLabels.distance,g=s.ignoreHiddenPoint,v=p.length,y,m,x,b,$,S,k,A,M=0;for(t||(r.center=t=r.getCenter()),k=0;k<v;k++){A=p[k],m=c+M*f,A.isValid()&&(!g||A.visible)&&(M+=A.percentage/100),x=c+M*f;var P={x:t[0],y:t[1],r:t[2]/2,innerR:t[3]/2,start:Math.round(m*n)/n,end:Math.round(x*n)/n};A.shapeType="arc",A.shapeArgs=P,A.labelDistance=pick$15(A.options.dataLabels&&A.options.dataLabels.distance,u),A.labelDistance=relativeLength$4(A.labelDistance,P.r),r.maxLabelDistance=Math.max(r.maxLabelDistance||0,A.labelDistance),b=(x+m)/2,b>1.5*Math.PI?b-=2*Math.PI:b<-Math.PI/2&&(b+=2*Math.PI),A.slicedTranslation={translateX:Math.round(Math.cos(b)*a),translateY:Math.round(Math.sin(b)*a)},$=Math.cos(b)*t[2]/2,S=Math.sin(b)*t[2]/2,A.tooltipPos=[t[0]+$*.7,t[1]+S*.7],A.half=b<-Math.PI/2||b>Math.PI/2?1:0,A.angle=b,y=Math.min(l,A.labelDistance/5),A.labelPosition={natural:{x:t[0]+$+Math.cos(b)*A.labelDistance,y:t[1]+S+Math.sin(b)*A.labelDistance},final:{},alignment:A.labelDistance<0?"center":A.half?"right":"left",connectorPosition:{breakAt:{x:t[0]+$+Math.cos(b)*y,y:t[1]+S+Math.sin(b)*y},touchingSliceAt:{x:t[0]+$,y:t[1]+S}}}}fireEvent$n(r,"afterTranslate")},e.prototype.updateTotals=function(){var t=this.points,r=t.length,n=this.options.ignoreHiddenPoint,s,a,l=0;for(s=0;s<r;s++)a=t[s],a.isValid()&&(!n||a.visible)&&(l+=a.y);for(this.total=l,s=0;s<r;s++)a=t[s],a.percentage=l>0&&(a.visible||!n)?a.y/l*100:0,a.total=l},e.defaultOptions=merge$Z(Series$e.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),e}(Series$e);extend$14(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$g,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$g,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$f=H.noop,distribute$1=R.distribute,Series$c=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$b=Utilities.clamp,defined$A=Utilities.defined,merge$Y=Utilities.merge,pick$14=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(o){var e=[],t={radialDistributionY:function(l){return l.top+l.distributeBox.pos},radialDistributionX:function(l,h,c,d){return l.getX(c<h.top+2||c>h.bottom-2?d:c,h.half,h)},justify:function(l,h,c){return c[0]+(l.half?-1:1)*(h+l.labelDistance)},alignToPlotEdges:function(l,h,c,d){var f=l.getBBox().width;return h?f+d:c-f-d},alignToConnectors:function(l,h,c,d){var f=0,p;return l.forEach(function(u){p=u.dataLabel.getBBox().width,p>f&&(f=p)}),h?f+d:c-f-d}};function r(l){if(DataLabel$1.compose(Series$c),e.indexOf(l)===-1){e.push(l);var h=l.prototype;h.dataLabelPositioners=t,h.alignDataLabel=noop$f,h.drawDataLabels=n,h.placeDataLabels=s,h.verifyDataLabelOverflow=a}}o.compose=r;function n(){var l=this,h=l.data,c=l.chart,d=l.options.dataLabels||{},f=d.connectorPadding,p=c.plotWidth,u=c.plotHeight,g=c.plotLeft,v=Math.round(c.chartWidth/3),y=l.center,m=y[2]/2,x=y[1],b=[[],[]],$=[0,0,0,0],S=l.dataLabelPositioners,k,A,M,P,E,T,O,C,I,L,D,N;!l.visible||!d.enabled&&!l._hasPointLabels||(h.forEach(function(B){B.dataLabel&&B.visible&&B.dataLabel.shortened&&(B.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),B.dataLabel.shortened=!1)}),Series$c.prototype.drawDataLabels.apply(l),h.forEach(function(B){B.dataLabel&&(B.visible?(b[B.half].push(B),B.dataLabel._pos=null,!defined$A(d.style.width)&&!defined$A(B.options.dataLabels&&B.options.dataLabels.style&&B.options.dataLabels.style.width)&&B.dataLabel.getBBox().width>v&&(B.dataLabel.css({width:Math.round(v*.7)+"px"}),B.dataLabel.shortened=!0)):(B.dataLabel=B.dataLabel.destroy(),B.dataLabels&&B.dataLabels.length===1&&delete B.dataLabels))}),b.forEach(function(B,X){var W=B.length,F=[],U,z,V,j,K,ot;if(W)for(l.sortByAngle(B,X-.5),l.maxLabelDistance>0&&(U=Math.max(0,x-m-l.maxLabelDistance),z=Math.min(x+m+l.maxLabelDistance,c.plotHeight),B.forEach(function(q){q.labelDistance>0&&q.dataLabel&&(q.top=Math.max(0,x-m-q.labelDistance),q.bottom=Math.min(x+m+q.labelDistance,c.plotHeight),K=q.dataLabel.getBBox().height||21,q.distributeBox={target:q.labelPosition.natural.y-q.top+K/2,size:K,rank:q.y},F.push(q.distributeBox))}),ot=z+K-U,distribute$1(F,ot,ot/5)),D=0;D<W;D++){if(k=B[D],T=k.labelPosition,P=k.dataLabel,L=k.visible===!1?"hidden":"inherit",V=T.natural.y,I=V,F&&defined$A(k.distributeBox)&&(typeof k.distributeBox.pos>"u"?L="hidden":(O=k.distributeBox.size,I=S.radialDistributionY(k))),delete k.positionIndex,d.justify)C=S.justify(k,m,y);else switch(d.alignTo){case"connectors":C=S.alignToConnectors(B,X,p,g);break;case"plotEdges":C=S.alignToPlotEdges(P,X,p,g);break;default:C=S.radialDistributionX(l,k,I,V)}P._attr={visibility:L,align:T.alignment},N=k.options.dataLabels||{},P._pos={x:C+pick$14(N.x,d.x)+({left:f,right:-f}[T.alignment]||0),y:I+pick$14(N.y,d.y)-10},T.final.x=C,T.final.y=I,pick$14(d.crop,!0)&&(E=P.getBBox().width,j=null,C-E<f&&X===1?(j=Math.round(E-C+f),$[3]=Math.max(j,$[3])):C+E>p-f&&X===0&&(j=Math.round(C+E-p+f),$[1]=Math.max(j,$[1])),I-O/2<0?$[0]=Math.max(Math.round(-I+O/2),$[0]):I+O/2>u&&($[2]=Math.max(Math.round(I+O/2-u),$[2])),P.sideOverflow=j)}}),(arrayMax$6($)===0||this.verifyDataLabelOverflow($))&&(this.placeDataLabels(),this.points.forEach(function(B){if(N=merge$Y(d,B.options.dataLabels),A=pick$14(N.connectorWidth,1),A){var X=void 0;M=B.connector,P=B.dataLabel,P&&P._pos&&B.visible&&B.labelDistance>0?(L=P._attr.visibility,X=!M,X&&(B.connector=M=c.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+B.colorIndex+(B.className?" "+B.className:"")).add(l.dataLabelsGroup),c.styledMode||M.attr({"stroke-width":A,stroke:N.connectorColor||B.color||palette.neutralColor60})),M[X?"attr":"animate"]({d:B.getConnectorPath()}),M.attr("visibility",L)):M&&(B.connector=M.destroy())}})))}function s(){this.points.forEach(function(l){var h=l.dataLabel,c;h&&l.visible&&(c=h._pos,c?(h.sideOverflow&&(h._attr.width=Math.max(h.getBBox().width-h.sideOverflow,0),h.css({width:h._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),h.shortened=!0),h.attr(h._attr),h[h.moved?"animate":"attr"](c),h.moved=!0):h&&h.attr({y:-9999})),delete l.distributeBox},this)}function a(l){var h=this.center,c=this.options,d=c.center,f=c.minSize||80,p=f,u=c.size!==null;return u||(d[0]!==null?p=Math.max(h[2]-Math.max(l[1],l[3]),f):(p=Math.max(h[2]-l[1]-l[3],f),h[0]+=(l[3]-l[1])/2),d[1]!==null?p=clamp$b(p,f,h[2]-Math.max(l[0],l[2])):(p=clamp$b(p,f,h[2]-l[0]-l[2]),h[1]+=(l[0]-l[2])/2),p<h[2]?(h[2]=p,h[3]=Math.min(relativeLength$3(c.innerSize||0,p),p),this.translate(h),this.drawDataLabels&&this.drawDataLabels()):u=!0),u}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$N=Utilities.addEvent,fireEvent$m=Utilities.fireEvent,isArray$b=Utilities.isArray,isNumber$u=Utilities.isNumber,objectEach$g=Utilities.objectEach,pick$13=Utilities.pick;addEvent$N(Chart$1,"render",function(){var e=this,t=[];(this.labelCollectors||[]).forEach(function(r){t=t.concat(r())}),(this.yAxis||[]).forEach(function(r){r.stacking&&r.options.stackLabels&&!r.options.stackLabels.allowOverlap&&objectEach$g(r.stacking.stacks,function(n){objectEach$g(n,function(s){s.label&&s.label.visibility!=="hidden"&&t.push(s.label)})})}),(this.series||[]).forEach(function(r){var n=r.options.dataLabels;if(r.visible&&!(n.enabled===!1&&!r._hasPointLabels)){var s=function(a){return a.forEach(function(l){if(l.visible){var h=isArray$b(l.dataLabels)?l.dataLabels:l.dataLabel?[l.dataLabel]:[];h.forEach(function(c){var d=c.options;c.labelrank=pick$13(d.labelrank,l.labelrank,l.shapeArgs&&l.shapeArgs.height),d.allowOverlap?(c.oldOpacity=c.opacity,c.newOpacity=1,hideOrShow(c,e)):t.push(c)})}})};s(r.nodes||[]),s(r.points)}}),this.hideOverlappingLabels(t)});Chart$1.prototype.hideOverlappingLabels=function(o){var e=this,t=o.length,r=e.renderer,n,s,a,l,h,c,d,f=!1,p=function(g,v){return!(v.x>=g.x+g.width||v.x+v.width<=g.x||v.y>=g.y+g.height||v.y+v.height<=g.y)},u=function(g){var v,y,m,x=g.box?0:g.padding||0,b=0,$=0,S,k;if(g&&(!g.alignAttr||g.placed))return v=g.alignAttr||{x:g.attr("x"),y:g.attr("y")},y=g.parentGroup,g.width||(m=g.getBBox(),g.width=m.width,g.height=m.height,b=r.fontMetrics(null,g.element).h),S=g.width-2*x,k={left:"0",center:"0.5",right:"1"}[g.alignValue],k?$=+k*S:isNumber$u(g.x)&&Math.round(g.x)!==g.translateX&&($=g.x-g.translateX),{x:v.x+(y.translateX||0)+x-($||0),y:v.y+(y.translateY||0)+x-b,width:g.width-2*x,height:g.height-2*x}};for(s=0;s<t;s++)n=o[s],n&&(n.oldOpacity=n.opacity,n.newOpacity=1,n.absoluteBox=u(n));for(o.sort(function(g,v){return(v.labelrank||0)-(g.labelrank||0)}),s=0;s<t;s++)for(l=o[s],c=l&&l.absoluteBox,a=s+1;a<t;++a)h=o[a],d=h&&h.absoluteBox,c&&d&&l!==h&&l.newOpacity!==0&&h.newOpacity!==0&&p(c,d)&&((l.labelrank<h.labelrank?l:h).newOpacity=0);o.forEach(function(g){hideOrShow(g,e)&&(f=!0)}),f&&fireEvent$m(e,"afterHideAllOverlappingLabels")};function hideOrShow(o,e){var t,r,n=!1;return o&&(r=o.newOpacity,o.oldOpacity!==r&&(o.alignAttr&&o.placed?(o[r?"removeClass":"addClass"]("highcharts-data-label-hidden"),t=function(){e.styledMode||o.css({pointerEvents:r?"auto":"none"})},n=!0,o.alignAttr.opacity=r,o[o.isOld?"animate":"attr"](o.alignAttr,null,t),fireEvent$m(e,"afterHideOverlappingLabel")):o.attr({opacity:r})),o.isOld=!0),n}var extend$13=Utilities.extend,find$e=Utilities.find,isArray$a=Utilities.isArray,isObject$8=Utilities.isObject,merge$X=Utilities.merge,objectEach$f=Utilities.objectEach,pick$12=Utilities.pick,splat$a=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(o){var e=[];function t(n){return e.indexOf(n)===-1&&(e.push(n),extend$13(n.prototype,r.prototype)),n}o.compose=t;var r=function(){function n(){}return n.prototype.currentOptions=function(s){var a=this,l={};function h(c,d,f,p){var u;objectEach$f(c,function(g,v){if(!p&&a.collectionsWithUpdate.indexOf(v)>-1&&d[v])for(g=splat$a(g),f[v]=[],u=0;u<Math.max(g.length,d[v].length);u++)d[v][u]&&(g[u]===void 0?f[v][u]=d[v][u]:(f[v][u]={},h(g[u],d[v][u],f[v][u],p+1)));else isObject$8(g)?(f[v]=isArray$a(g)?[]:{},h(g,d[v]||{},f[v],p+1)):typeof d[v]>"u"?f[v]=null:f[v]=d[v]})}return h(s,this.options,l,0),l},n.prototype.matchResponsiveRule=function(s,a){var l=s.condition,h=l.callback||function(){return this.chartWidth<=pick$12(l.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$12(l.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$12(l.minWidth,0)&&this.chartHeight>=pick$12(l.minHeight,0)};h.call(this)&&a.push(s._id)},n.prototype.setResponsive=function(s,a){var l=this,h=this.options.responsive,c=this.currentResponsive,d=[],f;!a&&h&&h.rules&&h.rules.forEach(function(g){typeof g._id>"u"&&(g._id=uniqueKey$3()),l.matchResponsiveRule(g,d)},this);var p=merge$X.apply(void 0,d.map(function(g){return find$e((h||{}).rules||[],function(v){return v._id===g})}).map(function(g){return g&&g.chartOptions}));p.isResponsiveOptions=!0,d=d.toString()||void 0;var u=c&&c.ruleIds;d!==u&&(c&&this.update(c.undoOptions,s,!0),d?(f=this.currentOptions(p),f.isResponsiveOptions=!0,this.currentResponsive={ruleIds:d,mergedOptions:p,undoOptions:f},this.update(p,s,!0)):this.currentResponsive=void 0)},n}()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;G$7.animate=animationExports.animate;G$7.animObject=animationExports.animObject;G$7.getDeferredAnimation=animationExports.getDeferredAnimation;G$7.setAnimation=animationExports.setAnimation;G$7.stop=animationExports.stop;G$7.timers=Fx.timers;G$7.AST=AST;G$7.Axis=Axis;G$7.Chart=Chart$1;G$7.chart=Chart$1.chart;G$7.Fx=Fx;G$7.Legend=Legend;G$7.PlotLineOrBand=PlotLineOrBand;G$7.Point=Point$2;G$7.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$7.Series=Series$e;G$7.SVGElement=SVGElement;G$7.SVGRenderer=SVGRenderer;G$7.Tick=Tick;G$7.Time=Time;G$7.Tooltip=Tooltip;G$7.Color=Color;G$7.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement.compose(SVGElement);G$7.defaultOptions=DefaultOptions.defaultOptions;G$7.getOptions=DefaultOptions.getOptions;G$7.time=DefaultOptions.defaultTime;G$7.setOptions=DefaultOptions.setOptions;G$7.dateFormat=FormatUtilities.dateFormat;G$7.format=FormatUtilities.format;G$7.numberFormat=FormatUtilities.numberFormat;G$7.addEvent=Utilities.addEvent;G$7.arrayMax=Utilities.arrayMax;G$7.arrayMin=Utilities.arrayMin;G$7.attr=Utilities.attr;G$7.clearTimeout=Utilities.clearTimeout;G$7.correctFloat=Utilities.correctFloat;G$7.createElement=Utilities.createElement;G$7.css=Utilities.css;G$7.defined=Utilities.defined;G$7.destroyObjectProperties=Utilities.destroyObjectProperties;G$7.discardElement=Utilities.discardElement;G$7.distribute=R.distribute;G$7.erase=Utilities.erase;G$7.error=Utilities.error;G$7.extend=Utilities.extend;G$7.extendClass=Utilities.extendClass;G$7.find=Utilities.find;G$7.fireEvent=Utilities.fireEvent;G$7.getMagnitude=Utilities.getMagnitude;G$7.getStyle=Utilities.getStyle;G$7.inArray=Utilities.inArray;G$7.isArray=Utilities.isArray;G$7.isClass=Utilities.isClass;G$7.isDOMElement=Utilities.isDOMElement;G$7.isFunction=Utilities.isFunction;G$7.isNumber=Utilities.isNumber;G$7.isObject=Utilities.isObject;G$7.isString=Utilities.isString;G$7.keys=Utilities.keys;G$7.merge=Utilities.merge;G$7.normalizeTickInterval=Utilities.normalizeTickInterval;G$7.objectEach=Utilities.objectEach;G$7.offset=Utilities.offset;G$7.pad=Utilities.pad;G$7.pick=Utilities.pick;G$7.pInt=Utilities.pInt;G$7.relativeLength=Utilities.relativeLength;G$7.removeEvent=Utilities.removeEvent;G$7.seriesType=SeriesRegistry$1.seriesType;G$7.splat=Utilities.splat;G$7.stableSort=Utilities.stableSort;G$7.syncTimeout=Utilities.syncTimeout;G$7.timeUnits=Utilities.timeUnits;G$7.uniqueKey=Utilities.uniqueKey;G$7.useSerialIds=Utilities.useSerialIds;G$7.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$e);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$M=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$z=Utilities.defined,error$3=Utilities.error,pick$11=Utilities.pick,timeUnits=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(o){function e(g,v,y){if(composedClasses.indexOf(g)===-1){composedClasses.push(g);var m=g.prototype;m.getTimeTicks=t,m.index2val=r,m.lin2val=n,m.val2lin=p,m.ordinal2lin=m.val2lin,addEvent$M(g,"afterInit",a),addEvent$M(g,"foundExtremes",l),addEvent$M(g,"afterSetScale",h),addEvent$M(g,"initialAxisTranslation",c)}return composedClasses.indexOf(y)===-1&&(composedClasses.push(y),addEvent$M(y,"pan",d)),composedClasses.indexOf(v)===-1&&(composedClasses.push(v),addEvent$M(v,"updatedData",f)),g}o.compose=e;function t(g,v,y,m,x,b,$){x===void 0&&(x=[]),b===void 0&&(b=0);var S={},k=this.options.tickPixelInterval,A=this.chart.time,M=[],P,E,T,O,C,I=0,L=[],D=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!x||x.length<3||typeof v>"u")return A.getTimeTicks.apply(A,arguments);var N=x.length;for(P=0;P<N;P++){if(C=P&&x[P-1]>y,x[P]<v&&(I=P),P===N-1||x[P+1]-x[P]>b*5||C){if(x[P]>D){for(E=A.getTimeTicks(g,x[I],x[P],m);E.length&&E[0]<=D;)E.shift();E.length&&(D=E[E.length-1]),M.push(L.length),L=L.concat(E)}I=P+1}if(C)break}if(E){if(O=E.info,$&&O.unitRange<=timeUnits.hour){for(P=L.length-1,I=1;I<P;I++)A.dateFormat("%d",L[I])!==A.dateFormat("%d",L[I-1])&&(S[L[I]]="day",T=!0);T&&(S[L[0]]="day"),O.higherRanks=S}O.segmentStarts=M,L.info=O}else error$3(12,!1,this.chart);if($&&defined$z(k)){for(var B=L.length,X=[],W=[],F=void 0,U=void 0,z=void 0,V=void 0,j=void 0,K=B;K--;)U=this.translate(L[K]),z&&(W[K]=z-U),X[K]=z=U;for(W.sort(),V=W[Math.floor(W.length/2)],V<k*.6&&(V=null),K=L[B-1]>y?B-1:B,z=void 0;K--;)U=X[K],j=Math.abs(z-U),z&&j<k*.8&&(V===null||j<V*.8)?(S[L[K]]&&!S[L[K+1]]?(F=K+1,z=U):F=K,L.splice(F,1)):z=U}return L}function r(g){var v=this,y=v.ordinal,m=y.positions;if(!m)return g;var x=m.length-1,b;return g<0?g=m[0]:g>x?g=m[x]:(x=Math.floor(g),b=g-x),typeof b<"u"&&typeof m[x]<"u"?m[x]+(b?b*(m[x+1]-m[x]):0):g}function n(g){var v=this,y=v.ordinal,m=v.old?v.old.min:v.min,x=v.old?v.old.transA:v.transA,b=y.positions;if(!b)return g;var $=(g-m)*x+v.minPixelPadding,S=$>0&&$<v.left+v.len;if(S||(y.extendedOrdinalPositions||(y.extendedOrdinalPositions=y.getExtendedPositions()),b=y.extendedOrdinalPositions),b&&b.length){var k=y.getIndexOfPoint($,b),A=correctFloat$8(k%1);if(k>=0&&k<b.length){var M=b[Math.floor(k)],P=b[Math.ceil(k)],E=P-M;return b[Math.floor(k)]+A*E}var T=b.length,O=b[0],C=b[T-1],I=(C-O)/(T-1);return k<0?O+I*k:C+I*(k-T)}return g}function s(g,v){var y=o.Additions.findIndexOf(g,v,!0);if(g[y]===v)return y;var m=(v-g[y])/(g[y+1]-g[y]);return y+m}function a(){var g=this;g.ordinal||(g.ordinal=new o.Additions(g))}function l(){var g=this;g.isXAxis&&defined$z(g.options.overscroll)&&g.max===g.dataMax&&(!g.chart.mouseIsDown||g.isInternal)&&(!g.eventArgs||g.eventArgs&&g.eventArgs.trigger!=="navigator")&&(g.max+=g.options.overscroll,!g.isInternal&&defined$z(g.userMin)&&(g.min+=g.options.overscroll))}function h(){var g=this;g.horiz&&!g.isDirty&&(g.isDirty=g.isOrdinal&&g.chart.navigator&&!g.chart.navigator.adaptToUpdatedData)}function c(){var g=this;g.ordinal&&(g.ordinal.beforeSetTickPositions(),g.tickInterval=g.ordinal.postProcessTickInterval(g.tickInterval))}function d(g){var v=this,y=v.xAxis[0],m=y.options.overscroll,x=g.originalEvent.chartX,b=v.options.chart.panning,$=!1;if(b&&b.type!=="y"&&y.options.ordinal&&y.series.length){var S=v.mouseDownX,k=y.getExtremes(),A=k.dataMax,M=k.min,P=k.max,E=v.hoverPoints,T=y.closestPointRange||y.ordinal&&y.ordinal.overscrollPointsRange,O=y.translationSlope*(y.ordinal.slope||T),C=(S-x)/O,I={ordinal:{positions:y.ordinal.getExtendedPositions()}},L=y.index2val,D=y.val2lin,N=void 0,B=void 0,X=void 0,W=void 0;I.ordinal.positions?Math.abs(C)>1&&(E&&E.forEach(function(F){F.setState()}),C<0?(X=I,W=y.ordinal.positions?y:I):(X=y.ordinal.positions?y:I,W=I),B=W.ordinal.positions,A>B[B.length-1]&&B.push(A),v.fixedRange=P-M,N=y.navigatorAxis.toFixedRange(null,null,L.apply(X,[D.apply(X,[M,!0])+C]),L.apply(W,[D.apply(W,[P,!0])+C])),N.min>=Math.min(k.dataMin,M)&&N.max<=Math.max(A,P)+m&&y.setExtremes(N.min,N.max,!0,!1,{trigger:"pan"}),v.mouseDownX=x,css$3(v.container,{cursor:"move"})):$=!0}else $=!0;$||b&&/y/.test(b.type)?m&&(y.max=y.dataMax+m):g.preventDefault()}function f(){var g=this.xAxis;g&&g.options.ordinal&&(delete g.ordinal.index,delete g.ordinal.extendedOrdinalPositions)}function p(g,v){var y=this,m=y.ordinal,x=m.positions,b=m.slope,$=m.extendedOrdinalPositions;if(!x)return g;var S=x.length,k;if(x[0]<=g&&x[S-1]>=g)k=s(x,g);else{if($||($=m.getExtendedPositions&&m.getExtendedPositions(),m.extendedOrdinalPositions=$),!($&&$.length))return g;var A=$.length;b||(b=($[A-1]-$[0])/A);var M=s($,x[0]);if(g>=$[0]&&g<=$[A-1])k=s($,g)-M;else if(g<$[0]){var P=$[0]-g,E=P/b;k=-M-E}else{var P=g-$[A-1],E=P/b;k=E+A-M}}return v?k:b*(k||0)+m.offset}var u=function(){function g(v){this.index={},this.axis=v}return g.prototype.beforeSetTickPositions=function(){var v=this.axis,y=v.ordinal,m=v.getExtremes(),x=m.min,b=m.max,$=v.isXAxis&&!!v.options.breaks,S=v.options.ordinal,k=v.chart.options.chart.ignoreHiddenSeries,A,M,P,E,T,O,C,I,L=[],D=Number.MAX_VALUE,N=!1;if(S||$){if(v.series.forEach(function(B,X){if(M=[],(!k||B.visible!==!1)&&(B.takeOrdinalPosition!==!1||$)&&(L=L.concat(B.processedXData),A=L.length,L.sort(function(W,F){return W-F}),D=Math.min(D,pick$11(B.closestPointRange,D)),A)){for(X=0;X<A-1;)L[X]!==L[X+1]&&M.push(L[X+1]),X++;M[0]!==L[0]&&M.unshift(L[0]),L=M}B.isSeriesBoosting&&(I=!0)}),I&&(L.length=0),A=L.length,A>2){for(P=L[1]-L[0],C=A-1;C--&&!N;)L[C+1]-L[C]!==P&&(N=!0);!v.options.keepOrdinalPadding&&(L[0]-x>P||b-L[L.length-1]>P)&&(N=!0)}else v.options.overscroll&&(A===2?D=L[1]-L[0]:A===1?(D=v.options.overscroll,L=[L[0],L[0]+D]):D=y.overscrollPointsRange);N||v.forceOrdinal?(v.options.overscroll&&(y.overscrollPointsRange=D,L=L.concat(y.getOverscrollPositions())),y.positions=L,E=v.ordinal2lin(Math.max(x,L[0]),!0),T=Math.max(v.ordinal2lin(Math.min(b,L[L.length-1]),!0),1),y.slope=O=(b-x)/(T-E),y.offset=x-E*O):(y.overscrollPointsRange=pick$11(v.closestPointRange,y.overscrollPointsRange),y.positions=v.ordinal.slope=y.offset=void 0)}v.isOrdinal=S&&N,y.groupIntervalFactor=null},g.findIndexOf=function(v,y,m){for(var x=0,b=v.length-1,$;x<b;)$=Math.ceil((x+b)/2),v[$]<=y?x=$:b=$-1;return v[x]===y||m?x:-1},g.prototype.getExtendedPositions=function(){var v=this,y=v.axis,m=y.constructor.prototype,x=y.chart,b=y.series[0].currentDataGrouping,$=b?b.count+b.unitName:"raw",S=y.options.overscroll,k=y.getExtremes(),A,M=void 0,P=v.index;return P||(P=v.index={}),P[$]||(A={series:[],chart:x,forceOrdinal:!1,getExtremes:function(){return{min:k.dataMin,max:k.dataMax+S}},getGroupPixelWidth:m.getGroupPixelWidth,getTimeTicks:m.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:m.ordinal2lin,getIndexOfPoint:m.getIndexOfPoint,val2lin:m.val2lin},A.ordinal.axis=A,y.series.forEach(function(E){M={xAxis:A,xData:E.xData.slice(),chart:x,destroyGroupedData:H.noop,getProcessedData:Series$e.prototype.getProcessedData,applyGrouping:Series$e.prototype.applyGrouping},M.xData=M.xData.concat(v.getOverscrollPositions()),M.options={dataGrouping:b?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[b.unitName,[b.count]]]}:{enabled:!1}},A.series.push(M),E.processData.apply(M)}),y.applyGrouping.call(A),M.closestPointRange!==M.basePointRange&&M.currentDataGrouping&&(A.forceOrdinal=!0),y.ordinal.beforeSetTickPositions.apply({axis:A}),P[$]=A.ordinal.positions),P[$]},g.prototype.getGroupIntervalFactor=function(v,y,m){var x=this;x.axis;var b=m.processedXData,$=b.length,S=[],k,A,M=x.groupIntervalFactor;if(!M){for(A=0;A<$-1;A++)S[A]=b[A+1]-b[A];S.sort(function(P,E){return P-E}),k=S[Math.floor($/2)],v=Math.max(v,b[0]),y=Math.min(y,b[$-1]),x.groupIntervalFactor=M=$*k/(y-v)}return M},g.prototype.getIndexOfPoint=function(v,y){var m=this,x=m.axis,b=m.positions?m.positions[0]:0,$=x.series[0].points&&x.series[0].points[0]&&x.series[0].points[0].plotX||x.minPixelPadding;x.series.length>1&&x.series.forEach(function(A){defined$z(A.points[0])&&defined$z(A.points[0].plotX)&&A.points[0].plotX<$&&($=A.points[0].plotX)});var S=x.translationSlope*(m.slope||x.closestPointRange||m.overscrollPointsRange),k=(v-$)/S;return g.findIndexOf(y,b)+k},g.prototype.getOverscrollPositions=function(){var v=this,y=v.axis,m=y.options.overscroll,x=v.overscrollPointsRange,b=[],$=y.dataMax;if(defined$z(x))for(;$<=y.dataMax+m;)$+=x,b.push($);return b},g.prototype.postProcessTickInterval=function(v){var y=this,m=y.axis,x=y.slope,b;return x?m.options.breaks?b=m.closestPointRange||v:b=v/(x/m.closestPointRange):b=v,b},g}();o.Additions=u})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$L=Utilities.addEvent,find$d=Utilities.find,fireEvent$l=Utilities.fireEvent,isArray$9=Utilities.isArray,isNumber$t=Utilities.isNumber,pick$10=Utilities.pick,BrokenAxis;(function(o){var e=[];function t(p,u){if(e.indexOf(p)===-1&&(e.push(p),p.keepProps.push("brokenAxis"),addEvent$L(p,"init",a),addEvent$L(p,"afterInit",r),addEvent$L(p,"afterSetTickPositions",s),addEvent$L(p,"afterSetOptions",n)),e.indexOf(u)===-1){e.push(u);var g=u.prototype;g.drawBreaks=c,g.gappedPath=d,addEvent$L(u,"afterGeneratePoints",l),addEvent$L(u,"afterRender",h)}return p}o.compose=t;function r(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function n(){var p=this;p.brokenAxis&&p.brokenAxis.hasBreaks&&(p.options.ordinal=!1)}function s(){var p=this,u=p.brokenAxis;if(u&&u.hasBreaks){for(var g=p.tickPositions,v=p.tickPositions.info,y=[],m=0;m<g.length;m++)u.isInAnyBreak(g[m])||y.push(g[m]);p.tickPositions=y,p.tickPositions.info=v}}function a(){var p=this;p.brokenAxis||(p.brokenAxis=new f(p))}function l(){var p=this,u=p.isDirty,g=p.options.connectNulls,v=p.points,y=p.xAxis,m=p.yAxis;if(u)for(var x=v.length;x--;){var b=v[x],$=b.y===null&&g===!1,S=!$&&(y&&y.brokenAxis&&y.brokenAxis.isInAnyBreak(b.x,!0)||m&&m.brokenAxis&&m.brokenAxis.isInAnyBreak(b.y,!0));b.visible=S?!1:b.options.visible!==!1}}function h(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$10(this.pointArrayMap,["y"]))}function c(p,u){var g=this,v=g.points,y,m,x,b;if(p&&p.brokenAxis&&p.brokenAxis.hasBreaks){var $=p.brokenAxis;u.forEach(function(S){y=$&&$.breakArray||[],m=p.isXAxis?p.min:pick$10(g.options.threshold,p.min),v.forEach(function(k){b=pick$10(k["stack"+S.toUpperCase()],k[S]),y.forEach(function(A){isNumber$t(m)&&isNumber$t(b)&&(x=!1,m<A.from&&b>A.to||m>A.from&&b<A.from?x="pointBreak":(m<A.from&&b>A.from&&b<A.to||m>A.from&&b>A.to&&b<A.from)&&(x="pointInBreak"),x&&fireEvent$l(p,x,{point:k,brk:A}))})})})}}function d(){var p=this.currentDataGrouping,u=p&&p.gapSize,g=this.points.slice(),v=this.yAxis,y=this.options.gapSize,m=g.length-1,x;if(y&&m>0){this.options.gapUnit!=="value"&&(y*=this.basePointRange),u&&u>y&&u>=this.basePointRange&&(y=u);for(var b=void 0,$=void 0;m--;)if($&&$.visible!==!1||($=g[m+1]),b=g[m],!($.visible===!1||b.visible===!1)){if($.x-b.x>y){var S=(b.x+$.x)/2;g.splice(m+1,0,{isNull:!0,x:S}),v.stacking&&this.options.stacking&&(x=v.stacking.stacks[this.stackKey][S]=new StackItem$1(v,v.options.stackLabels,!1,S,this.stack),x.total=0)}$=b}}return this.getGraphPath(g)}var f=function(){function p(u){this.hasBreaks=!1,this.axis=u}return p.isInBreak=function(u,g){var v=u.repeat||1/0,y=u.from,m=u.to-u.from,x=g>=y?(g-y)%v:v-(y-g)%v,b;return u.inclusive?b=x<=m:b=x<m&&x!==0,b},p.lin2Val=function(u){var g=this,v=g.brokenAxis,y=v&&v.breakArray;if(!y||!isNumber$t(u))return u;var m=u,x,b;for(b=0;b<y.length&&(x=y[b],!(x.from>=m));b++)(x.to<m||p.isInBreak(x,m))&&(m+=x.len);return m},p.val2Lin=function(u){var g=this,v=g.brokenAxis,y=v&&v.breakArray;if(!y||!isNumber$t(u))return u;var m=u,x,b;for(b=0;b<y.length;b++)if(x=y[b],x.to<=u)m-=x.len;else{if(x.from>=u)break;if(p.isInBreak(x,u)){m-=u-x.from;break}}return m},p.prototype.findBreakAt=function(u,g){return find$d(g,function(v){return v.from<u&&u<v.to})},p.prototype.isInAnyBreak=function(u,g){var v=this,y=v.axis,m=y.options.breaks||[],x=m.length,b,$,S;if(x&&isNumber$t(u)){for(;x--;)p.isInBreak(m[x],u)&&(b=!0,$||($=pick$10(m[x].showPoints,!y.isXAxis)));b&&g?S=b&&!$:S=b}return S},p.prototype.setBreaks=function(u,g){var v=this,y=v.axis,m=isArray$9(u)&&!!u.length;y.isDirty=v.hasBreaks!==m,v.hasBreaks=m,y.options.breaks=y.userOptions.breaks=u,y.forceRedraw=!0,y.series.forEach(function(x){x.isDirty=!0}),!m&&y.val2lin===p.val2Lin&&(delete y.val2lin,delete y.lin2val),m&&(y.userOptions.ordinal=!1,y.lin2val=p.lin2Val,y.val2lin=p.val2Lin,y.setExtremes=function(x,b,$,S,k){if(v.hasBreaks){for(var A=this.options.breaks||[],M=void 0;M=v.findBreakAt(x,A);)x=M.to;for(;M=v.findBreakAt(b,A);)b=M.from;b<x&&(b=x)}y.constructor.prototype.setExtremes.call(this,x,b,$,S,k)},y.setAxisTranslation=function(){if(y.constructor.prototype.setAxisTranslation.call(this),v.unitLength=void 0,v.hasBreaks){var x=y.options.breaks||[],b=[],$=[],S=pick$10(y.pointRangePadding,0),k=0,A,M,P=y.userMin||y.min,E=y.userMax||y.max,T,O;x.forEach(function(C){M=C.repeat||1/0,isNumber$t(P)&&isNumber$t(E)&&(p.isInBreak(C,P)&&(P+=C.to%M-P%M),p.isInBreak(C,E)&&(E-=E%M-C.from%M))}),x.forEach(function(C){if(T=C.from,M=C.repeat||1/0,isNumber$t(P)&&isNumber$t(E)){for(;T-M>P;)T-=M;for(;T<P;)T+=M;for(O=T;O<E;O+=M)b.push({value:O,move:"in"}),b.push({value:O+C.to-C.from,move:"out",size:C.breakSize})}}),b.sort(function(C,I){return C.value===I.value?(C.move==="in"?0:1)-(I.move==="in"?0:1):C.value-I.value}),A=0,T=P,b.forEach(function(C){A+=C.move==="in"?1:-1,A===1&&C.move==="in"&&(T=C.value),A===0&&isNumber$t(T)&&($.push({from:T,to:C.value,len:C.value-T-(C.size||0)}),k+=C.value-T-(C.size||0))}),v.breakArray=$,isNumber$t(P)&&isNumber$t(E)&&isNumber$t(y.min)&&(v.unitLength=E-P-k+S,fireEvent$l(y,"afterBreaks"),y.staticScale?y.transA=y.staticScale:v.unitLength&&(y.transA*=(E-y.min+S)/v.unitLength),S&&(y.minPixelPadding=y.transA*(y.minPointOffset||0)),y.min=P,y.max=E)}}),pick$10(g,!0)&&y.chart.redraw()},p}();o.Additions=f})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;BrokenAxis$1.compose(G$6.Axis,G$6.Series);var format$7=FormatUtilities.format,seriesProto$3=Series$e.prototype,addEvent$K=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$y=Utilities.defined,error$2=Utilities.error,extend$12=Utilities.extend,isNumber$s=Utilities.isNumber,merge$W=Utilities.merge,pick$$=Utilities.pick,approximations=H.approximations={sum:function(o){var e=o.length,t;if(!e&&o.hasNulls)t=null;else if(e)for(t=0;e--;)t+=o[e];return t},average:function(o){var e=o.length,t=approximations.sum(o);return isNumber$s(t)&&e&&(t=correctFloat$7(t/e)),t},averages:function(){var o=[];return[].forEach.call(arguments,function(e){o.push(approximations.average(e))}),typeof o[0]>"u"?void 0:o},open:function(o){return o.length?o[0]:o.hasNulls?null:void 0},high:function(o){return o.length?arrayMax$5(o):o.hasNulls?null:void 0},low:function(o){return o.length?arrayMin$5(o):o.hasNulls?null:void 0},close:function(o){return o.length?o[o.length-1]:o.hasNulls?null:void 0},ohlc:function(o,e,t,r){if(o=approximations.open(o),e=approximations.high(e),t=approximations.low(t),r=approximations.close(r),isNumber$s(o)||isNumber$s(e)||isNumber$s(t)||isNumber$s(r))return[o,e,t,r]},range:function(o,e){if(o=approximations.low(o),e=approximations.high(e),isNumber$s(o)||isNumber$s(e))return[o,e];if(o===null&&e===null)return null}},applyGrouping=function(){var o=this,e=o.chart,t=o.options,r=t.dataGrouping,n=o.allowDG!==!1&&r&&pick$$(r.enabled,e.options.isStock),s=o.visible||!e.options.chart.ignoreHiddenSeries,a,l,h=this.currentDataGrouping,c,d,f=!1;if(n&&!o.requireSorting&&(o.requireSorting=f=!0),l=skipDataGrouping(o)||!n,f&&(o.requireSorting=!1),!l){o.destroyGroupedData();var p=void 0,u=r.groupAll?o.xData:o.processedXData,g=r.groupAll?o.yData:o.processedYData,v=e.plotSizeX,y=o.xAxis,m=y.options.ordinal,x=o.groupPixelWidth;if(x&&u&&u.length){a=!0,o.isDirty=!0,o.points=null;var b=y.getExtremes(),$=b.min,S=b.max,k=m&&y.ordinal&&y.ordinal.getGroupIntervalFactor($,S,o)||1,A=x*(S-$)/v*k,M=y.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(A,r.units||defaultDataGroupingUnits),Math.min($,u[0]),Math.max(S,u[u.length-1]),y.options.startOfWeek,u,o.closestPointRange),P=seriesProto$3.groupData.apply(o,[u,g,M,r.approximation]),E=P.groupedXData,T=P.groupedYData,O=0;for(r&&r.smoothed&&E.length&&(r.firstAnchor="firstPoint",r.anchor="middle",r.lastAnchor="lastPoint",error$2(32,!1,e,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(o,E,S),p=1;p<M.length;p++)(!M.info.segmentStarts||M.info.segmentStarts.indexOf(p)===-1)&&(O=Math.max(M[p]-M[p-1],O));c=M.info,c.gapSize=O,o.closestPointRange=M.info.totalRange,o.groupMap=P.groupMap,s&&adjustExtremes(y,E),r.groupAll&&(o.allGroupedData=T,d=o.cropData(E,T,y.min,y.max,1),E=d.xData,T=d.yData,o.cropStart=d.start),o.processedXData=E,o.processedYData=T}else o.groupMap=null;o.hasGroupedData=a,o.currentDataGrouping=c,o.preventGraphAnimation=(h&&h.totalRange)!==(c&&c.totalRange)}},skipDataGrouping=function(o){if(o.isCartesian&&!o.isDirty&&!o.xAxis.isDirty&&!o.yAxis.isDirty)return!1},groupData=function(o,e,t,r){var n=this,s=n.data,a=n.options&&n.options.data,l=[],h=[],c=[],d=o.length,f,p,u,g=!!e,v=[],y,m=n.pointArrayMap,x=m&&m.length,b=["x"].concat(m||["y"]),$=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,k=0,A,M,P;function E(I){return typeof I=="function"?I:approximations[I]?approximations[I]:approximations[n.getDGApproximation&&n.getDGApproximation()||"average"]}for(y=E(r),x?m.forEach(function(){v.push([])}):v.push([]),A=x||1,M=0;M<=d&&!(o[M]>=t[0]);M++);for(M;M<=d;M++){for(;typeof t[S+1]<"u"&&o[M]>=t[S+1]||M===d;){for(f=t[S],n.dataGroupInfo={start:$?k:n.cropStart+k,length:v[0].length},u=y.apply(n,v),n.pointClass&&!defined$y(n.dataGroupInfo.options)&&(n.dataGroupInfo.options=merge$W(n.pointClass.prototype.optionsToObject.call({series:n},n.options.data[n.cropStart+k])),b.forEach(function(I){delete n.dataGroupInfo.options[I]})),typeof u<"u"&&(l.push(f),h.push(u),c.push(n.dataGroupInfo)),k=M,P=0;P<A;P++)v[P].length=0,v[P].hasNulls=!1;if(S+=1,M===d)break}if(M===d)break;if(m){var T=n.options.dataGrouping&&n.options.dataGrouping.groupAll?M:n.cropStart+M,O=s&&s[T]||n.pointClass.prototype.applyOptions.apply({series:n},[a[T]]),C=void 0;for(P=0;P<x;P++)C=O[m[P]],isNumber$s(C)?v[P].push(C):C===null&&(v[P].hasNulls=!0)}else p=g?e[M]:null,isNumber$s(p)?v[0].push(p):p===null&&(v[0].hasNulls=!0)}return{groupedXData:l,groupedYData:h,groupMap:c}},anchorPoints=function(o,e,t){var r=o.options,n=r.dataGrouping,s=o.currentDataGrouping&&o.currentDataGrouping.gapSize,a;if(n&&o.xData&&s&&o.groupMap){var l=e.length-1,h=n.anchor,c=pick$$(n.firstAnchor,h),d=pick$$(n.lastAnchor,h);if(h&&h!=="start"){var f=s*{middle:.5,end:1}[h];for(a=e.length-1;a--&&a>0;)e[a]+=f}if(c&&c!=="start"&&o.xData[0]>=e[0]){var p=o.groupMap[0].start,u=o.groupMap[0].length,g=void 0;isNumber$s(p)&&isNumber$s(u)&&(g=p+(u-1)),e[0]={middle:e[0]+.5*s,end:e[0]+s,firstPoint:o.xData[0],lastPoint:g&&o.xData[g]}[c]}if(d&&d!=="start"&&s&&e[l]>=t-s){var v=o.groupMap[o.groupMap.length-1].start;e[l]={middle:e[l]+.5*s,end:e[l]+s,firstPoint:v&&o.xData[v],lastPoint:o.xData[o.xData.length-1]}[d]}}},adjustExtremes=function(o,e){defined$y(e[0])&&isNumber$s(o.min)&&isNumber$s(o.dataMin)&&e[0]<o.min&&((!defined$y(o.options.min)&&o.min<=o.dataMin||o.min===o.dataMin)&&(o.min=Math.min(e[0],o.min)),o.dataMin=Math.min(e[0],o.dataMin)),defined$y(e[e.length-1])&&isNumber$s(o.max)&&isNumber$s(o.dataMax)&&e[e.length-1]>o.max&&((!defined$y(o.options.max)&&isNumber$s(o.dataMax)&&o.max>=o.dataMax||o.max===o.dataMax)&&(o.max=Math.max(e[e.length-1],o.max)),o.dataMax=Math.max(e[e.length-1],o.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(o,e){o&&(this.groupedData[e]=o.destroy?o.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var o=this,e=o.series;e.forEach(function(t){t.groupPixelWidth=void 0,t.groupPixelWidth=o.getGroupPixelWidth&&o.getGroupPixelWidth(),t.groupPixelWidth&&(t.hasProcessed=!0),t.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var o=this.series,e=o.length,t,r=0,n=!1,s,a;for(t=e;t--;)a=o[t].options.dataGrouping,a&&(r=Math.max(r,pick$$(a.groupPixelWidth,commonOptions.groupPixelWidth)));for(t=e;t--;)a=o[t].options.dataGrouping,a&&(s=(o[t].processedXData||o[t].data).length,(o[t].groupPixelWidth||s>this.chart.plotSizeX/r||s&&a.forced)&&(n=!0));return n?r:0};Axis.prototype.setDataGrouping=function(o,e){var t=this,r;if(e=pick$$(e,!0),o||(o={forced:!1,units:null}),this instanceof Axis)for(r=this.series.length;r--;)this.series[r].update({dataGrouping:o},!1);else this.chart.options.series.forEach(function(n){n.dataGrouping=o},!1);t.ordinal&&(t.ordinal.slope=void 0),e&&this.chart.redraw()};addEvent$K(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$K(Point$2,"update",function(){if(this.dataGroup)return error$2(24,!1,this.series.chart),!1});addEvent$K(Tooltip,"headerFormatter",function(o){var e=this.chart,t=e.time,r=o.labelConfig,n=r.series,s=n.options,a=n.tooltipOptions,l=s.dataGrouping,h=a.xDateFormat,c,d=n.xAxis,f,p,u,g,v=a[o.isFooter?"footerFormat":"headerFormat"];d&&d.options.type==="datetime"&&l&&isNumber$s(r.key)&&(f=n.currentDataGrouping,p=l.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,f?(u=p[f.unitName],f.count===1?h=u[0]:(h=u[1],c=u[2])):!h&&p&&d.dateTime&&(h=d.dateTime.getXDateFormat(r.x,a.dateTimeLabelFormats)),g=t.dateFormat(h,r.key),c&&(g+=t.dateFormat(c,r.key+f.totalRange-1)),n.chart.styledMode&&(v=this.styledModeFormat(v)),o.text=format$7(v,{point:extend$12(r.point,{key:g}),series:n},e),o.preventDefault())});addEvent$K(Series$e,"destroy",seriesProto$3.destroyGroupedData);addEvent$K(Series$e,"afterSetOptions",function(o){var e=o.options,t=this.type,r=this.chart.options.plotOptions,n=DefaultOptions.defaultOptions.plotOptions[t].dataGrouping,s=this.useCommonDataGrouping&&commonOptions;if(specificOptions[t]||s){n||(n=merge$W(commonOptions,specificOptions[t]));var a=this.chart.rangeSelector;e.dataGrouping=merge$W(s,n,r.series&&r.series.dataGrouping,r[t].dataGrouping,this.userOptions.dataGrouping,!e.isInternal&&a&&isNumber$s(a.selected)&&a.buttonOptions[a.selected].dataGrouping)}});addEvent$K(Axis,"afterSetScale",function(){this.series.forEach(function(o){o.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$L=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=function(o){__extends$L(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.close=void 0,t.high=void 0,t.low=void 0,t.open=void 0,t.options=void 0,t.plotClose=void 0,t.plotOpen=void 0,t.series=void 0,t}return e.prototype.getClassName=function(){return o.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},e.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},e.prototype.resolveColor=function(){o.prototype.resolveColor.call(this),this.resolveUpColor()},e.prototype.getZone=function(){var t=o.prototype.getZone.call(this);return this.resolveUpColor(),t},e.prototype.applyOptions=function(){return o.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},e}(ColumnSeries$g.prototype.pointClass),__extends$K=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$11=Utilities.extend,merge$V=Utilities.merge,OHLCSeries$1=function(o){__extends$K(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.yData=void 0,t}return e.prototype.drawPoints=function(){var t=this,r=t.points,n=t.chart,s=function(a,l,h){var c=a[0],d=a[1];typeof c[2]=="number"&&(c[2]=Math.max(h+l,c[2])),typeof d[2]=="number"&&(d[2]=Math.min(h-l,d[2]))};r.forEach(function(a){var l,h,c,d,f,p=a.graphic,u,g=!p,v;typeof a.plotY<"u"&&(p||(a.graphic=p=n.renderer.path().add(t.group)),n.styledMode||p.attr(t.pointAttribs(a,a.selected&&"select")),v=p.strokeWidth(),c=v%2/2,u=Math.round(a.plotX)-c,d=Math.round(a.shapeArgs.width/2),f=[["M",u,Math.round(a.yBottom)],["L",u,Math.round(a.plotHigh)]],a.open!==null&&(l=Math.round(a.plotOpen)+c,f.push(["M",u,l],["L",u-d,l]),s(f,v/2,l)),a.close!==null&&(h=Math.round(a.plotClose)+c,f.push(["M",u,h],["L",u+d,h]),s(f,v/2,h)),p[g?"attr":"animate"]({d:f}).addClass(a.getClassName(),!0))})},e.prototype.init=function(){o.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.pointAttribs=function(t,r){var n=o.prototype.pointAttribs.call(this,t,r),s=this.options;return delete n.fill,!t.options.color&&s.upColor&&t.open<t.close&&(n.stroke=s.upColor),n},e.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},e.prototype.translate=function(){var t=this,r=t.yAxis,n=!!t.modifyValue,s=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];o.prototype.translate.apply(t),t.points.forEach(function(a){[a.open,a.high,a.low,a.close,a.low].forEach(function(l,h){l!==null&&(n&&(l=t.modifyValue(l)),a[s[h]]=r.toPixels(l,!0))}),a.tooltipPos[1]=a.plotHigh+r.pos-t.chart.plotTop})},e.defaultOptions=merge$V(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),e}(ColumnSeries$f);extend$11(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$J=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defaultOptions$8=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$U=Utilities.merge,CandlestickSeries=function(o){__extends$J(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(t,r){var n=ColumnSeries$e.prototype.pointAttribs.call(this,t,r),s=this.options,a=t.open<t.close,l=s.lineColor||this.color,h=t.color||this.color,c;return n["stroke-width"]=s.lineWidth,n.fill=t.options.color||a&&s.upColor||h,n.stroke=t.options.lineColor||a&&s.upLineColor||l,r&&(c=s.states[r],n.fill=c.color||n.fill,n.stroke=c.lineColor||n.stroke,n["stroke-width"]=c.lineWidth||n["stroke-width"]),n},e.prototype.drawPoints=function(){var t=this,r=t.points,n=t.chart,s=t.yAxis.reversed;r.forEach(function(a){var l=a.graphic,h,c,d,f,p,u,g,v,y,m,x=!l;typeof a.plotY<"u"&&(l||(a.graphic=l=n.renderer.path().add(t.group)),t.chart.styledMode||l.attr(t.pointAttribs(a,a.selected&&"select")).shadow(t.options.shadow),g=l.strokeWidth()%2/2,v=Math.round(a.plotX)-g,h=a.plotOpen,c=a.plotClose,d=Math.min(h,c),f=Math.max(h,c),m=Math.round(a.shapeArgs.width/2),p=s?f!==a.yBottom:Math.round(d)!==Math.round(a.plotHigh),u=s?Math.round(d)!==Math.round(a.plotHigh):f!==a.yBottom,d=Math.round(d)+g,f=Math.round(f)+g,y=[],y.push(["M",v-m,f],["L",v-m,d],["L",v+m,d],["L",v+m,f],["Z"],["M",v,d],["L",v,p?Math.round(s?a.yBottom:a.plotHigh):d],["M",v,f],["L",v,u?Math.round(s?a.plotHigh:a.yBottom):f]),l[x?"attr":"animate"]({d:y}).addClass(a.getClassName(),!0))})},e.defaultOptions=merge$U(OHLCSeries.defaultOptions,defaultOptions$8.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$8.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),e}(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$I=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$r=Utilities.isNumber,FlagsPoint=function(o){__extends$I(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.isValid=function(){return isNumber$r(this.y)||typeof this.y>"u"},e.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},e}(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$e.prototype,defined$x=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var o=this,e=o.options,t=o.chart,r=o.points,n=r.length-1,s,a,l=e.onSeries,h=l&&t.get(l),c=e.onKey||"y",d=h&&h.options.step,f=h&&h.points,p=f&&f.length,u=t.inverted,g=o.xAxis,v=o.yAxis,y=0,m,x,b,$,S;if(h&&h.visible&&p)for(y=(h.pointXOffset||0)+(h.barW||0)/2,$=h.currentDataGrouping,x=f[p-1].x+($?$.totalRange:0),stableSort$4(r,function(k,A){return k.x-A.x}),c="plot"+c[0].toUpperCase()+c.substr(1);p--&&r[n]&&(m=f[p],s=r[n],s.y=m.y,!(m.x<=s.x&&typeof m[c]<"u"&&(s.x<=x&&(s.plotY=m[c],m.x<s.x&&!d&&(b=f[p+1],b&&typeof b[c]<"u"&&(S=(s.x-m.x)/(b.x-m.x),s.plotY+=S*(b[c]-m[c]),s.y+=S*(b.y-m.y)))),n--,p++,n<0))););r.forEach(function(k,A){var M;k.plotX+=y,(typeof k.plotY>"u"||u)&&(k.plotX>=0&&k.plotX<=g.len?u?(k.plotY=g.translate(k.x,0,1,0,1),k.plotX=defined$x(k.y)?v.translate(k.y,0,0,0,1):0):k.plotY=(g.opposite?0:o.yAxis.len)+g.offset:k.shapeArgs={}),a=r[A-1],a&&a.plotX===k.plotX&&(typeof a.stackIndex>"u"&&(a.stackIndex=0),M=a.stackIndex+1),k.stackIndex=M}),this.onSeries=h}},symbols$3=SVGRenderer.prototype.symbols;symbols$3.flag=function(o,e,t,r,n){var s=n&&n.anchorX||o,a=n&&n.anchorY||e,l=symbols$3.circle(s-1,a-1,2,2);return l.push(["M",s,a],["L",o,e+r],["L",o,e],["L",o+t,e],["L",o+t,e+r],["L",o,e+r],["Z"]),l};function createPinSymbol(o){symbols$3[o+"pin"]=function(e,t,r,n,s){var a=s&&s.anchorX,l=s&&s.anchorY,h;if(o==="circle"&&n>r&&(e-=Math.round((n-r)/2),r=n),h=symbols$3[o](e,t,r,n),a&&l){var c=a;if(o==="circle")c=e+r/2;else{var d=h[0],f=h[1];d[0]==="M"&&f[0]==="L"&&(c=(d[1]+f[1])/2)}var p=t>l?t:t+n;h.push(["M",c,p],["L",a,l]),h=h.concat(symbols$3.circle(a-1,l-1,2,2))}return h}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$3.circlepin,Renderer.prototype.symbols.flag=symbols$3.flag,Renderer.prototype.symbols.squarepin=symbols$3.squarepin);var __extends$H=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$e=H.noop,distribute=R.distribute,Series$b=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$J=Utilities.addEvent,defined$w=Utilities.defined,extend$10=Utilities.extend,merge$T=Utilities.merge,objectEach$e=Utilities.objectEach,wrap$b=Utilities.wrap,FlagsSeries=function(o){__extends$H(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){t&&this.setClip()},e.prototype.drawPoints=function(){var t=this,r=t.points,n=t.chart,s=n.renderer,a,l,h=n.inverted,c=t.options,d=c.y,f,p,u,g,v,y,m,x,b=t.yAxis,$={},S=[],k;for(p=r.length;p--;)u=r[p],x=(h?u.plotY:u.plotX)>t.xAxis.len,a=u.plotX,v=u.stackIndex,f=u.options.shape||c.shape,l=u.plotY,typeof l<"u"&&(l=u.plotY+d-(typeof v<"u"&&v*c.stackDistance)),u.anchorX=v?void 0:u.plotX,y=v?void 0:u.plotY,k=f!=="flag",g=u.graphic,typeof l<"u"&&a>=0&&!x?(g&&u.hasNewShapeType()&&(g=g.destroy()),g||(g=u.graphic=s.label("",null,null,f,null,null,c.useHTML).addClass("highcharts-point").add(t.markerGroup),u.graphic.div&&(u.graphic.div.point=u),g.isNew=!0),g.attr({align:k?"center":"left",width:c.width,height:c.height,"text-align":c.textAlign}),n.styledMode||g.attr(t.pointAttribs(u)).css(merge$T(c.style,u.style)).shadow(c.shadow),a>0&&(a-=g.strokeWidth()%2),m={y:l,anchorY:y},c.allowOverlapX&&(m.x=a,m.anchorX=u.anchorX),g.attr({text:u.options.title||c.title||"A"})[g.isNew?"attr":"animate"](m),c.allowOverlapX||($[u.plotX]?$[u.plotX].size=Math.max($[u.plotX].size,g.width):$[u.plotX]={align:k?.5:0,size:g.width,target:a,anchorX:a}),u.tooltipPos=[a,l+b.pos-n.plotTop]):g&&(u.graphic=g.destroy());c.allowOverlapX||(objectEach$e($,function(A){A.plotX=A.anchorX,S.push(A)}),distribute(S,h?b.len:this.xAxis.len,100),r.forEach(function(A){var M=A.graphic&&$[A.plotX];M&&(A.graphic[A.graphic.isNew?"attr":"animate"]({x:M.pos+M.align*M.size,anchorX:A.anchorX}),defined$w(M.pos)?A.graphic.isNew=!1:(A.graphic.attr({x:-9999,anchorX:-9999}),A.graphic.isNew=!0))})),c.useHTML&&wrap$b(t.markerGroup,"on",function(A){return SVGElement.prototype.on.apply(A.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},e.prototype.drawTracker=function(){var t=this,r=t.points;o.prototype.drawTracker.call(this),r.forEach(function(n){var s=n.graphic;s&&(n.unbindMouseOver&&n.unbindMouseOver(),n.unbindMouseOver=addEvent$J(s.element,"mouseover",function(){n.stackIndex>0&&!n.raised&&(n._y=s.y,s.attr({y:n._y-8}),n.raised=!0),r.forEach(function(a){a!==n&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})}))})},e.prototype.pointAttribs=function(t,r){var n=this.options,s=t&&t.color||this.color,a=n.lineColor,l=t&&t.lineWidth,h=t&&t.fillColor||n.fillColor;return r&&(h=n.states[r].fillColor,a=n.states[r].lineColor,l=n.states[r].lineWidth),{fill:h||s,stroke:a||s,"stroke-width":l||n.lineWidth||0}},e.prototype.setClip=function(){Series$b.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},e.defaultOptions=merge$T(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),e}(ColumnSeries$c);extend$10(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$e,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$b.prototype.init,invertGroups:noop$e,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$I=Utilities.addEvent,defined$v=Utilities.defined,pick$_=Utilities.pick,ScrollbarAxis=function(){function o(){}return o.compose=function(e,t){if(o.composed.indexOf(e)===-1)o.composed.push(e);else return e;var r=function(n){var s=pick$_(n.options&&n.options.min,n.min),a=pick$_(n.options&&n.options.max,n.max);return{axisMin:s,axisMax:a,scrollMin:defined$v(n.dataMin)?Math.min(s,n.min,n.dataMin,pick$_(n.threshold,1/0)):s,scrollMax:defined$v(n.dataMax)?Math.max(a,n.max,n.dataMax,pick$_(n.threshold,-1/0)):a}};return addEvent$I(e,"afterInit",function(){var n=this;n.options&&n.options.scrollbar&&n.options.scrollbar.enabled&&(n.options.scrollbar.vertical=!n.horiz,n.options.startOnTick=n.options.endOnTick=!1,n.scrollbar=new t(n.chart.renderer,n.options.scrollbar,n.chart),addEvent$I(n.scrollbar,"changed",function(s){var a=r(n),l=a.axisMin,h=a.axisMax,c=a.scrollMin,d=a.scrollMax,f=d-c,p,u;!defined$v(l)||!defined$v(h)||(n.horiz&&!n.reversed||!n.horiz&&n.reversed?(p=c+f*this.to,u=c+f*this.from):(p=c+f*(1-this.from),u=c+f*(1-this.to)),this.shouldUpdateExtremes(s.DOMType)?n.setExtremes(u,p,!0,s.DOMType!=="mousemove"&&s.DOMType!=="touchmove",s):this.setRange(this.from,this.to))}))}),addEvent$I(e,"afterRender",function(){var n=this,s=r(n),a=s.scrollMin,l=s.scrollMax,h=n.scrollbar,c=n.axisTitleMargin+(n.titleOffset||0),d=n.chart.scrollbarsOffsets,f=n.options.margin||0,p,u,g;h&&(n.horiz?(n.opposite||(d[1]+=c),h.position(n.left,n.top+n.height+2+d[1]-(n.opposite?f:0),n.width,n.height),n.opposite||(d[1]+=f),p=1):(n.opposite&&(d[0]+=c),h.position(n.left+n.width+2+d[0]-(n.opposite?0:f),n.top,n.width,n.height),n.opposite&&(d[0]+=f),p=0),d[p]+=h.size+h.options.margin,isNaN(a)||isNaN(l)||!defined$v(n.min)||!defined$v(n.max)||n.min===n.max?h.setRange(0,1):(u=(n.min-a)/(l-a),g=(n.max-a)/(l-a),n.horiz&&!n.reversed||!n.horiz&&n.reversed?h.setRange(u,g):h.setRange(1-g,1-u)))}),addEvent$I(e,"afterGetOffset",function(){var n=this,s=n.horiz?2:1,a=n.scrollbar;a&&(n.chart.scrollbarsOffsets=[0,0],n.chart.axisOffset[s]+=a.size+a.options.margin)}),e},o.composed=[],o}(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$7=DefaultOptions.defaultOptions,addEvent$H=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$u=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$k=Utilities.fireEvent,merge$S=Utilities.merge,pick$Z=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=function(){function o(e,t,r){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(e,t,r)}return o.compose=function(e){ScrollbarAxis.compose(e,o)},o.swapXY=function(e,t){return t&&e.forEach(function(r){for(var n=r.length,s,a=0;a<n;a+=2)s=r[a+1],typeof s=="number"&&(r[a+1]=r[a+2],r[a+2]=s)}),e},o.prototype.addEvents=function(){var e=this.options.inverted?[1,0]:[0,1],t=this.scrollbarButtons,r=this.scrollbarGroup.element,n=this.track.element,s=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),l=this.mouseUpHandler.bind(this),h=[[t[e[0]].element,"click",this.buttonToMinClick.bind(this)],[t[e[1]].element,"click",this.buttonToMaxClick.bind(this)],[n,"click",this.trackClick.bind(this)],[r,"mousedown",s],[r.ownerDocument,"mousemove",a],[r.ownerDocument,"mouseup",l]];H.hasTouch&&h.push([r,"touchstart",s],[r.ownerDocument,"touchmove",a],[r.ownerDocument,"touchend",l]),h.forEach(function(c){addEvent$H.apply(null,c)}),this._events=h},o.prototype.buttonToMaxClick=function(e){var t=this,r=(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(t.from+r,t.to+r),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},o.prototype.buttonToMinClick=function(e){var t=this,r=correctFloat$6(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(correctFloat$6(t.from-r),correctFloat$6(t.to-r)),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},o.prototype.cursorToScrollbarPosition=function(e){var t=this,r=t.options,n=r.minWidth>t.calculatedWidth?r.minWidth:0;return{chartX:(e.chartX-t.x-t.xOffset)/(t.barWidth-n),chartY:(e.chartY-t.y-t.yOffset)/(t.barWidth-n)}},o.prototype.destroy=function(){var e=this,t=e.chart.scroller;e.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(r){e[r]&&e[r].destroy&&(e[r]=e[r].destroy())}),t&&e===t.scrollbar&&(t.scrollbar=null,destroyObjectProperties$3(t.scrollbarButtons))},o.prototype.drawScrollbarButton=function(e){var t=this,r=t.renderer,n=t.scrollbarButtons,s=t.options,a=t.size,l=r.g().add(t.group),h;n.push(l),h=r.rect().addClass("highcharts-scrollbar-button").add(l),t.chart.styledMode||h.attr({stroke:s.buttonBorderColor,"stroke-width":s.buttonBorderWidth,fill:s.buttonBackgroundColor}),h.attr(h.crisp({x:-.5,y:-.5,width:a+1,height:a+1,r:s.buttonBorderRadius},h.strokeWidth())),h=r.path(o.swapXY([["M",a/2+(e?-1:1),a/2-3],["L",a/2+(e?-1:1),a/2+3],["L",a/2+(e?2:-2),a/2]],s.vertical)).addClass("highcharts-scrollbar-arrow").add(n[e]),t.chart.styledMode||h.attr({fill:s.buttonArrowColor})},o.prototype.init=function(e,t,r){var n=this;n.scrollbarButtons=[],n.renderer=e,n.userOptions=t,n.options=merge$S(ScrollbarDefaults,defaultOptions$7.scrollbar,t),n.chart=r,n.size=pick$Z(n.options.size,n.options.height),t.enabled&&(n.render(),n.addEvents())},o.prototype.mouseDownHandler=function(e){var t=this,r=t.chart.pointer.normalize(e),n=t.cursorToScrollbarPosition(r);t.chartX=n.chartX,t.chartY=n.chartY,t.initPositions=[t.from,t.to],t.grabbedCenter=!0},o.prototype.mouseMoveHandler=function(e){var t=this,r=t.chart.pointer.normalize(e),n=t.options,s=n.vertical?"chartY":"chartX",a=t.initPositions||[],l,h,c;t.grabbedCenter&&(!e.touches||e.touches[0][s]!==0)&&(h=t.cursorToScrollbarPosition(r)[s],l=t[s],c=h-l,t.hasDragged=!0,t.updatePosition(a[0]+c,a[1]+c),t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:e.type,DOMEvent:e}))},o.prototype.mouseUpHandler=function(e){var t=this;t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:e.type,DOMEvent:e}),t.grabbedCenter=t.hasDragged=t.chartX=t.chartY=null},o.prototype.position=function(e,t,r,n){var s=this,a=s.options,l=a.vertical,h=s.rendered?"animate":"attr",c=n,d=0;s.x=e,s.y=t+this.trackBorderWidth,s.width=r,s.height=n,s.xOffset=c,s.yOffset=d,l?(s.width=s.yOffset=r=d=s.size,s.xOffset=c=0,s.barWidth=n-r*2,s.x=e=e+s.options.margin):(s.height=s.xOffset=n=c=s.size,s.barWidth=r-n*2,s.y=s.y+s.options.margin),s.group[h]({translateX:e,translateY:s.y}),s.track[h]({width:r,height:n}),s.scrollbarButtons[1][h]({translateX:l?0:r-c,translateY:l?n-d:0})},o.prototype.removeEvents=function(){this._events.forEach(function(e){removeEvent$4.apply(null,e)}),this._events.length=0},o.prototype.render=function(){var e=this,t=e.renderer,r=e.options,n=e.size,s=e.chart.styledMode,a=t.g("scrollbar").attr({zIndex:r.zIndex,translateY:-99999}).add();e.group=a,e.track=t.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:r.trackBorderRadius||0,height:n,width:n}).add(a),s||e.track.attr({fill:r.trackBackgroundColor,stroke:r.trackBorderColor,"stroke-width":r.trackBorderWidth}),e.trackBorderWidth=e.track.strokeWidth(),e.track.attr({y:-this.trackBorderWidth%2/2}),e.scrollbarGroup=t.g().add(a),e.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:n,width:n,r:r.barBorderRadius||0}).add(e.scrollbarGroup),e.scrollbarRifles=t.path(o.swapXY([["M",-3,n/4],["L",-3,2*n/3],["M",0,n/4],["L",0,2*n/3],["M",3,n/4],["L",3,2*n/3]],r.vertical)).addClass("highcharts-scrollbar-rifles").add(e.scrollbarGroup),s||(e.scrollbar.attr({fill:r.barBackgroundColor,stroke:r.barBorderColor,"stroke-width":r.barBorderWidth}),e.scrollbarRifles.attr({stroke:r.rifleColor,"stroke-width":1})),e.scrollbarStrokeWidth=e.scrollbar.strokeWidth(),e.scrollbarGroup.translate(-e.scrollbarStrokeWidth%2/2,-e.scrollbarStrokeWidth%2/2),e.drawScrollbarButton(0),e.drawScrollbarButton(1)},o.prototype.setRange=function(e,t){var r=this,n=r.options,s=n.vertical,a=n.minWidth,l=r.barWidth,h=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$u(l)){var c=l*Math.min(t,1),d,f;e=Math.max(e,0),d=Math.ceil(l*e),r.calculatedWidth=f=correctFloat$6(c-d),f<a&&(d=(l-a+f)*e,f=a);var p=Math.floor(d+r.xOffset+r.yOffset),u=f/2-.5;r.from=e,r.to=t,s?(r.scrollbarGroup[h]({translateY:p}),r.scrollbar[h]({height:f}),r.scrollbarRifles[h]({translateY:u}),r.scrollbarTop=p,r.scrollbarLeft=0):(r.scrollbarGroup[h]({translateX:p}),r.scrollbar[h]({width:f}),r.scrollbarRifles[h]({translateX:u}),r.scrollbarLeft=p,r.scrollbarTop=0),f<=12?r.scrollbarRifles.hide():r.scrollbarRifles.show(!0),n.showFull===!1&&(e<=0&&t>=1?r.group.hide():r.group.show()),r.rendered=!0}},o.prototype.shouldUpdateExtremes=function(e){return pick$Z(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||e==="mouseup"||e==="touchend"||!defined$u(e)},o.prototype.trackClick=function(e){var t=this,r=t.chart.pointer.normalize(e),n=t.to-t.from,s=t.y+t.scrollbarTop,a=t.x+t.scrollbarLeft;t.options.vertical&&r.chartY>s||!t.options.vertical&&r.chartX>a?t.updatePosition(t.from+n,t.to+n):t.updatePosition(t.from-n,t.to-n),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},o.prototype.update=function(e){this.destroy(),this.init(this.chart.renderer,merge$S(!0,this.options,e),this.chart)},o.prototype.updatePosition=function(e,t){t>1&&(e=correctFloat$6(1-correctFloat$6(t-e)),t=1),e<0&&(t=correctFloat$6(t-e),e=0),this.from=e,this.to=t},o.defaultOptions=ScrollbarDefaults,o}();defaultOptions$7.scrollbar=merge$S(!0,Scrollbar.defaultOptions,defaultOptions$7.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$G=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$t=Utilities.defined,isNumber$q=Utilities.isNumber,pick$Y=Utilities.pick,NavigatorAxisAdditions=function(){function o(e){this.axis=e}return o.prototype.destroy=function(){this.axis=void 0},o.prototype.toFixedRange=function(e,t,r,n){var s=this,a=s.axis,l=a.chart,h=l&&l.fixedRange,c=(a.pointRange||0)/2,d=pick$Y(r,a.translate(e,!0,!a.horiz)),f=pick$Y(n,a.translate(t,!0,!a.horiz)),p=h&&(f-d)/h;return defined$t(r)||(d=correctFloat$5(d+c)),defined$t(n)||(f=correctFloat$5(f-c)),p>.7&&p<1.3&&(n?d=f-h:f=d+h),(!isNumber$q(d)||!isNumber$q(f))&&(d=f=void 0),{min:d,max:f}},o}(),NavigatorAxis=function(){function o(){}return o.compose=function(e){e.keepProps.push("navigatorAxis"),addEvent$G(e,"init",function(){var t=this;t.navigatorAxis||(t.navigatorAxis=new NavigatorAxisAdditions(t))}),addEvent$G(e,"zoom",function(t){var r=this,n=r.chart,s=n.options,a=s.navigator,l=r.navigatorAxis,h=s.chart.pinchType,c=s.rangeSelector,d=s.chart.zoomType,f;r.isXAxis&&(a&&a.enabled||c&&c.enabled)&&(d==="y"?t.zoomed=!1:(!isTouchDevice$2&&d==="xy"||isTouchDevice$2&&h==="xy")&&r.options.range&&(f=l.previousZoom,defined$t(t.newMin)?l.previousZoom=[r.min,r.max]:f&&(t.newMin=f[0],t.newMax=f[1],l.previousZoom=void 0))),typeof t.zoomed<"u"&&t.preventDefault()})},o.AdditionsClass=NavigatorAxisAdditions,o}(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$6=DefaultOptions.defaultOptions,seriesTypes$5=SeriesRegistry$1.seriesTypes,addEvent$F=Utilities.addEvent,clamp$a=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$s=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$$=Utilities.extend,find$c=Utilities.find,isArray$8=Utilities.isArray,isNumber$p=Utilities.isNumber,merge$R=Utilities.merge,pick$X=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$9=Utilities.splat,defaultSeriesType,numExt=function(o){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];var r=[].filter.call(e,isNumber$p);if(r.length)return Math[o].apply(0,r)};defaultSeriesType=typeof seriesTypes$5.areaspline>"u"?"line":"areaspline";extend$$(defaultOptions$6,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(o,e,t,r,n){var s=(n&&n.width||0)/2,a=Math.round(s/3)+.5,l=n&&n.height||0;return[["M",-s-1,.5],["L",s,.5],["L",s,l+.5],["L",-s-1,l+.5],["L",-s-1,.5],["M",-a,4],["L",-a,l-3],["M",a-1,4],["L",a-1,l-3]]};var Navigator=function(){function o(e){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(e)}return o.prototype.drawHandle=function(e,t,r,n){var s=this,a=s.navigatorOptions.handles.height;s.handles[t][n](r?{translateX:Math.round(s.left+s.height/2),translateY:Math.round(s.top+parseInt(e,10)+.5-a)}:{translateX:Math.round(s.left+parseInt(e,10)),translateY:Math.round(s.top+s.height/2-a/2-1)})},o.prototype.drawOutline=function(e,t,r,n){var s=this,a=s.navigatorOptions.maskInside,l=s.outline.strokeWidth(),h=l/2,c=l%2/2,d=s.outlineHeight,f=s.scrollbarHeight||0,p=s.size,u=s.left-f,g=s.top,v,y;r?(u-=h,v=g+t+c,t=g+e+c,y=[["M",u+d,g-f-c],["L",u+d,v],["L",u,v],["L",u,t],["L",u+d,t],["L",u+d,g+p+f]],a&&y.push(["M",u+d,v-h],["L",u+d,t+h])):(e+=u+f-c,t+=u+f-c,g+=h,y=[["M",u,g],["L",e,g],["L",e,g+d],["L",t,g+d],["L",t,g],["L",u+p+f*2,g]],a&&y.push(["M",e-h,g],["L",t+h,g])),s.outline[n]({d:y})},o.prototype.drawMasks=function(e,t,r,n){var s=this,a=s.left,l=s.top,h=s.height,c,d,f,p;r?(f=[a,a,a],p=[l,l+e,l+t],d=[h,h,h],c=[e,t-e,s.size-t]):(f=[a,a+e,a+t],p=[l,l,l],d=[e,t-e,s.size-t],c=[h,h,h]),s.shades.forEach(function(u,g){u[n]({x:f[g],y:p[g],width:d[g],height:c[g]})})},o.prototype.renderElements=function(){var e=this,t=e.navigatorOptions,r=t.maskInside,n=e.chart,s=n.inverted,a=n.renderer,l,h={cursor:s?"ns-resize":"ew-resize"};e.navigatorGroup=l=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!r,r,!r].forEach(function(c,d){e.shades[d]=a.rect().addClass("highcharts-navigator-mask"+(d===1?"-inside":"-outside")).add(l),n.styledMode||e.shades[d].attr({fill:c?t.maskFill:"rgba(0,0,0,0)"}).css(d===1&&h)}),e.outline=a.path().addClass("highcharts-navigator-outline").add(l),n.styledMode||e.outline.attr({"stroke-width":t.outlineWidth,stroke:t.outlineColor}),t.handles.enabled&&[0,1].forEach(function(c){if(t.handles.inverted=n.inverted,e.handles[c]=a.symbol(t.handles.symbols[c],-t.handles.width/2-1,0,t.handles.width,t.handles.height,t.handles),e.handles[c].attr({zIndex:7-c}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][c]).add(l),!n.styledMode){var d=t.handles;e.handles[c].attr({fill:d.backgroundColor,stroke:d.borderColor,"stroke-width":d.lineWidth}).css(h)}})},o.prototype.update=function(e){(this.series||[]).forEach(function(r){r.baseSeries&&delete r.baseSeries.navigatorSeries}),this.destroy();var t=this.chart.options;merge$R(!0,t.navigator,this.options,e),this.init(this.chart)},o.prototype.render=function(e,t,r,n){var s=this,a=s.chart,l,h,c,d=s.scrollbarHeight,f,p=s.xAxis,u=p.pointRange||0,g=p.navigatorAxis.fake?a.xAxis[0]:p,v=s.navigatorEnabled,y,m,x=s.rendered,b=a.inverted,$,S,k,A,M=a.xAxis[0].minRange,P=a.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$s(r))){if(e=correctFloat$4(e-u/2),t=correctFloat$4(t+u/2),!isNumber$p(e)||!isNumber$p(t))if(x)r=0,n=pick$X(p.width,g.width);else return;s.left=pick$X(p.left,a.plotLeft+d+(b?a.plotWidth:0)),s.size=m=f=pick$X(p.len,(b?a.plotHeight:a.plotWidth)-2*d),b?l=d:l=f+2*d,r=pick$X(r,p.toPixels(e,!0)),n=pick$X(n,p.toPixels(t,!0)),(!isNumber$p(r)||Math.abs(r)===1/0)&&(r=0,n=l),S=p.toValue(r,!0),k=p.toValue(n,!0),A=Math.abs(correctFloat$4(k-S)),A<M?this.grabbedLeft?r=p.toPixels(k-M-u,!0):this.grabbedRight&&(n=p.toPixels(S+M+u,!0)):defined$s(P)&&correctFloat$4(A-u)>P&&(this.grabbedLeft?r=p.toPixels(k-P-u,!0):this.grabbedRight&&(n=p.toPixels(S+P+u,!0))),s.zoomedMax=clamp$a(Math.max(r,n),0,m),s.zoomedMin=clamp$a(s.fixedWidth?s.zoomedMax-s.fixedWidth:Math.min(r,n),0,m),s.range=s.zoomedMax-s.zoomedMin,m=Math.round(s.zoomedMax),y=Math.round(s.zoomedMin),v&&(s.navigatorGroup.attr({visibility:"visible"}),$=x&&!s.hasDragged?"animate":"attr",s.drawMasks(y,m,b,$),s.drawOutline(y,m,b,$),s.navigatorOptions.handles.enabled&&(s.drawHandle(y,0,b,$),s.drawHandle(m,1,b,$))),s.scrollbar&&(b?(c=s.top-d,h=s.left-d+(v||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),d=f+2*d):(c=s.top+(v?s.height:-d),h=s.left-d),s.scrollbar.position(h,c,l,d),s.scrollbar.setRange(s.zoomedMin/(f||1),s.zoomedMax/(f||1))),s.rendered=!0}},o.prototype.addMouseEvents=function(){var e=this,t=e.chart,r=t.container,n=[],s,a;e.mouseMoveHandler=s=function(l){e.onMouseMove(l)},e.mouseUpHandler=a=function(l){e.onMouseUp(l)},n=e.getPartsEvents("mousedown"),n.push(addEvent$F(t.renderTo,"mousemove",s),addEvent$F(r.ownerDocument,"mouseup",a)),hasTouch&&(n.push(addEvent$F(t.renderTo,"touchmove",s),addEvent$F(r.ownerDocument,"touchend",a)),n.concat(e.getPartsEvents("touchstart"))),e.eventsToUnbind=n,e.series&&e.series[0]&&n.push(addEvent$F(e.series[0].xAxis,"foundExtremes",function(){t.navigator.modifyNavigatorAxisExtremes()}))},o.prototype.getPartsEvents=function(e){var t=this,r=[];return["shades","handles"].forEach(function(n){t[n].forEach(function(s,a){r.push(addEvent$F(s.element,e,function(l){t[n+"Mousedown"](l,a)}))})}),r},o.prototype.shadesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var r=this,n=r.chart,s=r.xAxis,a=r.zoomedMin,l=r.left,h=r.size,c=r.range,d=e.chartX,f,p,u,g;n.inverted&&(d=e.chartY,l=r.top),t===1?(r.grabbedCenter=d,r.fixedWidth=c,r.dragOffset=d-a):(g=d-l-c/2,t===0?g=Math.max(0,g):t===2&&g+c>=h&&(g=h-c,r.reversedExtremes?(g-=c,p=r.getUnionExtremes().dataMin):f=r.getUnionExtremes().dataMax),g!==a&&(r.fixedWidth=c,u=s.navigatorAxis.toFixedRange(g,g+c,p,f),defined$s(u.min)&&n.xAxis[0].setExtremes(Math.min(u.min,u.max),Math.max(u.min,u.max),!0,null,{trigger:"navigator"})))},o.prototype.handlesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var r=this,n=r.chart,s=n.xAxis[0],a=r.reversedExtremes;t===0?(r.grabbedLeft=!0,r.otherHandlePos=r.zoomedMax,r.fixedExtreme=a?s.min:s.max):(r.grabbedRight=!0,r.otherHandlePos=r.zoomedMin,r.fixedExtreme=a?s.max:s.min),n.fixedRange=null},o.prototype.onMouseMove=function(e){var t=this,r=t.chart,n=t.left,s=t.navigatorSize,a=t.range,l=t.dragOffset,h=r.inverted,c;(!e.touches||e.touches[0].pageX!==0)&&(e=r.pointer.normalize(e),c=e.chartX,h&&(n=t.top,c=e.chartY),t.grabbedLeft?(t.hasDragged=!0,t.render(0,0,c-n,t.otherHandlePos)):t.grabbedRight?(t.hasDragged=!0,t.render(0,0,t.otherHandlePos,c-n)):t.grabbedCenter&&(t.hasDragged=!0,c<l?c=l:c>s+l-a&&(c=s+l-a),t.render(0,0,c-l,c-l+a)),t.hasDragged&&t.scrollbar&&pick$X(t.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(e.DOMType=e.type,setTimeout(function(){t.onMouseUp(e)},0)))},o.prototype.onMouseUp=function(e){var t=this,r=t.chart,n=t.xAxis,s=t.scrollbar,a=e.DOMEvent||e,l=r.inverted,h=t.rendered&&!t.hasDragged?"animate":"attr",c,d,f,p,u,g;(t.hasDragged&&(!s||!s.hasDragged)||e.trigger==="scrollbar")&&(f=t.getUnionExtremes(),t.zoomedMin===t.otherHandlePos?p=t.fixedExtreme:t.zoomedMax===t.otherHandlePos&&(u=t.fixedExtreme),t.zoomedMax===t.size&&(u=t.reversedExtremes?f.dataMin:f.dataMax),t.zoomedMin===0&&(p=t.reversedExtremes?f.dataMax:f.dataMin),g=n.navigatorAxis.toFixedRange(t.zoomedMin,t.zoomedMax,p,u),defined$s(g.min)&&r.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,t.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:a})),e.DOMType!=="mousemove"&&e.DOMType!=="touchmove"&&(t.grabbedLeft=t.grabbedRight=t.grabbedCenter=t.fixedWidth=t.fixedExtreme=t.otherHandlePos=t.hasDragged=t.dragOffset=null),t.navigatorEnabled&&isNumber$p(t.zoomedMin)&&isNumber$p(t.zoomedMax)&&(d=Math.round(t.zoomedMin),c=Math.round(t.zoomedMax),t.shades&&t.drawMasks(d,c,l,h),t.outline&&t.drawOutline(d,c,l,h),t.navigatorOptions.handles.enabled&&Object.keys(t.handles).length===t.handles.length&&(t.drawHandle(d,0,l,h),t.drawHandle(c,1,l,h)))},o.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(e){e()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},o.prototype.removeBaseSeriesEvents=function(){var e=this.baseSeries||[];this.navigatorEnabled&&e[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&e.forEach(function(t){removeEvent$3(t,"updatedData",this.updatedDataHandler)},this),e[0].xAxis&&removeEvent$3(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},o.prototype.init=function(e){var t=e.options,r=t.navigator,n=r.enabled,s=t.scrollbar,a=s.enabled,l=n?r.height:0,h=a?s.height:0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=l,this.scrollbarHeight=h,this.scrollbarEnabled=a,this.navigatorEnabled=n,this.navigatorOptions=r,this.scrollbarOptions=s,this.outlineHeight=l+h,this.opposite=pick$X(r.opposite,!!(!n&&e.inverted));var c=this,d=c.baseSeries,f=e.xAxis.length,p=e.yAxis.length,u=d&&d[0]&&d[0].xAxis||e.xAxis[0]||{options:{}};e.isDirtyBox=!0,c.navigatorEnabled?(c.xAxis=new Axis(e,merge$R({breaks:u.options.breaks,ordinal:u.options.ordinal},r.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:f,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[h,0,-h,0],width:l}:{offsets:[0,-h,0,h],height:l})),c.yAxis=new Axis(e,merge$R(r.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:p,isInternal:!0,reversed:pick$X(r.yAxis&&r.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:l}:{height:l})),d||r.series.data?c.updateNavigatorSeries(!1):e.series.length===0&&(c.unbindRedraw=addEvent$F(e,"beforeRedraw",function(){e.series.length>0&&!c.series&&(c.setBaseSeries(),c.unbindRedraw())})),c.reversedExtremes=e.inverted&&!c.xAxis.reversed||!e.inverted&&c.xAxis.reversed,c.renderElements(),c.addMouseEvents()):(c.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(g,v){var y=e.xAxis[0],m=y.getExtremes(),x=y.len-2*h,b=numExt("min",y.options.min,m.dataMin),$=numExt("max",y.options.max,m.dataMax)-b;return v?g*$/x+b:x*(g-b)/$},toPixels:function(g){return this.translate(g)},toValue:function(g){return this.translate(g,!0)}},c.xAxis.navigatorAxis.axis=c.xAxis,c.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(c.xAxis.navigatorAxis)),e.options.scrollbar.enabled&&(e.scrollbar=c.scrollbar=new Scrollbar(e.renderer,merge$R(e.options.scrollbar,{margin:c.navigatorEnabled?0:10,vertical:e.inverted}),e),addEvent$F(c.scrollbar,"changed",function(g){var v=c.size,y=v*this.to,m=v*this.from;c.hasDragged=c.scrollbar.hasDragged,c.render(0,0,m,y),this.shouldUpdateExtremes(g.DOMType)&&setTimeout(function(){c.onMouseUp(g)})})),c.addBaseSeriesEvents(),c.addChartEvents()},o.prototype.getUnionExtremes=function(e){var t=this.chart.xAxis[0],r=this.xAxis,n=r.options,s=t.options,a;return(!e||t.dataMin!==null)&&(a={dataMin:pick$X(n&&n.min,numExt("min",s.min,t.dataMin,r.dataMin,r.min)),dataMax:pick$X(n&&n.max,numExt("max",s.max,t.dataMax,r.dataMax,r.max))}),a},o.prototype.setBaseSeries=function(e,t){var r=this.chart,n=this.baseSeries=[];e=e||r.options&&r.options.navigator.baseSeries||(r.series.length?find$c(r.series,function(s){return!s.options.isInternal}).index:0),(r.series||[]).forEach(function(s,a){!s.options.isInternal&&(s.options.showInNavigator||(a===e||s.options.id===e)&&s.options.showInNavigator!==!1)&&n.push(s)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,t)},o.prototype.updateNavigatorSeries=function(e,t){var r=this,n=r.chart,s=r.baseSeries,a,l,h=r.navigatorOptions.series,c,d={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},f=r.series=(r.series||[]).filter(function(p){var u=p.baseSeries;return s.indexOf(u)<0?(u&&(removeEvent$3(u,"updatedData",r.updatedDataHandler),delete u.navigatorSeries),p.chart&&p.destroy(),!1):!0});s&&s.length&&s.forEach(function(u){var g=u.navigatorSeries,v=extend$$({color:u.color,visible:u.visible},isArray$8(h)?defaultOptions$6.navigator.series:h);if(!(g&&r.navigatorOptions.adaptToUpdatedData===!1)){d.name="Navigator "+s.length,a=u.options||{},c=a.navigatorOptions||{},v.dataLabels=splat$9(v.dataLabels),l=merge$R(a,d,v,c),l.pointRange=pick$X(v.pointRange,c.pointRange,defaultOptions$6.plotOptions[l.type||"line"].pointRange);var y=c.data||v.data;r.hasNavigatorData=r.hasNavigatorData||!!y,l.data=y||a.data&&a.data.slice(0),g&&g.options?g.update(l,t):(u.navigatorSeries=n.initSeries(l),u.navigatorSeries.baseSeries=u,f.push(u.navigatorSeries))}}),(h.data&&!(s&&s.length)||isArray$8(h))&&(r.hasNavigatorData=!1,h=splat$9(h),h.forEach(function(p,u){d.name="Navigator "+(f.length+1),l=merge$R(defaultOptions$6.navigator.series,{color:n.series[u]&&!n.series[u].options.isInternal&&n.series[u].color||n.options.colors[u]||n.options.colors[0]},d,p),l.data=p.data,l.data&&(r.hasNavigatorData=!0,f.push(n.initSeries(l)))})),e&&this.addBaseSeriesEvents()},o.prototype.addBaseSeriesEvents=function(){var e=this,t=e.baseSeries||[];t[0]&&t[0].xAxis&&t[0].eventsToUnbind.push(addEvent$F(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),t.forEach(function(r){r.eventsToUnbind.push(addEvent$F(r,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),r.eventsToUnbind.push(addEvent$F(r,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&r.xAxis&&r.eventsToUnbind.push(addEvent$F(r,"updatedData",this.updatedDataHandler)),r.eventsToUnbind.push(addEvent$F(r,"remove",function(){this.navigatorSeries&&(erase$1(e.series,this.navigatorSeries),defined$s(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},o.prototype.getBaseSeriesMin=function(e){return this.baseSeries.reduce(function(t,r){return Math.min(t,r.xData?r.xData[0]:t)},e)},o.prototype.modifyNavigatorAxisExtremes=function(){var e=this.xAxis,t;typeof e.getExtremes<"u"&&(t=this.getUnionExtremes(!0),t&&(t.dataMin!==e.min||t.dataMax!==e.max)&&(e.min=t.dataMin,e.max=t.dataMax))},o.prototype.modifyBaseAxisExtremes=function(){var e=this,t=e.chart.navigator,r=e.getExtremes(),n=r.min,s=r.max,a=r.dataMin,l=r.dataMax,h=s-n,c=t.stickToMin,d=t.stickToMax,f=pick$X(e.options.overscroll,0),p,u,g=t.series&&t.series[0],v=!!e.setExtremes,y=e.eventArgs&&e.eventArgs.trigger==="rangeSelectorButton";y||(c&&(u=a,p=u+h),d&&(p=l+f,c||(u=Math.max(a,p-h,t.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE)))),v&&(c||d)&&isNumber$p(u)&&(e.min=e.userMin=u,e.max=e.userMax=p)),t.stickToMin=t.stickToMax=null},o.prototype.updatedDataHandler=function(){var e=this.chart.navigator,t=this,r=this.navigatorSeries;e.stickToMax=e.reversedExtremes?Math.round(e.zoomedMin)===0:Math.round(e.zoomedMax)>=Math.round(e.size),e.stickToMin=e.shouldStickToMin(t,e),r&&!e.hasNavigatorData&&(r.options.pointStart=t.xData[0],r.setData(t.options.data,!1,null,!1))},o.prototype.shouldStickToMin=function(e,t){var r=t.getBaseSeriesMin(e.xData[0]),n=e.xAxis,s=n.max,a=n.min,l=n.options.range,h=!0;return isNumber$p(s)&&isNumber$p(a)?l&&s-r>0?h=s-r<l&&!this.chart.fixedRange:h=a<=r:h=!1,h},o.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$F(this.chart,"redraw",function(){var e=this.navigator,t=e&&(e.baseSeries&&e.baseSeries[0]&&e.baseSeries[0].xAxis||this.xAxis[0]);t&&e.render(t.min,t.max)}),addEvent$F(this.chart,"getMargins",function(){var e=this,t=e.navigator,r=t.opposite?"plotTop":"marginBottom";e.inverted&&(r=t.opposite?"marginRight":"plotLeft"),e[r]=(e[r]||0)+(t.navigatorEnabled||!e.inverted?t.outlineHeight:0)+t.navigatorOptions.margin}))},o.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$1(this.chart.xAxis,this.xAxis),erase$1(this.chart.axes,this.xAxis)),this.yAxis&&(erase$1(this.chart.yAxis,this.yAxis),erase$1(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(e){e.destroy&&e.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(e){this[e]&&this[e].destroy&&this[e].destroy(),this[e]=null},this),[this.handles].forEach(function(e){destroyObjectProperties$2(e)},this)},o}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$F(Chart$1,"beforeShowResetZoom",function(){var o=this.options,e=o.navigator,t=o.rangeSelector;if((e&&e.enabled||t&&t.enabled)&&(!isTouchDevice$1&&o.chart.zoomType==="x"||isTouchDevice$1&&o.chart.pinchType==="x"))return!1}),addEvent$F(Chart$1,"beforeRender",function(){var o=this.options;(o.navigator.enabled||o.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$F(Chart$1,"afterSetChartSize",function(){var o=this.legend,e=this.navigator,t,r,n,s;e&&(r=o&&o.options,n=e.xAxis,s=e.yAxis,t=e.scrollbarHeight,this.inverted?(e.left=e.opposite?this.chartWidth-t-e.height:this.spacing[3]+t,e.top=this.plotTop+t):(e.left=pick$X(n.left,this.plotLeft+t),e.top=e.navigatorOptions.top||this.chartHeight-e.height-t-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(r&&r.verticalAlign==="bottom"&&r.layout!=="proximate"&&r.enabled&&!r.floating?o.legendHeight+pick$X(r.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),n&&s&&(this.inverted?n.options.left=s.options.left=e.left:n.options.top=s.options.top=e.top,n.setAxisSize(),s.setAxisSize()))}),addEvent$F(Chart$1,"update",function(o){var e=o.options.navigator||{},t=o.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||t.enabled)&&(merge$R(!0,this.options.navigator,e),merge$R(!0,this.options.scrollbar,t),delete o.options.navigator,delete o.options.scrollbar)}),addEvent$F(Chart$1,"afterUpdate",function(o){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$X(o.redraw,!0)&&this.redraw(o.animation))}),addEvent$F(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$F(Series$e,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(o){var e,t=o.navigator;t&&o.xAxis[0]&&(e=o.xAxis[0].getExtremes(),t.render(e.min,e.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$5=DefaultOptions.defaultOptions,addEvent$E=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$r=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$_=Utilities.extend,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent,isNumber$o=Utilities.isNumber,merge$Q=Utilities.merge,objectEach$d=Utilities.objectEach,pad=Utilities.pad,pick$W=Utilities.pick,pInt$3=Utilities.pInt,splat$8=Utilities.splat;extend$_(defaultOptions$5,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$_(defaultOptions$5.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=function(){function o(e){this.buttons=void 0,this.buttonOptions=o.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=e,this.init(e)}return o.prototype.clickButton=function(e,t){var r=this,n=r.chart,s=r.buttonOptions[e],a=n.xAxis[0],l=n.scroller&&n.scroller.getUnionExtremes()||a||{},h=l.dataMin,c=l.dataMax,d,f=a&&Math.round(Math.min(a.max,pick$W(c,a.max))),p=s.type,u,g=s._range,v,y,m,x,b,$=s.dataGrouping;if(!(h===null||c===null)){if(n.fixedRange=g,r.setSelected(e),$&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(a||{chart:this.chart},$,!1),this.frozenStates=s.preserveDataGrouping),p==="month"||p==="year")a?(x={range:s,max:f,chart:n,dataMin:h,dataMax:c},d=a.minFromRange.call(x),isNumber$o(x.newMax)&&(f=x.newMax)):g=s;else if(g)d=Math.max(f-g,h),f=Math.min(d+g,c);else if(p==="ytd")if(a)typeof c>"u"&&(h=Number.MAX_VALUE,c=Number.MIN_VALUE,n.series.forEach(function(S){var k=S.xData;h=Math.min(k[0],h),c=Math.max(k[k.length-1],c)}),t=!1),b=r.getYTDExtremes(c,h,n.time.useUTC),d=v=b.min,f=b.max;else{r.deferredYTDClick=e;return}else p==="all"&&a&&(n.navigator&&n.navigator.baseSeries[0]&&(n.navigator.baseSeries[0].xAxis.options.range=void 0),d=h,f=c);defined$r(d)&&(d+=s._offsetMin),defined$r(f)&&(f+=s._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=e+1),a?a.setExtremes(d,f,pick$W(t,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:s}):(u=splat$8(n.options.xAxis)[0],m=u.range,u.range=g,y=u.min,u.min=v,addEvent$E(n,"load",function(){u.range=m,u.min=y})),fireEvent$j(this,"afterBtnClick")}},o.prototype.setSelected=function(e){this.selected=this.options.selected=e},o.prototype.init=function(e){var t=this,r=e.options.rangeSelector,n=r.buttons||t.defaultButtons.slice(),s=r.selected,a=function(){var l=t.minInput,h=t.maxInput;l&&l.blur&&fireEvent$j(l,"blur"),h&&h.blur&&fireEvent$j(h,"blur")};t.chart=e,t.options=r,t.buttons=[],t.buttonOptions=n,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$E(e.container,"mousedown",a)),this.eventsToUnbind.push(addEvent$E(e,"resize",a)),n.forEach(t.computeButtonRange),typeof s<"u"&&n[s]&&this.clickButton(s,!1),this.eventsToUnbind.push(addEvent$E(e,"load",function(){e.xAxis&&e.xAxis[0]&&addEvent$E(e.xAxis[0],"setExtremes",function(l){this.max-this.min!==e.fixedRange&&l.trigger!=="rangeSelectorButton"&&l.trigger!=="updatedData"&&t.forcedDataGrouping&&!t.frozenStates&&this.setDataGrouping(!1,!1)})}))},o.prototype.updateButtonStates=function(){var e=this,t=this.chart,r=this.dropdown,n=t.xAxis[0],s=Math.round(n.max-n.min),a=!n.hasVisibleSeries,l=24*36e5,h=t.scroller&&t.scroller.getUnionExtremes()||n,c=h.dataMin,d=h.dataMax,f=e.getYTDExtremes(d,c,t.time.useUTC),p=f.min,u=f.max,g=e.selected,v=isNumber$o(g),y=e.options.allButtonsEnabled,m=e.buttons;e.buttonOptions.forEach(function(x,b){var $=x._range,S=x.type,k=x.count||1,A=m[b],M=0,P,E,T=x._offsetMax-x._offsetMin,O=b===g,C=$>d-c,I=$<n.minRange,L=!1,D=!1,N=$===s;(S==="month"||S==="year")&&s+36e5>={month:28,year:365}[S]*l*k-T&&s-36e5<={month:31,year:366}[S]*l*k+T?N=!0:S==="ytd"?(N=u-p+T===s,L=!O):S==="all"&&(N=n.max-n.min>=d-c,D=!O&&v&&N),P=!y&&(C||I||D||a),E=O&&N||N&&!v&&!L||O&&e.frozenStates,P?M=3:E&&(v=!0,M=2),A.state!==M&&(A.setState(M),r&&(r.options[b+1].disabled=P,M===2&&(r.selectedIndex=b+1)),M===0&&g===b&&e.setSelected())})},o.prototype.computeButtonRange=function(e){var t=e.type,r=e.count||1,n={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:7*24*3600*1e3};n[t]?e._range=n[t]*r:(t==="month"||t==="year")&&(e._range={month:30,year:365}[t]*24*36e5*r),e._offsetMin=pick$W(e.offsetMin,0),e._offsetMax=pick$W(e.offsetMax,0),e._range+=e._offsetMax-e._offsetMin},o.prototype.getInputValue=function(e){var t=e==="min"?this.minInput:this.maxInput,r=this.chart.options.rangeSelector,n=this.chart.time;return t?(t.type==="text"&&r.inputDateParser||this.defaultInputDateParser)(t.value,n.useUTC,n):0},o.prototype.setInputValue=function(e,t){var r=this.options,n=this.chart.time,s=e==="min"?this.minInput:this.maxInput,a=e==="min"?this.minDateBox:this.maxDateBox;if(s){var l=s.getAttribute("data-hc-time"),h=defined$r(l)?Number(l):void 0;if(defined$r(t)){var c=h;defined$r(c)&&s.setAttribute("data-hc-time-previous",c),s.setAttribute("data-hc-time",t),h=t}s.value=n.dateFormat(this.inputTypeFormats[s.type]||r.inputEditDateFormat,h),a&&a.attr({text:n.dateFormat(r.inputDateFormat,h)})}},o.prototype.setInputExtremes=function(e,t,r){var n=e==="min"?this.minInput:this.maxInput;if(n){var s=this.inputTypeFormats[n.type],a=this.chart.time;if(s){var l=a.dateFormat(s,t);n.min!==l&&(n.min=l);var h=a.dateFormat(s,r);n.max!==h&&(n.max=h)}}},o.prototype.showInput=function(e){var t=e==="min"?this.minDateBox:this.maxDateBox,r=e==="min"?this.minInput:this.maxInput;if(r&&t&&this.inputGroup){var n=r.type==="text",s=this.inputGroup,a=s.translateX,l=s.translateY,h=this.options.inputBoxWidth;css$2(r,{width:n?t.width+(h?-2:20)+"px":"auto",height:n?t.height-2+"px":"auto",border:"2px solid silver"}),n&&h?css$2(r,{left:a+t.x+"px",top:l+"px"}):css$2(r,{left:Math.min(Math.round(t.x+a-(r.offsetWidth-t.width)/2),this.chart.chartWidth-r.offsetWidth)+"px",top:l-(r.offsetHeight-t.height)/2+"px"})}},o.prototype.hideInput=function(e){var t=e==="min"?this.minInput:this.maxInput;t&&css$2(t,{top:"-9999em",border:0,width:"1px",height:"1px"})},o.prototype.defaultInputDateParser=function(e,t,r){var n=function(c){return c.length>6&&(c.lastIndexOf("-")===c.length-6||c.lastIndexOf("+")===c.length-6)},s=e.split("/").join("-").split(" ").join("T");if(s.indexOf("T")===-1&&(s+="T00:00"),t)s+="Z";else if(H.isSafari&&!n(s)){var a=new Date(s).getTimezoneOffset()/60;s+=a<=0?"+"+pad(-a)+":00":"-"+pad(a)+":00"}var l=Date.parse(s);if(!isNumber$o(l)){var h=e.split("-");l=Date.UTC(pInt$3(h[0]),pInt$3(h[1])-1,pInt$3(h[2]))}return r&&t&&isNumber$o(l)&&(l+=r.getTimezoneOffset(l)),l},o.prototype.drawInput=function(e){var t=this,r=t.chart,n=t.div,s=t.inputGroup,a=this,l=r.renderer.style||{},h=r.renderer,c=r.options.rangeSelector,d=defaultOptions$5.lang,f=e==="min";function p(){var x=a.getInputValue(e),b=r.xAxis[0],$=r.scroller&&r.scroller.xAxis?r.scroller.xAxis:b,S=$.dataMin,k=$.dataMax,A=a.maxInput,M=a.minInput;x!==Number(y.getAttribute("data-hc-time-previous"))&&isNumber$o(x)&&(y.setAttribute("data-hc-time-previous",x),f&&A&&isNumber$o(S)?x>Number(A.getAttribute("data-hc-time"))?x=void 0:x<S&&(x=S):M&&isNumber$o(k)&&(x<Number(M.getAttribute("data-hc-time"))?x=void 0:x>k&&(x=k)),typeof x<"u"&&b.setExtremes(f?x:b.min,f?b.max:x,void 0,void 0,{trigger:"rangeSelectorInput"}))}var u=d[f?"rangeSelectorFrom":"rangeSelectorTo"]||"",g=h.label(u,0).addClass("highcharts-range-label").attr({padding:u?2:0,height:u?c.inputBoxHeight:0}).add(s),v=h.label("",0).addClass("highcharts-range-input").attr({padding:2,width:c.inputBoxWidth,height:c.inputBoxHeight,"text-align":"center"}).on("click",function(){a.showInput(e),a[e+"Input"].focus()});r.styledMode||v.attr({stroke:c.inputBoxBorderColor,"stroke-width":1}),v.add(s);var y=createElement$3("input",{name:e,className:"highcharts-range-selector"},void 0,n);y.setAttribute("type",preferredInputType(c.inputDateFormat||"%b %e, %Y")),r.styledMode||(g.css(merge$Q(l,c.labelStyle)),v.css(merge$Q({color:palette.neutralColor80},l,c.inputStyle)),css$2(y,extend$_({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:l.fontSize,fontFamily:l.fontFamily,top:"-9999em"},c.inputStyle))),y.onfocus=function(){a.showInput(e)},y.onblur=function(){y===H.doc.activeElement&&p(),a.hideInput(e),a.setInputValue(e),y.blur()};var m=!1;return y.onchange=function(){m||(p(),a.hideInput(e),y.blur())},y.onkeypress=function(x){x.keyCode===13&&p()},y.onkeydown=function(x){m=!0,(x.keyCode===38||x.keyCode===40)&&p()},y.onkeyup=function(){m=!1},{dateBox:v,input:y,label:g}},o.prototype.getPosition=function(){var e=this.chart,t=e.options.rangeSelector,r=t.verticalAlign==="top"?e.plotTop-e.axisOffset[0]:0;return{buttonTop:r+t.buttonPosition.y,inputTop:r+t.inputPosition.y-10}},o.prototype.getYTDExtremes=function(e,t,r){var n=this.chart.time,s,a=new n.Date(e),l=n.get("FullYear",a),h=r?n.Date.UTC(l,0,1):+new n.Date(l,0,1);s=Math.max(t,h);var c=a.getTime();return{max:Math.min(e||c,c),min:s}},o.prototype.render=function(e,t){var r=this.chart,n=r.renderer,s=r.container,a=r.options,l=a.rangeSelector,h=pick$W(a.chart.style&&a.chart.style.zIndex,0)+1,c=l.inputEnabled,d=this.rendered;if(l.enabled!==!1){if(!d&&(this.group=n.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:h}),this.buttonOptions.length&&this.renderButtons(),s.parentNode&&s.parentNode.insertBefore(this.div,s),c)){this.inputGroup=n.g("input-group").add(this.group);var f=this.drawInput("min");this.minDateBox=f.dateBox,this.minLabel=f.label,this.minInput=f.input;var p=this.drawInput("max");this.maxDateBox=p.dateBox,this.maxLabel=p.label,this.maxInput=p.input}if(c){this.setInputValue("min",e),this.setInputValue("max",t);var u=r.scroller&&r.scroller.getUnionExtremes()||r.xAxis[0]||{};if(defined$r(u.dataMin)&&defined$r(u.dataMax)){var g=r.xAxis[0].minRange||0;this.setInputExtremes("min",u.dataMin,Math.min(u.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(u.dataMin,this.getInputValue("min"))+g,u.dataMax)}if(this.inputGroup){var v=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(y){if(y){var m=y.getBBox().width;m&&(y.attr({x:v}),v+=m+l.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},o.prototype.renderButtons=function(){var e=this,t=this,r=t.buttons,n=t.chart,s=t.options,a=defaultOptions$5.lang,l=n.renderer,h=merge$Q(s.buttonTheme),c=h&&h.states,d=h.width||28;delete h.width,delete h.states,this.buttonGroup=l.g("range-selector-buttons").add(this.group);var f=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$E(f,"touchstart",function(){f.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(p){var u=p[0],g=p[1];addEvent$E(f,u,function(){var v=r[e.currentButtonIndex()];v&&fireEvent$j(v.element,g||u)})}),this.zoomText=l.label(a&&a.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),h["stroke-width"]=pick$W(h["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,f),this.buttonOptions.forEach(function(p,u){createElement$3("option",{textContent:p.title||p.text},void 0,f),r[u]=l.button(p.text,0,0,function(g){var v=p.events&&p.events.click,y;v&&(y=v.call(p,g)),y!==!1&&e.clickButton(u),e.isActive=!0},h,c&&c.hover,c&&c.select,c&&c.disabled).attr({"text-align":"center",width:d}).add(e.buttonGroup),p.title&&r[u].attr("title",p.title)})},o.prototype.alignElements=function(){var e=this,t=this,r=t.buttonGroup,n=t.buttons,s=t.chart,a=t.group,l=t.inputGroup,h=t.options,c=t.zoomText,d=s.options,f=d.exporting&&d.exporting.enabled!==!1&&d.navigation&&d.navigation.buttonOptions,p=h.buttonPosition,u=h.inputPosition,g=h.verticalAlign,v=function(I,L){return f&&e.titleCollision(s)&&g==="top"&&L.align==="right"&&L.y-I.getBBox().height-12<(f.y||0)+(f.height||0)+s.spacing[0]?-40:0},y=s.plotLeft;if(a&&p&&u){var m=p.x-s.spacing[3];if(r){if(this.positionButtons(),!this.initialButtonGroupWidth){var x=0;c&&(x+=c.getBBox().width+5),n.forEach(function(I,L){x+=I.width,L!==n.length-1&&(x+=h.buttonSpacing)}),this.initialButtonGroupWidth=x}y-=s.spacing[3],this.updateButtonStates();var b=v(r,p);this.alignButtonGroup(b),a.placed=r.placed=s.hasLoaded}var $=0;l&&($=v(l,u),u.align==="left"?m=y:u.align==="right"&&(m=-Math.max(s.axisOffset[1],-$)),l.align({y:u.y,width:l.getBBox().width,align:u.align,x:u.x+m-2},!0,s.spacingBox),l.placed=s.hasLoaded),this.handleCollision($),a.align({verticalAlign:g},!0,s.spacingBox);var S=a.alignAttr.translateY,k=a.getBBox().height+20,A=0;if(g==="bottom"){var M=s.legend&&s.legend.options,P=M&&M.verticalAlign==="bottom"&&M.enabled&&!M.floating?s.legend.legendHeight+pick$W(M.margin,10):0;k=k+P-20,A=S-k-(h.floating?0:h.y)-(s.titleOffset?s.titleOffset[2]:0)-10}g==="top"?(h.floating&&(A=0),s.titleOffset&&s.titleOffset[0]&&(A=s.titleOffset[0]),A+=s.margin[0]-s.spacing[0]||0):g==="middle"&&(u.y===p.y?A=S:(u.y||p.y)&&(u.y<0||p.y<0?A-=Math.min(u.y,p.y):A=S-k)),a.translate(h.x,h.y+Math.floor(A));var E=this,T=E.minInput,O=E.maxInput,C=E.dropdown;h.inputEnabled&&T&&O&&(T.style.marginTop=a.translateY+"px",O.style.marginTop=a.translateY+"px"),C&&(C.style.marginTop=a.translateY+"px")}},o.prototype.alignButtonGroup=function(e,t){var r=this,n=r.chart,s=r.options,a=r.buttonGroup;r.buttons;var l=s.buttonPosition,h=n.plotLeft-n.spacing[3],c=l.x-n.spacing[3];l.align==="right"?c+=e-h:l.align==="center"&&(c-=h/2),a&&a.align({y:l.y,width:pick$W(t,this.initialButtonGroupWidth),align:l.align,x:c},!0,n.spacingBox)},o.prototype.positionButtons=function(){var e=this,t=e.buttons,r=e.chart,n=e.options,s=e.zoomText,a=r.hasLoaded?"animate":"attr",l=n.buttonPosition,h=r.plotLeft,c=h;s&&s.visibility!=="hidden"&&(s[a]({x:pick$W(h+l.x,h)}),c+=l.x+s.getBBox().width+5),this.buttonOptions.forEach(function(d,f){t[f].visibility!=="hidden"?(t[f][a]({x:c}),c+=t[f].width+n.buttonSpacing):t[f][a]({x:h})})},o.prototype.handleCollision=function(e){var t=this,r=this,n=r.chart,s=r.buttonGroup,a=r.inputGroup,l=this.options,h=l.buttonPosition,c=l.dropdown,d=l.inputPosition,f=function(){var g=0;return t.buttons.forEach(function(v){var y=v.getBBox();y.width>g&&(g=y.width)}),g},p=function(g){if(a&&s){var v=a.alignAttr.translateX+a.alignOptions.x-e+a.getBBox().x+2,y=a.alignOptions.width,m=s.alignAttr.translateX+s.getBBox().x;return m+g>v&&v+y>m&&h.y<d.y+a.getBBox().height}return!1},u=function(){a&&s&&a.attr({translateX:a.alignAttr.translateX+(n.axisOffset[1]>=-e?0:-e),translateY:a.alignAttr.translateY+s.getBBox().height+10})};if(s){if(c==="always"){this.collapseButtons(e),p(f())&&u();return}c==="never"&&this.expandButtons()}a&&s?d.align===h.align||p(this.initialButtonGroupWidth+20)?c==="responsive"?(this.collapseButtons(e),p(f())&&u()):u():c==="responsive"&&this.expandButtons():s&&c==="responsive"&&(this.initialButtonGroupWidth>n.plotWidth?this.collapseButtons(e):this.expandButtons())},o.prototype.collapseButtons=function(e){var t=this,r=t.buttons,n=t.buttonOptions,s=t.chart,a=t.dropdown,l=t.options,h=t.zoomText,c=s.userOptions.rangeSelector&&s.userOptions.rangeSelector.buttonTheme||{},d=function(u){return{text:u?u+" ▾":"▾",width:"auto",paddingLeft:pick$W(l.buttonTheme.paddingLeft,c.padding,8),paddingRight:pick$W(l.buttonTheme.paddingRight,c.padding,8)}};h&&h.hide();var f=!1;n.forEach(function(u,g){var v=r[g];v.state!==2?v.hide():(v.show(),v.attr(d(u.text)),f=!0)}),f||(a&&(a.selectedIndex=0),r[0].show(),r[0].attr(d(this.zoomText&&this.zoomText.textStr)));var p=l.buttonPosition.align;this.positionButtons(),(p==="right"||p==="center")&&this.alignButtonGroup(e,r[this.currentButtonIndex()].getBBox().width),this.showDropdown()},o.prototype.expandButtons=function(){var e=this,t=e.buttons,r=e.buttonOptions,n=e.options,s=e.zoomText;this.hideDropdown(),s&&s.show(),r.forEach(function(a,l){var h=t[l];h.show(),h.attr({text:a.text,width:n.buttonTheme.width||28,paddingLeft:pick$W(n.buttonTheme.paddingLeft,"unset"),paddingRight:pick$W(n.buttonTheme.paddingRight,"unset")}),h.state<2&&h.setState(0)}),this.positionButtons()},o.prototype.currentButtonIndex=function(){var e=this.dropdown;return e&&e.selectedIndex>0?e.selectedIndex-1:0},o.prototype.showDropdown=function(){var e=this,t=e.buttonGroup,r=e.buttons,n=e.chart,s=e.dropdown;if(t&&s){var a=t.translateX,l=t.translateY,h=r[this.currentButtonIndex()].getBBox();css$2(s,{left:n.plotLeft+a+"px",top:l+.5+"px",width:h.width+"px",height:h.height+"px"}),this.hasVisibleDropdown=!0}},o.prototype.hideDropdown=function(){var e=this.dropdown;e&&(css$2(e,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},o.prototype.getHeight=function(){var e=this,t=e.options,r=e.group,n=t.inputPosition,s=t.buttonPosition,a=t.y,l=s.y,h=n.y,c=0,d;return t.height?t.height:(this.alignElements(),c=r?r.getBBox(!0).height+13+a:0,d=Math.min(h,l),(h<0&&l<0||h>0&&l>0)&&(c+=Math.abs(d)),c)},o.prototype.titleCollision=function(e){return!(e.options.title.text||e.options.subtitle.text)},o.prototype.update=function(e){var t=this.chart;merge$Q(!0,t.options.rangeSelector,e),this.destroy(),this.init(t),this.render()},o.prototype.destroy=function(){var e=this,t=e.minInput,r=e.maxInput;e.eventsToUnbind&&(e.eventsToUnbind.forEach(function(n){return n()}),e.eventsToUnbind=void 0),destroyObjectProperties$1(e.buttons),t&&(t.onfocus=t.onblur=t.onchange=null),r&&(r.onfocus=r.onblur=r.onchange=null),objectEach$d(e,function(n,s){n&&s!=="chart"&&(n instanceof SVGElement?n.destroy():n instanceof window.HTMLElement&&discardElement$2(n)),n!==o.prototype[s]&&(e[s]=null)},this)},o}();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(o){var e=o.indexOf("%L")!==-1;if(e)return"text";var t=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(n){return o.indexOf("%"+n)!==-1}),r=["H","k","I","l","M","S"].some(function(n){return o.indexOf("%"+n)!==-1});return t&&r?"datetime-local":t?"date":r?"time":"text"}Axis.prototype.minFromRange=function(){var o=this.range,e=o.type,t,r=this.max,n,s,a=this.chart.time,l=function(h,c){var d=e==="year"?"FullYear":"Month",f=new a.Date(h),p=a.get(d,f);return a.set(d,f,p+c),p===a.get(d,f)&&a.set("Date",f,0),f.getTime()-h};return isNumber$o(o)?(t=r-o,s=o):(t=r+l(r,-o.count),this.chart&&(this.chart.fixedRange=r-t)),n=pick$W(this.dataMin,Number.MIN_VALUE),isNumber$o(t)||(t=n),t<=n&&(t=n,typeof s>"u"&&(s=l(t,o.count)),this.newMax=Math.min(t+s,this.dataMax)),isNumber$o(r)||(t=void 0),t};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(o){var e,t=o.rangeSelector,r,n,s;function a(){t&&(e=o.xAxis[0].getExtremes(),r=o.legend,s=t&&t.options.verticalAlign,isNumber$o(e.min)&&t.render(e.min,e.max),r.display&&s==="top"&&s===r.options.verticalAlign&&(n=merge$Q(o.spacingBox),r.options.layout==="vertical"?n.y=o.plotTop:n.y+=t.getHeight(),r.group.placed=!1,r.align(n)))}if(t){var l=find$b(chartDestroyEvents_1,function(h){return h[0]===o});l||chartDestroyEvents_1.push([o,[addEvent$E(o.xAxis[0],"afterSetExtremes",function(h){t&&t.render(h.min,h.max)}),addEvent$E(o,"redraw",a)]]),a()}};addEvent$E(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$E(Chart$1,"beforeRender",function(){var o=this,e=o.axes,t=o.rangeSelector,r;t&&(isNumber$o(t.deferredYTDClick)&&(t.clickButton(t.deferredYTDClick),delete t.deferredYTDClick),e.forEach(function(n){n.updateNames(),n.setScale()}),o.getAxisMargins(),t.render(),r=t.options.verticalAlign,t.options.floating||(r==="bottom"?this.extraBottomMargin=!0:r!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$E(Chart$1,"update",function(o){var e=this,t=o.options,r=t.rangeSelector,n=e.rangeSelector,s,a=this.extraBottomMargin,l=this.extraTopMargin;r&&r.enabled&&!defined$r(n)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=n=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,n&&(initRangeSelector_1(this),s=r&&r.verticalAlign||n.options&&n.options.verticalAlign,n.options.floating||(s==="bottom"?this.extraBottomMargin=!0:s!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==a||this.extraTopMargin!==l)&&(this.isDirtyBox=!0))}),addEvent$E(Chart$1,"render",function(){var o=this,e=o.rangeSelector,t;e&&!e.options.floating&&(e.render(),t=e.options.verticalAlign,t==="bottom"?this.extraBottomMargin=!0:t!=="middle"&&(this.extraTopMargin=!0))}),addEvent$E(Chart$1,"getMargins",function(){var o=this.rangeSelector,e;o&&(e=o.getHeight(),this.extraTopMargin&&(this.plotTop+=e),this.extraBottomMargin&&(this.marginBottom+=e))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$E(Chart$1,"destroy",function(){for(var e=0;e<chartDestroyEvents_1.length;e++){var t=chartDestroyEvents_1[e];if(t[0]===this){t[1].forEach(function(r){return r()}),chartDestroyEvents_1.splice(e,1);return}}}),H.RangeSelector=RangeSelector}var __extends$G=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$4=animationExports.animObject,format$6=FormatUtilities.format,getOptions$2=DefaultOptions.getOptions,pointTooltipFormatter=Point$2.prototype.tooltipFormatter,_a$c=Series$e.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$D=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$9=Utilities.clamp,defined$q=Utilities.defined,extend$Z=Utilities.extend,find$a=Utilities.find,isNumber$n=Utilities.isNumber,isString$3=Utilities.isString,merge$P=Utilities.merge,pick$V=Utilities.pick,splat$7=Utilities.splat,StockChart=function(o){__extends$G(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.prototype.init=function(t,r){var n=getOptions$2(),s=t.xAxis,a=t.yAxis,l=pick$V(t.navigator&&t.navigator.enabled,n.navigator.enabled,!0);t.xAxis=t.yAxis=void 0;var h=merge$P({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:l},scrollbar:{enabled:pick$V(n.scrollbar&&n.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$V(n.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$V(n.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=s,t.yAxis=a,h.xAxis=splat$7(t.xAxis||{}).map(function(c,d){return merge$P(getDefaultAxisOptions("xAxis",c),n.xAxis,n.xAxis&&n.xAxis[d],c,getForcedAxisOptions("xAxis",t))}),h.yAxis=splat$7(t.yAxis||{}).map(function(c,d){return merge$P(getDefaultAxisOptions("yAxis",c),n.yAxis,n.yAxis&&n.yAxis[d],c)}),o.prototype.init.call(this,h,r)},e.prototype.createAxis=function(t,r){return r.axis=merge$P(getDefaultAxisOptions(t,r.axis),r.axis,getForcedAxisOptions(t,this.userOptions)),o.prototype.createAxis.call(this,t,r)},e}(Chart$1);(function(o){function e(t,r,n){return new o(t,r,n)}o.stockChart=e})(StockChart||(StockChart={}));function getDefaultAxisOptions(o,e){return o==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:o==="yAxis"?{labels:{y:-2},opposite:pick$V(e.opposite,!0),showLastLabel:!!(e.categories||e.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(o,e){if(o==="xAxis"){var t=getOptions$2(),r=pick$V(e.navigator&&e.navigator.enabled,t.navigator.enabled,!0),n={type:"datetime",categories:void 0};return r&&(n.startOnTick=!1,n.endOnTick=!1),n}return{}}addEvent$D(Series$e,"setOptions",function(o){var e;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?e={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(e={marker:{enabled:!1,radius:2}}),e&&(o.plotOptions[this.type]=merge$P(o.plotOptions[this.type],e)))});addEvent$D(Axis,"autoLabelAlign",function(o){var e=this.chart,t=this.options,r=e._labelPanes=e._labelPanes||{},n,s=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(n=t.top+","+t.height,!r[n]&&s.enabled&&(s.x===15&&(s.x=0),typeof s.align>"u"&&(s.align="right"),r[n]=this,o.align="right",o.preventDefault()))});addEvent$D(Axis,"destroy",function(){var o=this.chart,e=this.options&&this.options.top+","+this.options.height;e&&o._labelPanes&&o._labelPanes[e]===this&&delete o._labelPanes[e]});addEvent$D(Axis,"getPlotLinePath",function(o){var e=this,t=this.isLinked&&!this.series?this.linkedParent.series:this.series,r=e.chart,n=r.renderer,s=e.left,a=e.top,l,h,c,d,f=[],p=[],u,g,v=o.translatedValue,y=o.value,m=o.force,x;function b($){var S=$==="xAxis"?"yAxis":"xAxis",k=e.options[S];return isNumber$n(k)?[r[S][k]]:isString$3(k)?[r.get(k)]:t.map(function(A){return A[S]})}(r.options.isStock&&o.acrossPanes!==!1&&e.coll==="xAxis"||e.coll==="yAxis")&&(o.preventDefault(),p=b(e.coll),u=e.isXAxis?r.yAxis:r.xAxis,u.forEach(function($){if(!defined$q($.options.id)||$.options.id.indexOf("navigator")===-1){var S=$.isXAxis?"yAxis":"xAxis",k=defined$q($.options[S])?r[S][$.options[S]]:r[S][0];e===k&&p.push($)}}),g=p.length?[]:[e.isXAxis?r.yAxis[0]:r.xAxis[0]],p.forEach(function($){g.indexOf($)===-1&&!find$a(g,function(S){return S.pos===$.pos&&S.len===$.len})&&g.push($)}),x=pick$V(v,e.translate(y,null,null,o.old)),isNumber$n(x)&&(e.horiz?g.forEach(function($){var S;h=$.pos,d=h+$.len,l=c=Math.round(x+e.transB),m!=="pass"&&(l<s||l>s+e.width)&&(m?l=c=clamp$9(l,s,s+e.width):S=!0),S||f.push(["M",l,h],["L",c,d])}):g.forEach(function($){var S;l=$.pos,c=l+$.len,h=d=Math.round(a+e.height-x),m!=="pass"&&(h<a||h>a+e.height)&&(m?h=d=clamp$9(h,a,a+e.height):S=!0),S||f.push(["M",l,h],["L",c,d])})),o.path=f.length>0?n.crispPolyLine(f,o.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(o,e){for(var t=0;t<o.length;t=t+2){var r=o[t],n=o[t+1];r[1]===n[1]&&(r[1]=n[1]=Math.round(r[1])-e%2/2),r[2]===n[2]&&(r[2]=n[2]=Math.round(r[2])+e%2/2)}return o};addEvent$D(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$D(Axis,"afterDrawCrosshair",function(o){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$n(this.min)||!isNumber$n(this.max))){var e=this.chart,t=this.logarithmic,r=this.crosshair.label,n=this.horiz,s=this.opposite,a=this.left,l=this.top,h=this.crossLabel,c,d,f,p=r.format,u="",g,v,y=this.options.tickPosition==="inside",m=this.crosshair.snap!==!1,x=0,b=o.e||this.cross&&this.cross.e,$=o.point,S=this.min,k=this.max;t&&(S=t.lin2log(S),k=t.lin2log(k)),v=n?"center":s?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",h||(h=this.crossLabel=e.renderer.label("",0,void 0,r.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+($?$.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:r.align||v,padding:pick$V(r.padding,8),r:pick$V(r.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||h.attr({fill:r.backgroundColor||$&&$.series&&$.series.color||palette.neutralColor60,stroke:r.borderColor||"","stroke-width":r.borderWidth||0}).css(extend$Z({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},r.style||{}))),n?(c=m?($.plotX||0)+a:b.chartX,d=l+(s?0:this.height)):(c=s?this.width+a:0,d=m?($.plotY||0)+l:b.chartY),!p&&!r.formatter&&(this.dateTime&&(u="%b %d, %Y"),p="{value"+(u?":"+u:"")+"}");var A=m?this.isXAxis?$.x:$.y:this.toValue(n?b.chartX:b.chartY),M=$?$.series.isPointInside($):isNumber$n(A)&&A>S&&A<k,P="";p?P=format$6(p,{value:A},e):r.formatter&&isNumber$n(A)&&(P=r.formatter.call(this,A)),h.attr({text:P,x:c,y:d,visibility:M?"visible":"hidden"}),f=h.getBBox(),isNumber$n(h.y)&&(n?(y&&!s||!y&&s)&&(d=h.y-f.height):d=h.y-f.height/2),n?g={left:a-f.x,right:a+this.width-f.x}:g={left:this.labelAlign==="left"?a:0,right:this.labelAlign==="right"?a+this.width:e.chartWidth},h.translateX<g.left&&(x=g.left-h.translateX),h.translateX+f.width>=g.right&&(x=-(h.translateX+f.width-g.right)),h.attr({x:c+x,y:d,anchorX:n?c:this.opposite?0:e.chartWidth,anchorY:n?this.opposite?e.chartHeight:0:d+f.height/2})}});Series$e.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$e.prototype.setCompare=function(o){this.initCompare(o),this.userOptions.compare=o};Series$e.prototype.initCompare=function(o){this.modifyValue=o==="value"||o==="percent"?function(e,t){var r=this.compareValue;return typeof e<"u"&&typeof r<"u"?(o==="value"?e-=r:e=100*(e/r)-(this.options.compareBase===100?0:100),t&&(t.change=e),e):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$e.prototype.forceCropping=function(){var o=this.chart,e=this.options,t=e.dataGrouping,r=this.allowDG!==!1&&t&&pick$V(t.enabled,o.options.isStock);return r};Series$e.prototype.processData=function(o){var e=this,t,r=-1,n,s,a=e.options.compareStart===!0?0:1,l,h;if(seriesProcessData.apply(this,arguments),e.xAxis&&e.processedYData){for(n=e.processedXData,s=e.processedYData,l=s.length,e.pointArrayMap&&(r=e.pointArrayMap.indexOf(e.options.pointValKey||e.pointValKey||"y")),t=0;t<l-a;t++)if(h=s[t]&&r>-1?s[t][r]:s[t],isNumber$n(h)&&n[t+a]>=e.xAxis.min&&h!==0){e.compareValue=h;break}}};addEvent$D(Series$e,"afterGetExtremes",function(o){var e=o.dataExtremes;if(this.modifyValue&&e){var t=[this.modifyValue(e.dataMin),this.modifyValue(e.dataMax)];e.dataMin=arrayMin$4(t),e.dataMax=arrayMax$4(t)}});Axis.prototype.setCompare=function(o,e){this.isXAxis||(this.series.forEach(function(t){t.setCompare(o)}),pick$V(e,!0)&&this.chart.redraw())};Point$2.prototype.tooltipFormatter=function(o){var e=this,t=e.series.chart.numberFormatter;return o=o.replace("{point.change}",(e.change>0?"+":"")+t(e.change,pick$V(e.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[o])};addEvent$D(Series$e,"render",function(){var o=this.chart,e;if(!(o.is3d&&o.is3d())&&!o.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(e=this.yAxis.len,this.xAxis.axisLine){var t=o.plotTop+o.plotHeight-this.yAxis.pos-this.yAxis.len,r=Math.floor(this.xAxis.axisLine.strokeWidth()/2);t>=0&&(e-=Math.max(r-t,0))}if((!o.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$P(o.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=e),o.hasRendered){var n=animObject$4(this.options.animation),s=this.getSharedClipKey(n),a=o.sharedClips[s];if(a){a.animate({width:this.xAxis.len,height:e});var l=o.sharedClips[s+"m"];l&&l.animate({width:this.xAxis.len})}}}});addEvent$D(Chart$1,"update",function(o){var e=o.options;"scrollbar"in e&&this.navigator&&(merge$P(!0,this.options.scrollbar,e.scrollbar),this.navigator.update({},!1),delete e.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;G$5.Scrollbar=Scrollbar;G$5.StockChart=G$5.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$5.Axis);OrdinalAxis$1.compose(G$5.Axis,G$5.Series,G$5.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$7.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$O=Utilities.merge;function addClass$1(o,e){o.classList?o.classList.add(e):o.className.indexOf(e)<0&&(o.className+=e)}function escapeStringForHTML$1(o){return o.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(o){return doc$f.getElementById(o)}function getFakeMouseEvent$2(o){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(o);if(doc$f.createEvent){var e=doc$f.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(o,!0,!0,win$6,o==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),e}return{type:o}}function getHeadingTagNameForElement$1(o){var e=function(s){var a=parseInt(s.slice(1),10),l=Math.min(6,a+1);return"h"+l},t=function(s){return/H[1-6]/.test(s)},r=function(s){for(var a=s;a=a.previousSibling;){var l=a.tagName||"";if(t(l))return l}return""},n=function(s){var a=r(s);if(a)return e(a);var l=s.parentElement;if(!l)return"p";var h=l.tagName;return t(h)?e(h):n(l)};return n(o)}function removeElement$5(o){o&&o.parentNode&&o.parentNode.removeChild(o)}function reverseChildNodes$1(o){for(var e=o.childNodes.length;e--;)o.appendChild(o.childNodes[e])}function setElAttrs$4(o,e){Object.keys(e).forEach(function(t){var r=e[t];r===null?o.removeAttribute(t):o.setAttribute(t,r)})}function stripHTMLTagsFromString$2(o){return typeof o=="string"?o.replace(/<\/?[^>]+(>|$)/g,""):o}function visuallyHideElement$2(o){var e={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$O(!0,o.style,e)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$p=Utilities.defined,find$9=Utilities.find,fireEvent$i=Utilities.fireEvent;function getChartTitle$5(o){return stripHTMLTags$3(o.options.title.text||o.langFormat("accessibility.defaultChartTitle",{chart:o}))}function getAxisDescription$2(o){return o&&(o.userOptions&&o.userOptions.accessibility&&o.userOptions.accessibility.description||o.axisTitle&&o.axisTitle.textStr||o.options.id||o.categories&&"categories"||o.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(o){var e=o.options||{};return e.accessibility&&typeof e.accessibility.rangeDescription<"u"?e.accessibility.rangeDescription:o.categories?getCategoryAxisRangeDesc(o):o.dateTime&&(o.min===0||o.dataMin===0)?getAxisTimeLengthDesc(o):getAxisFromToDescription(o)}function getCategoryAxisRangeDesc(o){var e=o.chart;return o.dataMax&&o.dataMin?e.langFormat("accessibility.axis.rangeCategories",{chart:e,axis:o,numCategories:o.dataMax-o.dataMin+1}):""}function getAxisTimeLengthDesc(o){var e=o.chart,t={},r="Seconds";t.Seconds=((o.max||0)-(o.min||0))/1e3,t.Minutes=t.Seconds/60,t.Hours=t.Minutes/60,t.Days=t.Hours/24,["Minutes","Hours","Days"].forEach(function(s){t[s]>2&&(r=s)});var n=t[r].toFixed(r!=="Seconds"&&r!=="Minutes"?1:0);return e.langFormat("accessibility.axis.timeRange"+r,{chart:e,axis:o,range:n.replace(".0","")})}function getAxisFromToDescription(o){var e=o.chart,t=e.options&&e.options.accessibility&&e.options.accessibility.screenReaderSection.axisRangeDateFormat||"",r=function(n){return o.dateTime?e.time.dateFormat(t,o[n]):o[n]};return e.langFormat("accessibility.axis.rangeFromTo",{chart:e,axis:o,rangeFrom:r("min"),rangeTo:r("max")})}function getSeriesFirstPointElement$1(o){if(o.points&&o.points.length){var e=find$9(o.points,function(t){return!!t.graphic});return e&&e.graphic&&e.graphic.element}}function getSeriesA11yElement$1(o){var e=getSeriesFirstPointElement$1(o);return e&&e.parentNode||o.graph&&o.graph.element||o.group&&o.group.element}function unhideChartElementFromAT$7(o,e){e.setAttribute("aria-hidden",!1),!(e===o.renderTo||!e.parentNode||e.parentNode===doc$e.body)&&(Array.prototype.forEach.call(e.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(o,e.parentNode))}function hideSeriesFromAT$1(o){var e=getSeriesA11yElement$1(o);e&&e.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(o,e){return e?(o.series||[]).filter(function(t){return t.name===e}):o.series}function getPointFromXY$1(o,e,t){for(var r=o.length,n;r--;)if(n=find$9(o[r].points||[],function(s){return s.x===e&&s.y===t}),n)return n}function getRelativePointAxisPosition(o,e){if(!defined$p(o.dataMin)||!defined$p(o.dataMax))return 0;var t=o.toPixels(o.dataMin),r=o.toPixels(o.dataMax),n=o.coll==="xAxis"?"x":"y",s=o.toPixels(e[n]||0);return(s-t)/(r-t)}function scrollToPoint$1(o){var e=o.series.xAxis,t=o.series.yAxis,r=e&&e.scrollbar?e:t,n=r&&r.scrollbar;if(n&&defined$p(n.to)&&defined$p(n.from)){var s=n.to-n.from,a=getRelativePointAxisPosition(r,o);n.updatePosition(a-s/2,a+s/2),fireEvent$i(n,"changed",{from:n.from,to:n.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$8=Utilities.find;function KeyboardNavigationHandler(o,e){this.chart=o,this.keyCodeMap=e.keyCodeMap||[],this.validate=e.validate,this.init=e.init,this.terminate=e.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(o){var e=o.which||o.keyCode,t=this.response.noHandler,r=find$8(this.keyCodeMap,function(n){return n[0].indexOf(e)>-1});return r?t=r[1].call(this,e,o):e===9&&(t=this.response[o.shiftKey?"prev":"next"]),t}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$Y=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$Y(DOMElementProvider.prototype,{createElement:function(){var o=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(o),o},destroyCreatedElements:function(){this.elements.forEach(function(o){removeElement$4(o)}),this.elements=[]}});var addEvent$C=Utilities.addEvent,extend$X=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$X(EventProvider.prototype,{addEvent:function(){var o=addEvent$C.apply(H,arguments);return this.eventRemovers.push(o),o},removeAddedEvents:function(){this.eventRemovers.forEach(function(o){o()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$W=Utilities.extend,fireEvent$h=Utilities.fireEvent,merge$N=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(o){this.chart=o,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(o,e){var t=e.type;doc$c.createEvent&&(o.dispatchEvent||o.fireEvent)?o.dispatchEvent?o.dispatchEvent(e):o.fireEvent(t,e):fireEvent$h(o,t,e)},fakeClickEvent:function(o){if(o){var e=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(o,e)}},addProxyGroup:function(o){this.createOrUpdateProxyContainer();var e=this.createElement("div");return Object.keys(o||{}).forEach(function(t){o[t]!==null&&e.setAttribute(t,o[t])}),this.chart.a11yProxyContainer.appendChild(e),e},createOrUpdateProxyContainer:function(){var o=this.chart,e=o.renderer.box;o.a11yProxyContainer=o.a11yProxyContainer||this.createProxyContainerElement(),e.nextSibling!==o.a11yProxyContainer&&o.container.insertBefore(o.a11yProxyContainer,e.nextSibling)},createProxyContainerElement:function(){var o=doc$c.createElement("div");return o.className="highcharts-a11y-proxy-container",o},createProxyButton:function(o,e,t,r,n){var s=o.element,a=this.createElement("button"),l=merge$N({"aria-label":s.getAttribute("aria-label")},t);return Object.keys(l).forEach(function(h){l[h]!==null&&a.setAttribute(h,l[h])}),a.className="highcharts-a11y-proxy-button",o.hasClass("highcharts-no-tooltip")&&(a.className+=" highcharts-no-tooltip"),n&&this.addEvent(a,"click",n),this.setProxyButtonStyle(a),this.updateProxyButtonPosition(a,r||o),this.proxyMouseEventsForButton(s,a),e.appendChild(a),l["aria-hidden"]||unhideChartElementFromAT$6(this.chart,a),a},getElementPosition:function(o){var e=o.element,t=this.chart.renderTo;if(t&&e&&e.getBoundingClientRect){var r=e.getBoundingClientRect(),n=t.getBoundingClientRect();return{x:r.left-n.left,y:r.top-n.top,width:r.right-r.left,height:r.bottom-r.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(o){merge$N(!0,o.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),o.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(o,e){var t=this.getElementPosition(e);merge$N(!0,o.style,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},proxyMouseEventsForButton:function(o,e){var t=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(r){var n=r.indexOf("touch")===0;t.addEvent(e,r,function(s){var a=n?t.cloneTouchEvent(s):t.cloneMouseEvent(s);o&&t.fireEventOnWrappedOrUnwrappedElement(o,a),s.stopPropagation(),r!=="touchstart"&&r!=="touchmove"&&r!=="touchend"&&s.preventDefault()},{passive:!1})})},cloneMouseEvent:function(o){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(o.type,o);if(doc$c.createEvent){var e=doc$c.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(o.type,o.bubbles,o.cancelable,o.view||win$5,o.detail,o.screenX,o.screenY,o.clientX,o.clientY,o.ctrlKey,o.altKey,o.shiftKey,o.metaKey,o.button,o.relatedTarget),e}return getFakeMouseEvent$1(o.type)},cloneTouchEvent:function(o){var e=function(n){for(var s=[],a=0;a<n.length;++a){var l=n.item(a);l&&s.push(l)}return s};if(typeof win$5.TouchEvent=="function"){var t=new win$5.TouchEvent(o.type,{touches:e(o.touches),targetTouches:e(o.targetTouches),changedTouches:e(o.changedTouches),ctrlKey:o.ctrlKey,shiftKey:o.shiftKey,altKey:o.altKey,metaKey:o.metaKey,bubbles:o.bubbles,cancelable:o.cancelable,composed:o.composed,detail:o.detail,view:o.view});return o.defaultPrevented&&t.preventDefault(),t}var r=this.cloneMouseEvent(o);return r.touches=o.touches,r.changedTouches=o.changedTouches,r.targetTouches=o.targetTouches,r},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$W(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$B=Utilities.addEvent,fireEvent$g=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$B(doc$b,"keydown",function(o){var e=o.which||o.keyCode,t=27;e===t&&H.charts&&H.charts.forEach(function(r){r&&r.dismissPopupContent&&r.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var o=this;fireEvent$g(this,"dismissPopupContent",{},function(){o.tooltip&&o.tooltip.hide(0),o.hideExportMenu()})};function KeyboardNavigation(o,e){this.init(o,e)}KeyboardNavigation.prototype={init:function(o,e){var t=this,r=this.eventProvider=new EventProvider;this.chart=o,this.components=e,this.modules=[],this.currentModuleIx=0,this.update(),r.addEvent(this.tabindexContainer,"keydown",function(n){return t.onKeydown(n)}),r.addEvent(this.tabindexContainer,"focus",function(n){return t.onFocus(n)}),["mouseup","touchend"].forEach(function(n){return r.addEvent(doc$b,n,function(){return t.onMouseUp()})}),["mousedown","touchstart"].forEach(function(n){return r.addEvent(o.renderTo,n,function(){t.isClickingChart=!0})}),r.addEvent(o.renderTo,"mouseover",function(){t.pointerIsOverChart=!0}),r.addEvent(o.renderTo,"mouseout",function(){t.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(o){var e=this.chart.options.accessibility,t=e&&e.keyboardNavigation,r=this.components;this.updateContainerTabindex(),t&&t.enabled&&o&&o.length?(this.modules=o.reduce(function(n,s){var a=r[s].getKeyboardNavigation();return n.concat(a)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(o){var e=this.chart,t=o.relatedTarget&&e.container.contains(o.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!t&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var o=this.chart,e=this.modules&&this.modules[this.currentModuleIx||0];e&&e.terminate&&e.terminate(),o.focusElement&&o.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(o){var e=o||win$4.event,t,r=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,r){var n=r.run(e);n===r.response.success?t=!0:n===r.response.prev?t=this.prev():n===r.response.next&&(t=this.next()),t&&(e.preventDefault(),e.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(o){var e=this.modules&&this.modules[this.currentModuleIx];e&&e.terminate&&e.terminate(o),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=o;var t=this.modules&&this.modules[this.currentModuleIx];if(t){if(t.validate&&!t.validate())return this.move(o);if(t.init)return t.init(o),!0}return this.currentModuleIx=0,this.exiting=!0,o>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var o="highcharts-end-of-chart-marker-"+this.chart.index,e=getElement$1(o);this.removeExitAnchor(),e?(this.makeElementAnExitAnchor(e),this.exitAnchor=e):this.createExitAnchor()},updateContainerTabindex:function(){var o=this.chart.options.accessibility,e=o&&o.keyboardNavigation,t=!(e&&e.enabled===!1),r=this.chart,n=r.container,s;r.renderTo.hasAttribute("tabindex")?(n.removeAttribute("tabindex"),s=r.renderTo):s=n,this.tabindexContainer=s;var a=s.getAttribute("tabindex");t&&!a?s.setAttribute("tabindex","0"):t||r.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(o){var e=this.tabindexContainer.getAttribute("tabindex")||0;o.setAttribute("class","highcharts-exit-anchor"),o.setAttribute("tabindex",e),o.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(o)},createExitAnchor:function(){var o=this.chart,e=this.exitAnchor=doc$b.createElement("div");o.renderTo.appendChild(e),this.makeElementAnExitAnchor(e)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(o){var e=this.chart,t=this;this.eventProvider.addEvent(o,"focus",function(r){var n=r||win$4.event,s,a=n.relatedTarget&&e.container.contains(n.relatedTarget),l=!(a||t.exiting);l?(t.tabbingInBackwards=!0,t.tabindexContainer.focus(),delete t.tabbingInBackwards,n.preventDefault(),t.modules&&t.modules.length&&(t.currentModuleIx=t.modules.length-1,s=t.modules[t.currentModuleIx],s&&s.validate&&!s.validate()?t.prev():s&&s.init(-1))):t.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$3=animationExports.animObject,addEvent$A=Utilities.addEvent,extend$V=Utilities.extend,find$7=Utilities.find,fireEvent$f=Utilities.fireEvent,isNumber$m=Utilities.isNumber,pick$U=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(o,e){var t=o.allItems[e].pageIx,r=o.currentPage;typeof t<"u"&&t+1!==r&&o.scroll(1+t-r)}function shouldDoLegendA11y(o){var e=o.legend&&o.legend.allItems,t=o.options.legend.accessibility||{};return!!(e&&e.length&&!(o.colorAxis&&o.colorAxis.length)&&t.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(o){var e=this.legend.allItems,t=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return e[o]?(isNumber$m(t)&&e[t]&&fireEvent$f(e[t].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,o),this.setFocusToElement(e[o].legendItem,e[o].a11yProxyElement),fireEvent$f(e[o].legendGroup.element,"mouseover"),!0):!1};addEvent$A(Legend,"afterColorizeItem",function(o){var e=this.chart,t=e.options.accessibility,r=o.item;t.enabled&&r&&r.a11yProxyElement&&r.a11yProxyElement.setAttribute("aria-pressed",o.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$V(LegendComponent.prototype,{init:function(){var o=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===o.chart&&(o.updateProxiesPositions(),o.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(o.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(e){this.chart===o.chart&&this.chart.renderer&&o.updateProxyPositionForItem(e.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===o.chart&&this.chart.renderer&&o.recreateProxies()&&syncTimeout$1(function(){return o.updateProxiesPositions()},animObject$3(pick$U(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var o=this.chart.legend,e=o.allItems||[],t=o.currentPage||1,r=o.clipHeight||0;e.forEach(function(n){var s=n.pageIx||0,a=n._legendItemPos?n._legendItemPos[1]:0,l=n.legendItem?Math.round(n.legendItem.getBBox().height):0,h=a+l-o.pages[s]>r||s!==t-1;n.a11yProxyElement&&(n.a11yProxyElement.style.visibility=h?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var o=0,e=this.proxyElementsList;o<e.length;o++){var t=e[o],r=t.element,n=t.posElement;this.updateProxyButtonPosition(r,n)}},updateProxyPositionForItem:function(o){var e=find$7(this.proxyElementsList,function(t){return t.item===o});e&&this.updateProxyButtonPosition(e.element,e.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var o=this.chart,e=stripHTMLTags$2((o.legend&&o.legend.options.title&&o.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),t=o.langFormat("accessibility.legend.legendLabel"+(e?"":"NoTitle"),{chart:o,legendTitle:e,chartTitle:getChartTitle$4(o)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",t)},addLegendProxyGroup:function(){var o=this.chart.options.accessibility,e=o.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:e})},addLegendListContainer:function(){if(this.legendProxyGroup){var o=this.legendListContainer=this.createElement("ul");o.style.listStyle="none",this.legendProxyGroup.appendChild(o)}},proxyLegendItems:function(){var o=this,e=this.chart.legend&&this.chart.legend.allItems||[];e.forEach(function(t){t.legendItem&&t.legendItem.element&&o.proxyLegendItem(t)})},proxyLegendItem:function(o){if(!(!o.legendItem||!o.legendGroup||!this.legendListContainer)){var e=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(o.name),item:o}),t={tabindex:-1,"aria-pressed":o.visible,"aria-label":e},r=o.legendGroup.div?o.legendItem:o.legendGroup,n=this.createElement("li");this.legendListContainer.appendChild(n),o.a11yProxyElement=this.createProxyButton(o.legendItem,n,t,r),this.proxyElementsList.push({item:o,element:o.a11yProxyElement,posElement:r})}},getKeyboardNavigation:function(){var o=this.keyCodes,e=this,t=this.chart;return new KeyboardNavigationHandler(t,{keyCodeMap:[[[o.left,o.right,o.up,o.down],function(r){return e.onKbdArrowKey(this,r)}],[[o.enter,o.space],function(r){return H.isFirefox&&r===o.space?this.response.success:e.onKbdClick(this)}]],validate:function(){return e.shouldHaveLegendNavigation()},init:function(r){return e.onKbdNavigationInit(r)},terminate:function(){t.legend.allItems.forEach(function(r){return r.setState("",!0)})}})},onKbdArrowKey:function(o,e){var t=this.keyCodes,r=o.response,n=this.chart,s=n.options.accessibility,a=n.legend.allItems.length,l=e===t.left||e===t.up?-1:1,h=n.highlightLegendItem(this.highlightedLegendItemIx+l);return h?(this.highlightedLegendItemIx+=l,r.success):a>1&&s.keyboardNavigation.wrapAround?(o.init(l),r.success):r[l>0?"next":"prev"]},onKbdClick:function(o){var e=this.chart.legend.allItems[this.highlightedLegendItemIx];return e&&e.a11yProxyElement&&fireEvent$f(e.a11yProxyElement,"click"),o.response.success},shouldHaveLegendNavigation:function(){var o=this.chart,e=o.options.legend||{},t=o.legend&&o.legend.allItems,r=o.colorAxis&&o.colorAxis.length,n=e.accessibility||{};return!!(t&&o.legend.display&&!r&&n.enabled&&n.keyboardNavigation&&n.keyboardNavigation.enabled)},onKbdNavigationInit:function(o){var e=this.chart,t=e.legend.allItems.length-1,r=o>0?0:t;e.highlightLegendItem(r),this.highlightedLegendItemIx=r}});var extend$U=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(o){return o.exportSVGElements&&o.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var o=getExportMenuButtonElement(this);if(o){var e=o.element;e.onclick&&e.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var o=this,e=o.exportDivElements;e&&o.exportContextMenu&&(e.forEach(function(t){t&&t.className==="highcharts-menu-item"&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout"))}),o.highlightedExportItemIx=0,o.exportContextMenu.hideMenu(),o.container.focus())};Chart$1.prototype.highlightExportItem=function(o){var e=this.exportDivElements&&this.exportDivElements[o],t=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],r;return e&&e.tagName==="LI"&&!(e.children&&e.children.length)?(r=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,e.focus&&r&&e.focus(),t&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout")),e.onmouseover&&e.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=o,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var o=this,e;if(o.exportDivElements){for(e=o.exportDivElements.length;e--;)if(o.highlightExportItem(e))return!0}return!1};function exportingShouldHaveA11y(o){var e=o.options.exporting,t=getExportMenuButtonElement(o);return!!(e&&e.enabled!==!1&&e.accessibility&&e.accessibility.enabled&&t&&t.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$U(MenuComponent.prototype,{init:function(){var o=this.chart,e=this;this.addEvent(o,"exportMenuShown",function(){e.onMenuShown()}),this.addEvent(o,"exportMenuHidden",function(){e.onMenuHidden()})},onMenuHidden:function(){var o=this.chart.exportContextMenu;o&&o.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var o=this.chart,e=o.exportContextMenu;e&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(o,e)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(o){var e=this.exportButtonProxy;e&&e.setAttribute("aria-expanded",o)},onChartRender:function(){var o=this.chart,e=o.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(o)){this.exportProxyGroup=this.addProxyGroup(e.landmarkVerbosity==="all"?{"aria-label":o.langFormat("accessibility.exporting.exportRegionLabel",{chart:o,chartTitle:getChartTitle$3(o)}),role:"region"}:{});var t=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(t,this.exportProxyGroup,{"aria-label":o.langFormat("accessibility.exporting.menuButtonLabel",{chart:o}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var o=this.chart,e=o.exportDivElements;if(e&&e.length){e.forEach(function(r){r&&(r.tagName==="LI"&&!(r.children&&r.children.length)?r.setAttribute("tabindex",-1):r.setAttribute("aria-hidden","true"))});var t=e[0]&&e[0].parentNode;t&&(t.removeAttribute("aria-hidden"),t.setAttribute("aria-label",o.langFormat("accessibility.exporting.chartMenuLabel",{chart:o})))}},getKeyboardNavigation:function(){var o=this.keyCodes,e=this.chart,t=this;return new KeyboardNavigationHandler(e,{keyCodeMap:[[[o.left,o.up],function(){return t.onKbdPrevious(this)}],[[o.right,o.down],function(){return t.onKbdNext(this)}],[[o.enter,o.space],function(){return t.onKbdClick(this)}]],validate:function(){return!!e.exporting&&e.options.exporting.enabled!==!1&&e.options.exporting.accessibility.enabled!==!1},init:function(){var r=t.exportButtonProxy,n=e.exportingGroup;n&&r&&e.setFocusToElement(n,r)},terminate:function(){e.hideExportMenu()}})},onKbdPrevious:function(o){for(var e=this.chart,t=e.options.accessibility,r=o.response,n=e.highlightedExportItemIx||0;n--;)if(e.highlightExportItem(n))return r.success;return t.keyboardNavigation.wrapAround?(e.highlightLastExportItem(),r.success):r.prev},onKbdNext:function(o){for(var e=this.chart,t=e.options.accessibility,r=o.response,n=(e.highlightedExportItemIx||0)+1;n<e.exportDivElements.length;++n)if(e.highlightExportItem(n))return r.success;return t.keyboardNavigation.wrapAround?(e.highlightExportItem(0),r.success):r.next},onKbdClick:function(o){var e=this.chart,t=e.exportDivElements[e.highlightedExportItemIx],r=getExportMenuButtonElement(e).element;return this.isExportMenuShown?this.fakeClickEvent(t):(this.fakeClickEvent(r),e.highlightExportItem(0)),o.response.success}});var seriesTypes$4=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$o=Utilities.defined,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$e.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(o){seriesTypes$4[o]&&(seriesTypes$4[o].prototype.keyboardMoveVertical=!1)});function getPointIndex(o){var e=o.index,t=o.series.points,r=t.length;if(t[e]!==o){for(;r--;)if(t[r]===o)return r}else return e}function isSkipSeries(o){var e=o.chart.options.accessibility,t=e.keyboardNavigation.seriesNavigation,r=o.options.accessibility||{},n=r.keyboardNavigation;return n&&n.enabled===!1||r.enabled===!1||o.options.enableMouseTracking===!1||!o.visible||t.pointNavigationEnabledThreshold&&t.pointNavigationEnabledThreshold<=o.points.length}function isSkipPoint(o){var e=o.series.chart.options.accessibility,t=o.options.accessibility&&o.options.accessibility.enabled===!1;return o.isNull&&e.keyboardNavigation.seriesNavigation.skipNullPoints||o.visible===!1||o.isInside===!1||t||isSkipSeries(o.series)}function getClosestPoint(o,e,t,r){var n=1/0,s,a,l,h=e.points.length,c=function(d){return!(defined$o(d.plotX)&&defined$o(d.plotY))};if(!c(o)){for(;h--;)s=e.points[h],!c(s)&&(l=(o.plotX-s.plotX)*(o.plotX-s.plotX)*t+(o.plotY-s.plotY)*(o.plotY-s.plotY)*1,l<n&&(n=l,a=h));return defined$o(a)?e.points[a]:void 0}}Point$2.prototype.highlight=function(){var o=this.series.chart;return this.isNull?o.tooltip&&o.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&o.setFocusToElement(this.graphic),o.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(o){var e=this,t=e.series,r=e.highlightedPoint,n=r&&getPointIndex(r)||0,s=r&&r.series.points,a=e.series&&e.series[e.series.length-1],l=a&&a.points&&a.points[a.points.length-1],h,c;if(!t[0]||!t[0].points)return!1;if(!r)c=o?t[0].points[0]:l;else if(h=t[r.series.index+(o?1:-1)],c=s[n+(o?1:-1)],!c&&h&&(c=h.points[o?0:h.points.length-1]),!c)return!1;return isSkipPoint(c)?(h=c.series,isSkipSeries(h)?e.highlightedPoint=o?h.points[h.points.length-1]:h.points[0]:e.highlightedPoint=c,e.highlightAdjacentPoint(o)):c.highlight()};Series$e.prototype.highlightFirstValidPoint=function(){var o=this.chart.highlightedPoint,e=(o&&o.series)===this?getPointIndex(o):0,t=this.points,r=t.length;if(t&&r){for(var n=e;n<r;++n)if(!isSkipPoint(t[n]))return t[n].highlight();for(var s=e;s>=0;--s)if(!isSkipPoint(t[s]))return t[s].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(o){var e=this,t=e.highlightedPoint,r=e.series&&e.series[e.series.length-1],n=r&&r.points&&r.points[r.points.length-1],s,a,l;return e.highlightedPoint?(s=e.series[t.series.index+(o?-1:1)],!s||(a=getClosestPoint(t,s,4),!a)?!1:isSkipSeries(s)?(a.highlight(),l=e.highlightAdjacentSeries(o),l||(t.highlight(),!1)):(a.highlight(),a.series.highlightFirstValidPoint())):(s=o?e.series&&e.series[0]:r,a=o?s&&s.points&&s.points[0]:n,a?a.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(o){var e=this.highlightedPoint,t=1/0,r;return!defined$o(e.plotX)||!defined$o(e.plotY)?!1:(this.series.forEach(function(n){isSkipSeries(n)||n.points.forEach(function(s){if(!(!defined$o(s.plotY)||!defined$o(s.plotX)||s===e)){var a=s.plotY-e.plotY,l=Math.abs(s.plotX-e.plotX),h=Math.abs(a)*Math.abs(a)+l*l*4;n.yAxis&&n.yAxis.reversed&&(a*=-1),!(a<=0&&o||a>=0&&!o||h<5||isSkipPoint(s))&&h<t&&(t=h,r=s)}})}),r?r.highlight():!1)};function highlightFirstValidPointInChart(o){var e=!1;return delete o.highlightedPoint,e=o.series.reduce(function(t,r){return t||r.highlightFirstValidPoint()},!1),e}function highlightLastValidPointInChart(o){for(var e=o.series.length,t=e,r=!1;t--&&(o.highlightedPoint=o.series[t].points[o.series[t].points.length-1],r=o.series[t].highlightFirstValidPoint(),!r););return r}function updateChartFocusAfterDrilling(o){highlightFirstValidPointInChart(o),o.focusElement&&o.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(o,e){this.keyCodes=e,this.chart=o}extend$T(SeriesKeyboardNavigation.prototype,{init:function(){var o=this,e=this.chart,t=this.eventProvider=new EventProvider;t.addEvent(Series$e,"destroy",function(){return o.onSeriesDestroy(this)}),t.addEvent(e,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),t.addEvent(e,"drilldown",function(r){var n=r.point,s=n.series;o.lastDrilledDownPoint={x:n.x,y:n.y,seriesName:s?s.name:""}}),t.addEvent(e,"drillupall",function(){setTimeout(function(){o.onDrillupAll()},10)}),t.addEvent(Point$2,"afterSetState",function(){var r=this,n=r.graphic&&r.graphic.element;e.highlightedPoint===r&&doc$a.activeElement!==n&&n&&n.focus&&n.focus()})},onDrillupAll:function(){var o=this.lastDrilledDownPoint,e=this.chart,t=o&&getSeriesFromName(e,o.seriesName),r;o&&t&&defined$o(o.x)&&defined$o(o.y)&&(r=getPointFromXY(t,o.x,o.y)),e.container&&e.container.focus(),r&&r.highlight&&r.highlight(),e.focusElement&&e.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var o=this,e=this.keyCodes,t=this.chart,r=t.inverted;return new KeyboardNavigationHandler(t,{keyCodeMap:[[r?[e.up,e.down]:[e.left,e.right],function(n){return o.onKbdSideways(this,n)}],[r?[e.left,e.right]:[e.up,e.down],function(n){return o.onKbdVertical(this,n)}],[[e.enter,e.space],function(n,s){var a=t.highlightedPoint;return a&&(s.point=a,fireEvent$e(a.series,"click",s),a.firePointEvent("click")),this.response.success}]],init:function(n){return o.onHandlerInit(this,n)},terminate:function(){return o.onHandlerTerminate()}})},onKbdSideways:function(o,e){var t=this.keyCodes,r=e===t.right||e===t.down;return this.attemptHighlightAdjacentPoint(o,r)},onKbdVertical:function(o,e){var t=this.chart,r=this.keyCodes,n=e===r.down||e===r.right,s=t.options.accessibility.keyboardNavigation.seriesNavigation;if(s.mode&&s.mode==="serialize")return this.attemptHighlightAdjacentPoint(o,n);var a=t.highlightedPoint&&t.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return t[a](n),o.response.success},onHandlerInit:function(o,e){var t=this.chart;return e>0?highlightFirstValidPointInChart(t):highlightLastValidPointInChart(t),o.response.success},onHandlerTerminate:function(){var o=this.chart;o.tooltip&&o.tooltip.hide(0);var e=o.highlightedPoint&&o.highlightedPoint.series;e&&e.onMouseOut&&e.onMouseOut(),o.highlightedPoint&&o.highlightedPoint.onMouseOut&&o.highlightedPoint.onMouseOut(),delete o.highlightedPoint},attemptHighlightAdjacentPoint:function(o,e){var t=this.chart,r=t.options.accessibility.keyboardNavigation.wrapAround,n=t.highlightAdjacentPoint(e);return n?o.response.success:r?o.init(e?1:-1):o.response[e?"next":"prev"]},onSeriesDestroy:function(o){var e=this.chart,t=e.highlightedPoint&&e.highlightedPoint.series===o;t&&(delete e.highlightedPoint,e.focusElement&&e.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(o){var e=o.annotations||[];return e.reduce(function(t,r){return r.options&&r.options.visible!==!1&&(t=t.concat(r.labels)),t},[])}function getLabelText(o){return o.options&&o.options.accessibility&&o.options.accessibility.description||o.graphic&&o.graphic.text&&o.graphic.text.textStr||""}function getAnnotationLabelDescription(o){var e=o.options&&o.options.accessibility&&o.options.accessibility.description;if(e)return e;var t=o.chart,r=getLabelText(o),n=o.points,s=function(p){return p.graphic&&p.graphic.element&&p.graphic.element.getAttribute("aria-label")||""},a=function(p){var u=p.accessibility&&p.accessibility.valueDescription||s(p),g=p&&p.series.name||"";return(g?g+", ":"")+"data point "+u},l=n.filter(function(p){return!!p.graphic}).map(a).filter(function(p){return!!p}),h=l.length,c=h>1?"MultiplePoints":h?"SinglePoint":"NoPoints",d="accessibility.screenReaderSection.annotations.description"+c,f={annotationText:r,annotation:o,numPoints:h,annotationPoint:l[0],additionalAnnotationPoints:l.slice(1)};return t.langFormat(d,f)}function getAnnotationListItems(o){var e=getChartAnnotationLabels(o);return e.map(function(t){var r=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(t)));return r?"<li>"+r+"</li>":""})}function getAnnotationsInfoHTML$1(o){var e=o.annotations;if(!(e&&e.length))return"";var t=getAnnotationListItems(o);return'<ul style="list-style-type: none">'+t.join(" ")+"</ul>"}function getPointAnnotationTexts$1(o){var e=getChartAnnotationLabels(o.series.chart),t=e.filter(function(r){return r.points.indexOf(o)>-1});return t.length?t.map(function(r){return""+getLabelText(r)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getAnnotationLabelDescription,getAnnotationListItems,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$5=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$6=Utilities.find,isNumber$l=Utilities.isNumber,pick$T=Utilities.pick,defined$n=Utilities.defined;function findFirstPointWithGraphic(o){var e=o.index;return!o.series||!o.series.data||!defined$n(e)?null:find$6(o.series.data,function(t){return!!(t&&typeof t.index<"u"&&t.index>e&&t.graphic&&t.graphic.element)})||null}function shouldAddDummyPoint(o){var e=o.series&&o.series.is("sunburst"),t=o.isNull;return t&&!e}function makeDummyElement(o,e){var t=o.series.chart.renderer,r=t.rect(e.x,e.y,1,1);return r.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),r}function addDummyPointElement(o){var e=o.series,t=findFirstPointWithGraphic(o),r=t&&t.graphic,n=r?r.parentGroup:e.graph||e.group,s=t?{x:pick$T(o.plotX,t.plotX,0),y:pick$T(o.plotY,t.plotY,0)}:{x:pick$T(o.plotX,0),y:pick$T(o.plotY,0)},a=makeDummyElement(o,s);if(n&&n.element)return o.graphic=a,o.hasDummyGraphic=!0,a.add(n),n.element.insertBefore(a.element,r?r.element:null),a.element}function hasMorePointsThanDescriptionThreshold(o){var e=o.chart.options.accessibility,t=e.series.pointDescriptionEnabledThreshold;return!!(t!==!1&&o.points&&o.points.length>=t)}function shouldSetScreenReaderPropsOnPoints(o){var e=o.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(o)&&!e.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(o){var e=o.chart.options.accessibility,t=e.keyboardNavigation.seriesNavigation;return!!(o.points&&(o.points.length<t.pointNavigationEnabledThreshold||t.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(o){var e=o.chart,t=e.options.chart,r=t.options3d&&t.options3d.enabled,n=e.series.length>1,s=e.options.accessibility.series.describeSingleSeries,a=(o.options.accessibility||{}).exposeAsGroupOnly,l=r&&n;return!l&&(n||s||a||hasMorePointsThanDescriptionThreshold(o))}function pointNumberToString(o,e){var t=o.series.chart,r=t.options.accessibility.point||{},n=o.series.tooltipOptions||{},s=t.options.lang;return isNumber$l(e)?numberFormat(e,r.valueDecimals||n.valueDecimals||-1,s.decimalPoint,s.accessibility.thousandsSep||s.thousandsSep):e}function getSeriesDescriptionText(o){var e=o.options.accessibility||{},t=e.description;return t&&o.chart.langFormat("accessibility.series.description",{description:t,series:o})||""}function getSeriesAxisDescriptionText(o,e){var t=o[e];return o.chart.langFormat("accessibility.series."+e+"Description",{name:getAxisDescription$1(t),series:o})}function getPointA11yTimeDescription(o){var e=o.series,t=e.chart,r=t.options.accessibility.point||{},n=e.xAxis&&e.xAxis.dateTime;if(n){var s=n.getXDateFormat(o.x||0,t.options.tooltip.dateTimeLabelFormats),a=r.dateFormatter&&r.dateFormatter(o)||r.dateFormat||s;return t.time.dateFormat(a,o.x||0,void 0)}}function getPointXDescription(o){var e=getPointA11yTimeDescription(o),t=o.series.xAxis||{},r=t.categories&&defined$n(o.category)&&(""+o.category).replace("<br/>"," "),n=o.id&&o.id.indexOf("highcharts-")<0,s="x, "+o.x;return o.name||e||r||(n?o.id:s)}function getPointArrayMapValueDescription(o,e,t){var r=e||"",n=t||"",s=function(l){var h=pointNumberToString(o,pick$T(o[l],o.options[l]));return l+": "+r+h+n},a=o.series.pointArrayMap;return a.reduce(function(l,h){return l+(l.length?", ":"")+s(h)},"")}function getPointValue(o){var e=o.series,t=e.chart.options.accessibility.point||{},r=e.tooltipOptions||{},n=t.valuePrefix||r.valuePrefix||"",s=t.valueSuffix||r.valueSuffix||"",a=typeof o.value<"u"?"value":"y",l=pointNumberToString(o,o[a]);return o.isNull?e.chart.langFormat("accessibility.series.nullPointValue",{point:o}):e.pointArrayMap?getPointArrayMapValueDescription(o,n,s):n+l+s}function getPointAnnotationDescription(o){var e=o.series.chart,t="accessibility.series.pointAnnotationsDescription",r=getPointAnnotationTexts(o),n={point:o,annotations:r};return r.length?e.langFormat(t,n):""}function getPointValueDescription(o){var e=o.series,t=e.chart,r=t.options.accessibility.point.valueDescriptionFormat,n=pick$T(e.xAxis&&e.xAxis.options.accessibility&&e.xAxis.options.accessibility.enabled,!t.angular),s=n?getPointXDescription(o):"",a={point:o,index:defined$n(o.index)?o.index+1:"",xDescription:s,value:getPointValue(o),separator:n?", ":""};return format$5(r,a,t)}function defaultPointDescriptionFormatter$1(o){var e=o.series,t=e.chart,r=getPointValueDescription(o),n=o.options&&o.options.accessibility&&o.options.accessibility.description,s=n?" "+n:"",a=t.series.length>1&&e.name?" "+e.name+".":"",l=getPointAnnotationDescription(o),h=l?" "+l:"";return o.accessibility=o.accessibility||{},o.accessibility.valueDescription=r,r+s+a+h}function setPointScreenReaderAttribs(o,e){var t=o.series,r=t.chart.options.accessibility.point||{},n=t.options.accessibility||{},s=stripHTMLTags$1(n.pointDescriptionFormatter&&n.pointDescriptionFormatter(o)||r.descriptionFormatter&&r.descriptionFormatter(o)||defaultPointDescriptionFormatter$1(o));e.setAttribute("role","img"),e.setAttribute("aria-label",s)}function describePointsInSeries(o){var e=shouldSetScreenReaderPropsOnPoints(o),t=shouldSetKeyboardNavPropsOnPoints(o);(e||t)&&o.points.forEach(function(r){var n=r.graphic&&r.graphic.element||shouldAddDummyPoint(r)&&addDummyPointElement(r),s=r.options&&r.options.accessibility&&r.options.accessibility.enabled===!1;n&&(n.setAttribute("tabindex","-1"),n.style.outline="0",e&&!s?setPointScreenReaderAttribs(r,n):n.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(o){var e=o.chart,t=e.types||[],r=getSeriesDescriptionText(o),n=function(d){return e[d]&&e[d].length>1&&o[d]},s=getSeriesAxisDescriptionText(o,"xAxis"),a=getSeriesAxisDescriptionText(o,"yAxis"),l={name:o.name||"",ix:o.index+1,numSeries:e.series&&e.series.length,numPoints:o.points&&o.points.length,series:o},h=t.length>1?"Combination":"",c=e.langFormat("accessibility.series.summary."+o.type+h,l)||e.langFormat("accessibility.series.summary.default"+h,l);return c+(r?" "+r:"")+(n("yAxis")?" "+a:"")+(n("xAxis")?" "+s:"")}function describeSeriesElement(o,e){var t=o.options.accessibility||{},r=o.chart.options.accessibility,n=r.landmarkVerbosity;t.exposeAsGroupOnly?e.setAttribute("role","img"):n==="all"&&e.setAttribute("role","region"),e.setAttribute("tabindex","-1"),e.style.outline="0",e.setAttribute("aria-label",stripHTMLTags$1(r.series.descriptionFormatter&&r.series.descriptionFormatter(o)||defaultSeriesDescriptionFormatter$1(o)))}function describeSeries$1(o){var e=o.chart,t=getSeriesFirstPointElement(o),r=getSeriesA11yElement(o),n=e.is3d&&e.is3d();r&&(r.lastChild===t&&!n&&reverseChildNodes(r),describePointsInSeries(o),unhideChartElementFromAT$4(e,r),shouldDescribeSeriesElement(o)?describeSeriesElement(o,r):r.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=function(){function o(e,t){this.chart=e,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(t)}return o.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},o.prototype.announce=function(e){var t=this;AST.setElementHTML(this.announceRegion,e),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){t.announceRegion.innerHTML="",delete t.clearAnnouncementRegionTimer},1e3)},o.prototype.addAnnounceRegion=function(e){var t=this.chart.announcerContainer||this.createAnnouncerContainer(),r=this.domElementProvider.createElement("div");return setElAttrs$3(r,{"aria-hidden":!1,"aria-live":e}),visuallyHideElement$1(r),t.appendChild(r),r},o.prototype.createAnnouncerContainer=function(){var e=this.chart,t=doc$9.createElement("div");return setElAttrs$3(t,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),e.renderTo.insertBefore(t,e.renderTo.firstChild),e.announcerContainer=t,t},o}(),extend$S=Utilities.extend,defined$m=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(o){return!!o.options.accessibility.announceNewData.enabled}function findPointInDataArray(o){var e=o.series.data.filter(function(t){return o.x===t.x&&o.y===t.y});return e.length===1?e[0]:o}function getUniqueSeries(o,e){var t=(o||[]).concat(e||[]).reduce(function(r,n){return r[n.name+n.index]=n,r},{});return Object.keys(t).map(function(r){return t[r]})}var NewDataAnnouncer=function(o){this.chart=o};extend$S(NewDataAnnouncer.prototype,{init:function(){var o=this.chart,e=o.options.accessibility.announceNewData,t=e.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(o,t),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var o=this,e=this.chart,t=this.eventProvider;t.addEvent(e,"afterDrilldown",function(){o.lastAnnouncementTime=0}),t.addEvent(Series$e,"updatedData",function(){o.onSeriesUpdatedData(this)}),t.addEvent(e,"afterAddSeries",function(r){o.onSeriesAdded(r.series)}),t.addEvent(Series$e,"addPoint",function(r){o.onPointAdded(r.point)}),t.addEvent(e,"redraw",function(){o.announceDirtyData()})},onSeriesUpdatedData:function(o){var e=this.chart;o.chart===e&&chartHasAnnounceEnabled(e)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[o.name+o.index]=o)},onSeriesAdded:function(o){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[o.name+o.index]=o,this.dirty.newSeries=defined$m(this.dirty.newSeries)?void 0:o)},onPointAdded:function(o){var e=o.series.chart;this.chart===e&&chartHasAnnounceEnabled(e)&&(this.dirty.newPoint=defined$m(this.dirty.newPoint)?void 0:o)},announceDirtyData:function(){var o=this.chart,e=this;if(o.options.accessibility.announceNewData&&this.dirty.hasDirty){var t=this.dirty.newPoint;t&&(t=findPointInDataArray(t)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(r){return e.dirty.allSeries[r]}),this.dirty.newSeries,t),this.dirty={allSeries:{}}}},queueAnnouncement:function(o,e,t){var r=this,n=this.chart,s=n.options.accessibility.announceNewData;if(s.enabled){var a=+new Date,l=a-this.lastAnnouncementTime,h=Math.max(0,s.minAnnounceInterval-l),c=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,o),d=this.buildAnnouncementMessage(c,e,t);d&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:a,message:d,series:c},this.queuedAnnouncementTimer=setTimeout(function(){r&&r.announcer&&(r.lastAnnouncementTime=+new Date,r.announcer.announce(r.queuedAnnouncement.message),delete r.queuedAnnouncement,delete r.queuedAnnouncementTimer)},h))}},buildAnnouncementMessage:function(o,e,t){var r=this.chart,n=r.options.accessibility.announceNewData;if(n.announcementFormatter){var s=n.announcementFormatter(o,e,t);if(s!==!1)return s.length?s:null}var a=H.charts&&H.charts.length>1?"Multiple":"Single",l=e?"newSeriesAnnounce"+a:t?"newPointAnnounce"+a:"newDataAnnounce",h=getChartTitle$2(r);return r.langFormat("accessibility.announceNewData."+l,{chartTitle:h,seriesDesc:e?defaultSeriesDescriptionFormatter(e):null,pointDesc:t?defaultPointDescriptionFormatter(t):null,point:t,series:e})}});var addEvent$z=Utilities.addEvent,merge$M=Utilities.merge;function isWithinDescriptionThreshold(o){var e=o.chart.options.accessibility;return o.points.length<e.series.pointDescriptionEnabledThreshold||e.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(o){var e=o.chart,t=e.options.accessibility.enabled,r=(o.options.accessibility&&o.options.accessibility.enabled)!==!1;return t&&r&&isWithinDescriptionThreshold(o)}function hasIndividualPointMarkerOptions(o){return!!(o._hasPointMarkers&&o.points&&o.points.length)}function unforceSeriesMarkerOptions(o){var e=o.resetA11yMarkerOptions;e&&merge$M(!0,o.options,{marker:{enabled:e.enabled,states:{normal:{opacity:e.states&&e.states.normal&&e.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(o){merge$M(!0,o,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(o){return o.marker.states&&o.marker.states.normal&&o.marker.states.normal.opacity||1}function unforcePointMarkerOptions(o){merge$M(!0,o.marker,{states:{normal:{opacity:getPointMarkerOpacity(o)}}})}function handleForcePointMarkers(o){for(var e=o.points.length;e--;){var t=o.points[e],r=t.options;delete t.hasForcedA11yMarker,r.marker&&(r.marker.enabled?(unforcePointMarkerOptions(r),t.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(r),t.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$z(Series$e,"render",function(){var o=this,e=o.options;shouldForceMarkers(o)?(e.marker&&e.marker.enabled===!1&&(o.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(o.options)),hasIndividualPointMarkerOptions(o)&&handleForcePointMarkers(o)):o.a11yMarkersForced&&(delete o.a11yMarkersForced,unforceSeriesMarkerOptions(o))}),addEvent$z(Series$e,"afterSetOptions",function(o){this.resetA11yMarkerOptions=merge$M(o.options.marker||{},this.userOptions.marker||{})}),addEvent$z(Series$e,"afterRender",function(){var o=this;o.chart.styledMode&&(o.markerGroup&&o.markerGroup[o.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(o)&&o.points.forEach(function(e){e.graphic&&(e.graphic[e.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),e.graphic[e.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$R=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$R(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var o=this;this.addEvent(Tooltip,"refresh",function(){this.chart===o.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(o){o.labelBySeries&&o.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var o=this.chart;o.series.forEach(function(e){var t=(e.options.accessibility&&e.options.accessibility.enabled)!==!1&&e.visible;t?describeSeries(e):hideSeriesFromAT(e)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$d=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Q=Utilities.extend,pick$S=Utilities.pick;function chartHasMapZoom(o){return!!(o.mapZoom&&o.mapNavButtons&&o.mapNavButtons.length)}H.Axis.prototype.panStep=function(o,e){var t=e||3,r=this.getExtremes(),n=(r.max-r.min)/t*o,s=r.max+n,a=r.min+n,l=s-a;o<0&&a<r.dataMin?(a=r.dataMin,s=a+l):o>0&&s>r.dataMax&&(s=r.dataMax,a=s-l),this.setExtremes(a,s)};var ZoomComponent=noop$d;ZoomComponent.prototype=new AccessibilityComponent;extend$Q(ZoomComponent.prototype,{init:function(){var o=this,e=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(t){o.addEvent(e,t,function(){o.updateProxyOverlays()})})},onChartUpdate:function(){var o=this.chart,e=this;o.mapNavButtons&&o.mapNavButtons.forEach(function(t,r){unhideChartElementFromAT$3(o,t.element),e.setMapNavButtonAttrs(t.element,"accessibility.zoom.mapZoom"+(r?"Out":"In"))})},setMapNavButtonAttrs:function(o,e){var t=this.chart,r=t.langFormat(e,{chart:t});setElAttrs$2(o,{tabindex:-1,role:"button","aria-label":r})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var o=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),o.resetZoomButton&&this.recreateProxyButtonAndGroup(o.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",o.langFormat("accessibility.zoom.resetZoomButton",{chart:o})),o.drillUpButton&&this.recreateProxyButtonAndGroup(o.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",o.langFormat("accessibility.drillUpButton",{chart:o,buttonText:o.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(o,e,t,r){removeElement(this[t]),this[t]=this.addProxyGroup(),this[e]=this.createProxyButton(o,this[t],{"aria-label":r,tabindex:-1})},getMapZoomNavigation:function(){var o=this.keyCodes,e=this.chart,t=this;return new KeyboardNavigationHandler(e,{keyCodeMap:[[[o.up,o.down,o.left,o.right],function(r){return t.onMapKbdArrow(this,r)}],[[o.tab],function(r,n){return t.onMapKbdTab(this,n)}],[[o.space,o.enter],function(){return t.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(e)},init:function(r){return t.onMapNavInit(r)}})},onMapKbdArrow:function(o,e){var t=this.keyCodes,r=e===t.up||e===t.down?"yAxis":"xAxis",n=e===t.left||e===t.up?-1:1;return this.chart[r][0].panStep(n),o.response.success},onMapKbdTab:function(o,e){var t,r=this.chart,n=o.response,s=e.shiftKey,a=s&&!this.focusedMapNavButtonIx||!s&&this.focusedMapNavButtonIx;return r.mapNavButtons[this.focusedMapNavButtonIx].setState(0),a?(r.mapZoom(),n[s?"prev":"next"]):(this.focusedMapNavButtonIx+=s?-1:1,t=r.mapNavButtons[this.focusedMapNavButtonIx],r.setFocusToElement(t.box,t.element),t.setState(2),n.success)},onMapKbdClick:function(o){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),o.response.success},onMapNavInit:function(o){var e=this.chart,t=e.mapNavButtons[0],r=e.mapNavButtons[1],n=o>0?t:r;e.setFocusToElement(n.box,n.element),n.setState(2),this.focusedMapNavButtonIx=o>0?0:1},simpleButtonNavigation:function(o,e,t){var r=this.keyCodes,n=this,s=this.chart;return new KeyboardNavigationHandler(s,{keyCodeMap:[[[r.tab,r.up,r.down,r.left,r.right],function(a,l){var h=a===r.tab&&l.shiftKey||a===r.left||a===r.up;return this.response[h?"prev":"next"]}],[[r.space,r.enter],function(){var a=t(this,s);return pick$S(a,this.response.success)}]],validate:function(){var a=s[o]&&s[o].box&&n[e];return a},init:function(){s.setFocusToElement(s[o].box,n[e])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(o,e){e.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(o,e){return e.drillUp(),o.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$y=Utilities.addEvent,extend$P=Utilities.extend;function shouldRunInputNavigation(o){return!!(o.rangeSelector&&o.rangeSelector.inputGroup&&o.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&o.options.rangeSelector.inputEnabled!==!1&&o.rangeSelector.minInput&&o.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(o){var e=this.rangeSelector&&this.rangeSelector.buttons||[],t=this.highlightedRangeSelectorItemIx,r=this.rangeSelector&&this.rangeSelector.selected;return typeof t<"u"&&e[t]&&t!==r&&e[t].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=o,e[o]?(this.setFocusToElement(e[o].box,e[o].element),o!==r&&(this.oldRangeSelectorItemState=e[o].state,e[o].setState(1)),!0):!1};addEvent$y(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$P(RangeSelectorComponent.prototype,{init:function(){var o=this.chart;this.announcer=new Announcer(o,"polite")},onChartUpdate:function(){var o=this.chart,e=this,t=o.rangeSelector;t&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),t.buttons&&t.buttons.length&&t.buttons.forEach(function(r){e.setRangeButtonAttrs(r)}),t.maxInput&&t.minInput&&["minInput","maxInput"].forEach(function(r,n){var s=t[r];s&&(unhideChartElementFromAT$2(o,s),e.setRangeInputAttrs(s,"accessibility.rangeSelector."+(n?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var o=this.chart,e=o.rangeSelector,t=e&&e.dropdown,r=e&&e.buttons||[],n=function(s){return s.setAttribute("aria-hidden",!0)};e&&e.hasVisibleDropdown&&t?(unhideChartElementFromAT$2(o,t),r.forEach(function(s){return n(s.element)})):(t&&n(t),r.forEach(function(s){return unhideChartElementFromAT$2(o,s.element)}))},setDropdownAttrs:function(){var o=this.chart,e=o.rangeSelector&&o.rangeSelector.dropdown;if(e){var t=o.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:o.options.lang.rangeSelectorZoom});e.setAttribute("aria-label",t),e.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(o){setElAttrs$1(o.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(o,e){var t=this.chart;setElAttrs$1(o,{tabindex:-1,"aria-label":t.langFormat(e,{chart:t})})},onButtonNavKbdArrowKey:function(o,e){var t=o.response,r=this.keyCodes,n=this.chart,s=n.options.accessibility.keyboardNavigation.wrapAround,a=e===r.left||e===r.up?-1:1,l=n.highlightRangeSelectorButton(n.highlightedRangeSelectorItemIx+a);return l?t.success:s?(o.init(a),t.success):t[a>0?"next":"prev"]},onButtonNavKbdClick:function(o){var e=o.response,t=this.chart,r=t.oldRangeSelectorItemState===3;return r||this.fakeClickEvent(t.rangeSelector.buttons[t.highlightedRangeSelectorItemIx].element),e.success},onAfterBtnClick:function(){var o=this.chart,e=getAxisRangeDescription$1(o.xAxis[0]),t=o.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:o,axisRangeDescription:e});t&&this.announcer.announce(t)},onInputKbdMove:function(o){var e=this.chart,t=e.rangeSelector,r=e.highlightedInputRangeIx=(e.highlightedInputRangeIx||0)+o,n=r>1||r<0;if(n)e.accessibility&&(e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation[o<0?"prev":"next"]());else if(t){var s=t[r?"maxDateBox":"minDateBox"],a=t[r?"maxInput":"minInput"];s&&a&&e.setFocusToElement(s,a)}},onInputNavInit:function(o){var e=this,t=this,r=this.chart,n=o>0?0:1,s=r.rangeSelector,a=s&&s[n?"maxDateBox":"minDateBox"],l=s&&s.minInput,h=s&&s.maxInput,c=n?h:l;if(r.highlightedInputRangeIx=n,a&&l&&h){r.setFocusToElement(a,c),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var d=function(u){var g=(u.which||u.keyCode)===e.keyCodes.tab;g&&(u.preventDefault(),u.stopPropagation(),t.onInputKbdMove(u.shiftKey?-1:1))},f=addEvent$y(l,"keydown",d),p=addEvent$y(h,"keydown",d);this.removeInputKeydownHandler=function(){f(),p()}}},onInputNavTerminate:function(){var o=this.chart.rangeSelector||{};o.maxInput&&o.hideInput("max"),o.minInput&&o.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var o=this,e=this.chart,t=e.rangeSelector,r=t&&t.dropdown;t&&r&&(e.setFocusToElement(t.buttonGroup,r),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$y(r,"keydown",function(n){var s=(n.which||n.keyCode)===o.keyCodes.tab;s&&(n.preventDefault(),n.stopPropagation(),e.accessibility&&(e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation[n.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var o=this.chart,e=this.keyCodes,t=this;return new KeyboardNavigationHandler(o,{keyCodeMap:[[[e.left,e.right,e.up,e.down],function(r){return t.onButtonNavKbdArrowKey(this,r)}],[[e.enter,e.space],function(){return t.onButtonNavKbdClick(this)}]],validate:function(){return!!(o.rangeSelector&&o.rangeSelector.buttons&&o.rangeSelector.buttons.length)},init:function(r){var n=o.rangeSelector;if(n&&n.hasVisibleDropdown)t.initDropdownNav();else if(n){var s=n.buttons.length-1;o.highlightRangeSelectorButton(r>0?0:s)}},terminate:function(){t.removeDropdownKeydownHandler&&(t.removeDropdownKeydownHandler(),delete t.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var o=this.chart,e=this;return new KeyboardNavigationHandler(o,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(o)},init:function(t){e.onInputNavInit(t)},terminate:function(){e.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$4=FormatUtilities.format,doc$8=H.doc,extend$O=Utilities.extend,pick$R=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(o){return o.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(o,e){return e.mapTitle?o.langFormat("accessibility.chartTypes.mapTypeDescription",e):o.langFormat("accessibility.chartTypes.unknownMap",e)}function getTypeDescForCombinationChart(o,e){return o.langFormat("accessibility.chartTypes.combinationChart",e)}function getTypeDescForEmptyChart(o,e){return o.langFormat("accessibility.chartTypes.emptyChart",e)}function buildTypeDescriptionFromSeries(o,e,t){var r=e[0],n=o.langFormat("accessibility.seriesTypeDescriptions."+r,t),s=o.series&&o.series.length<2?"Single":"Multiple";return(o.langFormat("accessibility.chartTypes."+r+s,t)||o.langFormat("accessibility.chartTypes.default"+s,t))+(n?" "+n:"")}function getTableSummary(o){return o.langFormat("accessibility.table.tableSummary",{chart:o})}Chart$1.prototype.getTypeDescription=function(o){var e=o[0],t=this.series&&this.series[0]||{},r={numSeries:this.series.length,numPoints:t.points&&t.points.length,chart:this,mapTitle:t.mapTitle};return e?e==="map"?getTypeDescForMapChart(this,r):this.types.length>1?getTypeDescForCombinationChart(this,r):buildTypeDescriptionFromSeries(this,o,r):getTypeDescForEmptyChart(this,r)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$O(InfoRegionsComponent.prototype,{init:function(){var o=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(o,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(o,"afterViewData",function(t){e.dataTableDiv=t,setTimeout(function(){e.focusDataTable()},300)}),this.announcer=new Announcer(o,"assertive")},initRegionsDefinitions:function(){var o=this;this.screenReaderSections={before:{element:null,buildContent:function(e){var t=e.options.accessibility.screenReaderSection.beforeChartFormatter;return t?t(e):o.defaultBeforeChartFormatter(e)},insertIntoDOM:function(e,t){t.renderTo.insertBefore(e,t.renderTo.firstChild)},afterInserted:function(){typeof o.sonifyButtonId<"u"&&o.initSonifyButton(o.sonifyButtonId),typeof o.dataTableButtonId<"u"&&o.initDataTableButton(o.dataTableButtonId)}},after:{element:null,buildContent:function(e){var t=e.options.accessibility.screenReaderSection.afterChartFormatter;return t?t(e):o.defaultAfterChartFormatter()},insertIntoDOM:function(e,t){t.renderTo.insertBefore(e,t.container.nextSibling)},afterInserted:function(){o.chart.accessibility&&o.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var o=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(e){o.updateScreenReaderSection(e)})},getLinkedDescriptionElement:function(){var o=this.chart.options,e=o.accessibility.linkedDescription;if(e){if(typeof e!="string")return e;var t=format$4(e,this.chart),r=doc$8.querySelectorAll(t);if(r.length===1)return r[0]}},setLinkedDescriptionAttrs:function(){var o=this.linkedDescriptionElement;o&&(o.setAttribute("aria-hidden","true"),addClass(o,"highcharts-linked-description"))},updateScreenReaderSection:function(o){var e=this.chart,t=this.screenReaderSections[o],r=t.buildContent(e),n=t.element=t.element||this.createElement("div"),s=n.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(n,o),AST.setElementHTML(s,r),n.appendChild(s),t.insertIntoDOM(n,e),visuallyHideElement(s),unhideChartElementFromAT$1(e,s),t.afterInserted&&t.afterInserted()},setScreenReaderSectionAttribs:function(o,e){var t="accessibility.screenReaderSection."+e+"RegionLabel",r=this.chart,n=r.langFormat(t,{chart:r,chartTitle:getChartTitle$1(r)}),s="highcharts-screen-reader-region-"+e+"-"+r.index;setElAttrs(o,{id:s,"aria-label":n}),o.style.position="relative",r.options.accessibility.landmarkVerbosity==="all"&&n&&o.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var o=this.chart,e=o.options.accessibility.screenReaderSection.beforeChartFormat,t=this.getAxesDescription(),r=o.sonify&&o.options.sonification&&o.options.sonification.enabled,n="highcharts-a11y-sonify-data-btn-"+o.index,s="hc-linkto-highcharts-data-table-"+o.index,a=getAnnotationsInfoHTML(o),l=o.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:o}),h={headingTagName:getHeadingTagNameForElement(o.renderTo),chartTitle:getChartTitle$1(o),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:t.xAxis,yAxisDescription:t.yAxis,playAsSoundButton:r?this.getSonifyButtonText(n):"",viewTableButton:o.getCSV?this.getDataTableButtonText(s):"",annotationsTitle:a?l:"",annotationsList:a},c=H.i18nFormat(e,h,o);return this.dataTableButtonId=s,this.sonifyButtonId=n,stripEmptyHTMLTags(c)},defaultAfterChartFormatter:function(){var o=this.chart,e=o.options.accessibility.screenReaderSection.afterChartFormat,t={endOfChartMarker:this.getEndOfChartMarkerText()},r=H.i18nFormat(e,t,o);return stripEmptyHTMLTags(r)},getLinkedDescription:function(){var o=this.linkedDescriptionElement,e=o&&o.innerHTML||"";return stripHTMLTagsFromString(e)},getLongdescText:function(){var o=this.chart.options,e=o.caption,t=e&&e.text,r=this.getLinkedDescription();return o.accessibility.description||r||t||""},getTypeDescriptionText:function(){var o=this.chart;return o.types?o.options.accessibility.typeDescription||o.getTypeDescription(o.types):""},getDataTableButtonText:function(o){var e=this.chart,t=e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:getChartTitle$1(e)});return'<button id="'+o+'">'+t+"</button>"},getSonifyButtonText:function(o){var e=this.chart;if(e.options.sonification&&e.options.sonification.enabled===!1)return"";var t=e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:getChartTitle$1(e)});return'<button id="'+o+'">'+t+"</button>"},getSubtitleText:function(){var o=this.chart.options.subtitle;return stripHTMLTagsFromString(o&&o.text||"")},getEndOfChartMarkerText:function(){var o=this.chart,e=o.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:o}),t="highcharts-end-of-chart-marker-"+o.index;return'<div id="'+t+'">'+e+"</div>"},onDataTableCreated:function(o){var e=this.chart;if(e.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var t=o.tree.attributes||{};t.tabindex=-1,t.summary=getTableSummary(e),o.tree.attributes=t}},focusDataTable:function(){var o=this.dataTableDiv,e=o&&o.getElementsByTagName("table")[0];e&&e.focus&&e.focus()},initSonifyButton:function(o){var e=this,t=this.sonifyButton=getElement(o),r=this.chart,n=function(s){t&&(t.setAttribute("aria-hidden","true"),t.setAttribute("aria-label","")),s.preventDefault(),s.stopPropagation();var a=r.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:r});e.announcer.announce(a),setTimeout(function(){t&&(t.removeAttribute("aria-hidden"),t.removeAttribute("aria-label")),r.sonify&&r.sonify()},1e3)};t&&r&&(setElAttrs(t,{tabindex:-1}),t.onclick=function(s){var a=r.options.accessibility&&r.options.accessibility.screenReaderSection.onPlayAsSoundClick;(a||n).call(this,s,r)})},initDataTableButton:function(o){var e=this.viewDataTableButton=getElement(o),t=this.chart,r=o.replace("hc-linkto-","");e&&(setElAttrs(e,{tabindex:-1,"aria-expanded":!!getElement(r)}),e.onclick=t.options.accessibility.screenReaderSection.onViewDataTableClick||function(){t.viewData()})},getAxesDescription:function(){var o=this.chart,e=function(l,h){var c=o[l];return c.length>1||c[0]&&pick$R(c[0].options.accessibility&&c[0].options.accessibility.enabled,h)},t=!!o.types&&o.types.indexOf("map")<0,r=!!o.hasCartesianSeries,n=e("xAxis",!o.angular&&r&&t),s=e("yAxis",r&&t),a={};return n&&(a.xAxis=this.getAxisDescriptionText("xAxis")),s&&(a.yAxis=this.getAxisDescriptionText("yAxis")),a},getAxisDescriptionText:function(o){var e=this.chart,t=e[o];return e.langFormat("accessibility.axis."+o+"Description"+(t.length>1?"Plural":"Singular"),{chart:e,names:t.map(function(r){return getAxisDescription(r)}),ranges:t.map(function(r){return getAxisRangeDescription(r)}),numAxes:t.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$N=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$N(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var o=this.chart,e="highcharts-title-"+o.index,t=stripHTMLTags(o.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(o)}));if(t.length){var r=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");r.textContent=t,r.id=e,o.renderTo.insertBefore(r,o.renderTo.firstChild)}},setSVGContainerLabel:function(){var o=this.chart,e=o.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(o)});o.renderer.box&&e.length&&o.renderer.box.setAttribute("aria-label",e)},setGraphicContainerAttrs:function(){var o=this.chart,e=o.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(o)});e.length&&o.container.setAttribute("aria-label",e)},setRenderToAttrs:function(){var o=this.chart;o.options.accessibility.landmarkVerbosity!=="disabled"?o.renderTo.setAttribute("role","region"):o.renderTo.removeAttribute("role"),o.renderTo.setAttribute("aria-label",o.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(o),chart:o}))},makeCreditsAccessible:function(){var o=this.chart,e=o.credits;e&&(e.textStr&&e.element.setAttribute("aria-label",o.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(e.textStr)})),unhideChartElementFromAT(o,e.element))},getKeyboardNavigation:function(){var o=this.chart;return new KeyboardNavigationHandler(o,{keyCodeMap:[],validate:function(){return!0},init:function(){var e=o.accessibility;e&&e.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var o=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&o)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var e=doc$6.createElement("div"),t="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";e.style.backgroundImage="url("+t+")",doc$6.body.appendChild(e);var r=(e.currentStyle||win$3.getComputedStyle(e)).backgroundImage;return doc$6.body.removeChild(e),r==="none"}return!1},setHighContrastTheme:function(o){o.highContrastModeActive=!0;var e=o.options.accessibility.highContrastTheme;o.update(e,!1),o.series.forEach(function(t){var r=e.plotOptions[t.type]||{};t.update({color:r.color||"windowText",colors:[r.color||"windowText"],borderColor:r.borderColor||"window"}),t.points.forEach(function(n){n.options&&n.options.color&&n.update({color:r.color||"windowText",borderColor:r.borderColor||"window"},!1)})}),o.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$1=Utilities.error,pick$Q=Utilities.pick;function traverseSetOption(o,e,t){for(var r=o,n,s=0;s<e.length-1;++s)n=e[s],r=r[n]=pick$Q(r[n],{});r[e[e.length-1]]=t}function deprecateFromOptionsMap(o,e,t,r){function n(l,h){return h.reduce(function(c,d){return c[d]},l)}var s=n(o.options,e),a=n(o.options,t);Object.keys(r).forEach(function(l){var h,c=s[l];typeof c<"u"&&(traverseSetOption(a,r[l],c),error$1(32,!1,o,(h={},h[e.join(".")+"."+l]=t.join(".")+"."+r[l].join("."),h)))})}function copyDeprecatedChartOptions(o){var e=o.options.chart,t=o.options.accessibility||{};["description","typeDescription"].forEach(function(r){var n;e[r]&&(t[r]=e[r],error$1(32,!1,o,(n={},n["chart."+r]="use accessibility."+r,n)))})}function copyDeprecatedAxisOptions(o){o.axes.forEach(function(e){var t=e.options;t&&t.description&&(t.accessibility=t.accessibility||{},t.accessibility.description=t.description,error$1(32,!1,o,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(o){var e={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};o.series.forEach(function(t){Object.keys(e).forEach(function(r){var n,s=t.options[r];typeof s<"u"&&(traverseSetOption(t.options,e[r],r==="skipKeyboardNavigation"?!s:s),error$1(32,!1,o,(n={},n["series."+r]="series."+e[r].join("."),n)))})})}function copyDeprecatedTopLevelAccessibilityOptions(o){deprecateFromOptionsMap(o,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(o){deprecateFromOptionsMap(o,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(o){deprecateFromOptionsMap(o,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(o){copyDeprecatedChartOptions(o),copyDeprecatedAxisOptions(o),o.series&&copyDeprecatedSeriesOptions(o),copyDeprecatedTopLevelAccessibilityOptions(o),copyDeprecatedKeyboardNavigationOptions(o),copyDeprecatedLangOptions(o)}var format$3=FormatUtilities.format,pick$P=Utilities.pick;function stringTrim(o){return o.trim&&o.trim()||o.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(o,e){var t=o.indexOf("#each("),r=o.indexOf("#plural("),n=o.indexOf("["),s=o.indexOf("]"),a,l;if(t>-1){var h=o.slice(t).indexOf(")")+t,c=o.substring(0,t),d=o.substring(h+1),f=o.substring(t+6,h),p=f.split(","),u=Number(p[1]),g=void 0;if(l="",a=e[p[0]],a){u=isNaN(u)?a.length:u,g=u<0?a.length+u:Math.min(u,a.length);for(var v=0;v<g;++v)l+=c+a[v]+d}return l.length?l:""}if(r>-1){var y=o.slice(r).indexOf(")")+r,m=o.substring(r+8,y),x=m.split(","),b=Number(e[x[0]]);switch(b){case 0:l=pick$P(x[4],x[1]);break;case 1:l=pick$P(x[2],x[1]);break;case 2:l=pick$P(x[3],x[1]);break;default:l=x[1]}return l?stringTrim(l):""}if(n>-1){var $=o.substring(0,n),S=Number(o.substring(n+1,s)),k=void 0;return a=e[$],!isNaN(S)&&a&&(S<0?(k=a[a.length+S],typeof k>"u"&&(k=a[0])):(k=a[S],typeof k>"u"&&(k=a[a.length-1]))),typeof k<"u"?k:""}return"{"+o+"}"}H.i18nFormat=function(o,e,t){var r=function(h,c){var d=h.slice(c||0),f=d.indexOf("{"),p=d.indexOf("}");if(f>-1&&p>f)return{statement:d.substring(f+1,p),begin:c+f+1,end:c+p}},n=[],s,a,l=0;do s=r(o,l),a=o.substring(l,s&&s.begin-1),a.length&&n.push({value:a,type:"constant"}),s&&n.push({value:s.statement,type:"statement"}),l=s?s.end+1:l+1;while(s);return n.forEach(function(h){h.type==="statement"&&(h.value=formatExtendedStatement(h.value,e))}),format$3(n.reduce(function(h,c){return h+c.value},""),e,t)};Chart$1.prototype.langFormat=function(o,e){for(var t=o.split("."),r=this.options.lang,n=0;n<t.length;++n)r=r&&r[t[n]];return typeof r=="string"?H.i18nFormat(r,e,this):""};var addEvent$x=Utilities.addEvent,extend$M=Utilities.extend,pick$O=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(o){if(!o.focusBorderDestroyHook){var e=o.destroy;o.destroy=function(){return o.focusBorder&&o.focusBorder.destroy&&o.focusBorder.destroy(),e.apply(o,arguments)},o.focusBorderDestroyHook=e}}function removeDestroyFocusBorderHook(o){o.focusBorderDestroyHook&&(o.destroy=o.focusBorderDestroyHook,delete o.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(o){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];o.focusBorderUpdateHooks||(o.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(r){var n=r+"Setter",s=o[n]||o._defaultSetter;o.focusBorderUpdateHooks[n]=s,o[n]=function(){var a=s.apply(o,arguments);return o.addFocusBorder.apply(o,e),a}}))}function removeUpdateFocusBorderHooks(o){o.focusBorderUpdateHooks&&(Object.keys(o.focusBorderUpdateHooks).forEach(function(e){var t=o.focusBorderUpdateHooks[e];t===o._defaultSetter?delete o[e]:o[e]=t}),delete o.focusBorderUpdateHooks)}extend$M(SVGElement.prototype,{addFocusBorder:function(o,e){this.focusBorder&&this.removeFocusBorder();var t=this.getBBox(),r=pick$O(o,3);t.x+=this.translateX?this.translateX:0,t.y+=this.translateY?this.translateY:0;var n=t.x-r,s=t.y-r,a=t.width+2*r,l=t.height+2*r;function h(v){var y=0,m=0;return v.attr("text-anchor")==="middle"?y=m=.5:v.rotation?y=.25:m=.75,{x:y,y:m}}var c=this instanceof SVGLabel;if(this.element.nodeName==="text"||c){var d=!!this.rotation,f=c?{x:d?1:0,y:0}:h(this),p=+this.attr("x"),u=+this.attr("y");if(isNaN(p)||(n=p-t.width*f.x-r),isNaN(u)||(s=u-t.height*f.y-r),c&&d){var g=a;a=l,l=g,isNaN(p)||(n=p-t.height*f.x-r),isNaN(u)||(s=u-t.width*f.y-r)}}this.focusBorder=this.renderer.rect(n,s,a,l,parseInt((e&&e.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:e&&e.stroke,"stroke-width":e&&e.strokeWidth}),addUpdateFocusBorderHooks(this,o,e),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var o=this.focusElement,e=this.options.accessibility.keyboardNavigation.focusBorder;o&&(o.removeFocusBorder(),e.enabled&&o.addFocusBorder(e.margin,{stroke:e.style.color,strokeWidth:e.style.lineWidth,r:e.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(o,e){var t=this.options.accessibility.keyboardNavigation.focusBorder,r=e||o.element;r&&r.focus&&(r.hcEvents&&r.hcEvents.focusin||addEvent$x(r,"focusin",function(){}),r.focus(),t.hideBrowserFocusOutline&&(r.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=o,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$4=DefaultOptions.defaultOptions,addEvent$w=Utilities.addEvent,extend$L=Utilities.extend,fireEvent$d=Utilities.fireEvent,merge$L=Utilities.merge;merge$L(!0,defaultOptions$4,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(o){this.init(o)}Accessibility.prototype={init:function(o){if(this.chart=o,!doc$5.addEventListener||!o.renderer.isSVG){o.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(o),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(o,this.components),this.update()},initComponents:function(){var o=this.chart,e=o.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},e.customComponents&&extend$L(this.components,e.customComponents);var t=this.components;this.getComponentOrder().forEach(function(r){t[r].initBase(o),t[r].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var o=Object.keys(this.components).filter(function(e){return e!=="series"});return["series"].concat(o)},update:function(){var o=this.components,e=this.chart,t=e.options.accessibility;fireEvent$d(e,"beforeA11yUpdate"),e.types=this.getChartTypes(),this.getComponentOrder().forEach(function(r){o[r].onChartUpdate(),fireEvent$d(e,"afterA11yComponentUpdate",{name:r,component:o[r]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!e.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(e),fireEvent$d(e,"afterA11yUpdate",{accessibility:this})},destroy:function(){var o=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),o.renderTo&&o.renderTo.setAttribute("aria-hidden",!0),o.focusElement&&o.focusElement.removeFocusBorder()},getChartTypes:function(){var o={};return this.chart.series.forEach(function(e){o[e.type]=1}),Object.keys(o)}};Chart$1.prototype.updateA11yEnabled=function(){var o=this.accessibility,e=this.options.accessibility;e&&e.enabled?o?o.update():this.accessibility=o=new Accessibility(this):o?(o.destroy&&o.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$w(Chart$1,"render",function(o){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var e=this.accessibility;e&&e.getComponentOrder().forEach(function(t){e.components[t].onChartRender()})});addEvent$w(Chart$1,"update",function(o){var e=o.options.accessibility;e&&(e.customComponents&&(this.options.accessibility.customComponents=e.customComponents,delete e.customComponents),merge$L(!0,this.options.accessibility,e),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$w(Point$2,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(o){addEvent$w(Chart$1,o,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(o){addEvent$w(Series$e,o,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(o){addEvent$w(Chart$1,o,function(){this.accessibility&&this.accessibility.update()})});addEvent$w(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$v=Utilities.addEvent,fireEvent$c=Utilities.fireEvent,objectEach$c=Utilities.objectEach,pick$N=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var o=this,e=function(r){addEvent$v(r,H.isTouchDevice?"touchstart":"mousedown",function(n){o.onMouseDown(n)},{passive:!1})};if(e(this.graphic.element),(o.labels||[]).forEach(function(r){r.options.useHTML&&r.graphic.text&&e(r.graphic.text.element)}),objectEach$c(o.options.events,function(r,n){var s=function(a){(n!=="click"||!o.cancelClick)&&r.call(o,o.chart.pointer.normalize(a),o.target)};(o.nonDOMEvents||[]).indexOf(n)===-1?o.graphic.on(n,s):addEvent$v(o,n,s,{passive:!1})}),o.options.draggable&&(addEvent$v(o,"drag",o.onDrag),!o.graphic.renderer.styledMode)){var t={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[o.options.draggable]};o.graphic.css(t),(o.labels||[]).forEach(function(r){r.options.useHTML&&r.graphic.text&&r.graphic.text.css(t)})}o.isUpdating||fireEvent$c(o,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(o){var e=this,t=e.chart.pointer,r,n;o.preventDefault&&o.preventDefault(),o.button!==2&&(o=t.normalize(o),r=o.chartX,n=o.chartY,e.cancelClick=!1,e.chart.hasDraggedAnnotation=!0,e.removeDrag=addEvent$v(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(s){e.hasDragged=!0,s=t.normalize(s),s.prevChartX=r,s.prevChartY=n,fireEvent$c(e,"drag",s),r=s.chartX,n=s.chartY},H.isTouchDevice?{passive:!1}:void 0),e.removeMouseUp=addEvent$v(H.doc,H.isTouchDevice?"touchend":"mouseup",function(s){var a=pick$N(e.target&&e.target.annotation,e.target);a&&(a.cancelClick=e.hasDragged),e.cancelClick=e.hasDragged,e.hasDragged=!1,e.chart.hasDraggedAnnotation=!1,fireEvent$c(pick$N(a,e),"afterUpdate"),e.onMouseUp(s)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(o){var e=this.chart,t=this.target||this,r=e.options.annotations,n=e.annotations.indexOf(t);this.removeDocEvents(),r[n]=t.options},onDrag:function(o){if(this.chart.isInsidePlot(o.chartX-this.chart.plotLeft,o.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var e=this.mouseMoveToTranslation(o);this.options.draggable==="x"&&(e.y=0),this.options.draggable==="y"&&(e.x=0),this.points.length?this.translate(e.x,e.y):(this.shapes.forEach(function(t){t.translate(e.x,e.y)}),this.labels.forEach(function(t){t.translate(e.x,e.y)})),this.redraw(!1)}},mouseMoveToRadians:function(o,e,t){var r=o.prevChartY-t,n=o.prevChartX-e,s=o.chartY-t,a=o.chartX-e,l;return this.chart.inverted&&(l=n,n=r,r=l,l=a,a=s,s=l),Math.atan2(s,a)-Math.atan2(r,n)},mouseMoveToTranslation:function(o){var e=o.chartX-o.prevChartX,t=o.chartY-o.prevChartY,r;return this.chart.inverted&&(r=t,t=e,e=r),{x:e,y:t}},mouseMoveToScale:function(o,e,t){var r=o.prevChartX-e,n=o.prevChartY-t,s=o.chartX-e,a=o.chartY-t,l=(s||1)/(r||1),h=(a||1)/(n||1),c;return this.chart.inverted&&(c=h,h=l,l=c),{x:l,y:h}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$K=Utilities.merge,pick$M=Utilities.pick,ControlPoint=function(){function o(e,t,r,n){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=e,this.target=t,this.options=r,this.index=pick$M(r.index,n)}return o.prototype.setVisibility=function(e){this.graphic.attr("visibility",e?"visible":"hidden"),this.options.visible=e},o.prototype.render=function(){var e=this.chart,t=this.options;this.graphic=e.renderer.symbol(t.symbol,0,0,t.width,t.height).add(e.controlPointsGroup).css(t.style),this.setVisibility(t.visible),this.addEvents()},o.prototype.redraw=function(e){this.graphic[e?"animate":"attr"](this.options.positioner.call(this,this.target))},o.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},o.prototype.update=function(e){var t=this.chart,r=this.target,n=this.index,s=merge$K(!0,this.options,e);this.destroy(),this.constructor(t,r,s,n),this.render(t.controlPointsGroup),this.redraw()},o}(),defined$l=Utilities.defined,fireEvent$b=Utilities.fireEvent,MockPoint=function(){function o(e,t,r){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:e,getPlotBox:Series$e.prototype.getPlotBox},this.target=t||null,this.options=r,this.applyOptions(this.getOptions())}return o.fromPoint=function(e){return new o(e.series.chart,null,{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis})},o.pointToPixels=function(e,t){var r=e.series,n=r.chart,s=e.plotX,a=e.plotY,l;return n.inverted&&(e.mock?(s=e.plotY,a=e.plotX):(s=n.plotWidth-e.plotY,a=n.plotHeight-e.plotX)),r&&!t&&(l=r.getPlotBox(),s+=l.translateX,a+=l.translateY),{x:s,y:a}},o.pointToOptions=function(e){return{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis}},o.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},o.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},o.prototype.applyOptions=function(e){this.command=e.command,this.setAxis(e,"x"),this.setAxis(e,"y"),this.refresh()},o.prototype.setAxis=function(e,t){var r=t+"Axis",n=e[r],s=this.series.chart;this.series[r]=n instanceof Axis?n:defined$l(n)?s[r][n]||s.get(n):null},o.prototype.toAnchor=function(){var e=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(e[0]=this.plotY,e[1]=this.plotX),e},o.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},o.prototype.isInsidePlot=function(){var e=this.plotX,t=this.plotY,r=this.series.xAxis,n=this.series.yAxis,s={x:e,y:t,isInsidePlot:!0};return r&&(s.isInsidePlot=defined$l(e)&&e>=0&&e<=r.len),n&&(s.isInsidePlot=s.isInsidePlot&&defined$l(t)&&t>=0&&t<=n.len),fireEvent$b(this.series.chart,"afterIsInsidePlot",s),s.isInsidePlot},o.prototype.refresh=function(){var e=this.series,t=e.xAxis,r=e.yAxis,n=this.getOptions();t?(this.x=n.x,this.plotX=t.toPixels(n.x,!0)):(this.x=null,this.plotX=n.x),r?(this.y=n.y,this.plotY=r.toPixels(n.y,!0)):(this.y=null,this.plotY=n.y),this.isInside=this.isInsidePlot()},o.prototype.translate=function(e,t,r,n){this.hasDynamicOptions()||(this.plotX+=r,this.plotY+=n,this.refreshOptions())},o.prototype.scale=function(e,t,r,n){if(!this.hasDynamicOptions()){var s=this.plotX*r,a=this.plotY*n,l=(1-r)*e,h=(1-n)*t;this.plotX=l+s,this.plotY=h+a,this.refreshOptions()}},o.prototype.rotate=function(e,t,r){if(!this.hasDynamicOptions()){var n=Math.cos(r),s=Math.sin(r),a=this.plotX,l=this.plotY,h=void 0,c=void 0;a-=e,l-=t,h=a*n-l*s,c=a*s+l*n,this.plotX=h+e,this.plotY=c+t,this.refreshOptions()}},o.prototype.refreshOptions=function(){var e=this.series,t=e.xAxis,r=e.yAxis;this.x=this.options.x=t?this.options.x=t.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=r?r.toValue(this.plotY,!0):this.plotY},o}(),isObject$7=Utilities.isObject,isString$2=Utilities.isString,merge$J=Utilities.merge,splat$6=Utilities.splat,controllableMixin={init:function(o,e,t){this.annotation=o,this.chart=o.chart,this.options=e,this.points=[],this.controlPoints=[],this.index=t,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var o=this.options;return o.points||o.point&&splat$6(o.point)},attrsFromOptions:function(o){var e=this.constructor.attrsMap,t={},r,n,s=this.chart.styledMode;for(r in o)n=e[r],n&&(!s||["fill","stroke","stroke-width"].indexOf(n)===-1)&&(t[n]=o[r]);return t},anchor:function(o){var e=o.series.getPlotBox(),t=o.series.chart,r=o.mock?o.toAnchor():Tooltip.prototype.getAnchor.call({chart:o.series.chart},o),n={x:r[0]+(this.options.x||0),y:r[1]+(this.options.y||0),height:r[2]||0,width:r[3]||0};return{relativePosition:n,absolutePosition:merge$J(n,{x:n.x+(o.mock?e.translateX:t.plotLeft),y:n.y+(o.mock?e.translateY:t.plotTop)})}},point:function(o,e){if(o&&o.series)return o;if(!e||e.series===null){if(isObject$7(o))e=new MockPoint(this.chart,this,o);else if(isString$2(o))e=this.chart.get(o)||null;else if(typeof o=="function"){var t=o.call(e,this);e=t.series?t:new MockPoint(this.chart,this,o)}}return e},linkPoints:function(){var o=this.getPointsOptions(),e=this.points,t=o&&o.length||0,r,n;for(r=0;r<t;r++){if(n=this.point(o[r],e[r]),!n){e.length=0;return}n.mock&&n.refresh(),e[r]=n}return e},addControlPoints:function(){var o=this.options.controlPoints;(o||[]).forEach(function(e,t){var r=merge$J(this.options.controlPointOptions,e);r.index||(r.index=t),o[t]=r,this.controlPoints.push(new ControlPoint(this.chart,this,r))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(o){this.controlPoints.forEach(function(e){e.render()})},redraw:function(o){this.controlPoints.forEach(function(e){e.redraw(o)})},transform:function(o,e,t,r,n){if(this.chart.inverted){var s=e;e=t,t=s}this.points.forEach(function(a,l){this.transformPoint(o,e,t,r,n,l)},this)},transformPoint:function(o,e,t,r,n,s){var a=this.points[s];a.mock||(a=this.points[s]=MockPoint.fromPoint(a)),a[o](e,t,r,n)},translate:function(o,e){this.transform("translate",null,null,o,e)},translatePoint:function(o,e,t){this.transformPoint("translate",null,null,o,e,t)},translateShape:function(o,e){var t=this.annotation.chart,r=this.annotation.userOptions,n=t.annotations.indexOf(this.annotation),s=t.options.annotations[n];this.translatePoint(o,e,0),s[this.collection][this.index].point=this.options.point,r[this.collection][this.index].point=this.options.point},rotate:function(o,e,t){this.transform("rotate",o,e,t)},scale:function(o,e,t,r){this.transform("scale",o,e,t,r)},setControlPointsVisibility:function(o){this.controlPoints.forEach(function(e){e.setVisibility(o)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(o){o.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(o){var e=this.annotation,t=merge$J(!0,this.options,o),r=this.graphic.parentGroup;this.destroy(),this.constructor(e,t,this.index),this.render(r),this.redraw()}},addEvent$u=Utilities.addEvent,defined$k=Utilities.defined,merge$I=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(o,e){var t={attributes:{id:o}},r={stroke:e.color||"none",fill:e.color||"rgba(0, 0, 0, 0.75)"};t.children=e.children&&e.children.map(function(a){return merge$I(r,a)});var n=merge$I(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},e,t),s=this.definition(n);return s.id=o,s};function createMarkerSetter(o){return function(e){this.attr(o,"url(#"+e+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(o){var e=o.options,t=o.chart,r=t.options.defs,n=e.fill,s=defined$k(n)&&n!=="none"?n:e.stroke,a=function(l){var h=e[l],c,d,f,p;if(h){for(f in r)if(c=r[f],(h===(c.attributes&&c.attributes.id)||h===c.id)&&c.tagName==="marker"){d=c;break}d&&(p=o[l]=t.renderer.addMarker((e.id||uniqueKey$2())+"-"+h,merge$I(d,{color:s})),o.attr(l,p.getAttribute("id")))}};["markerStart","markerEnd"].forEach(a)}};addEvent$u(Chart$1,"afterGetContainer",function(){this.options.defs=merge$I(defaultMarkers,this.options.defs||{})});var extend$K=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=function(){function o(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(e,t,r),this.collection="shapes"}return o.prototype.toD=function(){var e=this.options.d;if(e)return typeof e=="function"?e.call(this):e;var t=this.points,r=t.length,n=r,s=t[0],a=n&&this.anchor(s).absolutePosition,l=0,h,c=[];if(a)for(c.push(["M",a.x,a.y]);++l<r&&n;)s=t[l],h=s.command||"L",a=this.anchor(s).absolutePosition,h==="M"?c.push([h,a.x,a.y]):h==="L"?c.push([h,a.x,a.y]):h==="Z"&&c.push([h]),n=s.series.visible;return n?this.chart.renderer.crispLine(c,this.graphic.strokeWidth()):null},o.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},o.prototype.render=function(e){var t=this.options,r=this.attrsFromOptions(t);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(r).add(e),t.className&&this.graphic.addClass(t.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(e),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+t.snap*2}),controllableMixin.render.call(this),extend$K(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},o.prototype.redraw=function(e){var t=this.toD(),r=e?"animate":"attr";t?(this.graphic[r]({d:t}),this.tracker[r]({d:t})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!t,controllableMixin.redraw.call(this,e)},o.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},o}(),merge$H=Utilities.merge,ControllableRect=function(){function o(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return o.prototype.render=function(e){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(t).add(e),controllableMixin.render.call(this)},o.prototype.redraw=function(e){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[e?"animate":"attr"]({x:t.x,y:t.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,e)},o.attrsMap=merge$H(ControllablePath.attrsMap,{width:"width",height:"height"}),o}(),merge$G=Utilities.merge,ControllableCircle=function(){function o(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return o.prototype.render=function(e){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(t).add(e),controllableMixin.render.call(this)},o.prototype.redraw=function(e){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[e?"animate":"attr"]({x:t.x,y:t.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,e)},o.prototype.setRadius=function(e){this.options.r=e},o.attrsMap=merge$G(ControllablePath.attrsMap,{r:"r"}),o}(),format$2=FormatUtilities.format,symbols$2=SVGRenderer.prototype.symbols,extend$J=Utilities.extend,isNumber$k=Utilities.isNumber,pick$L=Utilities.pick,ControllableLabel=function(){function o(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(e,t,r),this.collection="labels"}return o.alignedPosition=function(e,t){var r=e.align,n=e.verticalAlign,s=(t.x||0)+(e.x||0),a=(t.y||0)+(e.y||0),l,h;return r==="right"?l=1:r==="center"&&(l=2),l&&(s+=(t.width-(e.width||0))/l),n==="bottom"?h=1:n==="middle"&&(h=2),h&&(a+=(t.height-(e.height||0))/h),{x:Math.round(s),y:Math.round(a)}},o.justifiedOptions=function(e,t,r,n){var s=r.align,a=r.verticalAlign,l=t.box?0:t.padding||0,h=t.getBBox(),c={align:s,verticalAlign:a,x:r.x,y:r.y,width:t.width,height:t.height},d=(n.x||0)-e.plotLeft,f=(n.y||0)-e.plotTop,p;return p=d+l,p<0&&(s==="right"?c.align="left":c.x=(c.x||0)-p),p=d+h.width-l,p>e.plotWidth&&(s==="left"?c.align="right":c.x=(c.x||0)+e.plotWidth-p),p=f+l,p<0&&(a==="bottom"?c.verticalAlign="top":c.y=(c.y||0)-p),p=f+h.height-l,p>e.plotHeight&&(a==="top"?c.verticalAlign="bottom":c.y=(c.y||0)+e.plotHeight-p),c},o.prototype.translatePoint=function(e,t){controllableMixin.translatePoint.call(this,e,t,0)},o.prototype.translate=function(e,t){var r=this.annotation.chart,n=this.annotation.userOptions,s=r.annotations.indexOf(this.annotation),a=r.options.annotations,l=a[s];if(r.inverted){var h=e;e=t,t=h}this.options.x+=e,this.options.y+=t,l[this.collection][this.index].x=this.options.x,l[this.collection][this.index].y=this.options.y,n[this.collection][this.index].x=this.options.x,n[this.collection][this.index].y=this.options.y},o.prototype.render=function(e){var t=this.options,r=this.attrsFromOptions(t),n=t.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,t.shape,null,null,t.useHTML,null,"annotation-label").attr(r).add(e),this.annotation.chart.styledMode||(n.color==="contrast"&&(n.color=this.annotation.chart.renderer.getContrast(o.shapesWithoutBackground.indexOf(t.shape)>-1?"#FFFFFF":t.backgroundColor)),this.graphic.css(t.style).shadow(t.shadow)),t.className&&this.graphic.addClass(t.className),this.graphic.labelrank=t.labelrank,controllableMixin.render.call(this)},o.prototype.redraw=function(e){var t=this.options,r=this.text||t.format||t.text,n=this.graphic,s=this.points[0];n.attr({text:r?format$2(r,s.getLabelConfig(),this.annotation.chart):t.formatter.call(s,this)});var a=this.anchor(s),l=this.position(a);l?(n.alignAttr=l,l.anchorX=a.absolutePosition.x,l.anchorY=a.absolutePosition.y,n[e?"animate":"attr"](l)):n.attr({x:0,y:-9999}),n.placed=!!l,controllableMixin.redraw.call(this,e)},o.prototype.anchor=function(e){var t=controllableMixin.anchor.apply(this,arguments),r=this.options.x||0,n=this.options.y||0;return t.absolutePosition.x-=r,t.absolutePosition.y-=n,t.relativePosition.x-=r,t.relativePosition.y-=n,t},o.prototype.position=function(e){var t=this.graphic,r=this.annotation.chart,n=this.points[0],s=this.options,a=e.absolutePosition,l=e.relativePosition,h,c,d,f,p=n.series.visible&&MockPoint.prototype.isInsidePlot.call(n),u=t.width,g=u===void 0?0:u,v=t.height,y=v===void 0?0:v;return p&&(s.distance?h=Tooltip.prototype.getPosition.call({chart:r,distance:pick$L(s.distance,16)},g,y,{plotX:l.x,plotY:l.y,negative:n.negative,ttBelow:n.ttBelow,h:l.height||l.width}):s.positioner?h=s.positioner.call(this):(c={x:a.x,y:a.y,width:0,height:0},h=o.alignedPosition(extend$J(s,{width:g,height:y}),c),this.options.overflow==="justify"&&(h=o.alignedPosition(o.justifiedOptions(r,t,s,h),c))),s.crop&&(d=h.x-r.plotLeft,f=h.y-r.plotTop,p=r.isInsidePlot(d,f)&&r.isInsidePlot(d+g,f+y))),p?h:null},o.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},o.shapesWithoutBackground=["connector"],o}();symbols$2.connector=function(o,e,t,r,n){var s=n&&n.anchorX,a=n&&n.anchorY,l,h,c=t/2;return isNumber$k(s)&&isNumber$k(a)&&(l=[["M",s,a]],h=e-a,h<0&&(h=-r-h),h<t&&(c=s<o+t/2?h:t-h),a>e+r?l.push(["L",o+c,e+r]):a<e?l.push(["L",o+c,e]):s<o?l.push(["L",o,e+r/2]):s>o+t&&l.push(["L",o+t,e+r/2])),l||[]};var ControllableImage=function(){function o(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return o.prototype.render=function(e){var t=this.attrsFromOptions(this.options),r=this.options;this.graphic=this.annotation.chart.renderer.image(r.src,0,-9e9,r.width,r.height).attr(t).add(e),this.graphic.width=r.width,this.graphic.height=r.height,controllableMixin.render.call(this)},o.prototype.redraw=function(e){var t=this.anchor(this.points[0]),r=ControllableLabel.prototype.position.call(this,t);r?this.graphic[e?"animate":"attr"]({x:r.x,y:r.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!r,controllableMixin.redraw.call(this,e)},o.attrsMap={width:"width",height:"height",zIndex:"zIndex"},o}(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$t=Utilities.addEvent,defined$j=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase=Utilities.erase,extend$I=Utilities.extend,find$5=Utilities.find,fireEvent$a=Utilities.fireEvent,merge$F=Utilities.merge,pick$K=Utilities.pick,splat$5=Utilities.splat,wrap$a=Utilities.wrap,Annotation=function(){function o(e,t){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var r;this.chart=e,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$F(this.defaultOptions,t),this.userOptions=t,r=this.getLabelsAndShapesOptions(this.options,t),this.options.labels=r.labels,this.options.shapes=r.shapes,this.init(e,this.options)}return o.prototype.init=function(){var e=this.chart,t=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(e,t)},o.prototype.getLabelsAndShapesOptions=function(e,t){var r={};return["labels","shapes"].forEach(function(n){e[n]&&(t[n]?r[n]=splat$5(t[n]).map(function(s,a){return merge$F(e[n][a],s)}):r[n]=e[n])}),r},o.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(e,t){var r=this.initShape(e,t);merge$F(!0,this.options.shapes[t],r.options)},this)},o.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(e,t){var r=this.initLabel(e,t);merge$F(!0,this.options.labels[t],r.options)},this)},o.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},o.prototype.setClipAxes=function(){var e=this.chart.xAxis,t=this.chart.yAxis,r=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(n,s){var a=s&&(s.point||s.points&&s.points[0]);return[e[a&&a.xAxis]||n[0],t[a&&a.yAxis]||n[1]]},[]);this.clipXAxis=r[0],this.clipYAxis=r[1]},o.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},o.prototype.setLabelCollector=function(){var e=this;e.labelCollector=function(){return e.labels.reduce(function(t,r){return r.options.allowOverlap||t.push(r.graphic),t},[])},e.chart.labelCollectors.push(e.labelCollector)},o.prototype.setOptions=function(e){this.options=merge$F(this.defaultOptions,e)},o.prototype.redraw=function(e){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,e),this.redrawItems(this.labels,e),controllableMixin.redraw.call(this,e)},o.prototype.redrawItems=function(e,t){for(var r=e.length;r--;)this.redrawItem(e[r],t)},o.prototype.renderItems=function(e){for(var t=e.length;t--;)this.renderItem(e[t])},o.prototype.render=function(){var e=this.chart.renderer;this.graphic=e.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=e.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=e.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},o.prototype.setVisibility=function(e){var t=this.options,r=this.chart.navigationBindings,n=pick$K(e,!t.visible);this.graphic.attr("visibility",n?"visible":"hidden"),n||(this.setControlPointsVisibility(!1),r.activeAnnotation===this&&r.popup&&r.popup.formType==="annotation-toolbar"&&fireEvent$a(r,"closePopup")),t.visible=n},o.prototype.setControlPointsVisibility=function(e){var t=function(r){r.setControlPointsVisibility(e)};controllableMixin.setControlPointsVisibility.call(this,e),this.shapes.forEach(t),this.labels.forEach(t)},o.prototype.destroy=function(){var e=this.chart,t=function(r){r.destroy()};this.labels.forEach(t),this.shapes.forEach(t),this.clipXAxis=null,this.clipYAxis=null,erase(e.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,e)},o.prototype.remove=function(){return this.chart.removeAnnotation(this)},o.prototype.update=function(e,t){var r=this.chart,n=this.getLabelsAndShapesOptions(this.userOptions,e),s=r.annotations.indexOf(this),a=merge$F(!0,this.userOptions,e);a.labels=n.labels,a.shapes=n.shapes,this.destroy(),this.constructor(r,a),r.options.annotations[s]=a,this.isUpdating=!0,pick$K(t,!0)&&r.redraw(),fireEvent$a(this,"afterUpdate"),this.isUpdating=!1},o.prototype.initShape=function(e,t){var r=merge$F(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},e),n=new o.shapesMap[r.type](this,r,t);return n.itemType="shape",this.shapes.push(n),n},o.prototype.initLabel=function(e,t){var r=merge$F(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},e),n=new ControllableLabel(this,r,t);return n.itemType="label",this.labels.push(n),n},o.prototype.redrawItem=function(e,t){e.linkPoints(),e.shouldBeDrawn()?(e.graphic||this.renderItem(e),e.redraw(pick$K(t,!0)&&e.graphic.placed),e.points.length&&this.adjustVisibility(e)):this.destroyItem(e)},o.prototype.adjustVisibility=function(e){var t=!1,r=e.graphic;e.points.forEach(function(n){n.series.visible!==!1&&n.visible!==!1&&(t=!0)}),t?r.visibility==="hidden"&&r.show():r.hide()},o.prototype.destroyItem=function(e){erase(this[e.itemType+"s"],e),e.destroy()},o.prototype.renderItem=function(e){e.render(e.itemType==="label"?this.labelsGroup:this.shapesGroup)},o.ControlPoint=ControlPoint,o.MockPoint=MockPoint,o.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},o.types={},o}();merge$F(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$F(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$j(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(o,e,t,r){e=e||Annotation,extend$I(o.prototype,merge$F(e.prototype,t)),o.prototype.defaultOptions=merge$F(o.prototype.defaultOptions,r||{})};extend$I(chartProto,{initAnnotation:function(o){var e=Annotation.types[o.type]||Annotation,t=new e(this,o);return this.annotations.push(t),t},addAnnotation:function(o,e){var t=this.initAnnotation(o);return this.options.annotations.push(t.options),pick$K(e,!0)&&(t.redraw(),t.graphic.attr({opacity:1})),t},removeAnnotation:function(o){var e=this.annotations,t=o.coll==="annotations"?o:find$5(e,function(r){return r.options.id===o});t&&(fireEvent$a(t,"remove"),erase(this.options.annotations,t.options),erase(e,t),t.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(o){o.redraw(),o.graphic.animate({opacity:1},o.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$t(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(o){o.plotBoxClip=this.renderer.clipRect(this.plotBox),o.controlPointsGroup=o.renderer.g("control-points").attr({zIndex:99}).clip(o.plotBoxClip).add(),o.options.annotations.forEach(function(e,t){if(!o.annotations.some(function(n){return n.options===e})){var r=o.initAnnotation(e);o.options.annotations[t]=r.options}}),o.drawAnnotations(),addEvent$t(o,"redraw",o.drawAnnotations),addEvent$t(o,"destroy",function(){o.plotBoxClip.destroy(),o.controlPointsGroup.destroy()}),addEvent$t(o,"exportData",function(e){var t=o.annotations,r=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,n=!e.dataRows[1].xValues,s=o.options.lang&&o.options.lang.exportData&&o.options.lang.exportData.annotationHeader,a=function(g){var v;return r&&(v=r(g),v!==!1)?v:(v=s+" "+g,n?{columnTitle:v,topLevelColumnTitle:v}:v)},l=e.dataRows[0].length,h=o.options.exporting&&o.options.exporting.csv&&o.options.exporting.csv.annotations&&o.options.exporting.csv.annotations.itemDelimiter,c=o.options.exporting&&o.options.exporting.csv&&o.options.exporting.csv.annotations&&o.options.exporting.csv.annotations.join;t.forEach(function(g){g.options.labelOptions.includeInDataExport&&g.labels.forEach(function(v){if(v.options.text){var y=v.options.text;v.points.forEach(function(m){var x=m.x,b=m.series.xAxis?m.series.xAxis.options.index:-1,$=!1;if(b===-1){for(var S=e.dataRows[0].length,k=new Array(S),A=0;A<S;++A)k[A]="";k.push(y),k.xValues=[],k.xValues[b]=x,e.dataRows.push(k),$=!0}if($||e.dataRows.forEach(function(M,P){!$&&M.xValues&&b!==void 0&&x===M.xValues[b]&&(c&&M.length>l?M[M.length-1]+=h+y:M.push(y),$=!0)}),!$){for(var S=e.dataRows[0].length,k=new Array(S),A=0;A<S;++A)k[A]="";k[0]=x,k.push(y),k.xValues=[],b!==void 0&&(k.xValues[b]=x),e.dataRows.push(k)}})}})});var d=0;e.dataRows.forEach(function(g){d=Math.max(d,g.length)});for(var f=d-e.dataRows[0].length,p=0;p<f;p++){var u=a(p+1);n?(e.dataRows[0].push(u.topLevelColumnTitle),e.dataRows[1].push(u.columnTitle)):e.dataRows[0].push(u)}})});wrap$a(Pointer.prototype,"onContainerMouseDown",function(o){this.chart.hasDraggedAnnotation||o.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(o){o.navigation||(o.navigation={updates:[],update:function(e,t){this.updates.forEach(function(r){r.update.call(r.context,e,t)})}})},addUpdate:function(o,e){e.navigation||this.initUpdate(e),e.navigation.updates.push({update:o,context:e})}},format$1=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$s=Utilities.addEvent,attr=Utilities.attr,fireEvent$9=Utilities.fireEvent,isArray$7=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$j=Utilities.isNumber,isObject$6=Utilities.isObject,merge$E=Utilities.merge,objectEach$b=Utilities.objectEach,pick$J=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(o,e){var t=win$2.Element.prototype,r=t.matches||t.msMatchesSelector||t.webkitMatchesSelector,n=null;if(t.closest)n=t.closest.call(o,e);else do{if(r.call(o,e))return o;o=o.parentElement||o.parentNode}while(o!==null&&o.nodeType===1);return n}var bindingsUtils={getFieldType:function(o){return{string:"text",number:"number",boolean:"checkbox"}[typeof o]},updateRectSize:function(o,e){var t=e.chart,r=e.options.typeOptions,n=isNumber$j(r.xAxis)&&t.xAxis[r.xAxis],s=isNumber$j(r.yAxis)&&t.yAxis[r.yAxis];if(n&&s){var a=n.toValue(o[n.horiz?"chartX":"chartY"]),l=s.toValue(o[s.horiz?"chartX":"chartY"]),h=a-r.point.x,c=r.point.y-l;e.update({typeOptions:{background:{width:t.inverted?c:h,height:t.inverted?h:c}}})}},getAssignedAxis:function(o){return o.filter(function(e){var t=e.axis.min,r=e.axis.max,n=pick$J(e.axis.minPointOffset,0);return isNumber$j(t)&&isNumber$j(r)&&e.value>=t-n&&e.value<=r+n&&!e.axis.options.isInternal})[0]}},NavigationBindings=function(){function o(e,t){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=e,this.options=t,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return o.prototype.initEvents=function(){var e=this,t=e.chart,r=e.container,n=e.options;e.boundClassNames={},objectEach$b(n.bindings||{},function(s){e.boundClassNames[s.className]=s}),[].forEach.call(r,function(s){e.eventsToUnbind.push(addEvent$s(s,"click",function(a){var l=e.getButtonEvents(s,a);l&&l.button.className.indexOf("highcharts-disabled-btn")===-1&&e.bindingsButtonClick(l.button,l.events,a)}))}),objectEach$b(n.events||{},function(s,a){isFunction$1(s)&&e.eventsToUnbind.push(addEvent$s(e,a,s,{passive:!1}))}),e.eventsToUnbind.push(addEvent$s(t.container,"click",function(s){!t.cancelClick&&t.isInsidePlot(s.chartX-t.plotLeft,s.chartY-t.plotTop,{visiblePlotOnly:!0})&&e.bindingsChartClick(this,s)})),e.eventsToUnbind.push(addEvent$s(t.container,H.isTouchDevice?"touchmove":"mousemove",function(s){e.bindingsContainerMouseMove(this,s)},H.isTouchDevice?{passive:!1}:void 0))},o.prototype.initUpdate=function(){var e=this;chartNavigation.addUpdate(function(t){e.update(t)},this.chart)},o.prototype.bindingsButtonClick=function(e,t,r){var n=this,s=n.chart;n.selectedButtonElement&&(fireEvent$9(n,"deselectButton",{button:n.selectedButtonElement}),n.nextEvent&&(n.currentUserDetails&&n.currentUserDetails.coll==="annotations"&&s.removeAnnotation(n.currentUserDetails),n.mouseMoveEvent=n.nextEvent=!1)),n.selectedButton=t,n.selectedButtonElement=e,fireEvent$9(n,"selectButton",{button:e}),t.init&&t.init.call(n,e,r),(t.start||t.steps)&&s.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},o.prototype.bindingsChartClick=function(e,t){e=this.chart;var r=this,n=r.activeAnnotation,s=r.selectedButton,a=e.renderer.boxWrapper;n&&(!n.cancelClick&&!t.activeAnnotation&&t.target.parentNode&&!closestPolyfill(t.target,"."+PREFIX$1+"popup")?fireEvent$9(r,"closePopup"):n.cancelClick&&setTimeout(function(){n.cancelClick=!1},0)),!(!s||!s.start)&&(r.nextEvent?(r.nextEvent(t,r.currentUserDetails),r.steps&&(r.stepIndex++,s.steps[r.stepIndex]?r.mouseMoveEvent=r.nextEvent=s.steps[r.stepIndex]:(fireEvent$9(r,"deselectButton",{button:r.selectedButtonElement}),a.removeClass(PREFIX$1+"draw-mode"),s.end&&s.end.call(r,t,r.currentUserDetails),r.nextEvent=!1,r.mouseMoveEvent=!1,r.selectedButton=null))):(r.currentUserDetails=s.start.call(r,t),r.currentUserDetails&&s.steps?(r.stepIndex=0,r.steps=!0,r.mouseMoveEvent=r.nextEvent=s.steps[r.stepIndex]):(fireEvent$9(r,"deselectButton",{button:r.selectedButtonElement}),a.removeClass(PREFIX$1+"draw-mode"),r.steps=!1,r.selectedButton=null,s.end&&s.end.call(r,t,r.currentUserDetails))))},o.prototype.bindingsContainerMouseMove=function(e,t){this.mouseMoveEvent&&this.mouseMoveEvent(t,this.currentUserDetails)},o.prototype.fieldsToOptions=function(e,t){return objectEach$b(e,function(r,n){var s=parseFloat(r),a=n.split("."),l=t,h=a.length-1;isNumber$j(s)&&!r.match(/px/g)&&!n.match(/format/g)&&(r=s),r!==""&&r!=="undefined"&&a.forEach(function(c,d){var f=pick$J(a[d+1],"");h===d?l[c]=r:(l[c]||(l[c]=f.match(/\d/g)?[]:{}),l=l[c])})}),t},o.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},o.prototype.annotationToFields=function(e){var t=e.options,r=o.annotationsEditable,n=r.nestedOptions,s=this.utils.getFieldType,a=pick$J(t.type,t.shapes&&t.shapes[0]&&t.shapes[0].type,t.labels&&t.labels[0]&&t.labels[0].itemType,"label"),l=o.annotationsNonEditable[t.langKey]||[],h={langKey:t.langKey,type:a};function c(d,f,p,u){var g;p&&d&&l.indexOf(f)===-1&&((p.indexOf&&p.indexOf(f))>=0||p[f]||p===!0)&&(isArray$7(d)?(u[f]=[],d.forEach(function(v,y){isObject$6(v)?(u[f][y]={},objectEach$b(v,function(m,x){c(m,x,n[f],u[f][y])})):c(v,0,n[f],u[f])})):isObject$6(d)?(g={},isArray$7(u)?(u.push(g),g[f]={},g=g[f]):u[f]=g,objectEach$b(d,function(v,y){c(v,y,f===0?p:n[f],g)})):f==="format"?u[f]=[format$1(d,e.labels[0].points[0]).toString(),"text"]:isArray$7(u)?u.push([d,s(d)]):u[f]=[d,s(d)])}return objectEach$b(t,function(d,f){f==="typeOptions"?(h[f]={},objectEach$b(t[f],function(p,u){c(p,u,n,h[f])})):c(d,f,r[a],h)}),h},o.prototype.getClickedClassNames=function(e,t){for(var r=t.target,n=[],s;r;)if(s=attr(r,"class"),s&&(n=n.concat(s.split(" ").map(function(a){return[a,r]}))),r=r.parentNode,r===e)return n;return n},o.prototype.getButtonEvents=function(e,t){var r=this,n=this.getClickedClassNames(e,t),s;return n.forEach(function(a){r.boundClassNames[a[0]]&&!s&&(s={events:r.boundClassNames[a[0]],button:a[1]})}),s},o.prototype.update=function(e){this.options=merge$E(!0,this.options,e),this.removeEvents(),this.initEvents()},o.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(e){e()})},o.prototype.destroy=function(){this.removeEvents()},o.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},o.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},o}();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var o=this,e=o.options;e&&e.navigation&&e.navigation.bindings&&(o.navigationBindings=new NavigationBindings(o,e.navigation),o.navigationBindings.initEvents(),o.navigationBindings.initUpdate())};addEvent$s(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$s(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$s(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$s(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(o){var e=o.prototype.defaultOptions.events&&o.prototype.defaultOptions.events.click;function t(r){var n=this,s=n.chart.navigationBindings,a=s.activeAnnotation;e&&e.call(n,r),a!==n?(s.deselectAnnotation(),s.activeAnnotation=n,n.setControlPointsVisibility(!0),fireEvent$9(s,"showPopup",{annotation:n,formType:"annotation-toolbar",options:s.annotationToFields(n),onSubmit:function(l){var h={},c;l.actionType==="remove"?(s.activeAnnotation=!1,s.chart.removeAnnotation(n)):(s.fieldsToOptions(l.fields,h),s.deselectAnnotation(),c=h.typeOptions,n.options.type==="measure"&&(c.crosshairY.enabled=c.crosshairY.strokeWidth!==0,c.crosshairX.enabled=c.crosshairX.strokeWidth!==0),n.update(h))}})):fireEvent$9(s,"closePopup"),r.activeAnnotation=!0}merge$E(!0,o.prototype.defaultOptions.events,{click:t})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$b(Annotation.types,function(o){selectableAnnotation(o)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(o){var e=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis),n=this.chart.options.navigation;if(!(!t||!r))return this.chart.addAnnotation(merge$E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:t.value,y:r.value,xAxis:t.axis.options.index,yAxis:r.axis.options.index},r:5}]},n.annotationsOptions,n.bindings.circleAnnotation.annotationsOptions))},steps:[function(o,e){var t=e.options.shapes[0].point,r=this.chart.inverted,n,s,a;isNumber$j(t.xAxis)&&isNumber$j(t.yAxis)&&(n=this.chart.xAxis[t.xAxis].toPixels(t.x),s=this.chart.yAxis[t.yAxis].toPixels(t.y),a=Math.max(Math.sqrt(Math.pow(r?s-o.chartX:n-o.chartX,2)+Math.pow(r?n-o.chartY:s-o.chartY,2)),5)),e.update({shapes:[{r:a}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(o){var e=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis);if(!(!t||!r)){var n=t.value,s=r.value,a=t.axis.options.index,l=r.axis.options.index,h=this.chart.options.navigation;return this.chart.addAnnotation(merge$E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:a,yAxis:l,x:n,y:s},{xAxis:a,yAxis:l,x:n,y:s},{xAxis:a,yAxis:l,x:n,y:s},{xAxis:a,yAxis:l,x:n,y:s}]}]},h.annotationsOptions,h.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(o,e){var t=e.options.shapes[0].points,r=this.chart.pointer.getCoordinates(o),n=this.utils.getAssignedAxis(r.xAxis),s=this.utils.getAssignedAxis(r.yAxis),a,l;n&&s&&(a=n.value,l=s.value,t[1].x=a,t[2].x=a,t[2].y=l,t[3].y=l,e.update({shapes:[{points:t}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(o){var e=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis),n=this.chart.options.navigation;if(!(!t||!r))return this.chart.addAnnotation(merge$E({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:t.axis.options.index,yAxis:r.axis.options.index,x:t.value,y:r.value},overflow:"none",crop:!0}]},n.annotationsOptions,n.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$s(Chart$1,"render",function(){var o=this,e=o.navigationBindings,t="highcharts-disabled-btn";if(o&&e){var r=!1;o.series.forEach(function(n){!n.options.isInternal&&n.visible&&(r=!0)}),objectEach$b(e.boundClassNames,function(n,s){if(o.navigationBindings&&o.navigationBindings.container&&o.navigationBindings.container[0]){var a=o.navigationBindings.container[0].querySelectorAll("."+s);if(a)for(var l=0;l<a.length;l++){var h=a[l];n.noDataState==="normal"||r?h.className.indexOf(t)!==-1&&h.classList.remove(t):h.className.indexOf(t)===-1&&(h.className+=" "+t)}}})}});addEvent$s(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$1=DefaultOptions.getOptions,addEvent$r=Utilities.addEvent,createElement$2=Utilities.createElement,defined$i=Utilities.defined,fireEvent$8=Utilities.fireEvent,isArray$6=Utilities.isArray,isObject$5=Utilities.isObject,isString$1=Utilities.isString,objectEach$a=Utilities.objectEach,pick$I=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$9=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$9(Pointer.prototype,"onContainerMouseDown",function(o,e){var t=e.target&&e.target.className;isString$1(t)&&t.indexOf(PREFIX+"popup-field")>=0||o.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(o,e,t){this.init(o,e,t)};H.Popup.prototype={init:function(o,e,t){this.chart=t,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,o),this.lang=this.getLangpack(),this.iconsURL=e,this.addCloseBtn()},addCloseBtn:function(){var o=this,e,t=this.iconsURL;e=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),e.style["background-image"]="url("+(t.match(/png|svg|jpeg|jpg|gif/ig)?t:t+"close.svg")+")",["click","touchstart"].forEach(function(r){addEvent$r(e,r,function(){o.chart?fireEvent$8(o.chart.navigationBindings,"closePopup"):o.closePopup()})})},addColsContainer:function(o){var e,t;return t=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,o),e=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,o),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,e),{lhsCol:t,rhsCol:e}},addInput:function(o,e,t,r){var n=o.split("."),s=n[n.length-1],a=this.lang,l=PREFIX+e+"-"+s;l.match(indexFilter)||createElement$2(LABEL,{htmlFor:l},void 0,t).appendChild(doc$3.createTextNode(a[s]||s)),r!==""&&createElement$2(INPUT,{name:l,value:r[0],type:r[1],className:PREFIX+"popup-field"},void 0,t).setAttribute(PREFIX+"data-name",o)},addButton:function(o,e,t,r,n){var s=this,a=this.closePopup,l=this.getFields,h;return h=createElement$2(BUTTON,void 0,void 0,o),h.appendChild(doc$3.createTextNode(e)),["click","touchstart"].forEach(function(c){addEvent$r(h,c,function(){return a.call(s),r(l(n,t))})}),h},getFields:function(o,e){var t=o.querySelectorAll("input"),r="#"+PREFIX+"select-series > option:checked",n="#"+PREFIX+"select-volume > option:checked",s=o.querySelectorAll(r)[0],a=o.querySelectorAll(n)[0],l,h,c;return c={actionType:e,linkedTo:s&&s.getAttribute("value"),fields:{}},[].forEach.call(t,function(d){h=d.getAttribute(PREFIX+"data-name"),l=d.getAttribute(PREFIX+"data-series-id"),l?c.seriesId=d.value:h?c.fields[h]=d.value:c.type=d.value}),a&&(c.fields["params.volumeSeriesID"]=a.getAttribute("value")),c},showPopup:function(){var o=this.container,e=PREFIX+"annotation-toolbar",t=o.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,o.innerHTML="",o.className.indexOf(e)>=0&&(o.classList.remove(e),o.removeAttribute("style")),o.appendChild(t),o.style.display="block",o.style.height=""},closePopup:function(){var o=pick$I(this.popup&&this.popup.container,this.container);o.style.display="none"},showForm:function(o,e,t,r){e&&(this.popup=e.navigationBindings.popup,this.showPopup(),o==="indicators"&&this.indicators.addForm.call(this,e,t,r),o==="annotation-toolbar"&&this.annotations.addToolbar.call(this,e,t,r),o==="annotation-edit"&&this.annotations.addForm.call(this,e,t,r),o==="flag"&&this.annotations.addForm.call(this,e,t,r,!0),this.formType=o,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$1().lang.navigation.popup},annotations:{addToolbar:function(o,e,t){var r=this,n=this.lang,s=this.popup.container,a=this.showForm,l=PREFIX+"annotation-toolbar",h;s.className.indexOf(l)===-1&&(s.className+=" "+l),o&&(s.style.top=o.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,s).appendChild(doc$3.createTextNode(pick$I(n[e.langKey]||e.langKey,e.shapes&&e.shapes[0].type))),h=this.addButton(s,n.removeButton||"remove","remove",t,s),h.className+=" "+PREFIX+"annotation-remove-button",h.style["background-image"]="url("+this.iconsURL+"destroy.svg)",h=this.addButton(s,n.editButton||"edit","edit",function(){a.call(r,"annotation-edit",o,e,t)},s),h.className+=" "+PREFIX+"annotation-edit-button",h.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(o,e,t,r){var n=this.popup.container,s=this.lang,a,l;o&&(l=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,n),l.appendChild(doc$3.createTextNode(s[e.langKey]||e.langKey||"")),l=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,n),a=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,n),this.annotations.addFormFields.call(this,l,o,"",e,[],!0),this.addButton(a,r?s.addButton||"add":s.saveButton||"save",r?"add":"save",t,n))},addFormFields:function(o,e,t,r,n,s){var a=this,l=this.annotations.addFormFields,h=this.addInput,c=this.lang,d,f;e&&(objectEach$a(r,function(p,u){d=t!==""?t+"."+u:u,isObject$5(p)&&(!isArray$6(p)||isArray$6(p)&&isObject$5(p[0])?(f=c[u]||u,f.match(indexFilter)||n.push([!0,f,o]),l.call(a,o,e,d,p,n,!1)):n.push([a,d,"annotation",o,p]))}),s&&(stableSort$3(n,function(p){return p[1].match(/format/g)?-1:1}),isFirefox&&n.reverse(),n.forEach(function(p){p[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,p[2]).appendChild(doc$3.createTextNode(p[1])):h.apply(p[0],p.splice(1))})))}},indicators:{addForm:function(o,e,t){var r,n=this.indicators,s=this.lang,a;o&&(this.tabs.init.call(this,o),r=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(r[0]),n.addIndicatorList.call(this,o,r[0],"add"),a=r[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(a,s.addButton||"add","add",t,a),this.addColsContainer(r[1]),n.addIndicatorList.call(this,o,r[1],"edit"),a=r[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(a,s.saveButton||"save","edit",t,a),this.addButton(a,s.removeButton||"remove","remove",t,a))},addIndicatorList:function(o,e,t){var r=this,n=e.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],s=e.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],a=t==="edit",l=a?o.series:o.options.plotOptions,h=this.indicators.addFormFields,c,d,f;o&&(d=createElement$2(UL,{className:PREFIX+"indicator-list"},null,n),c=s.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$a(l,function(p,u){var g=p.options;if(p.params||g&&g.params){var v=r.indicators.getNameType(p,u),y=v.type;f=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,d),f.appendChild(doc$3.createTextNode(v.name)),["click","touchstart"].forEach(function(m){addEvent$r(f,m,function(){h.call(r,o,a?p:l[y],v.type,c),a&&p.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+y,value:p.options.id},null,c).setAttribute(PREFIX+"data-series-id",p.options.id)})})}}),d.childNodes.length>0&&d.childNodes[0].click())},getNameType:function(o,e){var t=o.options,r=H.seriesTypes,n=r[e]&&r[e].prototype.nameBase||e.toUpperCase(),s=e;return t&&t.type&&(s=o.options.type,n=o.name),{name:n,type:s}},listAllSeries:function(o,e,t,r,n){var s=PREFIX+e+"-type-"+o,a=this.lang,l,h;t&&(createElement$2(LABEL,{htmlFor:s},null,r).appendChild(doc$3.createTextNode(a[e]||e)),l=createElement$2(SELECT,{name:s,className:PREFIX+"popup-field"},null,r),l.setAttribute("id",PREFIX+"select-"+e),t.series.forEach(function(c){h=c.options,!h.params&&h.id&&h.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:h.id},null,l).appendChild(doc$3.createTextNode(h.name||h.id))}),defined$i(n)&&(l.value=n))},addFormFields:function(o,e,t,r){var n=e.params||e.options.params,s=this.indicators.getNameType;r.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,r).appendChild(doc$3.createTextNode(s(e,t).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+t,value:t},null,r),this.indicators.listAllSeries.call(this,t,"series",o,r,e.linkedParent&&n.volumeSeriesID),n.volumeSeriesID&&this.indicators.listAllSeries.call(this,t,"volume",o,r,e.linkedParent&&e.linkedParent.options.id),this.indicators.addParamInputs.call(this,o,"params",n,t,r)},addParamInputs:function(o,e,t,r,n){var s=this,a=this.indicators.addParamInputs,l=this.addInput,h;o&&objectEach$a(t,function(c,d){h=e+"."+d,c!==void 0&&(isObject$5(c)?(l.call(s,h,r,n,""),a.call(s,o,h,c,r,n)):h!=="params.volumeSeriesID"&&l.call(s,h,r,n,[c,"text"]))})},getAmount:function(){var o=this.series,e=0;return o.forEach(function(t){var r=t.options;(t.params||r&&r.params)&&e++}),e}},tabs:{init:function(o){var e=this.tabs,t=this.indicators.getAmount.call(o),r;o&&(r=e.addMenuItem.call(this,"add"),e.addMenuItem.call(this,"edit",t),e.addContentItem.call(this,"add"),e.addContentItem.call(this,"edit"),e.switchTabs.call(this,t),e.selectTab.call(this,r,0))},addMenuItem:function(o,e){var t=this.popup.container,r=PREFIX+"tab-item",n=this.lang,s;return e===0&&(r+=" "+PREFIX+"tab-disabled"),s=createElement$2(SPAN,{className:r},void 0,t),s.appendChild(doc$3.createTextNode(n[o+"Button"]||o)),s.setAttribute(PREFIX+"data-tab-type",o),s},addContentItem:function(){var o=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,o)},switchTabs:function(o){var e=this,t=this.popup.container,r=t.querySelectorAll("."+PREFIX+"tab-item"),n;r.forEach(function(s,a){n=s.getAttribute(PREFIX+"data-tab-type"),!(n==="edit"&&o===0)&&["click","touchstart"].forEach(function(l){addEvent$r(s,l,function(){e.tabs.deselectAll.call(e),e.tabs.selectTab.call(e,this,a)})})})},selectTab:function(o,e){var t=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");o.className+=" "+PREFIX+"tab-item-active",t[e].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var o=this.popup.container,e=o.querySelectorAll("."+PREFIX+"tab-item"),t=o.querySelectorAll("."+PREFIX+"tab-item-content"),r;for(r=0;r<e.length;r++)e[r].classList.remove(PREFIX+"tab-item-active"),t[r].classList.remove(PREFIX+"tab-item-show")}}};addEvent$r(NavigationBindings,"showPopup",function(o){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(o.formType,this.chart,o.options,o.onSubmit)});addEvent$r(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$q=Utilities.addEvent,extend$H=Utilities.extend,merge$D=Utilities.merge,pick$H=Utilities.pick,splat$4=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=function(){function o(e,t){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(e,t)}return o.prototype.init=function(e,t){this.chart=t,this.background=[],t.pane.push(this),this.setOptions(e)},o.prototype.setOptions=function(e){this.options=e=merge$D(this.defaultOptions,this.chart.angular?{background:{}}:void 0,e)},o.prototype.render=function(){var e=this.options,t=this.options.background,r=this.chart.renderer,n,s;if(this.group||(this.group=r.g("pane-group").attr({zIndex:e.zIndex||0}).add()),this.updateCenter(),t)for(t=splat$4(t),n=Math.max(t.length,this.background.length||0),s=0;s<n;s++)t[s]&&this.axis?this.renderBackground(merge$D(this.defaultBackgroundOptions,t[s]),s):this.background[s]&&(this.background[s]=this.background[s].destroy(),this.background.splice(s,1))},o.prototype.renderBackground=function(e,t){var r="animate",n={class:"highcharts-pane "+(e.className||"")};this.chart.styledMode||extend$H(n,{fill:e.backgroundColor,stroke:e.borderColor,"stroke-width":e.borderWidth}),this.background[t]||(this.background[t]=this.chart.renderer.path().add(this.group),r="attr"),this.background[t][r]({d:this.axis.getPlotBandPath(e.from,e.to,e)}).attr(n)},o.prototype.updateCenter=function(e){this.center=(e||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},o.prototype.update=function(e,t){merge$D(!0,this.options,e),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(r){r.pane===this&&(r.pane=null,r.update({},t))},this)},o}();function isInsidePane(o,e,t){return Math.sqrt(Math.pow(o-t[0],2)+Math.pow(e-t[1],2))<=t[2]/2}Chart$1.prototype.getHoverPane=function(o){var e=this,t;return o&&e.pane.forEach(function(r){var n=o.chartX-e.plotLeft,s=o.chartY-e.plotTop,a=e.inverted?s:n,l=e.inverted?n:s;isInsidePane(a,l,r.center)&&(t=r)}),t};addEvent$q(Chart$1,"afterIsInsidePlot",function(o){var e=this;e.polar&&(o.isInsidePlot=e.pane.some(function(t){return isInsidePane(o.x,o.y,t.center)}))});addEvent$q(Pointer,"beforeGetHoverData",function(o){var e=this.chart;e.polar?(e.hoverPane=e.getHoverPane(o),o.filter=function(t){return t.visible&&!(!o.shared&&t.directTouch)&&pick$H(t.options.enableMouseTracking,!0)&&(!e.hoverPane||t.xAxis.pane===e.hoverPane)}):e.hoverPane=void 0});addEvent$q(Pointer,"afterGetHoverData",function(o){var e=this.chart;o.hoverPoint&&o.hoverPoint.plotX&&o.hoverPoint.plotY&&e.hoverPane&&!isInsidePane(o.hoverPoint.plotX,o.hoverPoint.plotY,e.hoverPane.center)&&(o.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$3=DefaultOptions.defaultOptions,noop$c=H.noop,addEvent$p=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$h=Utilities.defined,extend$G=Utilities.extend,fireEvent$7=Utilities.fireEvent,merge$C=Utilities.merge,pick$G=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$8=Utilities.wrap,RadialAxis;(function(o){var e=[],t={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},r={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},n={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function s(){this.autoConnect=this.isCircular&&typeof pick$G(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function a(L,D){return e.indexOf(L)===-1&&(e.push(L),addEvent$p(L,"afterInit",x),addEvent$p(L,"autoLabelAlign",b),addEvent$p(L,"destroy",$),addEvent$p(L,"init",S),addEvent$p(L,"initialAxisTranslation",k)),e.indexOf(D)===-1&&(e.push(D),addEvent$p(D,"afterGetLabelPosition",A),addEvent$p(D,"afterGetPosition",M),wrap$8(D.prototype,"getMarkPath",I)),L}o.compose=a;function l(){var L=this;return function(){if(L.isRadial&&L.tickPositions&&L.options.labels&&L.options.labels.allowOverlap!==!0)return L.tickPositions.map(function(D){return L.ticks[D]&&L.ticks[D].label}).filter(function(D){return!!D})}}function h(){return noop$c}function c(L,D,N){var B=this.pane.center,X=L.value,W,F,U,z;return this.isCircular?(defined$h(X)?L.point&&(W=L.point.shapeArgs||{},W.start&&(X=this.chart.inverted?this.translate(L.point.rectPlotY,!0):L.point.x)):(U=L.chartX||0,z=L.chartY||0,X=this.translate(Math.atan2(z-N,U-D)-this.startAngleRad,!0)),F=this.getPosition(X),U=F.x,z=F.y):(defined$h(X)||(U=L.chartX,z=L.chartY),defined$h(U)&&defined$h(z)&&(N=B[1]+this.chart.plotTop,X=this.translate(Math.min(Math.sqrt(Math.pow(U-D,2)+Math.pow(z-N,2)),B[2]/2)-B[3]/2,!0))),[X,U||0,z||0]}function d(L,D,N){var B=this.pane.center,X=this.chart,W=this.left||0,F=this.top||0,U,z=pick$G(D,B[2]/2-this.offset),V;return typeof N>"u"&&(N=this.horiz?0:this.center&&-this.center[3]/2),N&&(z+=N),this.isCircular||typeof D<"u"?(V=this.chart.renderer.symbols.arc(W+B[0],F+B[1],z,z,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),V.xBounds=[W+B[0]],V.yBounds=[F+B[1]-z]):(U=this.postTranslate(this.angleRad,z),V=[["M",this.center[0]+X.plotLeft,this.center[1]+X.plotTop],["L",U.x,U.y]]),V}function f(){var L=this.constructor.prototype;L.getOffset.call(this),this.chart.axisOffset[this.side]=0}function p(L,D,N){var B=this.chart,X=function(at){if(typeof at=="string"){var lt=parseInt(at,10);return K.test(at)&&(lt=lt*U/100),lt}return at},W=this.center,F=this.startAngleRad,U=W[2]/2,z=Math.min(this.offset,0),V=this.left||0,j=this.top||0,K=/%$/,ot=this.isCircular,q,J,Y,Z,et,Q,tt=pick$G(X(N.outerRadius),U),rt=X(N.innerRadius),it=pick$G(X(N.thickness),10);if(this.options.gridLineInterpolation==="polygon")Q=this.getPlotLinePath({value:L}).concat(this.getPlotLinePath({value:D,reverse:!0}));else{L=Math.max(L,this.min),D=Math.min(D,this.max);var nt=this.translate(L),st=this.translate(D);ot||(tt=nt||0,rt=st||0),N.shape==="circle"||!ot?(q=-Math.PI/2,J=Math.PI*1.5,et=!0):(q=F+(nt||0),J=F+(st||0)),tt-=z,it-=z,Q=B.renderer.symbols.arc(V+W[0],j+W[1],tt,tt,{start:Math.min(q,J),end:Math.max(q,J),innerR:pick$G(rt,tt-it),open:et}),ot&&(Y=(J+q)/2,Z=V+W[0]+W[2]/2*Math.cos(Y),Q.xBounds=Y>-Math.PI/2&&Y<Math.PI/2?[Z,B.plotWidth]:[0,Z],Q.yBounds=[j+W[1]+W[2]/2*Math.sin(Y)],Q.yBounds[0]+=Y>-Math.PI&&Y<0||Y>Math.PI?-10:10)}return Q}function u(L){var D=this,N=this.pane.center,B=this.chart,X=B.inverted,W=L.reverse,F=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},U=F.innerRadius||"0%",z=F.outerRadius||"100%",V=N[0]+B.plotLeft,j=N[1]+B.plotTop,K=this.height,ot=L.isCrosshair,q=N[3]/2,J=L.value,Y,Z,et,Q,tt,rt,it,nt,st,at=this.getPosition(J),lt=at.x,ht=at.y;if(ot&&(nt=this.getCrosshairPosition(L,V,j),J=nt[0],lt=nt[1],ht=nt[2]),this.isCircular)Z=Math.sqrt(Math.pow(lt-V,2)+Math.pow(ht-j,2)),et=typeof U=="string"?relativeLength$2(U,1):U/Z,Q=typeof z=="string"?relativeLength$2(z,1):z/Z,N&&q&&(Y=q/Z,et<Y&&(et=Y),Q<Y&&(Q=Y)),st=[["M",V+et*(lt-V),j-et*(j-ht)],["L",lt-(1-Q)*(lt-V),ht+(1-Q)*(j-ht)]];else if(J=this.translate(J),J&&(J<0||J>K)&&(J=0),this.options.gridLineInterpolation==="circle")st=this.getLinePath(0,J,q);else if(st=[],B[X?"yAxis":"xAxis"].forEach(function(dt){dt.pane===D.pane&&(tt=dt)}),tt){it=tt.tickPositions,tt.autoConnect&&(it=it.concat([it[0]])),W&&(it=it.slice().reverse()),J&&(J+=q);for(var ct=0;ct<it.length;ct++)rt=tt.getPosition(it[ct],J),st.push(ct?["L",rt.x,rt.y]:["M",rt.x,rt.y])}return st}function g(L,D){var N=this.translate(L);return this.postTranslate(this.isCircular?N:this.angleRad,pick$G(this.isCircular?D:N<0?0:N,this.center[2]/2)-this.offset)}function v(){var L=this.center,D=this.chart,N=this.options.title;return{x:D.plotLeft+L[0]+(N.x||0),y:D.plotTop+L[1]-{high:.5,middle:.25,low:0}[N.align]*L[2]+(N.y||0)}}function y(L){L.beforeSetTickPositions=s,L.createLabelCollector=l,L.getCrosshairPosition=c,L.getLinePath=d,L.getOffset=f,L.getPlotBandPath=p,L.getPlotLinePath=u,L.getPosition=g,L.getTitlePosition=v,L.postTranslate=P,L.setAxisSize=T,L.setAxisTranslation=O,L.setOptions=C}function m(L){L.isHidden=!0,L.createLabelCollector=h,L.getOffset=noop$c,L.redraw=E,L.render=E,L.setScale=noop$c,L.setCategories=noop$c,L.setTitle=noop$c}function x(){var L=this.chart,D=this.options,N=L.angular&&this.isXAxis,B=this.pane,X=B&&B.options;!N&&B&&(L.angular||L.polar)&&(this.angleRad=(D.angle||0)*Math.PI/180,this.startAngleRad=(X.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$G(X.endAngle,X.startAngle+360)-90)*Math.PI/180,this.offset=D.offset||0)}function b(L){this.isRadial&&(L.align=void 0,L.preventDefault())}function $(){if(this.chart&&this.chart.labelCollectors){var L=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;L>=0&&this.chart.labelCollectors.splice(L,1)}}function S(L){var D=this.chart,N=D.inverted,B=D.angular,X=D.polar,W=this.isXAxis,F=this.coll,U=B&&W,z=D.options,V=L.userOptions.pane||0,j=this.pane=D.pane&&D.pane[V],K;if(F==="colorAxis"){this.isRadial=!1;return}B?(U?m(this):y(this),K=!W,K&&(this.defaultPolarOptions=r)):X&&(y(this),K=this.horiz,this.defaultPolarOptions=K?t:merge$C(F==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,n),N&&F==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),B||X?(this.isRadial=!0,z.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&D.labelCollectors.push(this.labelCollector)):this.isRadial=!1,j&&K&&(j.axis=this),this.isCircular=K}function k(){this.isRadial&&this.beforeSetTickPositions()}function A(L){var D=this.label;if(D){var N=this.axis,B=D.getBBox(),X=N.options.labels,W=(N.translate(this.pos)+N.startAngleRad+Math.PI/2)/Math.PI*180%360,F=Math.round(W),U=defined$h(X.y)?0:-B.height*.3,z=X.y,V,j=20,K=X.align,ot="end",q=F<0?F+360:F,J=q,Y=0,Z=0;N.isRadial&&(V=N.getPosition(this.pos,N.center[2]/2+relativeLength$2(pick$G(X.distance,-25),N.center[2]/2,-N.center[2]/2)),X.rotation==="auto"?D.attr({rotation:W}):defined$h(z)||(z=N.chart.renderer.fontMetrics(D.styles&&D.styles.fontSize).b-B.height/2),defined$h(K)||(N.isCircular?(B.width>N.len*N.tickInterval/(N.max-N.min)&&(j=0),W>j&&W<180-j?K="left":W>180+j&&W<360-j?K="right":K="center"):K="center",D.attr({align:K})),K==="auto"&&N.tickPositions.length===2&&N.isCircular&&(q>90&&q<180?q=180-q:q>270&&q<=360&&(q=540-q),J>180&&J<=360&&(J=360-J),(N.pane.options.startAngle===F||N.pane.options.startAngle===F+360||N.pane.options.startAngle===F-360)&&(ot="start"),F>=-90&&F<=90||F>=-360&&F<=-270||F>=270&&F<=360?K=ot==="start"?"right":"left":K=ot==="start"?"left":"right",J>70&&J<110&&(K="center"),q<15||q>=180&&q<195?Y=B.height*.3:q>=15&&q<=35?Y=ot==="start"?0:B.height*.75:q>=195&&q<=215?Y=ot==="start"?B.height*.75:0:q>35&&q<=90?Y=ot==="start"?-B.height*.25:B.height:q>215&&q<=270&&(Y=ot==="start"?B.height:-B.height*.25),J<15?Z=ot==="start"?-B.height*.15:B.height*.15:J>165&&J<=180&&(Z=ot==="start"?B.height*.15:-B.height*.15),D.attr({align:K}),D.translate(Z,Y+U)),L.pos.x=V.x+(X.x||0),L.pos.y=V.y+(z||0))}}function M(L){this.axis.getPosition&&extend$G(L.pos,this.axis.getPosition(this.pos))}function P(L,D){var N=this.chart,B=this.center;return L=this.startAngleRad+L,{x:N.plotLeft+B[0]+Math.cos(L)*D,y:N.plotTop+B[1]+Math.sin(L)*D}}function E(){this.isDirty=!1}function T(){var L=this.constructor.prototype,D,N;L.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),D=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(N=this.postTranslate(this.angleRad,D[3]/2),D[0]=N.x-this.chart.plotLeft,D[1]=N.y-this.chart.plotTop),this.len=this.width=this.height=(D[2]-D[3])*pick$G(this.sector,1)/2)}function O(){var L=this.constructor.prototype;L.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function C(L){var D=this.options=merge$C(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$3[this.coll],L);D.plotBands||(D.plotBands=[]),fireEvent$7(this,"afterSetOptions")}function I(L,D,N,B,X,W,F){var U=this.axis,z,V;return U.isRadial?(z=U.getPosition(this.pos,U.center[2]/2+B),V=["M",D,N,"L",z.x,z.y]):V=L.call(this,D,N,B,X,W,F),V}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$F=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),pointProto=Point$2.prototype,defined$g=Utilities.defined,isNumber$i=Utilities.isNumber,AreaRangePoint$1=function(o){__extends$F(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.high=void 0,t.low=void 0,t.options=void 0,t.plotHigh=void 0,t.plotLow=void 0,t.plotHighX=void 0,t.plotLowX=void 0,t.plotX=void 0,t.series=void 0,t}return e.prototype.setState=function(){var t=this.state,r=this.series,n=r.chart.polar;defined$g(this.plotHigh)||(this.plotHigh=r.yAxis.toPixels(this.high,!0)),defined$g(this.plotLow)||(this.plotLow=this.plotY=r.yAxis.toPixels(this.low,!0)),r.stateMarkerGraphic&&(r.lowerStateMarkerGraphic=r.stateMarkerGraphic,r.stateMarkerGraphic=r.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,n&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=t,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,n&&(this.plotX=this.plotLowX),r.stateMarkerGraphic&&(r.upperStateMarkerGraphic=r.stateMarkerGraphic,r.stateMarkerGraphic=r.lowerStateMarkerGraphic,r.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},e.prototype.haloPath=function(){var t=this.series.chart.polar,r=[];return this.plotY=this.plotLow,t&&(this.plotX=this.plotLowX),this.isInside&&(r=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,t&&(this.plotX=this.plotHighX),this.isTopInside&&(r=r.concat(pointProto.haloPath.apply(this,arguments))),r},e.prototype.isValid=function(){return isNumber$i(this.low)&&isNumber$i(this.high)},e}(AreaSeries$1.prototype.pointClass),__extends$E=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$b=H.noop,seriesProto$1=Series$e.prototype,defined$f=Utilities.defined,extend$F=Utilities.extend,isArray$5=Utilities.isArray,pick$F=Utilities.pick,merge$B=Utilities.merge,AreaRangeSeries$2=function(o){__extends$E(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.lowerStateMarkerGraphic=void 0,t.xAxis=void 0,t}return e.prototype.toYData=function(t){return[t.low,t.high]},e.prototype.highToXY=function(t){var r=this.chart,n=this.xAxis.postTranslate(t.rectPlotX||0,this.yAxis.len-t.plotHigh);t.plotHighX=n.x-r.plotLeft,t.plotHigh=n.y-r.plotTop,t.plotLowX=t.plotX},e.prototype.translate=function(){var t=this,r=t.yAxis,n=!!t.modifyValue;areaProto.translate.apply(t),t.points.forEach(function(s){var a=s.high,l=s.plotY;s.isNull?s.plotY=null:(s.plotLow=l,s.plotHigh=r.translate(n?t.modifyValue(a,s):a,0,1,0,1),n&&(s.yBottom=s.plotHigh))}),this.chart.polar&&this.points.forEach(function(s){t.highToXY(s),s.tooltipPos=[(s.plotHighX+s.plotLowX)/2,(s.plotHigh+s.plotLow)/2]})},e.prototype.getGraphPath=function(t){var r=[],n=[],s,a=areaProto.getGraphPath,l,h,c,d,f=this.options,p=this.chart.polar,u=p&&f.connectEnds!==!1,g=f.connectNulls,v=f.step,y,m;for(t=t||this.points,s=t.length;s--;){l=t[s];var x=p?{plotX:l.rectPlotX,plotY:l.yBottom,doCurve:!1}:{plotX:l.plotX,plotY:l.plotY,doCurve:!1};!l.isNull&&!u&&!g&&(!t[s+1]||t[s+1].isNull)&&n.push(x),h={polarPlotY:l.polarPlotY,rectPlotX:l.rectPlotX,yBottom:l.yBottom,plotX:pick$F(l.plotHighX,l.plotX),plotY:l.plotHigh,isNull:l.isNull},n.push(h),r.push(h),!l.isNull&&!u&&!g&&(!t[s-1]||t[s-1].isNull)&&n.push(x)}return d=a.call(this,t),v&&(v===!0&&(v="left"),f.step={left:"right",center:"center",right:"left"}[v]),y=a.call(this,r),m=a.call(this,n),f.step=v,c=[].concat(d,y),!this.chart.polar&&m[0]&&m[0][0]==="M"&&(m[0]=["L",m[0][1],m[0][2]]),this.graphPath=c,this.areaPath=d.concat(m),c.isArea=!0,c.xMap=d.xMap,this.areaPath.xMap=d.xMap,c},e.prototype.drawDataLabels=function(){var t=this.points,r=t.length,n,s=[],a=this.options.dataLabels,l,h,c=this.chart.inverted,d,f;if(a){if(isArray$5(a)?(d=a[0]||{enabled:!1},f=a[1]||{enabled:!1}):(d=extend$F({},a),d.x=a.xHigh,d.y=a.yHigh,f=extend$F({},a),f.x=a.xLow,f.y=a.yLow),d.enabled||this._hasPointLabels){for(n=r;n--;)l=t[n],l&&(h=d.inside?l.plotHigh<l.plotLow:l.plotHigh>l.plotLow,l.y=l.high,l._plotY=l.plotY,l.plotY=l.plotHigh,s[n]=l.dataLabel,l.dataLabel=l.dataLabelUpper,l.below=h,c?d.align||(d.align=h?"right":"left"):d.verticalAlign||(d.verticalAlign=h?"top":"bottom"));for(this.options.dataLabels=d,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),n=r;n--;)l=t[n],l&&(l.dataLabelUpper=l.dataLabel,l.dataLabel=s[n],delete l.dataLabels,l.y=l.low,l.plotY=l._plotY)}if(f.enabled||this._hasPointLabels){for(n=r;n--;)l=t[n],l&&(h=f.inside?l.plotHigh<l.plotLow:l.plotHigh>l.plotLow,l.below=!h,c?f.align||(f.align=h?"left":"right"):f.verticalAlign||(f.verticalAlign=h?"bottom":"top"));this.options.dataLabels=f,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(d.enabled)for(n=r;n--;)l=t[n],l&&(l.dataLabels=[l.dataLabelUpper,l.dataLabel].filter(function(p){return!!p}));this.options.dataLabels=a}},e.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},e.prototype.drawPoints=function(){var t=this,r=t.points.length,n,s;for(seriesProto$1.drawPoints.apply(t,arguments),s=0;s<r;)n=t.points[s],n.origProps={plotY:n.plotY,plotX:n.plotX,isInside:n.isInside,negative:n.negative,zone:n.zone,y:n.y},n.lowerGraphic=n.graphic,n.graphic=n.upperGraphic,n.plotY=n.plotHigh,defined$f(n.plotHighX)&&(n.plotX=n.plotHighX),n.y=pick$F(n.high,n.origProps.y),n.negative=n.y<(t.options.threshold||0),t.zones.length&&(n.zone=n.getZone()),t.chart.polar||(n.isInside=n.isTopInside=typeof n.plotY<"u"&&n.plotY>=0&&n.plotY<=t.yAxis.len&&n.plotX>=0&&n.plotX<=t.xAxis.len),s++;for(seriesProto$1.drawPoints.apply(t,arguments),s=0;s<r;)n=t.points[s],n.upperGraphic=n.graphic,n.graphic=n.lowerGraphic,n.origProps&&(extend$F(n,n.origProps),delete n.origProps),s++},e.defaultOptions=merge$B(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),e}(AreaSeries$1);extend$F(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$b});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$D=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$A=Utilities.merge,extend$E=Utilities.extend,AreaSplineRangeSeries=function(o){__extends$D(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.data=void 0,t.points=void 0,t}return e.defaultOptions=merge$A(AreaRangeSeries$2.defaultOptions),e}(AreaRangeSeries$2);extend$E(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$C=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$a=H.noop,extend$D=Utilities.extend,merge$z=Utilities.merge,pick$E=Utilities.pick,BoxPlotSeries=function(o){__extends$C(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(){return{}},e.prototype.translate=function(){var t=this,r=t.yAxis,n=t.pointArrayMap;o.prototype.translate.apply(t),t.points.forEach(function(s){n.forEach(function(a){s[a]!==null&&(s[a+"Plot"]=r.translate(s[a],0,1,0,1))}),s.plotHigh=s.highPlot})},e.prototype.drawPoints=function(){var t=this,r=t.points,n=t.options,s=t.chart,a=s.renderer,l,h,c,d,f,p,u,g=0,v,y,m,x,b,$=t.doQuartiles!==!1,S,k=t.options.whiskerLength;r.forEach(function(A){var M=A.graphic,P=M?"animate":"attr",E=A.shapeArgs,T={},O={},C={},I={},L=A.color||t.color;if(typeof A.plotY<"u"){y=Math.round(E.width),m=Math.floor(E.x),x=m+y,b=Math.round(y/2),l=Math.floor($?A.q1Plot:A.lowPlot),h=Math.floor($?A.q3Plot:A.lowPlot),c=Math.floor(A.highPlot),d=Math.floor(A.lowPlot),M||(A.graphic=M=a.g("point").add(t.group),A.stem=a.path().addClass("highcharts-boxplot-stem").add(M),k&&(A.whiskers=a.path().addClass("highcharts-boxplot-whisker").add(M)),$&&(A.box=a.path(v).addClass("highcharts-boxplot-box").add(M)),A.medianShape=a.path(p).addClass("highcharts-boxplot-median").add(M)),s.styledMode||(O.stroke=A.stemColor||n.stemColor||L,O["stroke-width"]=pick$E(A.stemWidth,n.stemWidth,n.lineWidth),O.dashstyle=A.stemDashStyle||n.stemDashStyle||n.dashStyle,A.stem.attr(O),k&&(C.stroke=A.whiskerColor||n.whiskerColor||L,C["stroke-width"]=pick$E(A.whiskerWidth,n.whiskerWidth,n.lineWidth),C.dashstyle=A.whiskerDashStyle||n.whiskerDashStyle||n.dashStyle,A.whiskers.attr(C)),$&&(T.fill=A.fillColor||n.fillColor||L,T.stroke=n.lineColor||L,T["stroke-width"]=n.lineWidth||0,T.dashstyle=A.boxDashStyle||n.boxDashStyle||n.dashStyle,A.box.attr(T)),I.stroke=A.medianColor||n.medianColor||L,I["stroke-width"]=pick$E(A.medianWidth,n.medianWidth,n.lineWidth),I.dashstyle=A.medianDashStyle||n.medianDashStyle||n.dashStyle,A.medianShape.attr(I));var D=void 0;u=A.stem.strokeWidth()%2/2,g=m+b+u,D=[["M",g,h],["L",g,c],["M",g,l],["L",g,d]],A.stem[P]({d:D}),$&&(u=A.box.strokeWidth()%2/2,l=Math.floor(l)+u,h=Math.floor(h)+u,m+=u,x+=u,D=[["M",m,h],["L",m,l],["L",x,l],["L",x,h],["L",m,h],["Z"]],A.box[P]({d:D})),k&&(u=A.whiskers.strokeWidth()%2/2,c=c+u,d=d+u,S=/%$/.test(k)?b*parseFloat(k)/100:k/2,D=[["M",g-S,c],["L",g+S,c],["M",g-S,d],["L",g+S,d]],A.whiskers[P]({d:D})),f=Math.round(A.medianPlot),u=A.medianShape.strokeWidth()%2/2,f=f+u,D=[["M",m,f],["L",x,f]],A.medianShape[P]({d:D})}})},e.prototype.toYData=function(t){return[t.low,t.q1,t.median,t.q3,t.high]},e.defaultOptions=merge$z(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),e}(ColumnSeries$h);extend$D(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$a,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$9=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,pick$D=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=function(){function o(e,t){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$9,this.init(e,t)}return o.prototype.init=function(e,t){this.options=e,this.visible=!0,this.chart=t.chart,this.legend=t},o.prototype.addToLegend=function(e){e.splice(this.options.legendIndex,0,this)},o.prototype.drawLegendSymbol=function(e){var t=this.chart,r=this.options,n=pick$D(e.options.itemDistance,20),s=r.ranges,a=r.connectorDistance,l;if(this.fontMetrics=t.renderer.fontMetrics(r.labels.style.fontSize),!s||!s.length||!isNumber$h(s[0].value)){e.options.bubbleLegend.autoRanges=!0;return}stableSort$2(s,function(f,p){return p.value-f.value}),this.ranges=s,this.setOptions(),this.render();var h=this.getMaxLabelSize(),c=this.ranges[0].radius,d=c*2;l=a-c+h.width,l=l>0?l:0,this.maxLabel=h,this.movementX=r.labels.align==="left"?l:0,this.legendItemWidth=d+l+n,this.legendItemHeight=d+this.fontMetrics.h/2},o.prototype.setOptions=function(){var e=this.ranges,t=this.options,r=this.chart.series[t.seriesIndex],n=this.legend.baseline,s={zIndex:t.zIndex,"stroke-width":t.borderWidth},a={zIndex:t.zIndex,"stroke-width":t.connectorWidth},l={align:this.legend.options.rtl||t.labels.align==="left"?"right":"left",zIndex:t.zIndex},h=r.options.marker.fillOpacity,c=this.chart.styledMode;e.forEach(function(d,f){c||(s.stroke=pick$D(d.borderColor,t.borderColor,r.color),s.fill=pick$D(d.color,t.color,h!==1?color$a(r.color).setOpacity(h).get("rgba"):r.color),a.stroke=pick$D(d.connectorColor,t.connectorColor,r.color)),e[f].radius=this.getRangeRadius(d.value),e[f]=merge$y(e[f],{center:e[0].radius-e[f].radius+n}),c||merge$y(!0,e[f],{bubbleAttribs:merge$y(s),connectorAttribs:merge$y(a),labelAttribs:l})},this)},o.prototype.getRangeRadius=function(e){var t=this.options,r=this.options.seriesIndex,n=this.chart.series[r],s=t.ranges[0].value,a=t.ranges[t.ranges.length-1].value,l=t.minSize,h=t.maxSize;return n.getRadius.call(this,a,s,l,h,e)},o.prototype.render=function(){var e=this.chart.renderer,t=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=e.g("bubble-legend"),this.legendItem=e.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(r){r.value>=t&&this.renderRange(r)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},o.prototype.renderRange=function(e){var t=this.ranges[0],r=this.legend,n=this.options,s=n.labels,a=this.chart,l=a.series[n.seriesIndex],h=a.renderer,c=this.symbols,d=c.labels,f=e.center,p=Math.abs(e.radius),u=n.connectorDistance||0,g=s.align,v=r.options.rtl,y=n.borderWidth,m=n.connectorWidth,x=t.radius||0,b=f-p-y/2+m/2,$=this.fontMetrics,S=$.f/2-($.h-$.f)/2,k=(b%1?1:.5)-(m%2?0:.5),A=h.styledMode,M=v||g==="left"?-u:u;g==="center"&&(M=0,n.connectorDistance=0,e.labelAttribs.align="center");var P=b+n.labels.y,E=x+M+n.labels.x;c.bubbleItems.push(h.circle(x,f+k,p).attr(A?{}:e.bubbleAttribs).addClass((A?"highcharts-color-"+l.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(n.className||"")).add(this.legendSymbol)),c.connectors.push(h.path(h.crispLine([["M",x,b],["L",x+M,b]],n.connectorWidth)).attr(A?{}:e.connectorAttribs).addClass((A?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(n.connectorClassName||"")).add(this.legendSymbol));var T=h.text(this.formatLabel(e),E,P+S).attr(A?{}:e.labelAttribs).css(A?{}:s.style).addClass("highcharts-bubble-legend-labels "+(n.labels.className||"")).add(this.legendSymbol);d.push(T),T.placed=!0,T.alignAttr={x:E,y:P+S}},o.prototype.getMaxLabelSize=function(){var e=this.symbols.labels,t,r;return e.forEach(function(n){r=n.getBBox(!0),t?t=r.width>t.width?r:t:t=r}),t||{}},o.prototype.formatLabel=function(e){var t=this.options,r=t.labels.formatter,n=t.labels.format,s=this.chart.numberFormatter;return n?FormatUtilities.format(n,e):r?r.call(e):s(e.value,1)},o.prototype.hideOverlappingLabels=function(){var e=this.chart,t=this.options.labels.allowOverlap,r=this.symbols;!t&&r&&(e.hideOverlappingLabels(r.labels),r.labels.forEach(function(n,s){n.newOpacity?n.newOpacity!==n.oldOpacity&&r.connectors[s].show():r.connectors[s].hide()}))},o.prototype.getRanges=function(){var e=this.legend.bubbleLegend,t=e.chart.series,r=e.options.ranges,n,s,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;return t.forEach(function(h){h.isBubble&&!h.ignoreSeries&&(s=h.zData.filter(isNumber$h),s.length&&(a=pick$D(h.options.zMin,Math.min(a,Math.max(arrayMin$3(s),h.options.displayNegative===!1?h.options.zThreshold:-Number.MAX_VALUE))),l=pick$D(h.options.zMax,Math.max(l,arrayMax$3(s)))))}),a===l?n=[{value:l}]:n=[{value:a},{value:(a+l)/2},{value:l,autoRanges:!0}],r.length&&r[0].radius&&n.reverse(),n.forEach(function(h,c){r&&r[c]&&(n[c]=merge$y(r[c],h))}),n},o.prototype.predictBubbleSizes=function(){var e=this.chart,t=this.fontMetrics,r=e.legend.options,n=r.floating,s=r.layout==="horizontal",a=s?e.legend.lastLineHeight:0,l=e.plotSizeX,h=e.plotSizeY,c=e.series[this.options.seriesIndex],d=Math.ceil(c.minPxSize),f=Math.ceil(c.maxPxSize),p=Math.min(h,l),u,g=c.options.maxSize;return n||!/%$/.test(g)?u=f:(g=parseFloat(g),u=(p+a-t.h/2)*g/100/(g/100+1),(s&&h-u>=l||!s&&l-u>=h)&&(u=f)),[d,Math.ceil(u)]},o.prototype.updateRanges=function(e,t){var r=this.legend.options.bubbleLegend;r.minSize=e,r.maxSize=t,r.ranges=this.getRanges()},o.prototype.correctSizes=function(){var e=this.legend,t=this.chart,r=t.series[this.options.seriesIndex],n=r.maxPxSize,s=this.options.maxSize;Math.abs(Math.ceil(n)-s)>1&&(this.updateRanges(this.options.minSize,r.maxPxSize),e.render())},o}(),setOptions=DefaultOptions.setOptions,addEvent$o=Utilities.addEvent,objectEach$9=Utilities.objectEach,wrap$7=Utilities.wrap,BubbleLegendComposition;(function(o){var e=[];function t(c,d,f){var p=this,u=p.legend,g=n(p)>=0,v,y;u&&u.options.enabled&&u.bubbleLegend&&u.options.bubbleLegend.autoRanges&&g?(v=u.bubbleLegend.options,y=u.bubbleLegend.predictBubbleSizes(),u.bubbleLegend.updateRanges(y[0],y[1]),v.placed||(u.group.placed=!1,u.allItems.forEach(function(m){m.legendGroup.translateY=null})),u.render(),p.getMargins(),p.axes.forEach(function(m){m.visible&&m.render(),v.placed||(m.setScale(),m.updateNames(),objectEach$9(m.ticks,function(x){x.isNew=!0,x.isNewLabel=!0}))}),v.placed=!0,p.getMargins(),c.call(p,d,f),u.bubbleLegend.correctSizes(),h(u,s(u))):(c.call(p,d,f),u&&u.options.enabled&&u.bubbleLegend&&(u.render(),h(u,s(u))))}function r(c,d,f){e.indexOf(c)===-1&&(e.push(c),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$7(c.prototype,"drawChartBox",t)),e.indexOf(d)===-1&&(e.push(d),addEvent$o(d,"afterGetAllItems",a)),e.indexOf(f)===-1&&(e.push(f),addEvent$o(f,"legendItemClick",l))}o.compose=r;function n(c){for(var d=c.series,f=0;f<d.length;){if(d[f]&&d[f].isBubble&&d[f].visible&&d[f].zData.length)return f;f++}return-1}function s(c){var d=c.allItems,f=[],p=d.length,u,g=0,v=0;for(g=0;g<p;g++)if(d[g].legendItemHeight&&(d[g].itemHeight=d[g].legendItemHeight),d[g]===d[p-1]||d[g+1]&&d[g]._legendItemPos[1]!==d[g+1]._legendItemPos[1]){for(f.push({height:0}),u=f[f.length-1],v;v<=g;v++)d[v].itemHeight>u.height&&(u.height=d[v].itemHeight);u.step=g}return f}function a(c){var d=this,f=d.bubbleLegend,p=d.options,u=p.bubbleLegend,g=n(d.chart);f&&f.ranges&&f.ranges.length&&(u.ranges.length&&(u.autoRanges=!!u.ranges[0].autoRanges),d.destroyItem(f)),g>=0&&p.enabled&&u.enabled&&(u.seriesIndex=g,d.bubbleLegend=new BubbleLegendItem(u,d),d.bubbleLegend.addToLegend(c.allItems))}function l(){var c=this,d=c.chart,f=c.visible,p=c.chart.legend,u;p&&p.bubbleLegend&&(c.visible=!f,c.ignoreSeries=f,u=n(d)>=0,p.bubbleLegend.visible!==u&&(p.update({bubbleLegend:{enabled:u}}),p.bubbleLegend.visible=u),c.visible=f)}function h(c,d){var f=c.allItems,p=c.options.rtl,u,g,v,y=0;f.forEach(function(m,x){u=m.legendGroup.translateX,g=m._legendItemPos[1],v=m.movementX,(v||p&&m.ranges)&&(v=p?u-m.options.maxSize/2:u+v,m.legendGroup.attr({translateX:v})),x>d[y].step&&y++,m.legendGroup.attr({translateY:Math.round(g+d[y].height/2)}),m._legendItemPos[1]=g+d[y].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$B=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$C=Utilities.extend,BubblePoint=function(o){__extends$B(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.haloPath=function(t){return Point$2.prototype.haloPath.call(this,t===0?0:(this.marker&&this.marker.radius||0)+t)},e}(ScatterPoint$2);extend$C(BubblePoint.prototype,{ttBelow:!1});var __extends$A=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$9=Color.parse,noop$8=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$8=Utilities.clamp,extend$B=Utilities.extend,isNumber$g=Utilities.isNumber,merge$x=Utilities.merge,pick$C=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=function(o){__extends$A(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.maxPxSize=void 0,t.minPxSize=void 0,t.options=void 0,t.points=void 0,t.radii=void 0,t.yData=void 0,t.zData=void 0,t}return e.prototype.animate=function(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(r){var n=r.graphic;n&&n.width&&(this.hasRendered||n.attr({x:r.plotX,y:r.plotY,width:1,height:1}),n.animate(this.markerAttribs(r),this.options.animation))},this)},e.prototype.getRadii=function(t,r,n){var s,a,l=this.zData,h=this.yData,c=n.minPxSize,d=n.maxPxSize,f=[],p;for(a=0,s=l.length;a<s;a++)p=l[a],f.push(this.getRadius(t,r,c,d,p,h[a]));this.radii=f},e.prototype.getRadius=function(t,r,n,s,a,l){var h=this.options,c=h.sizeBy!=="width",d=h.zThreshold,f=r-t,p=.5;if(l===null||a===null)return null;if(isNumber$g(a)){if(h.sizeByAbsoluteValue&&(a=Math.abs(a-d),r=f=Math.max(r-d,Math.abs(t-d)),t=0),a<t)return n/2-1;f>0&&(p=(a-t)/f)}return c&&p>=0&&(p=Math.sqrt(p)),Math.ceil(n+p*(s-n))/2},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.pointAttribs=function(t,r){var n=this.options.marker,s=n.fillOpacity,a=Series$e.prototype.pointAttribs.call(this,t,r);return s!==1&&(a.fill=color$9(a.fill).setOpacity(s).get("rgba")),a},e.prototype.translate=function(){var t,r=this.data,n,s,a=this.radii;for(o.prototype.translate.call(this),t=r.length;t--;)n=r[t],s=a?a[t]:0,isNumber$g(s)&&s>=this.minPxSize/2?(n.marker=extend$B(n.marker,{radius:s,width:2*s,height:2*s}),n.dlBox={x:n.plotX-s,y:n.plotY-s,width:2*s,height:2*s}):n.shapeArgs=n.plotY=n.dlBox=void 0},e.compose=BubbleLegendComposition$1.compose,e.defaultOptions=merge$x(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.z;return isNumber$g(r)?t(r,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),e}(ScatterSeries$3);extend$B(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$8,bubblePadding:!0,buildKDTree:noop$8,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var o=this,e=this.len,t=this.chart,r=0,n=e,s=this.isXAxis,a=s?"xData":"yData",l=this.min,h={},c=Math.min(t.plotWidth,t.plotHeight),d=Number.MAX_VALUE,f=-Number.MAX_VALUE,p=this.max-l,u=e/p,g=[];this.series.forEach(function(v){var y=v.options,m;v.bubblePadding&&(v.visible||!t.options.chart.ignoreHiddenSeries)&&(o.allowZoomOutside=!0,g.push(v),s&&(["minSize","maxSize"].forEach(function(x){var b=y[x],$=/%$/.test(b);b=pInt$2(b),h[x]=$?c*b/100:b}),v.minPxSize=h.minSize,v.maxPxSize=Math.max(h.maxSize,h.minSize),m=v.zData.filter(isNumber$g),m.length&&(d=pick$C(y.zMin,clamp$8(arrayMin$2(m),y.displayNegative===!1?y.zThreshold:-Number.MAX_VALUE,d)),f=pick$C(y.zMax,Math.max(f,arrayMax$2(m))))))}),g.forEach(function(v){var y=v[a],m=y.length,x;if(s&&v.getRadii(d,f,v),p>0)for(;m--;)isNumber$g(y[m])&&o.dataMin<=y[m]&&y[m]<=o.max&&(x=v.radii?v.radii[m]:0,r=Math.min((y[m]-l)*u-x,r),n=Math.max((y[m]-l)*u+x,n))}),g.length&&p>0&&!this.logarithmic&&(n-=e,u*=(e+Math.max(0,r)-Math.min(n,e))/e,[["min","userMin",r],["max","userMax",n]].forEach(function(v){typeof pick$C(o.options[v[0]],o[v[1]])>"u"&&(o[v[0]]+=v[2]/u)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$z=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$A=Utilities.extend,isNumber$f=Utilities.isNumber,ColumnRangePoint=function(o){__extends$z(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.series=void 0,t.options=void 0,t.barX=void 0,t.pointWidth=void 0,t.shapeType=void 0,t}return e.prototype.isValid=function(){return isNumber$f(this.low)},e}(AreaRangePoint);extend$A(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$y=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$7=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$7=Utilities.clamp,merge$w=Utilities.merge,pick$B=Utilities.pick,extend$z=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=function(o){__extends$y(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return e.prototype.setOptions=function(){return merge$w(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},e.prototype.translate=function(){var t=this,r=t.yAxis,n=t.xAxis,s=n.startAngleRad,a,l=t.chart,h=t.xAxis.isRadial,c=Math.max(l.chartWidth,l.chartHeight)+999,d;function f(p){return clamp$7(p,-c,c)}columnProto$3.translate.apply(t),t.points.forEach(function(p){var u=p.shapeArgs||{},g=t.options.minPointLength,v,y,m;if(p.plotHigh=d=f(r.translate(p.high,0,1,0,1)),p.plotLow=f(p.plotY),m=d,y=pick$B(p.rectPlotY,p.plotY)-d,Math.abs(y)<g?(v=g-y,y+=v,m-=v/2):y<0&&(y*=-1,m-=y),h)a=p.barX+s,p.shapeType="arc",p.shapeArgs=t.polarArc(m+y,m,a,a+p.pointWidth);else{u.height=y,u.y=m;var x=u.x,b=x===void 0?0:x,$=u.width,S=$===void 0?0:$;p.tooltipPos=l.inverted?[r.len+r.pos-l.plotLeft-m-y/2,n.len+n.pos-l.plotTop-b-S/2,y]:[n.left-l.plotLeft+b+S/2,r.pos-l.plotTop+m+y/2,y]}})},e.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},e.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},e.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},e.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},e.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},e.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},e.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},e.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},e.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},e.defaultOptions=merge$w(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),e}(AreaRangeSeries$1);extend$z(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$7,getSymbol:noop$7,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$x=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colProto=ColumnSeries$h.prototype,clamp$6=Utilities.clamp,merge$v=Utilities.merge,pick$A=Utilities.pick,ColumnPyramidSeries=function(o){__extends$x(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.translate=function(){var t=this,r=t.chart,n=t.options,s=t.dense=t.closestPointRange*t.xAxis.transA<2,a=t.borderWidth=pick$A(n.borderWidth,s?0:1),l=t.yAxis,h=n.threshold,c=t.translatedThreshold=l.getThreshold(h),d=pick$A(n.minPointLength,5),f=t.getColumnMetrics(),p=f.width,u=t.barW=Math.max(p,1+2*a),g=t.pointXOffset=f.offset;r.inverted&&(c-=.5),n.pointPadding&&(u=Math.ceil(u)),colProto.translate.apply(t),t.points.forEach(function(v){var y=pick$A(v.yBottom,c),m=999+Math.abs(y),x=clamp$6(v.plotY,-m,l.len+m),b=v.plotX+g,$=u/2,S=Math.min(x,y),k=Math.max(x,y)-S,A,M,P,E,T,O,C,I,L,D,N,B;v.barX=b,v.pointWidth=p,v.tooltipPos=r.inverted?[l.len+l.pos-r.plotLeft-x,t.xAxis.len-b-$,k]:[b+$,x+l.pos-r.plotTop,k],A=h+(v.total||v.y),n.stacking==="percent"&&(A=h+(v.y<0)?-100:100),P=l.toPixels(A,!0),M=r.plotHeight-P-(r.plotHeight-c),E=M?$*(S-P)/M:0,T=M?$*(S+k-P)/M:0,C=b-E+$,I=b+E+$,L=b+T+$,D=b-T+$,N=S-d,B=S+k,v.y<0&&(N=S,B=S+k+d),r.inverted&&(O=r.plotWidth-S,M=P-(r.plotWidth-c),E=$*(P-O)/M,T=$*(P-(O-k))/M,C=b+$+E,I=C-2*E,L=b-T+$,D=b+T+$,N=S,B=S+k-d,v.y<0&&(B=S+k+d)),v.shapeType="path",v.shapeArgs={x:C,y:N,width:I-C,height:k,d:[["M",C,N],["L",I,N],["L",L,B],["L",D,B],["Z"]]}})},e.defaultOptions=merge$v(ColumnSeries$h.defaultOptions,{}),e}(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$w=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$u=Utilities.merge,extend$y=Utilities.extend,ErrorBarSeries=function(o){__extends$w(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},e.prototype.drawDataLabels=function(){var t=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(r){r.y=r[t]}))},e.prototype.toYData=function(t){return[t.low,t.high]},e.defaultOptions=merge$u(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),e}(BoxPlotSeries);extend$y(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$v=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Point$1=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=function(o){__extends$v(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.shapeArgs=void 0,t}return e.prototype.setState=function(t){this.state=t},e}(Point$1),__extends$u=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$6=H.noop,Series$a=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$5=Utilities.clamp,isNumber$e=Utilities.isNumber,extend$x=Utilities.extend,merge$t=Utilities.merge,pick$z=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=function(o){__extends$u(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.yAxis=void 0,t}return e.prototype.translate=function(){var t=this,r=t.yAxis,n=t.options,s=r.center;t.generatePoints(),t.points.forEach(function(a){var l=merge$t(n.dial,a.dial),h=pInt$1(pick$z(l.radius,"80%"))*s[2]/200,c=pInt$1(pick$z(l.baseLength,"70%"))*h/100,d=pInt$1(pick$z(l.rearLength,"10%"))*h/100,f=l.baseWidth||3,p=l.topWidth||1,u=n.overshoot,g=r.startAngleRad+r.translate(a.y,null,null,null,!0);(isNumber$e(u)||n.wrap===!1)&&(u=isNumber$e(u)?u/180*Math.PI:0,g=clamp$5(g,r.startAngleRad-u,r.endAngleRad+u)),g=g*180/Math.PI,a.shapeType="path";var v=l.path||[["M",-d,-f/2],["L",c,-f/2],["L",h,-p/2],["L",h,p/2],["L",c,f/2],["L",-d,f/2],["Z"]];a.shapeArgs={d:v,translateX:s[0],translateY:s[1],rotation:g},a.plotX=s[0],a.plotY=s[1]})},e.prototype.drawPoints=function(){var t=this,r=t.chart,n=t.yAxis.center,s=t.pivot,a=t.options,l=a.pivot,h=r.renderer;t.points.forEach(function(c){var d=c.graphic,f=c.shapeArgs,p=f.d,u=merge$t(a.dial,c.dial);d?(d.animate(f),f.d=p):c.graphic=h[c.shapeType](f).attr({rotation:f.rotation,zIndex:1}).addClass("highcharts-dial").add(t.group),r.styledMode||c.graphic[d?"animate":"attr"]({stroke:u.borderColor||"none","stroke-width":u.borderWidth||0,fill:u.backgroundColor||palette.neutralColor100})}),s?s.animate({translateX:n[0],translateY:n[1]}):(t.pivot=h.circle(0,0,pick$z(l.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(n[0],n[1]).add(t.group),r.styledMode||t.pivot.attr({"stroke-width":l.borderWidth||0,stroke:l.borderColor||palette.neutralColor20,fill:l.backgroundColor||palette.neutralColor100}))},e.prototype.animate=function(t){var r=this;t||r.points.forEach(function(n){var s=n.graphic;s&&(s.attr({rotation:r.yAxis.startAngleRad*180/Math.PI}),s.animate({rotation:n.shapeArgs.rotation},r.options.animation))})},e.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$a.prototype.render.call(this),this.group.clip(this.chart.clipRect)},e.prototype.setData=function(t,r){Series$a.prototype.setData.call(this,t,!1),this.processData(),this.generatePoints(),pick$z(r,!0)&&this.chart.redraw()},e.prototype.hasData=function(){return!!this.points.length},e.defaultOptions=merge$t(Series$a.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),e}(Series$a);extend$x(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$6,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$t=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=function(o){__extends$t(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.degree=NaN,t.mass=NaN,t.radius=NaN,t.options=void 0,t.series=void 0,t.value=null,t}return e.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$2.prototype.destroy.apply(this,arguments)},e.prototype.firePointEvent=function(){var t=this.series,r=t.options;if(this.isParentNode&&r.parentNode){var n=r.allowPointSelect;r.allowPointSelect=r.parentNode.allowPointSelect,Point$2.prototype.firePointEvent.apply(this,arguments),r.allowPointSelect=n}else Point$2.prototype.firePointEvent.apply(this,arguments)},e.prototype.select=function(){var t=this,r=this.series,n=r.chart;t.isParentNode?(n.getSelectedPoints=n.getSelectedParentNodes,Point$2.prototype.select.apply(this,arguments),n.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$2.prototype.select.apply(this,arguments)},e}(BubbleSeries$1.prototype.pointClass),addEvent$n=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(o,e){var t=this.chart.pointer.normalize(e);o.fixedPosition={chartX:t.chartX,chartY:t.chartY,plotX:o.plotX,plotY:o.plotY},o.inDragMode=!0},onMouseMove:function(o,e){if(o.fixedPosition&&o.inDragMode){var t=this,r=t.chart,n=r.pointer.normalize(e),s=o.fixedPosition.chartX-n.chartX,a=o.fixedPosition.chartY-n.chartY,l=void 0,h=void 0,c=r.graphLayoutsLookup;(Math.abs(s)>5||Math.abs(a)>5)&&(l=o.fixedPosition.plotX-s,h=o.fixedPosition.plotY-a,r.isInsidePlot(l,h)&&(o.plotX=l,o.plotY=h,o.hasDragged=!0,this.redrawHalo(o),c.forEach(function(d){d.restartSimulation()})))}},onMouseUp:function(o,e){o.fixedPosition&&(o.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),o.inDragMode=o.hasDragged=!1,this.options.fixedDraggable||delete o.fixedPosition)},redrawHalo:function(o){o&&this.halo&&this.halo.attr({d:o.haloPath(this.options.states.hover.halo.size)})}};addEvent$n(Chart$1,"load",function(){var o=this,e,t,r;o.container&&(e=addEvent$n(o.container,"mousedown",function(n){var s=o.hoverPoint;s&&s.series&&s.series.hasDraggableNodes&&s.series.options.draggable&&(s.series.onMouseDown(s,n),t=addEvent$n(o.container,"mousemove",function(a){return s&&s.series&&s.series.onMouseMove(s,a)}),r=addEvent$n(o.container.ownerDocument,"mouseup",function(a){return t(),r(),s&&s.series&&s.series.onMouseUp(s,a)}))})),addEvent$n(o,"destroy",function(){e()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(o,e){return(e-o)/o},repulsiveForceFunction:function(o,e){return(e-o)/o*(e>o?1:0)},barycenter:function(){var o=this.options.gravitationalConstant,e=this.barycenter.xFactor,t=this.barycenter.yFactor;e=(e-(this.box.left+this.box.width)/2)*o,t=(t-(this.box.top+this.box.height)/2)*o,this.nodes.forEach(function(r){r.fixedPosition||(r.plotX-=e/r.mass/r.degree,r.plotY-=t/r.mass/r.degree)})},repulsive:function(o,e,t){var r=e*this.diffTemperature/o.mass/o.degree;o.fixedPosition||(o.plotX+=t.x*r,o.plotY+=t.y*r)},attractive:function(o,e,t){var r=o.getMass(),n=-t.x*e*this.diffTemperature,s=-t.y*e*this.diffTemperature;o.fromNode.fixedPosition||(o.fromNode.plotX-=n*r.fromNode/o.fromNode.degree,o.fromNode.plotY-=s*r.fromNode/o.fromNode.degree),o.toNode.fixedPosition||(o.toNode.plotX+=n*r.toNode/o.toNode.degree,o.toNode.plotY+=s*r.toNode/o.toNode.degree)},integrate:function(o,e){var t=-o.options.friction,r=o.options.maxSpeed,n=e.prevX,s=e.prevY,a=(e.plotX+e.dispX-n)*t,l=(e.plotY+e.dispY-s)*t,h=Math.abs,c=h(a)/(a||1),d=h(l)/(l||1);a=c*Math.min(r,Math.abs(a)),l=d*Math.min(r,Math.abs(l)),e.prevX=e.plotX+e.dispX,e.prevY=e.plotY+e.dispY,e.plotX+=a,e.plotY+=l,e.temperature=o.vectorLength({x:a,y:l})},getK:function(o){return Math.pow(o.box.width*o.box.height/o.nodes.length,.5)}},euler:{attractiveForceFunction:function(o,e){return o*o/e},repulsiveForceFunction:function(o,e){return e*e/o},barycenter:function(){var o=this.options.gravitationalConstant,e=this.barycenter.xFactor,t=this.barycenter.yFactor;this.nodes.forEach(function(r){if(!r.fixedPosition){var n=r.getDegree(),s=n*(1+n/2);r.dispX+=(e-r.plotX)*o*s/r.degree,r.dispY+=(t-r.plotY)*o*s/r.degree}})},repulsive:function(o,e,t,r){o.dispX+=t.x/r*e/o.degree,o.dispY+=t.y/r*e/o.degree},attractive:function(o,e,t,r){var n=o.getMass(),s=t.x/r*e,a=t.y/r*e;o.fromNode.fixedPosition||(o.fromNode.dispX-=s*n.fromNode/o.fromNode.degree,o.fromNode.dispY-=a*n.fromNode/o.fromNode.degree),o.toNode.fixedPosition||(o.toNode.dispX+=s*n.toNode/o.toNode.degree,o.toNode.dispY+=a*n.toNode/o.toNode.degree)},integrate:function(o,e){var t;e.dispX+=e.dispX*o.options.friction,e.dispY+=e.dispY*o.options.friction,t=e.temperature=o.vectorLength({x:e.dispX,y:e.dispY}),t!==0&&(e.plotX+=e.dispX/t*Math.min(Math.abs(e.dispX),o.temperature),e.plotY+=e.dispY/t*Math.min(Math.abs(e.dispY),o.temperature))},getK:function(o){return Math.pow(o.box.width*o.box.height/o.nodes.length,.3)}}};var extend$w=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(o){this.box=o,this.boxSize=Math.min(o.width,o.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$w(QuadTreeNode.prototype,{insert:function(o,e){var t;this.isInternal?this.nodes[this.getBoxPosition(o)].insert(o,e-1):(this.isEmpty=!1,this.body?e?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,e-1),this.body=!0),this.nodes[this.getBoxPosition(o)].insert(o,e-1)):(t=new QuadTreeNode({top:o.plotX,left:o.plotY,width:.1,height:.1}),t.body=o,t.isInternal=!1,this.nodes.push(t)):(this.isInternal=!1,this.body=o))},updateMassAndCenter:function(){var o=0,e=0,t=0;this.isInternal?(this.nodes.forEach(function(r){r.isEmpty||(o+=r.mass,e+=r.plotX*r.mass,t+=r.plotY*r.mass)}),e/=o,t/=o):this.body&&(o=this.body.mass,e=this.body.plotX,t=this.body.plotY),this.mass=o,this.plotX=e,this.plotY=t},divideBox:function(){var o=this.box.width/2,e=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:o,height:e}),this.nodes[1]=new QuadTreeNode({left:this.box.left+o,top:this.box.top,width:o,height:e}),this.nodes[2]=new QuadTreeNode({left:this.box.left+o,top:this.box.top+e,width:o,height:e}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+e,width:o,height:e})},getBoxPosition:function(o){var e=o.plotX<this.box.left+this.box.width/2,t=o.plotY<this.box.top+this.box.height/2,r;return e?t?r=0:r=3:t?r=1:r=2,r}});var QuadTree=H.QuadTree=function(o,e,t,r){this.box={left:o,top:e,width:t,height:r},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$w(QuadTree.prototype,{insertNodes:function(o){o.forEach(function(e){this.root.insert(e,this.maxDepth)},this)},visitNodeRecursive:function(o,e,t){var r;o||(o=this.root),o===this.root&&e&&(r=e(o)),r!==!1&&(o.nodes.forEach(function(n){if(n.isInternal){if(e&&(r=e(n)),r===!1)return;this.visitNodeRecursive(n,e,t)}else n.body&&e&&e(n.body);t&&t(n)},this),o===this.root&&t&&t(o))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(o){o.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$m=Utilities.addEvent,clamp$4=Utilities.clamp,defined$e=Utilities.defined,extend$v=Utilities.extend,isFunction=Utilities.isFunction,pick$y=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$v(H.layouts["reingold-fruchterman"].prototype,{init:function(o){this.options=o,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[o.integration],this.enableSimulation=o.enableSimulation,this.attractiveForce=pick$y(o.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$y(o.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=o.approximation},updateSimulation:function(o){this.enableSimulation=pick$y(o,this.options.enableSimulation)},start:function(){var o=this,e=this.series,t=this.options;o.currentStep=0,o.forces=e[0]&&e[0].forces||[],o.chart=e[0]&&e[0].chart,o.initialRendering&&(o.initPositions(),e.forEach(function(r){r.finishedAnimating=!0,r.render()})),o.setK(),o.resetSimulation(t),o.enableSimulation&&o.step()},step:function(){var o=this,e=this.series;this.options,o.currentStep++,o.approximation==="barnes-hut"&&(o.createQuadTree(),o.quadTree.calculateMassAndCenter()),o.forces.forEach(function(t){o[t+"Forces"](o.temperature)}),o.applyLimits(o.temperature),o.temperature=o.coolDown(o.startTemperature,o.diffTemperature,o.currentStep),o.prevSystemTemperature=o.systemTemperature,o.systemTemperature=o.getSystemTemperature(),o.enableSimulation&&(e.forEach(function(t){t.chart&&t.render()}),o.maxIterations--&&isFinite(o.temperature)&&!o.isStable()?(o.simulation&&H.win.cancelAnimationFrame(o.simulation),o.simulation=H.win.requestAnimationFrame(function(){o.step()})):o.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(o,e,t,r){this.box={left:o,top:e,width:t,height:r}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(o,e){o.forEach(function(t){e.indexOf(t)===-1&&e.push(t)})},removeElementFromCollection:function(o,e){var t=e.indexOf(o);t!==-1&&e.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(o){this.maxIterations=pick$y(o,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(o){this.initialRendering=o},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var o=this.options.initialPositions;isFunction(o)?(o.call(this),this.nodes.forEach(function(e){defined$e(e.prevX)||(e.prevX=e.plotX),defined$e(e.prevY)||(e.prevY=e.plotY),e.dispX=0,e.dispY=0})):o==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var o=this.box,e=this.nodes,t=e.length+1,r=2*Math.PI/t,n=e.filter(function(c){return c.linksTo.length===0}),s=[],a={},l=this.options.initialPositionRadius;function h(c){c.linksFrom.forEach(function(d){a[d.toNode.id]||(a[d.toNode.id]=!0,s.push(d.toNode),h(d.toNode))})}n.forEach(function(c){s.push(c),h(c)}),s.length?e.forEach(function(c){s.indexOf(c)===-1&&s.push(c)}):s=e,s.forEach(function(c,d){c.plotX=c.prevX=pick$y(c.plotX,o.width/2+l*Math.cos(d*r)),c.plotY=c.prevY=pick$y(c.plotY,o.height/2+l*Math.sin(d*r)),c.dispX=0,c.dispY=0})},setRandomPositions:function(){var o=this.box,e=this.nodes,t=e.length+1;function r(n){var s=n*n/Math.PI;return s=s-Math.floor(s),s}e.forEach(function(n,s){n.plotX=n.prevX=pick$y(n.plotX,o.width*r(s)),n.plotY=n.prevY=pick$y(n.plotY,o.height*r(t+s)),n.dispX=0,n.dispY=0})},force:function(o){this.integration[o].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var o=0,e=0,t=0;return this.nodes.forEach(function(r){e+=r.plotX*r.mass,t+=r.plotY*r.mass,o+=r.mass}),this.barycenter={x:e,y:t,xFactor:e/o,yFactor:t/o},this.barycenter},barnesHutApproximation:function(o,e){var t=this,r=t.getDistXY(o,e),n=t.vectorLength(r),s,a;return o!==e&&n!==0&&(e.isInternal?e.boxSize/n<t.options.theta&&n!==0?(a=t.repulsiveForce(n,t.k),t.force("repulsive",o,a*e.mass,r,n),s=!1):s=!0:(a=t.repulsiveForce(n,t.k),t.force("repulsive",o,a*e.mass,r,n))),s},repulsiveForces:function(){var o=this;o.approximation==="barnes-hut"?o.nodes.forEach(function(e){o.quadTree.visitNodeRecursive(null,function(t){return o.barnesHutApproximation(e,t)})}):o.nodes.forEach(function(e){o.nodes.forEach(function(t){var r,n,s;e!==t&&!e.fixedPosition&&(s=o.getDistXY(e,t),n=o.vectorLength(s),n!==0&&(r=o.repulsiveForce(n,o.k),o.force("repulsive",e,r*t.mass,s,n)))})})},attractiveForces:function(){var o=this,e,t,r;o.links.forEach(function(n){n.fromNode&&n.toNode&&(e=o.getDistXY(n.fromNode,n.toNode),t=o.vectorLength(e),t!==0&&(r=o.attractiveForce(t,o.k),o.force("attractive",n,r,e,t)))})},applyLimits:function(){var o=this,e=o.nodes;e.forEach(function(t){t.fixedPosition||(o.integration.integrate(o,t),o.applyLimitBox(t,o.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(o,e){var t=o.radius;o.plotX=clamp$4(o.plotX,e.left+t,e.width-t),o.plotY=clamp$4(o.plotY,e.top+t,e.height-t)},coolDown:function(o,e,t){return o-e*t},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(o,e){return o+e.temperature},0)},vectorLength:function(o){return Math.sqrt(o.x*o.x+o.y*o.y)},getDistR:function(o,e){var t=this.getDistXY(o,e);return this.vectorLength(t)},getDistXY:function(o,e){var t=o.plotX-e.plotX,r=o.plotY-e.plotY;return{x:t,y:r,absX:Math.abs(t),absY:Math.abs(r)}}});addEvent$m(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(o){o.stop()})});addEvent$m(Chart$1,"render",function(){var o,e=!1;function t(r){r.maxIterations--&&isFinite(r.temperature)&&!r.isStable()&&!r.enableSimulation&&(r.beforeStep&&r.beforeStep(),r.step(),o=!1,e=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(r){r.start()});!o;)o=!0,this.graphLayoutsLookup.forEach(t);e&&this.series.forEach(function(r){r&&r.layout&&r.render()})}});addEvent$m(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(o){o.updateSimulation(!1)}),this.redraw())});addEvent$m(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(o){o.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$l=Utilities.addEvent,extendClass=Utilities.extendClass,pick$x=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var o=this,e=o.series,t=[];return e.forEach(function(r){r.parentNode&&r.parentNode.selected&&t.push(r.parentNode)}),t};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(o,e,t,r){return Math.min(o,(t.marker.radius+r.marker.radius)/2)},barycenter:function(){var o=this,e=o.options.gravitationalConstant,t=o.box,r=o.nodes,n,s;r.forEach(function(a){o.options.splitSeries&&!a.isParentNode?(n=a.series.parentNode.plotX,s=a.series.parentNode.plotY):(n=t.width/2,s=t.height/2),a.fixedPosition||(a.plotX-=(a.plotX-n)*e/(a.mass*Math.sqrt(r.length)),a.plotY-=(a.plotY-s)*e/(a.mass*Math.sqrt(r.length)))})},repulsive:function(o,e,t,r){var n=e*this.diffTemperature/o.mass/o.degree,s=t.x*n,a=t.y*n;o.fixedPosition||(o.plotX+=s,o.plotY+=a),r.fixedPosition||(r.plotX-=s,r.plotY-=a)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(o){o&&o.calculateParentRadius()})},isStable:function(){var o=Math.abs(this.prevSystemTemperature-this.systemTemperature),e=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(e)<1&&o<1e-5||this.temperature<=0},setCircularPositions:function(){var o=this,e=o.box,t=o.nodes,r=t.length+1,n=2*Math.PI/r,s,a,l=o.options.initialPositionRadius;t.forEach(function(h,c){o.options.splitSeries&&!h.isParentNode?(s=h.series.parentNode.plotX,a=h.series.parentNode.plotY):(s=e.width/2,a=e.height/2),h.plotX=h.prevX=pick$x(h.plotX,s+l*Math.cos(h.index||c*n)),h.plotY=h.prevY=pick$x(h.plotY,a+l*Math.sin(h.index||c*n)),h.dispX=0,h.dispY=0})},repulsiveForces:function(){var o=this,e,t,r,n=o.options.bubblePadding;o.nodes.forEach(function(s){s.degree=s.mass,s.neighbours=0,o.nodes.forEach(function(a){e=0,s!==a&&!s.fixedPosition&&(o.options.seriesInteraction||s.series===a.series)&&(r=o.getDistXY(s,a),t=o.vectorLength(r)-(s.marker.radius+a.marker.radius+n),t<0&&(s.degree+=.01,s.neighbours++,e=o.repulsiveForce(-t/Math.sqrt(s.neighbours),o.k,s,a)),o.force("repulsive",s,e*a.mass,r,a,t))})})},applyLimitBox:function(o){var e=this,t,r,n=.01;e.options.splitSeries&&!o.isParentNode&&e.options.parentNodeLimit&&(t=e.getDistXY(o,o.series.parentNode),r=o.series.parentNodeRadius-o.marker.radius-e.vectorLength(t),r<0&&r>-2*o.marker.radius&&(o.plotX-=t.x*n,o.plotY-=t.y*n)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$l(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$s=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$8=Color.parse,Series$9=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$k=Utilities.addEvent,clamp$3=Utilities.clamp,defined$d=Utilities.defined,extend$u=Utilities.extend,fireEvent$6=Utilities.fireEvent,isArray$4=Utilities.isArray,isNumber$d=Utilities.isNumber,merge$s=Utilities.merge,pick$w=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=function(o){__extends$s(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.layout=void 0,t.options=void 0,t.points=void 0,t.xData=void 0,t}return e.prototype.accumulateAllPoints=function(t){var r=t.chart,n=[],s,a;for(s=0;s<r.series.length;s++)if(t=r.series[s],t.is("packedbubble")&&t.visible||!r.options.chart.ignoreHiddenSeries)for(a=0;a<t.yData.length;a++)n.push([null,null,t.yData[a],t.index,a,{id:a,marker:{radius:0}}]);return n},e.prototype.addLayout=function(){var t=this,r=t.options.layoutAlgorithm,n=t.chart.graphLayoutsStorage,s=t.chart.graphLayoutsLookup,a=t.chart.options.chart,l;n||(t.chart.graphLayoutsStorage=n={},t.chart.graphLayoutsLookup=s=[]),l=n[r.type],l||(r.enableSimulation=defined$d(a.forExport)?!a.forExport:r.enableSimulation,n[r.type]=l=new H.layouts[r.type],l.init(r),s.splice(l.index,0,l)),t.layout=l,t.points.forEach(function(h){h.mass=2,h.degree=1,h.collisionNmb=1}),l.setArea(0,0,t.chart.plotWidth,t.chart.plotHeight),l.addElementsToCollection([t],l.series),l.addElementsToCollection(t.points,l.nodes)},e.prototype.addSeriesLayout=function(){var t=this,r=t.options.layoutAlgorithm,n=t.chart.graphLayoutsStorage,s=t.chart.graphLayoutsLookup,a=merge$s(r,r.parentNodeOptions,{enableSimulation:t.layout.options.enableSimulation}),l;l=n[r.type+"-series"],l||(n[r.type+"-series"]=l=new H.layouts[r.type],l.init(a),s.splice(l.index,0,l)),t.parentNodeLayout=l,this.createParentNodes()},e.prototype.calculateParentRadius=function(){var t=this,r,n=20,s=20;r=t.seriesBox(),t.parentNodeRadius=clamp$3(Math.sqrt(2*t.parentNodeMass/Math.PI)+n,s,r?Math.max(Math.sqrt(Math.pow(r.width,2)+Math.pow(r.height,2))/2+n,s):Math.sqrt(2*t.parentNodeMass/Math.PI)+n),t.parentNode&&(t.parentNode.marker.radius=t.parentNode.radius=t.parentNodeRadius)},e.prototype.calculateZExtremes=function(){var t=this.chart,r=this.options.zMin,n=this.options.zMax,s=1/0,a=-1/0;return r&&n?[r,n]:(t.series.forEach(function(l){l.yData.forEach(function(h){defined$d(h)&&(h>a&&(a=h),h<s&&(s=h))})}),r=pick$w(r,s),n=pick$w(n,a),[r,n])},e.prototype.checkOverlap=function(t,r){var n=t[0]-r[0],s=t[1]-r[1],a=t[2]+r[2];return Math.sqrt(n*n+s*s)-Math.abs(a)<-.001},e.prototype.createParentNodes=function(){var t=this,r=t.chart,n=t.parentNodeLayout,s,a=t.parentNode,l=t.pointClass;t.parentNodeMass=0,t.points.forEach(function(h){t.parentNodeMass+=Math.PI*Math.pow(h.marker.radius,2)}),t.calculateParentRadius(),n.nodes.forEach(function(h){h.seriesIndex===t.index&&(s=!0)}),n.setArea(0,0,r.plotWidth,r.plotHeight),s||(a||(a=new l().init(this,{mass:t.parentNodeRadius/2,marker:{radius:t.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:t.parentNodeRadius,isParentNode:!0,seriesIndex:t.index})),t.parentNode&&(a.plotX=t.parentNode.plotX,a.plotY=t.parentNode.plotY),t.parentNode=a,n.addElementsToCollection([t],n.series),n.addElementsToCollection([a],n.nodes))},e.prototype.deferLayout=function(){var t=this,r=t.options.layoutAlgorithm;t.visible&&(t.addLayout(),r.splitSeries&&t.addSeriesLayout())},e.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(t){t.removeElementFromCollection(this,t.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$9.prototype.destroy.apply(this,arguments)},e.prototype.drawDataLabels=function(){var t=this.options.dataLabels.textPath,r=this.points;Series$9.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$9.prototype.drawDataLabels.apply(this,arguments),this.points=r,this.options.dataLabels.textPath=t)},e.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var t=this,r=t.chart,n={},s=this.layout.options.parentNodeOptions.marker,a={fill:s.fillColor||color$8(t.color).brighten(.4).get(),opacity:s.fillOpacity,stroke:s.lineColor||t.color,"stroke-width":s.lineWidth};this.parentNodesGroup||(t.parentNodesGroup=t.plotGroup("parentNodesGroup","parentNode",t.visible?"inherit":"hidden",.1,r.seriesGroup),t.group.attr({zIndex:2})),this.calculateParentRadius(),n=merge$s({x:t.parentNode.plotX-t.parentNodeRadius,y:t.parentNode.plotY-t.parentNodeRadius,width:t.parentNodeRadius*2,height:t.parentNodeRadius*2},a),t.parentNode.graphic||(t.graph=t.parentNode.graphic=r.renderer.symbol(a.symbol).add(t.parentNodesGroup)),t.parentNode.graphic.attr(n)}},e.prototype.drawTracker=function(){var t=this,r=t.parentNode,n;o.prototype.drawTracker.call(this),r&&(n=isArray$4(r.dataLabels)?r.dataLabels:r.dataLabel?[r.dataLabel]:[],r.graphic&&(r.graphic.element.point=r),n.forEach(function(s){s.div?s.div.point=r:s.element.point=r}))},e.prototype.getPointRadius=function(){var t=this,r=t.chart,n=r.plotWidth,s=r.plotHeight,a=t.options,l=a.useSimulation,h=Math.min(n,s),c={},d=[],f=r.allDataPoints,p,u,g,v,y;["minSize","maxSize"].forEach(function(m){var x=parseInt(a[m],10),b=/%$/.test(a[m]);c[m]=b?h*x/100:x*Math.sqrt(f.length)}),r.minRadius=p=c.minSize/Math.sqrt(f.length),r.maxRadius=u=c.maxSize/Math.sqrt(f.length),y=l?t.calculateZExtremes():[p,u],(f||[]).forEach(function(m,x){g=l?clamp$3(m[2],y[0],y[1]):m[2],v=t.getRadius(y[0],y[1],p,u,g),v===0&&(v=null),f[x][2]=v,d.push(v)}),t.radii=d},e.prototype.init=function(){return Series$9.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$k(this,"updatedData",function(){this.chart.series.forEach(function(t){t.type===this.type&&(t.isDirty=!0)},this)})),this},e.prototype.onMouseUp=function(t){if(t.fixedPosition&&!t.removed){var r,n,s=this.layout,a=this.parentNodeLayout;a&&s.options.dragBetweenSeries&&a.nodes.forEach(function(l){t&&t.marker&&l!==t.series.parentNode&&(r=s.getDistXY(t,l),n=s.vectorLength(r)-l.marker.radius-t.marker.radius,n<0&&(l.series.addPoint(merge$s(t.options,{plotX:t.plotX,plotY:t.plotY}),!1),s.removeElementFromCollection(t,s.nodes),t.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},e.prototype.placeBubbles=function(t){var r=this,n=r.checkOverlap,s=r.positionBubble,a=[],l=1,h=0,c=0,d,f,p=[],u;if(f=t.sort(function(g,v){return v[2]-g[2]}),f.length){if(a.push([[0,0,f[0][2],f[0][3],f[0][4]]]),f.length>1)for(a.push([[0,0-f[1][2]-f[0][2],f[1][2],f[1][3],f[1][4]]]),u=2;u<f.length;u++)f[u][2]=f[u][2]||1,d=s(a[l][h],a[l-1][c],f[u]),n(d,a[l][0])?(a.push([]),c=0,a[l+1].push(s(a[l][h],a[l][0],f[u])),l++,h=0):l>1&&a[l-1][c+1]&&n(d,a[l-1][c+1])?(c++,a[l].push(s(a[l][h],a[l-1][c],f[u])),h++):(h++,a[l].push(d));r.chart.stages=a,r.chart.rawPositions=[].concat.apply([],a),r.resizeRadius(),p=r.chart.rawPositions}return p},e.prototype.positionBubble=function(t,r,n){var s=Math.sqrt,a=Math.asin,l=Math.acos,h=Math.pow,c=Math.abs,d=s(h(t[0]-r[0],2)+h(t[1]-r[1],2)),f=l((h(d,2)+h(n[2]+r[2],2)-h(n[2]+t[2],2))/(2*(n[2]+r[2])*d)),p=a(c(t[0]-r[0])/d),u=t[1]-r[1]<0?0:Math.PI,g=(t[0]-r[0])*(t[1]-r[1])<0?1:-1,v=u+f+p*g,y=Math.cos(v),m=Math.sin(v),x=r[0]+(r[2]+n[2])*m,b=r[1]-(r[2]+n[2])*y;return[x,b,n[2],n[3],n[4]]},e.prototype.render=function(){var t=this,r=[];Series$9.prototype.render.apply(this,arguments),t.options.dataLabels.allowOverlap||(t.data.forEach(function(n){isArray$4(n.dataLabels)&&n.dataLabels.forEach(function(s){r.push(s)})}),t.options.useSimulation&&t.chart.hideOverlappingLabels(r))},e.prototype.resizeRadius=function(){var t=this.chart,r=t.rawPositions,n=Math.min,s=Math.max,a=t.plotLeft,l=t.plotTop,h=t.plotHeight,c=t.plotWidth,d,f,p,u,g,v,y,m,x;for(d=p=Number.POSITIVE_INFINITY,f=u=Number.NEGATIVE_INFINITY,x=0;x<r.length;x++)g=r[x][2],d=n(d,r[x][0]-g),f=s(f,r[x][0]+g),p=n(p,r[x][1]-g),u=s(u,r[x][1]+g);if(v=[f-d,u-p],y=[(c-a)/v[0],(h-l)/v[1]],m=n.apply([],y),Math.abs(m-1)>1e-10){for(x=0;x<r.length;x++)r[x][2]*=m;this.placeBubbles(r)}else t.diffY=h/2+l-p-(u-p)/2,t.diffX=c/2+a-d-(f-d)/2},e.prototype.seriesBox=function(){var t=this,r=t.chart,n=t.data,s=Math.max,a=Math.min,l,h=[r.plotLeft,r.plotLeft+r.plotWidth,r.plotTop,r.plotTop+r.plotHeight];return n.forEach(function(c){defined$d(c.plotX)&&defined$d(c.plotY)&&c.marker.radius&&(l=c.marker.radius,h[0]=a(h[0],c.plotX-l),h[1]=s(h[1],c.plotX+l),h[2]=a(h[2],c.plotY-l),h[3]=s(h[3],c.plotY+l))}),isNumber$d(h.width/h.height)?h:null},e.prototype.setVisible=function(){var t=this;Series$9.prototype.setVisible.apply(t,arguments),t.parentNodeLayout&&t.graph?t.visible?(t.graph.show(),t.parentNode.dataLabel&&t.parentNode.dataLabel.show()):(t.graph.hide(),t.parentNodeLayout.removeElementFromCollection(t.parentNode,t.parentNodeLayout.nodes),t.parentNode.dataLabel&&t.parentNode.dataLabel.hide()):t.layout&&(t.visible?t.layout.addElementsToCollection(t.points,t.layout.nodes):t.points.forEach(function(r){t.layout.removeElementFromCollection(r,t.layout.nodes)}))},e.prototype.translate=function(){var t=this,r=t.chart,n=t.data,s=t.index,a,l,h,c,d=t.options.useSimulation;for(t.processedXData=t.xData,t.generatePoints(),defined$d(r.allDataPoints)||(r.allDataPoints=t.accumulateAllPoints(t),t.getPointRadius()),d?h=r.allDataPoints:(h=t.placeBubbles(r.allDataPoints),t.options.draggable=!1),c=0;c<h.length;c++)h[c][3]===s&&(a=n[h[c][4]],l=pick$w(h[c][2],void 0),d||(a.plotX=h[c][0]-r.plotLeft+r.diffX,a.plotY=h[c][1]-r.plotTop+r.diffY),isNumber$d(l)&&(a.marker=extend$u(a.marker,{radius:l,width:2*l,height:2*l}),a.radius=l));d&&t.deferLayout(),fireEvent$6(t,"afterTranslate")},e.defaultOptions=merge$s(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.value;return isNumber$d(r)?t(r,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),e}(BubbleSeries);extend$u(PackedBubbleSeries.prototype,{alignDataLabel:Series$9.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$r=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$5=H.noop,Series$8=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$t=Utilities.extend,merge$r=Utilities.merge,PolygonSeries=function(o){__extends$r(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getGraphPath=function(){for(var t=LineSeries$2.prototype.getGraphPath.call(this),r=t.length+1;r--;)(r===t.length||t[r][0]==="M")&&r>0&&t.splice(r,0,["Z"]);return this.areaPath=t,t},e.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},e.defaultOptions=merge$r(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),e}(ScatterSeries$2);extend$t(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$8.prototype.drawTracker,setStackedPoints:noop$5});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$j=Utilities.addEvent,objectEach$8=Utilities.objectEach,WaterfallAxis;(function(o){var e=function(){function l(h){this.axis=h,this.stacks={changed:!1}}return l.prototype.renderStackTotals=function(){var h=this.axis,c=h.waterfall.stacks,d=h.stacking&&h.stacking.stackTotalGroup,f=new StackItem$1(h,h.options.stackLabels,!1,0,void 0);this.dummyStackItem=f,objectEach$8(c,function(p){objectEach$8(p,function(u){f.total=u.stackTotal,u.label&&(f.label=u.label),StackItem$1.prototype.render.call(f,d),u.label=f.label,delete f.label})}),f.total=null},l}();o.Composition=e;function t(l,h){addEvent$j(l,"init",a),addEvent$j(l,"afterBuildStacks",r),addEvent$j(l,"afterRender",n),addEvent$j(h,"beforeRedraw",s)}o.compose=t;function r(){var l=this,h=l.waterfall.stacks;h&&(h.changed=!1,delete h.alreadyChanged)}function n(){var l=this,h=l.options.stackLabels;h&&h.enabled&&l.waterfall.stacks&&l.waterfall.renderStackTotals()}function s(){for(var l=this.axes,h=this.series,c=h.length;c--;)h[c].options.stacking&&(l.forEach(function(d){d.isXAxis||(d.waterfall.stacks.changed=!0)}),c=0)}function a(){var l=this;l.waterfall||(l.waterfall=new e(l))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$q=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),isNumber$c=Utilities.isNumber,WaterfallPoint=function(o){__extends$q(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.getClassName=function(){var t=Point$2.prototype.getClassName.call(this);return this.isSum?t+=" highcharts-sum":this.isIntermediateSum&&(t+=" highcharts-intermediate-sum"),t},e.prototype.isValid=function(){return isNumber$c(this.y)||this.isSum||!!this.isIntermediateSum},e}(ColumnSeries$h.prototype.pointClass),__extends$p=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$s=Utilities.extend,isNumber$b=Utilities.isNumber,merge$q=Utilities.merge,objectEach$7=Utilities.objectEach,pick$v=Utilities.pick;function ownProp(o,e){return Object.hasOwnProperty.call(o,e)}var WaterfallSeries=function(o){__extends$p(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.stackedYNeg=void 0,t.stackedYPos=void 0,t.stackKey=void 0,t.xData=void 0,t.yAxis=void 0,t.yData=void 0,t}return e.prototype.generatePoints=function(){var t,r,n,s;for(ColumnSeries$8.prototype.generatePoints.apply(this),n=0,r=this.points.length;n<r;n++)t=this.points[n],s=this.processedYData[n],(t.isIntermediateSum||t.isSum)&&(t.y=correctFloat$2(s))},e.prototype.translate=function(){var t=this,r=t.options,n=t.yAxis,s,a=pick$v(r.minPointLength,5),l=a/2,h=r.threshold||0,c=h,d=h,f=r.stacking,p=n.waterfall.stacks[t.stackKey],u,g,v;ColumnSeries$8.prototype.translate.apply(t);for(var y=t.points,m=0;m<y.length;m++){var x=y[m],b=t.processedYData[m],$=x.shapeArgs;if(!(!$||!isNumber$b(b))){var S=[0,b],k=x.y;if(f){if(p){var A=p[m];f==="overlap"?(u=A.stackState[A.stateIndex--],s=k>=0?u:u-k,ownProp(A,"absolutePos")&&delete A.absolutePos,ownProp(A,"absoluteNeg")&&delete A.absoluteNeg):(k>=0?(u=A.threshold+A.posTotal,A.posTotal-=k,s=u):(u=A.threshold+A.negTotal,A.negTotal-=k,s=u-k),A.posTotal||ownProp(A,"absolutePos")&&(A.posTotal=A.absolutePos,delete A.absolutePos),A.negTotal||ownProp(A,"absoluteNeg")&&(A.negTotal=A.absoluteNeg,delete A.absoluteNeg)),x.isSum||(A.connectorThreshold=A.threshold+A.stackTotal),n.reversed?(g=k>=0?s-k:s+k,v=s):(g=s,v=s-k),x.below=g<=h,$.y=n.translate(g,!1,!0,!1,!0)||0,$.height=Math.abs($.y-(n.translate(v,!1,!0,!1,!0)||0));var M=n.waterfall.dummyStackItem;M&&(M.x=m,M.label=p[m].label,M.setOffset(t.pointXOffset||0,t.barW||0,t.stackedYNeg[m],t.stackedYPos[m]))}}else s=Math.max(c,c+k)+S[0],$.y=n.translate(s,!1,!0,!1,!0)||0,x.isSum?($.y=n.translate(S[1],!1,!0,!1,!0)||0,$.height=Math.min(n.translate(S[0],!1,!0,!1,!0)||0,n.len)-$.y,x.below=S[1]<=h):x.isIntermediateSum?(k>=0?(g=S[1]+d,v=d):(g=d,v=S[1]+d),n.reversed&&(g^=v,v^=g,g^=v),$.y=n.translate(g,!1,!0,!1,!0)||0,$.height=Math.abs($.y-Math.min(n.translate(v,!1,!0,!1,!0)||0,n.len)),d+=S[1],x.below=g<=h):($.height=b>0?(n.translate(c,!1,!0,!1,!0)||0)-$.y:(n.translate(c,!1,!0,!1,!0)||0)-(n.translate(c-b,!1,!0,!1,!0)||0),c+=b,x.below=c<h),$.height<0&&($.y+=$.height,$.height*=-1);x.plotY=$.y=Math.round($.y||0)-t.borderWidth%2/2,$.height=Math.max(Math.round($.height||0),.001),x.yBottom=$.y+$.height,$.height<=a&&!x.isNull?($.height=a,$.y-=l,x.plotY=$.y,x.y<0?x.minPointLengthOffset=-l:x.minPointLengthOffset=l):(x.isNull&&($.width=0),x.minPointLengthOffset=0);var P=x.plotY+(x.negative?$.height:0);x.below&&(x.plotY+=$.height),x.tooltipPos&&(t.chart.inverted?x.tooltipPos[0]=n.len-P:x.tooltipPos[1]=P)}}},e.prototype.processData=function(t){var r=this,n=r.options,s=r.yData,a=n.data,l,h=s.length,c=n.threshold||0,d,f,p,u,g,v;for(f=d=p=u=0,v=0;v<h;v++)g=s[v],l=a&&a[v]?a[v]:{},g==="sum"||l.isSum?s[v]=correctFloat$2(f):g==="intermediateSum"||l.isIntermediateSum?(s[v]=correctFloat$2(d),d=0):(f+=g,d+=g),p=Math.min(f,p),u=Math.max(f,u);o.prototype.processData.call(this,t),n.stacking||(r.dataMin=p+c,r.dataMax=u)},e.prototype.toYData=function(t){return t.isSum?"sum":t.isIntermediateSum?"intermediateSum":t.y},e.prototype.updateParallelArrays=function(t,r){o.prototype.updateParallelArrays.call(this,t,r),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},e.prototype.pointAttribs=function(t,r){var n=this.options.upColor,s;return n&&!t.options.color&&(t.color=t.y>0?n:null),s=ColumnSeries$8.prototype.pointAttribs.call(this,t,r),delete s.dashstyle,s},e.prototype.getGraphPath=function(){return[["M",0,0]]},e.prototype.getCrispPath=function(){var t=this.data,r=this.yAxis,n=t.length,s=Math.round(this.graph.strokeWidth())%2/2,a=Math.round(this.borderWidth)%2/2,l=this.xAxis.reversed,h=this.yAxis.reversed,c=this.options.stacking,d=[],f,p,u,g,v,y,m,x,b;for(b=1;b<n;b++)if(x=t[b].shapeArgs,g=t[b-1],m=t[b-1].shapeArgs,p=r.waterfall.stacks[this.stackKey],y=g.y>0?-m.height:0,p&&m&&x&&(u=p[b-1],c?(f=u.connectorThreshold,v=Math.round(r.translate(f,0,1,0,1)+(h?y:0))-s):v=m.y+g.minPointLengthOffset+a-s,d.push(["M",(m.x||0)+(l?0:m.width||0),v],["L",(x.x||0)+(l&&x.width||0),v])),m&&d.length&&(!c&&g.y<0&&!h||g.y>0&&h)){var $=d[d.length-2];$&&typeof $[2]=="number"&&($[2]+=m.height||0);var S=d[d.length-1];S&&typeof S[2]=="number"&&(S[2]+=m.height||0)}return d},e.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},e.prototype.setStackedPoints=function(){var t=this,r=t.options,n=t.yAxis.waterfall.stacks,s=r.threshold,a=s||0,l=a,h=t.stackKey,c=t.xData,d=c.length,f,p,u,g,v,y,m,x,b,$,S,k,A;function M(E,T,O,C){if(!y)p.stackState[0]=E,y=p.stackState.length;else for(O;O<y;O++)p.stackState[O]+=C;p.stackState.push(p.stackState[y-1]+T)}if(t.yAxis.stacking.usePercentage=!1,u=g=v=a,t.visible||!t.chart.options.chart.ignoreHiddenSeries){A=n.changed,k=n.alreadyChanged,k&&k.indexOf(h)<0&&(A=!0),n[h]||(n[h]={}),f=n[h];for(var P=0;P<d;P++)S=c[P],(!f[S]||A)&&(f[S]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:A&&f[S]?f[S].label:void 0}),p=f[S],$=t.yData[P],$>=0?p.posTotal+=$:p.negTotal+=$,b=r.data[P],m=p.absolutePos=p.posTotal,x=p.absoluteNeg=p.negTotal,p.stackTotal=m+x,y=p.stackState.length,b&&b.isIntermediateSum?(M(v,g,0,v),v=g,g=s,a^=l,l^=a,a^=l):b&&b.isSum?(M(s,u,y),a=s):(M(a,$,0,u),b&&(u+=$,g+=$)),p.stateIndex++,p.threshold=a,a+=p.stackTotal;n.changed=!1,n.alreadyChanged||(n.alreadyChanged=[]),n.alreadyChanged.push(h)}},e.prototype.getExtremes=function(){var t=this.options.stacking,r,n,s,a;return t?(r=this.yAxis,n=r.waterfall.stacks,s=this.stackedYNeg=[],a=this.stackedYPos=[],t==="overlap"?objectEach$7(n[this.stackKey],function(l){s.push(arrayMin$1(l.stackState)),a.push(arrayMax$1(l.stackState))}):objectEach$7(n[this.stackKey],function(l){s.push(l.negTotal+l.threshold),a.push(l.posTotal+l.threshold)}),{dataMin:arrayMin$1(s),dataMax:arrayMax$1(a)}):{dataMin:this.dataMin,dataMax:this.dataMax}},e.defaultOptions=merge$q(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),e}(ColumnSeries$8);extend$s(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$2=animationExports.animObject,seriesTypes$3=SeriesRegistry$1.seriesTypes,addEvent$i=Utilities.addEvent,defined$c=Utilities.defined,find$4=Utilities.find,isNumber$a=Utilities.isNumber,pick$u=Utilities.pick,splat$3=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$6=Utilities.wrap,seriesProto=Series$e.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(o){var e=this,t=e.chart,r=e.xAxis,n=r.pane.center,s=o.chartX-n[0]-t.plotLeft,a=o.chartY-n[1]-t.plotTop;return this.searchKDTree({clientX:180+Math.atan2(s,a)*(-180/Math.PI)})};seriesProto.getConnectors=function(o,e,t,r){var n,s,a,l,h,c,d,f,p,u,g,v,y=1.5,m=y+1,x,b,$,S,k,A,M,P,E,T=r?1:0;return e>=0&&e<=o.length-1?n=e:e<0?n=o.length-1+e:n=0,s=n-1<0?o.length-(1+T):n-1,a=n+1>o.length-1?T:n+1,l=o[s],h=o[a],c=l.plotX,d=l.plotY,f=h.plotX,p=h.plotY,u=o[n].plotX,g=o[n].plotY,x=(y*u+c)/m,b=(y*g+d)/m,$=(y*u+f)/m,S=(y*g+p)/m,k=Math.sqrt(Math.pow(x-u,2)+Math.pow(b-g,2)),A=Math.sqrt(Math.pow($-u,2)+Math.pow(S-g,2)),M=Math.atan2(b-g,x-u),P=Math.atan2(S-g,$-u),E=Math.PI/2+(M+P)/2,Math.abs(M-E)>Math.PI/2&&(E-=Math.PI),x=u+Math.cos(E)*k,b=g+Math.sin(E)*k,$=u+Math.cos(Math.PI+E)*A,S=g+Math.sin(Math.PI+E)*A,v={rightContX:$,rightContY:S,leftContX:x,leftContY:b,plotX:u,plotY:g},t&&(v.prevPointCont=this.getConnectors(o,s,!1,r)),v};seriesProto.toXY=function(o){var e=this.chart,t=this.xAxis,r=this.yAxis,n=o.plotX,s=o.plotY,a=o.series,l=e.inverted,h=o.y,c=l?n:r.len-s,d;if(l&&a&&!a.isRadialBar&&(o.plotY=s=typeof h=="number"&&r.translate(h)||0),o.rectPlotX=n,o.rectPlotY=s,r.center&&(c+=r.center[3]/2),isNumber$a(s)){var f=l?r.postTranslate(s,c):t.postTranslate(n,c);o.plotX=o.polarPlotX=f.x-e.plotLeft,o.plotY=o.polarPlotY=f.y-e.plotTop}this.kdByAngle?(d=(n/Math.PI*180+t.pane.options.startAngle)%360,d<0&&(d+=360),o.clientX=d):o.clientX=o.plotX};seriesTypes$3.spline&&(wrap$6(seriesTypes$3.spline.prototype,"getPointSpline",function(o,e,t,r){var n,s;if(this.chart.polar)if(!r)n=["M",t.plotX,t.plotY];else{s=this.getConnectors(e,r,!0,this.connectEnds);var a=s.prevPointCont&&s.prevPointCont.rightContX,l=s.prevPointCont&&s.prevPointCont.rightContY;n=["C",isNumber$a(a)?a:s.plotX,isNumber$a(l)?l:s.plotY,isNumber$a(s.leftContX)?s.leftContX:s.plotX,isNumber$a(s.leftContY)?s.leftContY:s.plotY,s.plotX,s.plotY]}else n=o.call(this,e,t,r);return n}),seriesTypes$3.areasplinerange&&(seriesTypes$3.areasplinerange.prototype.getPointSpline=seriesTypes$3.spline.prototype.getPointSpline));addEvent$i(Series$e,"afterTranslate",function(){var o=this,e=o.chart;if(e.polar&&o.xAxis){if(o.kdByAngle=e.tooltip&&e.tooltip.shared,o.kdByAngle?o.searchPoint=o.searchPointByAngle:o.options.findNearestPointBy="xy",!o.preventPostTranslate)for(var t=o.points,r=t.length;r--;)o.toXY(t[r]),!e.hasParallelCoordinates&&!o.yAxis.reversed&&t[r].y<o.yAxis.min&&(t[r].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!o.eventsToUnbind.push(addEvent$i(o,"afterRender",function(){var n;e.polar&&(n=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:n[0],y:n[1],r:n[2]/2,innerR:n[3]/2}):this.clipCircle=e.renderer.clipCircle(n[0],n[1],n[2]/2,n[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$6(seriesTypes$3.line.prototype,"getGraphPath",function(o,e){var t=this,r,n,s;if(this.chart.polar){for(e=e||this.points,r=0;r<e.length;r++)if(!e[r].isNull){n=r;break}this.options.connectEnds!==!1&&typeof n<"u"&&(this.connectEnds=!0,e.splice(e.length,0,e[n]),s=!0),e.forEach(function(l){typeof l.polarPlotY>"u"&&t.toXY(l)})}var a=o.apply(this,[].slice.call(arguments,1));return s&&e.pop(),a});var polarAnimate=function(o,e){var t=this,r=this.chart,n=this.options.animation,s=this.group,a=this.markerGroup,l=this.xAxis.center,h=r.plotLeft,c=r.plotTop,d,f,p,u,g,v;r.polar?t.isRadialBar?e||(t.startAngleRad=pick$u(t.translatedThreshold,t.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(t,e)):r.renderer.isSVG&&(n=animObject$2(n),t.is("column")?e||(f=l[3]/2,t.points.forEach(function(y){p=y.graphic,u=y.shapeArgs,g=u&&u.r,v=u&&u.innerR,p&&u&&(p.attr({r:f,innerR:f}),p.animate({r:g,innerR:v},t.options.animation))})):e?(d={translateX:l[0]+h,translateY:l[1]+c,scaleX:.001,scaleY:.001},s.attr(d),a&&a.attr(d)):(d={translateX:h,translateY:c,scaleX:1,scaleY:1},s.animate(d,n),a&&a.animate(d,n))):o.call(this,e)};wrap$6(seriesProto,"animate",polarAnimate);seriesTypes$3.column&&(arearangeProto=seriesTypes$3.arearange.prototype,columnProto$2=seriesTypes$3.column.prototype,columnProto$2.polarArc=function(o,e,t,r){var n=this.xAxis.center,s=this.yAxis.len,a=n[3]/2,l=s-e+a,h=s-pick$u(o,s)+a;return this.yAxis.reversed&&(l<0&&(l=a),h<0&&(h=a)),{x:n[0],y:n[1],r:l,innerR:h,start:t,end:r}},wrap$6(columnProto$2,"animate",polarAnimate),wrap$6(columnProto$2,"translate",function(o){var e=this,t=e.options,r=t.threshold,n=t.stacking,s=e.chart,a=e.xAxis,l=e.yAxis,h=l.reversed,c=l.center,d=a.startAngleRad,f=a.endAngleRad,p=f-d,u,g,v,y,m,x,b,$,S,k,A,M,P,E,T,O;if(e.preventPostTranslate=!0,o.call(e),a.isRadial)for(g=e.points,y=g.length,m=l.translate(l.min),x=l.translate(l.max),r=t.threshold||0,s.inverted&&isNumber$a(r)&&(u=l.translate(r),defined$c(u)&&(u<0?u=0:u>p&&(u=p),e.translatedThreshold=u+d));y--;)v=g[y],E=v.barX,k=v.x,A=v.y,v.shapeType="arc",s.inverted?(v.plotY=l.translate(A),n&&l.stacking?(P=l.stacking.stacks[(A<0?"-":"")+e.stackKey],e.visible&&P&&P[k]&&(v.isNull||(M=P[k].points[e.getStackIndicator(void 0,k,e.index).key],b=l.translate(M[0]),$=l.translate(M[1]),defined$c(b)&&(b=Utilities.clamp(b,0,p))))):(b=u,$=v.plotY),b>$&&($=[b,b=$][0]),h?$>m?$=m:b<x?b=x:(b>m||$<x)&&(b=$=p):b<m?b=m:$>x?$=x:($<m||b>x)&&(b=$=0),l.min>l.max&&(b=$=h?p:0),b+=d,$+=d,c&&(v.barX=E+=c[3]/2),T=Math.max(E,0),O=Math.max(E+v.pointWidth,0),v.shapeArgs={x:c&&c[0],y:c&&c[1],r:O,innerR:T,start:b,end:$},v.opacity=b===$?0:void 0,v.plotY=(defined$c(e.translatedThreshold)&&(b<e.translatedThreshold?b:$))-d):(b=E+d,v.shapeArgs=e.polarArc(v.yBottom,v.plotY,b,b+v.pointWidth)),e.toXY(v),s.inverted?(S=l.postTranslate(v.rectPlotY,E+v.pointWidth/2),v.tooltipPos=[S.x-s.plotLeft,S.y-s.plotTop]):v.tooltipPos=[v.plotX,v.plotY],c&&(v.ttBelow=v.plotY>c[1])}),columnProto$2.findAlignments=function(o,e){var t,r;return e.align===null&&(o>20&&o<160?t="left":o>200&&o<340?t="right":t="center",e.align=t),e.verticalAlign===null&&(o<45||o>315?r="bottom":o>135&&o<225?r="top":r="middle",e.verticalAlign=r),e},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$6(columnProto$2,"alignDataLabel",function(o,e,t,r,n,s){var a=this.chart,l=pick$u(r.inside,!!this.options.stacking),h,c,d;a.polar?(h=e.rectPlotX/Math.PI*180,a.inverted?(this.forceDL=a.isInsidePlot(e.plotX,Math.round(e.plotY)),l&&e.shapeArgs?(c=e.shapeArgs,d=this.yAxis.postTranslate(((c.start||0)+(c.end||0))/2-this.xAxis.startAngleRad,e.barX+e.pointWidth/2),n={x:d.x-a.plotLeft,y:d.y-a.plotTop}):e.tooltipPos&&(n={x:e.tooltipPos[0],y:e.tooltipPos[1]}),r.align=pick$u(r.align,"center"),r.verticalAlign=pick$u(r.verticalAlign,"middle")):this.findAlignments&&(r=this.findAlignments(h,r)),seriesProto.alignDataLabel.call(this,e,t,r,n,s),this.isRadialBar&&e.shapeArgs&&e.shapeArgs.start===e.shapeArgs.end&&t.hide(!0)):o.call(this,e,t,r,n,s)}));wrap$6(pointerProto,"getCoordinates",function(o,e){var t=this.chart,r={xAxis:[],yAxis:[]};return t.polar?t.axes.forEach(function(n){var s=n.isXAxis,a=n.center,l,h;n.coll!=="colorAxis"&&(l=e.chartX-a[0]-t.plotLeft,h=e.chartY-a[1]-t.plotTop,r[s?"xAxis":"yAxis"].push({axis:n,value:n.translate(s?Math.PI-Math.atan2(l,h):Math.sqrt(Math.pow(l,2)+Math.pow(h,2)),!0)}))}):r=o.call(this,e),r});SVGRenderer.prototype.clipCircle=function(o,e,t,r){var n,s=uniqueKey$1(),a=this.createElement("clipPath").attr({id:s}).add(this.defs);return n=r?this.arc(o,e,t,r,0,2*Math.PI).add(a):this.circle(o,e,t).add(a),n.id=s,n.clipPath=a,n};addEvent$i(Chart$1,"getAxes",function(){this.pane||(this.pane=[]),this.options.pane=splat$3(this.options.pane),this.options.pane.forEach(function(o){new Pane$1(o,this)},this)});addEvent$i(Chart$1,"afterDrawChartBox",function(){this.pane.forEach(function(o){o.render()})});addEvent$i(Series$e,"afterInit",function(){var o=this.chart;o.inverted&&o.polar&&(this.isRadialSeries=!0,this.is("column")&&(this.isRadialBar=!0))});wrap$6(Chart$1.prototype,"get",function(o,e){return find$4(this.pane||[],function(t){return t.options.id===e})||o.call(this,e)});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-more
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$4=H;RadialAxis$1.compose(G$4.Axis,G$4.Tick);BubbleSeries$2.compose(G$4.Chart,G$4.Legend,G$4.Series);var pick$t=Utilities.pick,deg2rad$3=H.deg2rad;function rotate3D(o,e,t,r){return{x:r.cosB*o-r.sinB*t,y:-r.sinA*r.sinB*o+r.cosA*e-r.cosB*r.sinA*t,z:r.cosA*r.sinB*o+r.sinA*e+r.cosA*r.cosB*t}}function perspective3D$1(o,e,t){var r=t>0&&t<Number.POSITIVE_INFINITY?t/(o.z+e.z+t):1;return{x:o.x*r,y:o.y*r}}H.perspective3D=perspective3D$1;function perspective$6(o,e,t,r){var n=e.options.chart.options3d,s=pick$t(r,t?e.inverted:!1),a={x:e.plotWidth/2,y:e.plotHeight/2,z:n.depth/2,vd:pick$t(n.depth,1)*pick$t(n.viewDistance,0)},l=e.scale3d||1,h=deg2rad$3*n.beta*(s?-1:1),c=deg2rad$3*n.alpha*(s?-1:1),d={cosA:Math.cos(c),cosB:Math.cos(-h),sinA:Math.sin(c),sinB:Math.sin(-h)};return t||(a.x+=e.plotLeft,a.y+=e.plotTop),o.map(function(f){var p=rotate3D((s?f.y:f.x)-a.x,(s?f.x:f.y)-a.y,(f.z||0)-a.z,d),u=perspective3D$1(p,a,a.vd);return u.x=u.x*l+a.x,u.y=u.y*l+a.y,u.z=p.z*l+a.z,{x:s?u.y:u.x,y:s?u.x:u.y,z:u.z}})}H.perspective=perspective$6;function pointCameraDistance$1(o,e){var t=e.options.chart.options3d,r={x:e.plotWidth/2,y:e.plotHeight/2,z:pick$t(t.depth,1)*pick$t(t.viewDistance,0)+t.depth},n=Math.sqrt(Math.pow(r.x-pick$t(o.plotX,o.x),2)+Math.pow(r.y-pick$t(o.plotY,o.y),2)+Math.pow(r.z-pick$t(o.plotZ,o.z),2));return n}H.pointCameraDistance=pointCameraDistance$1;function shapeArea$2(o){var e=0,t,r;for(t=0;t<o.length;t++)r=(t+1)%o.length,e+=o[t].x*o[r].y-o[r].x*o[t].y;return e/2}H.shapeArea=shapeArea$2;function shapeArea3D$1(o,e,t){return shapeArea$2(perspective$6(o,e,t))}H.shapeArea3d=shapeArea3D$1;var mathModule={perspective:perspective$6,perspective3D:perspective3D$1,pointCameraDistance:pointCameraDistance$1,shapeArea:shapeArea$2,shapeArea3D:shapeArea3D$1},color$7=Color.parse,defined$b=Utilities.defined,merge$p=Utilities.merge,objectEach$6=Utilities.objectEach,pick$s=Utilities.pick,SVGElement3D={};SVGElement3D.base={initArgs:function(o){var e=this,t=e.renderer,r=t[e.pathType+"Path"](o),n=r.zIndexes;e.parts.forEach(function(s){e[s]=t.path(r[s]).attr({class:"highcharts-3d-"+s,zIndex:n[s]||0}).add(e)}),e.attr({"stroke-linejoin":"round",zIndex:n.group}),e.originalDestroy=e.destroy,e.destroy=e.destroyParts,e.forcedSides=r.forcedSides},singleSetterForParts:function(o,e,t,r,n,s){var a=this,l={},h=[null,null,r||"attr",n,s],c=t&&t.zIndexes;return t?(c&&c.group&&this.attr({zIndex:c.group}),objectEach$6(t,function(d,f){l[f]={},l[f][o]=d,c&&(l[f].zIndex=t.zIndexes[f]||0)}),h[1]=l):(l[o]=e,h[0]=l),a.processParts.apply(a,h)},processParts:function(o,e,t,r,n){var s=this;return s.parts.forEach(function(a){e&&(o=pick$s(e[a],!1)),o!==!1&&s[a][t](o,r,n)}),s},destroyParts:function(){return this.processParts(null,null,"destroy"),this.originalDestroy()}};SVGElement3D.cuboid=merge$p(SVGElement3D.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(o,e,t,r){if(typeof o=="string"&&typeof e<"u"){var n=o;o={},o[n]=e}return o.shapeArgs||defined$b(o.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](o.shapeArgs||o)):SVGElement.prototype.attr.call(this,o,void 0,t,r)},animate:function(o,e,t){if(defined$b(o.x)&&defined$b(o.y)){var r=this.renderer[this.pathType+"Path"](o),n=r.forcedSides;this.singleSetterForParts("d",null,r,"animate",e,t),this.attr({zIndex:r.zIndexes.group}),n!==this.forcedSides&&(this.forcedSides=n,SVGElement3D.cuboid.fillSetter.call(this,this.fill))}else SVGElement.prototype.animate.call(this,o,e,t);return this},fillSetter:function(o){var e=this;return e.forcedSides=e.forcedSides||[],e.singleSetterForParts("fill",null,{front:o,top:color$7(o).brighten(e.forcedSides.indexOf("top")>=0?0:.1).get(),side:color$7(o).brighten(e.forcedSides.indexOf("side")>=0?0:-.1).get()}),e.color=e.fill=o,e}});var __extends$o=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$1=animationExports.animObject,color$6=Color.parse,charts=H.charts,deg2rad$2=H.deg2rad,perspective$5=mathModule.perspective,shapeArea$1=mathModule.shapeArea,defined$a=Utilities.defined,extend$r=Utilities.extend,merge$o=Utilities.merge,pick$r=Utilities.pick,cos=Math.cos,sin=Math.sin,PI=Math.PI,dFactor=4*(Math.sqrt(2)-1)/3/(PI/2),SVGRenderer3D=function(o){__extends$o(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.compose=function(t){var r=t.prototype,n=e.prototype;r.elements3d=SVGElement3D,r.arc3d=n.arc3d,r.arc3dPath=n.arc3dPath,r.cuboid=n.cuboid,r.cuboidPath=n.cuboidPath,r.element3d=n.element3d,r.face3d=n.face3d,r.polyhedron=n.polyhedron,r.toLinePath=n.toLinePath,r.toLineSegments=n.toLineSegments},e.curveTo=function(t,r,n,s,a,l,h,c){var d=[],f=l-a;return l>a&&l-a>Math.PI/2+1e-4?(d=d.concat(this.curveTo(t,r,n,s,a,a+Math.PI/2,h,c)),d=d.concat(this.curveTo(t,r,n,s,a+Math.PI/2,l,h,c)),d):l<a&&a-l>Math.PI/2+1e-4?(d=d.concat(this.curveTo(t,r,n,s,a,a-Math.PI/2,h,c)),d=d.concat(this.curveTo(t,r,n,s,a-Math.PI/2,l,h,c)),d):[["C",t+n*Math.cos(a)-n*dFactor*f*Math.sin(a)+h,r+s*Math.sin(a)+s*dFactor*f*Math.cos(a)+c,t+n*Math.cos(l)+n*dFactor*f*Math.sin(l)+h,r+s*Math.sin(l)-s*dFactor*f*Math.cos(l)+c,t+n*Math.cos(l)+h,r+s*Math.sin(l)+c]]},e.prototype.toLinePath=function(t,r){var n=[];return t.forEach(function(s){n.push(["L",s.x,s.y])}),t.length&&(n[0][0]="M",r&&n.push(["Z"])),n},e.prototype.toLineSegments=function(t){var r=[],n=!0;return t.forEach(function(s){r.push(n?["M",s.x,s.y]:["L",s.x,s.y]),n=!n}),r},e.prototype.face3d=function(t){var r=this,n=this.createElement("path");return n.vertexes=[],n.insidePlotArea=!1,n.enabled=!0,n.attr=function(s){if(typeof s=="object"&&(defined$a(s.enabled)||defined$a(s.vertexes)||defined$a(s.insidePlotArea))){this.enabled=pick$r(s.enabled,this.enabled),this.vertexes=pick$r(s.vertexes,this.vertexes),this.insidePlotArea=pick$r(s.insidePlotArea,this.insidePlotArea),delete s.enabled,delete s.vertexes,delete s.insidePlotArea;var a=charts[r.chartIndex],l=perspective$5(this.vertexes,a,this.insidePlotArea),h=r.toLinePath(l,!0),c=shapeArea$1(l);s.d=h,s.visibility=this.enabled&&c>0?"visible":"hidden"}return SVGElement.prototype.attr.apply(this,arguments)},n.animate=function(s){if(typeof s=="object"&&(defined$a(s.enabled)||defined$a(s.vertexes)||defined$a(s.insidePlotArea))){this.enabled=pick$r(s.enabled,this.enabled),this.vertexes=pick$r(s.vertexes,this.vertexes),this.insidePlotArea=pick$r(s.insidePlotArea,this.insidePlotArea),delete s.enabled,delete s.vertexes,delete s.insidePlotArea;var a=charts[r.chartIndex],l=perspective$5(this.vertexes,a,this.insidePlotArea),h=r.toLinePath(l,!0),c=shapeArea$1(l),d=this.enabled&&c>0?"visible":"hidden";s.d=h,this.attr("visibility",d)}return SVGElement.prototype.animate.apply(this,arguments)},n.attr(t)},e.prototype.polyhedron=function(t){var r=this,n=this.g(),s=n.destroy;return this.styledMode||n.attr({"stroke-linejoin":"round"}),n.faces=[],n.destroy=function(){for(var a=0;a<n.faces.length;a++)n.faces[a].destroy();return s.call(this)},n.attr=function(a,l,h,c){if(typeof a=="object"&&defined$a(a.faces)){for(;n.faces.length>a.faces.length;)n.faces.pop().destroy();for(;n.faces.length<a.faces.length;)n.faces.push(r.face3d().add(n));for(var d=0;d<a.faces.length;d++)r.styledMode&&delete a.faces[d].fill,n.faces[d].attr(a.faces[d],null,h,c);delete a.faces}return SVGElement.prototype.attr.apply(this,arguments)},n.animate=function(a,l,h){if(a&&a.faces){for(;n.faces.length>a.faces.length;)n.faces.pop().destroy();for(;n.faces.length<a.faces.length;)n.faces.push(r.face3d().add(n));for(var c=0;c<a.faces.length;c++)n.faces[c].animate(a.faces[c],l,h);delete a.faces}return SVGElement.prototype.animate.apply(this,arguments)},n.attr(t)},e.prototype.element3d=function(t,r){var n=this.g();return extend$r(n,this.elements3d[t]),n.initArgs(r),n},e.prototype.cuboid=function(t){return this.element3d("cuboid",t)},e.prototype.cuboidPath=function(t){var r=t.x||0,n=t.y||0,s=t.z||0,a=t.height||0,l=t.width||0,h=t.depth||0,c=charts[this.chartIndex],d,f,p,u,g,v,y,m,x,b,$,S,k,A=c.options.chart.options3d,M=A.alpha,P=1e6,E=10,T=100,O=0,C=[{x:r,y:n,z:s},{x:r+l,y:n,z:s},{x:r+l,y:n+a,z:s},{x:r,y:n+a,z:s},{x:r,y:n+a,z:s+h},{x:r+l,y:n+a,z:s+h},{x:r+l,y:n,z:s+h},{x:r,y:n,z:s+h}],I=[],L;C=perspective$5(C,c,t.insidePlotArea);function D(B){return a===0&&B>1&&B<6?{x:C[B].x,y:C[B].y+10,z:C[B].z}:C[0].x===C[7].x&&B>=4?{x:C[B].x+10,y:C[B].y,z:C[B].z}:h===0&&B<2||B>5?{x:C[B].x,y:C[B].y,z:C[B].z+10}:C[B]}function N(B){return C[B]}return L=function(B,X,W){var F=[[],-1],U=B.map(N),z=X.map(N),V=B.map(D),j=X.map(D);return shapeArea$1(U)<0?F=[U,0]:shapeArea$1(z)<0?F=[z,1]:W&&(I.push(W),shapeArea$1(V)<0?F=[U,0]:shapeArea$1(j)<0?F=[z,1]:F=[U,0]),F},d=[3,2,1,0],f=[7,6,5,4],y=L(d,f,"front"),m=y[0],$=y[1],p=[1,6,7,0],u=[4,5,2,3],y=L(p,u,"top"),x=y[0],S=y[1],v=[1,2,5,6],g=[0,7,4,3],y=L(v,g,"side"),b=y[0],k=y[1],k===1?O+=P*(c.plotWidth-r):k||(O+=P*r),O+=E*(!S||M>=0&&M<=180||M<360&&M>357.5?c.plotHeight-n:10+n),$===1?O+=T*s:$||(O+=T*(1e3-s)),{front:this.toLinePath(m,!0),top:this.toLinePath(x,!0),side:this.toLinePath(b,!0),zIndexes:{group:Math.round(O)},forcedSides:I,isFront:$,isTop:S}},e.prototype.arc3d=function(t){var r=this.g(),n=r.renderer,s=["x","y","r","innerR","start","end","depth"];function a(l){var h=!1,c={},d;l=merge$o(l);for(d in l)s.indexOf(d)!==-1&&(c[d]=l[d],delete l[d],h=!0);return h?[c,l]:!1}return t=merge$o(t),t.alpha=(t.alpha||0)*deg2rad$2,t.beta=(t.beta||0)*deg2rad$2,r.top=n.path(),r.side1=n.path(),r.side2=n.path(),r.inn=n.path(),r.out=n.path(),r.onAdd=function(){var l=r.parentGroup,h=r.attr("class");r.top.add(r),["out","inn","side1","side2"].forEach(function(c){r[c].attr({class:h+" highcharts-3d-side"}).add(l)})},["addClass","removeClass"].forEach(function(l){r[l]=function(){var h=arguments;["top","out","inn","side1","side2"].forEach(function(c){r[c][l].apply(r[c],h)})}}),r.setPaths=function(l){var h=r.renderer.arc3dPath(l),c=h.zTop*100;r.attribs=l,r.top.attr({d:h.top,zIndex:h.zTop}),r.inn.attr({d:h.inn,zIndex:h.zInn}),r.out.attr({d:h.out,zIndex:h.zOut}),r.side1.attr({d:h.side1,zIndex:h.zSide1}),r.side2.attr({d:h.side2,zIndex:h.zSide2}),r.zIndex=c,r.attr({zIndex:c}),l.center&&(r.top.setRadialReference(l.center),delete l.center)},r.setPaths(t),r.fillSetter=function(l){var h=color$6(l).brighten(-.1).get();return this.fill=l,this.side1.attr({fill:h}),this.side2.attr({fill:h}),this.inn.attr({fill:h}),this.out.attr({fill:h}),this.top.attr({fill:l}),this},["opacity","translateX","translateY","visibility"].forEach(function(l){r[l+"Setter"]=function(h,c){r[c]=h,["out","inn","side1","side2","top"].forEach(function(d){r[d].attr(c,h)})}}),r.attr=function(l){var h,c;return typeof l=="object"&&(c=a(l),c&&(h=c[0],arguments[0]=c[1],extend$r(r.attribs,h),r.setPaths(r.attribs))),SVGElement.prototype.attr.apply(r,arguments)},r.animate=function(l,h,c){var d,f=this.attribs,p,u,g="data-"+Math.random().toString(26).substring(2,9);return delete l.center,delete l.z,delete l.alpha,delete l.beta,u=animObject$1(pick$r(h,this.renderer.globalAnimation)),u.duration&&(d=a(l),r[g]=0,l[g]=1,r[g+"Setter"]=H.noop,d&&(p=d[0],u.step=function(v,y){function m(x){return f[x]+(pick$r(p[x],f[x])-f[x])*y.pos}y.prop===g&&y.elem.setPaths(merge$o(f,{x:m("x"),y:m("y"),r:m("r"),innerR:m("innerR"),start:m("start"),end:m("end"),depth:m("depth")}))}),h=u),SVGElement.prototype.animate.call(this,l,h,c)},r.destroy=function(){return this.top.destroy(),this.out.destroy(),this.inn.destroy(),this.side1.destroy(),this.side2.destroy(),SVGElement.prototype.destroy.call(this)},r.hide=function(){this.top.hide(),this.out.hide(),this.inn.hide(),this.side1.hide(),this.side2.hide()},r.show=function(l){this.top.show(l),this.out.show(l),this.inn.show(l),this.side1.show(l),this.side2.show(l)},r},e.prototype.arc3dPath=function(t){var r=t.x||0,n=t.y||0,s=t.start||0,a=(t.end||0)-1e-5,l=t.r||0,h=t.innerR||0,c=t.depth||0,d=t.alpha||0,f=t.beta||0,p=Math.cos(s),u=Math.sin(s),g=Math.cos(a),v=Math.sin(a),y=l*Math.cos(f),m=l*Math.cos(d),x=h*Math.cos(f),b=h*Math.cos(d),$=c*Math.sin(f),S=c*Math.sin(d),k=[["M",r+y*p,n+m*u]];k=k.concat(e.curveTo(r,n,y,m,s,a,0,0)),k.push(["L",r+x*g,n+b*v]),k=k.concat(e.curveTo(r,n,x,b,a,s,0,0)),k.push(["Z"]);var A=f>0?Math.PI/2:0,M=d>0?0:Math.PI/2,P=s>-A?s:a>-A?-A:s,E=a<PI-M?a:s<PI-M?PI-M:a,T=2*PI-M,O=[["M",r+y*cos(P),n+m*sin(P)]];O=O.concat(e.curveTo(r,n,y,m,P,E,0,0)),a>T&&s<T?(O.push(["L",r+y*cos(E)+$,n+m*sin(E)+S]),O=O.concat(e.curveTo(r,n,y,m,E,T,$,S)),O.push(["L",r+y*cos(T),n+m*sin(T)]),O=O.concat(e.curveTo(r,n,y,m,T,a,0,0)),O.push(["L",r+y*cos(a)+$,n+m*sin(a)+S]),O=O.concat(e.curveTo(r,n,y,m,a,T,$,S)),O.push(["L",r+y*cos(T),n+m*sin(T)]),O=O.concat(e.curveTo(r,n,y,m,T,E,0,0))):a>PI-M&&s<PI-M&&(O.push(["L",r+y*Math.cos(E)+$,n+m*Math.sin(E)+S]),O=O.concat(e.curveTo(r,n,y,m,E,a,$,S)),O.push(["L",r+y*Math.cos(a),n+m*Math.sin(a)]),O=O.concat(e.curveTo(r,n,y,m,a,E,0,0))),O.push(["L",r+y*Math.cos(E)+$,n+m*Math.sin(E)+S]),O=O.concat(e.curveTo(r,n,y,m,E,P,$,S)),O.push(["Z"]);var C=[["M",r+x*p,n+b*u]];C=C.concat(e.curveTo(r,n,x,b,s,a,0,0)),C.push(["L",r+x*Math.cos(a)+$,n+b*Math.sin(a)+S]),C=C.concat(e.curveTo(r,n,x,b,a,s,$,S)),C.push(["Z"]);var I=[["M",r+y*p,n+m*u],["L",r+y*p+$,n+m*u+S],["L",r+x*p+$,n+b*u+S],["L",r+x*p,n+b*u],["Z"]],L=[["M",r+y*g,n+m*v],["L",r+y*g+$,n+m*v+S],["L",r+x*g+$,n+b*v+S],["L",r+x*g,n+b*v],["Z"]],D=Math.atan2(S,-$),N=Math.abs(a+D),B=Math.abs(s+D),X=Math.abs((s+a)/2+D);function W(j){return j=j%(2*Math.PI),j>Math.PI&&(j=2*Math.PI-j),j}N=W(N),B=W(B),X=W(X);var F=1e5,U=X*F,z=B*F,V=N*F;return{top:k,zTop:Math.PI*F+1,out:O,zOut:Math.max(U,z,V),inn:C,zInn:Math.max(U,z,V),side1:I,zSide1:V*.99,side2:L,zSide2:z*.99}},e}(SVGRenderer),color$5=Color.parse,perspective$4=mathModule.perspective,shapeArea3D=mathModule.shapeArea3D,genericDefaultOptions=DefaultOptions.defaultOptions,addEvent$h=Utilities.addEvent,isArray$3=Utilities.isArray,merge$n=Utilities.merge,pick$q=Utilities.pick,wrap$5=Utilities.wrap,Chart3D;(function(o){var e=function(){function g(v){this.frame3d=void 0,this.chart=v}return g.prototype.get3dFrame=function(){var v=this.chart,y=v.options.chart.options3d,m=y.frame,x=v.plotLeft,b=v.plotLeft+v.plotWidth,$=v.plotTop,S=v.plotTop+v.plotHeight,k=0,A=y.depth,M=function(Y){var Z=shapeArea3D(Y,v);return Z>.5?1:Z<-.5?-1:0},P=M([{x,y:S,z:A},{x:b,y:S,z:A},{x:b,y:S,z:k},{x,y:S,z:k}]),E=M([{x,y:$,z:k},{x:b,y:$,z:k},{x:b,y:$,z:A},{x,y:$,z:A}]),T=M([{x,y:$,z:k},{x,y:$,z:A},{x,y:S,z:A},{x,y:S,z:k}]),O=M([{x:b,y:$,z:A},{x:b,y:$,z:k},{x:b,y:S,z:k},{x:b,y:S,z:A}]),C=M([{x,y:S,z:k},{x:b,y:S,z:k},{x:b,y:$,z:k},{x,y:$,z:k}]),I=M([{x,y:$,z:A},{x:b,y:$,z:A},{x:b,y:S,z:A},{x,y:S,z:A}]),L=!1,D=!0,N=!1,B=!1,X=!1,W=!1;[].concat(v.xAxis,v.yAxis,v.zAxis).forEach(function(Y){Y&&(Y.horiz?Y.opposite?B=!0:N=!0:Y.opposite?W=!0:X=!0)});var F=function(Y,Z,et){for(var Q=["size","color","visible"],tt={},rt=0;rt<Q.length;rt++)for(var it=Q[rt],nt=0;nt<Y.length;nt++)if(typeof Y[nt]=="object"){var st=Y[nt][it];if(typeof st<"u"&&st!==null){tt[it]=st;break}}var at=et;return tt.visible===!0||tt.visible===!1?at=tt.visible:tt.visible==="auto"&&(at=Z>0),{size:pick$q(tt.size,1),color:pick$q(tt.color,"none"),frontFacing:Z>0,visible:at}},U={axes:{},bottom:F([m.bottom,m.top,m],P,N),top:F([m.top,m.bottom,m],E,B),left:F([m.left,m.right,m.side,m],T,X),right:F([m.right,m.left,m.side,m],O,W),back:F([m.back,m.front,m],I,D),front:F([m.front,m.back,m],C,L)};if(y.axisLabelPosition==="auto"){var z=function(Y,Z){return Y.visible!==Z.visible||Y.visible&&Z.visible&&Y.frontFacing!==Z.frontFacing},V=[];z(U.left,U.front)&&V.push({y:($+S)/2,x,z:k,xDir:{x:1,y:0,z:0}}),z(U.left,U.back)&&V.push({y:($+S)/2,x,z:A,xDir:{x:0,y:0,z:-1}}),z(U.right,U.front)&&V.push({y:($+S)/2,x:b,z:k,xDir:{x:0,y:0,z:1}}),z(U.right,U.back)&&V.push({y:($+S)/2,x:b,z:A,xDir:{x:-1,y:0,z:0}});var j=[];z(U.bottom,U.front)&&j.push({x:(x+b)/2,y:S,z:k,xDir:{x:1,y:0,z:0}}),z(U.bottom,U.back)&&j.push({x:(x+b)/2,y:S,z:A,xDir:{x:-1,y:0,z:0}});var K=[];z(U.top,U.front)&&K.push({x:(x+b)/2,y:$,z:k,xDir:{x:1,y:0,z:0}}),z(U.top,U.back)&&K.push({x:(x+b)/2,y:$,z:A,xDir:{x:-1,y:0,z:0}});var ot=[];z(U.bottom,U.left)&&ot.push({z:(k+A)/2,y:S,x,xDir:{x:0,y:0,z:-1}}),z(U.bottom,U.right)&&ot.push({z:(k+A)/2,y:S,x:b,xDir:{x:0,y:0,z:1}});var q=[];z(U.top,U.left)&&q.push({z:(k+A)/2,y:$,x,xDir:{x:0,y:0,z:-1}}),z(U.top,U.right)&&q.push({z:(k+A)/2,y:$,x:b,xDir:{x:0,y:0,z:1}});var J=function(Y,Z,et){if(Y.length===0)return null;if(Y.length===1)return Y[0];for(var Q=perspective$4(Y,v,!1),tt=0,rt=1;rt<Q.length;rt++)(et*Q[rt][Z]>et*Q[tt][Z]||et*Q[rt][Z]===et*Q[tt][Z]&&Q[rt].z<Q[tt].z)&&(tt=rt);return Y[tt]};U.axes={y:{left:J(V,"x",-1),right:J(V,"x",1)},x:{top:J(K,"y",-1),bottom:J(j,"y",1)},z:{top:J(q,"y",-1),bottom:J(ot,"y",1)}}}else U.axes={y:{left:{x,z:k,xDir:{x:1,y:0,z:0}},right:{x:b,z:k,xDir:{x:0,y:0,z:1}}},x:{top:{y:$,z:k,xDir:{x:1,y:0,z:0}},bottom:{y:S,z:k,xDir:{x:1,y:0,z:0}}},z:{top:{x:X?b:x,y:$,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:X?b:x,y:S,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return U},g.prototype.getScale=function(v){var y=this.chart,m=y.plotLeft,x=y.plotWidth+m,b=y.plotTop,$=y.plotHeight+b,S=m+y.plotWidth/2,k=b+y.plotHeight/2,A={minX:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,minY:Number.MAX_VALUE,maxY:-Number.MAX_VALUE},M,P=1;return M=[{x:m,y:b,z:0},{x:m,y:b,z:v}],[0,1].forEach(function(E){M.push({x,y:M[E].y,z:M[E].z})}),[0,1,2,3].forEach(function(E){M.push({x:M[E].x,y:$,z:M[E].z})}),M=perspective$4(M,y,!1),M.forEach(function(E){A.minX=Math.min(A.minX,E.x),A.maxX=Math.max(A.maxX,E.x),A.minY=Math.min(A.minY,E.y),A.maxY=Math.max(A.maxY,E.y)}),m>A.minX&&(P=Math.min(P,1-Math.abs((m+S)/(A.minX+S))%1)),x<A.maxX&&(P=Math.min(P,(x-S)/(A.maxX-S))),b>A.minY&&(A.minY<0?P=Math.min(P,(b+k)/(-A.minY+b+k)):P=Math.min(P,1-(b+k)/(A.minY+k)%1)),$<A.maxY&&(P=Math.min(P,Math.abs(($-k)/(A.maxY-k)))),P},g}();o.Composition=e,o.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};function t(g,v){var y=g.prototype,m=v.prototype;y.is3d=function(){return!!(this.options.chart.options3d&&this.options.chart.options3d.enabled)},y.propsRequireDirtyBox.push("chart.options3d"),y.propsRequireUpdateSeries.push("chart.options3d"),m.matrixSetter=function(){var x;if(this.pos<1&&(isArray$3(this.start)||isArray$3(this.end))){var b=this.start||[1,0,0,1,0,0],$=this.end||[1,0,0,1,0,0];x=[];for(var S=0;S<6;S++)x.push(this.pos*$[S]+(1-this.pos)*b[S])}else x=this.end;this.elem.attr(this.prop,x,null,!0)},merge$n(!0,genericDefaultOptions,o.defaultOptions),addEvent$h(g,"init",d),addEvent$h(g,"addSeries",r),addEvent$h(g,"afterDrawChartBox",n),addEvent$h(g,"afterGetContainer",s),addEvent$h(g,"afterInit",a),addEvent$h(g,"afterSetChartSize",l),addEvent$h(g,"beforeRedraw",h),addEvent$h(g,"beforeRender",c),wrap$5(y,"isInsidePlot",f),wrap$5(g,"renderSeries",p),wrap$5(g,"setClassName",u)}o.compose=t;function r(g){this.is3d()&&g.options.type==="scatter"&&(g.options.type="scatter3d")}function n(){if(this.chart3d&&this.is3d()){var g=this,v=g.renderer,y=g.options.chart.options3d,m=g.chart3d.get3dFrame(),x=g.plotLeft,b=g.plotLeft+g.plotWidth,$=g.plotTop,S=g.plotTop+g.plotHeight,k=0,A=y.depth,M=x-(m.left.visible?m.left.size:0),P=b+(m.right.visible?m.right.size:0),E=$-(m.top.visible?m.top.size:0),T=S+(m.bottom.visible?m.bottom.size:0),O=k-(m.front.visible?m.front.size:0),C=A+(m.back.visible?m.back.size:0),I=g.hasRendered?"animate":"attr";g.chart3d.frame3d=m,g.frameShapes||(g.frameShapes={bottom:v.polyhedron().add(),top:v.polyhedron().add(),left:v.polyhedron().add(),right:v.polyhedron().add(),back:v.polyhedron().add(),front:v.polyhedron().add()}),g.frameShapes.bottom[I]({class:"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:m.bottom.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.bottom.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x:P,y:T,z:O},{x:P,y:T,z:C},{x:M,y:T,z:C}],enabled:m.bottom.visible},{fill:color$5(m.bottom.color).brighten(.1).get(),vertexes:[{x,y:S,z:A},{x:b,y:S,z:A},{x:b,y:S,z:k},{x,y:S,z:k}],enabled:m.bottom.visible},{fill:color$5(m.bottom.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:O},{x:M,y:T,z:C},{x,y:S,z:A},{x,y:S,z:k}],enabled:m.bottom.visible&&!m.left.visible},{fill:color$5(m.bottom.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:C},{x:P,y:T,z:O},{x:b,y:S,z:k},{x:b,y:S,z:A}],enabled:m.bottom.visible&&!m.right.visible},{fill:color$5(m.bottom.color).get(),vertexes:[{x:P,y:T,z:O},{x:M,y:T,z:O},{x,y:S,z:k},{x:b,y:S,z:k}],enabled:m.bottom.visible&&!m.front.visible},{fill:color$5(m.bottom.color).get(),vertexes:[{x:M,y:T,z:C},{x:P,y:T,z:C},{x:b,y:S,z:A},{x,y:S,z:A}],enabled:m.bottom.visible&&!m.back.visible}]}),g.frameShapes.top[I]({class:"highcharts-3d-frame highcharts-3d-frame-top",zIndex:m.top.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.top.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x:P,y:E,z:C},{x:P,y:E,z:O},{x:M,y:E,z:O}],enabled:m.top.visible},{fill:color$5(m.top.color).brighten(.1).get(),vertexes:[{x,y:$,z:k},{x:b,y:$,z:k},{x:b,y:$,z:A},{x,y:$,z:A}],enabled:m.top.visible},{fill:color$5(m.top.color).brighten(-.1).get(),vertexes:[{x:M,y:E,z:C},{x:M,y:E,z:O},{x,y:$,z:k},{x,y:$,z:A}],enabled:m.top.visible&&!m.left.visible},{fill:color$5(m.top.color).brighten(-.1).get(),vertexes:[{x:P,y:E,z:O},{x:P,y:E,z:C},{x:b,y:$,z:A},{x:b,y:$,z:k}],enabled:m.top.visible&&!m.right.visible},{fill:color$5(m.top.color).get(),vertexes:[{x:M,y:E,z:O},{x:P,y:E,z:O},{x:b,y:$,z:k},{x,y:$,z:k}],enabled:m.top.visible&&!m.front.visible},{fill:color$5(m.top.color).get(),vertexes:[{x:P,y:E,z:C},{x:M,y:E,z:C},{x,y:$,z:A},{x:b,y:$,z:A}],enabled:m.top.visible&&!m.back.visible}]}),g.frameShapes.left[I]({class:"highcharts-3d-frame highcharts-3d-frame-left",zIndex:m.left.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.left.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x,y:S,z:k},{x,y:S,z:A},{x:M,y:T,z:C}],enabled:m.left.visible&&!m.bottom.visible},{fill:color$5(m.left.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x,y:$,z:A},{x,y:$,z:k},{x:M,y:E,z:O}],enabled:m.left.visible&&!m.top.visible},{fill:color$5(m.left.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:C},{x:M,y:E,z:C},{x:M,y:E,z:O},{x:M,y:T,z:O}],enabled:m.left.visible},{fill:color$5(m.left.color).brighten(-.1).get(),vertexes:[{x,y:$,z:A},{x,y:S,z:A},{x,y:S,z:k},{x,y:$,z:k}],enabled:m.left.visible},{fill:color$5(m.left.color).get(),vertexes:[{x:M,y:T,z:O},{x:M,y:E,z:O},{x,y:$,z:k},{x,y:S,z:k}],enabled:m.left.visible&&!m.front.visible},{fill:color$5(m.left.color).get(),vertexes:[{x:M,y:E,z:C},{x:M,y:T,z:C},{x,y:S,z:A},{x,y:$,z:A}],enabled:m.left.visible&&!m.back.visible}]}),g.frameShapes.right[I]({class:"highcharts-3d-frame highcharts-3d-frame-right",zIndex:m.right.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.right.color).brighten(.1).get(),vertexes:[{x:P,y:T,z:C},{x:b,y:S,z:A},{x:b,y:S,z:k},{x:P,y:T,z:O}],enabled:m.right.visible&&!m.bottom.visible},{fill:color$5(m.right.color).brighten(.1).get(),vertexes:[{x:P,y:E,z:O},{x:b,y:$,z:k},{x:b,y:$,z:A},{x:P,y:E,z:C}],enabled:m.right.visible&&!m.top.visible},{fill:color$5(m.right.color).brighten(-.1).get(),vertexes:[{x:b,y:$,z:k},{x:b,y:S,z:k},{x:b,y:S,z:A},{x:b,y:$,z:A}],enabled:m.right.visible},{fill:color$5(m.right.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:O},{x:P,y:E,z:O},{x:P,y:E,z:C},{x:P,y:T,z:C}],enabled:m.right.visible},{fill:color$5(m.right.color).get(),vertexes:[{x:P,y:E,z:O},{x:P,y:T,z:O},{x:b,y:S,z:k},{x:b,y:$,z:k}],enabled:m.right.visible&&!m.front.visible},{fill:color$5(m.right.color).get(),vertexes:[{x:P,y:T,z:C},{x:P,y:E,z:C},{x:b,y:$,z:A},{x:b,y:S,z:A}],enabled:m.right.visible&&!m.back.visible}]}),g.frameShapes.back[I]({class:"highcharts-3d-frame highcharts-3d-frame-back",zIndex:m.back.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.back.color).brighten(.1).get(),vertexes:[{x:P,y:T,z:C},{x:M,y:T,z:C},{x,y:S,z:A},{x:b,y:S,z:A}],enabled:m.back.visible&&!m.bottom.visible},{fill:color$5(m.back.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x:P,y:E,z:C},{x:b,y:$,z:A},{x,y:$,z:A}],enabled:m.back.visible&&!m.top.visible},{fill:color$5(m.back.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:C},{x:M,y:E,z:C},{x,y:$,z:A},{x,y:S,z:A}],enabled:m.back.visible&&!m.left.visible},{fill:color$5(m.back.color).brighten(-.1).get(),vertexes:[{x:P,y:E,z:C},{x:P,y:T,z:C},{x:b,y:S,z:A},{x:b,y:$,z:A}],enabled:m.back.visible&&!m.right.visible},{fill:color$5(m.back.color).get(),vertexes:[{x,y:$,z:A},{x:b,y:$,z:A},{x:b,y:S,z:A},{x,y:S,z:A}],enabled:m.back.visible},{fill:color$5(m.back.color).get(),vertexes:[{x:M,y:T,z:C},{x:P,y:T,z:C},{x:P,y:E,z:C},{x:M,y:E,z:C}],enabled:m.back.visible}]}),g.frameShapes.front[I]({class:"highcharts-3d-frame highcharts-3d-frame-front",zIndex:m.front.frontFacing?-1e3:1e3,faces:[{fill:color$5(m.front.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x:P,y:T,z:O},{x:b,y:S,z:k},{x,y:S,z:k}],enabled:m.front.visible&&!m.bottom.visible},{fill:color$5(m.front.color).brighten(.1).get(),vertexes:[{x:P,y:E,z:O},{x:M,y:E,z:O},{x,y:$,z:k},{x:b,y:$,z:k}],enabled:m.front.visible&&!m.top.visible},{fill:color$5(m.front.color).brighten(-.1).get(),vertexes:[{x:M,y:E,z:O},{x:M,y:T,z:O},{x,y:S,z:k},{x,y:$,z:k}],enabled:m.front.visible&&!m.left.visible},{fill:color$5(m.front.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:O},{x:P,y:E,z:O},{x:b,y:$,z:k},{x:b,y:S,z:k}],enabled:m.front.visible&&!m.right.visible},{fill:color$5(m.front.color).get(),vertexes:[{x:b,y:$,z:k},{x,y:$,z:k},{x,y:S,z:k},{x:b,y:S,z:k}],enabled:m.front.visible},{fill:color$5(m.front.color).get(),vertexes:[{x:P,y:T,z:O},{x:M,y:T,z:O},{x:M,y:E,z:O},{x:P,y:E,z:O}],enabled:m.front.visible}]})}}function s(){this.styledMode&&(this.renderer.definition({tagName:"style",textContent:`.highcharts-3d-top{filter: url(#highcharts-brighter)}
.highcharts-3d-side{filter: url(#highcharts-darker)}
`}),[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(g){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+g.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:g.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:g.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:g.slope}}]}]})},this))}function a(){var g=this.options;this.is3d()&&(g.series||[]).forEach(function(v){var y=v.type||g.chart.type||g.chart.defaultSeriesType;y==="scatter"&&(v.type="scatter3d")})}function l(){var g=this,v=g.options.chart.options3d;if(g.chart3d&&g.is3d()){v&&(v.alpha=v.alpha%360+(v.alpha>=0?0:360),v.beta=v.beta%360+(v.beta>=0?0:360));var y=g.inverted,m=g.clipBox,x=g.margin,b=y?"y":"x",$=y?"x":"y",S=y?"height":"width",k=y?"width":"height";m[b]=-(x[3]||0),m[$]=-(x[0]||0),m[S]=g.chartWidth+(x[3]||0)+(x[1]||0),m[k]=g.chartHeight+(x[0]||0)+(x[2]||0),g.scale3d=1,v.fitToPlot===!0&&(g.scale3d=g.chart3d.getScale(v.depth)),g.chart3d.frame3d=g.chart3d.get3dFrame()}}function h(){this.is3d()&&(this.isDirtyBox=!0)}function c(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function d(){this.chart3d||(this.chart3d=new e(this))}function f(g){return this.is3d()||g.apply(this,[].slice.call(arguments,1))}function p(g){var v,y=this.series.length;if(this.is3d())for(;y--;)v=this.series[y],v.translate(),v.render();else g.call(this)}function u(g){g.apply(this,[].slice.call(arguments,1)),this.is3d()&&(this.container.className+=" highcharts-3d-chart")}})(Chart3D||(Chart3D={}));const Chart3D$1=Chart3D;var __extends$n=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),addEvent$g=Utilities.addEvent,merge$m=Utilities.merge,pick$p=Utilities.pick,splat$2=Utilities.splat,ZChart=function(){function o(){}return o.compose=function(e){addEvent$g(e,"afterGetAxes",o.onAfterGetAxes);var t=e.prototype;t.addZAxis=o.wrapAddZAxis,t.collectionsWithInit.zAxis=[t.addZAxis],t.collectionsWithUpdate.push("zAxis")},o.onAfterGetAxes=function(){var e=this,t=this.options,r=t.zAxis=splat$2(t.zAxis||{});e.is3d()&&(e.zAxis=[],r.forEach(function(n,s){n.index=s,n.isX=!0,e.addZAxis(n).setScale()}))},o.wrapAddZAxis=function(e){return new ZAxis(this,e)},o}(),ZAxis=function(o){__extends$n(e,o);function e(t,r){var n=o.call(this,t,r)||this;return n.isZAxis=!0,n}return e.prototype.getSeriesExtremes=function(){var t=this,r=t.chart;t.hasVisibleSeries=!1,t.dataMin=t.dataMax=t.ignoreMinPadding=t.ignoreMaxPadding=void 0,t.stacking&&t.stacking.buildStacks(),t.series.forEach(function(n){if(n.visible||!r.options.chart.ignoreHiddenSeries){var s=n.options,a=void 0,l=s.threshold;t.hasVisibleSeries=!0,t.positiveValuesOnly&&l<=0&&(l=void 0),a=n.zData,a.length&&(t.dataMin=Math.min(pick$p(t.dataMin,a[0]),Math.min.apply(null,a)),t.dataMax=Math.max(pick$p(t.dataMax,a[0]),Math.max.apply(null,a)))}})},e.prototype.setAxisSize=function(){var t=this,r=t.chart;o.prototype.setAxisSize.call(this),t.width=t.len=r.options.chart.options3d&&r.options.chart.options3d.depth||0,t.right=r.chartWidth-t.width-t.left},e.prototype.setOptions=function(t){t=merge$m({offset:0,lineWidth:0},t),this.isZAxis=!0,o.prototype.setOptions.call(this,t),this.coll="zAxis"},e.ZChartComposition=ZChart,e}(Axis),addEvent$f=Utilities.addEvent,extend$q=Utilities.extend,wrap$4=Utilities.wrap,Tick3D=function(){function o(){}return o.compose=function(e){addEvent$f(e,"afterGetLabelPosition",o.onAfterGetLabelPosition);var t=e.prototype;wrap$4(t,"getMarkPath",o.wrapGetMarkPath)},o.onAfterGetLabelPosition=function(e){var t=this.axis.axis3D;t&&extend$q(e.pos,t.fix3dPosition(e.pos))},o.wrapGetMarkPath=function(e){this.axis.chart;var t=this.axis.axis3D,r=e.apply(this,[].slice.call(arguments,1));if(t){var n=r[0],s=r[1];if(n[0]==="M"&&s[0]==="L"){var a=[t.fix3dPosition({x:n[1],y:n[2],z:0}),t.fix3dPosition({x:s[1],y:s[2],z:0})];return this.axis.chart.renderer.toLineSegments(a)}}return r},o}(),deg2rad$1=H.deg2rad,perspective$3=mathModule.perspective,perspective3D=mathModule.perspective3D,shapeArea=mathModule.shapeArea,addEvent$e=Utilities.addEvent,merge$l=Utilities.merge,pick$o=Utilities.pick,wrap$3=Utilities.wrap,Axis3DAdditions=function(){function o(e){this.axis=e}return o.prototype.fix3dPosition=function(e,t){var r=this,n=r.axis,s=n.chart;if(n.coll==="colorAxis"||!s.chart3d||!s.is3d())return e;var a=deg2rad$1*s.options.chart.options3d.alpha,l=deg2rad$1*s.options.chart.options3d.beta,h=pick$o(t&&n.options.title.position3d,n.options.labels.position3d),c=pick$o(t&&n.options.title.skew3d,n.options.labels.skew3d),d=s.chart3d.frame3d,f=s.plotLeft,p=s.plotWidth+f,u=s.plotTop,g=s.plotHeight+u,v=0,y=0,m,x={x:0,y:1,z:0},b=!1;if(e=n.axis3D.swapZ({x:e.x,y:e.y,z:0}),n.isZAxis)if(n.opposite){if(d.axes.z.top===null)return{};y=e.y-u,e.x=d.axes.z.top.x,e.y=d.axes.z.top.y,m=d.axes.z.top.xDir,b=!d.top.frontFacing}else{if(d.axes.z.bottom===null)return{};y=e.y-g,e.x=d.axes.z.bottom.x,e.y=d.axes.z.bottom.y,m=d.axes.z.bottom.xDir,b=!d.bottom.frontFacing}else if(n.horiz)if(n.opposite){if(d.axes.x.top===null)return{};y=e.y-u,e.y=d.axes.x.top.y,e.z=d.axes.x.top.z,m=d.axes.x.top.xDir,b=!d.top.frontFacing}else{if(d.axes.x.bottom===null)return{};y=e.y-g,e.y=d.axes.x.bottom.y,e.z=d.axes.x.bottom.z,m=d.axes.x.bottom.xDir,b=!d.bottom.frontFacing}else if(n.opposite){if(d.axes.y.right===null)return{};v=e.x-p,e.x=d.axes.y.right.x,e.z=d.axes.y.right.z,m=d.axes.y.right.xDir,m={x:m.z,y:m.y,z:-m.x}}else{if(d.axes.y.left===null)return{};v=e.x-f,e.x=d.axes.y.left.x,e.z=d.axes.y.left.z,m=d.axes.y.left.xDir}if(h!=="chart")if(h==="flap")if(!n.horiz)m={x:Math.cos(l),y:0,z:Math.sin(l)};else{var $=Math.sin(a),S=Math.cos(a);n.opposite&&($=-$),b&&($=-$),x={x:m.z*$,y:S,z:-m.x*$}}else if(h==="ortho")if(!n.horiz)m={x:Math.cos(l),y:0,z:Math.sin(l)};else{var k=Math.sin(a),A=Math.cos(a),M=Math.sin(l),P=Math.cos(l),E={x:M*A,y:-k,z:-A*P};x={x:m.y*E.z-m.z*E.y,y:m.z*E.x-m.x*E.z,z:m.x*E.y-m.y*E.x};var T=1/Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z);b&&(T=-T),x={x:T*x.x,y:T*x.y,z:T*x.z}}else n.horiz?x={x:Math.sin(l)*Math.sin(a),y:Math.cos(a),z:-Math.cos(l)*Math.sin(a)}:m={x:Math.cos(l),y:0,z:Math.sin(l)};e.x+=v*m.x+y*x.x,e.y+=v*m.y+y*x.y,e.z+=v*m.z+y*x.z;var O=perspective$3([e],n.chart)[0];if(c){var C=shapeArea(perspective$3([e,{x:e.x+m.x,y:e.y+m.y,z:e.z+m.z},{x:e.x+x.x,y:e.y+x.y,z:e.z+x.z}],n.chart))<0;C&&(m={x:-m.x,y:-m.y,z:-m.z});var I=perspective$3([{x:e.x,y:e.y,z:e.z},{x:e.x+m.x,y:e.y+m.y,z:e.z+m.z},{x:e.x+x.x,y:e.y+x.y,z:e.z+x.z}],n.chart);O.matrix=[I[1].x-I[0].x,I[1].y-I[0].y,I[2].x-I[0].x,I[2].y-I[0].y,O.x,O.y],O.matrix[4]-=O.x*O.matrix[0]+O.y*O.matrix[2],O.matrix[5]-=O.x*O.matrix[1]+O.y*O.matrix[3]}return O},o.prototype.swapZ=function(e,t){var r=this.axis;if(r.isZAxis){var n=t?0:r.chart.plotLeft;return{x:n+e.z,y:e.y,z:e.x-n}}return e},o}(),Axis3D=function(){function o(){}return o.compose=function(e){merge$l(!0,e.defaultOptions,o.defaultOptions),e.keepProps.push("axis3D"),addEvent$e(e,"init",o.onInit),addEvent$e(e,"afterSetOptions",o.onAfterSetOptions),addEvent$e(e,"drawCrosshair",o.onDrawCrosshair);var t=e.prototype;wrap$3(t,"getLinePath",o.wrapGetLinePath),wrap$3(t,"getPlotBandPath",o.wrapGetPlotBandPath),wrap$3(t,"getPlotLinePath",o.wrapGetPlotLinePath),wrap$3(t,"getSlotWidth",o.wrapGetSlotWidth),wrap$3(t,"getTitlePosition",o.wrapGetTitlePosition),Tick3D.compose(Tick)},o.onAfterSetOptions=function(){var e=this,t=e.chart,r=e.options;t.is3d&&t.is3d()&&e.coll!=="colorAxis"&&(r.tickWidth=pick$o(r.tickWidth,0),r.gridLineWidth=pick$o(r.gridLineWidth,1))},o.onDrawCrosshair=function(e){var t=this;t.chart.is3d()&&t.coll!=="colorAxis"&&e.point&&(e.point.crosshairPos=t.isXAxis?e.point.axisXpos:t.len-e.point.axisYpos)},o.onInit=function(){var e=this;e.axis3D||(e.axis3D=new Axis3DAdditions(e))},o.wrapGetLinePath=function(e){var t=this;return!t.chart.is3d()||t.coll==="colorAxis"?e.apply(t,[].slice.call(arguments,1)):[]},o.wrapGetPlotBandPath=function(e){if(!this.chart.is3d()||this.coll==="colorAxis")return e.apply(this,[].slice.call(arguments,1));var t=arguments,r=t[1],n=t[2],s=[],a=this.getPlotLinePath({value:r}),l=this.getPlotLinePath({value:n});if(a&&l)for(var h=0;h<a.length;h+=2){var c=a[h],d=a[h+1],f=l[h],p=l[h+1];c[0]==="M"&&d[0]==="L"&&f[0]==="M"&&p[0]==="L"&&s.push(c,d,p,["L",f[1],f[2]],["Z"])}return s},o.wrapGetPlotLinePath=function(e){var t=this,r=t.axis3D,n=t.chart,s=e.apply(t,[].slice.call(arguments,1));if(t.coll==="colorAxis"||!n.chart3d||!n.is3d()||s===null)return s;var a=n.options.chart.options3d,l=t.isZAxis?n.plotWidth:a.depth,h=n.chart3d.frame3d,c=s[0],d=s[1],f,p=[];return c[0]==="M"&&d[0]==="L"&&(f=[r.swapZ({x:c[1],y:c[2],z:0}),r.swapZ({x:c[1],y:c[2],z:l}),r.swapZ({x:d[1],y:d[2],z:0}),r.swapZ({x:d[1],y:d[2],z:l})],this.horiz?this.isZAxis?(h.left.visible&&p.push(f[0],f[2]),h.right.visible&&p.push(f[1],f[3]),h.top.visible&&p.push(f[0],f[1]),h.bottom.visible&&p.push(f[2],f[3])):(h.front.visible&&p.push(f[0],f[2]),h.back.visible&&p.push(f[1],f[3]),h.top.visible&&p.push(f[0],f[1]),h.bottom.visible&&p.push(f[2],f[3])):(h.front.visible&&p.push(f[0],f[2]),h.back.visible&&p.push(f[1],f[3]),h.left.visible&&p.push(f[0],f[1]),h.right.visible&&p.push(f[2],f[3])),p=perspective$3(p,this.chart,!1)),n.renderer.toLineSegments(p)},o.wrapGetSlotWidth=function(e,t){var r=this,n=r.chart,s=r.ticks,a=r.gridGroup;if(r.categories&&n.frameShapes&&n.is3d()&&a&&t&&t.label){var l=a.element.childNodes[0].getBBox(),h=n.frameShapes.left.getBBox(),c=n.options.chart.options3d,d={x:n.plotWidth/2,y:n.plotHeight/2,z:c.depth/2,vd:pick$o(c.depth,1)*pick$o(c.viewDistance,0)},f=t.pos,p=s[f-1],u=s[f+1],g=void 0,v=void 0,y=void 0;return f!==0&&p&&p.label&&p.label.xy&&(v=perspective3D({x:p.label.xy.x,y:p.label.xy.y,z:null},d,d.vd)),u&&u.label&&u.label.xy&&(y=perspective3D({x:u.label.xy.x,y:u.label.xy.y,z:null},d,d.vd)),g={x:t.label.xy.x,y:t.label.xy.y,z:null},g=perspective3D(g,d,d.vd),Math.abs(v?g.x-v.x:y?y.x-g.x:l.x-h.x)}return e.apply(r,[].slice.call(arguments,1))},o.wrapGetTitlePosition=function(e){var t=e.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(t,!0):t},o.defaultOptions={labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}},o}(),__extends$m=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),perspective$2=mathModule.perspective,addEvent$d=Utilities.addEvent,extend$p=Utilities.extend,merge$k=Utilities.merge,pick$n=Utilities.pick,isNumber$9=Utilities.isNumber,Series3D=function(o){__extends$m(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.prototype.translate=function(){o.prototype.translate.apply(this,arguments),this.chart.is3d()&&this.translate3dPoints()},e.prototype.translate3dPoints=function(){var t=this,r=t.options,n=t.chart,s=pick$n(t.zAxis,n.options.zAxis[0]),a=[],l,h,c,d,f,p=[],u=r.stacking?isNumber$9(r.stack)?r.stack:0:t.index||0;for(t.zPadding=u*(r.depth||0+(r.groupZPadding||1)),f=0;f<t.data.length;f++)l=t.data[f],s&&s.translate?(d=s.logarithmic&&s.val2lin?s.val2lin(l.z):l.z,l.plotZ=s.translate(d),l.isInside=l.isInside?d>=s.min&&d<=s.max:!1):l.plotZ=t.zPadding,l.axisXpos=l.plotX,l.axisYpos=l.plotY,l.axisZpos=l.plotZ,a.push({x:l.plotX,y:l.plotY,z:l.plotZ}),p.push(l.plotX||0);for(t.rawPointsX=p,h=perspective$2(a,n,!0),f=0;f<t.data.length;f++)l=t.data[f],c=h[f],l.plotX=c.x,l.plotY=c.y,l.plotZ=c.z},e.defaultOptions=merge$k(Series$e.defaultOptions),e}(Series$e);addEvent$d(Series$e,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});extend$p(Series$e.prototype,{translate3dPoints:Series3D.prototype.translate3dPoints});var columnProto$1=ColumnSeries$h.prototype,svg$1=H.svg,perspective$1=mathModule.perspective,addEvent$c=Utilities.addEvent,pick$m=Utilities.pick,wrap$2=Utilities.wrap;function retrieveStacks(o,e){var t=o.series,r={totalStacks:0},n,s=1;return t.forEach(function(a){n=pick$m(a.options.stack,e?0:t.length-1-a.index),r[n]?r[n].series.push(a):(r[n]={series:[a],position:s},s++)}),r.totalStacks=s+1,r}wrap$2(columnProto$1,"translate",function(o){o.apply(this,[].slice.call(arguments,1)),this.chart.is3d()&&this.translate3dShapes()});wrap$2(Series$e.prototype,"justifyDataLabel",function(o){return arguments[2].outside3dPlot?!1:o.apply(this,[].slice.call(arguments,1))});columnProto$1.translate3dPoints=function(){};columnProto$1.translate3dShapes=function(){var o=this,e=o.chart,t=o.options,r=t.depth,n=t.stacking?t.stack||0:o.index,s=n*(r+(t.groupZPadding||1)),a=o.borderWidth%2?.5:0,l;e.inverted&&!o.yAxis.reversed&&(a*=-1),t.grouping!==!1&&(s=0),s+=t.groupZPadding||1,o.data.forEach(function(h){if(h.outside3dPlot=null,h.y!==null){var c=h.shapeArgs,d=h.tooltipPos,f=[["x","width"],["y","height"]],p;f.forEach(function(u){if(p=c[u[0]]-a,p<0&&(c[u[1]]+=c[u[0]]+a,c[u[0]]=-a,p=0),p+c[u[1]]>o[u[0]+"Axis"].len&&c[u[1]]!==0&&(c[u[1]]=o[u[0]+"Axis"].len-c[u[0]]),c[u[1]]!==0&&(c[u[0]]>=o[u[0]+"Axis"].len||c[u[0]]+c[u[1]]<=a)){for(var g in c)c[g]=g==="y"?-9999:0;h.outside3dPlot=!0}}),h.shapeType==="rect"&&(h.shapeType="cuboid"),c.z=s,c.depth=r,c.insidePlotArea=!0,l={x:c.x+c.width/2,y:c.y,z:s+r/2},e.inverted&&(l.x=c.height,l.y=h.clientX),h.plot3d=perspective$1([l],e,!0,!1)[0],d=perspective$1([{x:d[0],y:d[1],z:s+r/2}],e,!0,!1)[0],h.tooltipPos=[d.x,d.y]}}),o.z=s};wrap$2(columnProto$1,"animate",function(o){if(!this.chart.is3d())o.apply(this,[].slice.call(arguments,1));else{var e=arguments,t=e[1],r=this.yAxis,n=this,s=this.yAxis.reversed;svg$1&&(t?n.data.forEach(function(a){a.y!==null&&(a.height=a.shapeArgs.height,a.shapey=a.shapeArgs.y,a.shapeArgs.height=1,s||(a.stackY?a.shapeArgs.y=a.plotY+r.translate(a.stackY):a.shapeArgs.y=a.plotY+(a.negative?-a.height:a.height)))}):(n.data.forEach(function(a){a.y!==null&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,a.graphic&&a.graphic[a.outside3dPlot?"attr":"animate"](a.shapeArgs,n.options.animation))}),this.drawDataLabels()))}});wrap$2(columnProto$1,"plotGroup",function(o,e,t,r,n,s){return e!=="dataLabelsGroup"&&this.chart.is3d()&&(this[e]&&delete this[e],s&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(s)),this[e]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[e].survive=!0,(e==="group"||e==="markerGroup")&&(arguments[3]="visible"))),o.apply(this,Array.prototype.slice.call(arguments,1))});wrap$2(columnProto$1,"setVisible",function(o,e){var t=this;t.chart.is3d()&&t.data.forEach(function(r){r.visible=r.options.visible=e=typeof e>"u"?!pick$m(t.visible,r.visible):e,t.options.data[t.data.indexOf(r)]=r.options,r.graphic&&r.graphic.attr({visibility:e?"visible":"hidden"})}),o.apply(this,Array.prototype.slice.call(arguments,1))});addEvent$c(ColumnSeries$h,"afterInit",function(){if(this.chart.is3d()){var o=this,e=this.options,t=e.grouping,r=e.stacking,n=this.yAxis.options.reversedStacks,s=0;if(!(typeof t<"u"&&!t)){var a=retrieveStacks(this.chart,r),l=e.stack||0,h=void 0;for(h=0;h<a[l].series.length&&a[l].series[h]!==this;h++);s=10*(a.totalStacks-a[l].position)+(n?h:-h),this.xAxis.reversed||(s=a.totalStacks*10-s)}e.depth=e.depth||25,o.z=o.z||0,e.zIndex=s}});function pointAttribs(o){var e=o.apply(this,[].slice.call(arguments,1));return this.chart.is3d&&this.chart.is3d()&&(e.stroke=this.options.edgeColor||e.fill,e["stroke-width"]=pick$m(this.options.edgeWidth,1)),e}function setState(o,e,t){var r=this.chart.is3d&&this.chart.is3d();r&&(this.options.inactiveOtherPoints=!0),o.call(this,e,t),r&&(this.options.inactiveOtherPoints=!1)}function hasNewShapeType(o){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];return this.series.chart.is3d()?this.graphic&&this.graphic.element.nodeName!=="g":o.apply(this,e)}wrap$2(columnProto$1,"pointAttribs",pointAttribs);wrap$2(columnProto$1,"setState",setState);wrap$2(columnProto$1.pointClass.prototype,"hasNewShapeType",hasNewShapeType);if(SeriesRegistry$1.seriesTypes.columnRange){var columnRangeProto=SeriesRegistry$1.seriesTypes.columnrange.prototype;wrap$2(columnRangeProto,"pointAttribs",pointAttribs),wrap$2(columnRangeProto,"setState",setState),wrap$2(columnRangeProto.pointClass.prototype,"hasNewShapeType",hasNewShapeType),columnRangeProto.plotGroup=columnProto$1.plotGroup,columnRangeProto.setVisible=columnProto$1.setVisible}wrap$2(Series$e.prototype,"alignDataLabel",function(o,e,t,r,n){var s=this.chart;if(r.outside3dPlot=e.outside3dPlot,s.is3d()&&this.is("column")){var a=this,l=a.options,h=pick$m(r.inside,!!a.options.stacking),c=s.options.chart.options3d,d=e.pointWidth/2||0,f={x:n.x+d,y:n.y,z:a.z+l.depth/2};s.inverted&&(h&&(n.width=0,f.x+=e.shapeArgs.height/2),c.alpha>=90&&c.alpha<=270&&(f.y+=e.shapeArgs.width)),f=perspective$1([f],s,!0,!1)[0],n.x=f.x-d,n.y=e.outside3dPlot?-9e9:f.y}o.apply(this,[].slice.call(arguments,1))});wrap$2(StackItem$1.prototype,"getStackBox",function(o,e,t,r,n,s,a,l){var h=o.apply(this,[].slice.call(arguments,1));if(e.is3d()&&t.base){var c=+t.base.split(",")[0],d=e.series[c],f=e.options.chart.options3d;if(d&&d instanceof SeriesRegistry$1.seriesTypes.column){var p={x:h.x+(e.inverted?a:s/2),y:h.y,z:d.options.depth/2};e.inverted&&(h.width=0,f.alpha>=90&&f.alpha<=270&&(p.y+=s)),p=perspective$1([p],e,!0,!1)[0],h.x=p.x-s/2,h.y=p.y}}return h});var __extends$l=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),PiePoint$2=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,superHaloPath=PiePoint$2.prototype.haloPath,Pie3DPoint=function(o){__extends$l(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.series=void 0,t}return e.prototype.haloPath=function(){return this.series.chart.is3d()?[]:superHaloPath.apply(this,arguments)},e}(PiePoint$2),__extends$k=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),deg2rad=H.deg2rad,svg=H.svg,PieSeries$2=SeriesRegistry$1.seriesTypes.pie,extend$o=Utilities.extend,pick$l=Utilities.pick,Pie3DSeries=function(o){__extends$k(e,o);function e(){return o!==null&&o.apply(this,arguments)||this}return e.prototype.addPoint=function(){o.prototype.addPoint.apply(this,arguments),this.chart.is3d()&&this.update(this.userOptions,!0)},e.prototype.animate=function(t){if(!this.chart.is3d())o.prototype.animate.apply(this,arguments);else{var r=this.options.animation,n=void 0,s=this.center,a=this.group,l=this.markerGroup;svg&&(r===!0&&(r={}),t?(a.oldtranslateX=pick$l(a.oldtranslateX,a.translateX),a.oldtranslateY=pick$l(a.oldtranslateY,a.translateY),n={translateX:s[0],translateY:s[1],scaleX:.001,scaleY:.001},a.attr(n),l&&(l.attrSetters=a.attrSetters,l.attr(n))):(n={translateX:a.oldtranslateX,translateY:a.oldtranslateY,scaleX:1,scaleY:1},a.animate(n,r),l&&l.animate(n,r)))}},e.prototype.drawDataLabels=function(){if(this.chart.is3d()){var t=this,r=t.chart,n=r.options.chart.options3d;t.data.forEach(function(s){var a=s.shapeArgs,l=a.r,h=(a.alpha||n.alpha)*deg2rad,c=(a.beta||n.beta)*deg2rad,d=(a.start+a.end)/2,f=s.labelPosition,p=f.connectorPosition,u=-l*(1-Math.cos(h))*Math.sin(d),g=l*(Math.cos(c)-1)*Math.cos(d);[f.natural,p.breakAt,p.touchingSliceAt].forEach(function(v){v.x+=g,v.y+=u})})}o.prototype.drawDataLabels.apply(this,arguments)},e.prototype.pointAttribs=function(t){var r=o.prototype.pointAttribs.apply(this,arguments),n=this.options;return this.chart.is3d()&&!this.chart.styledMode&&(r.stroke=n.edgeColor||t.color||this.color,r["stroke-width"]=pick$l(n.edgeWidth,1)),r},e.prototype.translate=function(){if(o.prototype.translate.apply(this,arguments),!!this.chart.is3d()){var t=this,r=t.options,n=r.depth||0,s=t.chart.options.chart.options3d,a=s.alpha,l=s.beta,h=r.stacking?(r.stack||0)*n:t._i*n;h+=n/2,r.grouping!==!1&&(h=0),t.data.forEach(function(c){var d=c.shapeArgs,f;c.shapeType="arc3d",d.z=h,d.depth=n*.75,d.alpha=a,d.beta=l,d.center=t.center,f=(d.end+d.start)/2,c.slicedTranslation={translateX:Math.round(Math.cos(f)*r.slicedOffset*Math.cos(a*deg2rad)),translateY:Math.round(Math.sin(f)*r.slicedOffset*Math.cos(a*deg2rad))}})}},e}(PieSeries$2);extend$o(Pie3DSeries.prototype,{pointClass:Pie3DPoint});SeriesRegistry$1.seriesTypes.pie.prototype.pointClass.prototype.haloPath=Pie3DPoint.prototype.haloPath;SeriesRegistry$1.seriesTypes.pie=Pie3DSeries;var __extends$j=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$9=Utilities.defined,Scatter3DPoint=function(o){__extends$j(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.applyOptions=function(){return o.prototype.applyOptions.apply(this,arguments),defined$9(this.z)||(this.z=0),this},e}(ScatterSeries$4.prototype.pointClass),__extends$i=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),pointCameraDistance=mathModule.pointCameraDistance,extend$n=Utilities.extend,merge$j=Utilities.merge,Scatter3DSeries=function(o){__extends$i(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(t){var r=o.prototype.pointAttribs.apply(this,arguments);return this.chart.is3d()&&t&&(r.zIndex=pointCameraDistance(t,this.chart)),r},e.defaultOptions=merge$j(ScatterSeries$4.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}}),e}(ScatterSeries$4);extend$n(Scatter3DSeries.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:Scatter3DPoint});SeriesRegistry$1.registerSeriesType("scatter3d",Scatter3DSeries);var perspective=mathModule.perspective,_a$6=SeriesRegistry$1.seriesTypes,AreaSeriesClass=_a$6.area,LineSeriesClass=_a$6.line,pick$k=Utilities.pick,wrap$1=Utilities.wrap;wrap$1(AreaSeriesClass.prototype,"getGraphPath",function(o){var e=this,t=o.apply(e,[].slice.call(arguments,1));if(!e.chart.is3d())return t;var r=LineSeriesClass.prototype.getGraphPath,n=e.options,s=n.stacking,a,l=[],h=[],c,d=pick$k(n.connectNulls,s==="percent"),f=Math.round(e.yAxis.getThreshold(n.threshold)),p;if(e.rawPointsX)for(var u=0;u<e.points.length;u++)l.push({x:e.rawPointsX[u],y:n.stacking?e.points[u].yBottom:f,z:e.zPadding});return p=e.chart.options.chart.options3d,l=perspective(l,e.chart,!0).map(function(g){return{plotX:g.x,plotY:g.y,plotZ:g.z}}),e.group&&p&&p.depth&&p.beta&&(e.markerGroup&&(e.markerGroup.add(e.group),e.markerGroup.attr({translateX:0,translateY:0})),e.group.attr({zIndex:Math.max(1,p.beta>270||p.beta<90?p.depth-Math.round(e.zPadding||0):Math.round(e.zPadding||0))})),l.reversed=!0,a=r.call(e,l,!0,!0),a[0]&&a[0][0]==="M"&&(a[0]=["L",a[0][1],a[0][2]]),e.areaPath&&(c=e.areaPath.splice(0,e.areaPath.length/2).concat(a),c.xMap=e.areaPath.xMap,e.areaPath=c,r.call(e,h,!1,d)),t});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-3d
 * @requires highcharts
 *
 * 3D features for Highcharts JS
 *
 * License: www.highcharts.com/license
 */var G$3=H;SVGRenderer3D.compose(G$3.SVGRenderer);Chart3D$1.compose(G$3.Chart,G$3.Fx);ZAxis.ZChartComposition.compose(G$3.Chart);Axis3D.compose(G$3.Axis);var doc$2=H.doc,createElement$1=Utilities.createElement,discardElement$1=Utilities.discardElement,merge$i=Utilities.merge,objectEach$5=Utilities.objectEach;function ajax$1(o){var e=merge$i(!0,{url:!1,type:"get",dataType:"json",success:!1,error:!1,data:!1,headers:{}},o),t={json:"application/json",xml:"application/xml",text:"text/plain",octet:"application/octet-stream"},r=new XMLHttpRequest;function n(s,a){e.error&&e.error(s,a)}if(!e.url)return!1;r.open(e.type.toUpperCase(),e.url,!0),e.headers["Content-Type"]||r.setRequestHeader("Content-Type",t[e.dataType]||t.text),objectEach$5(e.headers,function(s,a){r.setRequestHeader(a,s)}),r.onreadystatechange=function(){var s;if(r.readyState===4){if(r.status===200){if(s=r.responseText,e.dataType==="json")try{s=JSON.parse(s)}catch(a){return n(r,a)}return e.success&&e.success(s)}n(r,r.responseText)}};try{e.data=JSON.stringify(e.data)}catch{}r.send(e.data||!0)}function getJSON(o,e){exports$2.ajax({url:o,success:e,dataType:"json",headers:{"Content-Type":"text/plain"}})}function post(o,e,t){var r=createElement$1("form",merge$i({method:"post",action:o,enctype:"multipart/form-data"},t),{display:"none"},doc$2.body);objectEach$5(e,function(n,s){createElement$1("input",{type:"hidden",name:s,value:n},null,r)}),r.submit(),discardElement$1(r)}var exports$2={ajax:ajax$1,getJSON,post},doc$1=H.doc,ajax=exports$2.ajax,seriesTypes$2=SeriesRegistry$1.seriesTypes,addEvent$b=Utilities.addEvent,defined$8=Utilities.defined,extend$m=Utilities.extend,fireEvent$5=Utilities.fireEvent,isNumber$8=Utilities.isNumber,merge$h=Utilities.merge,objectEach$4=Utilities.objectEach,pick$j=Utilities.pick,splat$1=Utilities.splat,Data=function(){function o(e,t,r){this.chart=void 0,this.chartOptions=void 0,this.firstRowAsNames=void 0,this.rawColumns=void 0,this.options=void 0,this.dateFormats={"YYYY/mm/dd":{regex:/^([0-9]{4})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{1,2})$/,parser:function(n){return n?Date.UTC(+n[1],n[2]-1,+n[3]):NaN}},"dd/mm/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(n){return n?Date.UTC(+n[3],n[2]-1,+n[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(n){return n?Date.UTC(+n[3],n[1]-1,+n[2]):NaN}},"dd/mm/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(n){if(!n)return NaN;var s=+n[3],a=new Date;return s>a.getFullYear()-2e3?s+=1900:s+=2e3,Date.UTC(s,n[2]-1,+n[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(n){return n?Date.UTC(+n[3]+2e3,n[1]-1,+n[2]):NaN}}},this.init(e,t,r)}return o.prototype.init=function(e,t,r){var n=e.decimalPoint,s;t&&(this.chartOptions=t),r&&(this.chart=r),n!=="."&&n!==","&&(n=void 0),this.options=e,this.columns=e.columns||this.rowsToColumns(e.rows)||[],this.firstRowAsNames=pick$j(e.firstRowAsNames,this.firstRowAsNames,!0),this.decimalRegex=n&&new RegExp("^(-?[0-9]+)"+n+"([0-9]+)$"),this.rawColumns=[],this.columns.length&&(this.dataFound(),s=!0),this.hasURLOption(e)&&(clearTimeout(this.liveDataTimeout),s=!1),s||(s=this.fetchLiveData()),s||(s=!!this.parseCSV().length),s||(s=!!this.parseTable().length),s||(s=this.parseGoogleSpreadsheet()),!s&&e.afterComplete&&e.afterComplete()},o.prototype.hasURLOption=function(e){return!!(e&&(e.rowsURL||e.csvURL||e.columnsURL))},o.prototype.getColumnDistribution=function(){var e=this.chartOptions,t=this.options,r=[],n=function(u){return(seriesTypes$2[u||"line"].prototype.pointArrayMap||[0]).length},s=function(u){return seriesTypes$2[u||"line"].prototype.pointArrayMap},a=e&&e.chart&&e.chart.type,l=[],h=[],c=0,d=t&&t.seriesMapping||e&&e.series&&e.series.map(function(){return{x:0}})||[],f;(e&&e.series||[]).forEach(function(u){l.push(n(u.type||a))}),d.forEach(function(u){r.push(u.x||0)}),r.length===0&&r.push(0),d.forEach(function(u){var g=new SeriesBuilder,v=l[c]||n(a),y=e&&e.series||[],m=y[c]||{},x=s(m.type||a),b=x||["y"];for((defined$8(u.x)||m.isCartesian||!x)&&g.addColumnReader(u.x,"x"),objectEach$4(u,function($,S){S!=="x"&&g.addColumnReader($,S)}),f=0;f<v;f++)g.hasReader(b[f])||g.addColumnReader(void 0,b[f]);h.push(g),c++});var p=s(a);typeof p>"u"&&(p=["y"]),this.valueCount={global:n(a),xColumns:r,individual:l,seriesBuilders:h,globalPointArrayMap:p}},o.prototype.dataFound=function(){this.options.switchRowsAndColumns&&(this.columns=this.rowsToColumns(this.columns)),this.getColumnDistribution(),this.parseTypes(),this.parsed()!==!1&&this.complete()},o.prototype.parseCSV=function(e){var t=this,r=e||this.options,n=r.csv,s,a=typeof r.startRow<"u"&&r.startRow?r.startRow:0,l=r.endRow||Number.MAX_VALUE,h=typeof r.startColumn<"u"&&r.startColumn?r.startColumn:0,c=r.endColumn||Number.MAX_VALUE,d,f,p=0,u=[],g={",":0,";":0,"	":0};s=this.columns=[];function v(b,$,S,k){var A=0,M="",P="",E="",T="",O=0,C=0;function I(N){M=b[N],P=b[N-1],E=b[N+1]}function L(N){u.length<C+1&&u.push([N]),u[C][u[C].length-1]!==N&&u[C].push(N)}function D(){if(h>O||O>c){++O,T="";return}!isNaN(parseFloat(T))&&isFinite(T)?(T=parseFloat(T),L("number")):isNaN(Date.parse(T))?L("string"):(T=T.replace(/\//g,"-"),L("date")),s.length<C+1&&s.push([]),s[C][$]=T,T="",++C,++O}if(b.trim().length&&b.trim()[0]!=="#"){for(;A<b.length;A++)if(I(A),M==='"')for(I(++A);A<b.length&&!(M==='"'&&P!=='"'&&E!=='"');)(M!=='"'||M==='"'&&P!=='"')&&(T+=M),I(++A);else M===d?D():T+=M;D()}}function y(b){var $=0,S=0,k=!1;return b.some(function(A,M){var P=!1,E,T,O,C="";if(M>13)return!0;for(var I=0;I<A.length;I++){if(E=A[I],T=A[I+1],O=A[I-1],E==="#")return;if(E==='"')if(P){if(O!=='"'&&T!=='"'){for(;T===" "&&I<A.length;)T=A[++I];typeof g[T]<"u"&&g[T]++,P=!1}}else P=!0;else typeof g[E]<"u"?(C=C.trim(),isNaN(Date.parse(C))?(isNaN(C)||!isFinite(C))&&g[E]++:g[E]++,C=""):C+=E;E===","&&S++,E==="."&&$++}}),g[";"]>g[","]?k=";":(g[","]>g[";"],k=","),r.decimalPoint||($>S?r.decimalPoint=".":r.decimalPoint=",",t.decimalRegex=new RegExp("^(-?[0-9]+)"+r.decimalPoint+"([0-9]+)$")),k}function m(b,$){var S="YYYY/mm/dd",k,A=[],M,P=0,E=!1,T=[],O=[],C;for((!$||$>b.length)&&($=b.length);P<$;P++)if(typeof b[P]<"u"&&b[P]&&b[P].length)for(k=b[P].trim().replace(/\//g," ").replace(/\-/g," ").replace(/\./g," ").split(" "),A=["","",""],C=0;C<k.length;C++)C<A.length&&(k[C]=parseInt(k[C],10),k[C]&&(O[C]=!O[C]||O[C]<k[C]?k[C]:O[C],typeof T[C]<"u"?T[C]!==k[C]&&(T[C]=!1):T[C]=k[C],k[C]>31?k[C]<100?A[C]="YY":A[C]="YYYY":k[C]>12&&k[C]<=31?(A[C]="dd",E=!0):A[C].length||(A[C]="mm")));if(E){for(C=0;C<T.length;C++)T[C]!==!1?O[C]>12&&A[C]!=="YY"&&A[C]!=="YYYY"&&(A[C]="YY"):O[C]>12&&A[C]==="mm"&&(A[C]="dd");return A.length===3&&A[1]==="dd"&&A[2]==="dd"&&(A[2]="YY"),M=A.join("/"),(r.dateFormats||t.dateFormats)[M]?M:(fireEvent$5("deduceDateFailed"),S)}return S}if(n&&r.beforeParse&&(n=r.beforeParse.call(this,n)),n){f=n.replace(/\r\n/g,`
`).replace(/\r/g,`
`).split(r.lineDelimiter||`
`),(!a||a<0)&&(a=0),(!l||l>=f.length)&&(l=f.length-1),r.itemDelimiter?d=r.itemDelimiter:(d=null,d=y(f));var x=0;for(p=a;p<=l;p++)f[p][0]==="#"?x++:v(f[p],p-a-x);(!r.columnTypes||r.columnTypes.length===0)&&u.length&&u[0].length&&u[0][1]==="date"&&!r.dateFormat&&(r.dateFormat=m(s[0])),this.dataFound()}return s},o.prototype.parseTable=function(){var e=this.options,t=e.table,r=this.columns||[],n=e.startRow||0,s=e.endRow||Number.MAX_VALUE,a=e.startColumn||0,l=e.endColumn||Number.MAX_VALUE;return t&&(typeof t=="string"&&(t=doc$1.getElementById(t)),[].forEach.call(t.getElementsByTagName("tr"),function(h,c){c>=n&&c<=s&&[].forEach.call(h.children,function(d,f){var p=r[f-a],u=1;if((d.tagName==="TD"||d.tagName==="TH")&&f>=a&&f<=l)for(r[f-a]||(r[f-a]=[]),r[f-a][c-n]=d.innerHTML;c-n>=u&&p[c-n-u]===void 0;)p[c-n-u]=null,u++})}),this.dataFound()),r},o.prototype.fetchLiveData=function(){var e=this,t=this.chart,r=this.options,n=3,s=0,a=r.enablePolling,l=(r.dataRefreshRate||2)*1e3,h=merge$h(r);if(!this.hasURLOption(r))return!1;l<1e3&&(l=1e3),delete r.csvURL,delete r.rowsURL,delete r.columnsURL;function c(d){function f(p,u,g){if(!p||!/^(http|\/|\.\/|\.\.\/)/.test(p))return p&&r.error&&r.error("Invalid URL"),!1;d&&(clearTimeout(e.liveDataTimeout),t.liveDataURL=p);function v(){a&&t.liveDataURL===p&&(e.liveDataTimeout=setTimeout(c,l))}return ajax({url:p,dataType:g||"json",success:function(y){t&&t.series&&u(y),v()},error:function(y,m){return++s<n&&v(),r.error&&r.error(m,y)}}),!0}f(h.csvURL,function(p){t.update({data:{csv:p}})},"text")||f(h.rowsURL,function(p){t.update({data:{rows:p}})})||f(h.columnsURL,function(p){t.update({data:{columns:p}})})}return c(!0),this.hasURLOption(r)},o.prototype.parseGoogleSpreadsheet=function(){var e=this,t=this.options,r=t.googleSpreadsheetKey,n=this.chart,s=Math.max((t.dataRefreshRate||2)*1e3,4e3),a=function(){if(t.googleSpreadsheetRange)return t.googleSpreadsheetRange;var h="ABCDEFGHIJKLMNOPQRSTUVWXYZ",c=(h.charAt(t.startColumn||0)||"A")+((t.startRow||0)+1),d=h.charAt(pick$j(t.endColumn,-1))||"ZZ";return defined$8(t.endRow)&&(d+=t.endRow+1),c+":"+d};function l(h){var c=["https://sheets.googleapis.com/v4/spreadsheets",r,"values",a(),"?alt=json&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE&dateTimeRenderOption=FORMATTED_STRING&key="+t.googleAPIKey].join("/");ajax({url:c,dataType:"json",success:function(d){h(d),t.enablePolling&&setTimeout(function(){l(h)},s)},error:function(d,f){return t.error&&t.error(f,d)}})}return r&&(delete t.googleSpreadsheetKey,l(function(h){var c=h.values;if(!c||c.length===0)return!1;var d=c.reduce(function(f,p){return Math.max(f,p.length)},0);c.forEach(function(f){for(var p=0;p<d;p++)typeof f[p]>"u"&&(f[p]=null)}),n&&n.series?n.update({data:{columns:c}}):(e.columns=c,e.dataFound())})),!1},o.prototype.trim=function(e,t){return typeof e=="string"&&(e=e.replace(/^\s+|\s+$/g,""),t&&/^[0-9\s]+$/.test(e)&&(e=e.replace(/\s/g,"")),this.decimalRegex&&(e=e.replace(this.decimalRegex,"$1.$2"))),e},o.prototype.parseTypes=function(){for(var e=this.columns,t=e.length;t--;)this.parseColumn(e[t],t)},o.prototype.parseColumn=function(e,t){var r=this.rawColumns,n=this.columns,s=e.length,a,l,h,c,d=this.firstRowAsNames,f=this.valueCount.xColumns.indexOf(t)!==-1,p,u=[],g,v=this.chartOptions,y,m=this.options.columnTypes||[],x=m[t],b=f&&(v&&v.xAxis&&splat$1(v.xAxis)[0].type==="category"||x==="string");for(r[t]||(r[t]=[]);s--;)a=u[s]||e[s],h=this.trim(a),c=this.trim(a,!0),l=parseFloat(c),typeof r[t][s]>"u"&&(r[t][s]=h),b||s===0&&d?e[s]=""+h:+c===l?(e[s]=l,l>365*24*3600*1e3&&x!=="float"?e.isDatetime=!0:e.isNumeric=!0,typeof e[s+1]<"u"&&(y=l>e[s+1])):(h&&h.length&&(p=this.parseDate(a)),f&&isNumber$8(p)&&x!=="float"?(u[s]=a,e[s]=p,e.isDatetime=!0,typeof e[s+1]<"u"&&(g=p>e[s+1],g!==y&&typeof y<"u"&&(this.alternativeFormat?(this.dateFormat=this.alternativeFormat,s=e.length,this.alternativeFormat=this.dateFormats[this.dateFormat].alternative):e.unsorted=!0),y=g)):(e[s]=h===""?null:h,s!==0&&(e.isDatetime||e.isNumeric)&&(e.mixed=!0)));if(f&&e.mixed&&(n[t]=r[t]),f&&y&&this.options.sort)for(t=0;t<n.length;t++)n[t].reverse(),d&&n[t].unshift(n[t].pop())},o.prototype.parseDate=function(e){var t=this.options.parseDate,r,n,s,a=this.options.dateFormat||this.dateFormat,l;if(t)r=t(e);else if(typeof e=="string"){if(a)s=this.dateFormats[a],s||(s=this.dateFormats["YYYY/mm/dd"]),l=e.match(s.regex),l&&(r=s.parser(l));else for(n in this.dateFormats)if(s=this.dateFormats[n],l=e.match(s.regex),l){this.dateFormat=a=n,this.alternativeFormat=s.alternative,r=s.parser(l);break}l||(e.match(/:.+(GMT|UTC|[Z+-])/)&&(e=e.replace(/\s*(?:GMT|UTC)?([+-])(\d\d)(\d\d)$/,"$1$2:$3").replace(/(?:\s+|GMT|UTC)([+-])/,"$1").replace(/(\d)\s*(?:GMT|UTC|Z)$/,"$1+00:00")),l=Date.parse(e),typeof l=="object"&&l!==null&&l.getTime?r=l.getTime()-l.getTimezoneOffset()*6e4:isNumber$8(l)&&(r=l-new Date(l).getTimezoneOffset()*6e4))}return r},o.prototype.rowsToColumns=function(e){var t,r,n,s,a;if(e)for(a=[],r=e.length,t=0;t<r;t++)for(s=e[t].length,n=0;n<s;n++)a[n]||(a[n]=[]),a[n][t]=e[t][n];return a},o.prototype.getData=function(){if(this.columns)return this.rowsToColumns(this.columns).slice(1)},o.prototype.parsed=function(){if(this.options.parsed)return this.options.parsed.call(this,this.columns)},o.prototype.getFreeIndexes=function(e,t){var r,n,s=[],a=[],l;for(n=0;n<e;n=n+1)s.push(!0);for(r=0;r<t.length;r=r+1)for(l=t[r].getReferencedColumnIndexes(),n=0;n<l.length;n=n+1)s[l[n]]=!1;for(n=0;n<s.length;n=n+1)s[n]&&a.push(n);return a},o.prototype.complete=function(){var e=this.columns,t,r=this.options,n,s,a,l,h,c,d,f=[],p,u,g,v;if(e.length,r.complete||r.afterComplete){if(this.firstRowAsNames)for(a=0;a<e.length;a++)e[a].name=e[a].shift();for(n=[],u=this.getFreeIndexes(e.length,this.valueCount.seriesBuilders),c=0;c<this.valueCount.seriesBuilders.length;c++)p=this.valueCount.seriesBuilders[c],p.populateColumns(u)&&f.push(p);for(;u.length>0;){for(p=new SeriesBuilder,p.addColumnReader(0,"x"),v=u.indexOf(0),v!==-1&&u.splice(v,1),a=0;a<this.valueCount.global;a++)p.addColumnReader(void 0,this.valueCount.globalPointArrayMap[a]);p.populateColumns(u)&&f.push(p)}if(f.length>0&&f[0].readers.length>0&&(g=e[f[0].readers[0].columnIndex],typeof g<"u"&&(g.isDatetime?t="datetime":g.isNumeric||(t="category"))),t==="category")for(c=0;c<f.length;c++)for(p=f[c],h=0;h<p.readers.length;h++)p.readers[h].configName==="x"&&(p.readers[h].configName="name");for(c=0;c<f.length;c++){for(p=f[c],s=[],l=0;l<e[0].length;l++)s[l]=p.read(e,l);n[c]={data:s},p.name&&(n[c].name=p.name),t==="category"&&(n[c].turboThreshold=0)}d={series:n},t&&(d.xAxis={type:t},t==="category"&&(d.xAxis.uniqueNames=!1)),r.complete&&r.complete(d),r.afterComplete&&r.afterComplete(d)}},o.prototype.update=function(e,t){var r=this.chart;e&&(e.afterComplete=function(n){n&&(n.xAxis&&r.xAxis[0]&&n.xAxis.type===r.xAxis[0].options.type&&delete n.xAxis,r.update(n,t,!0))},merge$h(!0,r.options.data,e),this.init(r.options.data))},o}();H.data=function(o,e,t){return new H.Data(o,e,t)};addEvent$b(Chart$1,"init",function(o){var e=this,t=o.args[0]||{},r=o.args[1];t&&t.data&&!e.hasDataDef&&(e.hasDataDef=!0,e.data=new H.Data(extend$m(t.data,{afterComplete:function(n){var s,a;if(Object.hasOwnProperty.call(t,"series"))if(typeof t.series=="object")for(s=Math.max(t.series.length,n&&n.series?n.series.length:0);s--;)a=t.series[s]||{},t.series[s]=merge$h(a,n&&n.series?n.series[s]:{});else delete t.series;t=merge$h(n,t),e.init(t,r)}}),t,e),o.preventDefault())});var SeriesBuilder=function(){function o(){this.readers=[],this.pointIsArray=!0,this.name=void 0}return o.prototype.populateColumns=function(e){var t=this,r=!0;return t.readers.forEach(function(n){typeof n.columnIndex>"u"&&(n.columnIndex=e.shift())}),t.readers.forEach(function(n){typeof n.columnIndex>"u"&&(r=!1)}),r},o.prototype.read=function(e,t){var r=this,n=r.pointIsArray,s=n?[]:{},a;return r.readers.forEach(function(l){var h=e[l.columnIndex][t];n?s.push(h):l.configName.indexOf(".")>0?Point$2.prototype.setNestedProperty(s,h,l.configName):s[l.configName]=h}),typeof this.name>"u"&&r.readers.length>=2&&(a=r.getReferencedColumnIndexes(),a.length>=2&&(a.shift(),a.sort(function(l,h){return l-h}),this.name=e[a.shift()].name)),s},o.prototype.addColumnReader=function(e,t){this.readers.push({columnIndex:e,configName:t}),t==="x"||t==="y"||typeof t>"u"||(this.pointIsArray=!1)},o.prototype.getReferencedColumnIndexes=function(){var e,t=[],r;for(e=0;e<this.readers.length;e=e+1)r=this.readers[e],typeof r.columnIndex<"u"&&t.push(r.columnIndex);return t},o.prototype.hasReader=function(e){var t,r;for(t=0;t<this.readers.length;t=t+1)if(r=this.readers[t],r.configName===e)return!0},o}();H.Data=Data;H.Data;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/data
 * @requires highcharts
 *
 * Data module
 *
 * (c) 2012-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$2=H;G$2.HttpUtilities=exports$2;G$2.ajax=exports$2.ajax;G$2.getJSON=exports$2.getJSON;G$2.post=exports$2.post;var animObject=animationExports.animObject,format=FormatUtilities.format,noop$4=H.noop,defaultOptions$2=DefaultOptions.defaultOptions,seriesTypes$1=SeriesRegistry$1.seriesTypes,addEvent$a=Utilities.addEvent,removeEvent$1=Utilities.removeEvent,extend$l=Utilities.extend,fireEvent$4=Utilities.fireEvent,merge$g=Utilities.merge,objectEach$3=Utilities.objectEach,pick$i=Utilities.pick,syncTimeout=Utilities.syncTimeout,PieSeries$1=seriesTypes$1.pie,ddSeriesId=1;extend$l(defaultOptions$2.lang,{drillUpText:"◁ Back to {series.name}"});defaultOptions$2.drilldown={activeAxisLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},activeDataLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},animation:{duration:500},drillUpButton:{position:{align:"right",x:-10,y:10}}};SVGRenderer.prototype.Element.prototype.fadeIn=function(o){this.attr({opacity:.1,visibility:"inherit"}).animate({opacity:pick$i(this.newOpacity,1)},o||{duration:250})};Chart$1.prototype.addSeriesAsDrilldown=function(o,e){this.addSingleSeriesAsDrilldown(o,e),this.applyDrilldown()};Chart$1.prototype.addSingleSeriesAsDrilldown=function(o,e){var t=o.series,r=t.xAxis,n=t.yAxis,s,a,l=[],h=[],c,d,f,p;p=this.styledMode?{colorIndex:pick$i(o.colorIndex,t.colorIndex)}:{color:o.color||t.color},this.drilldownLevels||(this.drilldownLevels=[]),d=t.options._levelNumber||0,f=this.drilldownLevels[this.drilldownLevels.length-1],f&&f.levelNumber!==d&&(f=void 0),e=extend$l(extend$l({_ddSeriesId:ddSeriesId++},p),e),a=t.points.indexOf(o),t.chart.series.forEach(function(u){u.xAxis===r&&!u.isDrilling&&(u.options._ddSeriesId=u.options._ddSeriesId||ddSeriesId++,u.options._colorIndex=u.userOptions._colorIndex,u.options._levelNumber=u.options._levelNumber||d,f?(l=f.levelSeries,h=f.levelSeriesOptions):(l.push(u),u.purgedOptions=merge$g({_ddSeriesId:u.options._ddSeriesId,_levelNumber:u.options._levelNumber,selected:u.options.selected},u.userOptions),h.push(u.purgedOptions)))}),c=extend$l({levelNumber:d,seriesOptions:t.options,seriesPurgedOptions:t.purgedOptions,levelSeriesOptions:h,levelSeries:l,shapeArgs:o.shapeArgs,bBox:o.graphic?o.graphic.getBBox():{},color:o.isNull?Color.parse(p.color).setOpacity(0).get():p.color,lowerSeriesOptions:e,pointOptions:t.options.data[a],pointIndex:a,oldExtremes:{xMin:r&&r.userMin,xMax:r&&r.userMax,yMin:n&&n.userMin,yMax:n&&n.userMax},resetZoomButton:this.resetZoomButton},p),this.drilldownLevels.push(c),r&&r.names&&(r.names.length=0),s=c.lowerSeries=this.addSeries(e,!1),s.options._levelNumber=d+1,r&&(r.oldPos=r.pos,r.userMin=r.userMax=null,n.userMin=n.userMax=null),t.type===s.type&&(s.animate=s.animateDrilldown||noop$4,s.options.animation=!0)};Chart$1.prototype.applyDrilldown=function(){var o=this.drilldownLevels,e;o&&o.length>0&&(e=o[o.length-1].levelNumber,this.drilldownLevels.forEach(function(t){t.levelNumber===e&&t.levelSeries.forEach(function(r){r.options&&r.options._levelNumber===e&&r.remove(!1)})})),this.resetZoomButton&&(this.resetZoomButton.hide(),delete this.resetZoomButton),this.pointer.reset(),this.redraw(),this.showDrillUpButton(),fireEvent$4(this,"afterDrilldown")};Chart$1.prototype.getDrilldownBackText=function(){var o=this.drilldownLevels,e;if(o&&o.length>0)return e=o[o.length-1],e.series=e.seriesOptions,format(this.options.lang.drillUpText||"",e)};Chart$1.prototype.showDrillUpButton=function(){var o=this,e=this.getDrilldownBackText(),t=o.options.drilldown.drillUpButton,r,n,s=t.relativeTo==="chart"||t.relativeTo==="spacingBox"?null:"scrollablePlotBox";this.drillUpButton?this.drillUpButton.attr({text:e}).align():(r=t.theme,n=r&&r.states,this.drillUpButton=this.renderer.button(e,null,null,function(){o.drillUp()},r,n&&n.hover,n&&n.select).addClass("highcharts-drillup-button").attr({align:t.position.align,zIndex:7}).add().align(t.position,!1,s))};Chart$1.prototype.drillUp=function(){if(!(!this.drilldownLevels||this.drilldownLevels.length===0)){for(var o=this,e=o.drilldownLevels,t=e[e.length-1].levelNumber,r=e.length,n=o.series,s,a,l,h,c,d=function(f){var p;n.forEach(function(u){u.options._ddSeriesId===f._ddSeriesId&&(p=u)}),p=p||o.addSeries(f,!1),p.type===l.type&&p.animateDrillupTo&&(p.animate=p.animateDrillupTo),f===a.seriesPurgedOptions&&(h=p)};r--;)if(a=e[r],a.levelNumber===t){if(e.pop(),l=a.lowerSeries,!l.chart){for(s=n.length;s--;)if(n[s].options.id===a.lowerSeriesOptions.id&&n[s].options._levelNumber===t+1){l=n[s];break}}l.xData=[],a.levelSeriesOptions.forEach(d),fireEvent$4(o,"drillup",{seriesOptions:a.seriesPurgedOptions||a.seriesOptions}),this.resetZoomButton&&this.resetZoomButton.destroy(),h.type===l.type&&(h.drilldownLevel=a,h.options.animation=o.options.drilldown.animation,l.animateDrillupFrom&&l.chart&&l.animateDrillupFrom(a)),h.options._levelNumber=t,l.remove(!1),h.xAxis&&(c=a.oldExtremes,h.xAxis.setExtremes(c.xMin,c.xMax,!1),h.yAxis.setExtremes(c.yMin,c.yMax,!1)),a.resetZoomButton&&(o.resetZoomButton=a.resetZoomButton,o.resetZoomButton.show())}this.redraw(),this.drilldownLevels.length===0?this.drillUpButton=this.drillUpButton.destroy():this.drillUpButton.attr({text:this.getDrilldownBackText()}).align(),this.ddDupes.length=[],fireEvent$4(o,"drillupall")}};addEvent$a(Chart$1,"afterInit",function(){var o=this;o.drilldown={update:function(e,t){merge$g(!0,o.options.drilldown,e),pick$i(t,!0)&&o.redraw()}}});addEvent$a(Chart$1,"afterShowResetZoom",function(){var o=this,e=o.resetZoomButton&&o.resetZoomButton.getBBox(),t=o.options.drilldown&&o.options.drilldown.drillUpButton;this.drillUpButton&&e&&t&&t.position&&t.position.x&&this.drillUpButton.align({x:t.position.x-e.width-10,y:t.position.y,align:t.position.align},!1,t.relativeTo||"plotBox")});addEvent$a(Chart$1,"render",function(){(this.xAxis||[]).forEach(function(o){o.ddPoints={},o.series.forEach(function(e){var t,r=e.xData||[],n=e.points,s;for(t=0;t<r.length;t++)if(s=e.options.data[t],typeof s!="number"&&(s=e.pointClass.prototype.optionsToObject.call({series:e},s),s.drilldown)){o.ddPoints[r[t]]||(o.ddPoints[r[t]]=[]);var a=t-(e.cropStart||0);o.ddPoints[r[t]].push(n&&a>=0&&a<n.length?n[a]:!0)}}),objectEach$3(o.ticks,Tick.prototype.drillable)})});ColumnSeries$h.prototype.animateDrillupTo=function(o){if(!o){var e=this,t=e.drilldownLevel;this.points.forEach(function(r){var n=r.dataLabel;r.graphic&&r.graphic.hide(),n&&(n.hidden=n.attr("visibility")==="hidden",n.hidden||(n.hide(),r.connector&&r.connector.hide()))}),syncTimeout(function(){if(e.points){var r=[];e.data.forEach(function(n){r.push(n)}),e.nodes&&(r=r.concat(e.nodes)),r.forEach(function(n,s){var a=s===(t&&t.pointIndex)?"show":"fadeIn",l=a==="show"?!0:void 0,h=n.dataLabel;n.graphic&&n.graphic[a](l),h&&!h.hidden&&(h.fadeIn(),n.connector&&n.connector.fadeIn())})}},Math.max(this.chart.options.drilldown.animation.duration-50,0)),delete this.animate}};ColumnSeries$h.prototype.animateDrilldown=function(o){var e=this,t=this.chart,r=t.drilldownLevels,n,s=animObject(t.options.drilldown.animation),a=this.xAxis,l=t.styledMode;o||(r.forEach(function(h){e.options._ddSeriesId===h.lowerSeriesOptions._ddSeriesId&&(n=h.shapeArgs,l||(n.fill=h.color))}),n.x+=pick$i(a.oldPos,a.pos)-a.pos,this.points.forEach(function(h){var c=h.shapeArgs;l||(c.fill=h.color),h.graphic&&h.graphic.attr(n).animate(extend$l(h.shapeArgs,{fill:h.color||e.color}),s),h.dataLabel&&h.dataLabel.fadeIn(s)}),delete this.animate)};ColumnSeries$h.prototype.animateDrillupFrom=function(o){var e=animObject(this.chart.options.drilldown.animation),t=this.group,r=t!==this.chart.columnGroup,n=this;n.trackerGroups.forEach(function(s){n[s]&&n[s].on("mouseover")}),r&&delete this.group,this.points.forEach(function(s){var a=s.graphic,l=o.shapeArgs,h=function(){a.destroy(),t&&r&&(t=t.destroy())};a&&l&&(delete s.graphic,n.chart.styledMode||(l.fill=o.color),e.duration?a.animate(l,merge$g(e,{complete:h})):(a.attr(l),h()))})};PieSeries$1&&extend$l(PieSeries$1.prototype,{animateDrillupTo:ColumnSeries$h.prototype.animateDrillupTo,animateDrillupFrom:ColumnSeries$h.prototype.animateDrillupFrom,animateDrilldown:function(o){var e=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],t=this.chart.options.drilldown.animation;if(this.is("item")&&(t.duration=0),this.center){var r=e.shapeArgs,n=r.start,s=r.end-n,a=s/this.points.length,l=this.chart.styledMode;o||(this.points.forEach(function(h,c){var d=h.shapeArgs;l||(r.fill=e.color,d.fill=h.color),h.graphic&&h.graphic.attr(merge$g(r,{start:n+c*a,end:n+(c+1)*a}))[t?"animate":"attr"](d,t)}),delete this.animate)}}});Point$2.prototype.doDrilldown=function(){this.runDrilldown()};Point$2.prototype.runDrilldown=function(o,e,t){var r=this.series,n=r.chart,s=n.options.drilldown,a=(s.series||[]).length,l;for(n.ddDupes||(n.ddDupes=[]);a--&&!l;)s.series[a].id===this.drilldown&&n.ddDupes.indexOf(this.drilldown)===-1&&(l=s.series[a],n.ddDupes.push(this.drilldown));fireEvent$4(n,"drilldown",{point:this,seriesOptions:l,category:e,originalEvent:t,points:typeof e<"u"&&this.series.xAxis.getDDPoints(e).slice(0)},function(h){var c=h.point.series&&h.point.series.chart,d=h.seriesOptions;c&&d&&(o?c.addSingleSeriesAsDrilldown(h.point,d):c.addSeriesAsDrilldown(h.point,d))})};Axis.prototype.drilldownCategory=function(o,e){this.getDDPoints(o).forEach(function(t){t&&t.series&&t.series.visible&&t.runDrilldown&&t.runDrilldown(!0,o,e)}),this.chart.applyDrilldown()};Axis.prototype.getDDPoints=function(o){return this.ddPoints&&this.ddPoints[o]||[]};Tick.prototype.drillable=function(){var o=this.pos,e=this.label,t=this.axis,r=t.coll==="xAxis"&&t.getDDPoints,n=r&&t.getDDPoints(o),s=t.chart.styledMode;r&&(e&&n&&n.length?(e.drillable=!0,!e.basicStyles&&!s&&(e.basicStyles=merge$g(e.styles)),e.addClass("highcharts-drilldown-axis-label"),e.removeOnDrillableClick&&removeEvent$1(e.element,"click"),e.removeOnDrillableClick=addEvent$a(e.element,"click",function(a){a.preventDefault(),t.drilldownCategory(o,a)}),s||e.css(t.chart.options.drilldown.activeAxisLabelStyle)):e&&e.drillable&&e.removeOnDrillableClick&&(s||(e.styles={},e.css(e.basicStyles)),e.removeOnDrillableClick(),e.removeClass("highcharts-drilldown-axis-label")))};addEvent$a(Point$2,"afterInit",function(){var o=this;return o.drilldown&&!o.unbindDrilldownClick&&(o.unbindDrilldownClick=addEvent$a(o,"click",handlePointClick)),o});addEvent$a(Point$2,"update",function(o){var e=this,t=o.options||{};t.drilldown&&!e.unbindDrilldownClick?e.unbindDrilldownClick=addEvent$a(e,"click",handlePointClick):!t.drilldown&&t.drilldown!==void 0&&e.unbindDrilldownClick&&(e.unbindDrilldownClick=e.unbindDrilldownClick())});var handlePointClick=function(o){var e=this,t=e.series;t.xAxis&&t.chart.options.drilldown.allowPointDrilldown===!1?t.xAxis.drilldownCategory(e.x,o):e.runDrilldown(void 0,void 0,o)};addEvent$a(Series$e,"afterDrawDataLabels",function(){var o=this.chart.options.drilldown.activeDataLabelStyle,e=this.chart.renderer,t=this.chart.styledMode;this.points.forEach(function(r){var n=r.options.dataLabels,s=pick$i(r.dlOptions,n&&n.style,{});r.drilldown&&r.dataLabel&&(o.color==="contrast"&&!t&&(s.color=e.getContrast(r.color||this.color)),n&&n.color&&(s.color=n.color),r.dataLabel.addClass("highcharts-drilldown-data-label"),t||r.dataLabel.css(o).css(s))},this)});var applyCursorCSS=function(o,e,t,r){o[t?"addClass":"removeClass"]("highcharts-drilldown-point"),r||o.css({cursor:e})};addEvent$a(Series$e,"afterDrawTracker",function(){var o=this.chart.styledMode;this.points.forEach(function(e){e.drilldown&&e.graphic&&applyCursorCSS(e.graphic,"pointer",!0,o)})});addEvent$a(Point$2,"afterSetState",function(){var o=this.series.chart.styledMode;this.drilldown&&this.series.halo&&this.state==="hover"?applyCursorCSS(this.series.halo,"pointer",!0,o):this.series.halo&&applyCursorCSS(this.series.halo,"auto",!1,o)});addEvent$a(Chart$1,"selection",function(o){if(o.resetSelection===!0&&this.drillUpButton){var e=this.options.drilldown&&this.options.drilldown.drillUpButton;e&&e.position&&this.drillUpButton.align({x:e.position.x,y:e.position.y,align:e.position.align},!1,e.relativeTo||"plotBox")}});addEvent$a(Chart$1,"drillup",function(){this.resetZoomButton&&(this.resetZoomButton=this.resetZoomButton.destroy())});H.doc;var addEvent$9=Utilities.addEvent,Fullscreen=function(){function o(e){this.chart=e,this.isOpen=!1;var t=e.renderTo;this.browserProps||(typeof t.requestFullscreen=="function"?this.browserProps={fullscreenChange:"fullscreenchange",requestFullscreen:"requestFullscreen",exitFullscreen:"exitFullscreen"}:t.mozRequestFullScreen?this.browserProps={fullscreenChange:"mozfullscreenchange",requestFullscreen:"mozRequestFullScreen",exitFullscreen:"mozCancelFullScreen"}:t.webkitRequestFullScreen?this.browserProps={fullscreenChange:"webkitfullscreenchange",requestFullscreen:"webkitRequestFullScreen",exitFullscreen:"webkitExitFullscreen"}:t.msRequestFullscreen&&(this.browserProps={fullscreenChange:"MSFullscreenChange",requestFullscreen:"msRequestFullscreen",exitFullscreen:"msExitFullscreen"}))}return o.prototype.close=function(){var e=this,t=e.chart,r=t.options.chart;e.isOpen&&e.browserProps&&t.container.ownerDocument instanceof Document&&t.container.ownerDocument[e.browserProps.exitFullscreen](),e.unbindFullscreenEvent&&(e.unbindFullscreenEvent=e.unbindFullscreenEvent()),t.setSize(e.origWidth,e.origHeight,!1),e.origWidth=void 0,e.origHeight=void 0,r.width=e.origWidthOption,r.height=e.origHeightOption,e.origWidthOption=void 0,e.origHeightOption=void 0,e.isOpen=!1,e.setButtonText()},o.prototype.open=function(){var e=this,t=e.chart,r=t.options.chart;if(r&&(e.origWidthOption=r.width,e.origHeightOption=r.height),e.origWidth=t.chartWidth,e.origHeight=t.chartHeight,e.browserProps){var n=addEvent$9(t.container.ownerDocument,e.browserProps.fullscreenChange,function(){e.isOpen?(e.isOpen=!1,e.close()):(t.setSize(null,null,!1),e.isOpen=!0,e.setButtonText())}),s=addEvent$9(t,"destroy",n);e.unbindFullscreenEvent=function(){n(),s()};var a=t.renderTo[e.browserProps.requestFullscreen]();a&&a.catch(function(){alert("Full screen is not supported inside a frame.")})}},o.prototype.setButtonText=function(){var e=this.chart,t=e.exportDivElements,r=e.options.exporting,n=r&&r.buttons&&r.buttons.contextButton.menuItems,s=e.options.lang;if(r&&r.menuItemDefinitions&&s&&s.exitFullscreen&&s.viewFullscreen&&n&&t){var a=t[n.indexOf("viewFullscreen")];a&&AST.setElementHTML(a,this.isOpen?s.exitFullscreen:r.menuItemDefinitions.viewFullscreen.text||s.viewFullscreen)}},o.prototype.toggle=function(){var e=this;e.isOpen?e.close():e.open()},o}();H.Fullscreen=Fullscreen;H.Fullscreen;addEvent$9(Chart$1,"beforeRender",function(){this.fullscreen=new H.Fullscreen(this)});var isTouchDevice=H.isTouchDevice,exporting={type:"image/png",url:"https://export.highcharts.com/",printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadPDF","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:function(){this.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:function(){this.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:function(){this.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:function(){this.exportChart({type:"image/svg+xml"})}}}},lang={viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"},navigation={buttonOptions:{symbolSize:14,symbolX:12.5,symbolY:10.5,align:"right",buttonSpacing:3,height:22,verticalAlign:"top",width:24,symbolFill:palette.neutralColor60,symbolStroke:palette.neutralColor60,symbolStrokeWidth:3,theme:{padding:5}},menuStyle:{border:"1px solid "+palette.neutralColor40,background:palette.backgroundColor,padding:"5px 0"},menuItemStyle:{padding:"0.5em 1em",color:palette.neutralColor80,background:"none",fontSize:isTouchDevice?"14px":"11px",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:palette.highlightColor80,color:palette.backgroundColor}},ExportingDefaults={exporting,lang,navigation},ExportingSymbols;(function(o){var e=[];function t(s){if(e.indexOf(s)===-1){e.push(s);var a=s.prototype.symbols;a.menu=r,a.menuball=n.bind(a)}}o.compose=t;function r(s,a,l,h){var c=[["M",s,a+2.5],["L",s+l,a+2.5],["M",s,a+h/2+.5],["L",s+l,a+h/2+.5],["M",s,a+h-1.5],["L",s+l,a+h-1.5]];return c}function n(s,a,l,h){var c=h/3-2,d=[];return d=d.concat(this.circle(l-c,a,c,c),this.circle(l-c,a+c+4,c,c),this.circle(l-c,a+2*(c+4),c,c)),d}})(ExportingSymbols||(ExportingSymbols={}));const ExportingSymbols$1=ExportingSymbols;var defaultOptions$1=DefaultOptions.defaultOptions,doc=H.doc,win$1=H.win,addEvent$8=Utilities.addEvent,css$1=Utilities.css,createElement=Utilities.createElement,discardElement=Utilities.discardElement,extend$k=Utilities.extend,find$3=Utilities.find,fireEvent$3=Utilities.fireEvent,isObject$4=Utilities.isObject,merge$f=Utilities.merge,objectEach$2=Utilities.objectEach,pick$h=Utilities.pick,removeEvent=Utilities.removeEvent,uniqueKey=Utilities.uniqueKey,Exporting;(function(o){var e=[],t=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/],r=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"];o.inlineWhitelist=[];var n=["clipPath","defs","desc"],s;function a(P){var E=this,T=E.renderer,O=merge$f(E.options.navigation.buttonOptions,P),C=O.onclick,I=O.menuItems,L=O.symbolSize||12,D;if(E.btnCount||(E.btnCount=0),E.exportDivElements||(E.exportDivElements=[],E.exportSVGElements=[]),!(O.enabled===!1||!O.theme)){var N=O.theme,B=N.states,X=B&&B.hover,W=B&&B.select,F;E.styledMode||(N.fill=pick$h(N.fill,palette.backgroundColor),N.stroke=pick$h(N.stroke,"none")),delete N.states,C?F=function(z){z&&z.stopPropagation(),C.call(E,z)}:I&&(F=function(z){z&&z.stopPropagation(),E.contextMenu(U.menuClassName,I,U.translateX,U.translateY,U.width,U.height,U),U.setState(2)}),O.text&&O.symbol?N.paddingLeft=pick$h(N.paddingLeft,30):O.text||extend$k(N,{width:O.width,height:O.height,padding:0}),E.styledMode||(N["stroke-linecap"]="round",N.fill=pick$h(N.fill,palette.backgroundColor),N.stroke=pick$h(N.stroke,"none"));var U=T.button(O.text,0,0,F,N,X,W).addClass(P.className).attr({title:pick$h(E.options.lang[O._titleKey||O.titleKey],"")});U.menuClassName=P.menuClassName||"highcharts-menu-"+E.btnCount++,O.symbol&&(D=T.symbol(O.symbol,O.symbolX-L/2,O.symbolY-L/2,L,L,{width:L,height:L}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(U),E.styledMode||D.attr({stroke:O.symbolStroke,fill:O.symbolFill,"stroke-width":O.symbolStrokeWidth||1})),U.add(E.exportingGroup).align(extend$k(O,{width:U.width,x:pick$h(O.x,E.buttonOffset)}),!0,"spacingBox"),E.buttonOffset+=(U.width+O.buttonSpacing)*(O.align==="right"?-1:1),E.exportSVGElements.push(U,D)}}function l(){var P=this;if(P.printReverseInfo){var E=P.printReverseInfo,T=E.childNodes,O=E.origDisplay,C=E.resetParams;P.moveContainers(P.renderTo),[].forEach.call(T,function(I,L){I.nodeType===1&&(I.style.display=O[L]||"")}),P.isPrinting=!1,C&&P.setSize.apply(P,C),delete P.printReverseInfo,s=void 0,fireEvent$3(P,"afterPrint")}}function h(){var P=this,E=doc.body,T=P.options.exporting.printMaxWidth,O={childNodes:E.childNodes,origDisplay:[],resetParams:void 0};P.isPrinting=!0,P.pointer.reset(null,0),fireEvent$3(P,"beforePrint");var C=T&&P.chartWidth>T;C&&(O.resetParams=[P.options.chart.width,void 0,!1],P.setSize(T,void 0,!1)),[].forEach.call(O.childNodes,function(I,L){I.nodeType===1&&(O.origDisplay[L]=I.style.display,I.style.display="none")}),P.moveContainers(E),P.printReverseInfo=O}function c(P){var E=P;E.renderExporting(),addEvent$8(P,"redraw",E.renderExporting),addEvent$8(P,"destroy",E.destroyExport)}function d(P,E){if(ExportingSymbols$1.compose(E),e.indexOf(P)===-1){e.push(P);var T=P.prototype;T.afterPrint=l,T.exportChart=u,T.inlineStyles=b,T.print=k,T.sanitizeSVG=M,T.getChartHTML=g,T.getSVG=y,T.getSVGForExport=m,T.getFilename=v,T.moveContainers=$,T.beforePrint=h,T.contextMenu=f,T.addButton=a,T.destroyExport=p,T.renderExporting=A,T.callbacks.push(c),addEvent$8(P,"init",S),H.isSafari&&H.win.matchMedia("print").addListener(function(O){s&&(O.matches?s.beforePrint():s.afterPrint())})}}o.compose=d;function f(P,E,T,O,C,I,L){var D=this,N=D.options.navigation,B=D.chartWidth,X=D.chartHeight,W="cache-"+P,F=Math.max(C,I),U,z=D[W];z||(D.exportContextMenu=D[W]=z=createElement("div",{className:P},{position:"absolute",zIndex:1e3,padding:F+"px",pointerEvents:"auto"},D.fixedDiv||D.container),U=createElement("ul",{className:"highcharts-menu"},{listStyle:"none",margin:0,padding:0},z),D.styledMode||css$1(U,extend$k({MozBoxShadow:"3px 3px 10px #888",WebkitBoxShadow:"3px 3px 10px #888",boxShadow:"3px 3px 10px #888"},N.menuStyle)),z.hideMenu=function(){css$1(z,{display:"none"}),L&&L.setState(0),D.openMenu=!1,css$1(D.renderTo,{overflow:"hidden"}),css$1(D.container,{overflow:"hidden"}),Utilities.clearTimeout(z.hideTimer),fireEvent$3(D,"exportMenuHidden")},D.exportEvents.push(addEvent$8(z,"mouseleave",function(){z.hideTimer=win$1.setTimeout(z.hideMenu,500)}),addEvent$8(z,"mouseenter",function(){Utilities.clearTimeout(z.hideTimer)}),addEvent$8(doc,"mouseup",function(j){D.pointer.inClass(j.target,P)||z.hideMenu()}),addEvent$8(z,"click",function(){D.openMenu&&z.hideMenu()})),E.forEach(function(j){if(typeof j=="string"&&(j=D.options.exporting.menuItemDefinitions[j]),isObject$4(j,!0)){var K=void 0;j.separator?K=createElement("hr",void 0,void 0,U):(j.textKey==="viewData"&&D.isDataTableVisible&&(j.textKey="hideData"),K=createElement("li",{className:"highcharts-menu-item",onclick:function(ot){ot&&ot.stopPropagation(),z.hideMenu(),j.onclick&&j.onclick.apply(D,arguments)}},void 0,U),AST.setElementHTML(K,j.text||D.options.lang[j.textKey]),D.styledMode||(K.onmouseover=function(){css$1(this,N.menuItemHoverStyle)},K.onmouseout=function(){css$1(this,N.menuItemStyle)},css$1(K,extend$k({cursor:"pointer"},N.menuItemStyle)))),D.exportDivElements.push(K)}}),D.exportDivElements.push(U,z),D.exportMenuWidth=z.offsetWidth,D.exportMenuHeight=z.offsetHeight);var V={display:"block"};T+D.exportMenuWidth>B?V.right=B-T-C-F+"px":V.left=T-F+"px",O+I+D.exportMenuHeight>X&&L.alignOptions.verticalAlign!=="top"?V.bottom=X-O-F+"px":V.top=O+I-F+"px",css$1(z,V),css$1(D.renderTo,{overflow:""}),css$1(D.container,{overflow:""}),D.openMenu=!0,fireEvent$3(D,"exportMenuShown")}function p(P){var E=P?P.target:this,T=E.exportSVGElements,O=E.exportDivElements,C=E.exportEvents,I;T&&(T.forEach(function(L,D){L&&(L.onclick=L.ontouchstart=null,I="cache-"+L.menuClassName,E[I]&&delete E[I],T[D]=L.destroy())}),T.length=0),E.exportingGroup&&(E.exportingGroup.destroy(),delete E.exportingGroup),O&&(O.forEach(function(L,D){L&&(Utilities.clearTimeout(L.hideTimer),removeEvent(L,"mouseleave"),O[D]=L.onmouseout=L.onmouseover=L.ontouchstart=L.onclick=null,discardElement(L))}),O.length=0),C&&(C.forEach(function(L){L()}),C.length=0)}function u(P,E){var T=this.getSVGForExport(P,E);P=merge$f(this.options.exporting,P),exports$2.post(P.url,{filename:P.filename?P.filename.replace(/\//g,"-"):this.getFilename(),type:P.type,width:P.width||0,scale:P.scale,svg:T},P.formAttributes)}function g(){return this.styledMode&&this.inlineStyles(),this.container.innerHTML}function v(){var P=this.userOptions.title&&this.userOptions.title.text,E=this.options.exporting.filename;return E?E.replace(/\//g,"-"):(typeof P=="string"&&(E=P.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z0-9\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,"")),(!E||E.length<5)&&(E="chart"),E)}function y(P){var E=this,T,O,C=merge$f(E.options,P);C.plotOptions=merge$f(E.userOptions.plotOptions,P&&P.plotOptions),C.time=merge$f(E.userOptions.time,P&&P.time);var I=createElement("div",null,{position:"absolute",top:"-9999em",width:E.chartWidth+"px",height:E.chartHeight+"px"},doc.body),L=E.renderTo.style.width,D=E.renderTo.style.height,N=C.exporting.sourceWidth||C.chart.width||/px$/.test(L)&&parseInt(L,10)||(C.isGantt?800:600),B=C.exporting.sourceHeight||C.chart.height||/px$/.test(D)&&parseInt(D,10)||400;extend$k(C.chart,{animation:!1,renderTo:I,forExport:!0,renderer:"SVGRenderer",width:N,height:B}),C.exporting.enabled=!1,delete C.data,C.series=[],E.series.forEach(function(F){O=merge$f(F.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:F.visible}),O.isInternal||C.series.push(O)});var X={};E.axes.forEach(function(F){F.userOptions.internalKey||(F.userOptions.internalKey=uniqueKey()),F.options.isInternal||(X[F.coll]||(X[F.coll]=!0,C[F.coll]=[]),C[F.coll].push(merge$f(F.userOptions,{visible:F.visible})))});var W=new Chart$1(C,E.callback);return P&&["xAxis","yAxis","series"].forEach(function(F){var U={};P[F]&&(U[F]=P[F],W.update(U))}),E.axes.forEach(function(F){var U=find$3(W.axes,function(K){return K.options.internalKey===F.userOptions.internalKey}),z=F.getExtremes(),V=z.userMin,j=z.userMax;U&&(typeof V<"u"&&V!==U.min||typeof j<"u"&&j!==U.max)&&U.setExtremes(V,j,!0,!1)}),T=W.getChartHTML(),fireEvent$3(this,"getSVG",{chartCopy:W}),T=E.sanitizeSVG(T,C),C=null,W.destroy(),discardElement(I),T}function m(P,E){var T=this.options.exporting;return this.getSVG(merge$f({chart:{borderRadius:0}},T.chartOptions,E,{exporting:{sourceWidth:P&&P.sourceWidth||T.sourceWidth,sourceHeight:P&&P.sourceHeight||T.sourceHeight}}))}function x(P){return P.replace(/([A-Z])/g,function(E,T){return"-"+T.toLowerCase()})}function b(){var P=t,E=o.inlineWhitelist,T={},O,C=doc.createElement("iframe");css$1(C,{width:"1px",height:"1px",visibility:"hidden"}),doc.body.appendChild(C);var I=C.contentWindow.document;I.open(),I.write('<svg xmlns="http://www.w3.org/2000/svg"></svg>'),I.close();function L(N){var B,X,W="",F,U,z,V,j;function K(q,J){if(z=V=!1,E.length){for(j=E.length;j--&&!V;)V=E[j].test(J);z=!V}for(J==="transform"&&q==="none"&&(z=!0),j=P.length;j--&&!z;)z=P[j].test(J)||typeof q=="function";z||(X[J]!==q||N.nodeName==="svg")&&T[N.nodeName][J]!==q&&(!r||r.indexOf(J)!==-1?q&&N.setAttribute(x(J),q):W+=x(J)+":"+q+";")}if(N.nodeType===1&&n.indexOf(N.nodeName)===-1){if(B=win$1.getComputedStyle(N,null),X=N.nodeName==="svg"?{}:win$1.getComputedStyle(N.parentNode,null),T[N.nodeName]||(O=I.getElementsByTagName("svg")[0],F=I.createElementNS(N.namespaceURI,N.nodeName),O.appendChild(F),T[N.nodeName]=merge$f(win$1.getComputedStyle(F,null)),N.nodeName==="text"&&delete T.text.fill,O.removeChild(F)),H.isFirefox||H.isMS)for(var ot in B)K(B[ot],ot);else objectEach$2(B,K);if(W&&(U=N.getAttribute("style"),N.setAttribute("style",(U?U+";":"")+W)),N.nodeName==="svg"&&N.setAttribute("stroke-width","1px"),N.nodeName==="text")return;[].forEach.call(N.children||N.childNodes,L)}}function D(){O.parentNode.removeChild(O),C.parentNode.removeChild(C)}L(this.container.querySelector("svg")),D()}function $(P){var E=this;(E.fixedDiv?[E.fixedDiv,E.scrollingContainer]:[E.container]).forEach(function(T){P.appendChild(T)})}function S(){var P=this,E=function(T,O,C){P.isDirtyExporting=!0,merge$f(!0,P.options[T],O),pick$h(C,!0)&&P.redraw()};P.exporting={update:function(T,O){E("exporting",T,O)}},chartNavigation.addUpdate(function(T,O){E("navigation",T,O)},P)}function k(){var P=this;P.isPrinting||(s=P,H.isSafari||P.beforePrint(),setTimeout(function(){win$1.focus(),win$1.print(),H.isSafari||setTimeout(function(){P.afterPrint()},1e3)},1))}function A(){var P=this,E=P.options.exporting,T=E.buttons,O=P.isDirtyExporting||!P.exportSVGElements;P.buttonOffset=0,P.isDirtyExporting&&P.destroyExport(),O&&E.enabled!==!1&&(P.exportEvents=[],P.exportingGroup=P.exportingGroup||P.renderer.g("exporting-group").attr({zIndex:3}).add(),objectEach$2(T,function(C){P.addButton(C)}),P.isDirtyExporting=!1)}function M(P,E){var T=P.indexOf("</svg>")+6,O=P.substr(T);return P=P.substr(0,T),E&&E.exporting&&E.exporting.allowHTML&&O&&(O='<foreignObject x="0" y="0" width="'+E.chart.width+'" height="'+E.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+O.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",P=P.replace("</svg>",O+"</svg>")),P=P.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery[0-9]+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (|NS[0-9]+\:)href=/g," xlink:href=").replace(/\n/," ").replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"').replace(/&nbsp;/g," ").replace(/&shy;/g,"­"),this.ieSanitizeSVG&&(P=this.ieSanitizeSVG(P)),P}})(Exporting||(Exporting={}));defaultOptions$1.exporting=merge$f(ExportingDefaults.exporting,defaultOptions$1.exporting);defaultOptions$1.lang=merge$f(ExportingDefaults.lang,defaultOptions$1.lang);defaultOptions$1.navigation=merge$f(ExportingDefaults.navigation,defaultOptions$1.navigation);const Exporting$1=Exporting;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/exporting
 * @requires highcharts
 *
 * Exporting module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$1=H;G$1.HttpUtilities=exports$2;G$1.ajax=exports$2.ajax;G$1.getJSON=exports$2.getJSON;G$1.post=exports$2.post;Exporting$1.compose(G$1.Chart,G$1.Renderer);var __extends$h=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$3=H.noop,Series$7=SeriesRegistry$1.series,PieSeries=SeriesRegistry$1.seriesTypes.pie,addEvent$7=Utilities.addEvent,extend$j=Utilities.extend,fireEvent$2=Utilities.fireEvent,isArray$2=Utilities.isArray,merge$e=Utilities.merge,pick$g=Utilities.pick,FunnelSeries=function(o){__extends$h(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.alignDataLabel=function(t,r,n,s,a){var l=t.series,h=l.options.reversed,c=t.dlBox||t.shapeArgs,d=n.align,f=n.verticalAlign,p=((l.options||{}).dataLabels||{}).inside,u=l.center[1],g=h?2*u-t.plotY:t.plotY,v=l.getWidthAt(g-c.height/2+r.height),y=f==="middle"?(c.topWidth-c.bottomWidth)/4:(v-c.bottomWidth)/2,m=c.y,x=c.x;f==="middle"?m=c.y-c.height/2+r.height/2:f==="top"&&(m=c.y-c.height+r.height+n.padding),(f==="top"&&!h||f==="bottom"&&h||f==="middle")&&(d==="right"?x=c.x-n.padding+y:d==="left"&&(x=c.x+n.padding-y)),s={x,y:h?m-c.height:m,width:c.bottomWidth,height:c.height},n.verticalAlign="bottom",(!p||t.visible)&&Series$7.prototype.alignDataLabel.call(this,t,r,n,s,a),p&&(!t.visible&&t.dataLabel&&(t.dataLabel.placed=!1),t.contrastColor&&r.css({color:t.contrastColor}))},e.prototype.drawDataLabels=function(){var t=this,r=t.data,n=t.options.dataLabels.distance,s,a,l,h=r.length,c,d;for(t.center[2]-=2*n;h--;)l=r[h],s=l.half,a=s?1:-1,d=l.plotY,l.labelDistance=pick$g(l.options.dataLabels&&l.options.dataLabels.distance,n),t.maxLabelDistance=Math.max(l.labelDistance,t.maxLabelDistance||0),c=t.getX(d,s,l),l.labelPosition={natural:{x:0,y:d},final:{},alignment:s?"right":"left",connectorPosition:{breakAt:{x:c+(l.labelDistance-5)*a,y:d},touchingSliceAt:{x:c+l.labelDistance*a,y:d}}};SeriesRegistry$1.seriesTypes[t.options.dataLabels.inside?"column":"pie"].prototype.drawDataLabels.call(this)},e.prototype.translate=function(){var t=0,r=this,n=r.chart,s=r.options,a=s.reversed,l=s.ignoreHiddenPoint,h=n.plotWidth,c=n.plotHeight,d=0,f=s.center,p=L(f[0],h),u=L(f[1],c),g=L(s.width,h),v,y=L(s.height,c),m=L(s.neckWidth,h),x=L(s.neckHeight,c),b=u-y/2+y-x,$=r.data,S,k,A=s.dataLabels.position==="left"?1:0,M,P,E,T,O,C,I;function L(D,N){return/%$/.test(D)?N*parseInt(D,10)/100:parseInt(D,10)}r.getWidthAt=function(D){var N=u-y/2;return D>b||y===x?m:m+(g-m)*(1-(D-N)/(y-x))},r.getX=function(D,N,B){return p+(N?-1:1)*(r.getWidthAt(a?2*u-D:D)/2+B.labelDistance)},r.center=[p,u,y],r.centerX=p,$.forEach(function(D){(!l||D.visible!==!1)&&(t+=D.y)}),$.forEach(function(D){I=null,k=t?D.y/t:0,P=u-y/2+d*y,O=P+k*y,v=r.getWidthAt(P),M=p-v/2,E=M+v,v=r.getWidthAt(O),T=p-v/2,C=T+v,P>b?(M=T=p-m/2,E=C=p+m/2):O>b&&(I=O,v=r.getWidthAt(b),T=p-v/2,C=T+v,O=b),a&&(P=2*u-P,O=2*u-O,I!==null&&(I=2*u-I)),S=[["M",M,P],["L",E,P],["L",C,O]],I!==null&&S.push(["L",C,I],["L",T,I]),S.push(["L",T,O],["Z"]),D.shapeType="path",D.shapeArgs={d:S},D.percentage=k*100,D.plotX=p,D.plotY=(P+(I||O))/2,D.tooltipPos=[p,D.plotY],D.dlBox={x:T,y:P,topWidth:E-M,bottomWidth:C-T,height:Math.abs(pick$g(I,O)-P),width:NaN},D.slice=noop$3,D.half=A,(!l||D.visible!==!1)&&(d+=k)}),fireEvent$2(r,"afterTranslate")},e.prototype.sortByAngle=function(t){t.sort(function(r,n){return r.plotY-n.plotY})},e.defaultOptions=merge$e(PieSeries.defaultOptions,{animation:!1,center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,size:!0,dataLabels:{connectorWidth:1,verticalAlign:"middle"},states:{select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}}}),e}(PieSeries);extend$j(FunnelSeries.prototype,{animate:noop$3});addEvent$7(Chart$1,"afterHideAllOverlappingLabels",function(){this.series.forEach(function(o){var e=o.options&&o.options.dataLabels;isArray$2(e)&&(e=e[0]),o.is("pie")&&o.placeDataLabels&&e&&!e.inside&&o.placeDataLabels()})});SeriesRegistry$1.registerSeriesType("funnel",FunnelSeries);var __extends$g=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),merge$d=Utilities.merge,PyramidSeries=function(o){__extends$g(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.defaultOptions=merge$d(FunnelSeries.defaultOptions,{neckWidth:"0%",neckHeight:"0%",reversed:!0}),e}(FunnelSeries);SeriesRegistry$1.registerSeriesType("pyramid",PyramidSeries);var colorPointMixin$1={setVisible:function(o){var e=this,t=o?"show":"hide";e.visible=e.options.visible=!!o,["graphic","dataLabel"].forEach(function(r){e[r]&&e[r][t]()}),this.series.buildKDTree()}},colorSeriesMixin$1={optionalAxis:"colorAxis",translateColors:function(){var o=this,e=this.data.length?this.data:this.points,t=this.options.nullColor,r=this.colorAxis,n=this.colorKey;e.forEach(function(s){var a=s.getNestedProperty(n),l;l=s.options.color||(s.isNull||s.value===null?t:r&&typeof a<"u"?r.toColor(a,s):s.color||o.color),l&&s.color!==l&&(s.color=l,o.options.legendType==="point"&&s.legendItem&&o.chart.legend.colorizeItem(s,s.visible))})}},exports$1={colorPointMixin:colorPointMixin$1,colorSeriesMixin:colorSeriesMixin$1},color$4=Color.parse,colorPointMixin=exports$1.colorPointMixin,colorSeriesMixin=exports$1.colorSeriesMixin,addEvent$6=Utilities.addEvent,extend$i=Utilities.extend,merge$c=Utilities.merge,pick$f=Utilities.pick,splat=Utilities.splat,ColorAxisComposition;(function(o){var e=[],t;function r(u,g,v,y,m){if(t||(t=u),e.indexOf(g)===-1){e.push(g);var x=g.prototype;x.collectionsWithUpdate.push("colorAxis"),x.collectionsWithInit.colorAxis=[x.addColorAxis],addEvent$6(g,"afterGetAxes",n),d(g)}if(e.indexOf(v)===-1){e.push(v);var b=v.prototype;b.fillSetter=f,b.strokeSetter=p}e.indexOf(y)===-1&&(e.push(y),addEvent$6(y,"afterGetAllItems",s),addEvent$6(y,"afterColorizeItem",a),addEvent$6(y,"afterUpdate",l)),e.indexOf(m)===-1&&(e.push(m),extend$i(m.prototype,colorSeriesMixin),extend$i(m.prototype.pointClass.prototype,colorPointMixin),addEvent$6(m,"afterTranslate",h),addEvent$6(m,"bindAxes",c))}o.compose=r;function n(){var u=this,g=this.options;this.colorAxis=[],g.colorAxis&&(g.colorAxis=splat(g.colorAxis),g.colorAxis.forEach(function(v,y){v.index=y,new t(u,v)}))}function s(u){var g=this,v=this.chart.colorAxis||[],y=function($){var S=u.allItems.indexOf($);S!==-1&&(g.destroyItem(u.allItems[S]),u.allItems.splice(S,1))},m=[],x,b;for(v.forEach(function($){x=$.options,x&&x.showInLegend&&(x.dataClasses&&x.visible?m=m.concat($.getDataClassLegendSymbols()):x.visible&&m.push($),$.series.forEach(function(S){(!S.options.showInLegend||x.dataClasses)&&(S.options.legendType==="point"?S.points.forEach(function(k){y(k)}):y(S))}))}),b=m.length;b--;)u.allItems.unshift(m[b])}function a(u){u.visible&&u.item.legendColor&&u.item.legendSymbol.attr({fill:u.item.legendColor})}function l(){var u=this.chart.colorAxis;u&&u.forEach(function(g){g.update({},arguments[2])})}function h(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function c(){var u=this.axisTypes;u?u.indexOf("colorAxis")===-1&&u.push("colorAxis"):this.axisTypes=["colorAxis"]}function d(u){var g=u.prototype.createAxis;u.prototype.createAxis=function(v,y){if(v!=="colorAxis")return g.apply(this,arguments);var m=new t(this,merge$c(y.axis,{index:this[v].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(x){x.series=[]}),this.series.forEach(function(x){x.bindAxes(),x.isDirtyData=!0}),pick$f(y.redraw,!0)&&this.redraw(y.animation),m}}function f(){this.elem.attr("fill",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}function p(){this.elem.attr("stroke",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}})(ColorAxisComposition||(ColorAxisComposition={}));const ColorAxisComposition$1=ColorAxisComposition;var colorAxisDefaults={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:palette.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:palette.highlightColor10,maxColor:palette.highlightColor100,tickLength:5,showInLegend:!0},__extends$f=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$3=Color.parse,noop$2=H.noop,Series$6=SeriesRegistry$1.series,extend$h=Utilities.extend,isNumber$7=Utilities.isNumber,merge$b=Utilities.merge,pick$e=Utilities.pick,ColorAxis=function(o){__extends$f(e,o);function e(t,r){var n=o.call(this,t,r)||this;return n.beforePadding=!1,n.chart=void 0,n.coll="colorAxis",n.dataClasses=void 0,n.legendItem=void 0,n.legendItems=void 0,n.name="",n.options=void 0,n.stops=void 0,n.visible=!0,n.init(t,r),n}return e.compose=function(t,r,n,s){ColorAxisComposition$1.compose(e,t,r,n,s)},e.prototype.init=function(t,r){var n=this,s=t.options.legend||{},a=r.layout?r.layout!=="vertical":s.layout!=="vertical",l=r.visible,h=merge$b(e.defaultColorAxisOptions,r,{showEmpty:!1,title:null,visible:s.enabled&&l!==!1});n.coll="colorAxis",n.side=r.side||a?2:1,n.reversed=r.reversed||!a,n.opposite=!a,o.prototype.init.call(this,t,h),n.userOptions.visible=l,r.dataClasses&&n.initDataClasses(r),n.initStops(),n.horiz=a,n.zoomEnabled=!1},e.prototype.initDataClasses=function(t){var r=this,n=r.chart,s=r.options,a=t.dataClasses.length,l,h=0,c=n.options.chart.colorCount;r.dataClasses=l=[],r.legendItems=[],(t.dataClasses||[]).forEach(function(d,f){var p;d=merge$b(d),l.push(d),!(!n.styledMode&&d.color)&&(s.dataClassColor==="category"?(n.styledMode||(p=n.options.colors,c=p.length,d.color=p[h]),d.colorIndex=h,h++,h===c&&(h=0)):d.color=color$3(s.minColor).tweenTo(color$3(s.maxColor),a<2?.5:f/(a-1)))})},e.prototype.hasData=function(){return!!(this.tickPositions||[]).length},e.prototype.setTickPositions=function(){if(!this.dataClasses)return o.prototype.setTickPositions.call(this)},e.prototype.initStops=function(){var t=this;t.stops=t.options.stops||[[0,t.options.minColor],[1,t.options.maxColor]],t.stops.forEach(function(r){r.color=color$3(r[1])})},e.prototype.setOptions=function(t){var r=this;o.prototype.setOptions.call(this,t),r.options.crosshair=r.options.marker},e.prototype.setAxisSize=function(){var t=this,r=t.legendSymbol,n=t.chart,s=n.options.legend||{},a,l,h,c;r?(this.left=a=r.attr("x"),this.top=l=r.attr("y"),this.width=h=r.attr("width"),this.height=c=r.attr("height"),this.right=n.chartWidth-a-h,this.bottom=n.chartHeight-l-c,this.len=this.horiz?h:c,this.pos=this.horiz?a:l):this.len=(this.horiz?s.symbolWidth:s.symbolHeight)||e.defaultLegendLength},e.prototype.normalizedValue=function(t){var r=this;return r.logarithmic&&(t=r.logarithmic.log2lin(t)),1-(r.max-t)/(r.max-r.min||1)},e.prototype.toColor=function(t,r){var n=this,s=n.dataClasses,a=n.stops,l,h,c,d,f,p;if(s){for(p=s.length;p--;)if(f=s[p],h=f.from,c=f.to,(typeof h>"u"||t>=h)&&(typeof c>"u"||t<=c)){d=f.color,r&&(r.dataClass=p,r.colorIndex=f.colorIndex);break}}else{for(l=n.normalizedValue(t),p=a.length;p--&&!(l>a[p][0]););h=a[p]||a[p+1],c=a[p+1]||h,l=1-(c[0]-l)/(c[0]-h[0]||1),d=h.color.tweenTo(c.color,l)}return d},e.prototype.getOffset=function(){var t=this,r=t.legendGroup,n=t.chart.axisOffset[t.side];r&&(t.axisParent=r,o.prototype.getOffset.call(this),t.added||(t.added=!0,t.labelLeft=0,t.labelRight=t.width),t.chart.axisOffset[t.side]=n)},e.prototype.setLegendColor=function(){var t=this,r=t.horiz,n=t.reversed,s=n?1:0,a=n?0:1,l=r?[s,0,a,0]:[0,a,0,s];t.legendColor={linearGradient:{x1:l[0],y1:l[1],x2:l[2],y2:l[3]},stops:t.stops}},e.prototype.drawLegendSymbol=function(t,r){var n=this,s=t.padding,a=t.options,l=n.horiz,h=pick$e(a.symbolWidth,l?e.defaultLegendLength:12),c=pick$e(a.symbolHeight,l?12:e.defaultLegendLength),d=pick$e(a.labelPadding,l?16:30),f=pick$e(a.itemDistance,10);this.setLegendColor(),r.legendSymbol=this.chart.renderer.rect(0,t.baseline-11,h,c).attr({zIndex:1}).add(r.legendGroup),n.legendItemWidth=h+s+(l?f:d),n.legendItemHeight=c+s+(l?d:0)},e.prototype.setState=function(t){this.series.forEach(function(r){r.setState(t)})},e.prototype.setVisible=function(){},e.prototype.getSeriesExtremes=function(){var t=this,r=t.series,n,s,a,l,h,c,d=r.length,f,p;for(this.dataMin=1/0,this.dataMax=-1/0;d--;){if(c=r[d],s=c.colorKey=pick$e(c.options.colorKey,c.colorKey,c.pointValKey,c.zoneAxis,"y"),l=c.pointArrayMap,h=c[s+"Min"]&&c[s+"Max"],c[s+"Data"])n=c[s+"Data"];else if(!l)n=c.yData;else if(n=[],a=l.indexOf(s),f=c.yData,a>=0&&f)for(p=0;p<f.length;p++)n.push(pick$e(f[p][a],f[p]));if(h)c.minColorValue=c[s+"Min"],c.maxColorValue=c[s+"Max"];else{var u=Series$6.prototype.getExtremes.call(c,n);c.minColorValue=u.dataMin,c.maxColorValue=u.dataMax}typeof c.minColorValue<"u"&&(this.dataMin=Math.min(this.dataMin,c.minColorValue),this.dataMax=Math.max(this.dataMax,c.maxColorValue)),h||Series$6.prototype.applyExtremes.call(c)}},e.prototype.drawCrosshair=function(t,r){var n=this,s=r&&r.plotX,a=r&&r.plotY,l=n.pos,h=n.len,c;r&&(c=n.toPixels(r.getNestedProperty(r.series.colorKey)),c<l?c=l-2:c>l+h&&(c=l+h+2),r.plotX=c,r.plotY=n.len-c,o.prototype.drawCrosshair.call(this,t,r),r.plotX=s,r.plotY=a,n.cross&&!n.cross.addedToColorAxis&&n.legendGroup&&(n.cross.addClass("highcharts-coloraxis-marker").add(n.legendGroup),n.cross.addedToColorAxis=!0,!n.chart.styledMode&&typeof n.crosshair=="object"&&n.cross.attr({fill:n.crosshair.color})))},e.prototype.getPlotLinePath=function(t){var r=this,n=r.left,s=t.translatedValue,a=r.top;return isNumber$7(s)?r.horiz?[["M",s-4,a-6],["L",s+4,a-6],["L",s,a],["Z"]]:[["M",n,s],["L",n-6,s+6],["L",n-6,s-6],["Z"]]:o.prototype.getPlotLinePath.call(this,t)},e.prototype.update=function(t,r){var n=this,s=n.chart,a=s.legend;this.series.forEach(function(l){l.isDirtyData=!0}),(t.dataClasses&&a.allItems||n.dataClasses)&&n.destroyItems(),o.prototype.update.call(this,t,r),n.legendItem&&(n.setLegendColor(),a.colorizeItem(this,!0))},e.prototype.destroyItems=function(){var t=this,r=t.chart;t.legendItem?r.legend.destroyItem(t):t.legendItems&&t.legendItems.forEach(function(n){r.legend.destroyItem(n)}),r.isDirtyLegend=!0},e.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),o.prototype.destroy.apply(this,[].slice.call(arguments))},e.prototype.remove=function(t){this.destroyItems(),o.prototype.remove.call(this,t)},e.prototype.getDataClassLegendSymbols=function(){var t=this,r=t.chart,n=t.legendItems,s=r.options.legend,a=s.valueDecimals,l=s.valueSuffix||"",h;return n.length||t.dataClasses.forEach(function(c,d){var f=c.from,p=c.to,u=r.numberFormatter,g=!0;h="",typeof f>"u"?h="< ":typeof p>"u"&&(h="> "),typeof f<"u"&&(h+=u(f,a)+l),typeof f<"u"&&typeof p<"u"&&(h+=" - "),typeof p<"u"&&(h+=u(p,a)+l),n.push(extend$h({chart:r,name:h,options:{},drawLegendSymbol:LegendSymbol$1.drawRectangle,visible:!0,setState:noop$2,isDataClass:!0,setVisible:function(){g=t.visible=!g,t.series.forEach(function(v){v.points.forEach(function(y){y.dataClass===d&&y.setVisible(g)})}),r.legend.colorizeItem(this,g)}},c))}),n},e.defaultColorAxisOptions=colorAxisDefaults,e.defaultLegendLength=200,e.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"],e}(Axis);Array.prototype.push.apply(Axis.keepProps,ColorAxis.keepProps);var defined$7=Utilities.defined,addEvent$5=Utilities.addEvent,noop$1=H.noop,seriesTypes=H.seriesTypes;addEvent$5(Point$2,"afterSetState",function(o){var e=this;e.moveToTopOnHover&&e.graphic&&e.graphic.attr({zIndex:o&&o.state==="hover"?1:0})});var colorMapPointMixin$1={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return this.value!==null&&this.value!==1/0&&this.value!==-1/0}},colorMapSeriesMixin$2={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:noop$1,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:seriesTypes.column.prototype.pointAttribs,colorAttribs:function(o){var e={};return defined$7(o.color)&&(!o.state||o.state==="normal")&&(e[this.colorProp||"fill"]=o.color),e}},exports={colorMapPointMixin:colorMapPointMixin$1,colorMapSeriesMixin:colorMapSeriesMixin$2},__extends$e=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colorMapPointMixin=exports.colorMapPointMixin,ScatterPoint$1=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,clamp$2=Utilities.clamp,extend$g=Utilities.extend,pick$d=Utilities.pick,HeatmapPoint=function(o){__extends$e(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.value=void 0,t.x=void 0,t.y=void 0,t}return e.prototype.applyOptions=function(t,r){var n=o.prototype.applyOptions.call(this,t,r);return n.formatPrefix=n.isNull||n.value===null?"null":"point",n},e.prototype.getCellAttributes=function(){var t=this,r=t.series,n=r.options,s=(n.colsize||1)/2,a=(n.rowsize||1)/2,l=r.xAxis,h=r.yAxis,c=t.options.marker||r.options.marker,d=r.pointPlacementToXValue(),f=pick$d(t.pointPadding,n.pointPadding,0),p={x1:clamp$2(Math.round(l.len-(l.translate(t.x-s,!1,!0,!1,!0,-d)||0)),-l.len,2*l.len),x2:clamp$2(Math.round(l.len-(l.translate(t.x+s,!1,!0,!1,!0,-d)||0)),-l.len,2*l.len),y1:clamp$2(Math.round(h.translate(t.y-a,!1,!0,!1,!0)||0),-h.len,2*h.len),y2:clamp$2(Math.round(h.translate(t.y+a,!1,!0,!1,!0)||0),-h.len,2*h.len)};return[["width","x"],["height","y"]].forEach(function(u){var g=u[0],v=u[1],y=v+"1",m=v+"2",x=Math.abs(p[y]-p[m]),b=c&&c.lineWidth||0,$=Math.abs(p[y]+p[m])/2;c[g]&&c[g]<x&&(p[y]=$-c[g]/2-b/2,p[m]=$+c[g]/2+b/2),f&&(v==="y"&&(y=m,m=v+"1"),p[y]+=f,p[m]-=f)}),p},e.prototype.haloPath=function(t){if(!t)return[];var r=this.shapeArgs;return["M",r.x-t,r.y-t,"L",r.x-t,r.y+r.height+t,r.x+r.width+t,r.y+r.height+t,r.x+r.width+t,r.y-t,"Z"]},e.prototype.isValid=function(){return this.value!==1/0&&this.value!==-1/0},e}(ScatterPoint$1);extend$g(HeatmapPoint.prototype,{dataLabelOnNull:colorMapPointMixin.dataLabelOnNull,moveToTopOnHover:colorMapPointMixin.moveToTopOnHover});var __extends$d=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colorMapSeriesMixin$1=exports.colorMapSeriesMixin,Series$5=SeriesRegistry$1.series,_a$5=SeriesRegistry$1.seriesTypes,ColumnSeries$7=_a$5.column,ScatterSeries$1=_a$5.scatter,symbols$1=SVGRenderer.prototype.symbols,extend$f=Utilities.extend,fireEvent$1=Utilities.fireEvent,isNumber$6=Utilities.isNumber,merge$a=Utilities.merge,pick$c=Utilities.pick,HeatmapSeries$1=function(o){__extends$d(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.colorAxis=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.valueMax=NaN,t.valueMin=NaN,t}return e.prototype.drawPoints=function(){var t=this,r=this.options.marker||{};(r.enabled||this._hasPointMarkers)&&(Series$5.prototype.drawPoints.call(this),this.points.forEach(function(n){n.graphic&&(n.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(n)),t.options.borderRadius&&n.graphic.attr({r:t.options.borderRadius}),n.value===null&&n.graphic.addClass("highcharts-null-point"))}))},e.prototype.getExtremes=function(){var t=Series$5.prototype.getExtremes.call(this,this.valueData),r=t.dataMin,n=t.dataMax;return isNumber$6(r)&&(this.valueMin=r),isNumber$6(n)&&(this.valueMax=n),Series$5.prototype.getExtremes.call(this)},e.prototype.getValidPoints=function(t,r){return Series$5.prototype.getValidPoints.call(this,t,r,!0)},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.init=function(){var t;Series$5.prototype.init.apply(this,arguments),t=this.options,t.pointRange=pick$c(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,symbols$1.ellipse=symbols$1.circle},e.prototype.markerAttribs=function(t,r){var n=t.marker||{},s=this.options.marker||{},a,l,h=t.shapeArgs||{},c=t.hasImage,d={};return c?{x:t.plotX,y:t.plotY}:(r&&(a=s.states[r]||{},l=n.states&&n.states[r]||{},[["width","x"],["height","y"]].forEach(function(f){d[f[0]]=(l[f[0]]||a[f[0]]||h[f[0]])+(l[f[0]+"Plus"]||a[f[0]+"Plus"]||0),d[f[1]]=h[f[1]]+(h[f[0]]-d[f[0]])/2})),r?d:h)},e.prototype.pointAttribs=function(t,r){var n=this,s=Series$5.prototype.pointAttribs.call(n,t,r),a=n.options||{},l=n.chart.options.plotOptions||{},h=l.series||{},c=l.heatmap||{},d,f,p=t&&t.options.borderColor||a.borderColor||c.borderColor||h.borderColor,u=t&&t.options.borderWidth||a.borderWidth||c.borderWidth||h.borderWidth||s["stroke-width"];return s.stroke=t&&t.marker&&t.marker.lineColor||a.marker&&a.marker.lineColor||p||this.color,s["stroke-width"]=u,r&&(d=merge$a(a.states[r],a.marker&&a.marker.states[r],t&&t.options.states&&t.options.states[r]||{}),f=d.brightness,s.fill=d.color||Color.parse(s.fill).brighten(f||0).get(),s.stroke=d.lineColor),s},e.prototype.setClip=function(t){var r=this,n=r.chart;Series$5.prototype.setClip.apply(r,arguments),(r.options.clip!==!1||t)&&r.markerGroup.clip((t||r.clipBox)&&r.sharedClipKey?n.sharedClips[r.sharedClipKey]:n.clipRect)},e.prototype.translate=function(){var t=this,r=t.options,n=r.marker&&r.marker.symbol||"rect",s=symbols$1[n]?n:"rect",a=["circle","square"].indexOf(s)!==-1;t.generatePoints(),t.points.forEach(function(l){var h,c,d,f=l.getCellAttributes(),p={};p.x=Math.min(f.x1,f.x2),p.y=Math.min(f.y1,f.y2),p.width=Math.max(Math.abs(f.x2-f.x1),0),p.height=Math.max(Math.abs(f.y2-f.y1),0),d=l.hasImage=(l.marker&&l.marker.symbol||n||"").indexOf("url")===0,a&&(c=Math.abs(p.width-p.height),p.x=Math.min(f.x1,f.x2)+(p.width<p.height?0:c/2),p.y=Math.min(f.y1,f.y2)+(p.width<p.height?c/2:0),p.width=p.height=Math.min(p.width,p.height)),h={plotX:(f.x1+f.x2)/2,plotY:(f.y1+f.y2)/2,clientX:(f.x1+f.x2)/2,shapeType:"path",shapeArgs:merge$a(!0,p,{d:symbols$1[s](p.x,p.y,p.width,p.height)})},d&&(l.marker={width:p.width,height:p.height}),extend$f(l,h)}),fireEvent$1(t,"afterTranslate")},e.defaultOptions=merge$a(ScatterSeries$1.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:palette.neutralColor3,dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.value;return isNumber$6(r)?t(r,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}}),e}(ScatterSeries$1);extend$f(HeatmapSeries$1.prototype,{alignDataLabel:ColumnSeries$7.prototype.alignDataLabel,axisTypes:colorMapSeriesMixin$1.axisTypes,colorAttribs:colorMapSeriesMixin$1.colorAttribs,colorKey:colorMapSeriesMixin$1.colorKey,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:Series$5.prototype.getSymbol,parallelArrays:colorMapSeriesMixin$1.parallelArrays,pointArrayMap:["y","value"],pointClass:HeatmapPoint,trackerGroups:colorMapSeriesMixin$1.trackerGroups});SeriesRegistry$1.registerSeriesType("heatmap",HeatmapSeries$1);/**
 * @license Highmaps JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/heatmap
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G=H;G.ColorAxis=ColorAxis;ColorAxis.compose(G.Chart,G.Fx,G.Legend,G.Series);var color$2=Color.parse,extend$e=Utilities.extend,merge$9=Utilities.merge,SolidGaugeAxis;(function(o){var e={initDataClasses:function(r){var n=this.chart,s,a=0,l=this.options;this.dataClasses=s=[],r.dataClasses.forEach(function(h,c){var d;h=merge$9(h),s.push(h),h.color||(l.dataClassColor==="category"?(d=n.options.colors,h.color=d[a++],a===d.length&&(a=0)):h.color=color$2(l.minColor).tweenTo(color$2(l.maxColor),c/(r.dataClasses.length-1)))})},initStops:function(r){this.stops=r.stops||[[0,this.options.minColor],[1,this.options.maxColor]],this.stops.forEach(function(n){n.color=color$2(n[1])})},toColor:function(r,n){var s,a=this.stops,l,h,c,d=this.dataClasses,f,p;if(d){for(p=d.length;p--;)if(f=d[p],l=f.from,h=f.to,(typeof l>"u"||r>=l)&&(typeof h>"u"||r<=h)){c=f.color,n&&(n.dataClass=p);break}}else{for(this.logarithmic&&(r=this.val2lin(r)),s=1-(this.max-r)/(this.max-this.min),p=a.length;p--&&!(s>a[p][0]););l=a[p]||a[p+1],h=a[p+1]||l,s=1-(h[0]-s)/(h[0]-l[0]||1),c=l.color.tweenTo(h.color,s)}return c}};function t(r){extend$e(r,e)}o.init=t})(SolidGaugeAxis||(SolidGaugeAxis={}));const SolidGaugeAxis$1=SolidGaugeAxis;var _a$4=SVGRenderer.prototype,symbols=_a$4.symbols,arc=_a$4.symbols.arc;symbols.arc=function(o,e,t,r,n){var s=arc(o,e,t,r,n);if(n&&n.rounded){var a=n.r||t,l=(a-(n.innerR||0))/2,h=s[0],c=s[2];if(h[0]==="M"&&c[0]==="L"){var d=h[1],f=h[2],p=c[1],u=c[2],g=["A",l,l,0,1,1,d,f],v=["A",l,l,0,1,1,p,u];s[2]=v,s[4]=g}}return s};var __extends$c=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$3=SeriesRegistry$1.seriesTypes,GaugeSeries=_a$3.gauge,pieProto=_a$3.pie.prototype,clamp$1=Utilities.clamp,extend$d=Utilities.extend,isNumber$5=Utilities.isNumber,merge$8=Utilities.merge,pick$b=Utilities.pick,pInt=Utilities.pInt,solidGaugeOptions={colorByPoint:!0,dataLabels:{y:0}},SolidGaugeSeries=function(o){__extends$c(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.axis=void 0,t.yAxis=void 0,t.startAngleRad=void 0,t.thresholdAngleRad=void 0,t}return e.prototype.translate=function(){var t=this.yAxis;SolidGaugeAxis$1.init(t),!t.dataClasses&&t.options.dataClasses&&t.initDataClasses(t.options),t.initStops(t.options),GaugeSeries.prototype.translate.call(this)},e.prototype.drawPoints=function(){var t=this,r=t.yAxis,n=r.center,s=t.options,a=t.chart.renderer,l=s.overshoot,h=isNumber$5(l)?l/180*Math.PI:0,c;isNumber$5(s.threshold)&&(c=r.startAngleRad+r.translate(s.threshold,null,null,null,!0)),this.thresholdAngleRad=pick$b(c,r.startAngleRad),t.points.forEach(function(d){if(!d.isNull){var f=d.graphic,p=r.startAngleRad+r.translate(d.y,null,null,null,!0),u=pInt(pick$b(d.options.radius,s.radius,100))*n[2]/200,g=pInt(pick$b(d.options.innerRadius,s.innerRadius,60))*n[2]/200,v=void 0,y=void 0,m=r.toColor(d.y,d),x=Math.min(r.startAngleRad,r.endAngleRad),b=Math.max(r.startAngleRad,r.endAngleRad),$=void 0,S=void 0;m==="none"&&(m=d.color||t.color||"none"),m!=="none"&&(d.color=m),p=clamp$1(p,x-h,b+h),s.wrap===!1&&(p=clamp$1(p,x,b)),$=Math.min(p,t.thresholdAngleRad),S=Math.max(p,t.thresholdAngleRad),S-$>2*Math.PI&&(S=$+2*Math.PI),d.shapeArgs=v={x:n[0],y:n[1],r:u,innerR:g,start:$,end:S,rounded:s.rounded},d.startR=u,f?(y=v.d,f.animate(extend$d({fill:m},v)),y&&(v.d=y)):d.graphic=f=a.arc(v).attr({fill:m,"sweep-flag":0}).add(t.group),t.chart.styledMode||(s.linecap!=="square"&&f.attr({"stroke-linecap":"round","stroke-linejoin":"round"}),f.attr({stroke:s.borderColor||"none","stroke-width":s.borderWidth||0})),f&&f.addClass(d.getClassName(),!0)}})},e.prototype.animate=function(t){t||(this.startAngleRad=this.thresholdAngleRad,pieProto.animate.call(this,t))},e.defaultOptions=merge$8(GaugeSeries.defaultOptions,solidGaugeOptions),e}(GaugeSeries);extend$d(SolidGaugeSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("solidgauge",SolidGaugeSeries);var TreemapAlgorithmGroup=function(){function o(e,t,r,n){this.height=e,this.width=t,this.plot=n,this.direction=r,this.startDirection=r,this.total=0,this.nW=0,this.lW=0,this.nH=0,this.lH=0,this.elArr=[],this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(s,a){return Math.max(s/a,a/s)}}}return o.prototype.addElement=function(e){this.lP.total=this.elArr[this.elArr.length-1],this.total=this.total+e,this.direction===0?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH)),this.elArr.push(e)},o.prototype.reset=function(){this.nW=0,this.lW=0,this.elArr=[],this.total=0},o}(),isFn$1=function(o){return typeof o=="function"},draw=function(e){var t=this,r=e.animatableAttribs,n=e.onComplete,s=e.css,a=e.renderer,l=this.series&&this.series.chart.hasRendered?void 0:this.series&&this.series.options.animation,h=this.graphic;if(this.shouldDraw())h||(this.graphic=h=a[e.shapeType](e.shapeArgs).add(e.group)),h.css(s).attr(e.attribs).animate(r,e.isNew?!1:l,n);else if(h){var c=function(){t.graphic=h=h&&h.destroy(),isFn$1(n)&&n()};Object.keys(r).length?h.animate(r,void 0,function(){c()}):c()}},drawPoint=function(e){var t=this,r=e.attribs=e.attribs||{};r.class=t.getClassName(),draw.call(t,e)},drawPointModule={draw,drawPoint,isFn:isFn$1},__extends$b=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Point=SeriesRegistry$1.series.prototype.pointClass,_a$2=SeriesRegistry$1.seriesTypes,PiePoint$1=_a$2.pie.prototype.pointClass,ScatterPoint=_a$2.scatter.prototype.pointClass,extend$c=Utilities.extend,isNumber$4=Utilities.isNumber,pick$a=Utilities.pick,TreemapPoint=function(o){__extends$b(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.name=void 0,t.node=void 0,t.options=void 0,t.series=void 0,t.value=void 0,t}return e.prototype.getClassName=function(){var t=Point.prototype.getClassName.call(this),r=this.series,n=r.options;return this.node.level<=r.nodeMap[r.rootNode].level?t+=" highcharts-above-level":!this.node.isLeaf&&!pick$a(n.interactByLeaf,!n.allowTraversingTree)?t+=" highcharts-internal-node-interactive":this.node.isLeaf||(t+=" highcharts-internal-node"),t},e.prototype.isValid=function(){return!!(this.id||isNumber$4(this.value))},e.prototype.setState=function(t){Point.prototype.setState.call(this,t),this.graphic&&this.graphic.attr({zIndex:t==="hover"?1:0})},e.prototype.shouldDraw=function(){return isNumber$4(this.plotY)&&this.y!==null},e}(ScatterPoint);extend$c(TreemapPoint.prototype,{draw:drawPointModule.drawPoint,setVisible:PiePoint$1.prototype.setVisible});var objectEach$1=Utilities.objectEach,TreemapUtilities;(function(o){o.AXIS_MAX=100;function e(n){return typeof n=="boolean"}o.isBoolean=e;function t(n,s,a){a=a||this,objectEach$1(n,function(l,h){s.call(a,l,h,n)})}o.eachObject=t;function r(n,s,a){a===void 0&&(a=this);var l;l=s.call(a,n),l!==!1&&r(l,s,a)}o.recursive=r})(TreemapUtilities||(TreemapUtilities={}));const TreemapUtilities$1=TreemapUtilities;var extend$b=Utilities.extend,isArray$1=Utilities.isArray,isNumber$3=Utilities.isNumber,isObject$3=Utilities.isObject,merge$7=Utilities.merge,pick$9=Utilities.pick,isBoolean=function(o){return typeof o=="boolean"},isFn=function(o){return typeof o=="function"},setTreeValues=function o(e,t){var r=t.before,n=t.idRoot,s=t.mapIdToNode,a=s[n],l=isBoolean(t.levelIsConstant)?t.levelIsConstant:!0,h=t.points,c=h[e.i],d=c&&c.options||{},f=0,p=[],u;return e.levelDynamic=e.level-(l?0:a.level),e.name=pick$9(c&&c.name,""),e.visible=n===e.id||(isBoolean(t.visible)?t.visible:!1),isFn(r)&&(e=r(e,t)),e.children.forEach(function(g,v){var y=extend$b({},t);extend$b(y,{index:v,siblings:e.children.length,visible:e.visible}),g=o(g,y),p.push(g),g.visible&&(f+=g.val)}),u=pick$9(d.value,f),e.visible=u>=0&&(f>0||e.visible),e.children=p,e.childrenTotal=f,e.isLeaf=e.visible&&!f,e.val=u,e},getColor$1=function(e,t){var r=t.index,n=t.mapOptionsToLevel,s=t.parentColor,a=t.parentColorIndex,l=t.series,h=t.colors,c=t.siblings,d=l.points,f,p=l.chart.options.chart,u,g,v,y,m,x;function b($){var S=g&&g.colorVariation;return S&&S.key==="brightness"?Color.parse($).brighten(S.to*(r/c)).get():$}return e&&(u=d[e.i],g=n[e.level]||{},f=u&&g.colorByPoint,f&&(y=u.index%(h?h.length:p.colorCount),v=h&&h[y]),l.chart.styledMode||(m=pick$9(u&&u.options.color,g&&g.color,v,s&&b(s),l.color)),x=pick$9(u&&u.options.colorIndex,g&&g.colorIndex,y,a,t.colorIndex)),{color:m,colorIndex:x}},getLevelOptions$2=function(e){var t=null,r,n,s,a,l,h;if(isObject$3(e))for(t={},a=isNumber$3(e.from)?e.from:1,h=e.levels,n={},r=isObject$3(e.defaults)?e.defaults:{},isArray$1(h)&&(n=h.reduce(function(c,d){var f,p,u;return isObject$3(d)&&isNumber$3(d.level)&&(u=merge$7({},d),p=isBoolean(u.levelIsConstant)?u.levelIsConstant:r.levelIsConstant,delete u.levelIsConstant,delete u.level,f=d.level+(p?0:a-1),isObject$3(c[f])?extend$b(c[f],u):c[f]=u),c},{})),l=isNumber$3(e.to)?e.to:1,s=0;s<=l;s++)t[s]=merge$7({},r,isObject$3(n[s])?n[s]:{});return t},updateRootId$1=function(o){var e,t;return isObject$3(o)&&(t=isObject$3(o.options)?o.options:{},e=pick$9(o.rootNode,t.rootId,""),isObject$3(o.userOptions)&&(o.userOptions.rootId=e),o.rootNode=e),e},result={getColor:getColor$1,getLevelOptions:getLevelOptions$2,setTreeValues,updateRootId:updateRootId$1},Series$4=SeriesRegistry$1.series,addEvent$4=Utilities.addEvent,extend$a=Utilities.extend,treemapAxisDefaultValues=!1;addEvent$4(Series$4,"afterBindAxes",function(){var o=this,e=o.xAxis,t=o.yAxis,r;e&&t&&(o.is("treemap")?(r={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:TreemapUtilities$1.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]},extend$a(t.options,r),extend$a(e.options,r),treemapAxisDefaultValues=!0):treemapAxisDefaultValues&&(t.setOptions(t.userOptions),e.setOptions(e.userOptions),treemapAxisDefaultValues=!1))});var __extends$a=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$1=Color.parse,colorMapSeriesMixin=exports.colorMapSeriesMixin,noop=H.noop,Series$3=SeriesRegistry$1.series,_a$1=SeriesRegistry$1.seriesTypes,ColumnSeries$6=_a$1.column,HeatmapSeries=_a$1.heatmap,ScatterSeries=_a$1.scatter,getColor=result.getColor,getLevelOptions$1=result.getLevelOptions,updateRootId=result.updateRootId,addEvent$3=Utilities.addEvent,correctFloat$1=Utilities.correctFloat,defined$6=Utilities.defined,error=Utilities.error,extend$9=Utilities.extend,fireEvent=Utilities.fireEvent,isArray=Utilities.isArray,isObject$2=Utilities.isObject,isString=Utilities.isString,merge$6=Utilities.merge,pick$8=Utilities.pick,stableSort$1=Utilities.stableSort,TreemapSeries=function(o){__extends$a(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.axisRatio=void 0,t.data=void 0,t.mapOptionsToLevel=void 0,t.nodeMap=void 0,t.options=void 0,t.points=void 0,t.rootNode=void 0,t.tree=void 0,t}return e.prototype.algorithmCalcPoints=function(t,r,n,s){var a,l,h,c,d=n.lW,f=n.lH,p=n.plot,u,g=0,v=n.elArr.length-1;r?(d=n.nW,f=n.nH):u=n.elArr[n.elArr.length-1],n.elArr.forEach(function(y){(r||g<v)&&(n.direction===0?(a=p.x,l=p.y,h=d,c=y/h):(a=p.x,l=p.y,c=f,h=y/c),s.push({x:a,y:l,width:h,height:correctFloat$1(c)}),n.direction===0?p.y=p.y+c:p.x=p.x+h),g=g+1}),n.reset(),n.direction===0?n.width=n.width-d:n.height=n.height-f,p.y=p.parent.y+(p.parent.height-n.height),p.x=p.parent.x+(p.parent.width-n.width),t&&(n.direction=1-n.direction),r||n.addElement(u)},e.prototype.algorithmFill=function(t,r,n){var s=[],a,l=r.direction,h=r.x,c=r.y,d=r.width,f=r.height,p,u,g,v;return n.forEach(function(y){a=r.width*r.height*(y.val/r.val),p=h,u=c,l===0?(v=f,g=a/v,d=d-g,h=h+g):(g=d,v=a/g,f=f-v,c=c+v),s.push({x:p,y:u,width:g,height:v}),t&&(l=1-l)}),s},e.prototype.algorithmLowAspectRatio=function(t,r,n){var s=[],a=this,l,h={x:r.x,y:r.y,parent:r},c=r.direction,d=0,f=n.length-1,p=new TreemapAlgorithmGroup(r.height,r.width,c,h);return n.forEach(function(u){l=r.width*r.height*(u.val/r.val),p.addElement(l),p.lP.nR>p.lP.lR&&a.algorithmCalcPoints(t,!1,p,s,h),d===f&&a.algorithmCalcPoints(t,!0,p,s,h),d=d+1}),s},e.prototype.alignDataLabel=function(t,r,n){var s=n.style;s&&!defined$6(s.textOverflow)&&r.text&&r.getBBox().width>r.text.textWidth&&r.css({textOverflow:"ellipsis",width:s.width+="px"}),ColumnSeries$6.prototype.alignDataLabel.apply(this,arguments),t.dataLabel&&t.dataLabel.attr({zIndex:(t.node.zIndex||0)+1})},e.prototype.buildNode=function(t,r,n,s,a){var l=this,h=[],c=l.points[r],d=0,f,p;return(s[t]||[]).forEach(function(u){p=l.buildNode(l.points[u].id,u,n+1,s,t),d=Math.max(p.height+1,d),h.push(p)}),f={id:t,i:r,children:h,height:d,level:n,parent:a,visible:!1},l.nodeMap[f.id]=f,c&&(c.node=f),f},e.prototype.calculateChildrenAreas=function(t,r){var n=this,s=n.options,a=n.mapOptionsToLevel,l=a[t.level+1],h=pick$8(n[l&&l.layoutAlgorithm]&&l.layoutAlgorithm,s.layoutAlgorithm),c=s.alternateStartingDirection,d=[],f;f=t.children.filter(function(p){return!p.ignore}),l&&l.layoutStartingDirection&&(r.direction=l.layoutStartingDirection==="vertical"?0:1),d=n[h](r,f),f.forEach(function(p,u){var g=d[u];p.values=merge$6(g,{val:p.childrenTotal,direction:c?1-r.direction:r.direction}),p.pointValues=merge$6(g,{x:g.x/n.axisRatio,y:TreemapUtilities$1.AXIS_MAX-g.y-g.height,width:g.width/n.axisRatio}),p.children.length&&n.calculateChildrenAreas(p,p.values)})},e.prototype.drawDataLabels=function(){var t=this,r=t.mapOptionsToLevel,n=t.points.filter(function(l){return l.node.visible}),s,a;n.forEach(function(l){a=r[l.node.level],s={style:{}},l.node.isLeaf||(s.enabled=!1),a&&a.dataLabels&&(s=merge$6(s,a.dataLabels),t._hasPointLabels=!0),l.shapeArgs&&(s.style.width=l.shapeArgs.width,l.dataLabel&&l.dataLabel.css({width:l.shapeArgs.width+"px"})),l.dlOptions=merge$6(s,l.options.dataLabels)}),Series$3.prototype.drawDataLabels.call(this)},e.prototype.drawPoints=function(){var t=this,r=t.chart,n=r.renderer,s=t.points,a=r.styledMode,l=t.options,h=a?{}:l.shadow,c=l.borderRadius,d=r.pointCount<l.animationLimit,f=l.allowTraversingTree;s.forEach(function(p){var u=p.node.levelDynamic,g={},v={},y={},m="level-group-"+p.node.level,x=!!p.graphic,b=d&&x,$=p.shapeArgs;p.shouldDraw()&&(p.isInside=!0,c&&(v.r=c),merge$6(!0,b?g:v,x?$:{},a?{}:t.pointAttribs(p,p.selected?"select":void 0)),t.colorAttribs&&a&&extend$9(y,t.colorAttribs(p)),t[m]||(t[m]=n.g(m).attr({zIndex:1e3-(u||0)}).add(t.group),t[m].survive=!0)),p.draw({animatableAttribs:g,attribs:v,css:y,group:t[m],renderer:n,shadow:h,shapeArgs:$,shapeType:"rect"}),f&&p.graphic&&(p.drillId=l.interactByLeaf?t.drillToByLeaf(p):t.drillToByGroup(p))})},e.prototype.drillToByGroup=function(t){var r=this,n=!1;return t.node.level-r.nodeMap[r.rootNode].level===1&&!t.node.isLeaf&&(n=t.id),n},e.prototype.drillToByLeaf=function(t){var r=this,n=!1,s;if(t.node.parent!==r.rootNode&&t.node.isLeaf)for(s=t.node;!n;)s=r.nodeMap[s.parent],s.parent===r.rootNode&&(n=s.id);return n},e.prototype.drillToNode=function(t,r){error(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"}),this.setRootNode(t,r)},e.prototype.drillUp=function(){var t=this,r=t.nodeMap[t.rootNode];r&&isString(r.parent)&&t.setRootNode(r.parent,!0,{trigger:"traverseUpButton"})},e.prototype.getExtremes=function(){var t=Series$3.prototype.getExtremes.call(this,this.colorValueData),r=t.dataMin,n=t.dataMax;return this.valueMin=r,this.valueMax=n,Series$3.prototype.getExtremes.call(this)},e.prototype.getListOfParents=function(t,r){var n=isArray(t)?t:[],s=isArray(r)?r:[],a=n.reduce(function(l,h,c){var d=pick$8(h.parent,"");return typeof l[d]>"u"&&(l[d]=[]),l[d].push(c),l},{"":[]});return TreemapUtilities$1.eachObject(a,function(l,h,c){h!==""&&s.indexOf(h)===-1&&(l.forEach(function(d){c[""].push(d)}),delete c[h])}),a},e.prototype.getTree=function(){var t=this,r=this.data.map(function(s){return s.id}),n=t.getListOfParents(this.data,r);return t.nodeMap={},t.buildNode("",-1,0,n)},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.init=function(t,r){var n=this,s;colorMapSeriesMixin&&(this.colorAttribs=colorMapSeriesMixin.colorAttribs),s=addEvent$3(n,"setOptions",function(a){var l=a.userOptions;defined$6(l.allowDrillToNode)&&!defined$6(l.allowTraversingTree)&&(l.allowTraversingTree=l.allowDrillToNode,delete l.allowDrillToNode),defined$6(l.drillUpButton)&&!defined$6(l.traverseUpButton)&&(l.traverseUpButton=l.drillUpButton,delete l.drillUpButton)}),Series$3.prototype.init.call(n,t,r),delete n.opacity,n.eventsToUnbind.push(s),n.options.allowTraversingTree&&n.eventsToUnbind.push(addEvent$3(n,"click",n.onClickDrillToNode))},e.prototype.onClickDrillToNode=function(t){var r=this,n=t.point,s=n&&n.drillId;isString(s)&&(n.setState(""),r.setRootNode(s,!0,{trigger:"click"}))},e.prototype.pointAttribs=function(t,r){var n=this,s=isObject$2(n.mapOptionsToLevel)?n.mapOptionsToLevel:{},a=t&&s[t.node.level]||{},l=this.options,h,c=r&&l.states[r]||{},d=t&&t.getClassName()||"",f;return h={stroke:t&&t.borderColor||a.borderColor||c.borderColor||l.borderColor,"stroke-width":pick$8(t&&t.borderWidth,a.borderWidth,c.borderWidth,l.borderWidth),dashstyle:t&&t.borderDashStyle||a.borderDashStyle||c.borderDashStyle||l.borderDashStyle,fill:t&&t.color||this.color},d.indexOf("highcharts-above-level")!==-1?(h.fill="none",h["stroke-width"]=0):d.indexOf("highcharts-internal-node-interactive")!==-1?(f=pick$8(c.opacity,l.opacity),h.fill=color$1(h.fill).setOpacity(f).get(),h.cursor="pointer"):d.indexOf("highcharts-internal-node")!==-1?h.fill="none":r&&(h.fill=color$1(h.fill).brighten(c.brightness).get()),h},e.prototype.renderTraverseUpButton=function(t){var r=this,n=r.nodeMap,s=n[t],a=s.name,l=r.options.traverseUpButton,h=pick$8(l.text,a,"◁ Back"),c,d;t===""||r.is("sunburst")&&r.tree.children.length===1&&t===r.tree.children[0].id?r.drillUpButton&&(r.drillUpButton=r.drillUpButton.destroy()):this.drillUpButton?(this.drillUpButton.placed=!1,this.drillUpButton.attr({text:h}).align()):(c=l.theme,d=c&&c.states,this.drillUpButton=this.chart.renderer.button(h,0,0,function(){r.drillUp()},c,d&&d.hover,d&&d.select).addClass("highcharts-drillup-button").attr({align:l.position.align,zIndex:7}).add().align(l.position,!1,l.relativeTo||"plotBox"))},e.prototype.setColorRecursive=function(t,r,n,s,a){var l=this,h=l&&l.chart,c=h&&h.options&&h.options.colors,d,f;t&&(d=getColor(t,{colors:c,index:s,mapOptionsToLevel:l.mapOptionsToLevel,parentColor:r,parentColorIndex:n,series:l,siblings:a}),f=l.points[t.i],f&&(f.color=d.color,f.colorIndex=d.colorIndex),(t.children||[]).forEach(function(p,u){l.setColorRecursive(p,d.color,d.colorIndex,u,t.children.length)}))},e.prototype.setPointValues=function(){var t=this,r=t.points,n=t.xAxis,s=t.yAxis,a=t.chart.styledMode,l=function(h){return a?0:(t.pointAttribs(h)["stroke-width"]||0)%2/2};r.forEach(function(h){var c=h.node,d=c.pointValues,f=c.visible;if(d&&f){var p=d.height,u=d.width,g=d.x,v=d.y,y=l(h),m=Math.round(n.toPixels(g,!0))-y,x=Math.round(n.toPixels(g+u,!0))-y,b=Math.round(s.toPixels(v,!0))-y,$=Math.round(s.toPixels(v+p,!0))-y,S={x:Math.min(m,x),y:Math.min(b,$),width:Math.abs(x-m),height:Math.abs($-b)};h.plotX=S.x+S.width/2,h.plotY=S.y+S.height/2,h.shapeArgs=S}else delete h.plotX,delete h.plotY})},e.prototype.setRootNode=function(t,r,n){var s=this,a=extend$9({newRootId:t,previousRootId:s.rootNode,redraw:pick$8(r,!0),series:s},n),l=function(h){var c=h.series;c.idPreviousRoot=h.previousRootId,c.rootNode=h.newRootId,c.isDirty=!0,h.redraw&&c.chart.redraw()};fireEvent(s,"setRootNode",a,l)},e.prototype.setState=function(t){this.options.inactiveOtherPoints=!0,Series$3.prototype.setState.call(this,t,!1),this.options.inactiveOtherPoints=!1},e.prototype.setTreeValues=function(t){var r=this,n=r.options,s=r.rootNode,a=r.nodeMap,l=a[s],h=TreemapUtilities$1.isBoolean(n.levelIsConstant)?n.levelIsConstant:!0,c=0,d=[],f,p=r.points[t.i];return t.children.forEach(function(u){u=r.setTreeValues(u),d.push(u),u.ignore||(c+=u.val)}),stableSort$1(d,function(u,g){return(u.sortIndex||0)-(g.sortIndex||0)}),f=pick$8(p&&p.options.value,c),p&&(p.value=f),extend$9(t,{children:d,childrenTotal:c,ignore:!(pick$8(p&&p.visible,!0)&&f>0),isLeaf:t.visible&&!c,levelDynamic:t.level-(h?0:l.level),name:pick$8(p&&p.name,""),sortIndex:pick$8(p&&p.sortIndex,-f),val:f}),t},e.prototype.sliceAndDice=function(t,r){return this.algorithmFill(!0,t,r)},e.prototype.squarified=function(t,r){return this.algorithmLowAspectRatio(!0,t,r)},e.prototype.strip=function(t,r){return this.algorithmLowAspectRatio(!1,t,r)},e.prototype.stripes=function(t,r){return this.algorithmFill(!1,t,r)},e.prototype.translate=function(){var t=this,r=t.options,n=updateRootId(t),s,a,l,h,c;Series$3.prototype.translate.call(t),h=t.tree=t.getTree(),s=t.nodeMap[n],n!==""&&(!s||!s.children.length)&&(t.setRootNode("",!1),n=t.rootNode,s=t.nodeMap[n]),t.renderTraverseUpButton(n),t.mapOptionsToLevel=getLevelOptions$1({from:s.level+1,levels:r.levels,to:h.height,defaults:{levelIsConstant:t.options.levelIsConstant,colorByPoint:r.colorByPoint}}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode],function(d){var f=!1,p=d.parent;return d.visible=!0,(p||p==="")&&(f=t.nodeMap[p]),f}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode].children,function(d){var f=!1;return d.forEach(function(p){p.visible=!0,p.children.length&&(f=(f||[]).concat(p.children))}),f}),t.setTreeValues(h),t.axisRatio=t.xAxis.len/t.yAxis.len,t.nodeMap[""].pointValues=a={x:0,y:0,width:TreemapUtilities$1.AXIS_MAX,height:TreemapUtilities$1.AXIS_MAX},t.nodeMap[""].values=l=merge$6(a,{width:a.width*t.axisRatio,direction:r.layoutStartingDirection==="vertical"?0:1,val:h.val}),t.calculateChildrenAreas(h,l),!t.colorAxis&&!r.colorByPoint&&t.setColorRecursive(t.tree),r.allowTraversingTree&&(c=s.pointValues,t.xAxis.setExtremes(c.x,c.x+c.width,!1),t.yAxis.setExtremes(c.y,c.y+c.height,!1),t.xAxis.setScale(),t.yAxis.setScale()),t.setPointValues()},e.defaultOptions=merge$6(ScatterSeries.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var t=this&&this.point?this.point:{},r=isString(t.name)?t.name:"";return r},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,drillUpButton:{position:{align:"right",x:-10,y:10}},traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:palette.neutralColor10,borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:palette.neutralColor40,brightness:HeatmapSeries?0:.1,halo:!1,opacity:.75,shadow:!1}}}),e}(ScatterSeries);extend$9(TreemapSeries.prototype,{buildKDTree:noop,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:noop,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:TreemapPoint,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:TreemapUtilities$1.recursive}});SeriesRegistry$1.registerSeriesType("treemap",TreemapSeries);var getOptions=DefaultOptions.getOptions,addEvent$2=Utilities.addEvent,extend$8=Utilities.extend,chartPrototype=Chart$1.prototype,defaultOptions=getOptions();extend$8(defaultOptions.lang,{noData:"No data to display"});defaultOptions.noData={attr:{zIndex:1},position:{x:0,y:0,align:"center",verticalAlign:"middle"},style:{fontWeight:"bold",fontSize:"12px",color:palette.neutralColor60}};chartPrototype.showNoData=function(o){var e=this,t=e.options,r=o||t&&t.lang.noData||"",n=t&&(t.noData||{});e.renderer&&(e.noDataLabel||(e.noDataLabel=e.renderer.label(r,0,0,void 0,void 0,void 0,n.useHTML,void 0,"no-data").add()),e.styledMode||e.noDataLabel.attr(AST.filterUserAttributes(n.attr||{})).css(n.style||{}),e.noDataLabel.align(extend$8(e.noDataLabel.getBBox(),n.position||{}),!1,"plotBox"))};chartPrototype.hideNoData=function(){var o=this;o.noDataLabel&&(o.noDataLabel=o.noDataLabel.destroy())};chartPrototype.hasData=function(){for(var o=this,e=o.series||[],t=e.length;t--;)if(e[t].hasData()&&!e[t].options.isInternal)return!0;return o.loadingShown};addEvent$2(Chart$1,"render",function(){this.hasData()?this.hideNoData():this.showNoData()});var defined$5=Utilities.defined,extend$7=Utilities.extend,find$2=Utilities.find,pick$7=Utilities.pick,NodesMixin=H.NodesMixin={createNode:function(o){function e(s,a){return find$2(s,function(l){return l.id===a})}var t=e(this.nodes,o),r=this.pointClass,n;return t||(n=this.options.nodes&&e(this.options.nodes,o),t=new r().init(this,extend$7({className:"highcharts-node",isNode:!0,id:o,y:1},n)),t.linksTo=[],t.linksFrom=[],t.formatPrefix="node",t.name=t.name||t.options.id||"",t.mass=pick$7(t.options.mass,t.options.marker&&t.options.marker.radius,this.options.marker&&this.options.marker.radius,4),t.getSum=function(){var s=0,a=0;return t.linksTo.forEach(function(l){s+=l.weight}),t.linksFrom.forEach(function(l){a+=l.weight}),Math.max(s,a)},t.offset=function(s,a){for(var l=0,h=0;h<t[a].length;h++){if(t[a][h]===s)return l;l+=t[a][h].weight}},t.hasShape=function(){var s=0;return t.linksTo.forEach(function(a){a.outgoing&&s++}),!t.linksTo.length||s!==t.linksTo.length},this.nodes.push(t)),t},generatePoints:function(){var o=this.chart,e={};Series$e.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){defined$5(t.from)&&(e[t.from]||(e[t.from]=this.createNode(t.from)),e[t.from].linksFrom.push(t),t.fromNode=e[t.from],o.styledMode?t.colorIndex=pick$7(t.options.colorIndex,e[t.from].colorIndex):t.color=t.options.color||e[t.from].color),defined$5(t.to)&&(e[t.to]||(e[t.to]=this.createNode(t.to)),e[t.to].linksTo.push(t),t.toNode=e[t.to]),t.name=t.name||t.id},this),this.nodeLookup=e},setData:function(){this.nodes&&(this.nodes.forEach(function(o){o.destroy()}),this.nodes.length=0),Series$e.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),Series$e.prototype.destroy.apply(this,arguments)},setNodeState:function(o){var e=arguments,t=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];o!=="select"&&t.forEach(function(r){r&&r.series&&(Point$2.prototype.setState.apply(r,e),r.isNode||(r.fromNode.graphic&&Point$2.prototype.setState.apply(r.fromNode,e),r.toNode&&r.toNode.graphic&&Point$2.prototype.setState.apply(r.toNode,e)))}),Point$2.prototype.setState.apply(this,e)}},__extends$9=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$5=SeriesRegistry$1.seriesTypes.column,defined$4=Utilities.defined,extend$6=Utilities.extend,SankeyPoint$1=function(o){__extends$9(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.className=void 0,t.fromNode=void 0,t.level=void 0,t.linkBase=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.mass=void 0,t.nodeX=void 0,t.nodeY=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return e.prototype.applyOptions=function(t,r){return Point$2.prototype.applyOptions.call(this,t,r),defined$4(this.options.level)&&(this.options.column=this.column=this.options.level),this},e.prototype.getClassName=function(){return(this.isNode?"highcharts-node ":"highcharts-link ")+Point$2.prototype.getClassName.call(this)},e.prototype.isValid=function(){return this.isNode||typeof this.weight=="number"},e}(ColumnSeries$5.prototype.pointClass);extend$6(SankeyPoint$1.prototype,{setState:NodesMixin.setNodeState});var __extends$8=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Series$2=SeriesRegistry$1.series,ColumnSeries$4=SeriesRegistry$1.seriesTypes.column,getLevelOptions=result.getLevelOptions,defined$3=Utilities.defined,extend$5=Utilities.extend,find$1=Utilities.find,isObject$1=Utilities.isObject,merge$5=Utilities.merge,pick$6=Utilities.pick,relativeLength$1=Utilities.relativeLength,stableSort=Utilities.stableSort,SankeySeries$1=function(o){__extends$8(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.colDistance=void 0,t.data=void 0,t.group=void 0,t.nodeLookup=void 0,t.nodePadding=void 0,t.nodes=void 0,t.nodeWidth=void 0,t.options=void 0,t.points=void 0,t.translationFactor=void 0,t}return e.getDLOptions=function(t){var r=isObject$1(t.optionsPoint)?t.optionsPoint.dataLabels:{},n=isObject$1(t.level)?t.level.dataLabels:{},s=merge$5({style:{}},n,r);return s},e.prototype.createNodeColumn=function(){var t=this,r=this.chart,n=[];return n.sum=function(){return this.reduce(function(s,a){return s+a.getSum()},0)},n.offset=function(s,a){for(var l=0,h,c=t.nodePadding,d=0;d<n.length;d++){var f=n[d].getSum(),p=Math.max(f*a,t.options.minLinkWidth);if(f?h=p+c:h=0,n[d]===s)return{relativeTop:l+relativeLength$1(s.options.offset||0,h)};l+=h}},n.top=function(s){var a=t.nodePadding,l=this.reduce(function(h,c){h>0&&(h+=a);var d=Math.max(c.getSum()*s,t.options.minLinkWidth);return h+=d,h},0);return(r.plotSizeY-l)/2},n},e.prototype.createNodeColumns=function(){var t=[];this.nodes.forEach(function(n){var s=-1,a;if(!defined$3(n.options.column))if(n.linksTo.length===0)n.column=0;else{for(var l=0;l<n.linksTo.length;l++){var h=n.linksTo[l];h.fromNode.column>s&&h.fromNode!==n&&(a=h.fromNode,s=a.column)}if(n.column=s+1,a&&a.options.layout==="hanging"){n.hangsFrom=a;var c=-1;find$1(a.linksFrom,function(d,f){var p=d.toNode===n;return p&&(c=f),p}),n.column+=c}}t[n.column]||(t[n.column]=this.createNodeColumn()),t[n.column].push(n)},this);for(var r=0;r<t.length;r++)typeof t[r]>"u"&&(t[r]=this.createNodeColumn());return t},e.prototype.generatePoints=function(){NodesMixin.generatePoints.apply(this,arguments);function t(r,n){typeof r.level>"u"&&(r.level=n,r.linksFrom.forEach(function(s){s.toNode&&t(s.toNode,n+1)}))}this.orderNodes&&(this.nodes.filter(function(r){return r.linksTo.length===0}).forEach(function(r){t(r,0)}),stableSort(this.nodes,function(r,n){return r.level-n.level}))},e.prototype.getNodePadding=function(){var t=this.options.nodePadding||0;if(this.nodeColumns){var r=this.nodeColumns.reduce(function(n,s){return Math.max(n,s.length)},0);r*t>this.chart.plotSizeY&&(t=this.chart.plotSizeY/r)}return t},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.pointAttribs=function(t,r){if(!t)return{};var n=this,s=t.isNode?t.level:t.fromNode.level,a=n.mapOptionsToLevel[s||0]||{},l=t.options,h=a.states&&a.states[r||""]||{},c=["colorByPoint","borderColor","borderWidth","linkOpacity"].reduce(function(f,p){return f[p]=pick$6(h[p],l[p],a[p],n.options[p]),f},{}),d=pick$6(h.color,l.color,c.colorByPoint?t.color:a.color);return t.isNode?{fill:d,stroke:c.borderColor,"stroke-width":c.borderWidth}:{fill:Color.parse(d).setOpacity(c.linkOpacity).get()}},e.prototype.render=function(){var t=this.points;this.points=this.points.concat(this.nodes||[]),ColumnSeries$4.prototype.render.call(this),this.points=t},e.prototype.translate=function(){var t=this,r=function(c){for(var d=c.slice(),f=t.options.minLinkWidth||0,p,u=0,g,v=s.plotSizeY-a.borderWidth-(c.length-1)*n.nodePadding;c.length;){for(u=v/c.sum(),p=!1,g=c.length;g--;)c[g].getSum()*u<f&&(c.splice(g,1),v-=f,p=!0);if(!p)break}return c.length=0,d.forEach(function(y){return c.push(y)}),u};this.processedXData||this.processData(),this.generatePoints(),this.nodeColumns=this.createNodeColumns(),this.nodeWidth=relativeLength$1(this.options.nodeWidth,this.chart.plotSizeX);var n=this,s=this.chart,a=this.options,l=this.nodeWidth,h=this.nodeColumns;this.nodePadding=this.getNodePadding(),this.translationFactor=h.reduce(function(c,d){return Math.min(c,r(d))},1/0),this.colDistance=(s.plotSizeX-l-a.borderWidth)/Math.max(1,h.length-1),n.mapOptionsToLevel=getLevelOptions({from:1,levels:a.levels,to:h.length-1,defaults:{borderColor:a.borderColor,borderRadius:a.borderRadius,borderWidth:a.borderWidth,color:n.color,colorByPoint:a.colorByPoint,levelIsConstant:!0,linkColor:a.linkColor,linkLineWidth:a.linkLineWidth,linkOpacity:a.linkOpacity,states:a.states}}),h.forEach(function(c){c.forEach(function(d){n.translateNode(d,c)})},this),this.nodes.forEach(function(c){c.linksFrom.forEach(function(d){(d.weight||d.isNull)&&d.to&&(n.translateLink(d),d.allowShadow=!1)})})},e.prototype.translateLink=function(t){var r=function(V,j){var K=V.offset(t,j)*l,ot=Math.min(V.nodeY+K,V.nodeY+(V.shapeArgs&&V.shapeArgs.height||0)-h);return ot},n=t.fromNode,s=t.toNode,a=this.chart,l=this.translationFactor,h=Math.max(t.weight*l,this.options.minLinkWidth),c=this.options,d=(a.inverted?-this.colDistance:this.colDistance)*c.curveFactor,f=r(n,"linksFrom"),p=r(s,"linksTo"),u=n.nodeX,g=this.nodeWidth,v=s.column*this.colDistance,y=t.outgoing,m=v>u+g;if(a.inverted&&(f=a.plotSizeY-f,p=(a.plotSizeY||0)-p,v=a.plotSizeX-v,g=-g,h=-h,m=u>v),t.shapeType="path",t.linkBase=[f,f+h,p,p+h],m&&typeof p=="number")t.shapeArgs={d:[["M",u+g,f],["C",u+g+d,f,v-d,p,v,p],["L",v+(y?g:0),p+h/2],["L",v,p+h],["C",v-d,p+h,u+g+d,f+h,u+g,f+h],["Z"]]};else if(typeof p=="number"){var x=20,b=a.plotHeight-f-h,$=v-x-h,S=v-x,k=v,A=u+g,M=A+x,P=M+h,E=f,T=f+h,O=T+x,C=O+b,I=C+x,L=I+h,D=p,N=D+h,B=N+x,X=T-h*.7,W=I+h*.7,F=N-h*.7,U=k-h*.7,z=A+h*.7;t.shapeArgs={d:[["M",A,E],["C",z,E,P,X,P,O],["L",P,C],["C",P,W,z,L,A,L],["L",k,L],["C",U,L,$,W,$,C],["L",$,B],["C",$,F,U,D,k,D],["L",k,N],["C",S,N,S,N,S,B],["L",S,C],["C",S,I,S,I,k,I],["L",A,I],["C",M,I,M,I,M,C],["L",M,O],["C",M,T,M,T,A,T],["Z"]]}}t.dlBox={x:u+(v-u+g)/2,y:f+(p-f)/2,height:h,width:0},t.tooltipPos=a.inverted?[a.plotSizeY-t.dlBox.y-h/2,a.plotSizeX-t.dlBox.x]:[t.dlBox.x,t.dlBox.y+h/2],t.y=t.plotY=1,t.color||(t.color=n.color)},e.prototype.translateNode=function(t,r){var n=this.translationFactor,s=this.chart,a=this.options,l=t.getSum(),h=Math.max(Math.round(l*n),this.options.minLinkWidth),c=Math.round(a.borderWidth)%2/2,d=r.offset(t,n),f=Math.floor(pick$6(d.absoluteTop,r.top(n)+d.relativeTop))+c,p=Math.floor(this.colDistance*t.column+a.borderWidth/2)+c,u=s.inverted?s.plotSizeX-p:p,g=Math.round(this.nodeWidth);if(t.sum=l,l){t.shapeType="rect",t.nodeX=u,t.nodeY=f;var v=u,y=f,m=t.options.width||a.width||g,x=t.options.height||a.height||h;s.inverted&&(v=u-g,y=s.plotSizeY-f-h,m=t.options.height||a.height||g,x=t.options.width||a.width||h),t.dlOptions=e.getDLOptions({level:this.mapOptionsToLevel[t.level],optionsPoint:t.options}),t.plotX=1,t.plotY=1,t.tooltipPos=s.inverted?[s.plotSizeY-y-x/2,s.plotSizeX-v-m/2]:[v+m/2,y+x/2],t.shapeArgs={x:v,y,width:m,height:x,display:t.hasShape()?"":"none"}}else t.dlOptions={enabled:!1}},e.defaultOptions=merge$5(ColumnSeries$4.defaultOptions,{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkOpacity:.5,minLinkWidth:0,nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} → {point.toNode.name}: <b>{point.weight}</b><br/>",nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}),e}(ColumnSeries$4);extend$5(SankeySeries$1.prototype,{animate:Series$2.prototype.animate,createNode:NodesMixin.createNode,destroy:NodesMixin.destroy,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,pointArrayMap:["from","to"],pointClass:SankeyPoint$1,searchPoint:H.noop,setData:NodesMixin.setData});SeriesRegistry$1.registerSeriesType("sankey",SankeySeries$1);var __extends$7=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Series$1=SeriesRegistry$1.series,PiePoint=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,defined$2=Utilities.defined,isNumber$2=Utilities.isNumber,merge$4=Utilities.merge,objectEach=Utilities.objectEach,pick$5=Utilities.pick,TimelinePoint=function(o){__extends$7(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.alignConnector=function(){var t=this,r=t.series,n=t.connector,s=t.dataLabel,a=t.dataLabel.options=merge$4(r.options.dataLabels,t.options.dataLabels),l=t.series.chart,h=n.getBBox(),c={x:h.x+s.translateX,y:h.y+s.translateY},d;l.inverted?c.y-=s.options.connectorWidth/2:c.x+=s.options.connectorWidth/2,d=l.isInsidePlot(c.x,c.y),n[d?"animate":"attr"]({d:t.getConnectorPath()}),r.chart.styledMode||n.attr({stroke:a.connectorColor||t.color,"stroke-width":a.connectorWidth,opacity:s[defined$2(s.newOpacity)?"newOpacity":"opacity"]})},e.prototype.drawConnector=function(){var t=this,r=t.series;t.connector||(t.connector=r.chart.renderer.path(t.getConnectorPath()).attr({zIndex:-1}).add(t.dataLabel)),t.series.chart.isInsidePlot(t.dataLabel.x,t.dataLabel.y)&&t.alignConnector()},e.prototype.getConnectorPath=function(){var t=this,r=t.series.chart,n=t.series.xAxis.len,s=r.inverted,a=s?"x2":"y2",l=t.dataLabel,h=l.targetPosition,c={x1:t.plotX,y1:t.plotY,x2:t.plotX,y2:isNumber$2(h.y)?h.y:l.y},d=(l.alignAttr||l)[a[0]]<t.series.yAxis.len/2,f;return s&&(c={x1:t.plotY,y1:n-t.plotX,x2:h.x||l.x,y2:n-t.plotX}),d&&(c[a]+=l[s?"width":"height"]),objectEach(c,function(p,u){c[u]-=(l.alignAttr||l)[u[0]]}),f=r.renderer.crispLine([["M",c.x1,c.y1],["L",c.x2,c.y2]],l.options.connectorWidth),f},e.prototype.init=function(){var t=o.prototype.init.apply(this,arguments);return t.name=pick$5(t.name,"Event"),t.y=1,t},e.prototype.isValid=function(){return this.options.y!==null},e.prototype.setState=function(){var t=o.prototype.setState;this.isNull||t.apply(this,arguments)},e.prototype.setVisible=function(t,r){var n=this,s=n.series;r=pick$5(r,s.options.ignoreHiddenPoint),PiePoint.prototype.setVisible.call(n,t,!1),s.processData(),r&&s.chart.redraw()},e.prototype.applyOptions=function(t,r){return t=Point$2.prototype.optionsToObject.call(this,t),this.userDLOptions=merge$4(this.userDLOptions,t.dataLabels),o.prototype.applyOptions.call(this,t,r)},e}(Series$1.prototype.pointClass),__extends$6=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a=SeriesRegistry$1.seriesTypes,ColumnSeries$3=_a.column,LineSeries=_a.line,addEvent$1=Utilities.addEvent,arrayMax=Utilities.arrayMax,arrayMin=Utilities.arrayMin,defined$1=Utilities.defined,extend$4=Utilities.extend,merge$3=Utilities.merge,pick$4=Utilities.pick,TimelineSeries=function(o){__extends$6(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.userOptions=void 0,t.visibilityMap=void 0,t}return e.prototype.alignDataLabel=function(t,r,n,s){var a=this,l=a.chart.inverted,h=a.visibilityMap.filter(function($){return $}),c=a.visiblePointsCount,d=h.indexOf(t),f=!d||d===c-1,p=a.options.dataLabels,u=t.userDLOptions||{},g=p.alternate?f?1.5:2:1,v,y=Math.floor(a.xAxis.len/c),m=r.padding,x,b;t.visible&&(v=Math.abs(u.x||t.options.dataLabels.x),l?(x=(v-m)*2-t.itemHeight/2,b={width:x+"px",textOverflow:r.width/x*r.height/2>y*g?"ellipsis":"none"}):b={width:(u.width||p.width||y*g-m*2)+"px"},r.css(b),a.chart.styledMode||r.shadow(p.shadow)),o.prototype.alignDataLabel.apply(a,arguments)},e.prototype.bindAxes=function(){var t=this;o.prototype.bindAxes.call(t),["xAxis","yAxis"].forEach(function(r){r==="xAxis"&&!t[r].userOptions.type&&(t[r].categories=t[r].hasNames=!0)})},e.prototype.distributeDL=function(){var t=this,r=t.options.dataLabels,n=1;if(r){var s=r.distance||0;t.points.forEach(function(a){var l;a.options.dataLabels=merge$3((l={},l[t.chart.inverted?"x":"y"]=r.alternate&&n%2?-s:s,l),a.userDLOptions),n++})}},e.prototype.generatePoints=function(){var t=this;o.prototype.generatePoints.apply(t),t.points.forEach(function(r,n){r.applyOptions({x:t.xData[n]},t.xData[n])})},e.prototype.getVisibilityMap=function(){var t=this,r=(t.data.length?t.data:t.userOptions.data).map(function(n){return n&&n.visible!==!1&&!n.isNull?n:!1});return r},e.prototype.getXExtremes=function(t){var r=this,n=t.filter(function(s,a){return r.points[a].isValid()&&r.points[a].visible});return{min:arrayMin(n),max:arrayMax(n)}},e.prototype.init=function(){var t=this;o.prototype.init.apply(t,arguments),t.eventsToUnbind.push(addEvent$1(t,"afterTranslate",function(){var r,n=Number.MAX_VALUE;t.points.forEach(function(s){s.isInside=s.isInside&&s.visible,s.visible&&!s.isNull&&(defined$1(r)&&(n=Math.min(n,Math.abs(s.plotX-r))),r=s.plotX)}),t.closestPointRangePx=n})),t.eventsToUnbind.push(addEvent$1(t,"drawDataLabels",function(){t.distributeDL()})),t.eventsToUnbind.push(addEvent$1(t,"afterDrawDataLabels",function(){var r;t.points.forEach(function(n){if(r=n.dataLabel,r)return r.animate=function(s){return this.targetPosition&&(this.targetPosition=s),SVGElement.prototype.animate.apply(this,arguments)},r.targetPosition||(r.targetPosition={}),n.drawConnector()})})),t.eventsToUnbind.push(addEvent$1(t.chart,"afterHideOverlappingLabel",function(){t.points.forEach(function(r){r.connector&&r.dataLabel&&r.dataLabel.oldOpacity!==r.dataLabel.newOpacity&&r.alignConnector()})}))},e.prototype.markerAttribs=function(t,r){var n=this,s=n.options.marker,a,l=t.marker||{},h=l.symbol||s.symbol,c,d=pick$4(l.width,s.width,n.closestPointRangePx),f=pick$4(l.height,s.height),p=0,u;return n.xAxis.dateTime?o.prototype.markerAttribs.call(this,t,r):(r&&(a=s.states[r]||{},c=l.states&&l.states[r]||{},p=pick$4(c.radius,a.radius,p+(a.radiusPlus||0))),t.hasImage=h&&h.indexOf("url")===0,u={x:Math.floor(t.plotX)-d/2-p/2,y:t.plotY-f/2-p/2,width:d+p,height:f+p},u)},e.prototype.processData=function(){var t=this,r=0,n;for(t.visibilityMap=t.getVisibilityMap(),t.visibilityMap.forEach(function(s){s&&r++}),t.visiblePointsCount=r,n=0;n<t.xData.length;n++)t.yData[n]=1;o.prototype.processData.call(this,arguments)},e.defaultOptions=merge$3(LineSeries.defaultOptions,{colorByPoint:!0,stickyTracking:!1,ignoreHiddenPoint:!0,legendType:"point",lineWidth:4,tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {point.key}</span><br/>',pointFormat:"{point.description}"},states:{hover:{lineWidthPlus:0}},dataLabels:{enabled:!0,allowOverlap:!0,alternate:!0,backgroundColor:palette.backgroundColor,borderWidth:1,borderColor:palette.neutralColor40,borderRadius:3,color:palette.neutralColor80,connectorWidth:1,distance:100,formatter:function(){var t;return this.series.chart.styledMode?t="<span>● </span>":t='<span style="color:'+this.point.color+'">● </span>',t+='<span class="highcharts-strong">'+(this.key||"")+"</span><br/>"+(this.point.label||""),t},style:{textOutline:"none",fontWeight:"normal",fontSize:"12px"},shadow:!1,verticalAlign:"middle"},marker:{enabledThreshold:0,symbol:"square",radius:6,lineWidth:2,height:15},showInLegend:!1,colorKey:"x"}),e}(LineSeries);extend$4(TimelineSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$3.prototype.drawTracker,pointClass:TimelinePoint,trackerGroups:["markerGroup","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("timeline",TimelineSeries);var __extends$5=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SankeyPoint=SeriesRegistry$1.seriesTypes.sankey.prototype.pointClass,OrganizationPoint=function(o){__extends$5(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.fromNode=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return e.prototype.getSum=function(){return 1},e}(SankeyPoint),__extends$4=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SankeySeries=SeriesRegistry$1.seriesTypes.sankey,css=Utilities.css,extend$3=Utilities.extend,merge$2=Utilities.merge,pick$3=Utilities.pick,wrap=Utilities.wrap,OrganizationSeries=function(o){__extends$4(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.curvedPath=function(t,r){for(var n=[],s=0;s<t.length;s++){var a=t[s][1],l=t[s][2];if(typeof a=="number"&&typeof l=="number")if(s===0)n.push(["M",a,l]);else if(s===t.length-1)n.push(["L",a,l]);else if(r){var h=t[s-1],c=t[s+1];if(h&&c){var d=h[1],f=h[2],p=c[1],u=c[2];if(typeof d=="number"&&typeof p=="number"&&typeof f=="number"&&typeof u=="number"&&d!==p&&f!==u){var g=d<p?1:-1,v=f<u?1:-1;n.push(["L",a-g*Math.min(Math.abs(a-d),r),l-v*Math.min(Math.abs(l-f),r)],["C",a,l,a,l,a+g*Math.min(Math.abs(a-p),r),l+v*Math.min(Math.abs(l-u),r)])}}}else n.push(["L",a,l])}return n},e.prototype.alignDataLabel=function(t,r,n){if(n.useHTML){var s=t.shapeArgs.width,a=t.shapeArgs.height,l=this.options.borderWidth+2*this.options.dataLabels.padding;this.chart.inverted&&(s=a,a=t.shapeArgs.width),a-=l,s-=l;var h=r.text;h&&(css(h.element.parentNode,{width:s+"px",height:a+"px"}),css(h.element,{left:0,top:0,width:"100%",height:"100%",overflow:"hidden"})),r.getBBox=function(){return{width:s,height:a}},r.width=s,r.height=a}o.prototype.alignDataLabel.apply(this,arguments)},e.prototype.createNode=function(t){var r=o.prototype.createNode.call(this,t);return r.getSum=function(){return 1},r},e.prototype.createNodeColumn=function(){var t=o.prototype.createNodeColumn.call(this);return wrap(t,"offset",function(r,n,s){var a=r.call(this,n,s);return n.hangsFrom?{absoluteTop:n.hangsFrom.nodeY}:a}),t},e.prototype.pointAttribs=function(t,r){var n=this,s=SankeySeries.prototype.pointAttribs.call(n,t,r),a=t.isNode?t.level:t.fromNode.level,l=n.mapOptionsToLevel[a||0]||{},h=t.options,c=l.states&&l.states[r]||{},d=["borderRadius","linkColor","linkLineWidth"].reduce(function(f,p){return f[p]=pick$3(c[p],h[p],l[p],n.options[p]),f},{});return t.isNode?d.borderRadius&&(s.r=d.borderRadius):(s.stroke=d.linkColor,s["stroke-width"]=d.linkLineWidth,delete s.fill),s},e.prototype.translateLink=function(t){var r=t.fromNode,n=t.toNode,s=Math.round(this.options.linkLineWidth)%2/2,a=Math.floor(r.shapeArgs.x+r.shapeArgs.width)+s,l=Math.floor(r.shapeArgs.y+r.shapeArgs.height/2)+s,h=Math.floor(n.shapeArgs.x)+s,c=Math.floor(n.shapeArgs.y+n.shapeArgs.height/2)+s,d,f=this.options.hangingIndent,p=n.options.offset,u=/%$/.test(p)&&parseInt(p,10),g=this.chart.inverted;g&&(a-=r.shapeArgs.width,h+=n.shapeArgs.width),d=Math.floor(h+(g?1:-1)*(this.colDistance-this.nodeWidth)/2)+s,u&&(u>=50||u<=-50)&&(d=h=Math.floor(h+(g?-.5:.5)*n.shapeArgs.width)+s,c=n.shapeArgs.y,u>0&&(c+=n.shapeArgs.height)),n.hangsFrom===r&&(this.chart.inverted?(l=Math.floor(r.shapeArgs.y+r.shapeArgs.height-f/2)+s,c=n.shapeArgs.y+n.shapeArgs.height):l=Math.floor(r.shapeArgs.y+f/2)+s,d=h=Math.floor(n.shapeArgs.x+n.shapeArgs.width/2)+s),t.plotY=1,t.shapeType="path",t.shapeArgs={d:e.curvedPath([["M",a,l],["L",d,l],["L",d,c],["L",h,c]],this.options.linkRadius)}},e.prototype.translateNode=function(t,r){SankeySeries.prototype.translateNode.call(this,t,r),t.hangsFrom&&(t.shapeArgs.height-=this.options.hangingIndent,this.chart.inverted||(t.shapeArgs.y+=this.options.hangingIndent)),t.nodeHeight=this.chart.inverted?t.shapeArgs.width:t.shapeArgs.height},e.defaultOptions=merge$2(SankeySeries.defaultOptions,{borderColor:palette.neutralColor60,borderRadius:3,linkRadius:10,borderWidth:1,dataLabels:{nodeFormatter:function(){var t={width:"100%",height:"100%",display:"flex","flex-direction":"row","align-items":"center","justify-content":"center"},r={"max-height":"100%","border-radius":"50%"},n={width:"100%",padding:0,"text-align":"center","white-space":"normal"},s={margin:0},a={margin:0},l={opacity:.75,margin:"5px"};function h(d){return Object.keys(d).reduce(function(f,p){return f+p+":"+d[p]+";"},'style="')+'"'}this.point.image&&(r["max-width"]="30%",n.width="70%"),this.series.chart.renderer.forExport&&(t.display="block",n.position="absolute",n.left=this.point.image?"30%":0,n.top=0);var c="<div "+h(t)+">";return this.point.image&&(c+='<img src="'+this.point.image+'" '+h(r)+">"),c+="<div "+h(n)+">",this.point.name&&(c+="<h4 "+h(s)+">"+this.point.name+"</h4>"),this.point.title&&(c+="<p "+h(a)+">"+(this.point.title||"")+"</p>"),this.point.description&&(c+="<p "+h(l)+">"+this.point.description+"</p>"),c+="</div></div>",c},style:{fontWeight:"normal",fontSize:"13px"},useHTML:!0},hangingIndent:20,linkColor:palette.neutralColor60,linkLineWidth:1,nodeWidth:50,tooltip:{nodeFormat:"{point.name}<br>{point.title}<br>{point.description}"}}),e}(SankeySeries);extend$3(OrganizationSeries.prototype,{pointClass:OrganizationPoint});SeriesRegistry$1.registerSeriesType("organization",OrganizationSeries);var __extends$3=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$2=SeriesRegistry$1.seriesTypes.column,extend$2=Utilities.extend,XRangePoint=function(o){__extends$3(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.getColorByCategory=function(t,r){var n=t.options.colors||t.chart.options.colors,s=n?n.length:t.chart.options.chart.colorCount,a=r.y%s,l=n&&n[a];return{colorIndex:a,color:l}},e.prototype.resolveColor=function(){var t=this.series,r;t.options.colorByPoint&&!this.options.color?(r=e.getColorByCategory(t,this),t.chart.styledMode||(this.color=r.color),this.options.colorIndex||(this.colorIndex=r.colorIndex)):this.color||(this.color=t.color)},e.prototype.init=function(){return Point$2.prototype.init.apply(this,arguments),this.y||(this.y=0),this},e.prototype.setState=function(){Point$2.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},e.prototype.getLabelConfig=function(){var t=this,r=Point$2.prototype.getLabelConfig.call(t),n=t.series.yAxis.categories;return r.x2=t.x2,r.yCategory=t.yCategory=n&&n[t.y],r},e.prototype.isValid=function(){return typeof this.x=="number"&&typeof this.x2=="number"},e}(ColumnSeries$2.prototype.pointClass);extend$2(XRangePoint.prototype,{tooltipDateKeys:["x","x2"]});var addEvent=Utilities.addEvent,pick$2=Utilities.pick;addEvent(Axis,"afterGetSeriesExtremes",function(){var o=this,e=o.series,t,r;o.isXAxis&&(t=pick$2(o.dataMax,-Number.MAX_VALUE),e.forEach(function(n){n.x2Data&&n.x2Data.forEach(function(s){s>t&&(t=s,r=!0)})}),r&&(o.dataMax=t))});var __extends$2=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color=Color.parse,Series=SeriesRegistry$1.series,ColumnSeries$1=SeriesRegistry$1.seriesTypes.column,columnProto=ColumnSeries$1.prototype,clamp=Utilities.clamp,correctFloat=Utilities.correctFloat,defined=Utilities.defined,extend$1=Utilities.extend,find=Utilities.find,isNumber$1=Utilities.isNumber,isObject=Utilities.isObject,merge$1=Utilities.merge,pick$1=Utilities.pick,XRangeSeries=function(o){__extends$2(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.init=function(){ColumnSeries$1.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.getColumnMetrics=function(){var t,r=this.chart;function n(){r.series.forEach(function(s){var a=s.xAxis;s.xAxis=s.yAxis,s.yAxis=a})}return n(),t=columnProto.getColumnMetrics.call(this),n(),t},e.prototype.cropData=function(t,r,n,s){var a=Series.prototype.cropData,l=a.call(this,this.x2Data,r,n,s);return l.xData=t.slice(l.start,l.end),l},e.prototype.findPointIndex=function(t){var r=this,n=r.cropped,s=r.cropStart,a=r.points,l=t.id,h;if(l){var c=find(a,function(d){return d.id===l});h=c?c.index:void 0}if(typeof h>"u"){var c=find(a,function(f){return f.x===t.x&&f.x2===t.x2&&!f.touched});h=c?c.index:void 0}return n&&isNumber$1(h)&&isNumber$1(s)&&h>=s&&(h-=s),h},e.prototype.translatePoint=function(t){var r=this,n=r.xAxis,s=r.yAxis,a=r.columnMetrics,l=r.options,h=l.minPointLength||0,c=(t.shapeArgs&&t.shapeArgs.width||0)/2,d=r.pointXOffset=a.offset,f=t.plotX,p=pick$1(t.x2,t.x+(t.len||0)),u=n.translate(p,0,0,0,1),g=Math.abs(u-f),v,y,m=this.chart.inverted,x=pick$1(l.borderWidth,1),b=x%2/2,$=a.offset,S=Math.round(a.width),k,A,M,P,E;h&&(v=h-g,v<0&&(v=0),f-=v/2,u+=v/2),f=Math.max(f,-10),u=clamp(u,-10,n.len+10),defined(t.options.pointWidth)&&($-=(Math.ceil(t.options.pointWidth)-S)/2,S=Math.ceil(t.options.pointWidth)),l.pointPlacement&&isNumber$1(t.plotY)&&s.categories&&(t.plotY=s.translate(t.y,0,1,0,1,l.pointPlacement));var T=Math.floor(Math.min(f,u))+b,O=Math.floor(Math.max(f,u))+b,C={x:T,y:Math.floor(t.plotY+$)+b,width:O-T,height:S,r:r.options.borderRadius};t.shapeArgs=C,m?t.tooltipPos[1]+=d+c:t.tooltipPos[0]-=c+d-C.width/2,k=C.x,A=k+C.width,k<0||A>n.len?(k=clamp(k,0,n.len),A=clamp(A,0,n.len),M=A-k,t.dlBox=merge$1(C,{x:k,width:A-k,centerX:M?M/2:null})):t.dlBox=null;var I=t.tooltipPos,L=m?1:0,D=m?0:1;E=r.columnMetrics?r.columnMetrics.offset:-a.width/2,m?I[L]+=C.width/2:I[L]+=(n.reversed?-1:0)*C.width,I[D]=clamp(I[D]+(m?-1:1)*E,0,s.len-1),y=t.partialFill,y&&(isObject(y)&&(y=y.amount),isNumber$1(y)||(y=0),t.partShapeArgs=merge$1(C,{r:r.options.borderRadius}),P=Math.max(Math.round(g*y+t.plotX-f),0),t.clipRectArgs={x:n.reversed?C.x+g-P:C.x,y:C.y,width:P,height:C.height})},e.prototype.translate=function(){columnProto.translate.apply(this,arguments),this.points.forEach(function(t){this.translatePoint(t)},this)},e.prototype.drawPoint=function(t,r){var n=this,s=n.options,a=n.chart.renderer,l=t.graphic,h=t.shapeType,c=t.shapeArgs,d=t.partShapeArgs,f=t.clipRectArgs,p=t.partialFill,u=s.stacking&&!s.borderRadius,g=t.state,v=s.states[g||"normal"]||{},y=typeof g>"u"?"attr":r,m=n.pointAttribs(t,g),x=pick$1(n.chart.options.chart.animation,v.animation),b;!t.isNull&&t.visible!==!1?(l?l.rect[r](c):(t.graphic=l=a.g("point").addClass(t.getClassName()).add(t.group||n.group),l.rect=a[h](merge$1(c)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(l)),d&&(l.partRect?(l.partRect[r](merge$1(d)),l.partialClipRect[r](merge$1(f))):(l.partialClipRect=a.clipRect(f.x,f.y,f.width,f.height),l.partRect=a[h](d).addClass("highcharts-partfill-overlay").add(l).clip(l.partialClipRect))),n.chart.styledMode||(l.rect[r](m,x).shadow(s.shadow,null,u),d&&(isObject(p)||(p={}),isObject(s.partialFill)&&(p=merge$1(s.partialFill,p)),b=p.fill||color(m.fill).brighten(-.3).get()||color(t.color||n.color).brighten(-.3).get(),m.fill=b,l.partRect[y](m,x).shadow(s.shadow,null,u)))):l&&(t.graphic=l.destroy())},e.prototype.drawPoints=function(){var t=this,r=t.getAnimationVerb();t.points.forEach(function(n){t.drawPoint(n,r)})},e.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},e.prototype.isPointInside=function(t){var r=t.shapeArgs,n=t.plotX,s=t.plotY;if(!r)return o.prototype.isPointInside.apply(this,arguments);var a=typeof n<"u"&&typeof s<"u"&&s>=0&&s<=this.yAxis.len&&(r.x||0)+(r.width||0)>=0&&n<=this.xAxis.len;return a},e.defaultOptions=merge$1(ColumnSeries$1.defaultOptions,{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point,r=t.partialFill;if(isObject(r)&&(r=r.amount),isNumber$1(r)&&r>0)return correctFloat(r*100)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}),e}(ColumnSeries$1);extend$1(XRangeSeries.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:Series.prototype.animate,cropShoulder:1,getExtremesFromAll:!0,autoIncrement:H.noop,buildKDTree:H.noop,pointClass:XRangePoint});SeriesRegistry$1.registerSeriesType("xrange",XRangeSeries);var __extends$1=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),BulletPoint=function(o){__extends$1(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.destroy=function(){this.targetGraphic&&(this.targetGraphic=this.targetGraphic.destroy()),o.prototype.destroy.apply(this,arguments)},e}(ColumnSeries$h.prototype.pointClass),__extends=function(){var o=function(e,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var s in n)n.hasOwnProperty(s)&&(r[s]=n[s])},o(e,t)};return function(e,t){o(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries=SeriesRegistry$1.seriesTypes.column,extend=Utilities.extend,isNumber=Utilities.isNumber,merge=Utilities.merge,pick=Utilities.pick,relativeLength=Utilities.relativeLength,BulletSeries=function(o){__extends(e,o);function e(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.targetData=void 0,t}return e.prototype.drawPoints=function(){var t=this,r=t.chart,n=t.options,s=n.animationLimit||250;o.prototype.drawPoints.apply(this,arguments),t.points.forEach(function(a){var l=a.options,h=a.target,c=a.y,d,f=a.targetGraphic,p,u,g,v;if(isNumber(h)&&h!==null){g=merge(n.targetOptions,l.targetOptions),u=g.height;var y=a.shapeArgs;a.dlBox&&y&&!isNumber(y.width)&&(y=a.dlBox),p=relativeLength(g.width,y.width),v=t.yAxis.translate(h,!1,!0,!1,!0)-g.height/2-.5,d=t.crispCol.apply({chart:r,borderWidth:g.borderWidth,options:{crisp:n.crisp}},[y.x+y.width/2-p/2,v,p,u]),f?(f[r.pointCount<s?"animate":"attr"](d),isNumber(c)&&c!==null?f.element.point=a:f.element.point=void 0):a.targetGraphic=f=r.renderer.rect().attr(d).add(t.group),r.styledMode||f.attr({fill:pick(g.color,l.color,t.zones.length&&(a.getZone.call({series:t,x:a.x,y:h,options:{}}).color||t.color)||void 0,a.color,t.color),stroke:pick(g.borderColor,a.borderColor,t.options.borderColor),"stroke-width":g.borderWidth,r:g.borderRadius}),isNumber(c)&&c!==null&&(f.element.point=a),f.addClass(a.getClassName()+" highcharts-bullet-target",!0)}else f&&(a.targetGraphic=f.destroy())})},e.prototype.getExtremes=function(t){var r=o.prototype.getExtremes.call(this,t),n=this,s=n.targetData;if(s&&s.length){var a=o.prototype.getExtremes.call(this,s);isNumber(a.dataMin)&&(r.dataMin=Math.min(pick(r.dataMin,1/0),a.dataMin)),isNumber(a.dataMax)&&(r.dataMax=Math.max(pick(r.dataMax,-1/0),a.dataMax))}return r},e.defaultOptions=merge(ColumnSeries.defaultOptions,{targetOptions:{width:"140%",height:3,borderWidth:0,borderRadius:0},tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.y}</b>. Target: <b>{point.target}</b><br/>'}}),e}(ColumnSeries);extend(BulletSeries.prototype,{parallelArrays:["x","y","target"],pointArrayMap:["y","target"]});BulletSeries.prototype.pointClass=BulletPoint;SeriesRegistry$1.registerSeriesType("bullet",BulletSeries);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isSlot(o){return o.localName==="slot"}let FlattenedNodesObserver=class{static getFlattenedNodes(o){const e=wrap$e(o);if(isSlot(o))return o=o,e.assignedNodes({flatten:!0});{const t=[];for(let r=0;r<e.childNodes.length;r++){const n=e.childNodes[r];if(isSlot(n)){const s=n;t.push(...wrap$e(s).assignedNodes({flatten:!0}))}else t.push(n)}return t}}constructor(o,e){this._shadyChildrenObserver=null,this._nativeChildrenObserver=null,this._connected=!1,this._target=o,this.callback=e,this._effectiveNodes=[],this._observer=null,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){isSlot(this._target)?this._listenSlots([this._target]):wrap$e(this._target).children&&(this._listenSlots(wrap$e(this._target).children),window.ShadyDOM?this._shadyChildrenObserver=window.ShadyDOM.observeChildren(this._target,o=>{this._processMutations(o)}):(this._nativeChildrenObserver=new MutationObserver(o=>{this._processMutations(o)}),this._nativeChildrenObserver.observe(this._target,{childList:!0}))),this._connected=!0}disconnect(){isSlot(this._target)?this._unlistenSlots([this._target]):wrap$e(this._target).children&&(this._unlistenSlots(wrap$e(this._target).children),window.ShadyDOM&&this._shadyChildrenObserver?(window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver),this._shadyChildrenObserver=null):this._nativeChildrenObserver&&(this._nativeChildrenObserver.disconnect(),this._nativeChildrenObserver=null)),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,microTask.run(()=>this.flush()))}_processMutations(o){this._processSlotMutations(o),this.flush()}_processSlotMutations(o){if(o)for(let e=0;e<o.length;e++){let t=o[e];t.addedNodes&&this._listenSlots(t.addedNodes),t.removedNodes&&this._unlistenSlots(t.removedNodes)}}flush(){if(!this._connected)return!1;window.ShadyDOM&&ShadyDOM.flush(),this._nativeChildrenObserver?this._processSlotMutations(this._nativeChildrenObserver.takeRecords()):this._shadyChildrenObserver&&this._processSlotMutations(this._shadyChildrenObserver.takeRecords()),this._scheduled=!1;let o={target:this._target,addedNodes:[],removedNodes:[]},e=this.constructor.getFlattenedNodes(this._target),t=calculateSplices(e,this._effectiveNodes);for(let n=0,s;n<t.length&&(s=t[n]);n++)for(let a=0,l;a<s.removed.length&&(l=s.removed[a]);a++)o.removedNodes.push(l);for(let n=0,s;n<t.length&&(s=t[n]);n++)for(let a=s.index;a<s.index+s.addedCount;a++)o.addedNodes.push(e[a]);this._effectiveNodes=e;let r=!1;return(o.addedNodes.length||o.removedNodes.length)&&(r=!0,this.callback.call(this._target,o)),r}_listenSlots(o){for(let e=0;e<o.length;e++){let t=o[e];isSlot(t)&&t.addEventListener("slotchange",this._boundSchedule)}}_unlistenSlots(o){for(let e=0;e<o.length;e++){let t=o[e];isSlot(t)&&t.removeEventListener("slotchange",this._boundSchedule)}}};function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends PolymerElement{static get is(){return"vaadin-chart-series"}static get properties(){return{values:{type:Array,value:()=>[]},valueMin:{type:Number,reflectToAttribute:!0},valueMax:{type:Number,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},markers:{type:String,reflectToAttribute:!0},unit:{type:String,reflectToAttribute:!0},stack:{type:String,reflectToAttribute:!0},neckPosition:{type:String,reflectToAttribute:!0},neckWidth:{type:String,reflectToAttribute:!0},options:{type:Object},additionalOptions:{type:Object,reflectToAttribute:!0},_series:{type:Object}}}static get observers(){return["__additionalOptionsObserver(additionalOptions.*, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values.splices, _series)"]}get options(){const e=deepMerge({},this.additionalOptions);return this.type&&(e.type=this.type),this.title&&(e.name=this.title),this.values&&(e.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),e.marker=this.__markersConfiguration),this.unit&&(e.yAxis=this.unit),this.stack&&(e.stack=this.stack),isFinite(this.valueMin)&&(e.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(e.yAxisValueMax=this.valueMax),this.neckWidth&&(e.neckWidth=this.neckWidth),this.neckPosition&&(e.neckHeight=this.neckPosition),e}get __markersConfiguration(){const e={};switch(this.markers){case"shown":e.enabled=!0;break;case"hidden":e.enabled=!1;break;case"auto":default:e.enabled=null;break}return e}setSeries(e){this._series=e}__valuesObserver(e,t){t&&t.setData(this.values)}__additionalOptionsObserver(e,t){t&&e.base&&t.update(e.base)}__updateAxis(e,t,r){if(!isFinite(t)){this.__showWarn(`value-${r}`,"Numbers or null");return}e&&e.yAxis&&e.yAxis.update({[r]:t})}__valueMinObserver(e,t){e===void 0||t===void 0||this.__updateAxis(t,e,"min")}__valueMaxObserver(e,t){e===void 0||t===void 0||this.__updateAxis(t,e,"max")}__typeObserver(e,t){e&&t&&t.update({type:e})}__titleObserver(e,t){e===void 0||t===void 0||t.update({name:e})}__stackObserver(e,t){e===void 0||t===void 0||t.update({stack:e})}__neckPositionObserver(e,t){e===void 0||t===void 0||t.update({neckHeight:e})}__neckWidthObserver(e,t){e===void 0||t===void 0||t.update({neckWidth:e})}__unitObserver(e,t,r,n){if(n&&e!==this.__oldUnit){this.__oldUnit=e;const s=this.parentNode instanceof Chart&&this.parentNode;if(s&&s instanceof Chart){if(e&&!s.__getAxis(e)){const a={title:{text:e}};s.__addAxis({id:e,axisGenerated:!0,...a})}n.update({yAxis:e||0}),t!==void 0&&this.__updateAxis(n,t,"min"),r!==void 0&&this.__updateAxis(n,r,"max"),s.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(e,t){if(!(e===void 0||t===void 0)){if(!this.__isMarkersValid()){this.markers="auto";return}t.update({marker:this.__markersConfiguration})}}__showWarn(e,t){console.warn(`<vaadin-chart-series> Acceptable values for "${e}" are ${t}`)}}defineCustomElement(ChartSeries);/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */function deepMerge(o,e){const t=r=>r&&typeof r=="object"&&!Array.isArray(r);return t(e)&&t(o)&&Object.keys(e).forEach(r=>{t(e[r])?(o[r]||Object.assign(o,{[r]:{}}),deepMerge(o[r],e[r])):Object.assign(o,{[r]:e[r]})}),o}["exportChart","exportChartLocal","getSVG"].forEach(o=>{G$7.wrap(G$7.Chart.prototype,o,function(e,...t){G$7.fireEvent(this,"beforeExport");const r=e.apply(this,t);return G$7.fireEvent(this,"afterExport"),r})});Pointer.prototype.onDocumentMouseMove=function(o){const e=this.chart,t=this.chartPosition,r=this.normalize(o,t),n=e.tooltip;t&&(!n||!n.isStickyOnContact())&&!e.isInsidePlot(r.chartX-e.plotLeft,r.chartY-e.plotTop,{visiblePlotOnly:!0})&&!this.inClass(r.composedPath()[0],"highcharts-tracker")&&this.reset()};G$7.setOptions({lang:{noData:""}});class Chart extends ResizeMixin(ElementMixin(ThemableMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
          width: 100%;
          overflow: hidden;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <div id="chart"></div>
      <slot id="slot"></slot>
    `}static get is(){return"vaadin-chart"}static get cvdlName(){return"vaadin-chart"}static get properties(){return{configuration:Object,categories:{type:Object,reflectToAttribute:!0},categoryMax:{type:Number,reflectToAttribute:!0},categoryMin:{type:Number,reflectToAttribute:!0},categoryPosition:{type:String,reflectToAttribute:!0},noLegend:{type:Boolean,reflectToAttribute:!0},stacking:{type:String,reflectToAttribute:!0},timeline:{type:Boolean,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},tooltip:{type:Boolean,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},subtitle:{type:String,reflectToAttribute:!0},chart3d:{type:Boolean,reflectToAttribute:!0},emptyText:{type:String,reflectToAttribute:!0},additionalOptions:{type:Object,reflectToAttribute:!0},polar:{type:Boolean,reflectToAttribute:!0}}}static get observers(){return["__chart3dObserver(chart3d, configuration)","__emptyTextObserver(emptyText, configuration)","__hideLegend(noLegend, configuration)","__polarObserver(polar, configuration)","__stackingObserver(stacking, configuration)","__tooltipObserver(tooltip, configuration)","__updateCategories(categories, configuration)","__updateCategoryMax(categoryMax, configuration)","__updateCategoryMin(categoryMin, configuration)","__updateCategoryPosition(categoryPosition, configuration)","__updateSubtitle(subtitle, configuration)","__updateTitle(title, configuration)","__updateType(type, configuration)","__updateAdditionalOptions(additionalOptions.*)"]}static __callHighchartsFunction(e,t,...r){const n=G$7[e];n&&typeof n=="function"&&(r.forEach(s=>inflateFunctions(s)),n.apply(this.configuration,r),t&&G$7.charts.forEach(s=>{s!==void 0&&s.redraw()}))}constructor(){super(),this._baseConfig={annotations:[],chart:{styledMode:!0},credits:{enabled:!1},exporting:{enabled:!1},title:{text:null},series:[],xAxis:{},yAxis:{axisGenerated:!0}},this._baseChart3d={enabled:!0,alpha:15,beta:15,depth:50}}get options(){const e={...this._baseConfig};return deepMerge(e,this.additionalOptions),this.type&&(e.chart.type=this.type),this.polar&&(e.chart.polar=!0),this.title&&(e.title={text:this.title}),e.tooltip||(e.tooltip={},this.tooltip||(e.tooltip.enabled=!1)),this.subtitle&&(e.subtitle={text:this.subtitle}),this.categories&&(Array.isArray(e.xAxis)?e.xAxis[0].categories=this.categories:e.xAxis.categories=this.categories),isFinite(this.categoryMin)&&(Array.isArray(e.xAxis)?e.xAxis[0].min=this.categoryMin:e.xAxis.min=this.categoryMin),isFinite(this.categoryMax)&&(Array.isArray(e.xAxis)?e.xAxis[0].max=this.categoryMax:e.xAxis.max=this.categoryMax),this.noLegend&&(e.legend={enabled:!1}),this.emptyText&&(e.lang||(e.lang={}),e.lang.noData=this.emptyText),this.categoryPosition&&(e.chart.inverted=this.__shouldInvert(),Array.isArray(e.xAxis)?e.xAxis.forEach(t=>{t.opposite=this.__shouldFlipOpposite()}):e.xAxis&&(e.xAxis.opposite=this.__shouldFlipOpposite())),this.stacking&&(e.plotOptions||(e.plotOptions={}),e.plotOptions.series||(e.plotOptions.series={}),e.plotOptions.series.stacking=this.stacking),this.chart3d&&(e.chart.options3d={...this._baseChart3d,...e.chart.options3d}),e}get __chartEventNames(){return{addSeries:"chart-add-series",afterExport:"chart-after-export",afterPrint:"chart-after-print",beforeExport:"chart-before-export",beforePrint:"chart-before-print",click:"chart-click",drilldown:"chart-drilldown",drillup:"chart-drillup",drillupall:"chart-drillupall",load:"chart-load",redraw:"chart-redraw",selection:"chart-selection"}}get __seriesEventNames(){return{afterAnimate:"series-after-animate",checkboxClick:"series-checkbox-click",click:"series-click",hide:"series-hide",legendItemClick:"series-legend-item-click",mouseOut:"series-mouse-out",mouseOver:"series-mouse-over",show:"series-show"}}get __pointEventNames(){return{click:"point-click",legendItemClick:"point-legend-item-click",mouseOut:"point-mouse-out",mouseOver:"point-mouse-over",remove:"point-remove",select:"point-select",unselect:"point-unselect",update:"point-update"}}get __xAxesEventNames(){return{afterSetExtremes:"xaxes-extremes-set"}}get __yAxesEventNames(){return{afterSetExtremes:"yaxes-extremes-set"}}connectedCallback(){super.connectedCallback(),this.__updateStyles(),beforeNextRender(this,()=>{if(this.configuration){this.__reflow();return}this.__resetChart(),this.__addChildObserver(),this.__checkTurboMode()})}ready(){super.ready(),this.addEventListener("chart-redraw",this.__onRedraw.bind(this))}_onResize(e){if(!this.configuration)return;const{height:t,width:r}=e,{chartHeight:n,chartWidth:s}=this.configuration;(t!==n||r!==s)&&this.__reflow()}__reflow(){this.configuration&&this.configuration.reflow()}__addChildObserver(){this._childObserver=new FlattenedNodesObserver(this.$.slot,e=>{this.__addSeries(e.addedNodes.filter(this.__filterSeriesNodes)),this.__removeSeries(e.removedNodes.filter(this.__filterSeriesNodes)),this.__cleanupAfterSeriesRemoved(e.removedNodes.filter(this.__filterSeriesNodes))})}__filterSeriesNodes(e){return e.nodeType===Node.ELEMENT_NODE&&e instanceof ChartSeries}__addSeries(e){if(this.__isSeriesEmpty(e))return;const t=Array.from(this.childNodes).filter(this.__filterSeriesNodes),r=this.configuration.yAxis.reduce((n,s,a)=>(n[s.options.id||a]=s,n),{});for(let n=0,s=e.length;n<s;n++){const a=e[n],{yAxis:l,yAxisValueMin:h,yAxisValueMax:c}=a.options,d=t.indexOf(a);!l&&!this.configuration.yAxis.some(p=>p.userOptions.id===void 0)?r[l]=this.__addAxis({axisGenerated:!0}):l&&!r[l]&&(r[l]=this.__addAxis({id:l,title:{text:l},axisGenerated:!0})),isFinite(h)&&this.__setYAxisProps(r,l,{min:h}),isFinite(c)&&this.__setYAxisProps(r,l,{max:c});const f=this.__updateOrAddSeriesInstance(a.options,d,!1);a.setSeries(f)}this.__removeAxisIfEmpty(),this.configuration.redraw()}__removeSeries(e){this.__isSeriesEmpty(e)||e.forEach(t=>{t instanceof ChartSeries&&t._series.remove()})}__setYAxisProps(e,t,r){t?e[t].update(r):this.configuration.yAxis[0].update(r)}__isSeriesEmpty(e){return e===null||e.length===0}__cleanupAfterSeriesRemoved(e){this.__isSeriesEmpty(e)||(this.__removeAxisIfEmpty(),this.__updateNoDataElement(this.configuration))}__initChart(e){this.__initEventsListeners(e),this.__updateStyledMode(e),this.timeline?this.configuration=G$7.stockChart(this.$.chart,e):this.configuration=G$7.chart(this.$.chart,e)}__updateStyledMode(e){const t=e.chart.styledMode;this.$.chart.toggleAttribute("styled-mode",!!t)}disconnectedCallback(){super.disconnectedCallback(),this.configuration&&(this.configuration.destroy(),this.configuration=void 0),this._childObserver&&this._childObserver.disconnect()}__resetChart(){const e={...this.options,...this._jsonConfigurationBuffer};this.__initChart(e),this._jsonConfigurationBuffer=null}__getAxis(e,t){if(e=Number.parseInt(e)||e,this.configuration)return(t?this.configuration.xAxis:this.configuration.yAxis).find(r=>r.options.id===e)}__addAxis(e,t){if(this.configuration)return this.__createEventListeners(t?this.__xAxesEventNames:this.__yAxesEventNames,e,"events","axis"),this.configuration.addAxis(e,t)}__removeAxisIfEmpty(e){this.configuration&&(e?this.configuration.xAxis:this.configuration.yAxis).forEach(t=>{t.userOptions.axisGenerated&&t.series.length===0&&t.remove()})}updateConfiguration(e,t){(t||!this._jsonConfigurationBuffer)&&(this._jsonConfigurationBuffer={});const r=deepMerge({},e);inflateFunctions(r),this._jsonConfigurationBuffer=this.__makeConfigurationBuffer(this._jsonConfigurationBuffer,r),beforeNextRender(this,()=>{if(!(!this.configuration||!this._jsonConfigurationBuffer)){if(t){this.__resetChart();return}this.configuration.update(this._jsonConfigurationBuffer,!1),this._jsonConfigurationBuffer.credits&&this.__updateOrAddCredits(this._jsonConfigurationBuffer.credits),this._jsonConfigurationBuffer.xAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.xAxis,!0,!1),this._jsonConfigurationBuffer.yAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.yAxis,!1,!1),this._jsonConfigurationBuffer.series&&this.__updateOrAddSeries(this._jsonConfigurationBuffer.series,!1),this._jsonConfigurationBuffer=null,this.configuration.redraw()}})}__makeConfigurationBuffer(e,t){const r=G$7.merge(t),n=G$7.merge(e);return this.__mergeConfigurationArray(n,r,"series"),this.__mergeConfigurationArray(n,r,"xAxis"),this.__mergeConfigurationArray(n,r,"yAxis"),G$7.merge(n,r)}__mergeConfigurationArray(e,t,r){if(!t||!t[r]||!Array.isArray(t[r]))return;if(!e[r]){e[r]=Array.from(t[r]);return}const n=Math.max(e[r].length,t[r].length);for(let s=0;s<n;s++)e[r][s]=G$7.merge(e[r][s],t[r][s]);delete t[r]}__initEventsListeners(e){this.__initChartEventsListeners(e),this.__initSeriesEventsListeners(e),this.__initPointsEventsListeners(e),this.__initAxisEventsListeners(e,!0),this.__initAxisEventsListeners(e,!1)}__initChartEventsListeners(e){this.__createEventListeners(this.__chartEventNames,e,"chart.events","chart")}__initSeriesEventsListeners(e){this.__createEventListeners(this.__seriesEventNames,e,"plotOptions.series.events","series")}__initPointsEventsListeners(e){this.__createEventListeners(this.__pointEventNames,e,"plotOptions.series.point.events","point")}__initAxisEventsListeners(e,t){let r,n;t?(r=this.__xAxesEventNames,n=e.xAxis):(r=this.__yAxesEventNames,n=e.yAxis),Array.isArray(n)?n.forEach(s=>this.__createEventListeners(r,s,"events","axis")):this.__createEventListeners(r,n,"events","axis")}__createEventListeners(e,t,r,n){const s=this.__ensureObjectPath(t,r);for(let a=Object.keys(e),l=0;l<a.length;l++){const h=a[l];s[h]||(s[h]=c=>{const d={bubbles:!1,composed:!0,detail:{originalEvent:c,[n]:c.target}};if(!(c.type==="afterSetExtremes"&&(c.min==null||c.max==null))){if(c.type==="selection"&&(c.xAxis&&c.xAxis[0]&&(d.detail.xAxisMin=c.xAxis[0].min,d.detail.xAxisMax=c.xAxis[0].max),c.yAxis&&c.yAxis[0]&&(d.detail.yAxisMin=c.yAxis[0].min,d.detail.yAxisMax=c.yAxis[0].max)),c.type==="click"&&(c.xAxis&&c.xAxis[0]&&(d.detail.xValue=c.xAxis[0].value),c.yAxis&&c.yAxis[0]&&(d.detail.yValue=c.yAxis[0].value)),["beforePrint","beforeExport"].indexOf(c.type)>=0&&!this.tempBodyStyle){let f="";[...this.shadowRoot.querySelectorAll("style")].forEach(p=>{f+=p.textContent}),f=f.replace(/:host\(.+?\)/gu,p=>{const u=p.substr(6,p.length-7);return this.matches(u)?"":p}),f=`${f}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`,this.tempBodyStyle=document.createElement("style"),this.tempBodyStyle.textContent=f,document.body.appendChild(this.tempBodyStyle),this.options.chart.styledMode&&document.body.setAttribute("styled-mode","")}if(["afterPrint","afterExport"].indexOf(c.type)>=0&&this.tempBodyStyle&&(document.body.removeChild(this.tempBodyStyle),delete this.tempBodyStyle,this.options.chart.styledMode&&document.body.removeAttribute("styled-mode")),this.dispatchEvent(new CustomEvent(e[h],d)),c.type==="legendItemClick"&&this._visibilityTogglingDisabled)return!1}})}}__ensureObjectPath(e,t){if(typeof t=="string")return t=t.split("."),t.reduce((r,n)=>(r[n]||(r[n]={}),r[n]),e)}__hasConfigurationBuffer(e){return get(e,this._jsonConfigurationBuffer)!==void 0}__updateOrAddCredits(e){this.configuration.credits?this.configuration.credits.update(e):this.configuration.addCredits(e)}__updateOrAddAxes(e,t,r){Array.isArray(e)||(e=[e]);const n=t?this.configuration.xAxis:this.configuration.yAxis;for(let s=0;s<e.length;s++){const a=e[s];n[s]?n[s].update(a,r):this.configuration.addAxis(a,t,r)}}__updateOrAddSeries(e,t){if(!Array.isArray(e))throw new Error("The type of jsonConfiguration.series should be Object[]");for(let r=0;r<e.length;r++){const n=e[r];this.__updateOrAddSeriesInstance(n,r,t)}}__updateOrAddSeriesInstance(e,t,r){return this.configuration.series[t]?this.configuration.series[t].update(e,r):this.configuration.addSeries(e,r),this.configuration.series[t]}__updateCategories(e,t){e===void 0||!t||this.__hasConfigurationBuffer("xAxis.categories")||this.__updateOrAddAxes([{categories:e}],!0)}__updateCategoryMax(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("xAxis.max"))){if(!isFinite(e)){console.warn('<vaadin-chart> Acceptable value for "category-max" are Numbers or null');return}this.__updateOrAddAxes([{max:e}],!0)}}__updateCategoryMin(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("xAxis.min"))){if(!isFinite(e)){console.warn('<vaadin-chart> Acceptable value for "category-min" are Numbers or null');return}this.__updateOrAddAxes([{min:e}],!0)}}__shouldInvert(){if(this.type==="bar"&&["top","bottom"].indexOf(this.categoryPosition)>=0){console.warn(`<vaadin-chart> Acceptable "category-position" values for bar charts are
          "left" and "right". For "top" and "bottom" positions please consider using a column chart.`);return}return["left","right"].indexOf(this.categoryPosition)>=0}__shouldFlipOpposite(){const e=["top","right"],t=["right"];return(this.type==="bar"?t:e).indexOf(this.categoryPosition)>=0}__updateCategoryPosition(e,t){if(e===void 0||!t||this.__hasConfigurationBuffer("chart.inverted"))return;const r=["left","right","top","bottom"];if(r.indexOf(e)<0){console.warn(`<vaadin-chart> Acceptable "category-position" values are ${r}`);return}t.update({chart:{inverted:this.__shouldInvert()}}),t.xAxis.forEach(n=>n.update({opposite:this.__shouldFlipOpposite()}))}__hideLegend(e,t){e===void 0||!t||this.__hasConfigurationBuffer("legend")||(t.legend?t.legend.update({enabled:!e}):t.legend={enabled:!e})}__updateTitle(e,t){e===void 0||!t||this.__hasConfigurationBuffer("title")||t.title.update({text:e})}__tooltipObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("tooltip")||t.tooltip.update({enabled:e})}__updateType(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.type")||t.update({chart:{type:e||"line"}})}__updateSubtitle(e,t){e===void 0||!t||this.__hasConfigurationBuffer("subtitle")||(t.subtitle?t.subtitle.update({text:e}):t.setSubtitle({text:e}))}__updateAdditionalOptions(e){this.configuration&&e.base&&this.updateConfiguration(e.base)}__isStackingValid(){return["normal","percent",null].indexOf(this.stacking)===-1?(this.__showWarn("stacking",'"normal", "percent" or null'),!1):!0}__stackingObserver(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("plotOptions.series.stacking"))){if(!this.__isStackingValid()){this.stacking=null;return}t.update({plotOptions:{series:{stacking:e}}})}}__chart3dObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.options3d")||(e?t.update({chart:{options3d:{...this._baseChart3d,...this.additionalOptions&&this.additionalOptions.chart&&this.additionalOptions.chart.options3d,enabled:!0}}}):t.update({chart:{options3d:{enabled:!1}}}))}__polarObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.polar")||t.update({chart:{polar:e}})}__emptyTextObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("lang.noData")||(t.update({lang:{noData:e}}),this.__updateNoDataElement(t))}__updateNoDataElement(e){e.series.every(r=>r.data.length===0)&&(e.hideNoData(),e.showNoData(this.emptyText))}__callChartFunction(e,...t){if(this.configuration){const r=this.configuration[e];r&&typeof r=="function"&&(t.forEach(n=>inflateFunctions(n)),r.apply(this.configuration,t))}}__callSeriesFunction(e,t,...r){if(this.configuration&&this.configuration.series[t]){const n=this.configuration.series[t],s=n[e];s&&typeof s=="function"&&(r.forEach(a=>inflateFunctions(a)),s.apply(n,r))}}__callAxisFunction(e,t,r,...n){if(this.configuration){let s;switch(t){case 0:s=this.configuration.xAxis;break;case 1:s=this.configuration.yAxis;break;case 2:s=this.configuration.zAxis;break;case 3:s=this.configuration.colorAxis;break}if(s&&s[r]){const a=s[r],l=a[e];l&&typeof l=="function"&&(n.forEach(h=>inflateFunctions(h)),l.apply(a,n))}}}__callPointFunction(e,t,r,...n){if(this.configuration&&this.configuration.series[t]&&this.configuration.series[t].data[r]){const s=this.configuration.series[t].data[r],a=s[e];a&&typeof a=="function"&&a.apply(s,n)}}__updateStyles(){if(getComputedStyle(this).flex!=="0 1 auto"){this.$.chart.setAttribute("style","flex: 1; ");let t="";this.hasAttribute("style")&&(t=this.getAttribute("style"),t.endsWith(";")||(t+=";")),t+="display: flex;",this.setAttribute("style",t)}else this.$.chart.setAttribute("style","height:100%; width:100%;")}__showWarn(e,t){console.warn(`<vaadin-chart> Acceptable values for "${e}" are ${t}`)}__onRedraw(){this.__checkTurboMode()}__checkTurboMode(){const e=!!window.Vaadin.developmentMode;if(!this.configuration||!e||this.__turboModeWarningAlreadyLogged)return;this.configuration.series.some(r=>{const n=r.options&&r.options.turboThreshold||0,s=r.data.length;return n>0&&s>n})&&(this.__turboModeWarningAlreadyLogged=!0,console.warn("<vaadin-chart> Turbo mode has been enabled for one or more series, because the number of data items exceeds the configured threshold. Turbo mode improves the performance of charts with lots of data, but is not compatible with every type of series. Please consult the documentation on compatibility, or how to disable turbo mode."))}}defineCustomElement(Chart)});export default ft();
