/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.browser;

import com.vaadin.testbench.DriverSupplier;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.ParameterizedBrowserTest;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.annotations.RunLocally;
import com.vaadin.testbench.annotations.RunOnHub;
import com.vaadin.testbench.browser.BrowserTestInfo;
import com.vaadin.testbench.browser.CapabilitiesUtil;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.SauceLabsIntegration;
import com.vaadin.testbench.parallel.setup.SetupDriver;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserExtension
implements Extension,
BeforeEachCallback,
ExecutionCondition,
HasDriver,
ParameterResolver {
    private final SetupDriver driverConfiguration = new SetupDriver();
    private final DesiredCapabilities desiredCapabilities;
    protected WebDriver driver;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BrowserExtension.class);
    }

    public BrowserExtension(Capabilities capabilities) {
        this.desiredCapabilities = new DesiredCapabilities(capabilities);
        if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            SauceLabsIntegration.setDesiredCapabilities((DesiredCapabilities)this.desiredCapabilities);
        }
        this.driverConfiguration.setDesiredCapabilities(this.desiredCapabilities);
    }

    public BrowserExtension() {
        this((Capabilities)new DesiredCapabilities());
    }

    public void setDriver(WebDriver driver) {
        if (driver != null && !(driver instanceof TestBenchDriverProxy)) {
            driver = TestBench.createDriver((WebDriver)driver);
        }
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return CapabilitiesUtil.evaluateExecutionCondition(context);
    }

    protected String getHubURL(Class<?> testClass) {
        if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            return SauceLabsIntegration.getHubUrl();
        }
        return String.format("http://%s:%d/wd/hub", this.getHubHostname(testClass), Parameters.getHubPort());
    }

    protected String getHubHostname(Class<?> testClass) {
        String hubSystemProperty = Parameters.getHubHostname();
        if (hubSystemProperty != null) {
            return hubSystemProperty;
        }
        RunLocally runLocally = testClass.getAnnotation(RunLocally.class);
        if (runLocally != null) {
            return "localhost";
        }
        RunOnHub runOnHub = this.getRunOnHub(testClass);
        return runOnHub == null ? null : runOnHub.value();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (BrowserExtension.isParameterizedTest(context)) {
            return;
        }
        SauceLabsIntegration.setSauceLabsOption((DesiredCapabilities)this.desiredCapabilities, (String)"name", (Object)context.getDisplayName());
        this.setupDriver(context);
    }

    static boolean isParameterizedTest(ExtensionContext context) {
        return context.getTestMethod().filter(m -> m.isAnnotationPresent(ParameterizedBrowserTest.class)).isPresent();
    }

    private void setupDriver(ExtensionContext context) throws Exception {
        this.setDriver(this.createDriver(context, this.driverConfiguration));
    }

    private WebDriver createDriver(ExtensionContext context, SetupDriver driverConfig) throws Exception {
        DriverSupplier supplier;
        WebDriver webDriver;
        Object testInstance = context.getRequiredTestInstance();
        if (testInstance instanceof DriverSupplier && (webDriver = (supplier = (DriverSupplier)testInstance).createDriver()) != null) {
            return webDriver;
        }
        Class testClass = context.getRequiredTestClass();
        if (this.getRunLocallyBrowser(testClass) != null) {
            webDriver = driverConfig.setupLocalDriver(this.getRunLocallyBrowser(testClass), this.getRunLocallyBrowserVersion(testClass));
        } else if (Parameters.isLocalWebDriverUsed()) {
            webDriver = driverConfig.setupLocalDriver();
        } else if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            webDriver = driverConfig.setupRemoteDriver(this.getHubURL(testClass));
        } else if (this.getRunOnHub(testClass) != null || Parameters.getHubHostname() != null) {
            webDriver = driverConfig.setupRemoteDriver(this.getHubURL(testClass));
        } else {
            BrowserExtension.getLogger().info("Did not find a configuration to run locally, on Sauce Labs or on other test grid. Falling back to running locally on Chrome.");
            webDriver = driverConfig.setupLocalDriver(Browser.CHROME);
        }
        return webDriver;
    }

    protected RunOnHub getRunOnHub(Class<?> testClass) {
        if (testClass == null) {
            return null;
        }
        return testClass.getAnnotation(RunOnHub.class);
    }

    protected Browser getRunLocallyBrowser(Class<?> testClass) {
        return CapabilitiesUtil.getRunLocallyBrowserName(testClass);
    }

    protected String getRunLocallyBrowserVersion(Class<?> testClass) {
        return CapabilitiesUtil.getRunLocallyBrowserVersion(testClass);
    }

    public DesiredCapabilities getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == BrowserTestInfo.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (BrowserExtension.isParameterizedTest(extensionContext)) {
            return this.getStore(extensionContext).getOrComputeIfAbsent(BrowserTestInfo.class, k -> this.createTestInfoForParameterizedTest(extensionContext));
        }
        Class testClass = extensionContext.getRequiredTestClass();
        return new BrowserTestInfo(this.driver, (Capabilities)new ImmutableCapabilities((Capabilities)this.desiredCapabilities), this.getHubHostname(testClass), this.getRunLocallyBrowser(testClass), this.getRunLocallyBrowserVersion(testClass));
    }

    private BrowserTestInfo createTestInfoForParameterizedTest(ExtensionContext context) {
        WebDriver webDriver;
        DesiredCapabilities capabilities = CapabilitiesUtil.getDesiredCapabilities(context).stream().findFirst().orElseThrow(() -> new ParameterResolutionException("Cannot get capabilities"));
        if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            SauceLabsIntegration.setDesiredCapabilities((DesiredCapabilities)capabilities);
        }
        SauceLabsIntegration.setSauceLabsOption((DesiredCapabilities)capabilities, (String)"name", (Object)context.getDisplayName());
        try {
            SetupDriver driverConfig = new SetupDriver();
            driverConfig.setDesiredCapabilities(capabilities);
            webDriver = this.createDriver(context, driverConfig);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Cannot create WebDriver", (Throwable)e);
        }
        Class testClass = context.getRequiredTestClass();
        return new BrowserTestInfo(webDriver, (Capabilities)new ImmutableCapabilities((Capabilities)capabilities), this.getHubHostname(testClass), this.getRunLocallyBrowser(testClass), this.getRunLocallyBrowserVersion(testClass));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{BrowserExtension.class, context.getUniqueId()}));
    }

    static {
        TestBench.ensureLoaded();
    }
}

