/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.radiobutton.RadioButton;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioButtonTester;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Tests(fqn={"com.vaadin.flow.component.radiobutton.RadioButtonGroup"})
public class RadioButtonGroupTester<T extends RadioButtonGroup<V>, V>
extends ComponentTester<T> {
    public RadioButtonGroupTester(T component) {
        super(component);
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((RadioButtonGroup)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((RadioButtonGroup)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }

    public void selectItem(String selection) {
        this.ensureComponentIsUsable();
        this.updateSelection(selection);
    }

    public void deselectItem() {
        this.ensureComponentIsUsable();
        ((RadioButtonGroup)this.getComponent()).setValue(((RadioButtonGroup)this.getComponent()).getEmptyValue());
    }

    public V getSelected() {
        return (V)((RadioButtonGroup)this.getComponent()).getValue();
    }

    @NotNull
    private Stream<RadioButton> getRadioButtons(Predicate<RadioButton> filter) {
        return ((RadioButtonGroup)this.getComponent()).getChildren().filter(RadioButton.class::isInstance).map(RadioButton.class::cast).filter(filter);
    }

    private V getRadioButtonValue(RadioButton<T> radioButton) {
        RadioButton<T> cast = radioButton;
        return (V)cast.getItem();
    }

    private boolean isUsableRadioButton(RadioButton<T> radioButton, boolean throwIfNotUsable) {
        boolean usable = new RadioButtonTester(radioButton).isUsable();
        if (!usable && throwIfNotUsable) {
            throw new IllegalStateException("Item " + radioButton.getElement().getProperty("value") + " is not usable");
        }
        return usable;
    }

    private void updateSelection(String selection) {
        ItemLabelGenerator itemLabelGenerator = ((RadioButtonGroup)this.getComponent()).getItemLabelGenerator();
        Map<String, Object> selectedItems = this.getRadioButtons(child -> selection.equals(itemLabelGenerator.apply(this.getRadioButtonValue((RadioButton<T>)child)))).filter(child -> this.isUsableRadioButton((RadioButton<T>)child, true)).collect(Collectors.toMap(button -> itemLabelGenerator.apply(this.getRadioButtonValue((RadioButton<T>)button)), this::getRadioButtonValue));
        if (selectedItems.isEmpty()) {
            throw new IllegalArgumentException("Invalid Item string representation: " + selection);
        }
        ((RadioButtonGroup)this.getComponent()).setValue(selectedItems.get(selection));
    }
}

