/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.textfield.GeneratedVaadinTextArea;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.RequiredValidationUtil;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;

public class TextArea
extends GeneratedVaadinTextArea<TextArea, String>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;

    public TextArea() {
        super("", "", false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
    }

    public TextArea(String label) {
        this();
        this.setLabel(label);
    }

    public TextArea(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextArea(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextArea(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public void setMaxLength(int maxLength) {
        super.setMaxlength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getMaxlengthDouble();
    }

    public void setMinLength(int minLength) {
        super.setMinlength(minLength);
    }

    public int getMinLength() {
        return (int)this.getMinlengthDouble();
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    public String getEmptyValue() {
        return "";
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        if (!this.isConnectorAttached) {
            UI.getCurrent().getPage().addJavaScript("frontend://textConnector.js");
            this.isConnectorAttached = true;
        }
        RequiredValidationUtil.updateClientValidation(requiredIndicatorVisible, (Component)this);
    }
}

