/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;

final class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static void disableClientValidation(Component component) {
        if (!component.getElement().getNode().isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation can only be disabled for a component when it has been attached to the UI and because it should be called again once the component is removed/added, you should call this method from the onAttach() method of the component.", component.toString()));
        }
        StateNode componentNode = component.getElement().getNode();
        componentNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(componentNode, (SerializableConsumer & Serializable)executionContext -> FieldValidationUtil.overrideClientValidation(component)));
    }

    private static void overrideClientValidation(Component component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return this.checkValidity();};");
        if (component instanceof HasValidation && ((HasValidation)component).isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Serializable[0]);
    }
}

