/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinNumberField;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

public abstract class AbstractNumberField<C extends AbstractNumberField<C, T>, T extends Number>
extends GeneratedVaadinNumberField<C, T>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect,
HasHelper {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private boolean required;
    private double min;
    private double max;
    private double step;
    private boolean stepSetByUser;
    private boolean minSetByUser;

    public AbstractNumberField(SerializableFunction<String, T> parser, SerializableFunction<T, String> formatter, double absoluteMin, double absoluteMax) {
        super(null, null, String.class, parser, formatter);
        this.setInvalid(false);
        this.min = absoluteMin;
        this.max = absoluteMax;
        this.step = 1.0;
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    @Override
    public void setHasControls(boolean hasControls) {
        super.setHasControls(hasControls);
    }

    public boolean hasControls() {
        return super.hasControlsBoolean();
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public String getTitle() {
        return super.getTitleString();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    public boolean isClearButtonVisible() {
        return this.isClearButtonVisibleBoolean();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public T getEmptyValue() {
        return null;
    }

    public void setValue(T value) {
        super.setValue(value);
    }

    public T getValue() {
        return (T)((Number)super.getValue());
    }

    @Override
    protected void setMin(double min) {
        super.setMin(min);
        this.min = min;
        this.minSetByUser = true;
    }

    @Override
    protected double getMinDouble() {
        return this.min;
    }

    @Override
    protected void setMax(double max) {
        super.setMax(max);
        this.max = max;
    }

    @Override
    protected double getMaxDouble() {
        return this.max;
    }

    @Override
    protected void setStep(double step) {
        super.setStep(step);
        this.step = step;
        this.stepSetByUser = true;
    }

    @Override
    protected double getStepDouble() {
        return this.step;
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    protected void validate() {
        Object value = this.getValue();
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && ((Number)value).doubleValue() > this.max;
        boolean isSmallerThanMin = value != null && ((Number)value).doubleValue() < this.min;
        this.setInvalid(isRequiredButEmpty || isGreaterThanMax || isSmallerThanMin || !this.isValidByStep(value));
    }

    private boolean isValidByStep(T value) {
        if (!this.stepSetByUser || value == null || this.step == 0.0) {
            return true;
        }
        double stepBasis = this.minSetByUser ? this.getMinDouble() : 0.0;
        return new BigDecimal(String.valueOf(value)).subtract(BigDecimal.valueOf(stepBasis)).remainder(BigDecimal.valueOf(this.step)).compareTo(BigDecimal.ZERO) == 0;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        FieldValidationUtil.disableClientValidation((Component)this);
    }
}

