/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinTextField;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableBiFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Tag(value="vaadin-big-decimal-field")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="22.0.12")
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./vaadin-big-decimal-field.js")})
public class BigDecimalField
extends GeneratedVaadinTextField<BigDecimalField, BigDecimal>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect,
HasHelper {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private boolean required;
    private Locale locale;
    private static final SerializableBiFunction<BigDecimalField, String, BigDecimal> PARSER = (SerializableBiFunction & Serializable)(field, valueFromClient) -> {
        if (valueFromClient == null || valueFromClient.isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(valueFromClient.replace(field.getDecimalSeparator(), '.'));
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableBiFunction<BigDecimalField, BigDecimal, String> FORMATTER = (SerializableBiFunction & Serializable)(field, valueFromModel) -> valueFromModel == null ? "" : valueFromModel.toPlainString().replace('.', field.getDecimalSeparator());

    public BigDecimalField() {
        super(null, null, String.class, PARSER, FORMATTER, true);
        this.setLocale(Optional.ofNullable(UI.getCurrent()).map(UI::getLocale).orElse(Locale.ROOT));
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public BigDecimalField(String label) {
        this();
        this.setLabel(label);
    }

    public BigDecimalField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(String label, BigDecimal initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, BigDecimal initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    public boolean isClearButtonVisible() {
        return this.isClearButtonVisibleBoolean();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public String getTitle() {
        return super.getTitleString();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public BigDecimal getEmptyValue() {
        return null;
    }

    public void setValue(BigDecimal value) {
        super.setValue((Object)value);
    }

    public BigDecimal getValue() {
        return (BigDecimal)super.getValue();
    }

    @Override
    protected void validate() {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), this.getValue());
        this.setInvalid(isRequiredButEmpty);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale to set can't be null.");
        this.locale = locale;
        this.setDecimalSeparator(new DecimalFormatSymbols(locale).getDecimalSeparator());
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setDecimalSeparator(char decimalSeparator) {
        this.getElement().setProperty("_decimalSeparator", decimalSeparator + "");
    }

    private char getDecimalSeparator() {
        String prop = this.getElement().getProperty("_decimalSeparator");
        return prop == null || prop.isEmpty() ? (char)'.' : this.getElement().getProperty("_decimalSeparator").charAt(0);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        FieldValidationUtil.disableClientValidation((Component)this);
    }
}

