/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Tag(value="vaadin-big-decimal-field")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.11")
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./vaadin-big-decimal-field.js")})
@Uses(value=TextField.class)
public class BigDecimalField
extends TextFieldBase<BigDecimalField, BigDecimal>
implements HasThemeVariant<TextFieldVariant> {
    private boolean isConnectorAttached;
    private Locale locale;
    private static final SerializableBiFunction<BigDecimalField, String, BigDecimal> PARSER = (SerializableBiFunction & Serializable)(field, valueFromClient) -> {
        if (valueFromClient == null || valueFromClient.isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(valueFromClient.replace(field.getDecimalSeparator(), '.'));
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableBiFunction<BigDecimalField, BigDecimal, String> FORMATTER = (SerializableBiFunction & Serializable)(field, valueFromModel) -> valueFromModel == null ? "" : valueFromModel.toPlainString().replace('.', field.getDecimalSeparator());

    public BigDecimalField() {
        super(null, null, String.class, PARSER, FORMATTER, true);
        this.setLocale(Optional.ofNullable(UI.getCurrent()).map(UI::getLocale).orElse(Locale.ROOT));
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
    }

    public BigDecimalField(String label) {
        this();
        this.setLabel(label);
    }

    public BigDecimalField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(String label, BigDecimal initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, BigDecimal initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public BigDecimal getEmptyValue() {
        return null;
    }

    public void setValue(BigDecimal value) {
        BigDecimal oldValue = this.getValue();
        super.setValue((Object)value);
        if (Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent()) {
            this.getElement().executeJs("this._inputElementValue = ''", new Serializable[0]);
            this.getElement().setProperty("_hasInputValue", false);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        } else {
            this.getElement().executeJs("this._inputElementValue = this.value", new Serializable[0]);
        }
    }

    public BigDecimal getValue() {
        return (BigDecimal)super.getValue();
    }

    protected void validate() {
        BigDecimal value = this.getValue();
        boolean isRequired = this.isRequiredIndicatorVisible();
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)isRequired, (Object)value, (Object)this.getEmptyValue());
        this.setInvalid(requiredValidation.isError() || this.checkValidity(value).isError());
    }

    private ValidationResult checkValidity(BigDecimal value) {
        boolean hasNonParsableValue;
        boolean bl = hasNonParsableValue = Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent();
        if (hasNonParsableValue) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public Validator<BigDecimal> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.checkValidity((BigDecimal)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<BigDecimal> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    private boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale to set can't be null.");
        this.locale = locale;
        this.setDecimalSeparator(new DecimalFormatSymbols(locale).getDecimalSeparator());
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setDecimalSeparator(char decimalSeparator) {
        this.getElement().setProperty("_decimalSeparator", "" + decimalSeparator);
    }

    private char getDecimalSeparator() {
        String prop = this.getElement().getProperty("_decimalSeparator");
        return prop == null || prop.isEmpty() ? (char)'.' : this.getElement().getProperty("_decimalSeparator").charAt(0);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }
}

