/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.component.textfield.AbstractNumberFieldI18n;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

@Tag(value="vaadin-integer-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.5.0"), @NpmPackage(value="@vaadin/integer-field", version="24.5.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/integer-field/src/vaadin-integer-field.js")})
public class IntegerField
extends AbstractNumberField<IntegerField, Integer>
implements HasThemeVariant<TextFieldVariant> {
    private static final SerializableFunction<String, Integer> PARSER = (SerializableFunction & Serializable)valueFormClient -> {
        if (valueFormClient == null || valueFormClient.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(valueFormClient);
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableFunction<Integer, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();

    public IntegerField() {
        super(PARSER, FORMATTER, -2.147483648E9, 2.147483647E9);
    }

    public IntegerField(String label) {
        this();
        this.setLabel(label);
    }

    public IntegerField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public IntegerField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<IntegerField, Integer>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public IntegerField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<IntegerField, Integer>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public IntegerField(String label, Integer initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<IntegerField, Integer>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMin(int min) {
        super.setMin(min);
    }

    public int getMin() {
        return (int)this.getMinDouble();
    }

    public void setMax(int max) {
        super.setMax(max);
    }

    public int getMax() {
        return (int)this.getMaxDouble();
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep(step);
    }

    public int getStep() {
        return (int)this.getStepDouble();
    }

    @Override
    public IntegerFieldI18n getI18n() {
        return (IntegerFieldI18n)super.getI18n();
    }

    public void setI18n(IntegerFieldI18n i18n) {
        super.setI18n(i18n);
    }

    public static class IntegerFieldI18n
    implements AbstractNumberFieldI18n {
        private String requiredErrorMessage;
        private String badInputErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;
        private String stepErrorMessage;

        @Override
        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public IntegerFieldI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public IntegerFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public IntegerFieldI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public IntegerFieldI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getStepErrorMessage() {
            return this.stepErrorMessage;
        }

        public IntegerFieldI18n setStepErrorMessage(String errorMessage) {
            this.stepErrorMessage = errorMessage;
            return this;
        }
    }
}

