/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.google.common.collect.Lists;
import com.wix.mysql.MysqlClient;
import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.MysqldStarter;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.config.RuntimeConfigBuilder;
import com.wix.mysql.config.SchemaConfig;
import com.wix.mysql.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class EmbeddedMysql {
    protected final MysqldConfig config;
    protected final MysqldExecutable executable;
    private AtomicBoolean isRunning = new AtomicBoolean(true);

    protected EmbeddedMysql(MysqldConfig config) {
        this.config = config;
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults().build();
        this.executable = (MysqldExecutable)new MysqldStarter(runtimeConfig).prepare((IExecutableProcessConfig)config);
        try {
            this.executable.start();
            this.getClient("information_schema").executeCommands(String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s';", config.getUsername(), config.getPassword()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MysqldConfig getConfig() {
        return this.config;
    }

    public void reloadSchema(String schemaName, File ... scripts) {
        this.reloadSchema(SchemaConfig.aSchemaConfig(schemaName).withScripts(scripts).build());
    }

    public void reloadSchema(String schemaName, List<File> scripts) {
        this.reloadSchema(SchemaConfig.aSchemaConfig(schemaName).withScripts(scripts).build());
    }

    public void reloadSchema(SchemaConfig config) {
        this.getClient("information_schema").executeCommands(String.format("DROP DATABASE %s", config.getName()));
        this.addSchema(config);
    }

    private EmbeddedMysql addSchema(SchemaConfig schema) {
        this.getClient("information_schema").executeCommands(String.format("CREATE DATABASE %s CHARACTER SET = %s COLLATE = %s;", schema.getName(), schema.getCharset().getCharset(), schema.getCharset().getCollate()), String.format("GRANT ALL ON %s.* TO '%s'@'%%';", schema.getName(), this.config.getUsername()));
        this.getClient(schema.getName()).executeScripts(schema.getScripts());
        return this;
    }

    public synchronized void stop() {
        if (this.isRunning.getAndSet(false)) {
            this.executable.stop();
        }
    }

    private MysqlClient getClient(String schemaName) {
        return new MysqlClient(this.config, this.executable, schemaName);
    }

    public static Builder anEmbeddedMysql(Version version) {
        return new Builder(MysqldConfig.aMysqldConfig(version).build());
    }

    public static Builder anEmbeddedMysql(MysqldConfig config) {
        return new Builder(config);
    }

    public static class Builder {
        private final MysqldConfig config;
        private List<SchemaConfig> schemas = Lists.newArrayList();

        public Builder(MysqldConfig config) {
            this.config = config;
        }

        public Builder addSchema(String name, File ... scripts) {
            this.schemas.add(SchemaConfig.aSchemaConfig(name).withScripts(scripts).build());
            return this;
        }

        public Builder addSchema(String name, List<File> scripts) {
            this.schemas.add(SchemaConfig.aSchemaConfig(name).withScripts(scripts).build());
            return this;
        }

        public Builder addSchema(SchemaConfig config) {
            this.schemas.add(config);
            return this;
        }

        public EmbeddedMysql start() {
            EmbeddedMysql instance = new EmbeddedMysql(this.config);
            for (SchemaConfig schema : this.schemas) {
                instance.addSchema(schema);
            }
            return instance;
        }
    }
}

