/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.google.common.base.Strings;
import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.exceptions.CommandFailedException;
import de.flapdoodle.embed.process.distribution.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.IOUtils;

class MysqlClient {
    private final MysqldConfig config;
    private final MysqldExecutable executable;
    private final String schemaName;

    public MysqlClient(MysqldConfig config, MysqldExecutable executable, String schemaName) {
        this.config = config;
        this.executable = executable;
        this.schemaName = schemaName;
    }

    public void executeScripts(List<File> files) {
        for (File file : files) {
            this.execute(String.format("source %s", file.getAbsolutePath()));
        }
    }

    public void executeCommands(String ... sqls) {
        for (String sql : sqls) {
            this.execute(sql);
        }
    }

    private void execute(String sql) {
        String command = Platform.detect() == Platform.Windows ? String.format("\"%s\"", sql) : sql;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{Paths.get(this.executable.getBaseDir().getAbsolutePath(), "bin", "mysql").toString(), "--protocol=tcp", String.format("--user=%s", "root"), String.format("--port=%s", this.config.getPort()), "-e", command, this.schemaName});
            if (p.waitFor() != 0) {
                String out = IOUtils.toString((InputStream)p.getInputStream());
                String err = IOUtils.toString((InputStream)p.getErrorStream());
                if (Strings.isNullOrEmpty((String)out)) {
                    throw new CommandFailedException(command, this.schemaName, p.waitFor(), err);
                }
                throw new CommandFailedException(command, this.schemaName, p.waitFor(), out);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CommandFailedException(command, this.schemaName, e.getMessage(), e);
        }
    }
}

