/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqldProcess;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.exceptions.MissingDependencyException;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.runtime.Executable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

class MysqldExecutable
extends Executable<MysqldConfig, MysqldProcess> {
    private final IExtractedFileSet executable;

    public MysqldExecutable(Distribution distribution, MysqldConfig config, IRuntimeConfig runtimeConfig, IExtractedFileSet executable) {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, executable);
        this.executable = executable;
    }

    protected MysqldProcess start(Distribution distribution, MysqldConfig config, IRuntimeConfig runtime) throws IOException {
        this.markAllLibraryFilesExecutable();
        if (Platform.detect().isUnixLike()) {
            this.initDatabase();
        }
        return new MysqldProcess(distribution, config, runtime, this);
    }

    private void markAllLibraryFilesExecutable() {
        for (File f : this.executable.files(FileType.Library)) {
            f.setExecutable(true);
        }
    }

    private void initDatabase() throws IOException {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"scripts/mysql_install_db", "--no-defaults", String.format("--basedir=%s", this.getBaseDir()), String.format("--datadir=%s/data", this.getBaseDir())}, null, this.getBaseDir());
            int retCode = p.waitFor();
            if (retCode != 0) {
                this.resolveException(retCode, IOUtils.toString((InputStream)p.getInputStream()) + IOUtils.toString((InputStream)p.getErrorStream()));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void resolveException(int retCode, String output) {
        if (output.contains("error while loading shared libraries: libaio.so")) {
            throw new MissingDependencyException("System library 'libaio.so.1' missing. Please install it via system package manager, ex. 'sudo apt-get install libaio1'.\nFor details see: http://bugs.mysql.com/bug.php?id=60544");
        }
        throw new RuntimeException(String.format("'scripts/mysql_install_db' command exited with error code: '%s' and output: '%s'", retCode, output));
    }

    protected File getBaseDir() {
        return this.executable.generatedBaseDir();
    }
}

