/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.input.LogFileProcessor;
import com.wix.mysql.input.OutputWatchStreamProcessor;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.collections.Collections;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MysqldProcess
extends AbstractProcess<MysqldConfig, MysqldExecutable, MysqldProcess> {
    private static final Logger logger = LoggerFactory.getLogger(MysqldProcess.class);
    private OutputWatchStreamProcessor logWatch = null;
    private LogFileProcessor logFile = null;

    public MysqldProcess(Distribution distribution, MysqldConfig config, IRuntimeConfig runtimeConfig, MysqldExecutable executable) throws IOException {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, (Executable)executable);
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, MysqldConfig config, IRuntimeConfig runtimeConfig) {
        super.onBeforeProcessStart(processBuilder, (IExecutableProcessConfig)config, runtimeConfig);
        this.logWatch = new OutputWatchStreamProcessor(Sets.newHashSet((Object[])new String[]{"ready for connections"}), Sets.newHashSet((Object[])new String[]{"[ERROR]"}), StreamToLineProcessor.wrap((IStreamProcessor)runtimeConfig.getProcessOutput().getOutput()));
        this.logFile = new LogFileProcessor(new File(this.getExecutable().getBaseDir() + "/data/error.log"), this.logWatch);
    }

    public void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        try {
            this.logWatch.waitForResult(((MysqldConfig)this.getConfig()).getTimeout());
            if (!this.logWatch.isInitWithSuccess()) {
                throw new RuntimeException("mysql start failed with error: " + this.logWatch.getFailureFound());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (this.logFile != null) {
                this.logFile.shutdown();
            }
        }
    }

    protected List<String> getCommandLine(Distribution distribution, MysqldConfig config, IExtractedFileSet exe) throws IOException {
        String baseDir = exe.generatedBaseDir().getAbsolutePath();
        return Collections.newArrayList((Object[])new String[]{exe.executable().getAbsolutePath(), "--no-defaults", "--skip-name-resolve", "--log-output=NONE", "--skip-name-resolve", String.format("--basedir=%s", baseDir), String.format("--datadir=%s/data", baseDir), String.format("--plugin-dir=%s/lib/plugin", baseDir), String.format("--socket=%s", this.sockFile(exe)), String.format("--lc-messages-dir=%s/share", baseDir), String.format("--port=%s", config.getPort()), String.format("--log-error=%s/data/error.log", baseDir), String.format("--character-set-server=%s", config.getCharset().getCharset()), String.format("--collation-server=%s", config.getCharset().getCollate())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        MysqldProcess mysqldProcess = this;
        synchronized (mysqldProcess) {
            logger.info("try to stop mysqld");
            if (!this.stopUsingMysqldadmin()) {
                logger.warn("could not stop mysqld via mysqladmin, try next");
                if (!this.sendKillToProcess()) {
                    logger.warn("could not stop mysqld, try next");
                    if (!this.sendTermToProcess()) {
                        logger.warn("could not stop mysqld, try next");
                        if (!this.tryKillToProcess()) {
                            logger.warn("could not stop mysqld the second time, try one last thing");
                            try {
                                this.stopProcess();
                            }
                            catch (IllegalStateException e) {
                                logger.error("error while trying to stop mysql process", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void cleanupInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopUsingMysqldadmin() {
        LogFileProcessor processor;
        InputStreamReader stdErr;
        InputStreamReader stdOut;
        boolean retValue;
        block10: {
            retValue = false;
            stdOut = null;
            stdErr = null;
            processor = null;
            HashSet successPatterns = Sets.newHashSet((Object[])new String[]{"'Can't connect to MySQL server on 'localhost'", Platform.detect() == Platform.Windows ? "mysqld.exe: Shutdown complete" : "mysqld: Shutdown complete"});
            try {
                String cmd = Paths.get(this.getExecutable().getFile().generatedBaseDir().getAbsolutePath(), "bin", "mysqladmin").toString();
                Process p = Runtime.getRuntime().exec(new String[]{cmd, "--no-defaults", "--protocol=tcp", String.format("-u%s", "root"), String.format("--port=%s", ((MysqldConfig)this.getConfig()).getPort()), "shutdown"});
                retValue = p.waitFor() == 0;
                OutputWatchStreamProcessor outputWatch = new OutputWatchStreamProcessor(successPatterns, Sets.newHashSet((Object[])new String[]{"[ERROR]"}), StreamToLineProcessor.wrap((IStreamProcessor)this.getRuntimeConfig().getProcessOutput().getOutput()));
                processor = new LogFileProcessor(new File(this.getExecutable().getBaseDir() + "/data/error.log"), outputWatch);
                stdOut = new InputStreamReader(p.getInputStream());
                stdErr = new InputStreamReader(p.getErrorStream());
                if (retValue) {
                    outputWatch.waitForResult(((MysqldConfig)this.getConfig()).getTimeout());
                    if (!outputWatch.isInitWithSuccess()) {
                        logger.error("mysql shutdown failed. Expected to find in output: 'Shutdown complete', got: " + outputWatch.getFailureFound());
                        retValue = false;
                    }
                    break block10;
                }
                String errOutput = CharStreams.toString((Readable)stdErr);
                if (errOutput.contains("Can't connect to MySQL server on")) {
                    logger.warn("mysql was already shutdown - no need to add extra shutdown hook - process does it out of the box.");
                    retValue = true;
                    break block10;
                }
                logger.error("mysql shutdown failed with error code: " + p.waitFor() + " and message: " + CharStreams.toString((Readable)stdErr));
            }
            catch (IOException | InterruptedException e) {
                try {
                    logger.warn("Encountered error why shutting down process.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeCloseables(stdOut, stdErr);
                    if (processor != null) {
                        processor.shutdown();
                    }
                    throw throwable;
                }
                Utils.closeCloseables(stdOut, stdErr);
                if (processor != null) {
                    processor.shutdown();
                }
            }
        }
        Utils.closeCloseables(stdOut, stdErr);
        if (processor != null) {
            processor.shutdown();
        }
        return retValue;
    }

    private MysqldExecutable getExecutable() {
        try {
            Field f = AbstractProcess.class.getDeclaredField("executable");
            f.setAccessible(true);
            return (MysqldExecutable)((Object)f.get((Object)this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IRuntimeConfig getRuntimeConfig() {
        try {
            Field f = AbstractProcess.class.getDeclaredField("runtimeConfig");
            f.setAccessible(true);
            return (IRuntimeConfig)f.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String sockFile(IExtractedFileSet exe) throws IOException {
        String sysTempDir = System.getProperty("java.io.tmpdir");
        String sockFile = String.format("%s.sock", exe.generatedBaseDir().getName());
        return new File(sysTempDir, sockFile).getAbsolutePath();
    }
}

