/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.config;

import com.google.common.collect.Lists;
import com.wix.mysql.config.Charset;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class SchemaConfig {
    private final String name;
    private final Charset charset;
    private final List<File> scripts;

    private SchemaConfig(String name, Charset charset, List<File> scripts) {
        this.name = name;
        this.charset = charset;
        this.scripts = scripts;
    }

    public static Builder aSchemaConfig(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public List<File> getScripts() {
        return this.scripts;
    }

    public static class Builder {
        private final String name;
        private Charset charset = Charset.defaults();
        private List<File> scripts = Lists.newArrayList();

        public Builder(String name) {
            this.name = name;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withScripts(File ... scripts) {
            return this.withScripts(Arrays.asList(scripts));
        }

        public Builder withScripts(List<File> scripts) {
            this.scripts = scripts;
            return this;
        }

        public SchemaConfig build() {
            return new SchemaConfig(this.name, this.charset, this.scripts);
        }
    }
}

