/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.distribution;

import com.google.common.base.Joiner;
import com.wix.mysql.exceptions.UnsupportedPlatformException;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;
import java.util.Arrays;
import java.util.List;

public enum Version implements IVersion
{
    v5_5_40("5.5", "40", Platform.Linux, Platform.OS_X),
    v5_6_21("5.6", "21"),
    v5_6_22("5.6", "22"),
    v5_6_23("5.6", "23"),
    v5_6_24("5.6", "24"),
    v5_6_latest(v5_6_24);

    private final String majorVersion;
    private final String minorVersion;
    private final List<Platform> supportedPlatforms;

    private Version(String majorVersion, String minorVersion, Platform ... supportedPlatforms) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.supportedPlatforms = Arrays.asList(supportedPlatforms);
    }

    private Version(String majorVersion, String minorVersion) {
        this(majorVersion, minorVersion, Platform.Linux, Platform.Windows, Platform.OS_X);
    }

    private Version(Version other) {
        this.majorVersion = other.majorVersion;
        this.minorVersion = other.minorVersion;
        this.supportedPlatforms = other.supportedPlatforms;
    }

    public boolean supportsCurrentPlatform() {
        return this.supportedPlatforms.contains(this.currentPlatform());
    }

    public String asInDownloadPath() {
        this.assertPlatformIsSupported();
        switch (this.currentPlatform()) {
            case Windows: {
                return String.format("%s/mysql-%s.%s", this.path(), this.majorVersion, this.minorVersion);
            }
            case OS_X: {
                return String.format("%s/mysql-%s.%s-osx%s", this.path(), this.majorVersion, this.minorVersion, this.osVersion());
            }
            case Linux: {
                return String.format("%s/mysql-%s.%s-%s", this.path(), this.majorVersion, this.minorVersion, this.gcLibVersion());
            }
        }
        throw new UnsupportedPlatformException("Unrecognized platform, currently not supported");
    }

    public String toString() {
        return String.format("Version %s.%s", this.majorVersion, this.minorVersion);
    }

    private String osVersion() {
        if (this.majorVersion.equals("5.6")) {
            return "10.9";
        }
        if (this.majorVersion.equals("5.5")) {
            return "10.6";
        }
        throw new UnsupportedOperationException();
    }

    private String gcLibVersion() {
        if (this.majorVersion.equals("5.6")) {
            return "linux-glibc2.5";
        }
        if (this.majorVersion.equals("5.5")) {
            return "linux2.6";
        }
        throw new UnsupportedOperationException();
    }

    private Platform currentPlatform() {
        return Platform.detect();
    }

    private String path() {
        return String.format("MySQL-%s", this.majorVersion);
    }

    private void assertPlatformIsSupported() {
        if (!this.supportsCurrentPlatform()) {
            throw new UnsupportedPlatformException(String.format("Platform %s is not in a supported platform list: %s", this.currentPlatform().name(), Joiner.on((String)",").join(this.supportedPlatforms)));
        }
    }
}

