/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.input;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileProcessor
extends Thread {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private volatile boolean running = true;
    private static final long delaySec = 3000L;
    private final BlockingQueue<String> lines = new LinkedBlockingDeque<String>();
    private final Tailer tailer;
    private final IStreamProcessor processor;

    public LogFileProcessor(File logFile, IStreamProcessor processor) {
        this.tailer = Tailer.create((File)logFile, (TailerListener)new LogTailerListener(this.lines), (long)3000L);
        this.processor = processor;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            String res;
            while ((res = this.lines.poll(10L, TimeUnit.SECONDS)) != null && this.running) {
                this.log.info(res);
                this.processor.process(res);
            }
        }
        catch (InterruptedException iox) {
            this.log.warn(iox.getMessage());
        }
        finally {
            this.processor.onProcessed();
            this.tailer.stop();
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public static class LogTailerListener
    extends TailerListenerAdapter {
        private final BlockingQueue<String> lines;

        public LogTailerListener(BlockingQueue<String> queue) {
            this.lines = queue;
        }

        public void handle(String line) {
            this.lines.offer(line);
        }
    }
}

