/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.input;

import com.google.common.collect.Sets;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import java.util.Set;

public class OutputWatchStreamProcessor
implements IStreamProcessor {
    private final StringBuilder output = new StringBuilder();
    private final Set<String> successes;
    private final Set<String> failures;
    private boolean initWithSuccess = false;
    private String failureFound = null;
    private final IStreamProcessor destination;

    public OutputWatchStreamProcessor(Set<String> successes, Set<String> failures, IStreamProcessor destination) {
        this.successes = successes;
        this.failures = Sets.newHashSet(failures);
        this.destination = destination;
    }

    public boolean isSuccess(String output) {
        for (String success : this.successes) {
            if (!output.contains(success)) continue;
            return true;
        }
        return false;
    }

    public void process(String block) {
        this.destination.process(block);
        this.output.append(block);
        if (this.isSuccess(block)) {
            this.gotResult(true, null);
        } else {
            for (String failure : this.failures) {
                int failureIndex = this.output.indexOf(failure);
                if (failureIndex == -1) continue;
                this.gotResult(false, this.output.substring(failureIndex));
            }
        }
    }

    public void onProcessed() {
        this.gotResult(false, "<EOF>");
    }

    private synchronized void gotResult(boolean success, String message) {
        this.initWithSuccess = success;
        this.failureFound = message;
        this.notify();
    }

    public synchronized void waitForResult(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitWithSuccess() {
        return this.initWithSuccess;
    }

    public String getFailureFound() {
        return this.failureFound;
    }
}

