/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqldProcess;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.distribution.Setup;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.runtime.Executable;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MysqldExecutable
extends Executable<MysqldConfig, MysqldProcess> {
    private static final Logger logger = LoggerFactory.getLogger(MysqldExecutable.class);
    private final IExtractedFileSet executable;

    MysqldExecutable(Distribution distribution, MysqldConfig config, IRuntimeConfig runtimeConfig, IExtractedFileSet executable) {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, executable);
        this.executable = executable;
    }

    protected MysqldProcess start(Distribution distribution, MysqldConfig config, IRuntimeConfig runtime) throws IOException {
        logger.info("Preparing mysqld for startup");
        Setup.apply(config.getVersion(), this.executable, runtime);
        logger.info("Starting MysqldProcess");
        return new MysqldProcess(distribution, config, runtime, this);
    }

    File getBaseDir() {
        return this.executable.baseDir();
    }
}

