/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.Sources;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.utils.Utils;
import java.io.File;
import java.io.FileFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ScriptResolver {
    public static SqlScriptSource classPathFile(String path) {
        String normalizedPath = path.startsWith("/") ? path : String.format("/%s", path);
        URL resource = ScriptResolver.class.getResource(normalizedPath);
        if (resource == null) {
            throw new ScriptResolutionException(normalizedPath);
        }
        return Sources.fromURL(resource);
    }

    public static List<SqlScriptSource> classPathFiles(String pattern) {
        String[] parts = pattern.split("/");
        String path = Utils.join(Arrays.asList(Arrays.copyOfRange(parts, 0, parts.length - 1)), "/");
        URL baseFolder = ScriptResolver.class.getResource(path.startsWith("/") ? path : String.format("/%s", path));
        WildcardFileFilter filter = new WildcardFileFilter(parts[parts.length - 1]);
        if (baseFolder == null) {
            throw new ScriptResolutionException(path);
        }
        List<File> results = Arrays.asList(ScriptResolver.asFile(baseFolder).listFiles((FileFilter)filter));
        Collections.sort(results);
        return ScriptResolver.fromFiles(results);
    }

    private static File asFile(URL resource) {
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<SqlScriptSource> fromFiles(List<File> files) {
        ArrayList<SqlScriptSource> res = new ArrayList<SqlScriptSource>();
        for (File f : files) {
            res.add(Sources.fromFile(f));
        }
        return res;
    }

    public static class ScriptResolutionException
    extends RuntimeException {
        ScriptResolutionException(String path) {
            super(String.format("No script(s) found for path '%s'", path));
        }
    }
}

