/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.distribution.setup;

import com.wix.mysql.exceptions.MissingDependencyException;
import com.wix.mysql.io.TimingOutProcessExecutor;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

final class ProcessRunner {
    final TimingOutProcessExecutor tope;

    ProcessRunner(String cmd) {
        this.tope = new TimingOutProcessExecutor(cmd);
    }

    void run(Process p, IRuntimeConfig runtimeConfig, long timeoutNanos) throws IOException {
        IStreamProcessor outputWatch = StreamToLineProcessor.wrap((IStreamProcessor)runtimeConfig.getProcessOutput().getOutput());
        try {
            Processors.connect((Reader)new InputStreamReader(p.getInputStream()), (IStreamProcessor)outputWatch);
            Processors.connect((Reader)new InputStreamReader(p.getErrorStream()), (IStreamProcessor)outputWatch);
            int retCode = this.tope.waitFor(p, timeoutNanos);
            if (retCode != 0) {
                ProcessRunner.resolveException(retCode, IOUtils.toString((InputStream)p.getInputStream()) + IOUtils.toString((InputStream)p.getErrorStream()));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void resolveException(int retCode, String output) {
        if (output.contains("error while loading shared libraries: libaio.so")) {
            throw new MissingDependencyException("System library 'libaio.so.1' missing. Please install it via system package manager, ex. 'sudo apt-get install libaio1'.\nFor details see: http://bugs.mysql.com/bug.php?id=60544");
        }
        throw new RuntimeException(String.format("Command exited with error code: '%s' and output: '%s'", retCode, output));
    }
}

