/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqlClient;
import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.MysqldStarter;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.config.AdditionalConfig;
import com.wix.mysql.config.Charset;
import com.wix.mysql.config.DownloadConfig;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.config.RuntimeConfigBuilder;
import com.wix.mysql.config.SchemaConfig;
import com.wix.mysql.distribution.Version;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedMysql {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedMysql.class);
    private static final ReentrantLock localRepository = new ReentrantLock();
    protected final MysqldConfig config;
    protected final MysqldExecutable executable;
    private AtomicBoolean isRunning = new AtomicBoolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedMysql(MysqldConfig mysqldConfig, DownloadConfig downloadConfig) {
        logger.info("Preparing EmbeddedMysql version '{}'...", (Object)mysqldConfig.getVersion());
        this.config = mysqldConfig;
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(mysqldConfig, downloadConfig).build();
        MysqldStarter mysqldStarter = new MysqldStarter(runtimeConfig);
        localRepository.lock();
        try {
            this.executable = (MysqldExecutable)mysqldStarter.prepare((IExecutableProcessConfig)mysqldConfig);
        }
        finally {
            localRepository.unlock();
        }
        try {
            this.executable.start();
            this.getClient("information_schema").executeCommands(String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s';", mysqldConfig.getUsername(), mysqldConfig.getPassword()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MysqldConfig getConfig() {
        return this.config;
    }

    public void reloadSchema(String schemaName, SqlScriptSource ... scripts) {
        this.reloadSchema(SchemaConfig.aSchemaConfig(schemaName).withScripts(scripts).build());
    }

    public void reloadSchema(String schemaName, List<SqlScriptSource> scripts) {
        this.reloadSchema(SchemaConfig.aSchemaConfig(schemaName).withScripts(scripts).build());
    }

    public void reloadSchema(SchemaConfig config) {
        this.dropSchema(config);
        this.addSchema(config);
    }

    public void dropSchema(SchemaConfig config) {
        this.getClient("information_schema").executeCommands(String.format("DROP DATABASE %s", config.getName()));
    }

    public EmbeddedMysql addSchema(SchemaConfig schema) {
        Charset effectiveCharset = Utils.or(schema.getCharset(), this.config.getCharset());
        this.getClient("information_schema").executeCommands(String.format("CREATE DATABASE %s CHARACTER SET = %s COLLATE = %s;", schema.getName(), effectiveCharset.getCharset(), effectiveCharset.getCollate()), String.format("GRANT ALL ON %s.* TO '%s'@'%%';", schema.getName(), this.config.getUsername()));
        MysqlClient client = this.getClient(schema.getName());
        client.executeScripts(schema.getScripts());
        return this;
    }

    public synchronized void stop() {
        if (this.isRunning.getAndSet(false)) {
            this.executable.stop();
        }
    }

    private MysqlClient getClient(String schemaName) {
        return new MysqlClient(this.config, this.executable, schemaName);
    }

    public static Builder anEmbeddedMysql(Version version, AdditionalConfig ... additionalConfigs) {
        MysqldConfig mysqldConfig = MysqldConfig.aMysqldConfig(version).build();
        DownloadConfig downloadConfig = EmbeddedMysql.resolveDownloadConfig(additionalConfigs);
        return new Builder(mysqldConfig, downloadConfig);
    }

    public static Builder anEmbeddedMysql(MysqldConfig mysqldConfig, AdditionalConfig ... additionalConfigs) {
        DownloadConfig downloadConfig = EmbeddedMysql.resolveDownloadConfig(additionalConfigs);
        return new Builder(mysqldConfig, downloadConfig);
    }

    private static DownloadConfig resolveDownloadConfig(AdditionalConfig[] additionalConfig) {
        AdditionalConfig first;
        AdditionalConfig additionalConfig2 = first = additionalConfig.length > 0 ? additionalConfig[0] : null;
        if (first != null && first instanceof DownloadConfig) {
            return (DownloadConfig)first;
        }
        return DownloadConfig.aDownloadConfig().build();
    }

    public static class Builder {
        private final MysqldConfig mysqldConfig;
        private final DownloadConfig downloadConfig;
        private List<SchemaConfig> schemas = new ArrayList<SchemaConfig>();

        public Builder(MysqldConfig mysqldConfig, DownloadConfig downloadConfig) {
            this.mysqldConfig = mysqldConfig;
            this.downloadConfig = downloadConfig;
        }

        public Builder addSchema(String name, SqlScriptSource ... scripts) {
            this.schemas.add(SchemaConfig.aSchemaConfig(name).withScripts(scripts).build());
            return this;
        }

        public Builder addSchema(String name, List<SqlScriptSource> scripts) {
            this.schemas.add(SchemaConfig.aSchemaConfig(name).withScripts(scripts).build());
            return this;
        }

        public Builder addSchema(SchemaConfig config) {
            this.schemas.add(config);
            return this;
        }

        public EmbeddedMysql start() {
            EmbeddedMysql instance = new EmbeddedMysql(this.mysqldConfig, this.downloadConfig);
            for (SchemaConfig schema : this.schemas) {
                instance.addSchema(schema);
            }
            return instance;
        }
    }
}

